---
title: Réflexion et transmission à l'interface entre deux milieux LHI
published: false
routable: false
visible: false
lessons:
    - slug: EM-waves-reflexion-transmission-propagation-3
      name: PARALLÈLE ":" Propagation dans un milieu, Réfléxion et Transmission aux interfaces
      order: 2
---

[en construction] (en cours de formatage)

## Réflexion et transmission à l'interface entre deux milieux LHI

Dans ce chapitre, nous allons démontrer dans un premier temps les relations de passage des champs électriques et magnétiques au travers d'une interface (notée $`\mathcal{P}`$) séparant deux milieux Linéaires Homogènes et Isotropes (LHI) dont les propriétés telles que la permittivité et la perméabilité sont différentes. Dans le milieu $`1`$, il y règne un champ électromagnétique  ($`\vec{E}_1`$, $`\vec{B}_1`$) et potentiellement des vecteurs $`\vec{D}_1`$, $`\vec{H}_1`$. De même dans le milieu $`2`$, on y trouve un champ électromagnétique ($`\vec{E}_2`$, $`\vec{B}_2`$) et potentiellement des vecteurs $`\vec{D}_2`$, $`\vec{H}_2`$. Après l'obtention des relations de continuité, autrement dit les conditions aux limites à l'interface, nous étudierons certains cas typiques de propagation.  


### Relations de continuité

Afin de déterminer le caractère continue ou pas, des vecteurs $`\vec{E}`$, $`\vec{B}`$, $`\vec{D}`$ et $`\vec{H}`$ au passage de l'interface entre deux milieux LHI aux propriétés différentes, nous allons nous intéresser en premier lieu aux composantes normales de ces champs puis aux composantes tangentielles, en revenant encore une fois aux équations de Maxwell sous forme intégrale.

#### Composante normale

Afin de dériver, les relations de continuité des composantes normales de $`\vec{B}`$ et $`\vec{D}`$ au travers de l'interface $`(\mathcal{P})`$, il est nécessaire d'étudier le voisinage d'un point $`M`$ appartenant à $`\mathcal{P}`$. Avec un point $`M_1`$ du milieu $`1`$, infiniment proche de $`M`$ et  un autre point $`M_2`$ dans le milieu $`2`$, infiniment proche de $`M`$, il est possible de définir un élément infinitésimal de volume $`V`$ de forme cylindrique (cf. \ref{fig:comp_norm}), grâce à l'élément infinitésimal de surface $`d S`$ autour de $`M`$. Ecrivons les équations de Maxwell sous forme intégrales, avec pour volume d'intégration le cylindre $`V`$ de hauteur $`d h`$, et un élément de volume infinitésimal $`d\tau=d h \times d S`$.

![comp-norm_imprim_L1200.jpg](comp-norm_imprim_L1200.jpg)
_Définition géométrique de l'interface $`(\mathcal{P})`$ et volume d'intégration $`V`$ utilisé pour calculer le flux des vecteurs $`\vec{B}`$ et $`\vec{D}`$._
    
##### Champ d'induction magnétique $`\overrightarrow{B}`$

Grâce au théorème de la divergence, il vient :

$`\displaystyle\int_V div\,\overrightarrow{B}~d\tau =\oint_S \overrightarrow{B}\cdot\overrightarrow{dS} = 0`$

$`\displaystyle\oint_S \overrightarrow{B}\cdot\overrightarrow{dS} =  \int_{S_1} \overrightarrow{B}_1 \cdot\overrightarrow{dS}_1 + \int_{S_2} \overrightarrow{B}_2 \cdot\overrightarrow{dS}_2 +\int_{S_lat} \overrightarrow{B} \cdot\overrightarrow{dS}_{lat} `$

En faisant tendre $`d h~\to 0`$, comme le champ magnétique est une fonction bornée, la dernière intégrale (sur la surface latérale du cylindre) tend aussi vers 0. 

De plus, en écrivant $`\overrightarrow{dS}_1=-\,dS~\overrightarrow{n}_{1 \to 2}`$ et $`\overrightarrow{dS}_2=+\,d S~\overrightarrow{n}_{1 \to 2}`$, il vient :

$`\displaystyle\int_{S_1} \left(\overrightarrow{B}_2-\overrightarrow{B}_1\right)\cdot\overrightarrow{n}_{1\to2}\, dS = 0`$

La **relation de continuité** de la *composante normale du champ d'induction magnétique $`\vec{B}`$* à la **traversée de deux milieux LHI** s'écrit donc : 

**$`\displaystyle\vec{n}_{1\to2}\cdot\left(\vec{B}_2-\vec{B}_1\right)= B_{2N}-B_{1N}=0`$**

La **composante normale de $`\vec{B}`$ est continue** à la traversée de l'interface $`(\mathcal{P})`$.

! *Remarque :*
!
! Le *vide* étant lui même un *milieu L*inéaire, *H*omogène et *I*sotrope, je retrouve bien la relation de continuité de la composante normale du champ d'induction magnétique  $`\vec{B}`$ à la *traversée d'une nappe de courant dans le vide*, démontrée précédemment :
!
! *$`\overrightarrow{n}_{1\to2}\cdot\left(\overrightarrow{B}_2-\overrightarrow{B}_1\right)= B_{2N}-B_{1N}=0`$*
!


##### Vecteur d'induction électrique $`\overrightarrow{D}`$

Grâce au théorème de la divergence, il vient :

$`\displaystyle\int_V div\, ~\overrightarrow{D}~d\tau =\oint_S \overrightarrow{D}\cdot\overrightarrow{dS} = \int_V \rho_l~d\tau=\int_{S'} \sigma_S~d S`$

car en faisant tendre $`d h \to 0`$, seule une densité surfacique peut être prise en compte.

$`\displaystyle\oint_S \overrightarrow{D}\cdot\overrightarrow{dS} =  \int_{S_1} \overrightarrow{D}_1\cdot\overrightarrow{dS}_1 + \int_{S_2} \overrightarrow{D}_2\cdot\overrightarrow{dS}_2 +\int_{S_{lat}} \overrightarrow{D}\cdot\overrightarrow{dS}=\int_{S'} \sigma_S~d S`$

En faisant tendre $`d h~\to 0`$, comme l'induction électrique est une fonction bornée, la dernière intégrale (sur la surface latérale du cylindre) tend aussi vers 0. \\

De plus, en écrivant $`d \vec{S}_1=-d S~\vec{n}_{1 \to 2}`$ et $`d \vec{S}_2=d S~\vec{n}_{1 \to 2}`$, il vient:

$`\displaystyle\int_{S_1} \left(\overrightarrow{D}_2-\overrightarrow{D}_1\right)\cdot\overrightarrow{n}_{1\to2}\,dS =\int_{S'} \sigma_S~d S`$

et comme $`S_1=S'$ on en déduit :

La **relation de continuité** de la *composante normale du champ d'induction électrique $`\vec{D}`$* à la **traversée de deux milieux LHI** s'écrit donc : 

**$\displaystyle\overrightarrow{n}_{1\to2}~.\left(\overrightarrow{D}_2-\overrightarrow{D}_1\right)= D_{2N}-D_{1N}=\sigma_S`$**

La **composante normale du vecteur d'induction électrique $`\vec{D}`$ est discontinue** à la traversée de l'interface $`(\mathcal{P})`$.

! *Remarque :*
!
! Le *vide* est un *milieu L*inéaire, *H*omogène et *I*sotrope non polarisable (pas de charges susceptibles de  créer des dipôles) :
!
! dans le vide : *$`\overrightarrow{P}=0`$*.
!
! Donc dans le vide les champs *$`\vec{E}`$ et $`\vec{D}`$ sont liés l'un à l'autre* par la simple *constante électrique* = permittivité électrique (absolue) du vide = *$`\epsilon_0`$, grandeur physique scalaire* :
!
! dans le vide : *$`\overrightarrow{D}=\epsilon_0\,\overrightarrow{E}`$*
!
! Ainsi *la relation* 
!
! *$`\overrightarrow{n}_{1\to2}~.\left(\overrightarrow{D}_2-\overrightarrow{D}_1\right)= D_{2N}-D_{1N}=\sigma_S`$*
!
! *généralise la relation de continuité* de la composante normale de $`\vec{E}`$ à la traversée d'une surface chargée précédemment démontrée mais *limitée à une interface chargée dans le vide* :
!
! *$`\overrightarrow{n}_{1\to2}~.\left(\overrightarrow{E}_2-\overrightarrow{E}_1\right)= E_{2N}-E_{1N}=\dfrac{\sigma_S}{\epsilon_0}`$*
!

!!!! *Attention :*
!!!!
!!!! Il n'y a *en général pas de charges libres à la frontière entre deux matériaux diélectriques* jointifs, donc :
!!!! 
!!!! à l'*interface entre deux matériaux diélectriques : $`\overrightarrow{n}_{1\to2}~.\left(\overrightarrow{D}_2-\overrightarrow{D}_1\right)= D_{2N}-D_{1N}=0`$*
!!!!
!!!! Cette conservation de la composante normale de $`\vec{D}`$ dans ce cas implique de façon générale que la *composante normale de $`\vec{E}`$ n'est pas conservée* :
!!!!
!!!! à l'*interface entre deux matériaux diélectriques : $`\overrightarrow{n}_{1\to2}~.\left(\overrightarrow{E}_2-\overrightarrow{E}_1\right)= E_{2N}-E_{1N}\ne 0`$*
!!!!
!!!! Cette remarque justifie l'introduction du vecteur induction électrique $`\vec{D}`$.
!!!!


### composante tangentielle

![comp-tang.jpg](comp-tang_imprim_L1200.jpg)
_Définition géométrique de l'interface $`(\mathcal{P})`$ et surface d'intégration $`S`$ utilisée pour calculer la circulation des vecteurs $`\vec{E}`$ et $`\vec{H}`$._
 
##### Champ électrique $`\overrightarrow{E}`$

Grâce au théorème du rotationnel, il vient :

$`\displaystyle\int_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS}=\oint_{\mathcal{C}} \overrightarrow{E}\cdot\overrightarrow{dl} =-\,\dfrac{\partial}{\partial t}\,\int_S \overrightarrow{B}\cdot\overrightarrow{dS}=0`$

En faisant tendre $`d h~\to 0`$, comme le champ magnétique est une fonction bornée, l'intégrale du flux de $`\vec{B}`$ au travers de la surface $`(S)`$ tend vers 0. 

La circulation de $`\vec{E}`$ sur le contour $`(\mathcal{C})`$ peut être décomposée comme 

$`\displaystyle\oint_{\mathcal{C}}\overrightarrow{E}\cdot\overrightarrow{dl}=\overrightarrow{E}_1\cdot\overrightarrow{AB}+\overrightarrow{E}_2\cdot\overrightarrow{CD}+C_{BC}+C_{DA}`$

En faisant tendre $`d h~\to 0`$, et comme le champ électrique est une fonction bornée, les termes $`C_{BC}`$ et $`C_{DA}`$ vont tendre vers 0.

De plus, en écrivant $`\vec{AB}=-\vec{CD}=d\vec{l}`$, il vient :

$`\displaystyle\left(\overrightarrow{E}_1-\overrightarrow{E}_2\right)\cdot\overrightarrow{dl}=0`$ , pour tout $`\overrightarrow{dl}~//~(\mathcal{P})`$

soit encore

$`\displaystyle\overrightarrow{E}_{{2}_T}-\overrightarrow{E}_{{1}_T} = \overrightarrow{0}`$

On en déduit :

La **relation de continuité** de la *composante tangentielle du champ électrique $`\vec{E}`$* à la **traversée de deux milieux LHI** s'écrit donc : 

**$` \displaystyle\overrightarrow{n}_{1 \to 2} \wedge \left(\overrightarrow{E}_2-\overrightarrow{E}_1\right)= \overrightarrow{0}`$**

La **composante tangentielle de $`\vec{E}`$ est continue** à la traversée de l'interface $`(\mathcal{P})`$.

! *Remarque :*
!
! Le *vide* étant lui même un *milieu L*inéaire, *H*omogène et *I*sotrope, je retrouve bien la relation de continuité de la composante tangentielle du champ électrique  $`\vec{E}`$ à la traversée d'une surface chargée dans le vide, démontrée précédemment :
!
! *$` \displaystyle\overrightarrow{n}_{1 \to 2} \wedge \left(\overrightarrow{E}_2-\overrightarrow{E}_1\right)= \overrightarrow{0}`$*
!

##### Vecteur excitation magnétique $`\overrightarrow{H}`$

Grâce au théorème du rotationnel, il vient :

$`\displaystyle\int_S \overrightarrow{rot}\,\overrightarrow{H}\cdot\overrightarrow{dS}=\oint_{\mathcal{C}} \overrightarrow{H}\cdot\overrightarrow{dl} =\int_S \overrightarrow{j_{libre}}\cdot\overrightarrow{dS}+\dfrac{\partial}{\partial t}\int_S \overrightarrow{D}\cdot\overrightarrow{dS}`$


En faisant tendre $`d h~\to 0`$, comme l'induction électrique est une fonction bornée, l'intégrale du flux de $`\vec{D}`$ au travers de la surface $`(S)`$ tend vers 0. 

La circulation de $`\vec{H}`$ sur le contour $`(\mathcal{C})`$ peut être décomposée comme 

$`\displaystyle\oint_{\mathcal{C}}\overrightarrow{H}\cdot\overrightarrow{dl}=\overrightarrow{H}_1\cdot\overrightarrow{AB}+\overrightarrow{H}_2\cdot\overrightarrow{CD}+C_{BC}+C_{DA}`$

En faisant tendre $`d h~\to 0`$, et comme le vecteur d'excitation magnétique est une fonction bornée, les termes $`C_{BC}`$ et $`C_{DA}`$ vont tendre vers 0.

De plus, en écrivant $`\vec{AB}=-\vec{CD}`$, il vient:

$`\displaystyle \left( \overrightarrow{H}_1 - \overrightarrow{H}_2 \right) \cdot \overrightarrow{dl} = \overrightarrow{j_{libre}} \cdot \overrightarrow{dS} = d I = \overrightarrow{j_S}_{libre} \cdot \left( \overrightarrow{dl} \wedge \overrightarrow{n}_{1 \to 2} \right) `$ , pour tout $`\overrightarrow{dl}~//~(\mathcal{P})`$

On en déduit :

La **relation de continuité** de la *composante tangentielle du vecteur excitation magnétique $`\vec{H}`$* à la **traversée de deux milieux LHI** s'écrit donc : 

**$`\displaystyle\overrightarrow{n}_{1 \to 2} \wedge \left(\overrightarrow{H}_2-\overrightarrow{H}_1\right)=\overrightarrow{j_S}_{libre}`$**

La **composante tangentielle du vecteur excitation magnétique $`\vec{H}`$ est discontinue** à la traversée de l'interface $`(\mathcal{P})`$.

! *Remarque :*
!
! Le *vide* est un *milieu L*inéaire, *H*omogène et *I*sotrope *non magnétique* (pas de charges en mouvement susceptibles de  créer des dipôles magnétiques) :
!
! dans le vide : *$`\overrightarrow{M}=0`$*.
!
! Donc dans le vide les champs *$`\vec{B}`$ et $`\vec{H}`$ sont liés l'un à l'autre* par la simple *constante magnétique* = perméabilité magnétique (absolue) du vide = *$`\mu_0`$, grandeur physique scalaire* :
!
! dans le vide : *$`\overrightarrow{H}=\dfrac{\overrightarrow{B}}{\mu_0}`$*
!
! Ainsi *la relation* 
!
! *$`\displaystyle\overrightarrow{n}_{1 \to 2} \wedge \left(\overrightarrow{H}_2-\overrightarrow{H}_1\right)=\overrightarrow{j_S}_{libre}`$*
!
! *généralise la relation de continuité* de la composante tangentielle de $`\vec{B}`$ à la traversée d'une nappe de courant précédemment démontrée mais *limitée à une nappe de courant isolée dans le vide* :
!
! *$`\overrightarrow{n}_{1\to2}~.\left(\overrightarrow{B}_2-\overrightarrow{B}_1\right)= B_{2T}-B_{1T}=\mu_0\,\overrightarrow{j_S}_{libre}`$*
!

!!!! *Attention :*
!!!!
!!!! Il n'y a *en général pas de courants libres* (courants de conduction) *à la frontière entre deux matériaux diélectriques* jointifs, donc :
!!!! 
!!!! à l'*interface entre deux matériaux diélectriques : $`\displaystyle\overrightarrow{n}_{1 \to 2} \wedge \left(\overrightarrow{H}_2-\overrightarrow{H}_1\right)=\overrightarrow{0}`$*
!!!!
!!!! Cette conservation de la composante tangentielle de $`\vec{H}`$ dans ce cas implique de façon générale que la *composante tangentielle de $`\vec{B}`$ n'est pas conservée* :
!!!!
!!!! à l'*interface entre deux matériaux diélectriques : $`\overrightarrow{n}_{1\to2}~.\left(\overrightarrow{B}_2-\overrightarrow{B}_1\right)= B_{2T}-B_{1T}\ne 0`$*
!!!!
!!!! Cette remarque est une justification à l'introduction et l'intérêt du vecteur induction électrique $`\vec{H}`$*.
!!!! 

!! *Pour aller plus loin :* 
!!
!! Fondamentalement parlant, seuls des champs $`\vec{E}`$ et $`\vec{B}`$ ont une importance. En effet les équations de Maxwell dans le vide précisent comment sont créés les champs $`\vec{E}`$ et $`\vec{B}`$ par les charges et les courants, et la force de Lorentz $`\vec{F}_{Lorentz}=q\cdot (\vec{E}+\vec{v}\land\vec{B})`$ indique avec la relation classique $`\vec{F}_{Lorentz}=d\vec{p}\,/\,dt`$ comment les champs $`\vec{E}`$ et $`\vec{B}`$ modifient le mouvement des charges. Les équations de Maxwell dans le vide sont générales, l'atome est prinicpalement constitué de vide et si notre échelle d'observation était atomique, ce sont avec ces équations et ces champs  $`\vec{E}`$ et $`\vec{B}`$ que nous décririons les phénomènes.
!!
!! Cependant à l'échelle mésoscopique d'observation et de modélisation, les détails des moments dipolaires électriques et des moments magnétiques est inconnu, seules les moyennes statistiques de ces moments interviennent dans la définition des vecteurs polarisation $`\vec{P}`$ et aimantation $`\vec{M}`$.
!! Un milieu anisotrope pour ses propriétés électriques et magnétiques possède des directions de plus facile polarisation et de plus facile aimantation. Si les champs $`\vec{E}`$ et $`\vec{B}`$ appliqués de l'extérieur ne sont pas dirigés selon ces directions, alors les vecteurs $`\vec{D}=\epsilon_0\;\vec{E}+\vec{P}`$ et $`\vec{H}=(\vec{B}\,/\mu_0)+\vec{M}`$ ne sont pas parralèles à $`\vec{E}`$ et $`\vec{B}`$. 
!!
!! La définition des vecteurs $`\vec{D}`$ et $`\vec{H}`$ permettent de mieux visualiser et simplifier l'écriture de grandeurs physiques importantes comme les densités volumiques d'énergie électrique $`w_E=(\vec{E}\cdot\vec{D})\,/\,2`$ et magnétique $`w_B=(\vec{H}\cdot\vec{B})\,/\,2`$, ainsi que le vecteur de Poynting $`\vec{\Pi}=\vec{E}\land\vec{H}`$.


<!--=======ATTENTION: pas si simplke là, à mettre au point ou retirer============
!! Cependant, dans la pratique courante les grandeurs physiques que nous contrôlons et mesurons facilement pour créer des champs électriques et magnétiques sont :
!!
!! * le potentiel électrique d'unité SI $`V`$ et donc le champ électrique $`E`$ d'unité SI $`V.m^{-1}`$, qui agit sur toutes les charges, libres comme liées.
!!
!! * l'intensité des courants d'unité SI $`A`$ dans les circuits électriques, donc le champ d'excitation magnétique $`H`$ d'unité SI $`A.m^{-1}`$ 
===============================================================-->

### Application à la réflexion métallique sous incidence normale

Nous allons traiter, dans la suite, un premier exemple d'applications des relations de continuité à l'interface entre l'air (indice optique $`n=1`$) et un conducteur supposé parfait. Afin de simplifier le problème dans un premier temps, le calcul sera fait sous incidence normale.

![interf-metal-normal_imprim_L1200.jpg](interf-metal-normal_imprim_L1200.jpg)
_Définition géométrique de l'interface diélectrique-métal avec une onde incidente normale._

#### Cas idéal

**À l'interface entre deux milieux**, une *onde incidente ($`\vec{E_i}`$)* se décompose en générale en une *onde réfléchie ($`\vec{E_r}`$)* et une *onde transmise ($`\overrightarrow{E_t}`$)* encore appelée *onde réfractée*. 

En tout point de l'interface et à tout instant $`t`$, nous avons :<!--conservation de l'énergie, on développe?-->

**$`\overrightarrow{E_i}=\overrightarrow{E_r}+\overrightarrow{E_t}`$**

Un **conducteur parfait** est caractérisé par une *conductivité électrique infiniment grande*($`\sigma=\infty`$), ce qui implique qu'*aucun champ électrique ne peut régner à l'intérieur* de ce milieu modèle ($`\overrightarrow{E_{int}}=\overrightarrow{0}`$).

Dans le **cas d'une réflexion sur un métal parfait**, il n'y aura donc *pas d'onde transmise* ($`\vec{E_t}=\vec{0}`$), mais seulement une onde réfléchie.
     
Choisissons une **onde incidente du type OPPM** *polarisée rectilignement suivant l'axe $`(Ox)`$*. En écriture complexe elle s'écrit :

**$`\underline{\overrightarrow{E_i}}=\overrightarrow{E}_i^0~\textrm{e}^{i(kz-\omega t)}=E_i^0~\overrightarrow{u}_x\;e^{i(kz-\omega t)}`$**

Étudions la nature de l'**onde réfléchie** qui _a priori_ peut s'écrire :

**$`\underline{\overrightarrow{E_r}}=\overrightarrow{E}_r^0~\textrm{e}^{i(k'z-\omega' t)} `$**,

avec $`\vec{E}_r^0`$, $`k'`$ et $`\omega'`$ des grandeurs inconnues.
	
#### Utilisation des relations de continuité à l'interface

**A l'interface**, c'est à dire en $`z=0`$ et à tout instant $`t`$, comme $`\vec{E_i}^0=E_i^0~\vec{u}_x`$ et $` \vec{E_r}^0`$ sont des vecteurs constants, nous devons avoir l'*égalité des phases* de ces deux ondes :

*$` kz-\omega t = k'z-\omega' t`$*. 

Cela implique que *$\omega'=\omega$*, ainsi l'**onde réfléchie** se propage à la *même fréquence que l'onde incidente*. De plus comme la propagation de l'onde réfléchie se fait dans le même milieu que l'onde incidente, le *vecteur d'onde $\vec{k'}$* aura *même norme que $\vec{k}$, mais de sens opposé*.

L'onde réfléchie peut donc s'écrire :

**$`\underline{\overrightarrow{E_r}}=\overrightarrow{E_r}^0\;e^{-i(kz+\omega t)} `$**

Il reste à déterminer $`\vec{E}_r^0`$.

* Du fait de la continuité de la composante normale à l'interface (pas d'accumulation de charges possible dans le conducteur parfait), il vient immédiatement que $E_{r_z}^0$, la composante de $\vec{E}_r^0$ suivant $(Oz)$ est nulle car $E_{i_z}^0=E_{t_z}^0=0$. 

* Du fait de la continuité de la composante tangentielle du champ $\vec{E}$ à l'interface, il est possible d'écrire deux équations correspondant aux projections suivant $(Ox)$ et $(Oy)$ :<br>
<br>
$`E_{i_x}^0+E_{r_x}^0=0\quad`$ et $`\quad E_{r_y}=0`$<br>
<br>
ce qui permet d'écrire le champ électrique réfléchi suivant :<br>
<br>
$`\underline{\overrightarrow{E_r}}=\underline{\overrightarrow{E_i}^0}~\overrightarrow{u}_x\;e^{-i(kz+\omega t)}`$

* le *champ électrique total* régnant **dans le milieu incident diélectrique** est donné par :<br>
<br>
$`\underline{\vec{E}}_{\textrm{tot}}=\underline{\vec{E}}_i+\underline{\vec{E}}_r`$$`=E_i^0~\vec{u}_x~\textrm{e}^{-i \omega t}\left(\textrm{e}^{ikz}-\textrm{e}^{-ikz}\right)`$$`=2i E_i^0~\vec{u}_x~\sin \left(kz\right)~\textrm{e}^{-i \omega t} `$<br>
<br>
soit en notation réelle :<br>
<br>
**$\displaystyle\vec{E}_{tot}=2E_i^0 \sin \left(kz\right) \sin \left(\omega t\right) \,\vec{u}_x$**<br>
<br> 
Ainsi nous obtenons un **champ électrique stationnaire**, car l'onde ne se propage plus (séparation des variables d'espace et de temps).

* Pour écrire les **champs magnétiques associés**, $\displaystyle \underline{\vec{B}}_i={\vec{B}}_i^0~\textrm{e}^{i(kz-\omega t)}$ et  $\displaystyle \underline{\vec{B}}_r={\vec{B}}_r^0~\textrm{e}^{-i(kz+\omega t)}$, il est impératif de revenir au fait que les ondes incidente et réfléchie sont des OPPM, ce qui nous permet d'écrire :<br>
<br>
$`\underline{\vec{B}}_i=\frac{\vec{k}\wedge\underline{\vec{E}}_i}{\omega},~~\underline{\vec{B}}_r=\frac{-\vec{k}\wedge\underline{\vec{E}}_r}{\omega} `$<br>
<br>
avec les mêmes relations valables en réél, et comme $`\vec{E}_r^0=-\vec{E}_i^0`$, il vient $`\displaystyle \vec{B}_r^0=\vec{B}_i^0=B_i^0~\vec{u}_y= \frac{E_i^0}{c}~\vec{u}_y`$. 

* Le champ magnétique total régnant dans le milieu diélectrique est donné par :<br>
<br> 
$`\underline{\vec{B}}_{\textrm{tot}}=\underline{\vec{B}}_i+\underline{\vec{B}}_r`$$`=B_i^0~\vec{u}_y~\textrm{e}^{-i \omega t}\left(\textrm{e}^{ikz}+\textrm{e}^{-ikz}\right)`$$`=2 B_i^0~\vec{u}_y~\cos \left(kz\right)~\textrm{e}^{-i \omega t} `$<br>
<br>
soit en notation réelle :<br>
<br>
**$`\displaystyle \vec{B}_{\textrm{tot}}=2\,B_i^0 \cos \left(kz\right) \cos \left(\omega t\right) \,\vec{u}_y`$**.<br>
<br>
Ainsi nous obtenons un **champ magnétique stationnaire**, car l'onde ne se propage plus (séparation des variables d'espace et de temps).

* La *discontinuité de la composante tangentielle de $\vec{H}$* à la traversée de l'interface conduit dans ce cas à un **courant surfacique** de vecteur densité surfacique :<br>
<br>
$`\underline{\vec{j}}_S=\vec{u}_z\wedge\left(\vec{0} -\left(\underline{\vec{H}}_i+\underline{\vec{H}}_r\right)\right) `$<br>
<br>
qui s'écrit au final :<br>
<br>
**$`\underline{\vec{j}}_S=\frac{2B_i^0}{\mu_0}~\vec{u}_x~\textrm{e}^{-i \omega t} `$**

#### Vecteur de Poynting
Afin de préciser le *bilan énergétique*, il est nécessaire de calculer le **vecteur de Poynting total** réel grâce à $`\displaystyle\vec{\Pi}_{\textrm{tot}}=\frac{\vec{E}_{\textrm{tot}}\wedge\vec{B}_{\textrm{tot}}}{\mu_0}`$. Il vient facilement:

**$`\overrightarrow{\Pi}_{\textrm{tot}}=\dfrac{E_i^0B_i^0}{\mu_0}~\overrightarrow{u}_z~\sin\left(2 kz\right) \sin\left(2 \omega t\right) `$**

La **valeur moyenne temporelle du vecteur de Poynting**, calculée sur une période temporelle  (équivalent à la moyenne temporelle déterminée sur une durée très grande devant la période temporelle) est **nulle**. Nous retrouvons bien une *caractéristique de l'onde stationnaire* du champ électromagnétique total.
 
### Application à la réflexion et à la transmission entre deux diélectriques sous incidence quelconque

Dans cette section, nous allons nous intéresser à la propagation d'une onde se propageant dans un **milieu LHI diélectrique incident  ($`1`$)** dont les constantes diélectriques et magnétiques sont *$`\epsilon_1,\mu_1`$*, et rencontrant sous incidence oblique un **milieu LHI diélectrique ($`2`$)** dont les constantes diélectriques et magnétiques sont *$`\epsilon_2,\mu_2`$*. 

Les deux **milieux** seront considérés comme **neutres**, il n'y a donc *pas de charges ni de courants* associés. 

#### Présentation du problème

A partir d'une **onde incidente** de *vecteur d'onde $`\vec{k}_{inc}`$* dont la source est suffisamment éloignée pour ne pas avoir d'effets dans le voisinage de l'interface, un phénomène de réflexion et de réfraction donne naissance à deux ondes. L'**onde réfléchie** dans le milieu $`1`$ possède un *vecteur d'onde $`\vec{k}_{ref}`$*, et l'**onde transmise** dans le milieu $`2`$ et possède un *vecteur d'onde $`\vec{k}_t{trans}`$*. _À priori_ ces vecteurs peuvent posséder des composantes sur
chacun des axes $`(Ox)`$, $`(Oy)`$ et $`(Oz)`$ soit`: 

$`\overrightarrow{k}_{inc}= \left| \begin{array}{l} k_{inc\,x} \\ k_{inc\,y} \\ k_{inc\,z} \end{array} \right.\,,\;`$
$`\overrightarrow{k}_{ref}=\left| \begin{array}{l} k_{ref\,x} \\ k_{ref\,y} \\ k_{ref\,z} \end{array} \right. \,,\;`$
$`\overrightarrow{k}_{trans}=\left| \begin{array}{l} k_{trans\,x} \\ k_{trans\,y} \\ k_{trans\,z}  \end{array} \right.`$

De plus, nous pouvons repérer les **angles** d'incidence *$`\theta_{inc}`$*, de réflexion *$`\theta_{ref}`$* et de réfraction *$`\theta_{trans}`$* **par rapport à la normale** à la surface comme dans la figure suivante

![interf-diel-qcque_imprim_L1200.jpg](interf-diel-qcque_imprim_L1200.jpg)

Afin de simplifier le problème, nous allons développer le **cas d'une onde OPPM incidente polarisée rectilignement**, sans pour autant oublier que le cas général d'une *onde plane quelconque (polarisée elliptiquement) peut toujours se ramener à la superposition de deux OPPMs polarisées rectilignement*. De manière très générale, nous pouvons ainsi écrire les **champs électriques présents dans les milieux $`1`$ et $`2`$** :

**$`\underline{\overrightarrow{E}}_{\,inc}\, = \, \underline{\overrightarrow{E}}_{\,inc}^{\,0}\;e^{i\,\left(\overrightarrow{k}_{inc}\cdot\overrightarrow{r}\,-\,\omega\,t\right)}`$**

**$`\underline{\overrightarrow{E}}_{\,ref}\, = \, \underline{\overrightarrow{E}}_{\,ref}^{\,0}\;e^{i\,\left(\overrightarrow{k}_{ref}\cdot\overrightarrow{r}\,-\,\omega_{ref} t\right)}`$**

**$`\underline{\overrightarrow{E}}_{\,trans}\, = \, \underline{\overrightarrow{E}}_{\,trans}^{\,0}\;e^{i\,\left(\overrightarrow{k}_{trans}\cdot\overrightarrow{r}\,-\,\omega_{trans} t\right)}`$**

où *$` \omega_{ref}`$* et  *$`\omega_{trans}`$* sont les *pulsations des ondes réfléchie et transmise*, et où les vecteurs $` \underline{\vec{E}}_{\,inc}`$, $` \underline{\vec{E}}_{\,ref}`$ et $` \underline{\vec{E}}_{\,trans}`$ sont des vecteurs constants mais pouvant être néanmoins complexes afin de tenir compte d'éventuels déphasages.

De plus, on peut décomposer chacun de ces vecteurs en une composante normale (suivant $`(Oz)`$) et une composante tangentielle (suivant $`(Ox)`$ et $`(Oy)`$), ainsi pour le vecteur incident par exemple, on a $`\underline{\vec{E}}_{\,inc}=  \underline{\vec{E}}_{\,inc\,N} + \underline{\vec{E}}_{\,inc\,T}`$. Evidemment, les caractéristiques des ondes réfléchie et transmise vont être déterminées grâce aux relations de continuité à l'interface (en $`z=0`$). 
 
#### Relations de continuité propres à cette interface

**A l'interface**, donc à la limite $z=0$, *pour tout $`x`$, $`y`$, et $`z`$*, on a:

* la **continuité de  la composante tangentielle de $`\vec{E}`$.**
* la **continuité de la composante normale de $`\vec{B}`$**

De plus comme il n'y a **pas de charges libres** et donc **pas de courants** associés, on a aussi:

* la **continuité de la composante normale de $`\vec{D}`$**
* la **continuité de la composante tangentielle de $`\vec{H}`$**

#### Lois de la réflexion et de la réfraction de l'optique des rayons (optique géométrique)

Étudions la **continuité de la composante tangentielle de $`\vec{E}`$ en un point $`M`$ de l'interface $`\mathcal{P}`$**. En posant *$`\vec{OM}=\vec{r}_S=x~\vec{u}_x+ y~\vec{u}_y`$*, la continuité s'écrit :

**$` \,\underline{\overrightarrow{E}}_{\,inc\,T}^{\,0}\;e^{i\,\left(\overrightarrow{k}_{inc}\cdot\overrightarrow{r_S}\,-\,\omega\, t\right)}\,`$$`+\, \underline{\overrightarrow{E}}_{\,ref\,T}^{\,0}\;e^{i\,\left(\overrightarrow{k}_{inc}\cdot\overrightarrow{r_S}\,-\,\omega _{ref} t\right)}\,`$
$`=\,\underline{\overrightarrow{E}}_{\,trans\,T}^{\,0}\;e^{i\,\left(\overrightarrow{k}_{inc}\cdot\overrightarrow{r_S}\,-\,\omega _{trans} t\right)} `$**

Comme $`\underline{\vec{E}}_{\,inc}^{\,0}`$, $`\underline{\vec{E}}_{\,ref}^{\,0}`$ et $`\underline{\vec{E}}_{\,trans}^{\,0}`$ sont des vecteurs constants, $`\underline{\vec{E}}_{\,inc\,T}^{\,0}`$, $`\underline{\vec{E}}_{\,ref\,T}^{\,0}`$ et $`\underline{\vec{E}}_{\,trans\,T}^{\,0}`$  le sont aussi.

Au point $M$, ces trois vecteurs vont avoir des *phases égales*  :

$`(\overrightarrow{k}_{inc}\cdot\overrightarrow{r_S}\,-\,\omega\, t\,`$
$`= (\overrightarrow{k}_{ref}\cdot\overrightarrow{r_S}\,-\,\omega\, t\,`$
$`= (\overrightarrow{k}_{trans}\cdot\overrightarrow{r_S}\,-\,\omega\, t\,`$ ,

soit encore

*$`k_{inc\,x}\cdot x+k_{inc\,y}\cdot y -\omega \,t \,`$$`\,= k_{ref\,x}\cdot x+k_{ref\,y}\cdot y -\omega_{ref} t \,`$$`\,=k_{trans\,x}\cdot x+k_{trans\,y}\cdot y -\omega_{trans} t  `$*

En se plaçant à l'origine des axes $`x=y=0`$ on a donc à chaque instant $`t`$ :

**$`\omega_{ref}=\omega_{trans}=\omega`$**.

ce qui traduit ce fait important :  A l'**interface entre deux milieux diélectriques Linéaires, Homogènes et Isotropes**, les *ondes réfléchies et réfractées ont la même pulsation que l'onde incidente*.

<!--====Xavier Marie? un point "pour aller au-delà", ou un développement plus complet dans le volet "Beyond" de ce cours? ===========================-->

##### Loi de la réflexion

Reprenons l'égalité des phases du champ électrique $`E`$ à l'interface $`\mathcal{P}`$ entre deux milieux diélectriques LHI, due à la continuité de $`E``$. 

$`\overrightarrow{k}_{inc}\cdot\overrightarrow{r_S}\,-\,\omega\, t\,`$
$`= \overrightarrow{k}_{ref}\cdot\overrightarrow{r_S}\,-\,\omega\, t\,`$
$`= \overrightarrow{k}_{trans}\cdot\overrightarrow{r_S}\,-\,\omega\, t\,`$ 

<!--====inutile ici==============
*$`k_{inc\,x}\cdot x+k_{inc\,y}\cdot y -\omega \,t \,`$$`\,= k_{ref\,x}\cdot x+k_{ref\,y}\cdot y -\omega_{ref} t \,`$$`\,=k_{trans\,x}\cdot x+k_{trans\,y}\cdot y -\omega_{trans} t  `$*
=========================-->

Nous en avons déduit que les ondes incidentes, réfléchie et transmise sont caractérisées par une même pulsation $`\omega=\omega_{inc}=\omega_{ref}=\omega_{trans}`$. Nous en déduisons donc l'égalité :

$`\overrightarrow{k}_{inc}\cdot\overrightarrow{r_S}\,`$
$`= \overrightarrow{k}_{ref}\cdot\overrightarrow{r_S}\,`$
$`= \overrightarrow{k}_{trans}\cdot\overrightarrow{r_S}\,`$ 

<!--====inutile ici==============
*$`k_{inc\,x}\cdot x+k_{inc\,y}\cdot y = k_{ref\,x}\cdot x+k_{ref\,y}\cdot y = k_{trans\,x}\cdot x+k_{trans\,y}\cdot y`$*
=========================-->

Les ondes incidente et réfléchie se propageant dans le même milieu incident d'indice de réfraction $`n_1`$, leurs nombres d'ondes $` k_{inc}=||\overrightarrow{k}_{inc}|| `$ et $`k_{inc}=||\overrightarrow{k}_{ref}|| `$ sont donc égaux. En effet :

$`k_{inc}=k_{ref}=k_1 \dfrac{\omega}{v_{\phi1}}=\dfrac{\omega}{c}\;\dfrac{c}{v_{\phi1}}=k_0\, n_1 `$

où *$`n_1`$* est l'*indice de réfraction* du milieu $`1`$, et *$`k_0`$* et *$`\lambda_0`$* sont respectivement le *nombre d'onde et la longueur d'onde dans le vide*.

Ayant même pulsation et se propageant dans le même milieu, il est normal que les **ondes OPPM incidente et réfléchie** soient caractérisées par le même nombre d'onde et donc la **même longueur d'onde dans le vide** $`\lambda_0`$.

!!!! *Important :*
!!!!  
!!!! Les ondes incidente et réfléchie ont aussi une même longueur d'onde $`\lambda_1`$ dans le milieu $`1`$ d'incidence, puisqu'elles partagent ce même milieu.
!!!!
!!!! Mais souviens-toi que *seules les grandeurs temporelles $`T`$, $`\nu`$ , $`\omega`$ de l'onde sont fondamentales, independantes du milieu de propagation* de l'onde. 
!!!!
!!!! Utiliser la notion de longueur d'onde $`\lambda_1`$ de l'onde dans le milieu $`1`$ peut éventuellement avoir une utilité dans l'étude des phénomènes d'interférence et de diffraction dans un milieu $1$, pour calculer la distance interfranges ou le diamètre de la tache d'Airy.
!!!!
!!!! Mais utiliser la *notion de longueur d'onde* dans un milieu qui n'est ni l'air ni le vide est dangeureux et  donc *ne doit pas être utilisée* dès que nous parlons d'*interaction entre l'onde électromagnétique et la matière*.
!!!!
!!!! Pour t'en convaincre, considère une lumière monochromatique de longeur d'onde $`\lambda_0=600\;nm`$ dans le vide (et donc dans l'air car $`n_{air}\simeq n_{vide}=1`$. La longueur d'onde $`\lambda_0=600\;nm`$ correspond à une perception visuelle de couleur orange. Cependant en se propageant dans le corps vitré de ton oeil, milieu diélectrique $`1`$ transparent qui conduit la lumière entre le cristallin et ta rétine, la  longueur d'onde de cette même radiation est $`\lambda_1\simeq 450\;nm`$ parce que l'indice de refraction du corps vitreux est $`n_1\simeq 1,33`$. Or dans le vide la longueur d'onde $`\lambda_0\simeq 450\;nm`$ correspond à une perception visuelle de couleur bleu. Cela est peut induire confusion : une longueur d'onde de $`\lambda_0\simeq 450\;nm`$ correspond-t-elle à une perception orange ou une perception bleue?
!!!!
!!!! L'*interaction lumière matière correspond à un échange d'énergie* entre l'onde électromagnétique et la matière chargée qui constitue les cellules cônes de ton oeil sensible à la couleur, sous forme de photons individuels d'énergie $`h\nu=\hbar\omega`$. L'énergie des photons, comme l'énergie de l'onde électromagnétique ne change pas la traversée entre deux milieux diélectriques, car l'énergie est *proportionnelle à la fréquence, grandeur temporelle fondamentale*.
!!!!

Reprenons à nouveau l'équation d'égalité des phases à l'interface, en nous limitant aux deux premiers termes qui concernent l'onde incidente et l'onde réfléchie : 

$`\overrightarrow{k}_{inc}\cdot\overrightarrow{r_S}=\overrightarrow{k}_{ref}\cdot\overrightarrow{r_S}`$

Comme d'une part cette égalité est valable en tout point de l'interface, et donc en particulier hors de l'origine ($\overrightarrow{r_S}\ne 0`$, et que d'autre part l'onde électromagnétique décrit un champ non constant ce qui implique $\omega\ne 0`$ et donc $`\overrightarrow{k}_{inc}\ne 0`$ et $`\overrightarrow{k}_{ref}\ne 0`$, nous en déduisons :

L'égalité entre le deux premiers termes bous permet d'écrire :

$`\left(\overrightarrow{k}_{inc}-\overrightarrow{k}_{ref}\right) .\overrightarrow{r_S}=0`$

soit en faisant apparaître les angles d'incidence $`\theta_{inc}=(\hat{vec{n},vec{n}`$ et

* Comme $\vec{r}_S$ appartient au plan $\mathcal{P}$, il faut donc que le vecteur  $\left(\vec{k}_i-\vec{k}_r\right)$ soit normal à $\mathcal{P}$. C'est à dire que les vecteurs $\vec{k}_i$, $\vec{k}_r$ et $\vec{n}_{1 \to 2}$ sont coplanaires.
$` `$
<!--=========================
\begin{itemize}
\item Comme $\vec{r}_S$ appartient au plan $\mathcal{P}$, il faut donc que le vecteur  $\left(\vec{k}_i-\vec{k}_r\right)$ soit normal à $\mathcal{P}$. C'est à dire que les vecteurs $\vec{k}_i$, $\vec{k}_r$ et $\vec{n}_{1 \to 2}$ sont coplanaires.\\
\begin{center}
\underline{Première loi de la réflexion}:\\ l'onde réfléchie est dans le plan d'incidence défini par le vecteur d'onde de l'onde incidente et le vecteur normal à l'interface $\vec{n}_{1 \to 2}$.
\end{center}
\vspace{0.5cm}
\item Les composantes tangentielles de $\vec{k}_i$ et $\vec{k}_r$ sont égales:
\begin{equation*}
\vert\vert\vec{k}_i\vert\vert \sin \theta_i=\vert\vert\vec{k}_r\vert\vert \sin \theta_r,
\end{equation*}
et comme $\vert\vert\vec{k}_i\vert\vert=\vert\vert\vec{k}_r\vert\vert$, on a:
\begin{equation}
\theta_i=\theta_r.
\end{equation}
==========================-->

$` `$
<!--=========================
\begin{center}
\underline{Seconde loi de la réflexion}:\\ l'angle de réflexion est égal à l'angle d'incidence.\\
\end{center}
\vspace{0.75cm}
\underline{Remarque}: Cette relation est valable indépendamment de la nature du milieu $2$, aussi bien pour un diélectrique qu'un conducteur.   
\end{itemize}
==========================-->

##### Lois de Snell-Descartes relative à la réfraction

En reprenant l'égalité (\ref{eq:ph_eq}), on a:

$`\left(\vec{k}_i-\vec{k}_t\right) .\vec{r}_S=0`$
<!--=========================
\begin{equation}
\left(\vec{k}_i-\vec{k}_t\right) .\vec{r}_S=0.
\end{equation}
==========================-->

$` `$
<!--=========================
\begin{itemize}
\item Comme $\vec{r}_S$ appartient au plan $\mathcal{P}$, il faut donc que le vecteur  $\left(\vec{k}_i-\vec{k}_t\right)$ soit normal à $\mathcal{P}$. C'est à dire que les vecteurs $\vec{k}_i$, $\vec{k}_t$ et $\vec{n}_{1 \to 2}$ sont coplanaires.\\
\begin{center}
\underline{Première loi de la réfraction}:\\ l'onde réfractée est dans le plan d'incidence défini par le vecteur d'onde de l'onde incidente et le vecteur normal à l'interface $\vec{n}_{1 \to 2}$.
\end{center}
\vspace{0.75cm}
\item Les composantes tangentielles de $\vec{k}_i$ et $\vec{k}_t$ sont égales:
\begin{equation*}
\vert\vert\vec{k}_i\vert\vert \sin \theta_i=\vert\vert\vec{k}_t\vert\vert \sin \theta_t,
\end{equation*}
comme $\vert\vert\vec{k}_i\vert\vert=k_0 n_1$, et aussi $\vert\vert\vec{k}_t\vert\vert=k_0 n_2$ on a:\\
\begin{center}
\underline{Seconde loi de la réfraction}:\\
\end{center}
\vspace{0.75cm}
\begin{equation}
n_1\sin \theta_i=n_2 \sin \theta_t.
\end{equation}
\end{itemize}
==========================-->

Maintenant que l'on dispose des relations liant les vecteurs d'onde, on peut s'intéresser aux relations liant les amplitudes.

#### Expressions des champs réfléchis et transmis: Relations de Fresnel

Nous devons séparer deux cas dans la suite: si le champ électrique est polarisé dans la direction perpendiculaire au plan d'incidence, on aura le mode Transverse Electrique (TE). Si le champ électrique est polarisé dans une direction appartenant au plan d'incidence, c'est à dire si le champ magnétique est transverse, alors on sera dans le mode Transverse Magnétique (TM). De plus, avec les conditions obtenues précédemment, et la nature isotrope des milieux, une onde incidente TE donnera naissance à une onde réfléchie TE et une onde transmise TE. De même pour une onde incidente TM. 

![mode-TE-TM_imprim_L1200.jpg](mode-TE-TM_imprim_L1200.jpg)
_ Configuration des champs é.m pour les modes TE et TM._

<!--=========================
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 \begin{figure}[!h]
\begin{center}
\includegraphics[width=0.6\columnwidth, trim=0 0 0 0,clip]{Chap-interf/Fig/mode-TE-TM.pdf} 
\end{center}
\caption{Configuration des champs é.m pour les modes TE et TM.}
\label{fig:mode-TE-TM}
\end{figure}
==========================-->
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

##### Cas d'une onde incidente TE (polarisée suivant une direction perpendiculaire au plan d'incidence)
 
Connaissant ${\vec{ \underline{E}^0_i}}$ (et donc ${\vec{ \underline{B}^0_i}}$), nous avons à déterminer quatre vecteurs inconnus: ${\vec{ \underline{E}^0_r}}$, ${\vec{ \underline{E}^0_t}}$, ${\vec{ \underline{B}^0_r}}$, et ${\vec{ \underline{B}^0_t}}$. Avec :

$`{\vec{ \underline{E}^0_i}}=\left\vert \begin{array}{c}`$
<!--=========================
\begin{equation*}
{\vec{ \underline{E}^0_i}}=\left\vert \begin{array}{c}
0 \\
\\
E_i^0 \\
\\
0
\end{array}, \right. 
\end{equation*} 
==========================-->

il vient facilement avec les conditions de continuités sur le champ électrique : (pas de composante normale, composante tangentielle uniquement sur $(Oy)$):

$` `$
<!--=========================
\begin{center}
\begin{minipage}[c]{.45\columnwidth}
\begin{equation*}
{\vec{ \underline{E}^0_r}}=\left\vert \begin{array}{c}
0 \\
\\
E_r^0 \\
\\
0
\end{array}, \right. 
\end{equation*}
\end{minipage}
\begin{minipage}[c]{.45\columnwidth}
\begin{equation*}
{\vec{ \underline{E}^0_t}}=\left\vert \begin{array}{c}
0 \\
\\
E_t^0 \\
\\
0
\end{array}. \right. 
\end{equation*}
\end{minipage}
\end{center}
==========================-->

De plus, avec la condition de continuité sur la composante tangentielle du champ électrique à l'interface ($z=0$, $\forall t$), on a:

$`E_i^0+E_r^0=E_t^0 `$
<!--=========================
\begin{equation}
E_i^0+E_r^0=E_t^0.
\end{equation}
==========================-->

![mode-TE_imprim_L1200.jpg}(mode-TE_imprim_L1200.jpg)

<!--=========================
 \begin{figure}[!h]
\begin{center}
\includegraphics[width=0.6\columnwidth, trim=0 0 0 0,clip]{Chap-interf/Fig/mode-TE.pdf} 
\end{center}
\caption{Configuration des champs é.m pour le mode TE.}
\label{fig:mode-TE}
\end{figure}
==========================-->

La continuité de la composante tangentielle de $\vec{H}$ à l'interface va nous donner à partir de :

$` `$
<!--=========================
\begin{equation*}
{\vec{ \underline{B}^0_i}}=\left\vert \begin{array}{c}
-B_i^0 \cos \theta_1 \\
\\
0 \\
\\
B_i^0 \sin \theta_1 
\end{array}, \right. 
\end{equation*} 
\begin{center}
\begin{minipage}[c]{.45\columnwidth}
\begin{equation*}
{\vec{ \underline{B}^0_r}}=\left\vert \begin{array}{c}
B_r^0 \cos \theta_1 \\
\\
0 \\
\\
B_r^0 \sin \theta_1
\end{array}, \right. 
\end{equation*}
\end{minipage}
==========================-->

$` `$
<!--=========================
\begin{minipage}[c]{.45\columnwidth}
\begin{equation*}
{\vec{ \underline{B}^0_t}}=\left\vert \begin{array}{c}
-B_t^0 \cos \theta_2\\
\\
0 \\
\\
B_t^0 \sin \theta_2
\end{array}, \right. 
\end{equation*}
\end{minipage}
\end{center}
==========================-->

la relation suivante:

$`\left(\frac{B_i^0}{\mu_1}-\frac{B_r^0}{\mu_1}\right) \cos \theta_1= \frac{B_t^0}{\mu_2} \cos \theta_2`$
<!--=========================
\begin{equation}
\left(\frac{B_i^0}{\mu_1}-\frac{B_r^0}{\mu_1}\right) \cos \theta_1= \frac{B_t^0}{\mu_2} \cos \theta_2
\end{equation}
==========================-->

En revenant à la définition des champs magnétiques d'une onde plane ($\displaystyle \vec{B}=\frac{\vec{k}}{w} \wedge \vec{E}$), il vient:

$`B_i^0 & = & \frac{n_1E_i^0}{c} `$
$` B_r^0 & = & \frac{n_1E_r^0}{c}`$
$`B_t^0 & = & \frac{n_2E_t^0}{c}.
\end{eqnarray* `$
<!--=========================
\begin{eqnarray*}
B_i^0 & = & \frac{n_1E_i^0}{c}\\
B_r^0 & = & \frac{n_1E_r^0}{c}\\
B_t^0 & = & \frac{n_2E_t^0}{c}.
\end{eqnarray*} 
==========================-->

Nous obtenons donc un système à deux équations à deux inconnues:

$` E_i^0+E_r^0 = E_t^0\\
  \,  \frac{n_1}{\mu_1} \left(E_i^0-E_r^0\right) \cos \theta_1 =\frac{n_2}{\mu_2}E_t^0 \cos \theta_2 `$
<!--=========================
\begin{equation*}
  \left\{
    \begin{aligned}
     & E_i^0+E_r^0 = E_t^0\\
  &  \frac{n_1}{\mu_1} \left(E_i^0-E_r^0\right) \cos \theta_1 =\frac{n_2}{\mu_2}E_t^0 \cos \theta_2\\
    \end{aligned}.
  \right.
\end{equation*}  
==========================-->

En définissant les coefficients de réflexion et de transmission en mode TE, de la manière suivante:

$`r_{\perp}=\frac{E^0_r}{E^0_i},~~t_{\perp}=\frac{E^0_t}{E^0_i}`$
<!--=========================
\begin{equation}
r_{\perp}=\frac{E^0_r}{E^0_i},~~t_{\perp}=\frac{E^0_t}{E^0_i},
\end{equation}
on montre facilement que les coefficients de Fresnel pour le mode TE s'écrivent:
\begin{equation}
  \left\{
    \begin{aligned}
     & r_{\perp}= \displaystyle \frac{\displaystyle \frac{n_1}{\mu_1}\cos \theta_1-\frac{n_2}{\mu_2}\cos \theta_2}{\displaystyle \frac{n_1}{\mu_1}\cos \theta_1+\frac{n_2}{\mu_2}\cos \theta_2}\\
  &  t_{\perp}= \displaystyle \frac{\displaystyle\frac{\displaystyle 2 n_1}{\mu_1}\cos \theta_1}{\displaystyle\frac{n_1}{\mu_1}\cos \theta_1+\frac{n_2}{\mu_2}\cos \theta_2}\\
    \end{aligned}.
  \right.
\end{equation}  
==========================-->


\underline{Remarques}:

$` `$
<!--=========================
 \begin{itemize}
 \item Dans le cas de milieux non magnétiques, on a une simplification des relations avec $\mu_1=\mu_2=\mu_0$.
\item on a  $t_\perp > 0$,  mais $r_\perp$ peut être positif ou négatif.\\
Si $\epsilon_1>\epsilon_2$, alors $\theta_1 < \theta_2$ donc $\cos \theta_1 > \cos \theta_2$,\\
Si $\epsilon_1<\epsilon_2$, alors $\theta_1 > \theta_2$ donc $\cos \theta_1 < \cos \theta_2$. 
\item Le symbole $\perp$ est utilisé pour désigner le mode TE ($\vec{E}$ est perpendiculaire au plan d'incidence).
\end{itemize}
==========================-->
  
##### Cas d'une onde incidente TM (polarisée dans le plan d'incidence

![mode-TM_imprim_L1200.jpg](mode-TM_imprim_L1200.jpg)

<!--=========================
 \begin{figure}[!h]
\begin{center}
\includegraphics[width=0.6\columnwidth, trim=0 0 0 0,clip]{Chap-interf/Fig/mode-TM.pdf} 
\end{center}
\caption{Configuration des champs é.m pour le mode TM.}
\label{fig:mode-TM}
\end{figure}
==========================-->
 
A partir des expressions des vecteurs $\vec{B}$, dans le système d'axe $(0xyz)$, et grâce à la continuité de la composante tangentielle de $\vec{H}$, il vient facilement que :

$`\frac{B_i^0-B_r^0}{\mu_1}=\frac{B_t^0}{\mu_2} `$
<!--=========================
\begin{equation}
\frac{B_i^0-B_r^0}{\mu_1}=\frac{B_t^0}{\mu_2}.
\end{equation}
==========================-->

La continuité de la composante tangentielle de $\vec{E}$ donne:

$` \left(E_i^0+E_r^0\right)\cos \theta_1=E_t^0\cos \theta_2`$
<!--=========================
\begin{equation}
\left(E_i^0+E_r^0\right)\cos \theta_1=E_t^0\cos \theta_2.
\end{equation}
==========================-->

Comme nous avons toujours $\displaystyle B_i^0=\frac{n_1 E^0_i}{c}$, $\displaystyle B_r^0=\frac{n_1 E^0_r}{c}$ et $\displaystyle B_t^0=\frac{n_1 E^0_t}{c}$, il vient:

$`\frac{n_1}{\mu_1}\left(E_i^0-E_r^0\right)=\frac{n_2}{\mu_2}E_t^0 `$
<!--=========================
\begin{equation*}
\frac{n_1}{\mu_1}\left(E_i^0-E_r^0\right)=\frac{n_2}{\mu_2}E_t^0.
\end{equation*}
==========================-->

Avec le système d'équations suivant:

$` \left(E_i^0+E_r^0\right)\cos \theta_1 = E_t^0 \cos \theta_2\\
  \,  \frac{n_1}{\mu_1} \left(E_i^0-E_r^0\right) =\frac{n_2}{\mu_2}E_t^0`$
<!--=========================
\begin{equation*}
  \left\{
    \begin{aligned}
     & \left(E_i^0+E_r^0\right)\cos \theta_1 = E_t^0 \cos \theta_2\\
  &  \frac{n_1}{\mu_1} \left(E_i^0-E_r^0\right) =\frac{n_2}{\mu_2}E_t^0\\
    \end{aligned}.
  \right.
\end{equation*} 
==========================-->

on montre facilement que les coefficients de Fresnel pour le mode TM s'écrivent:

$`  & r_{\parallel}= \displaystyle \frac{\displaystyle \frac{n_1}{\mu_1}\cos \theta_2-\frac{n_2}{\mu_2}\cos \theta_1}{\displaystyle \frac{n_2}{\mu_2}\cos \theta_1+\frac{n_1}{\mu_1}\cos \theta_2}`$

$` & t_{\parallel}= \displaystyle \frac{\displaystyle\frac{\displaystyle 2 n_1}{\mu_1}\cos \theta_1}{\displaystyle\frac{n_2}{\mu_2}\cos \theta_1+\frac{n_1}{\mu_1}\cos \theta_2}`$
<!--=========================
\begin{equation}
  \left\{
    \begin{aligned}
     & r_{\parallel}= \displaystyle \frac{\displaystyle \frac{n_1}{\mu_1}\cos \theta_2-\frac{n_2}{\mu_2}\cos \theta_1}{\displaystyle \frac{n_2}{\mu_2}\cos \theta_1+\frac{n_1}{\mu_1}\cos \theta_2}\\
  &  t_{\parallel}= \displaystyle \frac{\displaystyle\frac{\displaystyle 2 n_1}{\mu_1}\cos \theta_1}{\displaystyle\frac{n_2}{\mu_2}\cos \theta_1+\frac{n_1}{\mu_1}\cos \theta_2}\\
    \end{aligned}.
  \right.
\end{equation} 
==========================-->
    
! *Remarques :*
!
! Le symbole $\parallel$ est utilisé pour désigner le mode TM ($\vec{E}$ est contenu dans le  plan d'incidence).
\subsection{Bilan énergétique}
! Les pouvoirs de réflexion $R$ et de transmission $T$ sont quant à eux définis par:
!
! \begin{equation}
R= \frac{\mathcal{P}_r}{\mathcal{P}_i}=\frac{\vert\vert\langle\vec{\Pi}_r\rangle\vert\vert}{\vert\vert\langle\vec{\Pi}_i\rangle\vert\vert},
\end{equation}
\begin{equation}
!
! T= \frac{\mathcal{P}_t}{\mathcal{P}_i}=\frac{\vert\vert\langle\vec{\Pi}_t\rangle\vert\vert}{\vert\vert\langle\vec{\Pi}_i\rangle\vert\vert}.
\end{equation} 

Dans le cas de la propagation en mode TE, on a:

$` `$
<!--=========================
\begin{equation}
  \left\{
    \begin{aligned}
     & R_{\perp}= \displaystyle \frac{\vert\vert\vec{E}_r^0\vert\vert^2}{\vert\vert\vec{E}^0_i\vert\vert^2}=r_\perp^2\\
  & T_{\perp}=\displaystyle \frac{n_2}{n_1}\frac{\vert\vert\vec{E}_t^0\vert\vert^2}{\vert\vert\vec{E}^0_i\vert\vert^2}=\frac{n_2}{n_1}t_\perp^2\\
    \end{aligned}.
  \right.
\end{equation}
==========================-->

Dans le cas de la propagation en mode TM, on a:

$` `$
<!--=========================
\begin{equation}
  \left\{
    \begin{aligned}
     & R_{\parallel}= \displaystyle \frac{\vert\vert\vec{E}_r^0\vert\vert^2}{\vert\vert\vec{E}^0_i\vert\vert^2}=r_\parallel^2\\
  & T_{\parallel}=\displaystyle \frac{n_2}{n_1}\frac{\vert\vert\vec{E}_t^0\vert\vert^2}{\vert\vert\vec{E}^0_i\vert\vert^2}=\frac{n_2}{n_1}t_\parallel^2\\
    \end{aligned}.
  \right.
\end{equation}
==========================-->

\underline{Remarque}:\\

On vérifie bien la conservation de l'énergie, en montrant que $R+T=1$.   

### Application à la réflexion métallique sous incidence quelconque

Nous allons étudier la réflexion oblique d'une onde polarisée rectilignement sur une interface diélectrique (air) conducteur parfait. Le milieu diélectrique aura un indice optique $n$. Ces calculs serviront de base pour le chapitre suivant, puisque  nous retrouverons ces configurations dans le cas des guides d'onde métalliques rectangulaires.
Encore une fois nous traiterons deux cas: lorsque le champ électrique sera perpendiculaire au plan d'incidence (Mode TE), ou bien le champ magnétique perpendiculaire au plan d'incidence (Mode TM).
   
\subsubsection{Mode TE}

![Met-obl-TE_imprim_L1200.jpg](Met-obl-TE_imprim_L1200.jpg)

<!--=========================
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 \begin{figure}[!h]
\begin{center}
\includegraphics[width=0.6\columnwidth, trim=0 0 0 0,clip]{Chap-interf/Fig/Met-obl-TE.pdf} 
\end{center}
\caption{Configuration des champs é.m pour le mode TE.}
\label{fig:metobl-TE}
\end{figure}
==========================-->
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Dans la configuration de la Fig.(\ref{fig:metobl-TE}), le champ électrique incident s'écrit: $\displaystyle \underline{\vec{E}}_i=-E_0~\vec{u}_x~{\textrm{e}}^{i\left(\vec{k}_i.\vec{r}-\omega t\right)}$. Avec les vecteurs d'onde:

$` `$
<!--=========================
\begin{center}
\begin{minipage}[c]{.45\columnwidth}
\begin{equation*}
\vec{k}_i=\left\vert \begin{array}{c}
0 \\
\\
-k \cos \theta \\
\\
k \sin \theta
\end{array}, \right. 
\end{equation*}
\end{minipage}
\begin{minipage}[c]{.45\columnwidth}
\begin{equation*}
\vec{k}_r=\left\vert \begin{array}{c}
0 \\
\\
k \cos \theta \\
\\
k \sin \theta
\end{array}, \right. 
\end{equation*}
\end{minipage}
\end{center}

où $\displaystyle k= n\frac{\omega}{c}$, le champ électrique incident vaut donc:

$`\underline{\vec{E}}_i=-E_0~\vec{u}_x~\displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)} `$
\begin{equation}
\underline{\vec{E}}_i=-E_0~\vec{u}_x~\displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)}.
\end{equation}
==========================-->

Ayant choisi pour onde incidente une onde plane, on peut déterminer $\underline{\vec{B}}_i$, avec  
$\underline{\vec{B}}_i=\displaystyle \frac{\vec{k}_i\wedge\underline{\vec{E}}_i }{\omega}$, 
ce qui donne:

$`\underline{\vec{B}}_i=\left\vert \begin{array}{c} `$
<!--=========================
\begin{equation}
\underline{\vec{B}}_i=\left\vert \begin{array}{c}
0 \\
\\
 \displaystyle-\frac{nE_0}{c} \sin \theta ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)}\\
\\
 \displaystyle-\frac{nE_0}{c} \cos \theta ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)}\\
\end{array}, \right. 
\end{equation}
==========================-->

En écrivant le vecteur $\underline{\vec{E}}_r= \vec{E}_r^0 \displaystyle {\textrm{e}}^{i\left(\vec{k}_r.\vec{r}-\omega t\right)}$, et du fait de la continuité de la composante tangentielle de $\vec{E}$, en $y=0$, il vient facilement que $E_{r_z}=0$. Du fait de la continuité de la composante normale de $\vec{E}$, on a aussi $E_{r_y}=0$. Il nous reste à utiliser la continuité de la composante tangentielle de $\vec{E}$ suivant $(Ox)$ pour obtenir:

$` E_{r_x}+E_{i_x}=0`$
<!--=========================
\begin{equation}
E_{r_x}+E_{i_x}=0.
\end{equation}
==========================-->

Cela donne pour l'onde réfléchie un champ électrique:

$`\underline{\vec{E}}_r=E_0~\vec{u}_x~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)} `$
<!--=========================
\begin{equation}
\underline{\vec{E}}_r=E_0~\vec{u}_x~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)}.
\end{equation}
==========================-->

L'onde réfléchie possédant le caractère d'onde plane, avec la formule $\displaystyle \underline{\vec{B}}_r=\frac{\vec{k}_r}{w} \wedge \underline{\vec{E}}_r$, on peut écrire:

$` `$
<!--=========================
\begin{equation}
\underline{\vec{B}}_r=\left\vert \begin{array}{c}
0 \\
\\
 \displaystyle \frac{nE_0}{c} \sin \theta ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)}\\
\\
 \displaystyle-\frac{nE_0}{c} \cos \theta ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)}\\
\end{array}. \right. 
\end{equation}
==========================-->

Nous sommes en mesure de regarder la nature du champ é.m  résultant du mode TE ($\underline{\vec{E}}_\perp$, $\underline{\vec{B}}_\perp$) dans le milieu diélectrique avec $\underline{\vec{E}}_\perp=\underline{\vec{E}}_i+\underline{\vec{E}}_r$, et $\underline{\vec{B}}_\perp=\underline{\vec{B}}_i+\underline{\vec{B}}_r$. Concernant le champ électrique nous avons:

$`\underline{\vec{E}}_\perp=E_0~\vec{u}_x~\left(\displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)} - \displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)}\right) `$
<!--=========================
\begin{equation*}
\underline{\vec{E}}_\perp=E_0~\vec{u}_x~\left(\displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)} - \displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)}\right),
\end{equation*}
==========================-->

$`\underline{\vec{E}}_\perp=2~i~E_0~\vec{u}_x~\sin\left(ky \cos \theta\right)\displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)} `$
<!--=========================
\begin{equation}
\underline{\vec{E}}_\perp=2~i~E_0~\vec{u}_x~\sin\left(ky \cos \theta\right)\displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}.
\end{equation}
==========================-->

Pour le champ magnétique résultant, nous obtenons après quelques lignes:

$` `$
<!--=========================
\begin{equation}
\underline{\vec{B}}_\perp=\left\vert \begin{array}{c}
0 \\
\\
2i \displaystyle \frac{nE_0}{c} \sin \theta \sin\left(k y\cos \theta \right)~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}\\
\\
 -2\displaystyle\frac{nE_0}{c} \cos \theta \cos\left(k y\cos \theta \right) ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}\\
\end{array}. \right. 
\end{equation}
==========================-->

Ce champ é.m total possède quelques propriétés intéressantes:

<!--=========================
\begin{itemize}
\item il se propage suivant l'axe $(Oz)$
\item il se propage à la même pulsation $\omega$ que l'onde incidente
\item le champ électrique résultant est polarisé rectilignement (mode TE)
\item le champ magnétique possède une composante suivant la direction de propagation $(Oz)$ 
\item il n'est plus une onde plane
\item dans un plan $y=\textrm{Cste}$, le champ magnétique est polarisé elliptiquement
\item la vitesse de phase est donnée par $\displaystyle v_\varphi=\frac{c}{n \sin \theta}\geq c$.
\end{itemize}
\vspace{0.5cm}
==========================-->
 
 Au voisinage immédiat de l'interface, pour $y \to 0$ on a :
 
<!--=========================
 \begin{itemize}
 \item $\underline{\vec{E}}_\perp=\vec{0}$
 \item $\underline{\vec{B}}_\perp=\displaystyle -\frac{2 n E_0}{c} \vec{u}_z\cos \theta ~\displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}$, le champ magnétique est tangent à la surface et orienté suivant la direction de propagation.
\end{itemize}
\vspace{0.5cm}
==========================-->

Ailleurs dans le diélectrique, on observe un régime d'onde stationnaire dans la direction normale à l'interface. Il nous est donc possible de déterminer les surfaces d'équi-amplitudes dans la direction $(0y)$, en recherchant les plans nodaux ou ventraux, c'est à dire les maxima (ventres) et minima (noeuds) de l'onde résultante grâce à:

<!--=========================
\begin{itemize}
\item $\underline{\vec{E}}_\perp=\vec{0}$, pour $\displaystyle y_n=\frac{n \pi}{k \cos \theta}$, $n$ entier
\item   $\vert\vert \underline{\vec{E}}_\perp\vert\vert=\vert\vert\vec{E}_{\textrm{max}}\vert\vert$, pour $\displaystyle y_p=\frac{(2p+1)\pi}{k \cos \theta}$, $p$ entier.
\end{itemize} 
==========================-->

Dans une direction quelconque, on observera un régime d'ondes semi-stationnaires seulement. 

Afin d'étudier la propagation de l'énergie, calculons les champs résultants réels:

$` \vec{E}_\perp=-2~E_0~\vec{u}_x~\sin\left(ky \cos \theta\right)~\sin\left(k z \sin \theta -\omega t\right)`$
<!--=========================
\begin{equation}
\vec{E}_\perp=-2~E_0~\vec{u}_x~\sin\left(ky \cos \theta\right)~\sin\left(k z \sin \theta -\omega t\right),
\end{equation} 
==========================-->
 
 $` `$
<!--=========================
\begin{equation}
\vec{B}_\perp=\left\vert \begin{array}{c}
0 \\
\\
-2 \displaystyle \frac{nE_0}{c} \sin \theta \sin\left(k y\cos \theta \right)~ \sin \left(k z \sin \theta -\omega t\right)\\
\\
 -2\displaystyle\frac{nE_0}{c} \cos \theta \cos\left(k y\cos \theta \right) ~ \cos\left(k z \sin \theta -\omega t\right)\\
\end{array}. \right. 
\end{equation}
==========================-->

Le calcul du vecteur de Poynting donne à partir de $\displaystyle\vec{\Pi}=\frac{\vec{E}_{\perp}\wedge \vec{B}_\perp}{\mu_0}$,

$` `$
<!--=========================
\begin{equation}
\vec{\Pi}=\left\vert \begin{array}{c}
0 \\
\\
- \displaystyle \frac{nE_0^2}{\mu_0 c} \cos \theta \sin\left(2 k y\cos \theta \right)~ \sin \left(2\left(k z \sin \theta -\omega t\right)\right)\\
\\
 4\displaystyle\frac{nE_0^2}{\mu_0 c} \sin \theta \sin^2\left(k y\cos \theta \right) ~ \sin^2\left(k z \sin \theta -\omega t\right)\\
\end{array}. \right. 
\end{equation}
==========================-->

Enfin pour déterminer la puissance active, il ne reste plus qu'à prendre la valeur moyenne sur une période du vecteur $\vec{\Pi}$, ce qui amène:

$`\langle\vec{\Pi}\rangle_T=\frac{2 E_0^2 n}{\mu_0 c} \sin \theta \sin^2\left(k y\cos \theta \right) \vec{u}_z `$
<!--=========================
\begin{equation}
\langle\vec{\Pi}\rangle_T=\frac{2 E_0^2 n}{\mu_0 c} \sin \theta \sin^2\left(k y\cos \theta \right) \vec{u}_z
\end{equation}
==========================-->

La puissance active se propage donc suivant la direction de propagation de l'onde, c'est à dire suivant $(0z)$.

\underline{Remarque}:\\
Elle est nulle en $y=0$.

#### Mode TM
 
Le champ électrique est maintenant contenu dans le plan d'incidence, c'est le champ magnétique qui se trouve être perpendiculaire au plan d'incidence, cf Fig.~(\ref{fig:metobl-TM}).

Les vecteurs d'ondes associés au champ é.m incident et réfléchi s'écrivent:

$` `$
<!--=========================
\begin{center}
\begin{minipage}[c]{.45\columnwidth}
\begin{equation*}
\vec{k}_i=\left\vert \begin{array}{c}
0 \\
\\
-k \cos \theta \\
\\
k \sin \theta
\end{array}, \right. 
\end{equation*}
\end{minipage}
\begin{minipage}[c]{.45\columnwidth}
\begin{equation*}
\vec{k}_r=\left\vert \begin{array}{c}
0 \\
\\
k \cos \theta \\
\\
k \sin \theta
\end{array},\right. 
\end{equation*}
\end{minipage}
\end{center}
==========================-->

où $\displaystyle k= n\frac{\omega}{c}$. Le champ é.m incident est composé de:

$` `$
<!--=========================
\begin{equation}
\underline{\vec{B}}_i=-\frac{nE_0}{c}\vec{u}_x~\displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)},
\end{equation}
et 
\begin{equation}
\underline{\vec{E}}_i=\left\vert \begin{array}{c}
0 \\
\\
 \displaystyle E_0 \sin \theta ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)}\\
\\
 \displaystyle E_0 \cos \theta ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)}\\
\end{array}. \right. 
\end{equation}
==========================-->


![Met-obl-TM_imprim_L1200](Met-obl-TM_imprim_L1200)
<!--=========================
 \begin{figure}[!h]
\begin{center}
\includegraphics[width=0.6\columnwidth, trim=0 0 0 0,clip]{Chap-interf/Fig/Met-obl-TM.pdf} 
\end{center}
\caption{Configuration des champs é.m pour le mode TM.}
\label{fig:metobl-TM}
\end{figure}
==========================-->

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


En écrivant le vecteur $\underline{\vec{E}}_r= \vec{E}_r^0 \displaystyle {\textrm{e}}^{i\left(\vec{k}_r.\vec{r}-\omega t\right)}$, et du fait de la continuité de la composante tangentielle de $\vec{E}$, en $y=0$, il vient facilement que $E_{r_x}=0$. Il nous reste à utiliser la continuité de la composante tangentielle de $\vec{E}$ suivant $(Oz)$ pour obtenir:

$` E_{r_z}+E_{i_z}=0`$
<!--=========================
\begin{equation}
E_{r_z}+E_{i_z}=0.
\end{equation}
De plus, le conducteur étant parfait, il n'y a pas d'onde transmise donc $\vert\vert\vec{E}_i\vert\vert=\vert\vert\vec{E}_r\vert\vert$. Avec les deux conditions précédentes, nous sommes en mesure d'écrire:
\begin{equation}
\underline{\vec{E}}_r=\left\vert \begin{array}{c}
0 \\
\\
 \displaystyle E_0 \sin \theta ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)}\\
\\
 \displaystyle -E_0 \cos \theta ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)}\\
\end{array}. \right. 
\end{equation}
==========================-->

Cela donne pour l'onde réfléchie un champ magnétique:

$`\underline{\vec{B}}_r=-\displaystyle\frac{nE_0}{c}~\vec{u}_x~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)} `$
<!--=========================
\begin{equation}
\underline{\vec{B}}_r=-\displaystyle\frac{nE_0}{c}~\vec{u}_x~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)}.
\end{equation}
==========================-->

Nous sommes en mesure de regarder la nature du champ é.m  résultant du mode TM ($\underline{\vec{E}}_\parallel$, $\underline{\vec{B}}_\parallel$) dans le milieu diélectrique avec $\underline{\vec{E}}_\parallel=\underline{\vec{E}}_i+\underline{\vec{E}}_r$, et $\underline{\vec{B}}_\parallel=\underline{\vec{B}}_i+\underline{\vec{B}}_r$. Concernant le champ magnétique nous avons:

$`\underline{\vec{B}}_\parallel=-\displaystyle \frac{nE_0}{c}~\vec{u}_x~\left(\displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)} + \displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)}\right) `$

$`\underline{\vec{B}}_\parallel=-2\frac{nE_0}{c}~\vec{u}_x~\cos\left(ky \cos \theta\right)\displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}`$

<!--=========================
\begin{equation*}
\underline{\vec{B}}_\parallel=-\displaystyle \frac{nE_0}{c}~\vec{u}_x~\left(\displaystyle{\textrm{e}}^{\displaystyle i\left(k y \cos \theta + k z \sin \theta -\omega t\right)} + \displaystyle{\textrm{e}}^{\displaystyle i\left(- k y \cos \theta + k z \sin \theta -\omega t\right)}\right),
\end{equation*}

\begin{equation}
\underline{\vec{B}}_\parallel=-2\frac{nE_0}{c}~\vec{u}_x~\cos\left(ky \cos \theta\right)\displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}.
\end{equation}
==========================-->

Pour le champ électrique résultant, nous obtenons après quelques lignes:

$` `$
<!--=========================
\begin{equation}
\underline{\vec{E}}_\parallel=\left\vert \begin{array}{c}
0 \\
\\
2 E_0 \sin \theta \cos\left(k y\cos \theta \right)~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}\\
\\
 -2 i E_0 \cos \theta \sin\left(k y\cos \theta \right) ~ \displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}\\
\end{array}. \right. 
\end{equation}
=========================-->

Ce champ é.m total possède quelques propriétés intéressantes:

<!--=========================
\begin{itemize}
\item il se propage suivant l'axe $(Oz)$
\item il se propage à la même pulsation $\omega$ que l'onde incidente
\item le champ magnétique résultant est polarisé rectilignement (mode TM)
\item le champ électrique possède une composante suivant la direction de propagation $(Oz)$ 
\item il n'est plus une onde plane
\item dans un plan $y=\textrm{Cste}$, le champ électrique est polarisé elliptiquement
\item la vitesse de phase est donnée par $\displaystyle v_\varphi=\frac{c}{n \sin \theta}\geq c$.
\end{itemize}
\vspace{0.5cm}
==========================-->
 
 Au voisinage immédiat de l'interface, pour $y \to 0$ on a :
 
 $` `$
<!--=========================
 \begin{itemize}
 \item $\underline{\vec{E}}_\parallel=2~E_0~\vec{u}_y~ \sin \theta ~\displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}$, le champ électrique est normale à la surface métallique.
 \item $\underline{\vec{B}}_\parallel=\displaystyle -\frac{2 n E_0}{c} \vec{u}_x~\displaystyle{\textrm{e}}^{\displaystyle i\left(k z \sin \theta -\omega t\right)}$, le champ magnétique est tangent à la surface et transverse.
\end{itemize}
\vspace{0.5cm}
==========================-->

Ailleurs dans le diélectrique, on observe un régime d'onde stationnaire dans la direction normale à l'interface. Il nous est donc possible de déterminer les surfaces d'équi-amplitudes dans la direction $(0y)$, en recherchant les plans nodaux ou ventraux, c'est à dire les maxima (ventres) et minima (noeuds) de l'onde résultante grâce à:

$` `$
<!--=========================
\begin{itemize}
\item $\underline{\vec{B}}_\parallel=\vec{0}$, pour $\displaystyle y_n=\frac{(2n+1) \pi}{2 k \cos \theta}$, $n$ entier
\item   $\vert\vert \underline{\vec{B}}_\parallel\vert\vert=\vert\vert\vec{B}_{\textrm{max}}\vert\vert$, pour $\displaystyle y_p=\frac{p\pi}{k \cos \theta}$, $p$ entier.
\end{itemize} 
==========================-->

Dans une direction quelconque, on observera un régime d'onde semi-stationnaires seulement.

Afin d'étudier la propagation de l'énergie, calculons la valeur moyenne sur une période du vecteur de Poynting:

$`\langle\vec{\Pi}\rangle_T=\frac{2 E_0^2 n}{\mu_0 c} \sin \theta \cos^2\left(k y\cos \theta \right) \vec{u}_z `$
<!--=========================
\begin{equation}
\langle\vec{\Pi}\rangle_T=\frac{2 E_0^2 n}{\mu_0 c} \sin \theta \cos^2\left(k y\cos \theta \right) \vec{u}_z
\end{equation}
==========================-->

La puissance active se propage donc suivant la direction de propagation de l'onde, c'est à dire suivant $(0z)$.

\underline{Remarque}:\\
Elle est maximale en $y=0$.

