---
title : "brainstorming electromagnetism"
published : false
visible : false
---

$`\def\oiint{\mathop{\vcenter{\mathchoice{\huge\unicode{x222F}\,}{\unicode{x222F}}{\unicode{x222F}}{\unicode{x222F}}}\,}\nolimits}`$


## DOCUMENTO BÁSICO DE TRABAJO / DOCUMENT DE TRAVAIL DE BASE / BASIC WORKING DOCUMENT

ES : Aqui, por el momento, solo las ecuaciones que usamos. Y comentarios de intercambios 
entre nosotros, para proponer ya e intercambiar sobre la estructuración final. 
No olvidemos que tomará 4 niveles, desde un nivel básico hasta el nivel pre-master.

FR : Ici, pour le moment, seulement les équations que nous utilisons. Et commentaires 
d'échanges entre nous, pour déjà proposer et échanger sur la structuration finale.
N'oublions pas qu'il faudra 4 niveaux, depuis un niveau de base jusqu'au niveau pre-master.

EN : Here, for the moment, only the equations we use. And comments of exchanges between us, 
to already propose and to exchange on the final structuring. WE must not forget that we
want a course in 4 levels, from a basic level to the pre-master level. 

------------------

## TERMINALOGÍA / TERMINOLOGIE / TERMINOLOGY

ES : Para la terminología, pongamos los términos científicos utilizados en nuestros países, pero agregando
y poner en el primer plano la terminología estándar multilingüe de la "Comisión Electrotécnica Internacional"
http://www.electropedia.org/
que da, para el electromagnetismo :
http://www.electropedia.org/iev/iev.nsf/index?openform&part=121

FR : Pour la terminologie, mettons les termes scientifiques utilisés dans nos pays, mais en rajoutant
et mettant en premier plan la terminologie normée multilingues de la "InternationalElectrotechnicalCommission"
http://www.electropedia.org/
ce qui donne, pour l'électromagnétisme :
http://www.electropedia.org/iev/iev.nsf/index?openform&part=121

EN : For the terminology, let's put the scientific terms used in our countries, but by adding
and highlighting the multilingual standard terminology of the "InternationalElectrotechnicalCommission"
http://www.electropedia.org/
which gives, for electromagnetism :
http://www.electropedia.org/iev/iev.nsf/index?openform&part=121

**$`\overrightarrow{E}`$ :**  <br>
ES : intensidad de campo eléctrico <br>
FR : champ électrique  <br>
EN : electric field strength <br>
$`\vec{E}=\dfrac{\vec{F}}{q}`$ 

**$`\overrightarrow{D}`$ :**  <br>
ES : índucción eléctrica (= desplazamiento eléctrico) <br>
FR : induction électrique (= déplacement électrique) <br>
EN : electric flux density (= electric displacement) <br>
$`\vec{D}=\epsilon_0\;\vec{E}+\vec{P}`$ 

**$`\overrightarrow{P}`$ :**  <br>
ES : polarización eléctrica  <br>
FR : polarisation électrique  <br>
EN : electric polarization <br>
$`\vec{P}=\dfrac{\vec{p}}{\tau}`$ 

**$`\overrightarrow{p}`$ :**  <br>
ES : momento eléctrico  <br>
FR : moment électrique  <br>
EN : electric dipole moment <br>

**Campo magnético / Champ magnétique / Magnetic field** :  <br>
ES :
FR :
EN : 

**$`\overrightarrow{H}`$ :**  <br>
ES : intensidad de campo magnético <br>
FR : champ d'excitation magnétique = champ magnétique <br>
EN : magnetic field strength <br>
$`\overrightarrow{H}=\dfrac{\overrightarrow{B}}{\mu_0}- \overrightarrow{M}`$ <br>
$` \overrightarrow{H}=\overrightarrow{J_t}`$

**$`\overrightarrow{B}`$ :**  <br>
ES : densidad de flujo magnético = inducción magnética <br>
FR : champ d'induction magnétique <br>
EN : magnetic flux density = magnetic induction

**$`\overrightarrow{M}`$** = $`\overrightarrow{H_i}`$ :  <br>
ES : magnetización <br>
FR : aimantation  <br>
EN : magnetization

**$`\mu_0`$ :** <br>
ES : constante magnética = permeabilidad del vacío  <br>
FR : constante magnétique = perméabilité du vide <br>
EN : magnetic constant = permeability of vacuum

**$`\overrightarrow{J}`$** : <br>
ES : densidad de corriente (eléctrica) <br>
FR : densité de courant (électrique de conduction) <br>
EN : (conduction) current density = volumic electric current, volume corrent density <br>
$`\overrightarrow{J}=\dfrac{d\left(\sum_i q_i\;\overrightarrow{v_i}\right)}{d\tau}`$

**$`\overrightarrow{J}_s`$** ( non listé)<br>
ES : densidad de corriente superficial(eléctrica) <br>
FR : densité surfacique de courant (électrique)   <br>
EN : surface (electric) current density (= surfacic/areic?? electric current)  <br>

$`\overrightarrow{J_l}`$<br>
ES : densidad lineal de corriente (eléctrica) <br>
FR : densité linéique de courant (électrique)    <br>
EN : linear (electric) current density* = lineic (electric) current <br>

**$`\vec{J}_D`$** : <br>
ES : densidad de corriente de desplazamiento <br>
FR : densité de courant de déplacement  <br>
EN : displacement current density  <br>
$`\overrightarrow{J_D}=\dfrac{\partial D}{\partial t}`$

**$`\overrightarrow{J}_t`$** = $`\overrightarrow{J_{tot}}`$ : <br>
ES : densidad de corriente total <br>
FR : densité de courant total <br>
EN : total current density
$`\overrightarrow{J_t}=\overrightarrow{J}+\overrightarrow{J_D}`$

**$`\mu`$ :** <br>
ES : permeabilidad (absoluta) <br>
FR : perméabilité (absolue)   <br>
EN : (absolute) permeability <br>
$`\overrightarrow{B}=\mu\cdot\overrightarrow{H}`$

**$`\mu_r`$ :** <br>
ES : permeabilidad (relativa) <br>
FR : perméabilité (relative)   <br>
EN : relative permeability

ES : coordenada de un vector <br>
FR : cordonnée d'un vecteur <br>
EN : coordinate of a vector

$`\overrightarrow{U} \cdot \overrightarrow{V}`$ <br>
ES : producto escalar <br> 
FR : produit scalaire <br>
EN : scalar product (= dot product)

ES : orientación del espacio, triedro directo, triedro inverso <br>
FR : orientation de l'espace, trièdre direct, trièdre inverse (ou rétrograde ou  indirect ) <br>
EN : space orientation, right-handed trihedron, left-handed trihedron

$`\overrightarrow{U} \times \overrightarrow{V}`$ <br>
ES : producto vectorial (= producto externo) <br>
FR : produit vectoriel (=produit extérieur) , 
      $`U \land V`$ est déconseillé... <br>
EN : vector product

ES : contorno cerrado orientado <br>
FR : contour fermé, courbe fermée orientée <br>
EN : closed path, oriented closed curve <br>

ES : superficie cerrada <br>
FR : surface fermée <br>
EN : closed surface

$`\displaystyle\oiint \overrightarrow{V} \cdot \overrightarrow{dS}`$ , or  $`\displaystyle\iint \overrightarrow{V} \cdot \overrightarrow{dS}`$ <br> 
ES : flujo de un vector <br> 
FR : flux d'un vecteur <br>
EN : flux of a vector

$`\displaystyle\oint \overrightarrow{V} \cdot \overrightarrow{dr}`$ , or  $`\displaystyle\int \overrightarrow{V} \cdot \overrightarrow{dr}`$  <br>
ES : circulación de un vector <br>
FR : circulation d'un vecteur <br>
EN : circulation of a vector

$`dA = dx \, dy`$ <br>
ES : elemento escalar de superficie  <br>
FR : élément scalaire de surface (= surface élémentaire, surface infinitésimale) <br>
EN : scalar surface element

$`\overrightarrow{dA} = \overrightarrow{e_n}\;dA = \overrightarrow{n}\;dA `$ <br>
ES : elemento vectorial de superficie  <br>
FR : élément vectoriel de surface  <br>
EN : vector surface element

ES : vector axial / vector polar   <br>
FR : vecteur axial (= pseudo vecteur) / vecteur polaire (= vecteur vrai)   <br>
EN : axial vector (= space-oriented vector) / polar vector

ES : sistema de coordenadas cartesianas   <br>
FR : système de coordonnées cartésiennes   <br>
EN : Cartesian coordinate system

$`\nabla =\vec{e_x}\,\dfrac{\partial}{\partial x} + \vec{e_y}\,\dfrac{\partial}{\partial y}
+\vec{e_z}\,\dfrac{\partial}{\partial z}`$  
, or 
$`\nabla = \overrightarrow{e_x}\,\dfrac{\partial}{\partial x}+\overrightarrow{e_y}\,\dfrac{\partial}{\partial y}
+\overrightarrow{e_z}\,\dfrac{\partial}{\partial z}`$ 
, or more
$`\overrightarrow{\nabla} = \overrightarrow{e_x}\,\dfrac{\partial}{\partial x}+\overrightarrow{e_y}\,\dfrac{\partial}{\partial y}
+\overrightarrow{e_z}\,\dfrac{\partial}{\partial z} `$ <br>
ES : operador nabla   <br>
FR : opérateur nabla   <br>
EN : nabla operator


$`\overrightarrow{grad} f = \nabla f`$, $`\overrightarrow{\nabla}f`$ better, no?   <br>
ES : gradiente   <br>
FR : gradient   <br>
EN : gradient

$`div\;\overrightarrow{U}= \nabla \cdot \overrightarrow{U}`$ , $`div\;\overrightarrow{U}= \overrightarrow{\nabla} \cdot \overrightarrow{U}`$    <br>
ES : divergencia   <br>
FR : divergence   <br>
EN : divergence   <br>
$`div\;\overrightarrow{U}=\lim_{V\leftrightarrow0}\;\dfrac{1}{V}\;\displaystyle\oiint_{S\leftrightarrow V}\overrightarrow{U}\cdot\overrightarrow{dS}`$ 

$`rot\,\overrightarrow{U}`$, but $`\overrightarrow{rot}\,\overrightarrow{U}`$ better, no?   <br>
in some English texts : $`curl\times\overrightarrow{U}`$   <br>
$`\overrightarrow{\nabla}\times\overrightarrow{U}`$ or $`\overrightarrow{\nabla}\land\overrightarrow{U}`$    <br>
ES : rotacional de un vector  <br>
FR : rotationnel d'un vecteur   <br>
EN : rotation of a vector (= curl of a vector )


$`\Delta f = div\;\overrightarrow{grad}\,f `$, $`\Delta\,f = \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}f `$  <br>
ES : operador laplaciana escalar, laplaciana escalar, laplaciana de un campo escalar   <br>
FR : opérateur laplacien scalaire, laplacien scalaire, laplacien d'un champ scalaire  <br>
EN : laplacian operator, laplacian of a scalar field  <br>
ES : en coordenadas cartesianas ortonormalas<br>
FR : en coordonnées cartésiennes orthonormées :  <br>
EN : in orthonormal Cartesian coordinate :  <br>
$`\Delta = \dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$

$`\Delta\;\overrightarrow{U} = \overrightarrow{grad}\left( div\,\overrightarrow{U}\right) - \overrightarrow{rot}\left(\overrightarrow{rot}\,\overrightarrow{U}\right)`$   <br>
$`\Delta\;\overrightarrow{U} = \overrightarrow{grad}\;div\;\overrightarrow{U} - \overrightarrow{rot}\;\overrightarrow{rot}\;\overrightarrow{U}`$   <br>
ES : operador laplaciana vectorial, laplaciana vectorial, laplaciana de un campo vectorial   <br>
FR : opérateur laplacien, laplacien, d'un champ scalaire ou d'un champ vecoriel   <br>
EN : laplacian operator, vectorial laplacian, laplacian of a vector field <br>
in orthonormal Cartesian coordinate : <br>
$`\Delta\;\overrightarrow{U} = \overrightarrow{e_x}\left(\dfrac{\partial^2\;U_x}{\partial x^2}+\dfrac{\partial^2\;U_x}{\partial y^2}+\dfrac{\partial^2\;U_x}{\partial z^2}\right)
+\overrightarrow{e_y}\left(\dfrac{\partial^2\;U_y}{\partial x^2}+\dfrac{\partial^2\;U_y}{\partial y^2}+\dfrac{\partial^2\;U_y}{\partial z^2}\right)
+\overrightarrow{e_z}\left(\dfrac{\partial^2\;U_z}{\partial x^2}+\dfrac{\partial^2\;U_z}{\partial y^2}+\dfrac{\partial^2\;U_z}{\partial z^2}\right)`$ <br>

$`\Delta\;\overrightarrow{U} = \left |
   \begin{array} {r}
      \dfrac{\partial^2\;U_x}{\partial x^2}+\dfrac{\partial^2\;U_x}{\partial y^2}+\dfrac{\partial^2\;U_x}{\partial z^2} \\[4mm]
      \dfrac{\partial^2\;U_y}{\partial x^2}+\dfrac{\partial^2\;U_y}{\partial y^2}+\dfrac{\partial^2\;U_y}{\partial z^2} \\[4mm]
      \dfrac{\partial^2\;U_z}{\partial x^2}+\dfrac{\partial^2\;U_z}{\partial y^2}+\dfrac{\partial^2\;U_z}{\partial z^2}
   \end{array}
   \right.`$

$`\Delta\;\overrightarrow{U} = \left |   
\begin{matrix}
      \dfrac{\partial^2\;U_x}{\partial x^2}+\dfrac{\partial^2\;U_x}{\partial y^2}+\dfrac{\partial^2\;U_x}{\partial z^2} \\[4mm]
      \dfrac{\partial^2\;U_y}{\partial x^2}+\dfrac{\partial^2\;U_y}{\partial y^2}+\dfrac{\partial^2\;U_y}{\partial z^2} \\[4mm]
      \dfrac{\partial^2\;U_z}{\partial x^2}+\dfrac{\partial^2\;U_z}{\partial y^2}+\dfrac{\partial^2\;U_z}{\partial z^2} 
\end{matrix}
\right.`$

ES : escalar = número real o complexo + unidad de medida?   <br>
FR : scalaire = nombre réel ou complexe + unité de mesure   <br>
EN : scalar = real or complex number + measurement unit

ES : magnitud escalar = número real o complexo + unidad de medida?   <br>
FR : grandeur scalaire (= grandeur physique scalaire) = nombre réel ou complexe + unité de mesure   <br>
EN : scalar quantity = real or complex number + measurement unit


------------------------------

## INTERACCIONES MECÁNICAS NEWTONIANAS: FUERZAS Y CAMPOS (escalares y vectoriales) / INTERACTIONS EN MECANIQUE NEWTONIENNE : FORCES ET CHAMPS (scalaires et vectoriels) / INTERACTIONS in NEWTON's PHYSICS : FORCES AND FIELDS (scalar and vectorial)

....


## CAMPO ELÉCTRICO / CHAMP ELECTRIQUE / ELECTRIC FIELD

### El campo eléctrico y sus efectos inducidos / Le champ électrique et ses effets induits

#### Campo eléctrico y fuerza eléctrica inducida / Champ électrique et force électrique induite / Magnetic field and induced electric forces :

##### Observación de una fuerza eléctrica / Observation d'une force électrique / Observation of an electric force

##### Ley de Coulomb / Loi de Coulomb / Coulomb's law

##### Fuerza eléctrica ejercida sobre una carga eléctrica por un cable recto cargado uniformemente / Force électrique exercée sur une charge électrique par un fil rectiligne chargé uniformément / Electric force exerted on an electric charge by a uniformly charged straight wire

##### Fuerza eléctrica ejercida sobre una carga eléctrica por un plano infinito cargado uniformemente / Force électrique exercée sur une charge électrique par un plan infini chargé uniformément / Electric force exerted on an electric charge by a uniformly charged infinite plan

##### Momento o torque ejercido sobre un dipolo eléctrico / Moment ou couple exercé sur un dipôle électrique / Moment or torque exerted on an electric dipole 

##### Momento de dipolo eléctrico / Moment électrique dipôlaire / Electric dipole moment

##### Momentos eléctricos en la materia y polarización-1 / Moments électriques dans la matière et polarisation-1 / Electric moments in matter and polarisation-1

### El campo eléctrico y sus causas / Le champ électrique et ses causes / 

#### Origen del campo eléctrico: partícula elemental cargada eléctricamente / Origine du champ électrique : particule élémentaire chargée électriquement / Origin of the electric field: elementary particle having an electric charge



#### Origen de un campo eléctrico variable en el tiempo: un campo magnético variable en el tiempo / Origine d'un champ magnétique variable dans le temps : un champ électrique variable dans le temps / Origin of a magnetic field variable in time : an electric field variable in time


## CAMPO MAGNÉTICO / CHAMP MAGNETIQUE / MAGNETIC  FIELD

### El campo magnético y sus efectos inducidos / Le champ magnétique et ses effets induits

<!----Intercambio de ideas para construir juntos-----
------Echange d'idées pour construire ensemble-------

CM : Comience por descubrir el campo magnético por sus efectos inducidos observables? fortalezas, 
momentos y parejas? camino de partículas cargadas aislado?
=> campo de inducción magnética $`\vec{B}`$
Este podría ser un gran capítulo "El campo magnético y sus efectos inducidos"

Y después, ¿cómo creamos un campo magnético, las causas del campo magnético?
¿Y quizás presentar antes (como en muchos libros anglosajones) la distinción entre
$`\overrightarrow{H}`$ y $`\overrightarrow{B}`$ ? Será más fácil si ya hemos introducido el momento de B en un giro
con corriente y el momento magnético dipolo.
Tendremos que distinguir entre $`\overrightarrow{H}`$ y $`\overrightarrow{B}`$ en el nivel N3 o N4. 
Y nunca tenemos tiempo para explicarlo bien...
Este podría ser un gran capítulo "El campo magnético y sus causas"

Es solo una idea.

CM : On commence par introduire le champ magnétique par ses effets induits observables ?
Forces, moments et couples? trajectoire de cahrge isolée dans un champ B?
=> champ d'induction magnétique $`\overrightarrow{B}`$
Cela pourrait être un grand chapitre "Le champ magnétique et ses effets induits"

et après, parler de comment on créé un champ magnétique, les causes du champ magnétique?
Et peut-être introduire plus tôt (comme dans beaucoup de livres anglosaxons) la distinction
entre  $`\overrightarrow{H}`$ y $`\overrightarrow{B}`$? cela sera plus facile si on a déjà introduit le moment de
B sur une spire avec courant et le moment magnétique dipolaire.
On aura besoin de faire la distinction entre au niveau N3 ou N4. Et on a jamais le temps de bien l'expliquer..
Cela pourrait être un grand chapitre "Le champ magnétique et ses causes"

Seulement une idée

----------------------->

#### Campo magnética y fuerza magnética inducida / Champ magnétique er force magnétique induite / Magnetic field and induces magnetic forces :

##### Fuerza de Laplace / Force de Laplace / 
<!---------------------
¿Comenzar con la fuerza de Laplace en el nivel 2 porque está más cerca de la experiencia, 
luego reiniciarla desde la fuerza de Lorentz en el nivel 3?

Commencer par la force de Laplace au niveau 2 car plus proche de l'expérience? puis la redémontrer à partie de la Force de 
Lorentz au niveau 3?
----------------------->

* Fuerza magnética sobre un conductor por el cual circula una corriente
Force magnétique s'exerçant sur un conducteur parcouru par un courant
Magnetic force on a conductor carrying a current (through which a current flows?)

**Nivel N1 :**
<!----Intercambio de ideas para construir juntos-----
------Echange d'idées pour construire ensemble-------

CM : Creo que en el nivel 1, ya podemos representar una fuerza con una flecha
(y la palabra de vector) y la regla de la mano derecha. Creo que puedes hacer 
una foto con un imán, una placa de vidrio y limaduras de hierro, en la que las
limaduras de hierro no permanecen horizontalmente en la placa, sino que tienen
un componente vertical. Y puede ser divertido desde este nivel, tratar de entender
jugando con su mano derecha (regla de la mano derecha para la orientación del espacio).
¿qué piensa usted?

CM : Je pense que au niveau 1, on peut déjà représenter une force par une flèche
(et le mot de vecteur), et la règle de la main droite. Je pense qu'on peut réaliser 
une photo avec un aimant , une plaque de verre et de la limaille de fer, sur laquelle
la limaille de fer ne reste pas à l'horizontale sur la plaque, mais a une composante 
verticale. Et cela peut amuser dès ce niveau, d'essayer de comprendre en jouant avec 
sa main droite (règle de la main droite pour l'orientation de l'espace).
Qu'en pensez-vous?

CM : En este nivel, también se puede no hablar de estas fuerzas, y quedarse para
observar el comportamiento de los imanes y deducir un mínimo. ¿qué piensa usted?

CM On peut aussi à ce niveau ne pas parler de ces forces, et rester à observer
le comportement des aimants, et en déduire un minimum.Qu'en pensez-vous?

-------------------------------------------------->

**Nivel N2 :**
<!----Intercambio de ideas para construir juntos-----
------Echange d'idées pour construire ensemble-------

Sin cálculo diferencial en el nivel 2, debemos razonar con un cable recto de longitud L?
Producto vectorial o no, en el nivel 2? pero la regla de la mano derecha debe estar allí.

Sans calcul différentiel au niveau 2, nous devons raisonner avec un fil rectiligne de longueur L?
Produit vectoriel ou pas, au niveau 2? mais la règle de la main droite doit y être obligatoirement.

----------------------->

LA , EN : $`\overrightarrow{F}_{Lap}=I\;\overrightarrow{l}\times\overrightarrow{B}`$ <br>
FR : $`\overrightarrow{F}_{Lap}=I\;\overrightarrow{l}\land\overrightarrow{B}`$ 

o / ou 

$`\overrightarrow{F}_{Lap}`$ perpendicular a $`\overrightarrow{l}`$ y $`\overrightarrow{B}`$

con $`F=I \times L \times B`$

**Niveles N3 y N4 :**
<!----Intercambio de ideas para construir juntos-----
------Echange d'idées pour construire ensemble-------

Aquí tenemos el cálculo diferencial.

----------------------->

un élément infinitésimal $`\overrightarrow{dl}`$ d’un conducteur (dont la section est négligée) parcouru 
par un courant $`I`$, $`\overrightarrow{dl}`$  étant orienté dans le sens du courant $`I`$ :

LA , EN :
$`\overrightarrow{F}_{Lap}= I \; \overrightarrow{dl} \times \overrightarrow{B} `$   

FR :
$`\overrightarrow{F}_{Lap}=I\;\overrightarrow{dl}\land\overrightarrow{B}`$  

ES : Un Tesla (1T) es la Inducción Magnética para que una porción de cable conductor recto
rígido, perpendicular al campo magnético de un metro de longitud $`1m`$ y atravesado por una
corriente de intensidad de un amperio ($`1A`$) experimenta una fuerza lateral de un Newton ($`1N`$).

FR : Un tesla ($`1T`$) est l’induction magnétique pour laquelle une portion de fil conducteur rectiligne
rigide, perpendiculaire au champ magnétique de un mètre de longueur ($`1m`$) et parcouru par un courant
d’intensité un ampère ($`1A`$) expérimente une force latérale de un Newton ($`1N`$).

EN :

##### Fuerza de Lorentz / Force de Lorentz : 

**N1**

**N2**

**N3-N4**

ES : Para una carga punctual positiva $`q`$ se mueve con una velocidad $`\overrightarrow{v}`$ en un punto donde 
existe una Inducción Magnética $`\overrightarrow{B}`$ :

FR : Pour une particule ponctuelle de charge électrique  $`q`$ et de vecteur vitesse $`\vec{v}`$ située 
en un point où règne le champ d’induction magnétique $`\overrightarrow{B}`$  :

EN : For a point particle of electric charge $`q`$ and velocity vector $`\overrightarrow{v}`$ located at a point where
previals an magnetic field induction $`\overrightarrow{B}`$  :

LA , EN : $`\overrightarrow{F}_{Lor} = q \;\overrightarrow{v} \times \overrightarrow{B}`$ 

FR : $`\overrightarrow{F}_{Lor} = q \;\overrightarrow{v}\land\overrightarrow{B}`$

ES : Un Tesla ($`1T`$) es la Inducción Magnética para que una carga de un Coulomb ($`1C`$)  que se mueve
con una velocidad de ($`1\,ms^{-1}`$) experimente una fuerza lateral de un Newton ($`1N`$) .

FR : Un tesla ($`1T`$) est l’induction magnétique pour laquelle une charge de un Coulomb ($`1C`$) 
qui se meut à la vitesse de un mètre par seconde ($`1\,ms^{-1}`$) expérimente une force latérale 
de un Newton ($`1N`$).

EN : One tesla ($`1T`$) is the magnetic field induction for which a charge of a Coulomb (1C)
which moves at the speed of one meter per second ($`1\,ms^{-1}`$) experiences a lateral force
of a Newton ($`1N`$).

##### Fuerza magnética sobre un conductor por el cual circula una corriente / Force magnétique sur un conducteur parcouru par un courant / Magnetic force on a conducting wire carrying a current 

**N1 :** 
<!-- nada a decir, probablemente / rien à dire probablement-->

**N2 :**

**N3/N4 :**

##### Momento o torque magnético sobre una espira con corriente / Moment ou couple exercé sur une spire parcouru par un courant / Moment or torque exerted on a current carrying coil 

**N1 :** 
<!-- si, ya como ilustración, tener una primera idea de la Resonancia Magnética Nuclear Médica ?-->

**N2 :**

**N3/N4 :**

##### Momento de dipolo magnético / Moment magnétique dipôlaire / Magnetic dipole moment


##### Momentos magnéticos en la materia y magnetización-1 / Moments magnétiques dans la matière et aimantation-1 / Magnetic moments in matter and magnetization-1

<!----Intercambio de ideas para construir juntos-----
------Echange d'idées pour construire ensemble-------

CM : En el nivel N2, que sigue siendo básico, el joven está más interesado en los efectos y :<br>
- los nombres de los capítulos tienen las palabras "fuerzas", "momento", "pareja",
y en estos capítulos se presentan los conceptos y las palabras asociadas del campo de inducción magnética
, momento dipolar magnético, ...
Y en los niveles N3 y N4, los conceptos útiles deben ser entendidos y asimilados para ser utilizados, y :
- los nombres de los capítulos tratan más sobre los conceptos, con las palabras: campo de inducción magnética
, momento dipolar magnético, spin, ...
No sé, solo un idea. ¿qué piensa usted?

CM :  Au niveau N2, qui est encore basique, le jeune est plus intéressé par les effets, et :
- les noms de chapitres ont les mots "forces", "moment", "couple", et dans ces chapitres sont introduites
les notions et mots associés de champ d'induction magnétique, moment dipolaire magnétique.
Et aux niveaux N3 et N4, les concepts utiles doivent être compris et assimilés pour être utilisés, et :
- les noms de chapitres sont plus sur les concepts, avec les mots : champ d'induction magnétique, 
moment dipolaire magnétique, spin ...
Je ne sais pas. Qu'en pensez-vous?

----------------------->

**N1 :**
<!-- nada a decir, probablemente / rien à dire probablement-->

**N2 :**

**N3/N4 :**


##### Trayectoria de una carga eléctrica aislada en un campo magnético / Trajectoire d'une charge électrique isolée dans un champ magnétique / Trajectory of an isolated electric charge in a magnetic field

**N1 :**

**N2 :**

**N3/N4 :**




### El campo magnético y sus causas / Le champ magnétique et ses causes

#### Origen del campo magnético: elemento infinitesimal de corriente / Origine du champ magnétique : élément infinitésimal de courant / Origin of the magnetic field: infinitesimal element of current

##### Elemento infinitesimal de corriente / Elément infinitésimal de courant / Infinitesimal element of current
 
LA : Carga eléctrica puntual móvil o lemento infinitesimal de corriente (dependiendo del zoom, pero que puede
siempre ser considerado puntual por el observador):
  
ES : Particule chargée ponctuelle mobile, ou élément infinitésimal de courant (selon le zoom, mais toujours pouvant 
être considéré comme ponctuel par l'observateur) : 
 
 $`q\cdot\overrightarrow{v}\;\equiv\; I\cdot\overrightarrow{dl}\;\;\equiv\;\overrightarrow{j}\cdot d\tau`$
 
ES : 
$`q`$ : carga eléctrica de la partícula puntual
$`\overrightarrow{v}`$ : vector velocidad de la partícula puntual
$`I`$ : intensidad de corriente eléctrica en un cable de sección despreciable
$`\overrightarrow{dl}`$ : Diferencial de longitud del conductor en la dirección de la corriente
$`d\tau`$ : Diferencial de volumen  $`\overrightarrow{j}`$
$`\overrightarrow{j}`$ : Vector de densidad volumétrica de corriente en la diferencial de volumen.

FR :
$`q`$ : charge électrique de la particule ponctuelle
$`\overrightarrow{v}`$ : vecteur vitesse de la particule ponctuelle
$`I`$ : intensité de courant électrique dans le fil conducteur de section négligeable
$`\overrightarrow{dl}`$ : élément infinitésimal de longueur en direction du courant électrique.
$`d\tau`$ : volume infinitésimal  $`\vec{j}`$
$`\overrightarrow{j}`$ : vecteur densité volumique de courant dans le volume infinitésimal. 

EN :
$`q`$ : electric charge of the point particule
$`\overrightarrow{v}`$ : velocity vector of the point particule
$`I`$ : intensity of the electrical current in the wire of negligible section
$`\overrightarrow{dl}`$ : differential length element in the wire in direction of the current 
$`d\tau`$ : differential volume element.  $`\vec{j}`$
$`\overrightarrow{j}`$ : vector volume density of current in the differential volume element.
 
##### Dimensión y unidad de medida S.I. / Dimension et unité de mesure S.I. / Dimension and unit of measure S.I.

ES : Ecuaciones dimensionales (Análisis dimensional)   <br>
FR : Equations aux dimensions (analyse dimensionnelle) <br>
EN : Dimensional equations (dimensional analysis)   
 
$`[q \cdot v]=[q]\cdot[v] = [q]\cdot L \cdot T^{-1} = ([q]\cdot T^{-1}) \cdot L = I \cdot L`$

$`[I \cdot L]= I \cdot L`$

$`[j \cdot \tau]=[j]\cdot L^3 = I \cdot L^{-2} \cdot L^3 = I \cdot L`$

ES : Unidad del elemento infinitesimal de corriente en el Sistema Internacional de Unidades (S.I.)  <br>
FR : Unité de l'élément infinitésimal de courant dans le Système International d'unités (S.I.)      <br>
EN : Unit of the infinitesimal element of current in the International System of Units (S.I.)


S.I. : $`A \cdot m`$


#### Ley de Biot y Savart: ley física que conecta el campo magnético con sus causas / Loi de Biot & Savart : loi physique reliant le champ magnétique à ses causes / Biot-Savart's law : physical law connecting the magnetic field to its causes

**N1**

**N2**

**N3-N4**


EN : $`\overrightarrow{dH}_M=\dfrac{1}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}_P\times\overrightarrow{PM}}{||\overrightarrow{PM}||^3}`$

$`\overrightarrow{dH}_M`$ : magnetic field vector (S.I. unit : $`A\cdot m^{-1}`$ or $`A/m`$)

$`\overrightarrow{dB}_M`$ : flux density or magnetic field induction vector (S.I. unit : $`T`$)

$`\overrightarrow{dH}=\dfrac{1}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}\times\overrightarrow{r}}{r^3}=\dfrac{1}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}\times\overrightarrow{e_r}}{r^2}`$
 , avec  $`\overrightarrow{e_r}=\dfrac{\overrightarrow{r}}{||\overrightarrow{r}||}=\dfrac{\overrightarrow{r}}{r}`$  
 car  $`\overrightarrow{r}=r\;\overrightarrow{e_r}`$   avec $`r>0`$ .
 
Dans le vide :

LA : $`\overrightarrow{dB}_M=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}_P\times\overrightarrow{PM}}{||\overrightarrow{PM}||^3}`$

$`\overrightarrow{dB}=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\vec{dl}\times\overrightarrow{r}}{r^3}=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}\times\overrightarrow{e_r}}{r^2}`$,  
car  $`\overrightarrow{r}=r\;\overrightarrow{e_r}`$   avec $`r>0`$ .

FR : $`\overrightarrow{dB}_M=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\vec{dl}_P\land\overrightarrow{PM}}{||\overrightarrow{PM}||^3}`$

$`\overrightarrow{dB}=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}\land\overrightarrow{r}}{r^3}=\dfrac{\mu_0}{4\pi}\cdot\dfrac{I\cdot\overrightarrow{dl}\land\overrightarrow{e_r}}{r^2}`$,  
car  $`\overrightarrow{r}=r\;\overrightarrow{e_r}`$   avec $`r>0`$ .

#### Cálculos directos? de campo magnético, y fuerzas o momentos inducidos  / Calculs directs de champ magnétique, et forces et moments induits / Direct? magnetic field calculations, and induced forces and moments


##### Campo magnético creado por un conductor infinito recto atravesado por una corriente constante / Champ magnétique par fil rectiligne infini parcouru par un courant constant / Magnetic field by an infinite straight wire traversed by a constant current

Théorème de Gauss appliqué au champ magnétique

Intégral (magnétostatique + électromagnétisme)

$`\displaystyle\oiint_S\vec{B}\cdot\vec{dS}=0`$

$`\displaystyle\oint_{\Gamma\,orient.}\overrightarrow{B} \cdot \overrightarrow{dl}=
\mu_0\underset{S\,orient.}{\sum{\overline{\,I\,}}}`$

$`\displaystyle\oint_{\Gamma\,orient.}\overrightarrow{B} \cdot \overrightarrow{dl}=
\mu_0\underset{S\,orient.}{\iint{\overrightarrow{j}\cdot\overrightarrow{dS}}}`$

$`\displaystyle\oint_{\Gamma\,orient.}\overrightarrow{H} \cdot \overrightarrow{dl}=
\underset{S\,orient.}{\sum{\overline{\,I\,}}}`$

$`\displaystyle\oint_{\Gamma\,orient.}\overrightarrow{H} \cdot \overrightarrow{dl}=
\underset{S\,orient.}{\iint{\overrightarrow{j}\cdot\overrightarrow{dS}}}`$

local (magnétostatique)

$`\overrightarrow{rot}\,\overrightarrow{B}=\mu_0 \cdot \overrightarrow{j}`$

local (électromagnetism)

$`\overrightarrow{rot}\,\overrightarrow{B}=\mu_0 \cdot \overrightarrow{j}\,+ \, \epsilon_0\mu_0 \cdot \dfrac{\partial \overrightarrow{E}}{\partial t}`$$`=\mu_0 \cdot \overrightarrow{j}\,+ \, \dfrac{1}{c^2} \cdot \dfrac{\partial \overrightarrow{E}}{\partial t}`$$`=\mu_0 \cdot \overrightarrow{j}\,+ \mu_0 \cdot \overrightarrow{j_D}`$$` = \mu_0 \cdot (\overrightarrow{j}+\overrightarrow{j_D})`$

avec $`\overrightarrow{j_D}`$ courant de déplacement :  $`\overrightarrow{j_D}=\epsilon_0 \cdot \dfrac{\partial \overrightarrow{E}}{\partial t}`$

Con corriente de desplazamiento

$`\overrightarrow{rot}\,\overrightarrow{E}=-\dfrac{\partial \overrightarrow{B}}{\partial t}`$

$`div\overrightarrow{E}=\dfrac{\rho}{\epsilon_0}`$

$`\overrightarrow{D}=\epsilon \overrightarrow{E} = \epsilon_0 \epsilon_r \overrightarrow{E} `$

Propriétés anisotropes :   

$`\overrightarrow{D}= \overrightarrow{\overrightarrow{
\epsilon}}\, \overrightarrow{E}= \epsilon_0 \, \overrightarrow{\overrightarrow{
\epsilon_r}} \, \overrightarrow{E}`$

- si P est dans le vide :   $`\overrightarrow{D}=\epsilon_0 \cdot  \overrightarrow{E}`$

- si P est dans un milieu diélectrique (homogène et isotrope)

$`\overrightarrow{D}=\epsilon \cdot \overrightarrow{E} = \epsilon_0 \cdot \epsilon_r \cdot  \overrightarrow{E} `$		
	avec   $`\epsilon`$ : permittivité électrique absolue du milieu
	
$`\epsilon_r`$ : permittivité électrique absolue du milieu


#### Origen de un campo magnético variable en el tiempo: un campo eléctrico variable en el tiempos / Origine d'un champ magnétique variable dans le temps : un champ électrique variable dans le temps / Origin of a magnetic field variable in time : an electric field variable in time

##### Ley de Faraday / Loi de Faraday / Faraday's law

<!----Intercambio de ideas para construir juntos-----
------Echange d'idées pour construire ensemble-------

CM : Es electromagnetismo, por lo que necesita saber cuál es el campo magnético. Entonces, ¿probablemente 
en el nivel 4? ecuaciones de electromagnetismo, después de la electrostática y magnetostatica en el nivel 3?
Pero lástima, ¿ya da una vista previa en el nivel 2/3 de las líneas de campo? (Ver Feynmann electromagnetismo1 por ejemplo).

CM : C'est de l'électromagnétisme, donc nécessite de savoir ce qu'est le champ magnétique. Donc probablement 
au niveau 4? des équations de l'électromagnétisme, après l'électrostatique et la magnétostatique au niveau 3?.
Mais dommage, déjà en donner un aperçu au niveau 2/3 à partir des lignes de champ? (voir Feynmann electromagnetism 1 par exemple)

CM : It's electromagnetism, so you need to know what the magnetic field is. So probably at level 4? equations 
of electromagnetism, after the electrostatic and magnetostatic at level 3 ?. But pity, already give a preview
at level 2/3 from the field lines? (see Feynmann electromagnetism 1 for example).

----------------------->

* en forma diferencial

$`\overrightarrow{rot}\,\overrightarrow{E}=-\dfrac{\partial \overrightarrow{B}}{\partial t}`$

* en forma integral

$`\displaystyle\oiint_S\overrightarrow{E}\cdot\overrightarrow{dS}=\dfrac{Q_{int}}{\epsilon_0}`$$`=\dfrac{1}{\epsilon_0} \cdot \displaystyle\iiint_{\tau\leftrightarrow S} \rho \cdot d\tau`$



## Ecuaciones de Maxwell / Equations de maxwell / Maxwell's equations




### Un comentario / une remarque / An observation :

$`\epsilon_0 \cdot \mu_0 \cdot c^2 = 1`$


### Enlaces entre fenómenos eléctricos, magnéticos y luminosos: fenómenos electromagnéticos / Liens entre phénomènes électriques, magnétiques et lumineux : phénomènes électromagnétiques / Links between electrical, magnetic and luminous phenomena: electromagnetic phenomena


#### Ecuaciones de Maxwell en forma diferencial / Equations de maxwell locales / ...

$`div\overrightarrow{E}=\dfrac{\rho}{\epsilon_0}`$

$`\overrightarrow{rot}\,\overrightarrow{E}=-\dfrac{\partial \overrightarrow{B}}{\partial t}`$

$`div\overrightarrow{B}=0`$

$`\overrightarrow{rot}\,\overrightarrow{B}=\mu_0 \cdot \overrightarrow{j}\,+ \, \epsilon_0\mu_0 
\cdot \dfrac{\partial \overrightarrow{E}}{\partial t}`$$`=\mu_0 \cdot \overrightarrow{j}\,+ \, 
\dfrac{1}{c^2} \cdot \dfrac{\partial \overrightarrow{E}}{\partial t}`$

Para la secuela, ¿no deberíamos escribir y establecer mejor desde el principio las ecuaciones de Maxwell 
con los vectores de intensidad de campo eléctrico $`\overrightarrow{E}`$ y magnético $`\overrightarrow{H}`$?<br>
Pour la suite, ne faut-il pas mieux écrire et établir dès le début les équations de Maxwell avec les vecteurs
d'excitation électrique $`\overrightarrow{E}`$ et magnétique $`\overrightarrow{H}`$?

$`div\overrightarrow{E}=\dfrac{\rho}{\epsilon_0}`$

$`\overrightarrow{rot}\,\overrightarrow{E}=- \mu_0 \dfrac{\partial \overrightarrow{H}}{\partial t}`$

$`div\overrightarrow{H}=0`$

$`\overrightarrow{rot}\,\overrightarrow{H}= \overrightarrow{j}\,+ \,\epsilon_0 
\cdot \dfrac{\partial \overrightarrow{E}}{\partial t}`$


#### Ecuaciones de Maxwell en forma integral / Equations de maxwell intégrales / ...

<!--
$`\displaystyle\oiint_S\overrightarrow{E}\cdot\overrightarrow{dS}=\dfrac{Q_{int}}{\epsilon_0}`$
$`=\dfrac{1}{\epsilon_0} \cdot \displaystyle\iiint_{\tau\leftrightarrow S} \rho \cdot d\tau`$

$`\displaystyle\oiint_S\overrightarrow{B}\cdot\overrightarrow{dS}=0`$
-->
------------------------

* **Ley de Gauss = teorema de Gauss / Théorème de Gauss / Gauss' theorem**

$`\displaystyle\iiint_{\tau} div\overrightarrow{E} \cdot d\tau= \displaystyle\iiint_{\tau}
\dfrac{\rho}{\epsilon_0} \cdot d\tau = \dfrac{1}{\epsilon_0} \cdot \iiint_{\tau} \rho 
\cdot d\tau = \dfrac{Q_{int}}{\epsilon_0} `$


Ostrogradsky’s theorem = divergence theorem : for all vectorial field $`\vec{X}`$, $`\displaystyle\iiint_{\tau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\tau} \overrightarrow{X}\cdot\overrightarrow{dS}`$

$`\displaystyle\iiint_{\tau} div\;\overrightarrow{E} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS} = \Phi_E`$

$`\Phi_E`$ : Flujo eléctrico /

$`\Phi_E = \displaystyle \oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS}
= \dfrac{1}{\epsilon_0} \cdot \iiint_{\tau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0} `$

--------------------

* **Ley de Faraday / Loi de Faraday**


$`\displaystyle\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot \overrightarrow{dS}
= -\displaystyle\iint_{S \leftrightarrow \tau} \dfrac{\partial \overrightarrow{B}}{\partial t}\cdot \overrightarrow{dS}`$

Mecánica newtoniana : espacio y el tiempo son desacoplados $`\Longrightarrow`$ orden de integración
/ derivación entre variables de espacio y tiempo no importa.<br>
Mécanique newtonienne : espace et temps sont découplés $`\Longrightarrow`$ l'ordre d'intégration / différenciation entre 
variables d'espace et de temps n'importe pas.
 
$`\displaystyle\iint_S \overrightarrow{rot}\,\overrightarrow{E}\cdot \overrightarrow{dS} 
= - \dfrac{\partial}{\partial t} \left( \displaystyle\iint_S \overrightarrow{B}\cdot \overrightarrow{dS}\right)`$

Stokes' theorem  : for all vectorial field $`\vec{X}`$, $`\displaystyle\iint_{S\,orient.} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\,orient.\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$

$`\displaystyle\iint_{S\,orient.} \overrightarrow{rot} \,\overrightarrow{E}\cdot \overrightarrow{dS}
= \displaystyle \oint_{\Gamma\,orient.\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
= fem = \mathcal{C}_E`$

$`\mathcal{C}_E = fem = \mathcal{E}`$ : circulación del campo eléctrico = *fuerza electromotriz = voltaje inducido*

$`fem = \mathcal{C}_E = \mathcal{E} 
= \displaystyle \oint_{\Gamma\,orient.\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
= - \dfrac{\partial}{\partial t} \left( \displaystyle\iint_S \overrightarrow{B}\cdot \overrightarrow{dS}\right)
= - \dfrac{\partial \Phi_B}{\partial t}`$ 







Ostrogradsky’s theorem = divergence theorem : for all vectorial field $`\vec{X}`$, $`\displaystyle\iiint_{\tau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\tau} \overrightarrow{X}\cdot\overrightarrow{dS}`$

Stokes' theorem = 

for all vectorial field $`\vec{X}`$, 

$`\displaystyle\iint_{S\,orient.} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS = \displaystyle 
\oint_{\Gamma\,orient.\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$



$`\displaystyle\oint_{\Gamma\,orient.}\overrightarrow{H} \cdot \overrightarrow{dl}=
\underset{S\,orient.}{\iint{\overrightarrow{j}\cdot\overrightarrow{dS}}}`$


$`\displaystyle\left. \dfrac{dQ}{dt}\right|_S   =\oint_S \vec{j} \cdot \vec{dS}`$



