---
title: 'Spherical refracting surface in paraxial approximation'
---

### Spherical refracting surface in paraxial approximation.

#### Refracting surface. 

A **refracting surface** is a *polished surface between two media with different refractive indexes*.

!!!! *BE CAREFUL* :<br>
!!!! In the same way as we use in English the single word "mirror" to qualify a "reflecting surface", in French is use the single word "dioptre" to qualify a "refracting surface".
!!!! The term "dioptre" in English is a unit of mesure of the vergence of an optical system. In French, the same unit of mesaure is named "dioptrie".
!!!! So keep in mind the following scheme :
!!!!
!!!! refracting surface : *EN : refracting surface* , *ES : superficie refractiva* , *FR : dioptre*.<br>
!!!! _A crystal ball forms a spherical refracting surface : un "dioptre sphérique" in French._
!!!!
!!!! unit of measure : *EN : dioptre* , *ES : dioptría* , *FR : dioptrie*.<br>
!!!! _My corrective lens for both eyes are 4 dioptres : "4 dioptries" in French._


#### Spherical refracting surface.



#### Analytical study of the position and shape of an image.

A **spherical refracting surface** in analytical paraxial optics is defined by *three quantities* :
* **$`n_{ini}`$** : *refractive index of the initial medium* (the medium on the side on the incident light).
* **$`n_{fin}`$** : *refractive index of the final medium* (the medium on the side on the emerging light, after crossing the refracting surface).
* **$`\overline{SC}`$** : the *algebraic distance between the __vertex S__* (sometimes called "pole", is the centre of the aperture) *and the __center of curvature C__* of the refracting surface.

! *USEFUL* : The whole analytic study below also applies to a plane refracting surface. We just need to remark that a plane surface is a spherical surface whose radius of curvature tends towards infinity.

<!--à finir !!!! BE CAREFUL : For a same physical situations, a spherical surface between two transparent media, for optics, ... -->

Consider a *point object* **$`B_{obj}`$** whose orthogonal projection on the optical axis gives the *point object*  **$`A_{obj}`$**. If the point object is located on the optical axis, then $`B_{obj}=A_{obj}`$ and we will use to named it point object $`A_{obj}`$. The point object $`B_{obj}`$ can be **real** *as well as* **virtual**.

The **calculation of the position** of the *point image* **$`B_{ima}`$**, *conjugated point of the point object $`B_{obj}`$* by the refracting surface, is carried out in **two steps** :

1.  I use the **spherical refracting surface equation** (known too as the **"conjuction equation" for a spherical refracting surface**) to calculate the *position of the point* **$`A_{ima}`$**, $`A_{ima}`$ being the *orthogonal projection on the optical axis of the point image* $`B_{ima}`$. 

**$`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=\dfrac{n_{fin}-n_{ini}}{\overline{SC}}`$**

To perform this I *need to know the __algebraic distance__* **$`\overline{SA_{obj}}`$**, and the *calculation  of the __algebraic distance__* **$`\overline{SA_{ima}}`$** along the optical axis *gives me the position of $`A_{ima}`$*.
<!--conjugación-->

2. I use the **"transverse magnification equation" for a spherical refracting surface**, to calculate the *__algebraic value__ of the transverse magnification* **$`\overline{M_T}`$**, then to derive the *__algebraic length__* **$`\overline{A_{ima}B_{ima}}`$** of the segment $`[A_{ima}B_{ima}]`$, that is the algebraic distance of the point image $`B_{ima}`$ from its orthogonal projection $`A_{ima}`$ on the optical axis.

By *definition :* **$`\overline{M_T}=\dfrac{\overline{A_{ima}B_{ima}}}{\overline{A_{obj}B_{obj}}}`$**.
Its *expression for spherical refracting surface :* **$`\overline{M_T}=\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$**.

I know $`\overline{SA_{obj}}$, $n_{ini}$ and $n_{fin}$, I have previously calculated $`\overline{SA_{ima}}$, so I can calculate $`\overline{M_T}`$ and deduced $`\overline{A_{ima}B_{ima}}`$


! *USEFUL* : The conjuction equation and the transverse magnification equation for a plane refracting surface are obtained by rewriting these equations for a spherical refracting surface in the limit when $`|\overline{SC}|\longrightarrow\infty`$.<br> Then we get *for a plane refracting surface :*
!
! * *conjuction equation :*&nbsp;&nbsp; $`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=0`$.
!
! * *transverse magnification equation :*&nbsp;&nbsp; $`\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$ &nbsp;&nbsp; (unchanged).
!
! This generalizes and completes the knowledge you get about plane refracting surfaces seen in your pedagogical paths in plain and hills.


#### Graphical study of the position and shape of an image.



