---
title: Géométrie et coordonnées - proposition 2
published: true
routable: true
visible: false
lessons:
   - slug: geometry-coordinates-1-linear
     name: LINÉAIRE : Ma perception de l'espace et du temps
     order: 1
---

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>
!!!! <details>
!!!! <summary>
!!!! Note pour l'équipe pédagogique 
!!!! </summary>
!!!! <br>
!!!! Toujours délicat de fixer le curseur de ce niveau 1... A qui s'adresse-t-il? <br>
!!!!    <br>
!!!! - Il doit rester utile à ceux qui sont ou ont été le plus éloignés géographiquement, socialement, économiquement d'un système éducatifs de base. <br>  
!!!! ==> idée de cette proposition :    <br>
!!!! À ce niveau, fixer les concepts et mots-clés associés, principalement de la vie de tous les jours.  <br> 
!!!! Utiliser un vocabulaire simple et des textes pas trop longs.     <br>
!!!! Malgré tout, le texte dans cette partie "main" peut être suffisamment long pour préciser clairement les choses. En effet, pour les internautes qui n'ont pas l'habitude de lire ou de se concentrer sur des textes un peu longs, l'essentiel des idées est repris sous forme plus synthétique et associé à des images et animations dans la partie "synthèse". L'idée est aussi de tirer vers l'apprentissage de la lecture de textes plus longs ceux qui, ayant commencé par la partie synthèse, seraient particulièrement intéressés par le thème abordé.<br>
!!!! <br>
!!!! - La maîtrise des concepts et mots-clés utiles à la vie de tous les jours sont essentiels pour pouvoir se placer et progresser. Mais il ne faut pas rester à l'écart des évolutions, questions et connaissances plus pointues de l'actualité du thème scientifique abordé. C'est très important en terme de culture générale, d'attrait vers les sciences et de motivation pour progresser.   <br>
!!!! ==> idée de cette proposition :  <br>
!!!! Si un tel point n'est pas abordé dans le texte standard de cette partie "main" de niveau 1, il peut apparaître dans cette partie "main" dans un apparté "au-delà", il peut aussi être plus développé ou apparaître dans la partie "beyond" associée (dans le mode "linear") à cette partie "main". Et il serait bien qu'il apparaisse d'une façon ou d'une autre, plus développé, dans le niveau 2. <br>
!!!! </details>

##### Randonnée Plaine 

<!---------------------------
   - slug: geometry-coordinates-prop2-123-panorama-main
     order: 1

### Dans le temps et l'espace,<br>&nbsp;&nbsp;&nbsp;&nbsp; je situe,<br>&nbsp;&nbsp;&nbsp;&nbsp; je distingue des formes, <br>&nbsp;&nbsp;&nbsp;&nbsp; je mesure

<br>

<!--!   
! *LE  TEMPS  ET  L'ESPACE*        
!
!  <!--(autre type de titre possible "J'ai conscience du temps et je perçois l'espace")
! <details>
! <summary>
! Programme proposé
! </summary>
! <br>
! LIGNES  DIRECTRICES<br>
! L'idée dans cette proposition est de fixer le vocabulaire, et de faire réfléchir sur ces notions si intuitives qu'on y pense plus. Mais il s'agit d'une réflexion sur l'aspect objectif de ces notions, destiné à l'aspect mesure des durées et des longueurs, en préparation à la mécanique qui abordera les vitesses et accélérations, et de façon plus générale le mouvement, sa description et ses causes dans un référentiel donné.<br>
! <br>
! Le lien complexe entre le temps, l'espace, la matière, l'énergie<br>
! ou entre l'espace-temps et la matière-énergie<br>
! ou dans un cadre espace-temps-matière-énergie<br> 
! se fera progressivement dans les niveaux supérieurs et uniquement sur les thématiques concernées. L'idée ici est de rester au plus près des sensations et intuitions contemporaines : l'intuition toute newtonienne d'un espace et d'un temps, cadre d'un univers indépendant de son contenu.<br>
! <br>
! Quant à la valeur psychologique du temps, elle n'est pas d'utilitée en terme de mesure et de physique. L'idée si elle se développe sera de l'aborder dans une partie "psychologie, sciences sociales". Il sera toujours possible alors d'afficher ces deux visions dans un mode que nous pourrions appeler mode transverse ou mode transdisciplinaire.<br>
! <br>
! Enfin, l'emploi de centrer au début sur "ma", "ce que je", permet après de se poser la question "toi", "nous", "nos perceptions communes", "ce sur quoi nous pouvons nous entendre", premier pas vers l'idée que mes perceptions et ce que je crois, tout cela n'est pas universel. Je dois écouter et comprendre la vision de l'autre, premier apprentissage de la relativisation. La comparaison entre physique classique, relativités et physique quantique peut aider énormément à cela, avec un côté franchement objectif.<br>
! <br>
! PROGRAMME  PROPOSÉ <br>
! 1 - J'ai conscience du temps <br> 
! 1.1 - Ma perception et représentation du temps <br>
! 1.1.2 - Je distingue le passé, l'instant présent, et l'avenir <br>
! 1.1.3 - J'observe des évènements simultanés ou qui se succèdent dans le temps <br>
! 1.1.4 - J'ai conscience de phénomènes cycliques <br>
! 1.1.5 - Je mesure des durées entre deux évènements <br>
! 1.1.6 - Je date des évènements <br> 
! 1.2 - Nos perceptions communes du temps <br>
! 1.2.1 - Mon temps propre <br>
! 1.2.2 - Et toi, quelle est ta perception du temps? <br>
! 1.2.3 - De quoi pouvons-nous convenir ensemble? <br>
! 1.2.4 - Ce que révèlent les mesures temporelles les plus précises <br>
! 2 - Je perçois l'espace <br>
! 2.1 - Ma perception et représentation de l'espace <br>
! 2.1.1 - J'observe des corps plus ou moins éloignés <br>
! 2.1.2 - Je mesure des distance et des longueurs <br>
! 2.1.3 - J'ai conscience d'un espace a 3 dimensions <br>
! 2.1.4 - Une surface a 2 dimensions <br>
! 2.1.5 - Une ligne a 1 dimension <br>
! 2.1.6 - Une point a 0 dimension <br>
! 2.2 - Nos perceptions et représentations communes de l'espace <br>
! 2.2.1 - Et toi, quelle est ta perception de l'espace? <br>
! 2.2.2 - De quoi pouvons-nous convenir ensemble? <br>
! 3 - Au-delà de ce que révèlent nos sens, vers un espace-temps 
! </details>

En cours de rédaction, cela peut être changé, réécrit.
-->


![](titre-bleu-le-temps-et-l-espace_NB3_L1200.jpg)

<!-- 1 - 
### J'ai conscience du temps
<!--Perception et représentation du temps-->

<!-- 1.1 - -->
###  J'ai conscience du temps

Les premiers rayons du soleil percent doucement les rideaux, éveillant la chambre 
d’une lueur tranquille. Lentement, mon esprit émerge de la profondeur d'un sommeil 
inconscient. Quelques minutes sereines où je me sens simplement ... vivant.


#####  Ma perception et représentation du temps

Plus encore que l'espace où je me trouve et dans lequel je me déplace librement,le temps m'emporte inexorablement vers un futur incertain,
où chaque jour écrit un peu plus ma destinée.

Le temps est la toile de fond de ma vie, car mes pensées s'étendent et s'épanouissent 
dans le temps <!--ce flux temporel continu-->. Mon "moi" et ma "conscience" nécessitent le temps pour 
se percevoir, pour se concevoir, pour se sentir exister. Ainsi le temps n'est pas 
qu'une simple perception, il est à l'origine de ce tout que je perçois, du fait même
que je puisse percevoir, de mon moi. Il fonde l'être conscient que je suis, et à 
travers moi toutes les réalités qui m'interpellent, les sentiments qui me touchent,
les idées qui me viennent. Je suis d'abord né de cette étrange ... entité... qu'est 
le temps.

Si je me sens exister, si je perçois un monde 
réel qui m'entoure, alors le temps 
doit bien posséder un élément de réalité aussi réel que toutes les choses de ce monde. 
Puis-je concevoir un temps qui ne serait qu'émergence au sein d'une réalité qu'il fonde?
Le temps participe à cette réalité, il en est peut-être à l'origine.

Mais alors qu'est-ce alors que le temps? Sa nature profonde me parait bien insaisissable. 
Dans les cultures anciennes le temps est souvent personnifié par des dieux.
Dans la Grèce Antique, plusieurs dieux, Chronos, Kairos, Aion, ... se partagent 
nos différentes perceptions du temps. Chronos est le dieu de l'écoulement continue 
du temps au cours de la vie, qui conduit inexorablement chacun vers sa fin. 
Kairos le dieu des évènements qui ponctuent le temps, des instants décisifs 
qui déterminent le chemin d'une vie. Aion est le dieu de l'infinitude du temps, de l'éternité. 
Ces mythes montrent que depuis toujours, l'humanité a cherché à comprendre la nature du temps.


<!-- 1.1.2 ---->
#####  Je distingue le passé, l'instant présent, et l'avenir

<!-- premier texte---------
Ma conscience perçoit l’instant présent, ma mémoire me suggère un passé, 
ensemble formé d’une succession continue d’instants passés vécus. Je sais qu’à 
l’instant présent succède l’instant suivant, j'ai l’intuition, je projette mes
actions et anticipe leurs conséquences et les variations de mon environnement 
dans un futur.

De ma mémoire des évènements passés, de ma conscience du présent et de ma capacité 
d’analyse et de projection dans le futur, je perçois des enchainements entre faits 
du passé et faits du futur qui se répètent. J'ai ainsi développé l’intuition de causes qui 
induisent des effets, les causes précédant toujours les effets. Par ailleurs, 
lorsqu’un malheur me touche, je sais l’impossibilité de revenir dans le temps
pour modifier le déroulement des évènements. Le temps m'apparaît ainsi fléché, 
s’écoulant toujours de façon continue du passé vers le futur, et cela sans possibilité 
de retour vers le passé. 
------------------------->

Ma conscience capte l'instant présent, "je me sens vivant !", tandis que ma mémoire 
évoque le passé, avec ses souvenirs d’instants vécus, chacun empreint de ses propres 
émotions, joies et peines. Ce passé m'est précieux ; il forge l'être que je suis 
aujourd'hui et donne cet unique et si important sentiment de "poids" à mon existence. 
L'instant présent est aussi l'orée d'un futur de possibles, une porte ouverte vers
la réalisation de mes espoirs et de mes rêves.

Le monde extérieur, avec ses mystères et ses hasards, déploie devant moi une infinité
de possibles, chacun capable de transformer ma vie de manière inattendue. À certains moments,
les circonstances me dévoilent distinctement plusieurs chemins, offrant différentes 
perspectives et opportunités. Cette diversité célèbre la beauté de la liberté 
et du libre arbitre, m'invitant à choisir et à tracer mon propre chemin.

Lors de ces points de croisement sur la trajectoire de ma vie, la rencontre entre mes
pensées et mes actions avec le flux des événements façonne ma destinée. Les pensées
intimes que je choisis de lancer vers les instants à venir, ainsi que les décisions 
et actions que j’entreprends, expriment ma liberté d'être et de construire l'être 
humain unique auquel j'aspire. "Il n'est jamais trop tard pour devenir ce que vous 
auriez pu être", comme l'a si bien écrit George Eliot, pseudonyme de l'auteure 
britannique Mary Ann Evans.

Grâce à cette mémoire des événements passés, à ma conscience aiguisée du présent 
et à mon aptitude à analyser et à projeter dans l'avenir, je décèle des motifs récurrents,
des schémas entre ce qui a été et ce qui sera. Ainsi, j'ai développé cette intuition 
fondamentale de la réalité de causes à effets : chaque cause engendre un effet... avec 
cet ordre implacable qui veut qu'à l'échelle de ma perception humaine, la cause précède 
toujours l'effet dans la chronologie du temps.

Un souvenir me revient, le vécu d'un moment de joie et de plénitude. La nostalgie me prend 
de ces instants de bonheur, une certitude tranquille mêlée d'un léger regret de ne pouvoir
retourner dans le passé pour revivre ces instants.
De même, lorsque le malheur frappe, je ressens avec acuité l'impuissance de ne pouvoir remonter
le temps pour modifier le cours des événements. 

Le temps m'apparaît alors comme une flèche lancée parcourant inexorablement sa trajectoire. 
Il s'écoule du passé vers le futur, sans jamais permettre un 
retour en arrière. 



<!---
-Ainsi survient le double visage du temps, il est ma liberté, 
mais il est aussi ma prison... 

Mais peut-être est-ce cet aspect irrémédiable du temps, cet
impossible retour en arrière, qui donne cette si unique et précieuse profondeur à mon existence.
Quelle valeur aurait une vie où la réponse à chaque évènement pourrait être rejouée, où chaque
pensée pourrait-être réécrite, ou toute trajectoire pourrait être testée? Peut-être ce confort
viderait l'être que je suis de toute substance. Rejouer cent fois une épreuve d'un jeu
vidéo jusqu'à la réalisation d'une performance peut pour certain être prenant et captivant, 
donnant des moments de concentration puis de joies intenses qui peuvent s'inscrire
dans une vie. Mais cela n'est pas de la nature de l'existence elle-même, de la perception de soit
et de sa liberté. La prison devient plus simplement maison, que l'on meuble et dans laquelle 
se déroule notre existence. C'est l'immensité de l'espace et l'infinité des trajectoires possibles
qui ... à améliorer et continuer
------>



#####  J'observe des évènements simultanés ou qui se succèdent dans le temps

Tout à coup, un bruit léger suivi de quelques pépiements venant de l’extérieur m'extirpent
de ma torpeur. Un oiseau vient de se poser sur le rebord de ma fenêtre. Presque aussitôt 
il s’envole à nouveau, les battements de ses ailes trahissant son départ soudain. 

Je me redresse, pose mes pieds à terre. Je prends quelques secondes avant de me lever,
et me dirige machinalement vers la cuisine. Un sifflement léger suivi de quelques crépitements 
venant de la cafetière m'indiquent que le café est prêt. Dehors une silhouette traverse 
la rue et poursuit son chemin, indifférente à mon regard curieux.
Je m’installe avec mon café fumant, savourant la chaleur et l’odeur qui s’en dégage. 
Le téléphone posé à côté de moi vibre soudainement, et un message s’affiche sur l’écran. 
Un aboiement lointain résonne. Une nouvelle journée commence dans une routine familière.

Tout est évènement, tout est mouvement, tout s’enchaîne : l'oiseau, la cafetière, 
le passant, le message, le chien. Chacun de ces événements est indépendant, ponctuel,
mais dans mon esprit, ils forment une ensemble cohérent, une suite d’instants reliés
par ma simple présence. Je suis le témoin d'évènements anodins qui se succèdent 
dans le temps.

Une question émerge alors dans ma conscience : que serait ma perception du temps 
dans un monde sans mouvements, sans bruits ni odeurs, sans toutes ces petites 
choses qui ponctuent chaque moment de la journée? Le temps existerait-il dans un univers
sans mouvement de matière, ni propagation de lumière? Rien alors ne pourrait révéler
sa présence. Le temps nait-il du mouvement, ou lui préexiste-t-il?

> _Pour aller plus loin :   
Au-début du 20ème siècle, Albert Einstein a révolutionné notre conception même de l'espace
et du temps, d'abord avec la relativité restreinte en 1905, puis avec la relativité générale
en 1913. La relativité restreinte a unifié l'espace et le temps au sein d'un espace-temps,
puis unifié la masse et l'énergie à travers la célèbre relation E=mc<sup>2</sup>.
La relativité générale décrit la façon dont l'espace-temps se déforme sous l'action de la matière énergie, 
et comment cette déformation influence les mouvements de la matière-énergie.
Elle a permis entre autre de prédire l'existence des trous noirs et des ondes gravitationelles 
avant leur découverte, et ses prédictions sont essentielles à la précision des systèmes 
de géolocalisation par satellites. L'espace-temps et la matière-énergie apparaissent ainsi intimement liés._


<!--  1.1.3 - ---->
##### J'ai conscience de phénomènes cycliques

<!--L'observation de cycles ; origine et unités de temps ; datation, durée-->
Certains de ces mouvements extérieurs semblent revenir de manière régulière, je les 
appelle phénomènes cycliques dans le temps.   

L’homme a de tout temps observé des phénomènes temporellement cycliques dans la nature,
que ce soit le cycle des saisons, le cycle de l’alternance jour/nuit, le cycle des phases de la lune,
celui des marées… les battements de son propre coeur. Puis ils ont su observer ou produire des cycles
plus courts, comme le cycle du balancement d’un pendule à l'origine du tic-tac insistant 
de l'ancienne horloge murale des grand-parents, le cycle des vibrations d’un cristal de quartz
dans nos montres modernes non connectées. <!--De nos jours,  minimum actuelle (Galileo 10-17s ?)...
labos spécialisé gardiens du temps universel-->

Tous ces cycles sont cohérents entre eux. Si un cycle A est deux fois plus lent q'un cycle B et
cinq fois plus rapide qu'un cycle C, alors le cycle B est dix fois plus rapide que le cycle C.
De cette cohérence est né le sentiment que chaque battement d'un cycle n'est qu'un marqueur lancé dans
un flux temporel continu qui, tel un fleuve, s'écoule à vitesse constante du passé vers le futur.
<!--Quantifier alors l'intervalle de temps entre deux évènements quelconques, ou entre un évènement
quelconque et un évènement pris comme référence, devient alors possible.

<!--Rajouter un cycle beaucoup plus rapide, atomique pour montrer la résolution temporelle
minimum actuelle (Galileo 10-17s ?). Ces cycles sont cohérents entre eux ce qui permet 
de dire que le temps s’écoule de façon … linéaire ? (à développer).-->

<!--  1.1.4 - - ---->
##### Je mesure des durées entre deux évènements,<br>exprimées dans une unité de temps

Les phénomènes cycliques ont toujours été utilisés pour "mesurer la quantité de temps" 
entre deux évènements. Cette quantité de temps entre deux évènement se dit aussi 
"intervalle de temps", ou encore "durée" entre deux évènements.

A chaque durée de cycle peut-être associé une unité de temps : l’année pour les cycles 
des saisons en occident, l’année lunaire du calendrier musulman, la journée pour le cycle jour/nuit.
La durée entre deux évènements est ainsi mesurée comme le nombre de cycles d’un phénomène périodique donné, 
ainsi la durée entre la naissance et la mort se compte en années. Pour définir une unité 
de temps de durée plus courte, plus proche de la durée d’événements quotidiens, l’homme 
a souvent défini de nouvelles unités de temps, parfois de simples sous-multiples des 
unités précédentes : ainsi le mois est défini à-peu-près comme le douzième d’une année, 
la journée est divisée en vingt-quatre heures, chaque heure en soixante minutes, 
chaque minute en soixante seconde. La seconde est l’unité de temps du système international 
de mesure (S.I.). 

> _Pour aller plus loin :   
Si la définition de la seconde a évolué au cours des âges, elle est maintenant définie
à partir d’un phénomène physique universel : la durée de 9&nbsp;192&nbsp;631&nbsp;770 
périodes de la radiation correspondant à la transition entre les deux niveaux hyperfins de l'état 
fondamental de l'atome de césium 133._


##### Je date des évènements.

Comparer deux à deux l'intervalle de temps séparant deux évènements devient inefficace lorsque 
je dois ordonner dans le temps un grand nombre d'évènements.   

En effet si je dois me souvenir de toutes les durées entre deux évènements pris dans un ensemble
de $`N`$ éléments, alors pour chacun des $`N`$ évènements je dois mémoriser la durée qui le sépare
des $`N-1`$ autres évènements. Ce sont au total $`N \times (N-1)`$ durées que je dois mémoriser.

Il est plus simple de comparer
l'intervalle de temps entre chaque évènement et un même évènement pris comme référence et que
je peux appeler "évènement origine de la datation du temps". Si cet évènement origine est l'un 
des $`N`$ évènements, alors je n'aurai que $`N-1`$ "dates" à mémoriser.

Cet évènement de référence n'est pas l'origine du temps. C'est un évènement qui se produit
à un moment du temps, un évènement qui se passe quelque-part le long de la course du temps. 
Mais des évènements se sont produits avant cet évènement pris comme origine, et d'autres se 
sont produits et se produiront après. 

La question d'une origine, d'un commencement du temps lui-même fut d'abord et reste une 
question philosophique. C'est une question aussi maintenant abordée par la physique elle-même, dans
le cadre de la relativité générale d'Einstein. 

<!--===Point pour aller plus loin à discuter entre astrophysiciens cosmologistes====
!! *Au-delà : sur l'origine du temps*   
!! <br>
!! Dans la quête multimillénaire des phylosophes puis des physiciens sur la compréhension de notre réalité,
il y a eu plusieurs étapes importantes.   
!! Citons-en quelques-unes :
!! * Newton unifie le ciel et la terre en montrant que ce sont les mêmes lois qui régissent 
le mouvement des étoiles et des planètes dans l'univers, et le mouvement de tout corps sur 
terre comme la chute d'une pierre ou le lancé d'un ballon de basket.<br>
!! Dans les équations de Newton, le temps, l'espace, les corps matériels et la lumière sont indépendants.
!! * Einstein montre que les lois de Newton sont une approximation d'une représentation moins intuitive
de la réalité. Il publie :   
!!    * la relativité restreinte (1905) qui relie l'espace et le temps au sein d'un continuum "espace-temps", 
dans lequel se meut la matière, celle-ci étant unifiée à l'énergie au sein d'une "matière-énergie" par la célèbre égalité $`E=m\,c^2`$.
!!    * la relativité générale (1915) qui relie l'espace-temps et la matière-énergie au sein d'un continuum
"espace-temps-matière-énergie". En effet, les propriétés géométriques de l'espace-temps 
sont déterminées par son contenu en matière-énergie.   
!!
!! La relativité générale a permis d'interpréter tout un large faisceau d'observations de l'univers dans le cadre
du modèle du Big-Bang. 
!! à terminer ...
!! Origine de l'espace-temps, singularité mathématique... Plus philosophique, peut-on parler 
d'un "avant" à l'évènement "naissance de l'espace-temps" ?
!! A faire revisiter par de vrais cosmologistes.
====================================-->


### Nos perceptions communes du temps

##### Le temps, pour toi et pour moi

C'est une belle et sereine fin de semaine, le ciel est bleu et une douce bise atténue 
les ardeurs d'un soleil éclatant. Toi et moi avons décidé de profiter de la journée 
pour flâner au centre-ville.

A la descente du tramway, nous nous accordons un moment de liberté avant de nous 
rejoindre pour prendre une boisson fraîche à la terrasse d'un café, et terminer 
cette escapade en déambulant tranquillement dans les rues ombragées du centre historique.
Rendez-vous est pris dans 40 minutes devant la fontaine de la place centrale, et 
chacun regarde sa montre. Nos deux montres à quartz sont identiques, cadeaux de 
nos parents et d'un même jour. Contrairement à nos smartphone connectés à internet, ces montres déduisent 
l'heure en comptant le nombre d'oscillations d'un cristal de quartz. Elles indiquent 
un léger décalage de 5 minutes, mais mentalement chacun de nous calcule l'heure 
de notre rendez-vous et anticipe la position correspondante de la grande aiguille. 
Sûrs de nous retrouver, nous partons alors chacun de notre côté, moi vers la grande 
librairie à la découverte les dernières nouveautés littéraires, et toi vers le marché 
couvert aux étals variés et saveurs exotiques.

Arrive bientôt le moment de nous retrouver; je presse le pas pour te rejoindre. 
Assise sur le bord de la fontaine, tu me souris, et d'un geste machinal synchronisé
nous levons nos poignets pour vérifier l'heure. Sans y porter attention tant le fait
est intuitif et entendu, quelque-chose de remarquable s'est produit. Nos montres affichent 
exactement le même nombre de minutes écoulées : quarante-trois. Cette simple observation nous 
rappelle un fait important qui rythme nos vies. À l'échelle de nos perceptions humaines,
le temps bien que perçu consciemment et individuellement de manière propre et subjective,
fait battre au même rythme les oscillations des deux cristaux de quartz identiques de nos montres. 
Quelques-soient les unités de temps basées sur des cycles cohérents entre eux, 
toi et moi pouvons nous accorder sur des durées communes entre deux mêmes évènements perçus. 
Toi et moi pouvons nous accorder sur des dates communes, lorsque nous partageons un même 
évènement pris comme origine sur les axes de nos temps. Quelques-soient nos expériences 
individuelles, nous percevons un temps qui s'écoule de la même façon pour toi et moi.

> _Pour aller plus loin :_   
_La perception d'un temps qui s'écoule de la même façon pour toi et moi n'est cependant
pas exacte. L'écoulement du temps, mesurée par des horloges de très hautes précisions, 
dépend des mouvements relatifs des horloges les unes par rapport aux autres.
Et lorsque les horloges sont immobiles entre elles, il dépend de leurs différentes
altitudes dans le champ de gravitation terretre. Toutes ces mesures sont en accord
avec les préditions de la relativité générale d'Einstein. Les humains étant eux-mêmes
en mouvements les uns par rapports aux autres, et suivants des chemins à des altitudes
différentes, l'écoulement du temps est réellement propre à chacun._
<!--Ce point sera abordé dans le chapitre à venir 
"Au-delà de ce que révèlent nos sens, vers un espace-temps"._-->

##### Un temps perçu universel

<!-------
Attention : il faut parler de nos perceptions et des effets ressentis ou observés 
communs du temps. Puis ensuite de l'entente sur une durée, donc une unité de mesure
du temps commune (historiquement les heures, puis les secondes), et enfin sur un système 
de datatiob, donc une origine du temps associée à l'unité de temps, commun. 
Synchronisation des horloges au sein d'une nation, puis définition des fuseaux horaires 
et synchronisation des horloges au sein d'un mêême fuseau horaire. 
-------->

7h30 du matin, le grand hall de la gare de Toulouse accueille une foule dense de voyageurs 
en attente, les regards fixés sur la grande et majestueuse horloge murale et le tableau 
des départs de train. Les aiguilles de l'horloge pointent notre capacité à nous accorder
sur une heure et des durées communes. Chaque minute orchestrée par une avancée de la 
grande aiguille est une balise temporelle reconnue unanimement. Ce grand hall de gare 
à l'heure de pointe nous révèle que le temps est un lien subtile et invisible, harmonisant
des vies disparates en un ballet collectif d'heures, de minutes et de secondes partagées. 

Ainsi cette perception partagée d'un temps toi et moi s'est généralisée.
A l'échelle humaine de nos perceptions conscientes, le temps apparait universel.

> _Note :   
Tu lis peut-être l'heure donnée par ton smartphone, ou une montre connectée. 
Il s'agit d'une heure standardisée propre à ton pays ou ta zone géographique, 
et basée sur une échelle de temps de référence dénommé UTC (de l'anglais "coordinated 
universal time). L'heure UTC est définie et diffusée par le Bureau International 
des Poids et Mesures (BIPM : https://www.bipm.org/fr/). Par exemple le Mexique couvre 
plusieurs fuseaux horaires : l'heure officielle en été dans la ville de Guadalajara
à l'est du Mexique est en retard de 6 heures par rapport à l'heure de référence (UTC-6),
tandis que l'heure à Cancún, ville côtière au nord-est du Mexique, est en retard de
5 heures (UTC-5). La France est couverte par un seul fuseau horaire : dans la ville
de Toulouse comme sur l'ensemble du territoire national, l'heure d'été est en avance 
de 2 heures par rapport à l'heure de référence (UTC+2)._


##### Ce que révèlent les mesures temporelles les plus précises

-----------------------------------------------------

### 2 - Je perçois l'espace
<!--Perception et représentation de l'espace-->

#### 2.1 - Ma perception et représentation de l'espace

##### 2.1.1 - J'observe des corps plus ou moins éloignés


##### 2.1.2 - Je mesure des distance et des longueurs  

implique déjà la notion de sègment de droite, de plus court chemin entre deux points, mais c'est très intuitif.


##### 2.1.3 - J'ai conscience d'un espace a 3 dimensions

Première approche sur les notions de référentiel et de coordonnées :  
Un exemple possible d'enchaînement d'dées : 
\- je suis immobile sur le sol.  
\- de ma position mon regard pointe un objet immobile dans une direction.   
\- mon poids, dû à la gravité, m'indique en haut et un bas   
\- en plaine, mon corps est confiné dans un plan horizontal   
\- par rapport à moi, un objet est situé plus ou moins loin :   
&nbsp;&nbsp;\- devant ou derrière   
&nbsp;&nbsp;\- à gauche ou à droite
&nbsp;&nbsp;\- en haut ou en bas   
$`\Longrightarrow`$ conscience de trois directions indépendantes :   
\- haut-bas   
\- devant-derrière   
\- gauche-droite   
avec deux sens possibles pour chacune de ces directions. L'objet est situé plus ou moins loin :   
\- devant OU derrière   
\- en haut OU en bas (par rapport à mon regard qui pointe l'horizon de la plaine)   
\- à droite OU à gauche  

##### 2.1.4 - Une surface a 2 dimensions

Un exemple possible d'enchaînement d'dées : 
\- un oiseau se déplace dans les 3 dimensions de l'espace.   
\- en absence de moyen de me déplacer verticalement, mon déplacement est limité à la surface du sol terrestre.
\- 

##### 2.1.5 - Une ligne a 1 dimension 

Exemple possible d'un chemin étroit :   
Je peux seulement suivre le chemin (si le chemin est situé le long de la crête d'une montagne, si je le quitte je risque de tomber),
sans un sens ou dans un autre.

##### 2.1.6 - Une point a 0 dimension 

Un point est un volume de l'espace infiniment petit. Il n'y a pas différents lieux dans un point, je ne peux pas "me déplacer" dans un point.
Exemple possible :    
\- lorsque je regarde une étoile, je peux l'assimiler à un point dans le ciel car je ne distingue "pas de détails dans l'étoile".


#### 2.2 - Nos perceptions et représentations communes de l'espace  

##### 2.2.1 - Et toi, quelle est ta perception de l'espace?

##### 2.2.2 - De quoi pouvons-nous convenir ensemble?

(dans la vie de tous les jours, ce que l'on déduit de nos sens et de notre bon-sens)

<!--------------------------------------
#### 2.3 - Ce que révèlent les mesures temporelles les plus précises

pas assez de matière, et trop loin de la vie de tous les jours,
mais... un rapide point au-delà pour dire 2 mots des ondes gravitationnelles
et de leur détection ? Cela est devenu par la presse une culture scientifique,
--------------------------------------->


------------------------------------------

### 3 - Au-delà de ce que révèlent nos sens, vers un espace-temps   

(à ce niveau 1 pour intéresser et comme point culturel d'actualité?   
et  
comme chapitre dans cette partie main, ou comme un apparté "au-dela" de cette partie main?   
ou plutôt dans la partie "beyond"?)

<br><br>

![](<br><br>

![](titre-geometrie-definition_NB_L1200.jpg)

Utile? A faire et voir

<br><br>

![](titre-geometrie-pythagore-thales_NB3_L1200.jpg)

<!--!   
! *LA  GEOMETRIE  DE  L'ESPACE*   
! <!--(autre type de titre possible : " ... ")
! <details>
! <summary>
! Programme proposé
! </summary>
! 1 - Sègment de droites, droites et demi-droites <br>
! 1.1 - Le sègment de droite <br>
! 1.2 - Du sègment de droite et à la droite <br>
! 1.3 - Droites séquentes et droites parallèles <br>
! 2.2 - Le plan <br>
! 3 - La sphère <br>
! 4 - Le cercle <br>
! 4.1 - Le cercle <br>
! 4.2 - l'arc de cercle <br>
! 5 - Les angles <br>
! </details>
-->

### 1 - Sègment de droites, droites et demi-droites

#### 1.1 - Le sègment de droite

Dans l'espace, le chemin le plus court entre deux points.  
Idée :   
\- une corde non tendue réalise une ligne entre ses deux extrémités (la ligne est une idéalisation : corde infiniment fine).   
\- une corde tendue réalise une ligne entre ses deux extrémités (idéalisation).   
\- avec un double décimètre rigide (par opposition au double décimètre ruban), je peux tracer sur une feuille 
\- un sègment de droite $`[AB]`$ d'extrémités $`A`$ et $`B`$, et de longueur au plus $`d_{AB} \le 20cm`$.

Il pourront acheter pour quelques sous, ou voir, des diodes lasers. Dire deux mots du lien entre un faisceau laser et la ligne droite.

#### 1.2 - Du sègment de droite et à la droite

Idées :

(dans la partie main, on conte comment construire, et cela s'appuie sur des figures animées dans la partie synthèse).   

Pour réaliser un sègment de droite :   
\- à l'échelle de quelques centimètres, à l'aide d'un double-décimètre rigide (et non ruban), je trace sur une grande feuille un sègment d'extrémités $`[AB]`$
de longueur $`d_{AB} \le 20cm`$. 
\- à l'échelle de quelques mètres, une corde tendue.   
\- à l'échelle du kilomètre, trajectoire d'un faisceau laser? (encore que...)

Comment, à l'aide d'un double décimètre, puis-je prolonger le sègment $`[AB]`$ pour obtenir 
le sègment de droite $`[AC]`$ de longueur $`d_{AB} = 30cm`$?
En faisant glisser le double décimètre parallèlement à lui-même, sur une distance d'au moins 10cm.    
En répétant cette opération une infinité de fois, je pourrais (avec une feuille infiniment grande et en un temps infiniment long) tracer
un sègment de droite dont seule l'extrémité $`A`$ peut être localisée, l'autre extrémité étant toujours plus loin que tout autre point du sègment.
(première idée sans le dire, du "transport parallèle")   
J'aurais ainsi tracé la demi-droite $`[AB)`$.    
Utiliser au niveau 1 cette notation utilisant $`[`$ et $`)`$ en l'expliquant avec les mains?   
Elle est assez intuitive et peux s'expliquer rapidement d'un schéma.
Ce n'est pas fondamental à ce niveau, à voir.   
Donc tout autre point $`B`$ différent de l'extrémité $`A`$ permet de définir la demi-droite ainsi construite.

En partant de la demi-droite $`[AB)`$, si je pouvais prolonger le sègment $`[AB]`$ en partant de $`B`$ et en faisant glisser
parallèlement à lui-même le double décimètre vers $`A`$ en répétant l'opération une infinité de fois, alors les deux extrémités
de la ligne tracée seraient toutes deux rejetées à l'infini.    
J'aurais ainsi tracé la droite $`(AB)`$.    
Donc deux points quelconques et distincts $`A`$ et $`B`$ de la droite ainsi tracée pourraient définir cette ligne, et permettre l'appeler droite $`(AB)`$. 

On aura besoin, ici ou au moins au niveau 2, de définir "droite porteuse" d'un sègment, quelque chose comme
pour tout sègment de droite , la droite est la droite porteuse de ce sègment. Sinon, en optique géométrique,
au rythme où on la fait en présentiel c'est un peu la galère. 

#### 1.3 - Droites séquentes et droites parallèles.

idée :    
\- Deux droites distinctes qui se coupent en un point (qui ont un point en commun) sont séquentes en ce point.   
et à ce niveau on peut dire :   
\- Deux droites qui se coupent à l'infini sont parallèles.

--------------------------------------------------

### 2 - Le plan

idée :   
\- intuition, la feuille de papier non pliée
\- par ses propriétés : le chemin le plus court entre deux points quelconques et distincts d'un plan appartient à ce plan.
\- le construire : peut-être partir de droites parallèles entremêlées? difficile à exprimer mais facile à visualiser
(avec un exemple possible d'une grille...)





--------------------------------------------------

### 5 - Les angles

<!---POINT  DE  VOCABULAIRE-----------------------
A discuter mais, pour ce qui concerne la suite en physique :    
vocabulaire utile :    
angle complet, angle plat, angle droit, angle nul, sommet, côté,
angle complémentaire
vocabulaire mois important (ne pas surcharger la mémoire) :   
angle aigu, angle obtu
--------------------------------------------------->


#### 5.1 - Comment définir un angle

idée :
\- deux demi-droites séquentes en un point définissent un plan. Ces 2 demi-droites "séparent" kle plan en deux parties distinctes 
et complémentaires. ces deux demi-droites définissent 2 angles.
\- dans un plan, mesure de l' "écart au parallélisme" entre deux demi-droites du plan.   
soit   
\- dans un plan, mesure de "l'écart" entre deux demi-droites $`[AB)`$ et $`[AC)`$ possédant une extrémité $`A`$ commune.   
notation d'un angle : $`\widehat{BAC}`$ ou $`\widehat{CAB}`$   
(pas de distinction à ce niveau)

#### 5.2 - comment quantifier un angle

le rapporteur.   
les degrés, minutes, secondes angulaires.   
les degrés angulaires décimaux.   
(les grades sont-ils encore utilisés quelque-part?)
pas d'angle en valeur algébrique à ce niveau.

dans un point au-delà : donner une idée de la définition plus mathématique d'un angle :    
interections $`C`$ et $`D`$ entre deux droites séquentes en un point $`O`$ et un cercle $`\mathcal{C}`$ de centre $`O`$. 
angle comme longueur de l'arc du cercle $`\mathcal{C}`$ d'extrémités $`C`$ et $`D`$



#### 5.3 - Les angles remarquables.

##### 5.3.1 - L'angle complet : 360°  

<!--angle complet 360° utile pour définir l'angle plat 180°. Et l'angle plat intervient
dans la démonstration géométrique "somme des 3 angles dans un triangle est de 180°".-->

##### 5.3.2 - L'angle plat : 180°   

Idée :  on plie une feuille de papier de forme quelconque => la pliure est droite. On dessine un point $`A`$ 
sur cette pliure, puis deux points $`B`$ et $`C`$ sur la pliure et de chaque côté du point $`A`$, ce qui permet de définir
soit deux sègments $`[AB]`$ et $`[AC]`$, soit deux demi-droites $`[AB[`$ et $`[AC[`$ d'extrémités $`A`$ commune.   
\- Ces deux demi-droites séparent le plan en deux parties distinctes et complémentaires de "tailles" égales.   
\- Les deux "écarts" entre ces demi-droites, ou ces deux parties de plan de "tailles" égales sont quantifiés 
par deux angles complémentaires qui sont égaux et égales à 180°.
Ces deux angles sont identifiés individuellement par un signe (référer à une figure).   
signe = arc de cercle.

<!--le terme quantifier une quantité me semble imparable, et donc important même à ce niveau...-->

##### 5.3.3 - L'angle droit : 90°   

Idée : on plie à nouveau la feuille précédente, bord sur bord à partir du point $`A`$   
(beaucoup plus facile à visualiser à partir d'une image animée qu'à exprimer en mots, même si savoir
s'exprimer avec des mots est aussi important). Au point $`A`$, les deux pliures séparent le plan en deux parties
de "tailles" différentes, l'une étant "3 fois plus grande" que l'autre (on peut dire cela? sachant que un plan étant infini,
les aires de chacune des parties est aussi infini... première réflexion sur la comparaison d'infinis? niveau 2).   
Les deux pliures définissent deux angles complémentaires 90° et 3$`\times`$ 90° = 360°.


##### 5.3.4 - L'angle de 45°   

Idée : on plie à nouveau la feuille précédente, bord sur bord à partir du point $`A`$.   
Au point $`A`$, les deux pliures séparent le plan en deux parties
de "tailles" différentes, l'une étant "7 fois plus grande" que l'autre.   
Les deux pliures définissent deux angles complémentaires 45° et 7$`\times`$ 45° = 315°.


##### 5.3.5 - L'angle de 60°

Idée : avec un compas, cercle $`\mathcal{C_1}`$ de centre $`O`$. 

\- On choisit un point quelconque $`A`$ sur le cercle,   
pointe du compas en $`A`$ en sans changer l'écartement du compas on trace un nouveau cercle $`\mathcal{C_2}`$.   
$`B`$ et $`C`$ sont les deux points d'intersection de $`\mathcal{C_2}`$ avec $`\mathcal{C_1}`$.   

\- On recommence l'opération en mettant la pointe du compas en $`A`$ et en traçant le cercle $`\mathcal{C_3}`$.   
Un des points d'intersection de $`\mathcal{C_3}`$ avec $`\mathcal{C_1}`$ est soit $`B`$ soit $`C`$, et 
appelons $`D`$ l'autre point d'intersection.

\- On recommence ... etc.

\- Les six points $`A`$, $`B`$, $`C`$, $`D`$, $`E`$ et $`F`$ se répartissent uniformément
sur le cercle $`\mathcal{C_1}`$ de départ.

\- Les six angles $`\widehat{ABC}`$, $`\widehat{BCD}`$, $`\widehat{CDE}`$, $`\widehat{DEF}`$, 
$`\widehat{FEA}`$ et $`\widehat{EAB}`$ sont égaux et leur somme est égale à 360°.   
Leur valeur commune est $`\dfrac{360°}{6}=60°`$.

\- L'angle complémentaire de 60° et 5 $`\times`$ 60° = 300°.

##### 5.3.6 - L'angle de 30°

Idée : 

\- repartir de la figure précédente, en zoomant sur le triangle $`[A0B]`$ et l'angle 
$`\widehat{AOB}`$. Point $`M`$ milieu du sègment $`[AB]`$, demi-droite [OM). Le sègment [OM]
sépare le triangle $`[A0B]`$ en deux triangles semblables $`[A0M]`$ et $`[M0B]`$, 
d'angles en $`O`$ égaux et de valeur commune $`\dfrac{60°}{2}=30°`$.

\- sépare l'angle droit en 3 angles égaux.


##### 5.3.7 - Réaliser un angle de valeur donnée.

\- à l'échelle de quelques centimètres, sur une feuille de papier : avec une règle et un rapporteur
\- à l'échelle du mètre au kilomètre : goniomètre, méthode. Autre?

------------------------------------

<!--====================================================-->

<!--!   
! *SYMÉTRIES ET INVARIANCES EN GÉOMÉTRIE*   
! <!--(autre type de titre possible "J'identifie et réalise des formes, je calcul des surface et des volumes")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>  
! Idée : introduire les éléments de symétries, déjà pour pouvoir dans le chapitre suivant caractériser aussi les différentes
! figures par leurs éléments de symétries
! <br>
! </details>
-->

<br><br>


<!--====================================================-->

!   
! *DES  FIGURES  ET  DES  VOLUMES*   
! <!--(autre type de titre possible "J'identifie et réalise des formes, je calcul des surface et des volumes")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br> 
! LIGNES  DIRECTRICES 
! Idée d'un bloc très "utilitaire". Pour apprendre à reconnaître, nommer et savoir comment contruire des formes, et à recevoir les formules mathématiques pour s'entraîîner à calculer des aires et des volumes.<br>
! PROGRAMME  PROPOSÉ <br>
! 1 - Lignes, surfaces et volumes <br>
! 2 - Les figures simples dans un plan : <br>
! 2.1 - Les quadrilatères <br>
! 2.1.1 - Le quadrilatère <br>
! 2.1.2 - Le rectangle et le carré <br>
! 2.1.2 - Le parallélogramme et le losange <br>
! 2.1.3 - Le trapèze (à ce niveau? vraiment utile?) <br>
! 2.2 - Les triangles <br>
! 2.2.1 - Le triangle <br>
! 2.2.3 - Les triangles isocèle et équilatéral (est-ce vraiment utile?) <br>
! 2.2.4 - Triangles semblables <br>
! 2.2.5 - Tracer un triangle de longueurs de côtés données <br>
! 2.3 - Les polygones <br>
! 2.4 - Le cercle <br>
! 3 - Les volumes simples dans l'espace : <br>
! 3.1 - Le cube et le parallélépipède rectangle <br>
! 3.2 - Les prismes (avec pour base différents polygones) <br>
! 3.3 - Les pyramides (avec pour base différents polygones) <br>
! 3.4 - Le cylindre <br>
! 3.5 - La sphère   
! <br>
! </details>

### 1 - Lignes, surfaces et volumes

idées :
\- dans l'espace :   
&nbsp;&nbsp;\- ligne droite et ligne courbe.  
&nbsp;&nbsp;\- ligne ouverte et ligne fermée.   
&nbsp;&nbsp;\- surface ouverte et surface fermée.   
\- dans un plan, une figure est définie par une ligne fermée. Elle est frontière, elle délimite un intérieur et un extérieur. L'intérieur définie une surface. la surface est plus ou moins grande, elle possède une certaine aire.  
\- dans l'espace, un volume est défini par une surface fermée. Ce volume est plus ou moins grand, sa taille est quantifiée par son ... volume (une ambiguïté qui nous poursuivra jusqu'au niveau 3 au moins...)  

--------------------------------------------------

### 2 - Les figures simples dans un plan :  

#### 2.1 - Les quadrilatères

Idée : commencer par les quadrilatères, et rapidement le rectangle. L'avantage est que l'on peut définir
tout de suite l'aire d'un rectangle et la calculer. On en aura besoin pour calculer l'aire de triangles et autres figures.
Mêême si à ce niveau on donne les équations pour calculer les aires, on pourra faire des figures et animations qui ramènent toutes
à la définition de l'aire d'un rectangle. Et cela sera indispensable aux démonstrations géométriques (visuellement, avec des animations c'est
possible à ce niveau 1) des théorèmes de Thalès et Pytahgores qui sont utiles (parfois sous une forme cachée : règles de 3, coordonnées cartésiennes, ...) toute la vie, et à tout niveau y compris dans la vie quotidienne.

##### 2.1.1 - Le quadrilatère

dans un point "au-delà" ou un "point remarque" : une structure de quadrilatère, même si ses côtés sont rigides, se déforme facilement lorsqu'elle n'est pas pleine. 
A éviter pour faire une structure rigide, en architecture.

##### 2.1.2 - Le rectangle et le carré

définitions
Aire : $`A=a\times b`$, et $`A=a\times a= a^2`$.

Tracer un rectangle quelconque [ABCD]    
\- à l'échelle de quelques centimètres, sur une feuille de papier : ....  
\- à l'échelle de quelques mètres : ...
\- à l'échelle de la dizaine de mètre au kilomètres : ...

##### 2.1.2 - Le parallélogramme et le losange

définitions
Aire : $`A=a\times h_a`$  ou $`A=b\times h_b`$. 


##### 2.1.3 - Le trapèze
(utile à ce niveau? pas fondamental pour la suite ...)


#### 2.2 - Les triangles


##### 2.2.1 - Le triangle

quelconques, isocèles, équilatérales, rectangles.    
Formules de calcul des circonférences et des aires (avec les animations pour une compréhension géométrique)

##### 2.2.2 - Le triangle rectangle

dans un point "au-delà" ou un "point remarque" : une structure triangulaire de côtés rigides, même lorsqu'elle n'est pas pleine, est indéformable.
A privilégier pour faire une structure rigide en architecture.

##### 2.2.3 - Les triangles isocèle et équilatéral (est-ce vraiment utile?)


##### 2.2.4 - Triangles semblables 

Définir


##### 2.2.5 - Tracer un triangle de longueurs de côtés données.

triangle quelconque [ABC], de longueurs de côtés $`d_{AB}=c`$, $`d_{BC}=a`$ et $`d_{CA}=b`$
\- à l'échelle de quelques centimètres, sur une feuille de papier : la règle et le rapporteur.   
\- à l'échelle de quelques mètres : avec une corde de longueur $`L \le a+b+c`$, en reportant à partir
d'une extrémité la longueur c (ce qui définit lorsque la corde est tendue le sègment de droite $`[AB]`$), 
puis la longueur a, puis c, etc... (triangle indéformable) OU avec un goniomètre.   
\- à l'échelle de la dizaine de mètre au kilomètres : goniomètre... méthode. Autre?


#### 2.3 - Les polygones

Notamment les polygones réguliers

dans un "au-delà" faire tendre le nombre de côté du polygone régulier vers l'infini
pour aller vers le cercle. Premier pas (sans le dire) vers la notion de limite.

<br><br>

![](titre-bleu-le-zero-et-l-infini_NB3_L1200.jpg)


--------------------------------------------------

### 3 - La sphère

idée :   
Dans l'espace : tous les points de l'espace situés à une égale distance d'un point appelé centre de la sphère. 
Cette distance égale s'appelle le rayon de la sphère.

--------------------------------------------------

### 4 - Le cercle 

#### 4.1 - Le cercle
idées :   
\- Dans un plan : tous les points du plan situés à une égale distance d'un point appelé centre du cercle. 
Cette distance égale s'appelle le rayon $`R`$ de la sphère.    
\- Intersection entre un plan et une sphère (si intersection il y a...)    
Pour réaliser un cercle :   
\- à l'échelle de quelques centimètres le compas.
\- à l'échelle d'un terrain (plat) : une corde de longueur $`R`$ dont un piquet est attaché à chacune de 
ses extrémités. L'un des piquets est enfoncé dans le sol (centre du cercle). L'autre piquet est déplacé
sur un tour en gardant la corde tendue.

#### 4.2 - l'arc de cercle



#### 2.4 - Le cercle

(doublon ici ...)

Idée :    
A partir d'un point O centre du cercle, ensemble des points situés à un même distance R
(rayon du cercle) de O, et situés dans un même plan contenant O, le plan du cercle.

Tracer un cercle de rayon R :     
\- à l'échelle de quelques centimètres, sur une feuille de papier : compas  
\- à l'échelle de quelques mètres, sur un sol plat : un piquet à chaque extrémité d'une corde de longueur R, etc...
\- à l'échelle de la dizaine de mètre au kilomètres : ...


### 3 - Les volumes simples dans l'espace :  


#### 3.1 - Le cube et le parallélépipède rectangle

volume $`V=a\times b \times c`$


#### 3.2 - Les prismes (avec pour base différents polygones) 

simple défintion et exemples?    
ou en plus :    
aire du polygone de base $`A`$, hauteur $`h`$
volume $`V=A \times h`$


#### 3.3 - Les pyramides (avec pour base différents polygones) 

pour la base carrée, prendre l'exemples de la pyramide de Khéops bien sûr.


#### 3.4 - Le cylindre


#### 3.5 - La sphère

---------------------------

<!--====================================================-->

!   
! *GÉOMÉTRIE  ET  RÈGLES  DE  CALCUL*   
!  <!--(autre type de titre possible "La géométrie m'aide à calculer")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! LIGNES  DIRECTRICES <br>
! un tel bloc "Géométrie et règles de calcul" peut à ce niveau aider ceux qui ont des problèmes avec les règles du calcul numérique.<br>
! PROGRAMME  PROPOSÉ <br>
! 1 - Carrés, rectangles, et l'égalité $`(a+b)^2=a^2+b^2+2ab`$  <br>
! 2 - Carrés, rectangles, triangles rectangles et le théorème de Pythagore <br>
! 3 - Triangles semblables et théorème de Thalès <br>
! 4 - La projection parallèle <br>
! 5 - Cercle, projection, sinus et cosinus <br>
! 6 - Le nombre $`\large{\pi}`$   
! </details>  


#### 1 - Triangles semblables et théorème de Thalès   
(vers la règle de 3, et la proportionnalité)
dans une partie "au-delà" ou dans le texte, citer la légende de Thalès et de la pyramide de Khéops.

#### 2 - Carrés, rectangles, triangles rectangles et le théorème de Pythagore   
(dans un triangle rectangle, $`a^2+b^2=c^2`$). Cette propriété sera la justification du choix future, dès que c'est possible,
de systèmes de coordonnées (et leurs bases et repères associées) orthonormés, de l'opération de projection sur un axe et la définition
du produit scalaire. Il n'y a qu'au niveau 4, lorsqu'il faudra considérer des bases vectorielles non orthonormées, des géométries non euclidiennes, qu'il faudra s'écarter de cela. Et Cela demandera de bien avoir compris ce qu'il y a avant, le tout découlant directement du théorème de Pytahgore.

#### 3 - Carrés, rectangles, et l'égalité $`(a+b)^2=a^2+b^2+2ab`$


#### 4 - La projection parallèle

(très important ici)
Introduire le concept de projection sur une droite (ou un plan) parallèlement à une autre droite non colinéaire (ou non parallèle au plan).
Parler plutôt de projection parallèle (et non orthogonale) parce que c'est le type de projection qui sera utilisée pour les coordonnées, bases et repères cartésiens dans toute la suite. Et dire "parallèle" et non "orthogonale" parce que c'est bien la projection parallèle et non la projection orthogonale lorsqu'au niveau 4 seront abordés les bases non orthogonales et les composantes contravariantes et covariantes.   
Par ailleurs c'est facile à expliquer de façon très intuitive avec une animation : c'est la projection de l'ombre portée d'un style sur une feuille éclairée en plein soleil. Lorsque l'on commencera à parler de coordonnées orthogonales ou orthonormées (niveaux 2 et supérieurs), cela correspondra au cas où le soleil est au zénith.   
C'est aussi une préparation (sans le dire) au produit scalaire, probablement introduit dès le niveau 2.


#### 5 - Cercle, projection, et fonctions sinus et cosinus

de façon très visuel et animée, simplement définition des fonctions sinus et cosinus.
dans un apparté "au-delà" ou dans la partie "au-delà", faire tourner le rayon vecteur pour
faire apparaître les fonctions $`\sin(\theta)`$ et $`\sin(\theta)`$, périodicité et lien vers la notion d'onde
avec les vagues sur l'océan (suffisamment loin de la côte).


#### 6 - Le nombre $`\large{\pi}`$

Même si les fonctions sin et cos seront bien mieux maîtrisées dans les niveaux supérieurs, tous ont au moins une calculatrice (ne serait-ce
que dans leur smartphone) qui donne le résultat numérique du sinus ou du cosinus d'un angle (en degré à ce niveau).   
On peut donc exposer une méthode pour le calcul encadré du nombre pi.
Et proposer dans la partie beyond un défi ou exercice : qu'il applique la méthode pour calculer pi avec un certain  niveau de précisions
donné par le dernier digit).
Cela permet :   
\- de dédramatiser le nombre pi. Certes c'est un nombre (ou ses multiples comme tau ;) ) inclus dans la structure de l'espace euclidien,
mais il se calcule, il se découvre (il n'est pas donné "magiquement").   
\- d'introduire dans un apparté "beyond" ou dans la partie "beyond" la notion de limite, qui sera reprise au niveau 2 (ou 3?).   
\- cela permet d'introduire dans un apparté "beyond" ou dans la partie "beyond" la notion de d'incertitude sur la connaissance d'un nombre,
ou du résultat d'une mesure, qui sera reprise au niveau 2, puis développée dans les niveaux 3 et 4.

---------------------------------------

<!--====================================================-

!   
!  *INVARIANCES  ET  SYMÉTRIES  EN  GÉOMÉTRIE*  
! (autre type de titre possible "Je vois des formes symétriques")
!  (sera probablement un bloc - une page html - à part entière dans cette proposition)
!  Question : Dès ce niveau 1? ou on démarre au niveau 2?   
!  
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! À faire. symétrie par rapport à un point, à une droite, à un plan...<br>
! <br>
! Ce sujet mériterait un chemin pédagogique sur 4 niveaux à lui tout seul.<br>
! <br>
! Mais déjà cela conduit à mettre en valeur (ou être sûr qu'ils apparaissent dans le chapitre DES FIGURES ET DES VOLUMES, je pense en particulier à l'hexagone) les traingles, parallélogrammes quadrilatères et l'hexagone, car on peut remplir un plan avec chacun d'eux sans laisser d'interstices vides. Permiers pas vers les cristaux. On peut prendre comme exemple très concret les formes possibles pour l'élément de base d'une mosaïque ou d'un dallage (en considérant des joints extrêmement fins).<br>
! <br>
! et peut-être les volumes platoniciens? Pas grande utilité de fait. Peut-être simplement dans une partie "beyond"?<br>
! <br>
! </details> 

--------------------------------------------------

====================================================-->

!   
!  *SYSTÈMES  DE  COORDONNÉES*   
!  <!--(autre type de titre possible "Je me situe sur Terre, je repère des lieux")-->
! <details>
! <summary>
! Programme proposé
! </summary>
! <br>
! Introduire les systèmes de coordonnées. <br>
! 1 - Je repère à l'aide de coordonnées <br>
! 2 - Je localise sur le globe terrestre <br>
! 3 - J'utilise une carte géographique <br>
! 4 - Je situe avec une table d'orientation panoramique <br>
! 5 - Je fais une course d'orientation <br>
! 5.1 - avec géolocalisation par satellite <br>
! 5.2 - avec une carte et une boussole <br>
! 5.3 - sans instrument ni carte <br>
! 6 - Du globe terrestre à une carte du monde 
! </details>  



#### 1 - Je repère à l'aide de coordonnées

Espace à 3 dimensions $`\Longrightarrow`$ il faut trois nombres indépendants pour se repérer dans un environnement, ou pour localiser un corps dans l'espace.
3 nombres, peuvent correspondre à des distances ou des angles.


#### 2 - Je localise sur le globe terrestre

latitude, longitude, altitude (2 angles et une longueur)    
une première étape sans le dire vers les coordonnées sphériques (même si les définitions des angles et de la longueur changent).   
à partir de google earth ou d'un équivalent.


#### 3 - J'utilise une carte géographique.

c'est peut-être mieux d'introduire d'abord les coordonnées cartésiennes (sans le dire) avec une carte routière ou le plan 
d'une maison, avant les coordonnées polaires ou cylindriques (sans le dire) avec la table d'orientation panoramique.
Le plan aidera à expliquer certains points concernant la localisation avec la table d'orientation.

la carte est plane (échelle petite et moyenne, de façon qu'il n'y ait pas d'effet de projection visible).   
x, y (plan d'une maison)
"axes nord-sud et est-oouest"  (localisation à la surface), plus éventuellement courbes de niveau sur plan d'une région (altitude).   
En tout, 3 longueurs (l'espace à 3 dimensions)    
une première étape vers les coordonnées cartésiennes.    
(lien avec la représentation d'une fonction f(x) avec des exemples?).   


#### 4 - Je situe avec une table d'orientation panoramique

direction, distance, altitude (1 angles et 2 longueurs)
une première étape sans le dire vers les coordonnées polaires et cylindriques (même si les définitions des angles et de la longueur changent).   
à partir d'une table d'orientation panoramique.


#### 5 - Je fais une course d'orientation


##### 5.1 - avec géolocalisation par satellite.

Obligé, de nos jours. Questions :   
\- Un "déplacement géolocalisé" indiqué comme étant dirigé vers le nord est-il le nord géographique?
\- Peut-on parler d'information géographique globale? (en opposition à locale)

##### 5.2 - avec une carte et une boussole.

Un déplacement en direction du nord tel qu'indiqué par le magnétomètre d'un smartphone (une appli boussole)
et un déplacement en direction du champ magnétique local, supposé être largement dominé par le champ magnééique terrestre.
La boussole donne une information locale.   
La direction de déplacement est redéfinie à chaque "pas" avec les informations locales données par la boussole.

##### 5.3 - sans instrument ni carte.

La encore, à partir d'informations locales. Très important plus tard pour préparer la notion mathématique de gradient (niveau 3).
Le mot "gradient" est aussi un mot de tous les jours intéressant à connaître.
Exemple de situation :   
\- perdu dans le centre-ville d'une ville moyenne portuaire et cotière :   
souhaitant voir le port, à chaque instant je me dirige en direction où "la rue va vers le bas".   
(ici on est sensible visuellement et localement à la pente de la rue).
\- autre exemple : pour un exercice ou point de réflexion dans la partie "au-delà"?   
On est sensible à une bonne odeur de cuisine, et l'on est capable de se diriger vers cette odeur
pour localiser la cuisine ou le restaurant, ou la boulangerie.


#### 6 - Du globe terrestre à une carte du monde.
<!--(autre type de titre possible "De la planète Terre au lieu où je vis")-->

travail sur le globe terrestre, et une représentation projetée sur un plan.   
les distances entre deux lieux sur le globe ne sont pas conservées,   
la surface d'une sphère ne peut se déplier sur un plan sans déformations, déchirures.
dans une partie "au-delà" (en considérant des longueurs de l'ordre du rayon de la "sphère" terrestre,   
des éléments de géométrie (euclidienne) ne sont pas vrais)

----------------------------------------------

<!--====================================================-->

!   
!  *DES  GRANDEURS  PHYSIQUES  QUI  VARIENT, ET  LEURS  REPRESENTATIONS*   
!  <!--(autre type de titre possible "Je modélise la nature")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! L'idée est d'introduire :<br>
! - pour la suite dans ce niveau 1, les grandeurs comme la vitesse, l'accélération, les forces, qui ne se résument pas à un nombre.<br>
! - pour le niveau 2, idem, et on commencera à parler de grandeurs scalaires et vectorielles.<br>
! - pour le niveau 3, les grandeurs et champs scalaires et vectoriels.<br>
! - pour le niveau 4, les grandeurs et champs tensoriels, avec le tenseur comme une généralisation et un dépassement des scalaires et des vecteurs.
! <br>
!
! Donc déjà par dire ce qu'est une grandeur physique (je ne vois pas de mot plus simple pour ce niveau).<br>
! Les grandeurs physiques qui peuvent s'exprimer par un nombre (exemple : température) et par une flèche plus ou moins longues (exemple : vitesse du vent).<br>
! Ces grandeurs peuvent varier dans l'espace comme dans le temps.<br>
! Comment représenter les variations spatiales de ces grandeurs :<br>
! - une carte météorologique des température.<br>
! - une  carte météorologique des vents.<br>
! et leurs variations temporelles
! - pour continuer avec les exemples météorologiques et faire prendre conscience de l'urgence climatique :<br>
! &nbsp;&nbsp; - animation (gif) prévisions températures moyennes sur le globe -->2100 pour différents scénarios.<br>
! &nbsp;&nbsp; - graphique (température moyenne/temps) -->2100 sur une zone donnée du globe.<br>
! <br>
! Lien direct avec un bloc en mathématique sur les fonctions et leurs représentation, avec possibilité d'affichage en parallèle dans un mode.<br>
! <br>
! </details>  

---------------------------------------

<!--====================================================-->

!   
!  *MODELISER  LES  PHENOMENES  OBSERVÉS*   
!  <!--(autre type de titre possible "Je modélise la nature")-->
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! Il s'agit en fait sans le dire d'une première introduction (sans le dire) à la méthode scientifique. A partir des observations sur le temps, l'espace, les corps immobiles et en mouvements et des propriétés géométriques de l'espace et des nombres et des opérations d'introduire  la notion de modélisation physique.<br>  
! <br>
! Et de façon plus concrête, à partir des ces éléments de perceptions et de la mathématique, d'introduire la physique classique et la physique moderne.<br> 
! <br>
! Même si on doit bétonner la physique classique, car c'est celle qui est utile dans la vie de tous les jours, celle qui se "ressent" dans notren expérience du quotidien et qui nous permet de réaliser tout projet à ce niveau 1, il est important d'avoir une connaisance culturelle sur la physique moderne. Et la mise en parallèle de la physique classique, des relativités et quantique permet de mieux comprendre les "bases" de chacune, comment elles façonnent chacune notre vision du monde et se complètent, et de comprendre la notion-même de "modèle".<br>
! <br>
! Donc, a priori, se dirige en ce qui concerne la physique classique, vers la première étape de cinématique (sans dire ce mots), débarrassée des coordonnées. Donc a priori, on partirait des notions de position, de vitesse et d'accélération. Puis (sans le dire) vers des sensations physiques utiles, puis des concepts de dynamique et d'énergétique. <br>
! <br>
! </details>  


<!--====================================================-->


Après, les blocs suivants seront plutôt dans une autre thématique dédiée à la mécanique.   
Pour le côté cinématique (sans dire ce mot) :   
\- distance "à vol d'oiseau" entre deux villes et distance d'un trajet (itinéraire) joignant ces deux villes.   
\- vitesse et accélération   
Etc



