---
title: Properties of the conservative vector fields
published: false
routable: false
visible: false
lessons:
    - slug: gauss-ampere-theorems-demonstration
      name: PARALLÈLE : Les bases pour physiciens au niveau contreforts
      order: 1
---


<!--caligraphie de l'intégrale double curviligne-->
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

<!------Commentaire----------------------------
!  *Thème* :<br>
! *Electrostatique / Démonstration du théorème de Gauss, forme intégrale et forme locale*<br>
! Guide pour établir les 3 parties : main, overview, beyond<br>
!
!  (_précède le thème : Electrostatique : Application du théorème de Gauss, forme intégrale et forme locale._)
----------------------------------------------->

##### Randonnée Contreforts :&nbsp; _toute spécialité_

---------------------------

### PHYSIQUE GÉNÉRALE


### Définitions et propriétés<br>**Gradient**<br>**Champs vectoriels conservatifs**

### Physique<br>**Potentiel et énergie potentiel**<br>**Théorème de conservation de l'énergie mécaniqque**

<br>

GRADIENT  D'UN  CHAMP SCALAIRE<br>_" du champ scalaire au champ vectoriel "_
: ---

  *Définition du gradient* :
  
  Soit $`\phi`$ un champ scalaire.   
  En un point quelconque de l'espace, un déplacement élémentaire $`\overrightarrow{dl}`$ induit
  une variation élémentaire $`d\phi`$ de la valeur du champ.   
  
  Le vecteur $`\overrightarrow{grad}\,\phi`$ réalise ne lien entre $`d\phi`$ et $`\overrightarrow{dl}`$ au point considéré :
  
 $`\mathbf{d\phi=\overrightarrow{grad}\,\phi\cdot\overrightarrow{dl}}`$
 
 *Expressions du gradient*
 
   Coordonnées cartésiennes :   
   $`\begin{align}
   \overrightarrow{grad}\,\phi &=\dfrac{\partial \phi}{\partial x}\,\overrightarrow{e_x}+\dfrac{\partial \phi}{\partial y}\,\overrightarrow{e_y}+\dfrac{\partial \phi}{\partial z}\,\overrightarrow{e_z} \\
    &=\overrightarrow{\nabla}\,\phi
    \end{align}`$
    
   &nbsp;&nbsp;avec opérateur nabla :
   &nbsp;&nbsp;$`\overrightarrow{\nabla}=\dfrac{\partial}{\partial x}\,\overrightarrow{e_x}+\dfrac{\partial}{\partial y}\,\overrightarrow{e_y}+\dfrac{\partial}{\partial z}\,\overrightarrow{e_z}`$

   Coordonnées cylindriques :   
   $`\overrightarrow{grad}\,\phi=\dfrac{\partial \phi}{\partial \rho}\,\overrightarrow{e_{\rho}}+\dfrac{1}{\rho}\,\dfrac{\partial \phi}{\partial \varphi}\,\overrightarrow{e_{\varphi}}+\dfrac{\partial \phi}{\partial z}\,\overrightarrow{e_z}`$

   Coordonnées sphériques :   
   $`\overrightarrow{grad}\,V=\dfrac{\partial \phi}{\partial r}\,\overrightarrow{e_r}+\dfrac{1}{r}\,\dfrac{\partial \phi}{\partial \theta}\,\overrightarrow{e_{\theta}}+\dfrac{1}{r\,sin\,\theta}\,\dfrac{\partial \phi}{\partial \varphi}\,\overrightarrow{e_{\varphi}}`$
 
  *Champ de gradient d'un champ scalaire* :  
  
  L'ensemble des vecteurs gradients en tout point de l'espace est un champ vectoriel, appelé champ de gradient
  
  *Opérateur gradient*
  
  L'opérateur $`\overrightarrow{grad}`$, appliqué à un champ scalaire $`\phi`$ et en un point de l'espace, donne
  le vecteur $`\overrightarrow{grad}\,\phi`$
  
  ---
  
  *Propriétés du gradient*
  
  En tout point de l'espace :
  * $`\overrightarrow{grad}\,\phi`$ pointe en direction et sens où un
   vecteur déplacement  élémentaire $`\overrightarrow{dl}`$ de norme constante $`\Vert\overrightarrow{dl}\Vert`$ 
   induit la variation élémentaire maximale $`d\phi_{MAX}`$ (>0).
  * dans cette direction et sens de variation maximale :
    $`\dfrac{d\phi_{MAX}}{\Vert\overrightarrow{dl}\Vert}=\Vert\overrightarrow{grad}\,\phi\Vert`$
  
  ---

   *Théorème du gradient*
  
  à continuer... nécessaire ici?
    
    
    
CHAMP VECTORIEL CONSERVATIF<br>_" du champ vectoriel (conservatif) aux champs scalaires "_
: ---

  *Définition d'un champ vectoriel conservatif*

  Un champ vectoriel $`\overrightarrow{X}`$ est conservatif si et seulement si il s'identifie
  au champ de gradient d'un champ scalaire $`\phi`$ :

  $`\mathbf{\overrightarrow{X}(\vec{r})\text{ est conservatif }}`$
  $`\mathbf{\Longleftrightarrow\;\exists\,\phi(\vec{r}), \overrightarrow{X(\vec{r})}=\overrightarrow{grad}\,\big(\phi(\vec{r})\big)}`$
  
  *Propriété d'un champ vectoriel conservatif*
  
  La circulation d'un champ vectoriel conservatif $`\overrightarrow{X}=\overrightarrow{grad}(\phi)`$ entre deux points $`M_1`$ et $`M_2`$ ne dépend que
  égale à $`\phi(M_2)-\phi(M_1)`$, quelque-soit le chemin suivi entre ces deux points :
  
  $`\displaystyle\begin{align}\mathbf{\int_{M_1}^{M_2}\overrightarrow{X}\cdot\overrightarrow{dl}}&=\int_{M_1}^{M_2} \overrightarrow{grad}(\phi)\cdot\overrightarrow{dl}\\
    & = \displaystyle\int_{M_1}^{M_2} d\phi\mathbf{\;\;=\phi(M_2)-\phi(M_1)}\\
    \end{align}`$
    
  $`\Longrightarrow`$ La circulation d'un champ vectoriel conservatif le long d'un contour (chemin fermé) est nulle.
  
  ---
  
  *Intérêt en physique*
  
  
POTENTIEL, ÉNERGIE POTENTIELLE,<br> THÉORÈME DE CONSERVATION DE L'ÉNERGIE MÉCANIQUE
: ---

  ATTENTION!! INEXACTITUDES !! EN COURS DE REDACTION !!
  
  *Champs conservatifs en physique*
  
  En physique, les champs d'interaction fondamentaux $`\overrightarrow{X}`$ sont conservatifs,   
  en particulier le champ gravitationnel $`\mathcal{\overrightarrow{G}}`$ et le champ électrostatique $`\overrightarrow{E}`$.   
  <br>
  En électromagnétisme classique :
  * le champ électrique a une composante conservative (le champ électrostatique) et une composante non conservative (un champ électromoteur).
  * le champ magnétique est non conservatif.
  
  *Potentiel*
  
  Un champ scalaire $`\phi`$ tel que $`\overrightarrow{grad}\,\phi=-\,\overrightarrow{X}`$ est appelé "potentiel".
  
  * Potentiel gravitationnel $\phi_{grav}`$ : $`-\,\overrightarrow{grad}\,\phi_{grav}=-\mathcal{\overrightarrow{G}}`$
  * Potentiel électrostatique $\phi_{elec}`$, noté $`V`$ : $`-\,\overrightarrow{grad}\,V=-\overrightarrow{E}`$
  
  *Énergie potentielle*
  
  Une particule de sensibilité $`s`$ à une interaction $`\overrightarrow{X}`$, qui voit en sa position $`\overrightarrow{r}$ 
  un potentiel $`\phi_X(\vec{r}`$, possède une énergie potentielle $`\mathcal{E}_X^{pot}=s\,\phi_X(\vec{r}`$.

  * Interaction gravitationnelle :   
    sensibilité à la gravitation : masse grave = masse, noté $`m`$, telle que $`m\ge 0`$.  
    Energie potentielle gravitationnelle : $`\mathcal{E}_{grav}^{pot}=s\,\phi_{grav}(\vec{r}`$

  * Interaction électrique :   
    sensibilité à l'électromagnétisme : charge électrique, noté $`q`$, telle que $`q\in\mathbb{R}`$,   
    Energie potentielle électrostatique : $`\mathcal{E}_{elec}^{pot}=q\,V(\vec{r}`$
   
  Il existe toujours une infinité de potentiels $`\phi`$ tels que $`\overrightarrow{grad}\,\phi=-\,\overrightarrow{X}`$   
  (exemple : $`\phi`$ et $`\phi+const`$)   
  $`\Longrightarrow`$ l'énergie potentielle n'est pas défini et n'a donc pas d'existence réelle.   
  Mais   
  la circulation d'un champ conservatif entre deux points $`M_1`$ et $`M_2`$ ne dépend pas du chemin suivi :   
  $`\Longrightarrow`$ la différence d'énergie potentielle $`\mathcal{E}^{pot}(M_2)-\mathcal{E}^{pot}(M_1) entre deux points $`M_1`$ et $`M_2`$ est définie.
  
  *Définition et théorème de l'énergie cinétique*
  
   Pour une particule de masse $`m`$ et de vitesse $`\overrightarrow{\mathscr{v}}`$ dans le référentiel d'observation,   
   L'énergie cinétique est définie par : $`\mathcal{E}^{cin}=m\,\mathscr{v}^2`$
   
   Le travail de la force qui s’exerce sur un point matériel entre deux instants $`t_1\text{ et }t_2`$ est égal
   à la variation d’énergie cinétique entre ces deux instants :
   
   $`\displaystyle\mathcal{W}_{t_1t_2}=\int_{t_1}—^{t_2}\overrightarrow{F}\cdot\overrightarrow{dl}=\mathcal{E}_{t_2}^{cin}-\mathcal{E}_{t_1}`$ 
   
   _ou, équivalent :_
   
   Le travail de la force qui s’exerce sur un point matériel le long de sa trajectoire limité entre deux points s $`M_1`$ et $`M_2`$, 
   est égal à la variation d’énergie cinétique entre ces deux points.
   
   $`\displaystyle\mathcal{W}_{M_1M_2}=\int_{M_1}—^{M_2}\overrightarrow{F}\cdot\overrightarrow{dl}=\mathcal{E}_{M_2}^{cin}-\mathcal{E}_{M_1}`$ 

  
  *Définition et théorème de conservation de l'énergie mécanique*
  
  L'énergie mécanique $`\mathcal{E}^{méc}`$ est la somme de l'énergie cinétique et de l'énergie potentielle :   
  $`\mathcal{E}^{méc}=\mathcal{E}^{cin}+\mathcal{E}^{pot}`$
  
  Dans un référentiel d'inertie (= galiléen), l'énergie mécanique d'un point matériel reste constante, lorsque
  ce point se déplace librement dans un champ d'interaction conservatif :   
  $`\mathcal{E}^{méc}=\mathcal{E}^{cin}+\mathcal{E}^{pot}=constante`$
  
 
  

--------------->

  
   
   

En début de construction ! stade très très préliminaire.

déjà poser des qestions,    
mettre les équations qui seront utilisées.

#### LE  GRADIENT

<br>
#### Qu'est-ce qu'un champ scalaire ?

_Exemple "intuitif" d'un champ scalaire défini sur un espace 2D : une carte météorologique, qui donne_
_une représentation des températures constatées ou prévues au niveau du sol._

![](scalar-field-example-temperatures_v2_L800.gif)   

1. Un **champ scalaire** est une *grandeur physique scalaire définie en tout point de l'espace*. 

2. Ce champ est *mathématiquement modélisé* par une **fonction scalaire $`\phi(\vec{r})`$ continue et dérivable**.

3. Les **lignes de niveaux** (2D) ou **surfaces de niveaux** (3D) sont des ensembles continus de points de l'espace 
*caractérisés par une même valeur de champ*.

<!-------------------------
*Mathématiquement*, un champ scalaire $`\phi`$ défini sur l'espace euclidien classique (dimension 3) muni de coordonnées cartésiennes $`(x\,,y\,,z)`$ , s'écrit :
 
 * lorsque la *valeur* scalaire est *réelle* :   
 $`\Phi\quad : \mathbb{R}^3\,\longrightarrow\,\mathbb{R}\, x \,\longmapsto\,\Phi(x)`$
 * lorsque la valeur scalaire est complexe :   
 $`\Phi\quad : \mathbb{R}^3\,\longrightarrow\,\mathbb{C}\, x \,\longmapsto\,\Phi(x)`$
 

! Á tout champ scalaire tu pourras associer un champ de gradient.
------------------------>
 


#### Qu'est-ce qu'un champ vectoriel ?

_Exemple "intuitif" d'un champ vectoriel, défini sur un espace 2D : une carte météorologique, qui donne_
_une représentation de la vitesse des vents mesurée ou prévue au niveau du sol._

![](vector-field-example-speed-wind_v2_L800.gif)   

1. Un **champ vectoriel** est une *grandeur physique vectorielle définie en tout point de l'espace*. 

2. Ce champ est *mathématiquement modélisé* par une **fonction vectorielle $`\overrightarrow{X}(\vec{r})`$ continue et dérivable**.   

3. Les **lignes de champ** sont lignes telles qu'en chaque point d'une ligne, le *champ vectoriel* est *tangent à la ligne*.   
   Chaque ligne de champ porte l'information sur la direction du champ en chacun de ses point, mais *pas d'information sur la norme*.

4. Chaque ligne de champs est *orientée par une flèche* qui indique le *sens du champ vectoriel* sur la ligne.

<!----------------------
*Mathématiquement*, un champ vectoriel $`\overrightarrow{X}`$ défini **sur l'espace euclidien** classique (dimension 3) 
**muni de coordonnées cartésiennes  , s'écrit :   
--------------------->

!!!! *Attention :    
!!!! Tu ne pourras pas* toujours *considérer qu'un champ vectoriel $`\overrightarrow{X}`$ est le gradient d'un champ scalaire*.   
 
 
#### Quelle différence, en physique, entre direction et sens ?

**En français et en physique**, le **mot "direction"** à une *signification différente* de celle *du langage commun*.

* Dans le **langage commun**, regarder dans une direction signifie regarder *devant soi en pointant son regard vers un point* de l'espace.   
<br>
![](direction-common-language_L630.jpg)

* Dans le **langage de la physique, en France**, le mot direction a une *autre signification* :

   * Une **direction**, indiquée en un point, est *portée par une droite* qui contient ce point.   
<br>
![](direction-in-french-physics_L630.jpg)

   * Une *direction plus* un **sens**, indiqués en un point, sont *portés par un axe*, droite orientée par une **flèche qui indique le sens**.   
<br>
![](direction-sens-1_L630.jpg)

   * Une **direction** possède donc *2 sens* possibles.   
<br>
![](direction-sens-1-2_L630.gif)

 
#### Qu'est-ce qu'un champ uniforme, ou au contraire non-uniforme ?


#### Qu'est-ce qu'un champ stationnaire, ou au contraire variable ?


#### Quel est le gradient d'un champ scalaire ?






##### Vecteur gradiant en tout point d'un champ scalaire

_Exemple "intuitif" d'un champ scalaire défini sur un espace 2D : une carte météorologique, qui donne_
_une représentation des températures constatées ou prévues au niveau du sol._   
**$`\large{\mathbf{dV=\overrightarrow{grad}\,V\cdot\overrightarrow{dl}}}`$**

1. Un **champ scalaire** est une *grandeur physique scalaire définie en tout point de l'espace*. 

2. Ce champ est *mathématiquement modélisé* par une **fonction scalaire $`\phi(\vec{r})`$ continue et dérivable**.

3. Les **lignes de niveaux** (2D), ou **surfaces de niveaux** (3D) sont des ensembles continus de points de l'espace
*caractérisés par une même valeur de champ*.

... à modifier ...


##### L'opérateur gradient


##### Le Champ gradient 





**$`\large{\mathbf{dV=\overrightarrow{grad}\,V\cdot\overrightarrow{dl}}}`$**




#### Que représente le gradient d'un champ scalaire ?

**$`\mathbf{dV}`$**$`\;=\overrightarrow{grad}\,V\cdot\overrightarrow{dl}`$
**$`\mathbf{\;=\big\Vert\overrightarrow{grad}\,V\big\Vert\cdot\big\Vert\overrightarrow{dl}\big\Vert\cdot cos\theta}`$**

avec *$`\mathbf{\theta=\big(\widehat{\overrightarrow{grad}\,V\,,\overrightarrow{dl}}\big)}`$*


#### Comment se détermine l'expression du gradient dans un système de coordonnées ?

Je munis l'espace d'un système de coordonnées orthogonales $`(\alpha\,,\beta\,,\gamma)`$

En tout point de l'espace, je peux associer à ces coordonnées une base de vecteurs $`(\alpha\,,\beta\,,\gamma)`$

Ainsi je peux repérer tout point $`M`$ de l'espace par ses coordonnées $`(\alpha_M\,,\beta_M\,,\gamma_M)`$.




À ces coordonnées je peux associer les vecteurs géométriques unitaires

$`\overrightarrow{e_{\alpha}}\,,\overrightarrow{e_{\beta}}\text{ et }\overrightarrow{e_{\gamma}}`$

définie

si d'un point quelconque $`M`$ dans l'espace, de coordonnées $`(\alpha_M\,,\beta_M\,,\gamma_M)`$
je fais un déplacement correspondants aux variations de coordonnées $`d\alpha, d\beta \text{ et } d\gamma`$,


$`dV=\left.\dfrac{\partial V}{\partial \alpha}\right|_M\cdot dl_{\alpha} + \left.\dfrac{\partial V}{\partial \beta}\right|_M\cdot dl_{\beta} + \left.\dfrac{\partial V}{\partial \gamma}\right|_M\cdot dl_{\gamma}`$

$`dV=\left.\dfrac{\partial V}{\partial x}\right|_M\cdot dl_x + \left.\dfrac{\partial V}{\partial y}\right|_M\cdot dl_y + \left.\dfrac{\partial V}{\partial z}\right|_M\cdot dl_z`$




##### Expression du gradient en coordonnées cartésiennes

##### Expression du gradient en coordonnées cylindriques

##### Expression du gradient en coordonnées sphériques







#### CHAMP VECTORIEL CONSERVATIF, POTENTIEL et ÉNERGIE POTENTIEL

A construire... plusieurs figures 

<!-----------------
#### Quand un champ vectoriel est-il conservatif ?


#### Comment est modélisée une interaction mécanique entre deux corps en physique classique ?

interaction mécanique / concept de force entre les deux corps qui interagissent /
champ d'interaction associé / 
----------------->


#### Quel lien entre champ de force conservatif et potentiel ?

![](physics-from-field-to-potentiel_L800.gif)


#### pourquoi le signe "$`-`$" dans $`\overrightarrow{X}=-\,\overrightarrow{grad}\,\phi_X`$ ?


#### Quelle grandeur physique est l'énergie ?


#### Qu'est-ce que l'énergie mécanique ?


#### Qu'est-ce que le théorème de conservation de l'énergie mécanique ?



 
<!--Pour que le signe du potentiel permette de définir bune grandeur qui se conserve l'énergie

Dans un référentiel galiléen, Force d'une interaction s'exercant sur une pârticule sensible à cette interaction :

---> 

`\begin{align}
d\mathcal{W}&=\overrightarrow{F_X}\cdot\overrightarrow{dl}\\
&=m\,\dfrac{\overrightarrow{\mathscr{v}}}{dt}\cdot\overrightarrow{\mathscr{v}}\;dt\\
&=m\,\dfrac{1}{2}\;\left(\dfrac{d\overrightarrow{\mathscr{v}}}{dt}\cdot\overrightarrow{\mathscr{v}}+\overrightarrow{\mathscr{v}}\cdot\dfrac{d\overrightarrow{\mathscr{v}}}{dt}\right)\,dt\end{align}`








