---
title: Contributing
slug: contributing
---

## How it works

- 📖 *Flat files*
  - [enhanced markdown](#enhanced-markdown) for content
  - [YAML frontmatter](https://learn.getgrav.org/15/content/headers) for metadata
- 🦊 *Continuous integration* using [GitLab (Ruby)](https://m3p2.ljbac.com)
- 🌎 *Decentralized versioning* using [Git](https://en.wikipedia.org/wiki/Git)
  - asynchronous and offline collaboration
  - scales to thousands of contributors
- 🚀 *HTML generation* using [Grav (PHP)](https://m3p2.ljbac.com/m3p2/grav-website)
  - basically the new WordPress, _but much better_
  - vibrant and growing community in 2019


## Data Flow

```mermaid

graph RL

User(Teacher)
Website[M3P2 Website]
Local[Local Website]
Git[Git]
GitLab[GitLab]

User --> |contributes via| Git
User --> |contributes via| GitLab
User --> |contributes via| Local

Local --> |triggers| Git
Git --> |triggers| GitLab
GitLab --> |updates| Website

```


<marquee>🐠</marquee>


## Enhanced Markdown

The point of Markdown (compared to raw HTML) is the _readability of the source_.


### Markdown Cheatsheet

    # Header like h1
    ## Header like h2
    …
    ###### Header like h6
    
    _italic_
    __underlined__
    *bold*
    **strong**
    ~~strike-through~~
    
    `inline->code()`
    
    ```python
    import antigravity
    antigravity.apply()
    ```
    
    
    Go [there](https://…)
    [Current chapter](.)
    [Parent chapter](..)
    [Sibling chapter](../another-chapter)
    [Child chapter](chapter)
    [Anchor in the page](#slug-of-header)
    
    ![Description of the image](local-image.png)
    
    ! blue notice
    !! green notice
    !!! orange notice
    !!!! red notice
    !!!!
    !!!! another line on the red notice

> More at Gitlab's [Markdown documentation](https://docs.gitlab.com/ee/user/markdown.html).



### Emoticons ✨

Just type or paste the unicode character, modern browsers will do the rest.

Here's a handy list: https://unicode.org/emoji/charts/full-emoji-list.html



### LateX

You can use LateX in the courses.

For example, the following

    $E = m \cdot c^2$

yields $E = m \cdot c^2$

!!!! Make sure to *add trailing spaces* to expressions like `\cdot`,
!!!! or you'll end up with broken formulas.



#### Multiline

The preferred way is to use a `math` code block, like so:


    ```math
    \overrightarrow{F}_{L} = q \cdot (
        \overrightarrow{E}
        +
        \overrightarrow{v}
        \wedge
        \overrightarrow{B}
    )
    ```

The `math` code block also works in GitLab's preview.

_You can also use the `$$` syntax, but GitLab won't understand it._

!! Generous spacing greatly improves the readability of the source.



### Flowcharts

> _Any resemblance to real persons, living or dead, is purely coincidental._

```mermaid
graph TB
  subgraph M3P2
    Draft[Draft]
    File[File]
    Website[Website]
    Pipeline[Pipeline]
  end

  Sponsor((Sponsor))
  Teacher((Teacher))
  Student((Student))
  Engineer((Engineer))

  Student --> |studies| Website
  Student --> |loves| Sponsor
  Student --> |respects| Teacher
  Student --> |complements| Draft
  Teacher -.- Engineer
  Sponsor --> |feeds| Teacher
  Sponsor --> |feeds| Engineer
  Teacher --> |reviews| Draft
  File --> |triggers| Pipeline
  Draft -.- File
  Pipeline --> |updates| Website
  Teacher --> |authors| File
  Engineer --> |specifies| File
  Engineer --> |maintains| Pipeline
  Engineer --> |hosts| Website
```

    ```mermaid
    graph TB
      subgraph M3P2
        Draft[Draft]
        File[File]
        Website[Website]
        Pipeline[Pipeline]
      end
    
      Sponsor((Sponsor))
      Teacher((Teacher))
      Student((Student))
      Engineer((Engineer))
    
      Student --> |studies| Website
      Student --> |loves| Sponsor
      Student --> |respects| Teacher
      Student --> |complements| Draft
      Teacher -.- Engineer
      Sponsor --> |feeds| Teacher
      Sponsor --> |feeds| Engineer
      Teacher --> |reviews| Draft
      File --> |triggers| Pipeline
      Draft -.- File
      Pipeline --> |updates| Website
      Teacher --> |authors| File
      Engineer --> |specifies| File
      Engineer --> |maintains| Pipeline
      Engineer --> |hosts| Website
    ```
