---
title: Introduction à l'étude de l'instrumentation pour l'astronomie
published: false
routable: false
visible: false
lessons:
    - slug: introduction-instrumentation-for-astronomy-4
      name: LINÈAIRE : Introduction à l'instrumentation pour l'astronomie
      order: 1
---


### Instrumentation et représentation de l'Univers : <br>une approche historique

#### 1 - Le rôle de l'observation dans l'astronomie
<br>
Comment aborder un cours sur "l' instrumentation pour l'astronomie"? La plupart des 
enseignements ou des ouvrages publiés sur cette question, limitent leur champ au 
traitement d'un nombre plus ou moins grand de problèmes que la _physique_ permet 
de résoudre et qui ont un rapport plus ou moins direct avec les instruments (ou le
plus souvent avec des méthodes de mesure).

Pourtant, pour l'étudiant de _physique_ qui aborde une formation destinée à le préparer
à la recherche en _astronomie_, la difficulté est grande de replacer chacun des problèmes
de physique dans le très vaste champ de l'instrumentation astronomique. Les problèmes 
rencontrés dans la pratique de l'astronomie, notamment pour sa composante instrumentale, 
ne sont pas tous solubles à l'instant où on pourrait le souhaiter et leur identification 
ne va pas toujours de soi. Enfin, l'instrumentation pour l'_astronomie_ se développe
toujours dans un champ d'activité humaine très vaste qui lui attribue un caractère 
multidimensionnelle très complexe. De ce fait, tout approche fondée exclusivement sur 
_la physique et les mathématiques_ ne pourra aborder une étude de l'instrumentation 
en astronomique qui prennent en compte toute sa complexité. En particulier dans la 
plupart des ouvrages publiés sur le sujet, la composante humaine pourtant essentielle, e
st occultée. Le but fixé dans notre approche est d'aborder de front la complexité de la question.
L'ambition est davantage d'identifier les problèmes que de les résoudre : pour beaucoup 
d'entre eux, notamment pour tous ceux qui peuvent être traités par la physique, 
des renvoies seront faits vers des ouvrages publiés. Les parties développées ou 
détaillées seront celles qui font défaut dans les publications disponibles ou 
qui sont apparues comme les plus chargés de lacunes dans les générations
d'étudiants rencontrés. 

Le parti pris est de traiter des concepts susceptibles de rendre compte de la réalité d
e l'instrumentation pour l'astronomie. Cette priorité mise, des conceptions seront des 
concessions seront faites, notamment avec la rigueur mathématique des calculs présentés. 
Ces derniers n'ont jamais un caractère bien original et le lecteur intéressé pourra 
toujours consulter les ouvrages de mathématiques adéquat. Un autre compromis a été 
recherché dans le choix des questions abordées. Ce choix résulte des lacunes constatées 
parmi les connaissances d'une douzaine de générations d'étudiants du DEA Toulouse. 
L'objectif de ce cours étant d'être utile, beaucoup de problèmes ou de domaine, 
généralement bien maîtrisés par les étudiants ont été omis ou simplement effleurés ; 
d'autres, même d'un niveau modeste et en principe déjà traités (en second cycle universitaire 
ou dans le cas d'autres cours) mais dans la maîtrise s'est avérée fragile, ont été abordés, parfois exhaustivement. Enfin, l'approche des questions n'a pas hésité à sortir des sentiers battus du standard universitaire. La raison est toujours autant pédagogique que philosophique. Pédagogique car des approches diverses sont toujours bénéfiques. Pour accéder à une meilleure compréhension. Philosophique car la volonté de se soustraire à un enseignement dogmatique doit enduire un comportement pratique ouvert et risqué. Plutôt que de vouloir transmettre un savoir constitué (c'est à dire un état des connaissances figé), ce cours à l'ambition d'aider les étudiants à se poser des questions sur la base de connaissances en évolution. Il leur appartiendra, ensuite, de les reformuler à leur convenance et de tenter d'y répondre en faisant appel aux connaissances acquises dans les autres cours, dans leurs études et leurs expériences personnelles.    
L'approche ici présentée tente d'être globalisante pour poser les problèmes ; son 
cheminement va du général au particulier, même si le général limite parfois la description 
à un niveau relativement superficiel et souvent abstrait.   
Les 5 questions fondamentales sous-jacentes, posées relativement à l'instrumentation 
à l'astronomie, sont :
* qu'est-ce que c'est ?
* de quoi c'est fait ?
* comment ça fonctionne ? 
* à quoi cela sert ? 
* Vers quoi cela évolue ? 

Il est très facile de répondre à ces quatre questions sur des exemples. Il est moins 
aisé de les aborder d'un point de vue général. Plutôt que de tenter des réponses 
séparées à chacune des questions, une démarche de mise en perspective historique 
a été préférée. Cette approche est apparue plus fructueuse, ne serait-ce que pour
appréhender les effets d'évolution indispensables pour préparer l'approche au problème
de l'avenir de l'instrumentation en astronomie. Or, c'est l'avenir qui occupe la place
centrale des préoccupations dès qu'il s'agit de formation...    
Enfin, notre approche c'est limité à l'instrumentation pour l'_astronomie_ 
du rayonnement électromagnétique.    
Elle est étroitement corrélée à l'essentiel des connaissances relatives à l'univers.
Dans le passé, l'étude des météorites et des Rayons Cosmiques (particules chargées ou
neutres, animées de vitesse dans les valeurs approchent parfois en ordre de grandeur 
celle de la lumière, $`c=299\,792\,458 \;m\,s^{-1}`$), a joué un rôle modeste,
comparativement à celui de l'astronomie électromagnétique. Au cours des dernières décennies, 
les sondages in situ des plasma spatiaux ont apporté beaucoup à la connaissance de la
magnétosphère terrestre et du milieu interplanétaire ; mais ces mesures ne concernent 
que le Système Solaire. Aujourd'hui la mesure des flux de neutrino est tout à fait intéressante,
mais son intérêt reste focalisé sur l'étendue plus précises des structures internes des 
étoiles ou des phénomènes d'explosion de supernova. La détection des zones gravitationnelles 
ouvre les perspectives d'une nouvelle astronomie tant les potentialités en ce domaine son
vastes : mais nous nous sommes encore aujourd’hui que dans des phases initiales de programmes
envisagés pour le siècle prochain.    
Aussi, nous paraît-il acceptable de borner, pour l'instant, l'étude de l'instrumentation
à celle de l'astronomie du rayonnement électromagnétique.
Afin d'alléger la lecture, trois types de renvois ont été systématiquement faits. Les références 
bibliographiques sont rejetés dans l'annexe A4 où elles ont été classées par chapitre. 
Chaque nom des grandes figures de l'astronomie fait l'objet d'une fiche ;  ces fiches sont 
classées par ordre chronologique dans l'annexe 1 ("fiches biographiques et séquentielles). 
La description de chaque type d'instruments et celle de quelques systèmes instrumentaux exemplaires 
ou récents a été renvoyée dans des fiches classées dans l'annexe A2. Quelques rappels de 
techniques mathématiques élémentaires sont indiquées dans l'annexe A3. Enfin, un lexique des 
mots clés a été rédigé et mis dans l'annexe A5 : ce lexique est d'importance car comme l'a écrit 
EPICURE dans sa lettre a Hérodote : "il faut savoir à quoi renvoie les mots afin que nous ayons 
une pierre de touche à laquelle rapporter les opinions... afin que les notions restées floues
ne nous rejettent pas dans l'incertitude... afin que nous ne parlions pas pour ne rien dire."

Enfin, le souci majeur qui a présidé à la réduction de secours et __la mise en relation__ 
d'éléments que la réalité rassemble mais que l'approche cloisonnée des disciplines dissocie 
(y compris au sein de la physique lorsque, par exemple, il faut passer de la photométrie à 
l'optique géométrique, puis à l'optique ondulatoire, puis à la physique quantique appliquée 
à l'étude des photons).  L'approche est donc délibérément multidimensionnelle au risque de
demeurer superficielle. Les sciences construisent des démarches, étayées par des présupposés
philosophiques : l'histoire de l'astronomie illustre superbement se fait. Pourtant, un prudent 
silence évite presque toujours d'afficher ces présupposés et de discuter cette mise en relation 
science/philosophie. Le risque a été pris de l'évoquer clairement en avançant sans masque. 
Au lecteur de corriger les biais qu'il ne manquera pas de discerner, et d'entreprendre un 
travail personnel pour penser par lui-même. 

Guy Serra

<br>

#### 2 - L'astronomie et les préhistoires

<br>

Quand commence l'astronomie ? Sans doute il y a bien longtemps lorsque la pensée abstraite est devenue accessible aux femmes et aux hommes de la préhistoire. Encore qu'il faille se méfier des mots. L'astronomie de ses époques reculées n'avait de commun avec la nôtre que l'objectif de connaissance de l'univers ; cet univers pouvant souvent se réduire au ciel avec les phénomènes qui s'y déroulent. De plus, le mot "préhistoire" s'applique à des époques et des sociétés humaines qui ne possèdent pas l'écriture. Autant dire que la préhistoire ne peut pas se réduire à un intervalle de temps dans une chronologie universelle de l'évolution humaine. 
Il n'y a pas une préhistoire, mais de nombreuses préhistoires dans certaines s'achève de nos jours. L'étude des sociétés préhistoriques quasi contemporaines montre toute la richesse culturelle que de telles sociétés peuvent avoir. Malheureusement, l'absence d'écriture établit un certain type de limitation absolue dans l'acquisition et la perpétuation des connaissances. En particulier, le savoir va évoluer sans cesse en perdant la connaissance des états antérieurs. Aussi est-il très difficile, souvent impossible, de percevoir par exemple, quelles étaient les connaissances astronomiques des sociétés préhistoriques de l'Europe occidentale. Certains chercheurs voient dans des monuments mégalithiques, comme celui de Stonehenge en Grande-Bretagne, des observatoires enregistrant les directions caractéristiques des solstices et des équinoxes. Si tel était le cas, le gigantisme dans l'instrumentation astronomique ne date pas d'aujourd'hui !  Mais il est bien difficile de conclure sur ce sujet, à cause de la pauvreté des informations disponibles à ce jour.

Sans doute aussi, existait-il dans l'Amérique précolombienne des "observatoires" astronomique de pierre (Le Caracol de Chichen Itza au Yucatan ?)  permettant la mesure d'angles formés par différentes directions des astres "visibles", dont les plus importants étaient, d'évidence, le soleil et la lune. Il s'en est fallu de peu pour que nous puissions beaucoup mieux connaître cette "astronomie" et ses instruments puisque le peuple aztèque, par exemple, possédait une langue et un ensemble de signes constituant une forme très archaïque d'écriture. 
Les Mayas avaient eux aussi, dès le V<sup>ème</sup> siècle, deux types d'écriture primitive. Malheureusement les conquérants européens, dans leur volonté d'imposer le dogme chrétien, détruisirent la plupart des manuscrits mayas et aztèques dont beaucoup avaient, pour support, des écorces d'arbres. Il ne reste aujourd'hui que des monuments de pierre dont une des fonctions semble bien avoir été celle d'observatoires astronomiques ; des recherches sont en cours sur ce sujet. D'autres vestiges existent comme, par exemple, un objet en mosaïque, calendrier aztèque attestant une connaissance du temps corrélé au mouvement des astres. Indépendamment de l'écriture, des gravures sur roche témoignent de l'intérêt que les êtres humains ont souvent porté au phénomène du ciel. Des symboles figurants la lune, le soleil et les étoiles ont été gravés sur de nombreux rochers depuis les Pyrénées jusqu'en Amérique du Nord. Mais l'interprétation de tous ces pictogrammes demeure problématique. Il faut attendre l'écriture pour accéder à un ensemble suffisant d'informations pour caractériser une "astronomie".
Ce n'est probablement pas un hasard si les trois foyers indépendants d'apparition de l'écriture coïncident parfaitement avec les trois sites où s'est accomplie, quelques millénaires plutôt et de manière probablement indépendantes, la révolution néolithique. 

Voici environ une dizaine de milliers d'années, des peuples se sédentarisent en Mésopotamie, en tirant principalement leurs ressources d'une agriculture naissante. Cette révolution constitue le passage des sociétés préhistoriques paléolithiques (dont l'économie repose entièrement sur l'exploitation directe des ressources naturelles par la chasse, la pêche et la cueillette) aux sociétés néolithiques déjà proches des civilisations protohistoriques.

!!!!! *Terminologie : préhistorique, protohistoriques, historique*    
!!!!! À faire.

En moins d'un millénaire, cette révolution économique sociale et culturelle s'étend tout autour de la partie orientale du bassin méditerranéen, depuis la Grèce jusqu'à l'Egypte. Durant les deux millénaires suivants cette zone s'agrandit vers le Caucase et les régions de l'actuel Bulgarie alors que, parallèlement et de manière probablement indépendante, la révolution néolithique s'opère en Amérique Centrale. Vers 5000 à 6000 ans avant notre ère, ce dernier foyer s'est étendu sur une bonne partie du Mexique actuel. Dans le même temps, sur notre continent, les civilisations néolitiques habitent désormais tout le pourtour de la Méditerranée, sur une frange de terre très étroite dans la partie occidentale, alors qu'à l'Est l'expansion atteint la vallée de l'Indus ; une autre zone traverse l'Europe de la mer Noire à la mer du Nord. Simultanément, et probablement encore une fois de manière indépendante, un troisième foyer de civilisation néolithique apparaît dans la plaine de Chine, le long du "fleuve Jaune" (Houang-Ho ou Huanghe, ou encore Huang Hé). Il faudra encore 3,5 millénaires pour que dans cette vallée fertile apparaissent l'écriture du chinois ancien. Une riche civilisation évoluera dans cette région, de manière relativement autonome, pendant de très nombreux siècles. Une astronomie se développera, avec des instruments et des représentations originales de l'univers. Sans doute, beaucoup de travail reste à faire pour comparer le cours de cet astronomie, très florissante à certaines époques, avec celle qui s'est développée depuis la Mésopotamie ancienne jusqu'à l'Europe occidentale de la Renaissance, en passant par la Grèce antique et l'Égypte. 

Mais revenons en arrière, vers la première moitié du quatrième millénaire avant notre ère. Probablement dans les basses vallées de l'Euphrate et du Tigre, à proximité du Golfe Persique les sumériens gravent des signes cunéiformes qui constituent la souche commune la plus ancienne de la plupart des langues parlées et écrites en usage aujourd'hui (exception faite de celles dérivant de la souche du chinois ancien). Avec l'apparition de l'écriture, des textes sont écrits qui fournissent quantité d'informations sur cette civilisation.

<br><br>

#### 3 - L'astronomie et son instrumentation<br> en Mésopotamie antique

<br><br>

#### 4 - L'astronomie et son instrumentation<br> dans la Grèce antique et l'Empire romain

<br><br>

#### 5 - L'astronomie et son instrumentation<br> au Moyen Âge

<br><br>

#### 6 - Les révolutions de l'astronomie<br> à la Renaissance

<br><br>

#### 7 - L'essor de l'astronomie et de son instrumentation<br> aux Temps modernes

<br><br>

#### 8 - La place de l'instrumentation<br> dans l'histoire de l'astronomie

<br><br>

#### 9 - La place de l'instrumentation<br> dans l'astronomie d'aujourd'hui









