---
title: 'A curriculum structured in 8 main subject areas'
media_order: 'my-anxiety-en.jpg,viajar-en.jpg,mis-certezas-falsas-en.jpg,m3p2-circuits-LR-en.png,m3p2-8-domaines-LR-fr.png,m3p2-8-domaines-LR-es.png,paysage-v10-en.jpg,paysage-v9-es.jpg,paysage-v9-fr.jpg,planet_earth.jpg,m3p2-pathways-LR-es.png,m3p2-pathways-LR-fr.png,m3p2-pathways-LR-en.png,m3p2-8-domaines-LR-en.png,m3p2-circuits-LR-es.png,m3p2-circuits-LR-fr.png,mis-certezas-falsas-fr.jpg,viajar-fr.jpg,my-anxiety-es.jpg,mis-certezas-falsas-es.jpg'
published: true
routable: true
visible: true
lessons:
    - slug: m3p2-structure-spirit-pedagogy
      name: Structure, Spirit and Pedagogy
      order: 1
---

![](titre-structure.png)

#### 8 main subject areas
to meet 3 requirements :

![](m3p2-8-domaines-LR-en.png)

**An outside world to understand and master**
* Perceptions of the outside world ⟹ *experimental sciences*.
* Internal logic and mental representations ⟹ *ability to model the world*.
* Environmental, social, and economic interactions ⟹ *ability to understand and master technologies*.

**An inner self to know**
* A being in search of meaning ⟹ what science reveals about our *origins and fundamentals*.
* An inner physical body ⟹ the knowledge of our *body and its needs*.
* An inner psychic being ⟹ the knowledge of our *thinking being and its cognitive biases*.

**A being in interaction with the outside world** (physical, social and technological):
* A relational being, which *perceives other beings and perceives himself through others*.
* A relational being, who understands, *communicates and acts with others*, in a team, in society, internationally.
* A being whose *actions* have a *societal, ethical and environmental impact*.


#### A coherent and progressive training

* in **4 levels**
* **from basic to undergraduate level**
* carried out by the *same pedagogical team* to ensure continuity

*to better adapt to these situations experienced by young learners :*

![](my-anxiety-en.jpg)

* ##### I have never studied this before, I am going to fail
 _“I didn't take the ‘Optics’ course when I was in high school, I will not be able to understand now…”_<br>
	When studying **at level N, I can instantly return to level N-1** (or review both in parallel) *to fill a gap or review a concept or a prerequisite*.
    
* ##### It is too abstract. Is there a concrete connection ?
 _“This concept is mathematically complex. Where can I see its application in everyday life? Is it something I know and experience ?”_<br>
*Behind the level 4 mathematical complexity* of a phenomenon, its **description at base level is close to what I feel and experienced daily**, to what I understand with words.

* ##### What to study next year ? No idea... I know nothing about university studies !
 _“I am interested in that specific subject at level N. But what does it look like at level N+1? Or N+2? Which mathematical concepts are required ? Will it really suit me ?”_<br>
If I am still in high school, **I can have a look at how this subject is taught at university**, and determine if my interest is *simply cultural, or* if I am *ready to go further into the complexity and abstraction* of this subject at university.


![](mis-certezas-falsas-en.jpg)

* ##### This is not for me. I wouldn't stand a chance!
 _“This field fascinates me. But it is not for me… no one in my family is familiar with this field of science, no one will be able to help me. It is not for ‘us’”_<br>
**I can study gradually, at my own pace**, over a period of a few months to a few years. And what is beyond a “standard course”, the whole *cultural aspect of the subject is here part of the pedagogy*.

* ##### It would be too difficult for me to go back to school
 _“The circumstances of life ... Now I have the motivation, but I have had a two-year break… I’ve forgotten everything and I’ll never be able to go back to school, or attend university”_.<br>
**I can start again at level N that I used to have**, *go back at any time to level N-1 if necessary, and prepare level N+1*.

* ##### This education leads nowhere
 _“Why study now? This training is a dead end! I will never be able to progress any further. Higher education is off-limits to me”_.<br>
I can see–in real time–that **M3P2 delivers progressive learning, starting at a base level and leading to an undergraduate level**, *as taught in partner universities*.

#### Intercultural learning in Spanish, French and English

**For each subject area** of the M3P2 curriculum :
*  an **international pedagogical team** develops the structure and the pedagogical contents.
*  each of **the partner universities validates the pedagogical content** (in a balanced collaboration between European and Latin American partners).

*to better adapt to these situations experienced by young learners :*

![](viajar-en.jpg)

* ##### What I like are sciences, not languages !
 _“I am only interested in science and technology. I’m not good at foreign languages, but never mind, it’s not that important.”_<br>
I am encouraged to choose at least two languages, and **one of the presentation modes provides parallel lessons in the two chosen languages**, including text, audio, and video (see “Pedagogical method”).

* ##### I won’t be able to recognize scientific vocabulary
_“I’m doing an exchange at a partner university. I have all the scientific prerequisites, but over there the language will be different. I am excited, but at the same time a little anxious; will I recognize the technical terms and linguistic expressions?”_<br>
The courses are identical in all three languages, so that **I can practice identifying equivalent turns of phrase, on top of technical and scientific vocabulary** between the three languages.

* ##### I won’t ever get the chance to travel ...
 _“For me, to travel is a utopian dream… I won't ever get the chance to travel, so why should I be interested in the intercultural aspect and foreign languages?”_<br>
Sometimes it is easy for young people to travel, sometimes it is an achievable goal, and sometimes it can seem like a utopian dream. Even in the latter case, opportunities may present themselves and **I am encouraged to discover this intercultural aspect and to prepare accordingly**.

#### A training in 4 levels

**Pedagogical stage** : *teaching of a specific subject at a specific level*
_The white and red dots on the figure_.

**Pedagogical pathway** : *teaching of a specific subject on the 4 different levels*<br>
_The yellow line that connects the red dots on the figure._

![](m3p2-pathways-LR-en.png)<br>
_Schematic representation of the M3P2 structure: the pedagogical pathway_

The stages in a pedagogical pathway by **increasing levels of difficulty** are known as *plains, hills, foothills* and *mountains*.

![](paysage-v10-en.jpg)<br>
_Progressing on the pathways of knowledge will require training and perseverance, but do not forget that with time you will see further, the perspective will be more beautiful, and your steps more assured and enduring._

**Foothill and mountain pathways** : courses corresponding to undergraduate education provided in partner universities.

**Plain pathways** : what everyone should know.

**Hill pathways** : no direct correspondence with high school programs.

!!!! *M3P2 is not a training site for national baccalaureate exams* in the various countries of the partner institutions. If you are a high school student, M3P2 can help you understand some of the course content, but it *cannot and should not be taken as a substitute for high school education*.

#### A set of levels attributed to all subjects

**Pedagogical circuit** : when *a stage is selected on each pedagogical pathway* of the curriculum, the *set of all these stages* constitutes a pedagogical circuit.

![](m3p2-circuits-LR-en.png)<br>
_Schematic representation of the M3P2 structure: the pedagogical circuit_

#### A training objective to accomplish

**Pedagogical project** = a *targeted pedagogical circuit* + a *date* of achievement

It can be :
* a *soft pedagogical project*, such as :<br>
\- a personal training objective.<br>
\- a set of prerequisites to master, suggested by a partner university for a more relaxed academic year.<br>

* a *challenge*, such as :<br>
\- a program for admission tests in a partner university.

* a *pedagogical agreement* between a student and the host institution, such as :<br>
\- an academic program to validate before a given date, in order to be accepted in the next academic year.

#### Validated pedagogical content and projects

**A pedagogical team** on a given subject area :
* **is composed of** *lecturer-researchers and researchers from partner universities* on this subject, *external professors and researchers, experts in the subject*, and *external contributors*.
* **is international** : partner universities achieve a geographical balance between Europe and Latin America.
* **defines** the *structure of the curriculum* and **produces** the *pedagogical content*.

**partner universities** on a given subject area :
* **validate together** the *quality of the pedagogical content*.
* **can individually propose** *one or more pedagogical circuits*.



