---
title: 'Electrostatique : Calculs directs'
published: true
routable: true
visible: false
lessons:
    -
        slug: electrostatics-direct-3-linear
        name: LINÉAIRE-3 : Les causes d'un champ électrostatique
        order: 1
    -
        slug: causes-stationary-electric-magnetic-fields
        name: PARALLÈLE-3 : Les causes des champs E et B statiques
        order: 2
    -
        slug: electrostatics-cylindrical-charge-direct-gauss-integral-local
        name: PARALLÈLE-3 : Comparaison calcul direct, Gauss intégral et local
        order: 1
    -
        slug: rectilinear-line-electrosta-magnetostat-electromag
        name: PANORAMA-34 : le fil, en ElectroStat., MagnétoStat. et ÉlectroMag.
        order: 1
    -   
        slug: electrostatics-causes-effects-3
        name: PARALLÈLE-3 : Phénomènes électrostatiques
        order: 1
---

<!--caligraphie Latex spécifique-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Loiint{\displaystyle\mathop{{\iint}\mkern-22mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

        
*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-7_L1200.jpg)<details>
<summary>Etape 7 : En test auprès d'étudiants</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

<!--MétaDonnée : ... -->

##### Randonnée Contreforts :&nbsp; _toute spécialité_

---------------------------

### Électrostatique



#### Loi de Coulomb

* Soient **deux charges électriques ponctuelles immobiles** quelconques dans le référentiel de l'observateur, 
   * la *charge $`q_1`$ au point $`P_1`$*
   * la *charge $`q_2`$ au point $`P_2`$ *
   
   de l'espace.     
   <br>
La **loi de Coulomb** exprime la *force $`\overrightarrow{F}_{12}`$* qu'exerce la charge $`q_1`$ sur la charge $`q_2`$ :      
<br>
**$`\mathbf{ \overrightarrow{F_{12}}=\dfrac{1}{4\pi\epsilon_0}\cdot q_1 \, q_2\cdot\dfrac{\overrightarrow{P_1P_2}}{\lVert\overrightarrow{P_1P_2} \rVert^3}}`$**.   

<br>

* Dans un **repère de l'espace** de point **origine $`O`$** où chaque charge est repérée par leur *vecteur position*, soit :
   * la *charge $`q_1`$* par *$`\overrightarrow{r_1}=\overrightarrow{OP_1}`$*
   * la *charge $`q_2`$* par *$`\overrightarrow{r_2}=\overrightarrow{OP_2}`$*
   
   la loi de Coulomb se réécrit :   
<br>
$`\overrightarrow{F_{12}}=\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1 \, q_2}{\lVert\overrightarrow{r_2}-\overrightarrow{r_1}\rVert^3}\cdot (\overrightarrow{r_2}-\overrightarrow{r_1})`$   
<br>
soit encore,   
<br>
**$`\mathbf{ \overrightarrow{F_{12}}=\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1 \, q_2}{r_{12}^3}\cdot\overrightarrow{e_{12}}}`$**,   
<br>
avec *$`\mathbf{\overrightarrow{r_{12}}=\overrightarrow{r_2}-\overrightarrow{r_1}}`$*$`=\overrightarrow{P_1P_2}\quad`$ et 
*$`\mathbf{\quad\overrightarrow{e_{12}}=\dfrac{\overrightarrow{r_{12}}}{\lVert \overrightarrow{r_{12}} \rVert}}`$*


#### Champ électrostatique

* Il est possible de *séparer l'influence de la charge $`q_1`$ en $`\overrightarrow{r_2}`$*, position $`\overrightarrow{r_2}`$
  de la charge $`q_2`$, *de $`q_2`$* elle-même, en écrivant :   
  <br>
  *$`\mathbf{\overrightarrow{F_{12}}=\,}`$* **$`\mathbf{\overrightarrow{E_{12}}}`$** *$`\mathbf{\times q_2}}`$*   
  <br>
  où $`\overrightarrow{E_{12}}`$ est le **vecteur champ électrique** créé par la charge $`q_1`$ en la position de la charge $`q_2`$.

* Reprenant les expressions précédentes de la force de Coulomb, le vecteur champ électrique s'écrit :   
  <br>
  **$`\mathbf{\quad\overrightarrow{E_{12}}=\dfrac{q_1}{4\pi\epsilon_0}\cdot\dfrac{\overrightarrow{P_1P_2}}{\lVert\overrightarrow{P_1P_2} \rVert^3}`$**   
  <br>
  *$`\mathbf{\quad\overrightarrow{E_{12}}=\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1}{r_{12}^2}\cdot\overrightarrow{e_{12}}}`$*

* Ainsi le vecteur champ électrique $`\overrightarrow{E_{P\rightarrow M}`$ 
  encore noté $`\overrightarrow{E_1(\vec{r})`$ **peut être calculé en tout point $`M`$ de l'espace** de vecteur position $`\overrightarrow{r}`$,
  *indépendemment de la présence ou non d'une charge $`q`$* au point $`M`$.
  <br>
  *Étendu à tout l'espace*, l'ensemble de ces vecteurs étendu à tout l'espace définit le **champ électrostatique** créé par la charge $`q_1`$.
.

, pour toute charge $`q_1`$ positionnée en $`\overrightarrow{r_1}`$*,

* La force de Coulomb se réécrit simplement :   
<br>
$` \overrightarrow{F_{12}}=\left(\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1}{r_{12}^3}\cdot\overrightarrow{e_{12}}\right) \times q_2`$,   

* Le vecteur champ électrique $``\overrightarrow{E_{12}}`$ créé par la charge égale et est défini par 
ce qui permet de définir la grandeur physique entre parenthèse comme le champ électrostatique $`\overrightarrow{E_{12}}`$
créé par la charge $`q_1`$ immobile en $`\overrightarrow{r_1}`$ au
point $`\overrightarrow{r_2}`$.    

En **fonction de $`\overrightarrow{E_{12}}`$**, la *force de Coulomb* se réexprime :

*$`\mathbf{\overrightarrow{F_{12}}=q_2}`$* **$`\mathbf{\,\overrightarrow{E_{12}}\,}\quad`$**  (eq 1),

avec **$`\mathbf{\quad\overrightarrow{E_{12}}=\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1}{r_{12}^3}\cdot\overrightarrow{e_{12}}}`$**,   

Si $`\overrightarrow{E_{12}}`$ est connu, alors une charge $`q_2`$ située en $`\overrightarrow{r_2}`$
est soumise à la force de Coulomb
$`\overrightarrow{F_{12}}=\overrightarrow{E_{12}} \times q_2`$ due à la charge $`q_1`$.

La loi de Coulomb n'a aucune exigence sur la valeur de la charge $`q_2`$ ni sur sa position $`\overrightarrow{r_2}`$ tant que $`\overrightarrow{r_2}\ne \overrightarrow{r_1} `$, si bien que nous pouvons généraliser le vecteur $`\overrightarrow{r_2}`$ à tout vecteur $`\overrightarrow{r}`$ de l'espace
et $`q_2`$ à toute charge élémentaire $`q`$.

Ainsi la *charge $`q_1`$* est la *source dans tout l'espace* d'un **champ électrostatique $`\overrightarrow{E_1}`$**
dont l'expression en tout point  $`\overrightarrow{r}`$ de l'espace est :

**$`\mathbf{\overrightarrow{E_{1}}(\overrightarrow{r})=\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1}{\lVert \overrightarrow{r}-\overrightarrow{r_1}\rVert^3}\cdot(\overrightarrow{r}-\overrightarrow{r_1})}`$**,

<!--=========================
Le premier terme indique

Plutôt que de s'intéresser à la force créée entre deux charges ponctuelles immobiles en deux points de l'espace, il est intéressant de déomposer le problème en deux étapes :

* La charge 
=========================-->

#### Quelles sont les causes d'un champ électrique stationnaire ?

* Les causes d'un champ magnétique sont des **charges électriques immobiles** dans le référentiel d'observation.


#### Comment créer un champ électrique stationnaire ?

##### Distributions volumique, surfacique et linéïque de charge

L*'espace réel perçu possède 3 dimensions*, les charges occupent les trois dimensions spatiales et tout point point de l'espace peut être caractérisé par une **densité volumique de charge $`\dens^{3D}`$** d'unité SI (pour Système International d'unité) $`Cm^{-3}`$.

**$`\mathbf{\dens^{3D} = \dens^{3D}\,(\rho, \varphi, z)\quad}`$** *$`Cm^{-3}`$*

!!!! *Attention* :   
!!!!
!!!! La *lettre grecque "rho"* désigne traditionnellement à la fois :
!!!! * la *coordonnée rho* du repère cylindrique.
!!!! * une *densité volumique* (densité volumique de charge, densité volumique de masse = masse volumique, ...).
!!!!
!!!! Pour distinguer ces deux significations de la lettre rho et éviter toute confusion, *M3P2 utilise* deux police de caractères différentes de cette même lettre rho :
!!!!
!!!! * *$`\large\rho`$* est la *coordonnée rho* du repère cylindrique.   
!!!! * *$`\dens`$* représente une *densité de charge*.

Dans le cas de *charges localisées au voisinage d'une surface* ,sur une couche d'*épaisseur $`e`$ négligeable*, alors un point de cette surface peut être caractérisé par une **densité surfacique de charge $`\dens^{2D}`$** d'unité SI $`Cm^{-2}`$. Densité surfacique se dit aussi densité superficielle. Si les charges sont sur la surface latérale du cylindre, la densité surfacique s'écrit :

**$`\mathbf{\dens^{2D} = \dens^{2D}\,(\varphi, z)\quad}`$** *$`Cm^{-2}`$*

Dans la case de *charges réparties sur une ligne* de *section droite $`S_{\perp}`$ négligeable*, tout point de cette ligne peut être caractérisé par une **densité linéïque de charge $`\dens^{1D}`$** d'unité SI $`Cm^{-1}`$. Dans ce cas la densité linéïque de charge s'écrit : 

**$`\mathbf{\dens^{1D} = \dens^{1D}\,(z)\quad}`$** *$`Cm^{-1}`$*

! *Important* :   
!
! *Densités surfaciques et linéïque* de charge résultent d'une *idéalisation*, d'une *modélisation 2D et 1D* de la distribution des charges dans l'espace.   
!
! Si d'une façon générale, à l'échelle d'observation les grandeurs physiques et les champs varient de façon continue dans l'espace 3D, *des discontinuités peuvent apparaître* lors des modélisations 2D ou 1D.    
!
! Ces discontinuités correspondent à une perte d'information, aux variations continues ignorées des grandeurs physiques et des champs le long des dimensions négligées. 

##### Qu'est-ce qu'un élément de charge ?

Un **élément de charge** est un *ensemble de charges électriques* apparaissant comme *ponctuel à l'échelle d'observation*. Ainsi, en un point $`P`$ de l'espace :

*  un **élément de volume $`\mathbf{d\Ltau_P}`$** porte un élément de *charge $`\mathbf{dq=\dens_P^{3D}\cdot d\Ltau_P}`$*.
*  un **élément de surface $`\mathbf{dS_P}`$** porte un élément de *charge $`\mathbf{dq=\dens_P^{2D}\cdot dS_P}`$*.
*  un **élément de ligne $`\mathbf{d\mathcal{l}_P}`$** porte un élément de *charge $`\mathbf{dq=\dens_P^{1D}\cdot d\mathcal{l}_P}`$*.


!! *Pour aller plus loin* :   
!!
!! Un *point* est une *abstraction mathématique sans dimension* (0D) de volume nul. 
!!
!! Il représente un *petit volume* entourant tout point M, *non résolu à l'échelle d'observation* spatiale, mais suffisamment grand pour que la valeur moyenne de la grandeur physique exprimée en ce point soit statistiquement stable à l'échelle d'observation temporelle.  
!!  
!! Un tel volume est dit *volume mésoscopique*. 
!! 
!! Cette notion de volume mésoscopique sera précisée et utilisée dans les diverses études sur les propriétés physiques de la matière, dès ce niveau contrefort puis au niveau montagne.


##### Comment s'exprime de champ électrique créé par une distribution continue de charges?

* Un *élément de charge $`dq_P`$*  localisé en un point $`P`$ créé en tout point $`M`$ de l'espace 
  un **champ électrique élémentaire $`\overrightarrow{dE}_{P\rightarrow M}`$** donné par la loi de Coulomb :   
  <br>
  **$`\mathbf{\overrightarrow{dE}_{P\rightarrow M}=\dfrac{dq_P}{4\pi\epsilon_0}\cdot \dfrac{\overrightarrow{r_M}-\overrightarrow{r_P}}{\lVert \overrightarrow{r_M}-\overrightarrow{r_P}\rVert^3}}`$**,
 
* Le *champ électrique total $`\overrightarrow{E}_M`$* créé en ce point $`M`$ quelconque par 
  une **distribution continue de charge $`\mathscr{D}`$** s'exprime alors :   
  <br>
  *$`\displaystyle\mathbf{
  \overrightarrow{E}_M=\iiint_{P\in\mathscr{D}}\dfrac{dq_P}{4\pi\epsilon_0}\cdot 
  \dfrac{\overrightarrow{r_M}-\overrightarrow{r_P}}{\lVert \overrightarrow{r_M}-\overrightarrow{r_P}\rVert^3}}`$*



#### Qu'est-ce que le calcul direct d'un champ électrique ?

* La **calcul direct** résoudre l'intégrale précédente pour la dustribution de charge étudiée.   
   Il consiste donc à :
  * *décomposer* la distribution spatiale des charges *en charges élémentaires*.
  * pour chacun d'eux, *calculer le champ électrique élémentaire induit en un point quelconque de l'espace. 
  * *intégrer les champs électriques élémentaires* créés par l'ensemble des charges élémentaires de la distribution.

* Cette méthode n'est réalisable analytiquement que dans quelques cas très simples.
* Cette méthode peut être traduite en un programme informatique.

<br>

--------------------------------------------
<!--MAGST-200-->

#### **1 -** Quel est le champ électrique créé par un fil rectiligne infini uniformément chargé ?

<!--MAGST-300-->

##### Description et paramétrage du problème

* Le **fil rectiligne infini** est caractérisé par une *densité linéÏque de charge $`\dens^{1D}`$*.

![](electric-field-fil-rectiligne-infini-1_v2_L1200.jpg)

* Le *champ électrique* doit être calculé **en tout point de l'espace**. <br>
Pour cela nous prenons un **point $`M`$ quelconque, représentatif** de tout point de l'espace.<br>
* Il faut *décomposer la charge* dans le fil **en ses charges élémentaires**.<br>
Nous prenons une **charge élémentaire $`\dens^{1D}\cdot dl_P`$ en un point P quelconque, représentatif** de tous les points du fil.
* Ceci nous permettra :<br>
\- dans une première étape, de calculer le champ électrique $`\overrightarrow{dE_M}`$ créé par $`\dens^{1D}\cdot dl_P`$ au point $`M`$.<br>
\- dans une seconde étape seront intégrés l'ensemble des $`\overrightarrow{dE_M}`$ créés par toutes les charges élémentaires constituant le charge dans le fil, pour conduire au champ électrique $`\overrightarrow{E_M}`$ total.

![](electric-field-fil-rectiligne-infini-2_v2_L1200.jpg)

* Il faut ensuite **choisir le bon repère de l'espace** dans lequel la description mathématique de la situation et les calculs seront simples :<br>

* Un **fil rectiligne infini** est *invariant par rotation d'angle $`\varphi`$* quelconque et *par translation $`z`$* quelconque, si nous choissisons un **repère cylindrique $`(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})`$ dont l'axe $`Oz`$ est l'axe du fil**, comme repère de l'espace.
* Nous choisirons de positionner l'**origine $`O`$** du repère au *point de projection orthogonale du point $`M`$ sur le fil*. Ainsi le point $`M`$ de coordonnées cylindriques $`(\rho; \varphi, z)`$ est suité à la distance $`z`$ du fil. 

![](electric-field-fil-rectiligne-infini-3_v2_L1200.jpg)

* L'avantage de cette position de l'origine $`O`$ est que **les trois points $`(P, O, M)`$** forment un **triangle rectangle** en $`O`$.<br>
 Ainsi *les distances $`z`$, $`\rho`$ et $`d=||\,\overrightarrow{PM}\,||`$* qui interviendront dans le calcul de $`\overrightarrow{dB_M}`$, sont aussi les longueurs d'arête de ce triangle rectangle vérifient **$`d^2=\rho^2+z^2`$** et les **relations trigonométriques simples d'un triangle rectangle**.
 
* La charge élémentaire $`\dens^{1D}\cdot dl_P`$ et un point $`M`$ définissent un plan $`\mathcal{P}`$. La loi de Coulomb nous indique que la **direction** du vecteur champ électrique est donnée par le *vecteur $`\mathbf{\overrightarrow{PM}}`$* et son **sens** par le *signe de la charge* élémentaire en $`M`$.

! *Remarque* :   
! Dans le cas d'un fil rectiligne chargé, toutes les charges élémentaires constitutives et le point $`M`$ sont situés dans un même plan $`\mathcal{P}`$. Ces charges conduiront en ce point $`M`$ à des champs électriques élémentaires qui seront contenus dans ce plan $`\mathcal{P}`$.   
!   
! ![](electric-field-fil-rectiligne-infini-4_v2_L1200.jpg)
!
! Bien sûr, cette remarque n'est pas nécessaire, les calculs directs redonneront ce résultats, mais cette remarque *permet de vérifier la véracité du calcul* sur ce point.

* Il faut maintenant **paramétrer le problème**, introduire les *grandeurs physiques intermédiaires utiles* à notre perception du problème. Ainsi nous portons sur la figure :   
<br>
![](electric-field-fil-rectiligne-infini-5_v2_L1200.jpg)   
<br>
   * la distance $`d=||\,\overrightarrow{PM}\,||`$ qui intervient dans la loi de Coulomb.
   * le vecteur $`\overrightarrow{e_d}`$ tel que le vecteur $`\overrightarrow{PM}`$ s'écrive $`\overrightarrow{PM}=d\cdot \overrightarrow{e_d}`$
   * l'angle $`\alpha =\widehat{OMP}`$, exprimé en valeur algébrique définie par $`\alpha = arctg \Big(\dfrac{z}{\rho}\Big)`$    
     _Ainsi_ $`\alpha \ge 0 \Longleftrightarrow z \ge 0`$, _et_ $`\alpha \le 0 \Longleftrightarrow z \le 0`$.


##### Expression du champ électrique élémentaire

* Calculons le **champ électrique élémentaire** au point $`M`$ :<br>
<br>$`\overrightarrow{dE}_M\quad=\quad\dfrac{\dens^{1D}\cdot dl_P}{4\pi\epsilon_0}\cdot\dfrac{\overrightarrow{PM}}{||\,\overrightarrow{PM}\,||^{\,3}}`$
$`\quad=\quad\dfrac{\dens^{1D}\cdot dz}{4\pi\epsilon_0}\cdot\dfrac{d\,\overrightarrow{e_d}}{d^3}`$
$`\quad=\quad\dfrac{\dens^{1D}\cdot dz}{4\pi\epsilon_0}\cdot\dfrac{1}{d^2}\cdot \overrightarrow{e_d}`$

* Nous devons décomposer le vecteur $`\overrightarrow{e_d}`$ en fonction des vecteurs de la base cylindrique choisie, ce qui donne :<br>
$`\quad\overrightarrow{e_d}=\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\quad`$

*  Nous obtenons alors :<br>
<br>**$`\boldsymbol{\mathbf{\overrightarrow{dE}_M=\dfrac{\dens^{1D}\cdot dz}{4\pi\epsilon_0}\cdot\dfrac{1}{d^2}}}`$
$`\;\boldsymbol{\mathbf{\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)}}`$**


##### Calcul du champ électrique total par intégration



* Pour obtenir le *champ électrique total*, il reste à **intégrer tous les champs électriques élémentaires** créés par les éléments de charge qui composent le fil chargé.

!!!! *ATTENTION :* un *fil* est une *variété à une dimension* (variété = espace) : la position d'un élément de charge $`\dens_P^{1D}`$ sur le fil est repérée par *une seule coordonnée, $`z`$* dans le repère choisi.
!!!!
!!!! *Intégrer sur le fil infini* signifie tenir compte de tous les éléments de charge $`\dens_P^{1D}`$  en faisant varier *$`z`$ entre $`-\infty`$ et $`+\infty`$*.
!!!!
!!!! Mais dans notre expression du champ électrique élémentaire, la variable $`z`$ peut être liée à d'autres variables intermédiaires utilisées dans la description du problème. La *question à se poser* est :<br>
!!!! *Si le point $`P`$ se déplace, quelles variables utilisées varient?*
!!!!
!!!! *Si plusieurs variables sont liées* à ce déplacement unidimensionnel de $`P`$, alors elles sont liées. Il faut alors *choisir l'une d'elles comme variable d'intégration*, puis *exprimer les autres en fonction de celle choisie* AVANT de réaliser l'intégration.

* Dans cette étude, lorsque l'élément de charge se déplace le long du fil, les trois variables **$`z`$, $`d`$ et $`\alpha`$ varient de façon non indépendantes**, elles sont liés. Il faut donc **choisir l'une d'elle comme variable d'intégration**.   
$`\Longrightarrow`$ Nous avons la *liberté de choix*, il en résultera simplement des calculs plus ou moins difficiles, un résultat d'écriture plus ou moins smple, un éclairage particulier sur l'interprétation finale. Pour montrer cela, nous choisirons successivement $`z`$, puis $`\alpha`$.

*_Choix de $`z`$ comme variable d'intégration_*

à faire

_*Choix de $`\alpha`$ comme variable d'intégration*_

* C'est le choix la plupart du temps présenté lors de l'étude du fil rectiligne infini. Il conduit 
facilement à une expression simple du champ magnétique total. 

* Il faut **exprimer $`dz`$ et $`d`$ en fonction de $`\alpha`$**. Le triangle $`(P,O,M)`$ étant rectangle en $`O`$, nous avons :   
<br>
![](electric-magnetic-field-fil-rectiligne-infini-6_v2_L1200.jpg)
<br>
   * *$`\color{blue}{\dfrac{z}{\rho}=\tan\alpha}`$*$`\quad\Longrightarrow\quad z=\rho\cdot \tan\alpha`$<br>
<br>$`\Longrightarrow\quad\dfrac{dz}{d\alpha}=\rho\cdot \dfrac{d}{d\alpha}\left(\dfrac{\sin\alpha}{\cos\alpha}\right)`$
$`\quad\quad=\rho\cdot \dfrac{\cos^2\alpha+\sin^2\alpha}{\cos^2\alpha}=\dfrac{\rho}{\cos^2\alpha}`$<br>
<br>**$`\mathbf{\Longrightarrow\quad dz=\dfrac{\rho}{\cos^2\alpha}\cdot d\alpha}`$**

  * $`\color{blue}{\dfrac{\rho}{d}= \cos\alpha\quad}`$**$`\mathbf{\Longrightarrow\quad\dfrac{1}{d^2}=\dfrac{\cos^2\alpha}{\rho^2}}`$**

* Exprimé *seulement en fonction de $`\alpha`$*, le champ électrique élémentaire s'écrit :<br>
<br>**$`\mathbf{\overrightarrow{dE}_M}`$**
$`\;=\dfrac{\dens^{1D}\cdot dz}{4\pi\epsilon_0}\cdot\dfrac{1}{d^2}`$
$`\;\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)`$   
<br>  
$`\quad=\dfrac{\dens^{1D}}{4\pi\epsilon_0}\cdot
\underbrace
{\color{brown}{\dfrac{\cos^2\alpha}{\rho^2}}}
_{\color{blue}{\large\mathbf{\frac{1}{d^2}}}}
\cdot
\underbrace
{\color{brown}{\dfrac{\rho}{\cos^2\alpha}\cdot d\alpha}}
_{\color{blue}{\mathbf{dz}}}
`$
$`\;\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)`$   
**$`\mathbf{\quad=\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho}\cdot d\alpha}`$
$`\;\mathbf{\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)}`$**   
<br>


* Calcul de $`\overrightarrow{E}_M`$ créé par un **fil rectiligne de longueur finie**   
 de *densité linéïque de charge uniforme $`\dens^{1D}`$*   
 <br>   
![](electric-field-fil-rectiligne-infini-7_v2_L1200.gif)
 <br>
  Les **extrémités** du fil sont vues, depuis le point $`M`$ dans le repère choisi, sous les angles **$`\mathbf{\alpha_{inf}}`$ et $`\mathbf{\alpha_{sup}}`$** tels que $`\mathbf{\alpha_{inf}\lt\alpha_{sup}}`$, les angles étant *en notation algébrique*.   Le calcul conduit à :   
<br>
**$`\displaystyle\mathbf{\overrightarrow{E_M}}`$**
$`\displaystyle\;=\int_{\alpha_{inf}}^{\alpha_{sup}}\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho}\cdot d\alpha`$
$`\;\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)`$    
<br>   
$`\begin{align}
\quad=&\int_{\alpha_{inf}}^{\alpha_{sup}}\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho}\cdot \cos\alpha \cdot d\alpha \cdot\overrightarrow{e_{\rho}}\\
&\;-\;\int_{\alpha_{inf}}^{\alpha_{sup}}\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho}\cdot \sin\alpha \cdot d\alpha \cdot\overrightarrow{e_z}
\end{align}`$   
<br><br>
$`\begin{align}
\quad=&\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\sin\alpha\,\Big]_{\alpha_{inf}}^{\alpha_{sup}}\cdot\overrightarrow{e_{\rho}}\\
&\;\;-\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[-\,\cos\alpha\,\Big]_{\alpha_{inf}}^{\alpha_{sup}}\cdot\overrightarrow{e_z}
\end{align}`$   
<br><br>
**$`\begin{align}
\quad=&\mathbf{\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\sin\alpha_{sup} - \sin\alpha_{inf} \Big]\cdot\overrightarrow{e_{\rho}}}\\
&\mathbf{\;\;+\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\cos\alpha_{sup} - \cos\alpha_{inf} \Big]\cdot\overrightarrow{e_z}}
\end{align}`$**   

<br>
* Calcul de $`\overrightarrow{E}_M`$ créé par un **fil rectiligne de longueur infinie**   
 de *densité linéïque de charge uniforme $`\dens^{1D}`$*   
 <br>   
 _(figure à ajouter)_   
 <br>
 Dans ce cas, depuis le point M dans le repère choisi, le fil est vu entre les **angles limites 
 $`\mathbf{\alpha_{inf}=-\dfrac{\pi}{2}}`$** et **$`\mathbf{\alpha_{sup}=+\dfrac{\pi}{2}}`$**.
 Le calcul donne alors :   
 <br>
$`\overrightarrow{E_M}=\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\underbrace
{\color{brown}{\sin\left(\dfrac{\pi}{2}\right) - \sin\left(-\dfrac{\pi}{2}\right)}}_{\color{blue}{=\;1-(-1)\;=\;2}} \Big]\cdot\overrightarrow{e_{\rho}}`$
$`\quad\quad\quad+\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\underbrace
{\color{brown}{\cos\left(\dfrac{\pi}{2}\right) - \cos\left(-\dfrac{\pi}{2}\right)}}_{\color{blue}{=\;0-0\;=\;0}} \Big]\cdot\overrightarrow{e_z}`$   
<br>
Soit au final :   
<br>
**$`\displaystyle\mathbf{\overrightarrow{E_M}=\dfrac{\dens^{1D}}{2\pi\epsilon_0\,\rho}\cdot\overrightarrow{e_{\rho}}}`$**
 
 

! *Remarque :*   
!
! Ces expressions impliquent une valeur de champ électrique qui tend vers l'infini quand la distance au fil tend vers zéro. Est-ce physiquement réaliste ?
!
! Dans la modélisation de l'expérience, nous avons considéré un fil de section nulle. Nous avons ainsi fait un modèle approximé à 1 dimension (1D) d'une réalité physique tridimensionnelle (3D). Une reprise 3D de cette étude réalisée à une résolution mésoscopique (le "point" représentant en réalité un volume non résolvable à l'échelle d'observation) ferait apparaître à l'intérieur du fil un champ électrique qui s'éloigne des prédictions du modèle filaire 1D. Notamment les valeurs limites infinies disparaitraient.

!! *Pour aller plus loin :*<br>
!! Faire cette étude 3D de façon analytique en calculs directs serait extrêmement difficile. Une façon de faire serait d'implémenter la loi de Coulomb pour le champ électrique dans un calcul informatique avec un certain maillage de l'espace et une longeur de fil limitée. Par contre, ce fil uniformément chargé présentant des invariances et symétries suffisantes, ce calcul sera très facile en utilisant le théorème de Gauss (première étape réservée à ceux qui se destinent à maîtriser l'électromagnétisme de Maxwell).
!!
!! L'électron étant considéré comme une particule ponctuelle, même dans une description 3D les valeurs du champ électrique tend vers l'infini quand la distance à l'électron tend vers 0. 
!!
!! A la résolution de la plupart de nos expérience, nous utiliseront la notion de volume mésoscopique. C'est un volume infinitésimal à l'échelle d'observation et donc considéré comme ponctuel dans la modélisation, mais très grand devant les dimensions atomiques. Cela permet d'attribuer au volume mésoscopique la valeur moyenne des champs à l'intérieur de celui-ci, évitant ainsi les valeurs infinies. Dans l'étude des propriétés des matériaux, l'ordre de grandeur d'un volume mésoscopique est de quelques nanomètres cube à quelques dizaines de microns cube, selon les moyens de caractérisations.

<br>

--------------------------------------------

#### **2 -** Quel est le champ électrique créé en un point de son axe par un anneau circulaire chargé uniformément ?

<!--MAGST-400-->

##### Description de la distribution de charges

![](electrostatics-ring-1_L1200.gif)

* Un **anneau circulaire $`\mathcal{C}`$** de **rayon $`R`$** porte une *charge électrique 
$`Q`$* non nulle.

* L'anneau est **suffisamment mince** pour que sa *section droite* soit *négligée*, et tu le modélises
  par un **cercle** de rayon $`R`$.

* L'anneau est isolé, aucune charge proche de l'anneau ne créer un champ électrique extérieur
  qui viendrait influencer la distribution de la charge sur l'anneau. Tu peux donc considèrer
  que la **charge $`Q`$** est *répartie uniformément* sur le pourtour de l'anneau. 

* Ainsi, la distribution de charge modélisée est une **distribution linéïque uniforme de charge**
  notée **$`\dens^{1D}_0`$** (unité SI : $`C\,m^{-1}`$) répartie sur le cercle de rayon $`R`$.   
  
* Pour décrire la situation et réaliser les calculs, choisissons le point **origine O**
et le système de **coordonnées cylindriques $`(\rho, \varphi, z)`$**, tel que le 
*cercle $`\mathcal{C}`$* soit de *centre $`O`$* et s'inscrive 
*dans le plan perpendiculaire à l'axe $`Oz`$*.   
<br>
L'écriture dans tout l'espace $`\mathscr{E}`$ de la distribution de charge étudiée peut alors s'écrire :   
<br>
$`\forall(\rho, \varphi, z)\in\mathscr{E},`$   
$`\dens^{1D}(\rho, \varphi, z) = \left\{\begin{align}
&\dens^{1D}_0\small\text{   si }\rho=R\text{ et }z=0\\
& 0\quad\small\text{   dans le cas contraire }\end{align}\right.`$



##### Identification et écriture des éléments de charge

* L'*anneau $`\mathcal{C}`$*, de circonférence $`L=2\pi\,R`$, se décompose mentalement en ses 
**éléments d'arc de longueur**   
<br>
**$`dl_p = R\,d\varphi`$**    
<br>
situés en tout *point $`P`$ de l'anneau'* de coordonnées cylindriques   
*$`P = (\rho_P=R, \,\varphi_P, z_P=0)`$*. 

* La *charge totale $`Q`$* (C) étant *répartie uniformément* sur le pourtour de l'anneau', la distribution spatiale de charges
peut être totalement décrite par une **densité linéïque de charge $`\dens^{1D}_0`$** de valeur **constante**
en tout point $`P`$ de l'anneau, telle que :   
<br>
**$`\dens^{1D}_0 = \dfrac{Q}{L} = \dfrac{Q}{2\pi\,R}\quad`$**(C&nbsp;m<sup>-1</sup>)

* Chaque *élément d'arc $`dl_P`$* porte la **charge élémentaire**   
<br>
**$`dq_P = \dens^{1D}_0\;dl_P = \dens^{1D}_0\,R\,d\varphi\quad`$**(C)



##### Expression du champ électrique élémentaire

* Selon la *loi de Coulomb*, la charge élémentaire $`dq_P`$ en tout point $`P`$ de l'anneau chargé créé
*en tout point $`M`$* de l'espace, le **champ électrique élémentaire**    
<br>
 **$`\overrightarrow{dE}_{P\rightarrow M}=\dfrac{dq_P}{4\pi\epsilon_0}\cdot \dfrac{\overrightarrow{PM}}{\lVert \overrightarrow{PM}\rVert^3}\quad`$**
(V&nbsp;m<sup>-1</sup>)

* Le calcul de $`\overrightarrow{E}`$ se limitant aux points de l'axe $`Oz`$, les coordonnées de tout
*point $`M`$ de l'axe $`Oz`$* s'expriment     
*$`M = (\rho_M = 0, \,\varphi_M = 0, \, z_M)`$*


* *Exprimons $`\overrightarrow{dE}_{P\rightarrow M}`$* **en fonction des données de base de l'étude**, soit 
  la densité linéïque de charges $`\dens^{1D}`$, 
  le rayon $`R`$ de la spire, la coordonnée $`z_M`$, et les vecteurs
  $`\overrightarrow{e_{\rho}},\,\overrightarrow{e_{\varphi}},\,\overrightarrow{e_z}`$ de la base cylindrique choisie :

   * le vecteur $`,\overrightarrow{PM}`$ se décompose en   
     <br>
     **$`\overrightarrow{PM}=\overrightarrow{PO}+\overrightarrow{OM}=-R\,\overrightarrow{e_{\rho}}+z_m\,\overrightarrow{e_z}`$**. 
   * Les coordonnées cylindriques sont orthonormées ($`\overrightarrow{e_{\rho}}\perp\overrightarrow{e_z}`$) donc
     l'angle $`\alpha =\widehat{OMP}`$ est droit, le triangle (OMP) est rectangle en $`O`$.   
     Ainsi la *distance $`d=||\,\overrightarrow{PM}\,||`$* qui intervient dans la loi de Coulomb, 
     grâce au *théorème de Pythagore* appliqué au triangle (OMP), s'exprime :     
     <br>
     **$`d = \sqrt{(-R)^2+z_M^2}=(R^2+z_M^2)^{\,1/2}`$**

* Le champ électrique élémentaire au point $`M`$ créé par la charge en $`P`$ se réécrit donc :<br>
<br>
**$`\mathbf{\overrightarrow{dE}_{P\rightarrow M}}`$** 
$`\quad=\quad\dfrac{\dens^{1D}\cdot dl_P}{4\pi\epsilon_0}\cdot\dfrac{\overrightarrow{PM}}{||\,\overrightarrow{PM}\,||^{\,3}}`$   
<br>
$`\hspace{1.7cm}=\quad\dfrac{\dens^{1D}\cdot R\,d\varphi}{4\pi\epsilon_0}\cdot\dfrac{\overrightarrow{PM}}{d^3}`$   
<br>
**$`\hspace{1.7cm}\boldsymbol{\mathbf{=\quad\dfrac{\dens^{1D}\,R }{4\pi\epsilon_0}\cdot\dfrac{-R\,\overrightarrow{e_{\rho}}+z_m\,
\overrightarrow{e_z}}{(R^2+z_M^2)^{\,3/2}}\;d\varphi}}`$**   
<br>


##### Symétries des charges et direction du champ électrique total

![](electrostatics-ring-2_L1200.gif)

* **Pour tout point $`P`$** de l'anneau portant l'élément de charge $`\dens^{1D}_0\;dl_P`$
  **existe $`P'`$**, le point sur l'anneau *symétrique de $`P`$ par rapport au centre $`O`$*
  de l'anneau, qui porte l'élément de charge  $`\dens^{1D}_0\;dl_{P\Large '}`$ **tel que**   
  <br>
  **$`\dens^{1D}_0\;dl_{P\Large '}=\dens^{1D}_0\;dl_P`$**

* La *loi de Coulomb* appliquée aux champs élémentaires $`\overrightarrow{dE}_{P\rightarrow M}`$ et 
  $`\overrightarrow{dE}_{P'\rightarrow M}`$ créés en tout point $`M`$ de l'axe $`Oz`$, par les éléments
  de charge en $`P`$ et $`P'`$ montre que :   
  <br>
  la **somme de ces deux contributions $`\overrightarrow{dE}_{P\rightarrow M}`$ et $`\overrightarrow{dE}_{P'\rightarrow M}`$**
  au champ électrique total en $`\overrightarrow{E_M}`$
  est *dirigé selon $`\overrightarrow{e_z}`$*.   
  <br>
  Ainsi **seule la composante $`dE_{P\rightarrow M,z}`$** $`\; = \overrightarrow{dE}_{P\rightarrow M}\cdot\overrightarrow{e_z}`$ 
  du champ électrique élémentaire selon $`z`$ *contribue au champ total $`\overrightarrow{E}_M`$* :   
  <br>
  **$`\boldsymbol{\mathbf{\overrightarrow{dE}_{P\rightarrow M,z}=\dfrac{\dens^{1D}}{4\pi\epsilon_0}\cdot\dfrac{R\,z_M}{(R^2+z_M^2)^{\,3/2}}\,d\varphi\,\overrightarrow{e_z}}}`$**

<!----à faire---------
!! *Pour aller plus loin* : *Étude des symétries
!! gds
!!
--------------------->

##### Calcul du champ électrique total par intégration


* Le **champ électrique total** $`\overrightarrow{E}_M`$ en tout point $`M`$ de l'axe $`Oz`$, s'obtient en faisant 
  la *somme intégrale des $`\overrightarrow{dE}_{P\rightarrow M,z}`$* (principe de superposition appliqué 
  au champ électrique)sur *tous les point $`P`$ de la spire*   
  <br>
  **$`\displaystyle\boldsymbol{\mathbf{\overrightarrow{E}_M = \int_{P\in\mathcal{C}} \overrightarrow{dE}_{P\rightarrow M,z}}}`$**

*  *Tous les $`\overrightarrow{dE}_{P\rightarrow M,z}`$* ayant la *même orientation selon $`\overrightarrow{e_z}`$*, 
   la calcul intégrale se simplifie :   
  <br>
   **$`\boldsymbol{\mathbf{\overrightarrow{E}_M = E_M\;\overrightarrow{e_z}}}`$**   
  <br>
  avec    
  <br>
  *$`\boldsymbol{\mathbf{\displaystyle E_M=\int_{P\in\mathcal{C}} dE_{P\rightarrow M,z}}}`$*
   
*  L'ensemble des points $`P`$ constituant la spire, de coordonnées  $`P=(R,\,\varphi_M,\,0)`$, s'obtient 
   en faisant varier *$`\varphi_P`$ entre $`0`$ et $`2\pi`$*.   
  <br>
   **$`\boldsymbol{\mathbf{E_M}}`$**
   *$`\displaystyle\boldsymbol{\mathbf{\;=\int_{\varphi = 0}^{2\pi}\dfrac{\dens^{1D}}{4\pi\epsilon_0}\cdot\dfrac{R\,z_M}{(R^2+z_M^2)^{\,3/2}}\,d\varphi}}`$*   
   <br>
   $`\displaystyle\hspace{2.3cm}=\dfrac{\dens^{1D}}{4\pi\epsilon_0}\cdot\dfrac{R\,z_M}{(R^2+z_M^2)^{\,3/2}}\;\underbrace{\int_{\varphi = 0}^{2\pi}\,d\varphi}_{\color{blue}{=\big[\varphi\big]_0^{2\pi}=2\pi-0}}`$   
   <br>
   **$`\boldsymbol{\mathbf{\hspace{2.3cm}=\dfrac{\dens^{1D}}{2\epsilon_0}\cdot\dfrac{R\,z_M}{(R^2+z_M^2)^{\,3/2}}}}`$**

##### Interprétation

*  *Au final*, un anneau circulaire de rayon $`R`$ chargé uniformément avec la densité linéïque $`\dens^{1}`$, situé dans 
   le plan $`z=0`$ de son axe $`Oz`$, créé en tout point $`(\rho=0,\varphi=0,z)`$ de son axe le champ électrostatique   
   <br>
   **$`\boldsymbol{\mathbf{\overrightarrow{E}(z)=\dfrac{\dens^{1D}}{2\,\epsilon_0}\cdot\dfrac{R\,z}{(R^2+z^2)^{\,3/2}}\;\overrightarrow{e_z}}}`$**

* à terminer (profil de la composante $`E(z)`$, ...)


<br>

--------------------------------------------

#### **3 -** Quel est le champ électrique créé dans tous l'espace par un disque chargé uniformément ?

! <details markdown=1>
! <summary>Étude à partir du résultat précédent<br>
! (l'anneau circulaire chargé uniformément)</summary>
! __________________________
! Le calcul du champ électrique $`\overrightarrow{E}`$ créé en un point de son axe par un disque uniformément
! chargé peut s'appuyer sur la connaissance de $`\overrightarrow{E}`$ créé par un anneau uniformément chargé.<br>
! <br>
! Le rayon R de l'anneau devient la coordonnée $`\rho`$, variable.<br>
! <br>
! Donnons une petite épaisseur $`d\rho`$ à l'anneau de rayon $`\rho`$.<br>
! Cet anneau "épais" est alors chargé uniformément avec la densité surfacique $`\dens^{2D}`$,
! liée à la densité linéïque $`\dens^{1D}`$ de l'anneau sans épaisseur par <br>
! <br>
! $`\dens^{1D} (C\,m^{-1}) = \dens^{2D} (C\,m^{-2}) \times d\rho (m)`$<br>
! <br>
! figure<br>
! <br>
! Le disque uniformément chargé de rayon $`R`$ se décompose en la somme intégrale des anneaux concentriques de rayons $`\rho`$
! et d'épaisseur $`d\rho`$ chargés uniformément avec la même densité surfacique de charges $`\dens^{2D}`$, pour
! $`\rho`$ variant entre $`0`$ et le rayon $`R`$ du disque.<br>
! <br>
! Le théorème de superposition nous permet alors de calculer le champ électrique créé en tout point $`M`$ de son axe
! par le disque chargé, comme la somme intégrale des champs élémentaires créés en ce point $`M`$
! par tous les anneaux 'épais' qui composent le disque.<br>
! <br>
! $`dE_z = \dfrac{\dens^{1D}}{2\epsilon_0}\cdot\dfrac{R\,z}{(R^2+z^2)^{\,3/2}}`$<br>
! <br>
! devient alors, la charge élémentaire étant situé maintenant à la distance variable $`\rho`$ et non $`R`$ :<br>
! <br>
! $`dE_z = \dfrac{\dens^{2D}}{2\epsilon_0}\cdot\dfrac{\rho\,z}{(\rho^2+z^2)^{\,3/2}}\,d\rho`$ <br>
! <br>
! $`\hspace{0.5 cm} = \dfrac{\dens^{2D}\,z}{2\epsilon_0}\cdot \rho\,(\rho^2+z^2)^{-\,3/2}\,d\rho`$<br>
! <br>
! Calculons $`E_z`$ :<br>
! <br>
! $`\color{blue}{\scriptsize{\text{La dérivée de } u^n \text{ (avec u fonction de variable réelle x)}}}`$
! $`\color{blue}{\scriptsize{\text{étant } n\cdot u^{n-1}\cdot u'\;\text{, alors}}}`$   
! $`\color{blue}{\scriptsize{\text{  - la primitive de }  n\cdot u^{n-1}\cdot u' \text{ est } u^n}}`$   
! $`\color{blue}{\scriptsize{\text{soit encore }}}`$   
! $`\color{blue}{\scriptsize{\text{  - la primitive de } (n+1)\cdot u^n \cdot u' \text{ est } u^{n+1}}}`$   
!
! $`\displaystyle\hspace{0.5 cm}=\dfrac{\dens^{2D}\,z}{2\epsilon_0}  
! \int_{\rho = 0}^R - \Big(\underbrace{-\dfrac{1}{2}}_{\color{blue}{n+1}}\Big)\cdot\underbrace{2\rho}_{\color{blue}{u^{\,'}}}\,\underbrace{(\rho^2+z^2)^{-\,3/2}}_{\color{blue}{u^n}}\,d\rho`$<br>
! <br>
! $`\displaystyle \hspace{0.5 cm} =  - \dfrac{\dens^{2D}\,z}{2\epsilon_0} \big[\underbrace{(\rho^2+z^2)^{-\,1/2}}_{\color{blue}{u^{n+1}}}\big]_0^R`$<br>
! <br>
! $`\color{blue}{\scriptsize{\text{Le signe moins devient plus}}}`$<br>
! $`\color{blue}{\scriptsize{\text{en inversant les bornes d'intégration}}}`$<br>   
! <br>
! $`\displaystyle \hspace{0.5cm} = +\dfrac{\dens^{2D}\,z}{2\epsilon_0} \big[(\rho^2+z^2)^{-\,1/2}\big]_R^0`$<br>
! <br>
! $`\displaystyle \hspace{0.5 cm} =  \dfrac{\dens^{2D}\,z}{2\epsilon_0} \left(\dfrac{1}{\sqrt{z^2}} - \dfrac{1}{\sqrt{R^2+z^2}}\right)`$<br>   
! <br>
! $`\displaystyle \hspace{0.5 cm} =  \dfrac{\dens^{2D}\,z}{2\epsilon_0} \left(\dfrac{1}{|z|} - \dfrac{1}{\sqrt{R^2+z^2}}\right)`$<br>   
! <br>
! Ainsi le champ électrique s'exprime plus simplement :<br>   
! <br>
! Pour $`z>0`$ :<br>   
! $`\overrightarrow{E}(z) =  \dfrac{\dens^{2D}\,z}{2\epsilon_0} \left(1 - \dfrac{z}{\sqrt{\rho^2+z^2}}\right)\,\overrightarrow{e_z}`$<br>
! <br>
! Pour $`z>0`$ :<br>   
! $`\overrightarrow{E}(z) =  \dfrac{\dens^{2D}\,z}{2\epsilon_0} \left(- 1 - \dfrac{z}{\sqrt{\rho^2+z^2}}\right)\,\overrightarrow{e_z}`$<br>
!! </details>





##### Description de la distribution de charges


figure


* Une **disque $`\mathcal{D}`$** de **rayon $`R`$** porte une *charge électrique $`Q`$* non nulle, *répartie uniformément* à sa surface.

* Pour décrire la situation et réaliser les calculs, choisissons le point **origine $`O`$** et le système de **coordonnées cylindrique 
$`(\rho, \varphi, z)`$**, tel que le *disque $`\mathcal{D}`$* soit de *centre $`O`$*
et s'inscrive *dans le plan perpendiculaire à l'axe $`Oz`$*.


##### Identification et écriture des éléments de charge

* Le *disque $`\mathcal{D}`$*, d'aire $`S=\pi\,R^2`$, se décompose mentalement en ses 
**éléments de surface d'aire**   
<br>
**$`dS_p = \rho_P\,d\varphi\,d\rho`$**    
<br>
situés en tout *point $`P`$ du disque* de coordonnées cylindriques   
<br>
*$`P = (\rho_P, \,\varphi_P, z_P=0)`$*. 

* La *charge totale $`Q`$* (C) étant *répartie uniformément* sur la surface du disque, la distribution spatiale de charge
peut être totalement décrite par une **densité surfacique de charge $`\dens^{2D}_0`$** de valeur **constante**
en tout point $`P`$ de la spire, telle que :   
<br>
**$`\dens^{2D}_0 = \dfrac{Q}{S} = \dfrac{Q}{\pi\,R^2}\quad`$**(C&nbsp;m<sup>-2</sup>)

* Chaque *élément de surface $`dl_P`$* porte la **charge élémentaire**   
<br>
**$`dq_P = \dens^{2D}_0\;dS_P = \dens^{2D}_0\,\rho_P\,d\varphi\,d\rho\quad`$**(C)



##### Expression du champ électrique élémentaire


* Selon la loi de Coulomb, la charge élémentaire $`dq_P`$ en tout point $`P`$ du disque chargé créé
*en tout point $`M`$* de l'espace, le **champ électrique élémentaire**    
<br>
 **$`\overrightarrow{dE}_{P\rightarrow M}=\dfrac{dq_P}{4\pi\epsilon_0}\cdot \dfrac{\overrightarrow{PM}}{\lVert \overrightarrow{PM}\rVert^3}\quad`$**
(V&nbsp;m<sup>-1</sup>)

* Le calcul de $`\overrightarrow{E}_M`$ se limitant à l'axe $`Oz`$, les coordonnées de tout
*point $`M`$ situé sur l'axe $`Oz`$* s'expriment     
*$`M = (\rho_M = 0, \,\varphi_M = 0, \, z_M)`$*

* **Exprimons $`\overrightarrow{dE}_{P\rightarrow M}`$** *en fonction des données de base de l'étude*, soit 
  le rayon $`R`$ de la spire, la coordonnée $`z_M`$, et les vecteurs
  $`\overrightarrow{e_{\rho}},\,\overrightarrow{e_{\varphi}},\,\overrightarrow{e_z}`$ de la base cylindrique choisie :

   * le vecteur $`,\overrightarrow{PM}`$ se décompose en   
     <br>
     **$`\overrightarrow{PM}=\overrightarrow{PO}+\overrightarrow{OM}=-\rho_P\,\overrightarrow{e_{\rho}}+z_M\,\overrightarrow{e_z}`$**. 
   * Les coordonnées cylindriques sont orthonormées ($`\overrightarrow{e_{\rho}}\perp\overrightarrow{e_z}`$) donc
     l'angle $`\alpha =\widehat{OMP}`$ est droit, le triangle (OMP) est rectangle en $`O`$.   
     Ainsi la *distance $`d=||\,\overrightarrow{PM}\,||`$* qui intervient dans la loi de Coulomb, 
     grâce au *théorème de Pythagore* appliqué au triangle (OMP), s'exprime :     
     <br>
     **$`d = \sqrt{\rho_P^2+z_M^2}=(\rho_P^2+z_M^2)^{1/2}`$**

* Le **champ électrique élémentaire** au point $`M`$ créé par la charge en $`P`$ se réécrit donc :<br>
<br>
**$`\mathbf{\overrightarrow{dE}_{P\rightarrow M}}`$** 
$`\quad=\quad\dfrac{\dens^{2D}\cdot dS_P}{4\pi\epsilon_0}\cdot\dfrac{\overrightarrow{PM}}{||\,\overrightarrow{PM}\,||^{\,3}}`$   
<br>
$`\hspace{2.3cm}=\quad\dfrac{\dens^{2D}\cdot \rho_P\,d\varphi\,d\rho}{4\pi\epsilon_0}\cdot\dfrac{\overrightarrow{PM}}{d^3}`$   
<br>
**$`\mathbf{\boldsymbol{\hspace{2.3cm}=\quad\dfrac{\dens^{2D}}{4\pi\epsilon_0}\cdot\dfrac{-\rho_P\,\overrightarrow{e_{\rho}}+z_M\,
\overrightarrow{e_z}}{(\rho_P^2+z_M^2)^{3/2}}\;\rho_P\,d\varphi\,d\rho}}`$**



##### Symétries des charges et direction du champ électrique total

figure à faire

* **Pour tout point $`P`$** du disque portant l'élément de charge $`\dens^{2D}_0\;dS_P`$
  **existe $`P'`$**, le point sur l'anneau *symétrique de $`P`$ par rapport au centre $`O`$*
  de l'anneau, qui porte l'élément de charge  $`\dens^{2D}_0\;dS_{P\Large '}`$ **tel que**   
  <br>
  **$`\dens^{2D}_0\;dS_{P\Large '}=\dens^{2D}_0\;dS_P`$**

* La *loi de Coulomb* appliquée aux champs élémentaires $`\overrightarrow{dE}_{P\rightarrow M}`$ et 
  $`\overrightarrow{dE}_{P'\rightarrow M}`$ créés en tout point $`M`$ de l'axe $`Oz`$, par les éléments
  de charge en $`P`$ et $`P'`$ montre que :   
  <br>
  la **somme de ces deux contributions $`\overrightarrow{dE}_{P\rightarrow M}`$ et $`\overrightarrow{dE}_{P'\rightarrow M}`$**
  au champ électrique total en $`\overrightarrow{E_M}`$
  est *dirigé selon $`\overrightarrow{e_z}`$*.   
  <br>
  Ainsi **seule la composante $`dE_{P\rightarrow M,z}`$** $`\; = \overrightarrow{dE}_{P\rightarrow M}\cdot\overrightarrow{e_z}`$ 
  du champ électrique élémentaire selon $`z`$ *contribue au champ total $`\overrightarrow{E}_M`$* :   
  <br>
  **$`\boldsymbol{\mathbf{\overrightarrow{dE}_{P\rightarrow M,z}=\dfrac{\dens^{2D}}{4\pi\epsilon_0}\cdot\dfrac{\rho_P\,z_M}{(\rho_P^2+z_M^2)^{\,3/2}}\,d\varphi\,\,d\rho\,\overrightarrow{e_z}}}`$**


##### Calcul du champ électrique total par intégration


* Le **champ électrique total** $`\overrightarrow{E}_M`$ en tout point $`M`$ de l'axe $`Oz`$, s'obtient en faisant 
  la *somme intégrale des $`\overrightarrow{dE}_{P\rightarrow M,z}`$* (principe de superposition appliqué 
  au champ électrique)sur *tous les point $`P`$ de la spire*   
  <br>
  **$`\displaystyle\boldsymbol{\mathbf{\overrightarrow{E}_M = \int_{P\in\mathcal{D}} \overrightarrow{dE}_{P\rightarrow M,z}}}`$**

*  *Tous les $`\overrightarrow{dE}_{P\rightarrow M,z}`$* ayant la *même orientation selon $`\overrightarrow{e_z}`$*, 
   la calcul intégrale se simplifie :   
  <br>
   **$`\boldsymbol{\mathbf{\overrightarrow{E}_M = E_M\;\overrightarrow{e_z}}}`$**   
  <br>
  avec    
  <br>
  *$`\boldsymbol{\mathbf{\displaystyle E_M=\int_{P\in\mathcal{D}} dE_{P\rightarrow M,z}}}`$*
   
*  L'*ensemble des points $`P`$* du disque, de coordonnées  $`P=(\rho_M,\,\varphi_M,\,0)`$, s'obtient 
   en faisant varier 
   * **$`\varphi_P`$ entre $`0`$ et  $`2\pi`$**
   * **$`\rho_P`$ entre $`0`$ et $`R`$**   
   Il s'agira donc de réaliser une *intégrale double*, dont les variables d'intégration
   $`d\varphi`$ et $`d\rho`$ varient indépendamment l'une de l'autre.

* Pour conduire la plus difficile des intégrations, celle relative à la variable $`\rho`$,
  préparons l'expression du champ élémentaire en faisant disparaître le dénominateur pour le réexprimer au numérateur :   
  <br>
  **$`\boldsymbol{\mathbf{dE_{P\rightarrow M,z}}}`$** $`\;=\dfrac{\dens^{2D}}{4\pi\,\epsilon_0}\cdot\dfrac{\rho_P\,z_M}{(\rho_P^2+z_M^2)^{\,3/2}}`$   
  <br>
` **$`\boldsymbol{\mathbf{\hspace{1.5 cm}=\dfrac{\dens^{2D}\,z_M}{4\pi\,\epsilon_0}\cdot\rho_P\,(\rho_P^2+z_M^2)^{\,-3/2}}}`$**

* L'ordre d'intégration n'importe pas.

* L'intégration sur la variable $`d\varphi`$ donne :   
  <br>
  *$`\mathbf{\boldsymbol{E_M}}`$* 
  $`\displaystyle\;=\dfrac{\dens^{2D}\,z_M}{4\pi\,\epsilon_0}
  \cdot
  \int_{\varphi=0}^{2\pi} d\varphi 
  \cdot
  \int_{\rho=0}^{R} \rho\,(\rho^2+z_M^2)^{\,-3/2}\,d\rho`$   
  <br>
  *$`\displaystyle\boldsymbol{\mathbf{\hspace{1.5 cm}=\dfrac{\dens^{2D}\,z_M}{2\,\epsilon_0}\cdot\int_{\rho=0}^{R} \rho\,(\rho^2+z_M^2)^{\,-3/2}\,d\rho}}`$*

* L'intégration sur la variable $`d\rho`$ donne :   

   $`\color{blue}{\scriptsize{\text{La dérivée de } u^n \text{ (avec u fonction de variable réelle x)}}}`$
   $`\color{blue}{\scriptsize{\text{étant } n\cdot u^{n-1}\cdot u'\;\text{, alors}}}`$   
   $`\color{blue}{\scriptsize{\text{  - la primitive de }  n\cdot u^{n-1}\cdot u' \text{ est } u^n}}`$   
   $`\color{blue}{\scriptsize{\text{soit encore }}}`$   
   $`\color{blue}{\scriptsize{\text{  - la primitive de } (n+1)\cdot u^n \cdot u' \text{ est } u^{n+1}}}`$   

   *$`\mathbf{\boldsymbol{E_M}}`$*
    $`\displaystyle\;=\dfrac{\dens^{2D}\,z_M}{2\,\epsilon_0}
    \times
    \int_{\rho=0}^{R} \rho\,(\rho^2+z_M^2)^{\,-3/2}\,d\rho`$    
    <br>
    $`\displaystyle\hspace{1cm}=\dfrac{\dens^{2D}\,z}{2\epsilon_0}  
    \int_{\rho = 0}^R - \Big(\underbrace{-\dfrac{1}{2}}_{\color{blue}{n+1}}\Big)\cdot\underbrace{2\rho}_{\color{blue}{u^{\,'}}}\,\underbrace{(\rho^2+z^2)^{-\,3/2}}_{\color{blue}{u^n}}\,d\rho`$   
    <br>
    $`\displaystyle \hspace{1cm} =  - \dfrac{\dens^{2D}\,z}{2\epsilon_0} \big[\underbrace{(\rho^2+z^2)^{-\,1/2}}_{\color{blue}{u^{n+1}}}\big]_0^R`$  
    <br>
    $`\color{blue}{\scriptsize{\text{Le signe moins devient plus}}}`$
    $`\color{blue}{\scriptsize{\text{en inversant les bornes d'intégration}}}`$   
    <br>
    $`\displaystyle \hspace{1cm} = +\dfrac{\dens^{2D}\,z}{2\epsilon_0} \big[(\rho^2+z^2)^{-\,1/2}\big]_R^0`$   
    <br>
    $`\displaystyle \hspace{1cm} =  \dfrac{\dens^{2D}\,z}{2\epsilon_0} \left(\dfrac{1}{\sqrt{z^2}} - \dfrac{1}{\sqrt{R^2+z^2}}\right)`$   
    <br>
    *$`\displaystyle\mathbf{\boldsymbol{ \hspace{1cm} =  \dfrac{\dens^{2D}\,z}{2\epsilon_0} \left(\dfrac{1}{|z|} - \dfrac{1}{\sqrt{R^2+z^2}}\right)}}`$*   

*   Au final, le **champ électrique $`\overrightarrow{E}`$** créé en tout point de coordonnées z 
    **sur l'axe de révolution $`Oz`$** (l'origine $`O`$ étant le centre du disque)
    par un *disque de rayon $`R`$* chargé électriquement par une *distribution surfacique de charge uniforme $`\dens^{2D}`$*
    s'écrit :   
    <br>
    *Pour $`z>0`$* :   
    <br>
    **$`\mathbf{\boldsymbol{\overrightarrow{E}(z) =  \dfrac{\dens^{2D}\,z}{2\epsilon_0} \left(1 - \dfrac{z}{\sqrt{R^2+z^2}}\right)\,\overrightarrow{e_z}}}`$**   
    <br>
    *Pour $`z>0`$* :   
    <br>
    **$`\mathbf{\boldsymbol{\overrightarrow{E}(z) =  \dfrac{\dens^{2D}\,z}{2\epsilon_0} \left(- 1 - \dfrac{z}{\sqrt{R^2+z^2}}\right)\,\overrightarrow{e_z}}}`$**



##### Interprétation

à faire







<br>

--------------------------------------------

#### **4 -** Quel est le champ électrique créé dans tous l'espace par plan infini uniformément chargé ?

<!--MAGST-550-->

<br>

--------------------------------------------

#### **5 -** Qu'est-ce qu'un dipôle électrique, et quel champ électrique créé t-il ?

<!--MAGST-600-->
