---
title: 'Gauss local distribution cylindrique'
published: true
routable: true
visible: true
lessons:
    -
        slug: electrostatics-cylindrical-charge-direct-gauss-integral-local
        name: PARALLÈLE-3 : Comparaison calcul direct, Gauss intégral et local
        order: 3
    -
        slug: gauss-local-cylindrical-symmetry-3-linear
        name: LINÉAIRE-3 : Symétrie cylindrique avec Gauss local
        order: 2
    -
        slug: plane-cylindrical-spherical-distribution-gauss-local
        name: PARALLÈLE-3 : Gauss local : charges planes, cylindriques et sphériques
        order: 2
    -
        slug: gauss-local-cylindrical-symmetry-3-method
        name: LINÉAIRE-3 : De Gauss local aux charges à symétrie cylindrique
        order: 2  
    -   
        slug: gauss-theorem-cylindrical-symmetry-3
        name: "PARALLÈLE-3 : Symétrie cylindrique, Gauss intégral et local"
        order: 3
    -  
        slug: gauss-local-cylindrical-symmetry-3-mathtool
        name: OUTIL-MATH-3 : Éq. différentielles, coordonnées et charges cylindriques
        order: 2
    -
        slug: cylindrical-charge-or-current-distributions-local
        name: PARALLÈLE-3 : Distributions cylindriques, Gauss et Ampère locaux
        order: 1
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-7_L1200.jpg)<details>
<summary>Etape 7 : En test auprès d'étudiants</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

##### Application du théorème de **Gauss local** aux  


### **Distributions cylindriques de charges**

* Le terme **cylindrique** réfère à l'*aspect extérieur* de la distribution de charges.

#### Propriétés nécessaires au théorème de Gauss

* Le théorème de Gauss sera utilisable si une distribution cylindrique de charges possède les deux éléments de symétrie suivants :
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

<!---------un peu inutile ici---------
! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.

* La cause du champ $`\overrightarrow{E}`$ (la charge électrique) étant un scalaire, tout plan contenant l'axe de révolution est plan de symétrie pour la charge électrique.
------------------------------------->


#### Quel système de coordonnées spatiales choisir ?

* Le système de coordonnées *le mieux adapté* est le système de **coordonnées cylindriques $`(O,\rho,\varphi,z)`$**, 
   avec **$`Oz =\;`$ axe de révolution**, et où :
   * $`O`$ est le point de l'espace pris comme origine des coordonnées.
   * $`(\rho,\varphi,z)`$ sont les coordonnées cylindriques.
   
  et de repère orthonormé associé le *repère cylindrique $`\mathbf{(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})}`$*.

#### Comment caractériser cette distribution de charges ?

* La distribution de charges est décrite par une **densité de charges $`\dens=\dens(\rho,\varphi,z)`$**.
<br>
   * L'*invariance par rotation* d'angle $`\Delta\varphi`$ quelconque impose **$`\require{\cancel}\dens= \dens(\rho,\xcancel{\varphi}, z)`$**.
   * L'*invariance par translation* de longueur $`\Delta z`$ quelconque impose  **$`\require{cancel}\dens= \dens(\rho,\varphi, \xcancel{z})`$**.
<br>
* *Au final*, la densité volumique de charges **$`\dens`$ ne dépend que de z** :   
*$`\mathbf{\left.\begin{array}{l}
\dens=\dens\,(\rho, z) \\
\dens=\dens\,(\rho, \varphi)
\end{array}\quad\right\}
\,\Longrightarrow}`$* **$`\mathbf{\dens=\dens(\rho)}`$**

<br>

![](electrostatics-gauss-cylindrical-charge-distribution-1-v7_L1200.gif)
_Un cylindre infini est, lorsqu'il est chargé uniformément en volume, l'exemple le plus simple de distribution de chargess à symétrie cylindrique. Corriger_ $`\vec{e_r}`$ _en_ $`\vec{e_{\rho}}`$.


#### De quelles coordonnées dépend  $`\overrightarrow{E}`$ ?

* **L'effet** possède les *invariances de sa cause* :
$`\Longrightarrow`$**$`\mathbf{\overrightarrow{E}}`$** possède les *invariances de $`\dens`$*

* $`\mathbf{\dens=\dens(\rho)\Longrightarrow}`$**$`\mathbf{\overrightarrow{E}=\overrightarrow{E}(\rho)}`$**

#### Comment déterminer la direction de $`\overrightarrow{E}`$ ?

* *Par l'* **étude des symétries** *de la distribution de charges $`\dens`$*.   

<br>

![](https://m3p2.com/temporary_ins/electrostatics-vacuum/gauss-theorem-applications/cylindrical-charge-distributions/gauss-integral/overview/electrostatics-gauss-cylindrical-charge-distribution-2-v9_L1200.gif)


1. Soit un **point $`M(\rho_M\,\varphi_M,z_M)`$ quelconque** de l'espace.
2. Le **plan $`P_1`$** qui contient le point $`M`$ et l'axe $`Oz`$ est *plan de symétrie* pour la distribution de charges.
3. Le **plan $`P_2`$** qui contient le point $`M`$ et perpendiculaire à l'axe $`Oz`$ est *plan de symétrie* pour la distribution de charges.
4. Le champ électrique **$`\overrightarrow{E}`$ étant un vecteur polaire**, en tout point d'un plan de symétrie 
   il est contenu ce plan.    
   Ainsi *$`\overrightarrow{E}`$ est contenu* à la fois dans $`P_1`$ et $`P_2`$, il est donc contenu 
   *dans l'intersection $`P_1 \cap P_2`$* de ces deux plans.   
   La *direction de $`\overrightarrow{E}`$, selon $`\overrightarrow{e_{\rho}}`$*, est 
   *totalement déterminée*.

* De façon plus concise :   
<br>
**En tout point $`M`$** de l'espace,
*$`\left.\begin{array}{l} \overrightarrow{E}\;\text{vecteur polaire} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_z})\; \text{plan de symétrie} \\
P_2\,(M, \overrightarrow{e_{\varphi}}, \overrightarrow{e_{\rho}})\; \text{plan de symétrie}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}}`$**
 
![](https://m3p2.com/temporary_ins/electrostatics-vacuum/gauss-theorem-applications/cylindrical-charge-distributions/gauss-integral/overview/electrostat-symetries-cylinder_L1200.jpg)
<br>


#### Comment s'exprime  $`\overrightarrow{E}`$ en tout point de l'espace ?

* Synthèse de l'étude des invariances et symétries de $`\dens`$ :   
**En tout point $`M`$** de l'espace,   
*$`\left.\begin{array}{l}
\text{Invariances}\Longrightarrow\overrightarrow{E}=\overrightarrow{E}(\rho) \\
\text{Symétries}\Longrightarrow\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}}}`$**

#### Y-a-t'il des lieux où $`\overrightarrow{E}`$ est déjà totalement déterminé par les symétries et invariances ?

_figure à joindre_

**En tout point $`M\in Oz`$** :
* $`\left.\begin{array}{l} \overrightarrow{E}\;\text{vecteur polaire} \\
\exists \mathcal{P}_1\mid \mathcal{P}_1\supset Oz  \text{ , plan de symétrie} \\
\exists \mathcal{P}_2 \ne \mathcal{P}_1 \mid \mathcal{P}_2\supset Oz  \text{ , plan de symétrie}
\end{array}\right\}\,\Longrightarrow`$**$`\mathbf{\overrightarrow{E}=E_z\,\overrightarrow{e_z}}`$**

* $`\left.\begin{array}{l} \overrightarrow{E}\;\text{vecteur polaire} \\
\mathcal{P}_0\,(M, \overrightarrow{e_{\varphi}}, \overrightarrow{e_{\rho}})\; \text{plan de symétrie} \\
\end{array}\right\}\,\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}+E_{\varphi}\,\overrightarrow{e_{\varphi}}}`$**

* $`\left.\begin{array}{l} 
\overrightarrow{E}=0\,\overrightarrow{e_{\rho}}+ 0\,\overrightarrow{e_{\varphi}}+E_z\,\overrightarrow{e_z} \\
\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}+E_{\varphi}\,\overrightarrow{e_{\varphi}}+0\,\overrightarrow{e_z}
\end{array}\right\}\,\Longrightarrow`$* 
**$`\mathbf{\overrightarrow{E}=0\,\overrightarrow{e_{\rho}}+ 0\,\overrightarrow{e_{\varphi}}+0\,\overrightarrow{e_z}=\overrightarrow{0}}`$** 

Donc **par raisons de symétries**, le *champ électrique *est *nul en tout point de l'axe de révolution $`Oz`$* :   
<br>
**$`\mathbf{\overrightarrow{E}(\rho=0) = \overrightarrow{0}}`$**


#### Quelle expression de la divergence de  $`\overrightarrow{E}`$ choisir ?

* L'étude se réalise dans le repère cylindrique  $`(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, z)`$

* $`\Longrightarrow`$ nous choisissons l'*expression en coordonnées cylindriques* de la divergence  :   
<br>
**$`\mathbf{div\overrightarrow{E}=
\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}
+\dfrac{1}{\rho}\cdot\dfrac{\partial\,E_{\varphi}}{\partial\,\varphi}
+\dfrac{\partial\,E_z}{\partial\,z}}`$**

#### Qu'implique la direction de $`\overrightarrow{E}`$ ?

* L'étude des symétries de la distribution de charge implique en tout point de l'espace :    **$`\mathbf{\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}}`$**

* $`\Longrightarrow`$ les autres composantes de champ *$`\mathbf{E_{\varphi} \text{ et } E_z}`$ sont nulles* en tout point de l'espace :
<br>
$`\overrightarrow{E}=E_{\rho}\,\overrightarrow{e_{\rho}}=E_{\rho}\,\overrightarrow{e_{\rho}}+0\,\overrightarrow{e_{\varphi}}+0\,\overrightarrow{e_z}`$
  **$` \Longrightarrow\left\{
\begin{array}{l}
\mathbf{E_{\varphi}=0} \\
\mathbf{ E_z=0}
 \end{array}
 \right.`$**
 
* Si $`\mathbf{E_{\varphi}=E_z=0}`$ en tout point de l'espace $`\mathscr{E}`$, alors leur valeur nulle ne varie pas d'un point à un autre point voisin par translation élémentaire $`dz`$ ou variation élémentaire d'angle $`d\varphi`$. Donc *les dérivées partiellles de $`\mathbf{E_{\varphi}\text{ et }E_z}`$ par rapport à $`\mathbf{z\text{ et }\varphi}`$ sont nulles*.   
$`\mathbf{\forall M \in \mathscr{E}\, , E_{\varphi}=E_z=0}`$
  **$` \Longrightarrow\left\{
\begin{array}{l}
\mathbf{\dfrac{\partial E_{\varphi}}{\partial\varphi}=0 \;\;\text{ et } \;\;\dfrac{\partial E_{\varphi}}{\partial z}=0} \\
\mathbf{\dfrac{\partial E_z}{\partial\varphi}=0 \;\;\text{ et } \;\;\dfrac{\partial E_z}{\partial z}=0}
 \end{array}
 \right.`$**
 
* $`\Longrightarrow`$ l'expression de *la divergence de $`\overrightarrow{E}`$ se simplifie* en tout point de l'espace :   
**$`\mathbf{div\overrightarrow{E}}`$**
$`\require{\cancel}=\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}
+\xcancel{\dfrac{1}{\rho}\cdot\dfrac{\partial\,E_{\varphi}}{\partial\,\varphi}}
+\xcancel{\dfrac{\partial\,E_z}{\partial\,z}}`$
**$`\mathbf{\quad\quad=\dfrac{1}{\rho}\cdot\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}}`$**


#### Qu'impliquent les invariances de  $`\overrightarrow{E}`$ ?

* L'étude des invariances de la distribution de charge implique en tout point de l'espace :   **$`\boldsymbol{\mathbf{\overrightarrow{E}=\overrightarrow{E}(\rho)}=E_{\rho}(\rho)\,\overrightarrow{e_\rho}}`$** 

* Dans l'espression $`\dfrac{\partial\left(\rho\,E_{\rho}\right)}{\partial\,\rho}`$, le terme **$`\rho\,E_{\rho}(\rho)`$** est une **fonction de la seule coordonnée $`\rho`$**. l'opérateur de *dérivée partielle* $`\dfrac{\partial}{\partial\,\rho}`$ peut être *remplacée par* l'opérateur de *dérivée totale* $`\dfrac{d}{d\rho}`$.

* $`\Longrightarrow`$  la divergence de $`\overrightarrow{E}`$ se réécrit :   
**$`\boldsymbol{\mathbf{div\overrightarrow{E}=\dfrac{1}{\rho}\cdot\dfrac{d\left(\rho\,E_{\rho}\right)}{d\rho}}}`$**

#### Comment remonter à l'expression de $`\overrightarrow{E}`$ ?

* $`div\overrightarrow{E}=\dfrac{1}{\rho}\cdot\dfrac{d\left(\rho\,E_{\rho}\right)}{d\rho}`$ permet l'*écriture de la différentielle $`d\left(\rho\,E_{\rho}\right)`$* de la fonction $`\rho\,E_{\rho}`$ sous la forme :   
<br>
**$`\boldsymbol{\mathbf{d\left(\rho\,E_{\rho}\right)=\rho\,div\overrightarrow{E}\cdot d\rho}}`$**

* L'*intégration de $`d\left(\rho\,E_{\rho}\right)`$ entre $`\rho=0`$ et $`\rho_M`$*, $`M=M(\rho_M\,,\varphi_M\,, z_M)`$ étant un point quelconque de l'espace donne :   
<br>
**$`\displaystyle\boldsymbol{\mathbf{\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)=\rho_M\,E_{\rho}(\rho_M)-0\times E_{\rho}(0)}}`$**

* **par raisons de symétries**, *$`\mathbf{\overrightarrow{E}}`$ est nul sur l'axe $`\mathbf{Oz}`$*,     
$`\overrightarrow{E}(\rho=0) = \overrightarrow{0} \Longrightarrow 0 \times E_{\rho}(0)=0`$,    
(il suffisait de montrer que le champ garde une valeur finie en $`\rho=0`$)  
<br>
$`\quad\Longrightarrow`$ **$`\displaystyle\boldsymbol{\mathbf{\rho_M\,E_{\rho}=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}}`$**

* Nous obtenons alors, *en tout point $`\mathbf{M=M(\rho_M\,,\varphi_M\,, z_M)}`$*,    
<br>
**$`\left\{\begin{array}{l}
\boldsymbol{\mathbf{\rho_M=0\Longrightarrow \overrightarrow{E}=\overrightarrow{0}}} \\
\boldsymbol{\mathbf{\displaystyle\rho_M\gt 0 \Longrightarrow \overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)\cdot\overrightarrow{e_{\rho}}}}
\end{array}\right.`$**

#### Comment faire le lien avec la distribution de charges puis en déduire $`\overrightarrow{E}`$ ?

* Calculer la champ électrique $`\overrightarrow{E}`$ revient à calculer une intégrale dont l'intégrande est la différentielle $`d\left(\rho\,E_{\rho}\right)`$ :    
<br>
$`\displaystyle\overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)\cdot\overrightarrow{e_{\rho}}`$


* Cette différentielle s'exprime simplement en fonction de la divergence de $`\overrightarrow{E}`$, et le théorème de Gauss local relie cette divergence à la densité volumique de charge $`\dens^{3D}`$. Nous obtenons une *expression de $`d\left(\rho\,E_{\rho}\right)`$ en fonction de $`\dens^{3D}`$* :   
<br>
$`\left.\begin{array}{l}
d\left(\rho\,E_{\rho}\right)=\rho\,div\overrightarrow{E}\cdot d\rho \\
div\overrightarrow{E}=\dfrac{\dens^{3D}}{\epsilon_0}
\end{array}\right\}`$$`\Longrightarrow`$
**$`\boldsymbol{\mathbf{d\left(\rho\,E_{\rho}\right)=\dfrac{\rho\,\dens^{3D}}{\epsilon_0}\cdot d\rho}}`$**

* Dès lors, l'intégration relie en chaque point le champ électrique local à la densité volumique de charge locale :
<br>
$`\left.\begin{array}{l}
\displaystyle\overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)\cdot\overrightarrow{e_{\rho}}\\
d\left(\rho\,E_{\rho}\right)=\dfrac{\rho\,\dens^{3D}}{\epsilon_0}\cdot d\rho
\end{array}\right\}`$$`\Longrightarrow`$
**$`\displaystyle\boldsymbol{\mathbf{\overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens^{3D}}{\epsilon_0}\cdot\overrightarrow{e_{\rho}}}}`$**

* **Ces résultats**   
    * Sur l'axe de révolution $`Oz`$ ($`\rho_M=0`$ :   
    $`\overrightarrow{E}=\overrightarrow{0}`$
    * Partout ailleurs :     
    $`\displaystyle\overrightarrow{E}=\dfrac{1}{\rho_M}\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens^{3D}}{\epsilon_0}\cdot\overrightarrow{e_{\rho}}`$   
    <br>
   sont *commun à toutes les distributions* de charge à symétrie cylindrique invariantes par translation selon $`Oz`$.

* Le **calcul final de $`\overrightarrow{E}`$** nécessite de *connaître l'expression mathématique pour $`\mathbf{\dens^{3D}}`$* en chaque point de l'espace.    
<br>
$`\Longrightarrow`$ **différentes distributions de charge sont étudiées** *dans la suite de cette page*.

<br>

---------------------

#### **1 -** Cylindre infini de rayon $`R`$ chargé uniformément en volume

##### Description de $`\dens`$ :

* **$`\left\{\begin{array}{ll}
\rho\le R \Longrightarrow \dens^{3D}(\rho)=\dens^{3D}_0 = cste\gt 0 \\
\rho\gt R \Longrightarrow \dens^{3D}(\rho)= 0
\end{array}\right.`$**   


##### Calcul de $`\overrightarrow{E}`$ avec une intégrale définie

<!------------
* Nombre de sous-espaces complémentaires à prendre en compte : 2
   * sous-espace $`\mathscr{E}_{int}`$, caractérisé par $`\dens=\dens^{3D}_0`$ et tel que $`\rho\le R`$.
   * sous-espace $`\mathscr{E}_{ext}`$, caractérisé par $`\dens=0`$ et tel que $`\rho \gt R`$

*  L'*objectif final* est de calculer le champ électrique **$`\mathbf{\overrightarrow{E}}`$ en tout point $`\mathbf{M=(\rho_M\,\varphi_M\,z_M)}`$** de l'espace.
*  **2 cas sont à prendre en compte**, selon que le point *$`M`$ est situé à l'intérieur* $`(\rho_M\le R)`$ ou *à l'extérieur* $`(\rho_M\gt R)`$ du cylindre chargé de rayon $`R`$.


**Pour tout point $`\mathbf{M=M(\rho_M\,\varphi_M\, z_M)}`$** de l'espace, la synthèse des résultats donne :   
(ne pas oublier le facteur $`1\,/\,\epsilon_0`$)
----------->

<br>
**$`\large\text{Pour  }\mathbf{\rho_M = 0}`$** :    
L'étude des symétries nous a permis d'affirmer précédemment que :    
**$`\mathbf{\overrightarrow{E}(\rho=0) = \overrightarrow{0}}`$**
<br>

<br>
**$`\large\text{Pour  }\mathbf{0\lt \rho_M\le R}`$** :    
donc à l'*intérieur du cylindre chargé* mais hors axe de révolution :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\int_{\rho=0}^{\rho_M}\rho\,d\rho`$    
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\,\bigg[ \dfrac{\rho^2}{2}\bigg]_0^{\rho_M}`$   
<br>
$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{\rho_M^2\,\dens_0^{3D}}{2\epsilon_0}`$   
<br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons *au final* :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)=\dfrac{\rho_M\,\dens_0^{3D}}{2\epsilon_0}
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{\rho_M\,\dens^{3D}_0}{2\,\epsilon_0}\,\overrightarrow{e_{\rho}}}`$**
<br>

<br>
**$`\large\text{Pour  }\mathbf{\rho_M\gt R}`$** :    
donc à l'*extérieur du cylindre chargé* :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\int_{\rho=0}^{R}\rho\,d\rho
+\int_{R}^{\rho_M}0\,d\rho`$   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\,\bigg[ \dfrac{\rho^2}{2} \bigg]_0^{R}`$   
<br>
$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{R^2\,\dens_0^{3D}}{2\epsilon_0}`$   
<br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons *au final* :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)=\dfrac{R^2\,\dens_0^{3D}}{2\,\epsilon_0\,\rho_M}
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{R^2\,\dens^{3D}_0}{2\,\epsilon_0\,\rho_M}\,\overrightarrow{e_{\rho}}}`$**


<br>
##### Calcul de $`\overrightarrow{E}`$ avec une intégrale indéfinie

Attention, cette fin d'exo 1, avec intégrale indéfinie, est en cours de rédaction.   
L'affichage du calcul peut être erronée à ce stade.

<br>
**$`\large\text{Pour  }\mathbf{0\lt \rho_M\le R}`$** :    
donc à l'*intérieur du cylindre chargé* mais hors axe de révolution :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int \dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**   
<!---br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\int \rho\,d\rho`$--->
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\, \dfrac{\rho^2}{2}\,+\,Cst_1`$   
<br>
**$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{\rho_M^2\,\dens_0^{3D}}{2\epsilon_0}`$**   
<br>
où *$`Cst_1`$* est une *constante d'intégration* que tu détermineras plus trad.
<!----------br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons *au final* :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)=\dfrac{\rho_M\,\dens_0^{3D}}{2\epsilon_0}
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{\rho_M\,\dens^{3D}_0}{2\,\epsilon_0}\,\overrightarrow{e_{\rho}}}`$**
<br------------>

<br>
**$`\large\text{Pour  }\mathbf{\rho_M\gt R}`$** :    
donc à l'*extérieur du cylindre chargé* :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int \dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\int_{\rho=0}^{R}\rho\,d\rho
+\int_{R}^{\rho_M}0\,d\rho`$   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{\dens_0^{3D}}{\epsilon_0}\,\bigg[ \dfrac{\rho^2}{2} \bigg]_0^{R}`$   
<br>
$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{R^2\,\dens_0^{3D}}{2\epsilon_0}`$   
<br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons *au final* :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)=\dfrac{R^2\,\dens_0^{3D}}{2\,\epsilon_0\,\rho_M}
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{R^2\,\dens^{3D}_0}{2\,\epsilon_0\,\rho_M}\,\overrightarrow{e_{\rho}}}`$**


<br>

---------------------

#### **2 -** Cylindre infini de rayon $`R`$ chargé non uniformément en volume

##### Description de $`\dens`$ :

* Prenons l'**exemple** de la distribution :

**$`\quad\left\{\begin{array}{ll}
\rho\le R \Longrightarrow & \dens^{3D}(\rho) = A\,\rho^2 \\
&\text{ avec }A = cste \gt 0 \\
\rho\gt R \Longrightarrow & \dens^{3D}(\rho)= 0
\end{array}\right.`$**   


<br>
**$`\large\text{Pour  }\mathbf{\rho_M = 0}`$** :    
L'étude des symétries nous a permis d'affirmer précédemment que :    
**$`\mathbf{\overrightarrow{E}(\rho=0) = \overrightarrow{0}}`$**
<br>

<br>
**$`\large\text{Pour  }\mathbf{0\lt \rho_M\le R}`$** :    
donc à l'*intérieur du cylindre chargé* mais hors axe de révolution :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**   
<br>
$`\displaystyle\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\; A\,\rho^2}{\epsilon_0}\,d\rho`$    
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{A}{\epsilon_0}\int_{\rho=0}^{\rho_M}\rho^3\,d\rho`$   
<br>
$`\displaystyle\hspace{2.6cm}=\dfrac{A}{\epsilon_0}\,\bigg[ \dfrac{\rho^4}{4} \bigg]_0^{\rho_M}`$   
<br>
$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{A\,\rho_M^4}{4\,\epsilon_0}`$   
<br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons *au final* :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)\;=\dfrac{A\,\rho_M^3}{4\,\epsilon_0}   
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{A\,\rho_M^3}{4\,\epsilon_0}\,\overrightarrow{e_{\rho}}}`$**
<br>


<br>
**$`\large\text{Pour  }\mathbf{\rho_M\gt R}`$** :    
donc à l'*extérieur du cylindre chargé* :   
<br>
**$`\displaystyle\mathbf{\rho_M\,E_{\rho}(\rho_M)=\int_{\rho=0}^{\rho_M}d\left(\rho\,E_{\rho}\right)}`$**     
<br>
**$`\displaystyle\mathbf{\hspace{2.6cm}=\int_{\rho=0}^{\rho_M}\dfrac{\rho\,\dens_0^{3D}}{\epsilon_0}\,d\rho}`$**    
<br>
$`\displaystyle\hspace{2.6cm}=\int_{\rho=0}^{R}\dfrac{\rho\; A\,\rho^2}{\epsilon_0}\,d\rho
+\int_{R}^{\rho_M}0\,d\rho`$    
<br> 
$`\displaystyle\hspace{2.6cm}=\dfrac{A}{\epsilon_0}\int_{\rho=0}^{R}\rho^3\,d\rho`$  
<br>
$`\rho_M\,E_{\rho}(\rho_M)\;=\dfrac{A\,R^4}{4\,\epsilon_0}`$   
<br>
*$`{\rho_M}`$ étant strictement supérieur à 0*, nous obtenons au final :   
<br>
$`\left.\begin{array}{l}
\overrightarrow{E}=E_{\rho}(\rho)\,\overrightarrow{e_{\rho}} \\
E_{\rho}(\rho_M)\;=\dfrac{A\,R^4}{4\,\epsilon_0\,\rho_M}   
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{E}=\dfrac{A\,R^4}{4\,\epsilon_0\,\rho_M}\,\overrightarrow{e_{\rho}}}`$**

<br>

---------------------

#### **3 -** Cylindre infini creux de rayons intérieur $`R_{int}`$ et extérieur $`R_{ext}`$ 

<br>

---------------------

#### **4 -** Cylindre infini de rayon $`R`$ chargé uniformément en surface

* C'est, entre autre mais pas seulement,  le cas précédent dans la limite où $`R_{int}\longrightarrow R_{ext}=R`$)    
  $`\Longrightarrow \dens^{3D} \text{ est modélisée par } \dens^{2D} `$  
  
##### Description de $`\dens`$ :

* **$`\quad\left\{\begin{array}{ll}
\rho\lt R \Longrightarrow & \dens^{3D}(\rho) = 0 \\
\rho = R  \Longrightarrow & \dens^{2D}(\rho)=  \dens^{2D}_0=cst \ne 0 \\
\rho\gt R \Longrightarrow & \dens^{3D}(\rho) = 0 \\
\end{array}\right.`$**   




