---
title: Analyse systémique
published: true
routable: true
visible: false
lessons:
    - slug: anthropocene-systemic-analysis-overview-3
      order: 2
---

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

Attention, texte ci-dessous en cours de discussion, et est susceptible d'être largement modifié.

#### Qu'est-ce qu'un système complexe ?

<br>
![](simple-complicated-complex-1_L1200.jpg)

![](simple-complicated-complex-2-FR_L1200.gif)<br>
_Exemple pour distinguer les notions de simple, de compliqué et de complexe, selon J-Y ROSSIGNOL [3]_

Les notions de **simplicité**, de **complication** ou de **complexité** d'un système *réfèrent* :   

* du point de vue structure et schéma causal internes,

   *  au **degré d'identification et de connaissance** de *tous les composants* (sous-sytèmes) en lequel
un observateur peut le décomposer, 
   * au **degré de maîtrise** de *toutes les interactions* entre ces composantes.

* du point de vue comportemental dans son environnement,

   * au **degré de prévisibilité** *de son comportement* lorsqu'il évolue dans un environnement normal.
   * au **degré de stabilité** *de son état* sous l'effet d'une perturbation extérieure.
 
* du point de vue de son évolution structurelle et causale,

   * à son **aptitude à s'auto-adapter** (pas, ou plus ou moins rapidement) *à une modification durable de son environnement*


##### Ainsi,

* Un *avion en papier* est un **système simple** :<br>
  * Il se décompose en un *petit nombre de composants* (ici la seule feuille de papier) et il te demande 
  *peu d'instructions* de pliage si tu dois le réaliser.   
  * Son **comportement** est globalement *prévisible*, qu'il soit bien ou mal fait, 
    pour des conditions de lancé identiques dans une atmosphère calme.
  * Sa **capacité de s'auto-adapter** est *nulle*. S'il ne vole pas bien, c'est à l'humain de modifier le profil des ailes en papier.   
  <br>

--------

* Un *avion* de transport de passagers est un **système compliqué**.<br>
  Il se décompose en 
   * un très **grand nombre de composants** (mécaniques, électroniques, parfois hydroliques)
   *clairement identifiés*, et de *fonctions clairement définies*, 
   * **interactions** *maîtrisées* entre chaque composant.  
  
   Dans des conditions de vol normales,
   * le **comportement** de l'avion est *prévisible*.
   * son **état** est stable.
   <br>
   ! *Note* <br>
   ! Cette complication peut entraîner que la maîtrise totale est difficile à atteindre,
   ! et est un enjeu de sécurité aérienne. Mais un *avion* apparaît dans cette maîtrise
   ! *beaucoup plus compliqué que réellement complexe*   

  Si les énergies fossiles qui l'alimentent ne sont plus disponibles,
  * sa **capacité de s'auto-adapter** est *nulle*. Sa structure physique et son schéma causal de fonctionnement
    sont figés.
    <br>
    ! *Note*<br>
    ! Qu'une nouvelle génération d'avions puisse utiliser un jour des énergies renouvelables résulte
    ! d'études et de réalisations extérieures par des humains.    

<br>
    
--------

* Un *aigle* est un **système complexe**.
  Même si un observateur (citoyen, anatomiste, biologiste, généticien, ...) atteint dans son domaine de spécialité
  un certain niveau de connaissance sur l'aigle, et que toutes ces connaissances sont rassemblées,   
  il reste
   * **nombre d'éléments** fonctionnels *non identifiés ou répertoriés* qui peuvent interagir avec les éléments connus,
   * **nombre d'interactions** *insoupçonnées* entre éléments connus ou inconnus.    
   
   qui font que
   * la **réponse et** l'**évolution du système** à une excitation donnée ou un changement même minime dans son environnement
      n'est *pas toujours prévisible* au-delà d'une certaine période.
   * l'**état d'équilibre du système** caractérisant sa stabilité sur une période de temps donnée *peut basculer à un autre état* d'équilbre différent, 
     sous l'effet d'une *perturbation* plus ou moins grande, *parfois très petite*. 

   

   

   !!! <details makdown=1>
!!! <summary>L'aigle comme système complexe</summary>
!!! <br>
!!! * pour **tout humain** qui regarde la **morphologie** de l'aigle sur une échelle de taille allant du mètre au centimètre,
!!!     celui-ci est décomposable mentalement en *différents membres* : une tête, un corps, deux ailes, deux pattes et une queux.    
!!!   
!!! * pour l'**anatomiste**, l'aigle est décomposable mentalement, sur une échelle de taille allant du décimètre au millimètre,
!!!     en *différents tissus et organes* qui sont *en relation* les une avec les autres.   
!!! * pour le biologiste ... à faire   
!!! * pour le microbiologiste ... à faire     
!!! * pour le neurologue ?   
!!! * pour le comportementaliste ?   
!!! réponse de deux aigles à un même prédateur ?   
!!! réponse de deux aigles à un même virus ?   
!!! </details>

    !!!!! <details makdown=1>
!!!!! <summary>Terminologie : différence entre "un composant" et "une composante"</summary>
!!!!! <br>
!!!!! * Un composant a un sens concret.<br>    
!!!!! C'est un élément (électrique, électronique, mécanique, ... ) d'un système, 
!!!!!   qui peut être réparé ou remplacé.<br>   
!!!!! <br>
!!!!! * Une composante a un sens abstrait.<br>    
!!!!!   Un ensemble ou un système complexe peut 
!!!!!   se décomposer en différentes composantes. De par leur nature plus abstraite, les définitions, les types 
!!!!!   et parfois le nombre de composantes est un choix de l'observateur.<br>    
!!!!!   <br>
!!!!! (selon le Guide fédéral de jurilinguistique législative française, Canada)
!!!!! </details>

<br>

#### Quelles sont les propriétés d'un système complexe ?

![](properties-complex-systems-morin-FR_L1200.jpg)    
_Les onze propriétés des systèmes complexes, selon E. Morin [2] , J-Y ROSSIGNOL [3]_