---
title: 'Distributions cylindriques de charge'
published: true
routable: true
visible: true
lessons:
    -
        slug: gauss-integral-cylindrical-symmetry-3-linear
        order: 1
    -
        slug: gauss-integral-cylindrical-symmetry-3-method-main
        order: 3
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


### Distributions de charge à symétrie cylindrique


##### Distribution cylindrique de charge et repère cylindrique $`(O,\rho, \varphi, z)`$

Une *distribution cylindrique* de charge signifie que géométriquement les charges sont localisées dans un cylindre.   
La forme "cylindre" possède un **axe de révolution**.   

Le *repère de l'espace le mieux adapté* pour décrire une distribution cylindrique est le **repère cylindrique $`(O, \rho, \varphi, z)`$** où l'axe **$`Oz`$** est l'**axe de révolution** du cylindre, l'origine $`O`$ étant un point quelconque pris sur cet axe.

##### Distributions volumique, surfacique et linéïque de charge

L*'espace réel perçu possède 3 dimensions*, les charges occupent les trois dimensions spatiales et tout point point de l'espace peut être caractérisé par une **densité volumique de charge $`\dens`$** d'unité SI (pour Système International d'unité) $`Cm^{-3}`$.

**$`\mathbf{\dens = \dens\,(\rho, \varphi, z)\quad}`$** *$`Cm^{-3}`$*

!!!! *Attention* :   
!!!!
!!!! La *lettre grecque "rho"* désigne traditionnellement à la fois :
!!!! * la *coordonnée rho* du repère cylindrique.
!!!! * une *densité volumique* (densité volumique de charge, densité volumique de masse = masse volumique, ...).
!!!!
!!!! Pour distinguer ces deux significations de la lettre rho et éviter toute confusion, *M3P2 utilise* deux police de caractères différentes de cette même lettre rho :
!!!!
!!!! * *$`\large\rho`$* est la *coordonnée rho* du repère cylindrique.   
!!!! * *$`\dens`$* représente une *densité volumique*.

Dans le cas de *charges localisées au voisinage d'une surface* ,sur une couche d'*épaisseur $`e`$ négligeable*, alors un point de cette surface peut être caractérisé par une **densité surfacique de charge $`\sigma`$** d'unité SI $`Cm^{-2}`$. Densité surfacique se dit aussi densité superficielle. Si les charges sont sur la surface latérale du cylindre, la densité surfacique s'écrit :

**$`\mathbf{\sigma = \sigma\,(\varphi, z)\quad}`$** *$`Cm^{-2}`$*

Dans la case de *charges réparties sur une ligne* de *section droite $`S_{\perp}`$ négligeable*, tout point de cette ligne peut être caractérisé par une **densité linéïque de charge $`\lambda`$** d'unité SI $`Cm^{-1}`$. Dans ce cas la densité linéïque de charge s'écrit : 

**$`\mathbf{\lambda = \lambda\,(z)\quad}`$** *$`Cm^{-1}`$*

! *Important* :   
!
! *Densités surfaciques et linéïque* de charge résultent d'une *idéalisation*, d'une *modélisation 2D et 1D* de la distribution des charges dans l'espace.   
!
! Si d'une façon générale, à l'échelle d'observation les grandeurs physiques et les champs varient de façon continue dans l'espace 3D, *des discontinuités peuvent apparaître* lors des modélisations 2D ou 1D.    
!
! Ces discontinuités correspondent à une perte d'information, aux variations continues ignorées des grandeurs physiques et des champs le long des dimensions négligées. 

!! *Pour aller plus loin* :   
!!
!! Un *point* est une *abstraction mathématique sans dimension* (0D) de volume nul. 
!!
!! Il représente un *petit volume* entourant tout point M, *non résolu à l'échelle d'observation* spatiale, mais suffisamment grand pour que la valeur moyenne de la grandeur physique exprimée en ce point soit statistiquement stable à l'échelle d'observation temporelle.  
!!  
!! Un tel volume est dit *volume mésoscopique*. 
!! 
!! Cette notion de volume mésoscopique sera précisée et utilisée dans les diverses études sur les propriétés physiques de la matière, dès ce niveau contrefort puis au niveau montagne.


##### Distributions de charge à symétrie cylindrique

Une distribution de charge à symétrie cylindrique est un cas particulier de distribution cylindrique de charge, qui se caractérise par une **invariance** de la densité de charge **par rotation d'angle $`\varphi`$ quelconque**. Il en résulte que la densité volumique de charge ne dépend plus de la coordonnée $`\varphi`$, mais des seules coordonnées $`\rho`$ et $`z`$.

**$`\dens`$ à symétrie cylindrique $`\require{cancel}\Longleftrightarrow\dens\,(\rho,\xcancel{\varphi}, z) =\dens\,(\rho, z)`$**

* Distribution de charge cylindrique et uniforme :
Dans le cylindre, $`\dens\,(\rho, \varphi, z) = \text{cste} = cste`$


#### Le fil rectiligne infini uniformément chargé

Le théorème de Gauss montre que pour toute surface fermée $`S`$, le flux du vecteur champ électrique $`\overrightarrow{E}`$ à travers $`S`$ égale la charge totale contenue à l'intérieur de $`S`$ divisé par la permittivité électrique du vide $`\epsilon_0`$.

Ce théorème, dans les cas simples où il peut être utilisé en pratique pour le calcul du champ électrique $`\overrightarrow{E}`$ en tout point de l'espace, remplace un calcul direct qui serait extrêmement compliqué à conduire.

La condition à cette simplicité d'utilisation du théorème de Gauss est de connaître à l'avance des d'informations minimum sur le champ $`\overrightarrow{E}`$ créé par la distribution de charge étudiée, à savoir sa direction en tout point de l'espace et les coordonnées dont il dépend explicitement.   

Ces informations sont données par les symétries et invariances de la distribution de charge.

Information donnée par l'étude des invariances.

Si, exprimée dans un système de coordonnées $`(\alpha, \beta, \gamma)`$ une distribution de charge reste invariante lors d'une variation quelconque d'une des coordonnées, par exemple la coordonnée $`\beta`$, alors la valeur de cette distribution de charge ne dépend pas de cette coordonnée $`\beta`$.

Information donnée par l'étude des symétries.








$`\displaystyle\oiint_S \overrightarrow{E}\cdot\ \overrightarrow{dS} = \dfrac{Q_{int}}{\epsilon_0}`$


#### Le cylindre infini chargé







