---
title : electromagnetic-waves-in-vacuum
published : true
routable: true
visible : false
lessons:
    - 
       slug: electromagnetic-waves-propagation-reflexion-transmission
       name: PARALLÈLE-4 : Propagation dans un milieu, Réfléxion et Transmission aux interfaces
       order: 1
    -
       slug: electromagnetic-waves-propagation-in-vacuum
       name: "LINÉAIRE-4 : Propagation des ondes EM dans le vide"
       order: 1
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

Attention !!! En période très préliminaire d'élaboration et de construction !

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### ÉLECTROMAGNÉTISME

### **Propagation des ondes électromagnétiques**<br> *dans le vide*


#### Les équations de propagation du champ électromagnétique

Des quatre équations de Maxwell se déduisent les équations suivantes, vérifiées en tout point de l'espace et à tout instant :

$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\rho \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t} `$

$`\Delta \overrightarrow{B}-\mu_0\epsilon_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}`$

Dans un milieu matériel caractérisé par des champs non nuls de densité volumique de charge
$`\dens(\overrightarrow{r},t)`$ et de vecteur densité volumique de courant $`\overrightarrow{j}(\overrightarrow{r},t)`$ 
se produit une interaction réciproque permanente entre le champ électromagnétique 
$`\big(\overrightarrow{E}(\overrightarrow{r},t)\,,\overrightarrow{B}(\overrightarrow{r},t)\big)`$
et ces charges et courants. Ces équations de propagation du champ électromagnétique dans la matière n'ont pas la
simple forme de l'équation de d'Alembert, et leur étude plus complexe fait l'objet d'un
chapitre spécifique.

Dans le vide la situation est beaucoup plus simple. En effet le vide peut être considéré comme un milieu
homogène et isotrope caractérisé par $`\dens(\overrightarrow{r},t)=0`$ et 
$`\overrightarrow{j}(\overrightarrow{r},t)=\overrightarrow{0}`$. Dans ce cas les équations de propagation
du champ électromagnétique prennent la forme simple de l'équation de d'Alembert vectorielle :

$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = 
\overrightarrow{0}`$

$`\Delta \overrightarrow{B}-\mu_0\epsilon_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=\overrightarrow{0}`$


#### Propagation du champ électromagnétique dans le vide

L'espace vide, localisé en dehors des charges et des courants localisés qui sont
à l'origine du champ électromagnétique, densités volumiques de charges et de courants
sont nulles :

$`\rho=0`$  et  $`\overrightarrow{j}=\overrightarrow{0}`$

Le champ électromagnétique vérifie les deux équations d'onde :

$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = 0 \hspace{1cm}`$
et $`\hspace{1cm}\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=0`$

L'identification avec l'équation d'onde simple 

$`\Delta \overrightarrow{X} - \dfrac{1}{v} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=0`$

me dit que les champs électrique et magnétique se propagent simultanément dans l'espace vide
à la vitesse $`v`$ telle que :

$`\dfrac{1}{v_{\phi}}=\mu_0 \epsilon_0`$, soit $`v_{\phi}=\dfrac{1}{\mu_0 \epsilon_0}`$

La constante électrique (permittivité absolue du vide) $`\epsilon_0`$, constante magnétique
(perméabilité absolue du vide) $`\mu_0`$   et vitesse de la lumière dans le vide $`c`$ sont liées par la relation :

$`\epsilon_0\;\mu_0\;c^2=1`$

Ainsi j'obtiens un résultat fondamental qui va révolutionner toute la physique classique
dans tous ses aspects, hors (mais hors dans un premier temps seulement) son aspect gravitationnelle
décrit par les 3 lois de Newton :

Dans le vide, le champ électromagnétique se propage librement à la vitesse de la lumière $`c`$.

<!--!! AU-DELÀ :
!! Ecrire une petite note historique ici... Premières mesures un peu précises de la vitesse
de la lumière.. Maxwell remarque que les mesures expérimentales de l'époque montrent que $`\epsilon_0\;\mu_0\;c^2\simeq 1`$,
il fait l'hypothèse que $`\epsilon_0\;\mu_0\;c^2=1`$, puis par identification que la lumière
est une onde électromagnétique. .... autre, beaucoup de choses à dire là; Un minimum ici, et beaucoup
plus dans la partie de cours BEYOND.-->

#### Structure et propriétés de l'onde électromagnétique plane progressive monochromatique

##### Front d'onde

J'appele front d'onde toute surface continue de l'espace, si elle existe, sur 
laquelle le champ électromagnétique $`[\,\overrightarrow{E}\,;\,\overrightarrow{B}\;]`$
est identique en chacun de ses points, à tout instant donné.

Dans les cas simples, une onde électromagnétique est dite :
* sphérique, lorsque ses fronts d'onde sont des portions de sphères centrées sur un même point source
* parabolique, lorsque ses fronts d'onde sont des portions de paraboles.
* plane, lorsque ses fronts d'onde sont des plans parallèles entre eux.

<!--sera une remarque-->
Note : L'onde électromagnétique émise dans un milieu homogène et isotrope comme le vide
par une source quasi-ponctuelle est souvent décrite comme une onde sphérique, la 
source de l'onde étant au centre des fronts d'onde sphériques concentriques successifs.
A moyenne distance $`d`$ d'une telle source ponctuelle observée à travers une surface 
de dimension caractéristique $`a`$ petite devant $`d`$ , l'onde est souvent décrite comme
une onde parabolique. A très grande distance de la source, l'approximation de l'onde plane
 est réaliste (les fronts d'onde sont des plans parallèles à la direction de propagation).
Ainsi l'onde électromagnétique émise par le soleil peut être considérée comme une onde plane
lorsqu'elle atteint la Terre.

##### Onde électromagnétique (EM)

Une onde électromagnétique (onde EM) se reconnait parce que ses champs $`\overrightarrow{E}`$ 
et $`\overrightarrow{B}`$  vérifient les équations de Maxwell.

##### Onde EM plane

Une onde EM plane est une onde EM caractérisée par une direction représentée par un vecteur unitaire $`\overrightarrow{u}`$,
telle que tout plan perpendiculaire à cette direction est un front d'onde de l'onde plane.

 
---------------------------
Propriétés de l'onde EM plane :

* Les vecteurs champ électrique $`\overrightarrow{E}`$ et champ magnétique $`\overrightarrow{B}`$ sont perpendiculaires 
à la direction de propagation représentée par un vecteur unitaire $`\overrightarrow{u}`$ : le champ électromagnétique $`[\,\overrightarrow{E}\,;\,\overrightarrow{B}\;]`$ 
est dit transverse.

--------------------------

##### Onde EM plane progressive

<!--Les coordonnées spatiales de tout point M de l'espace sont les composantes du vecteur position 
$`\overrightarrow{r}=\overrightarrow{OM}`$ dans un repère de l'espace donné, d'origine O.

Une **onde EM plane** est **progressive** si les *coordonnées d'espace* contenues dans l'espression du vecteur  
$`\overrightarrow{r}`$ *et de temps sont couplées* dans l'expression des composantes des champs $`\overrightarrow{E}`$ 
et $`\overrightarrow{B}`$ *selon la forme :* **$`\pm\,\overrightarrow{u}\cdot\overrightarrow{r}\pm\,c\,t`$**, où 
$`\overrightarrow{u}`$ est le vecteur caractérisant la direction de l'onde.

Dans un repère cartésien $`(O, \overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})`$,
les 6 composantes des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ d'une 
onde EM plane progressive s'écrivent :

$`\left|
   \begin{array}{r c l}
      E_x=
      \overrightarrow{E}(\overrightarrow{r},t)=\overrightarrow{E}(\pm\,\overrightarrow{u}\cdot\overrightarrow{r}\pm ct) \\
      \overrightarrow{B}(\overrightarrow{r},t)=\overrightarrow{B}(\pm\,\overrightarrow{u}\cdot\overrightarrow{r}\pm ct) \\
   \end{array}
   \right`$.

<!--à modifier, c'est faux là $`\Longleftrightarrow 
\left|
   \begin{array}{r c l}
      \overrightarrow{E}(\overrightarrow{r},t)=\overrightarrow{E}(\pm\,\overrightarrow{u}\cdot\overrightarrow{r}\pm ct) \\
      \overrightarrow{B}(\overrightarrow{r},t)=\overrightarrow{B}(\pm\,\overrightarrow{u}\cdot\overrightarrow{r}\pm ct) \\
   \end{array}
   \right.`$

Si la direction de propagation de l'onde est donnée par le vecteur unitaire $`\overrightarrow{u}`$,
le **sens de propagation** est *donné par les signes qui précèdent les termes 
$`\overrightarrow{u}\cdot\overrightarrow{r}`$ et $`ct`$* :

* Si les **signes** sont **opposés**, l'onde se propage en *direction et sens du vecteur $`\overrightarrow{u}`$*.

* Si les **signes** sont **identiques**, l'onde se propage en *direction, mais sens inverse du vecteur $`\overrightarrow{u}`$*.

Il m'est toujours possible de choisir une repère cartésien de l'espace dont l'un 
vecteur de base est la direction de l'onde plane progressive. Si je choisis un 
repère cartésien de l'espace $`(O, \overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})`$
tel que $`\overrightarrow{e_z}=\overrightarrow{u}`$, alors pour tout point M de
l'espace repéré par le vecteur 
$`\overrightarrow{r}=x\;\overrightarrow{e_x}+y\;\overrightarrow{e_y}+z\;\overrightarrow{e_z}`$ :

$`\overrightarrow{u}\cdot\overrightarrow{r}=(1\;\overrightarrow{e_z})\cdot(x\;\overrightarrow{e_x}+y\;\overrightarrow{e_y}+z\;\overrightarrow{e_z})= z`$

et le champ électromagnétique de cette onde EM s'écrit sous la forme simple :

$`\overrightarrow{E}(\overrightarrow{r},t)=\overrightarrow{E}(\pm z \pm ct)\quad`$
 et $`\overrightarrow{B}(\overrightarrow{r},t)=\overrightarrow{B}(\pm z \pm ct)\quad`$

* $`\overrightarrow{E}(+z-ct)`$ ou $`\overrightarrow{E}(-z+ct)`$ indique une onde 
progressive qui se déplace vers les $`z`$ croissants.

* $`\overrightarrow{E}(+z+ct)`$ ou $`\overrightarrow{E}(-z-ct)`$ indique une onde 
progressive qui se déplace vers les $`z`$ décroissants.-->

---------------------------
Propriétés de l'onde EM plane progressive dans le vide :

* $`\overrightarrow{u}\land\overrightarrow{E}=c\overrightarrow{B}`$

$`\hspace{0.6cm}\Longrightarrow`$ l'OPP EM est transverse.

$`\hspace{0.6cm}\Longrightarrow (\overrightarrow{k},\overrightarrow{E},\overrightarrow{B})`$ forment un trièdre direct.

$`\hspace{0.6cm}\Longrightarrow ||\overrightarrow{B}||=\dfrac{||\overrightarrow{E}||}{c}`$

--------------------------

##### Onde EM plane progressive monochromatique (OPPM)

Une onde EM plane progressive est monochromatique si les champs électrique et magnétique
$`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ sont
des fonctions sinusoïdales de l'espace et du temps.

!!!!! *Terminologie* :<br>
!!!!! *monochromatique = harmonique = sinusoïdal*


Les grandeurs fondamentales décrivant l'OPPM (grandeurs indépendantes du milieu de propagation)
sont les grandeurs temporelles équivalentes suivantes :

* La période temporelle $`T`$, souvent appelée "période" et exprimée en $`s`$ dans le SI, 
est la durée entre deux phases identiques successives de l'onde en un point de l'espace.

* La fréquence temporelle $`\nu`$, souvent appelée "fréquence" et exprimée en $`Hz=s^{-1}`$
dans le SI, est le nombre de période temporelle $`T`$ par unité de temps (la seconde
dans le SI)

* La pulsation $`\omega`$, exprimée en $`rad.s^{-1}`$ dans le SI, est liée à la 
fréquence temporelle par la relation $`\omega=2\,\pi\;\nu`$.

Les grandeurs non fondamentales décrivant l'OPPM (grandeurs qui varieront
selon le milieu de propagation) sont les grandeurs spatiales équivalentes suivantes :

* la vitesse de phase $`v_{\phi}`$ exprimée en $`m.s^{-1}`$ dans le SI est la vitesse
à laquelle un front d'onde de phase donnée se propage dans l'espace.<br>
La vitesse de phase de l'onde électromagnétique dans le vide est une grandeur fondamentale
de la nature, c'est la vitesse de la lumière dans le vide, notée c et de valeur 
exacte $`c=299\,792\,458\;m\,s^{-1}`$. La vitesse c de propagation de la lumière dans le vide
est indépendante de l'état de mouvement de l'observateur (contredisant l'intuition classique)

* la longueur d'onde $`\lambda=v\,T=\dfrac{v}{\nu}`$ exprimée en $`m`$ dans le SI, 
est la période spatiale de l'onde : distance entre deux fronts d'onde successifs de même phase, mesurée
dans la direction de propagation.<br>
Pour l'onde électromagnétique dans le vide, $`\lambda=c\,T=\dfrac{c}{\nu}`$

* le vecteur d'onde $`\overrightarrow{k}=||k||\;\overrightarrow{u}=\dfrac{\omega}{c}\;\overrightarrow{u}`$ <br>
où $`\overrightarrow{u}`$ est le vecteur unitaire qui indique la direction ET le 
sens de propagation de l'onde,<br> et $`k`$$`=||k||`$ est le 
nombre d'onde, exprimé en $`\;rad.m^{-1}\;`$ dans le SI.

---------------------------
Propriétés de l'onde EM plane progressive monochromatique dans le vide :

* $`\overrightarrow{k}\land\overrightarrow{E}=\omega\overrightarrow{B}`$

$`\hspace{0.6cm}\Longrightarrow`$ l'OPPM EM est transverse.

$`\hspace{0.6cm}\Longrightarrow (\overrightarrow{k},\overrightarrow{E},\overrightarrow{B})`$ forment un trièdre direct.

$`\hspace{0.6cm}\Longrightarrow ||\overrightarrow{B}||=\dfrac{k}{\omega}\,||\overrightarrow{E}||=\dfrac{||\overrightarrow{E}||}{c}`$

--------------------------

L'écriture générale d'une onde EM plane progressive monochromatique,
dans un repère cartésien $`(O, \overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})`$ 
quelconque de l'espace, est :

* pour le champ électrique :

$`\hspace{0.6cm}\overrightarrow{E}=\left|
   \begin{array}{l}
      E_x=E_0x\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_x)\\
      E_y=E_0y\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_y)\\
      E_z=E_0z\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_z)\\
   \end{array}
   \right.`$

* pour le champ magnétique :

$`\hspace{0.6cm}\overrightarrow{B}=\left|
   \begin{array}{l}
      B_x=B_0x\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_x)\\
      B_y=B_0y\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_y)\\
      B_z=B_0z\cdot cos(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t+\phi_z)\\
   \end{array}
   \right.`$
   
Si je connais l'un des champs ($`\overrightarrow{E}`$ ou $`\overrightarrow{B}`$), l'autre est
totalement déterminé par les équations de Maxwell, ou plus simplement par la propriété de 
l'OPPM, $`\overrightarrow{k}\land\overrightarrow{E}=\omega\;\overrightarrow{E}`$, donc l'OPPM
est spécifiée par la seule donnée de son champ électrique.

Si l'OPPM se propage en direction et sens de l'un des vecteurs de base, par exemple le vecteur
$`\overrightarrow{e_z}`$, alors l'écriture de l'OPPM se simplifie :

$`\hspace{0.6cm}\overrightarrow{E}=\left|
   \begin{array}{l}
      E_x=E_0x\cdot cos(kz - \omega\,t + \phi_x)\\
      E_y=E_0y\cdot cos(kz - \omega\,t + \phi_y)\\
      E_z=0\\
   \end{array}
   \right.`$

Si de plus l'OPPM est polarisée rectilignement selon l'un des deux vecteurs de base restants,
par exemple le vecteur $`\overrightarrow{e_x}`$, alors l'écriture de l'OPPM se simplifie encore :

$`\hspace{0.6cm}\overrightarrow{E}=\left|
   \begin{array}{l}
      E_x=E_0\cdot cos(kz - \omega\,t + \phi_x)\\
      E_y=0\\
      E_z=0\\
   \end{array}
   \right.`$
 
 soit encore :
 
 $`\overrightarrow{E}(\overrightarrow{r},t)=E_0\cdot cos(kz - \omega\,t + \phi_x)\;\overrightarrow{e_x}`$
   
Au déphasage  $`\phi_x`$ correspond une durée $`\Delta t`$ telle que $`\phi_x=\omega\,\Delta t`$. Il suffit de retarder l'origine des temps cette valeur $`\Delta t`$ pour annuler cette valeur de déphasage. Cette valeur de déphasage, lorsque nous considérons qu'une seule OPPM qui n'a qu'une seule composante non nulle, est souvent omise, et nous écrivons souvent l'OPPM polarisée rectilignement sous la seule forme :

$`\overrightarrow{E}(\overrightarrow{r},t)=E_0\cdot cos(kz - \omega\,t )\;\overrightarrow{e_x}`$

<!--
$`\overrightarrow{E}(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega\,t)\quad`$
et $`\quad\overrightarrow{B}(\pm\,\overrightarrow{k}\cdot\overrightarrow{r}\pm \omega \,t))`$

Si je choisis un repère cartésien $`(O, \overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})`$
dont $`\overrightarrow{e_z}=\overrightarrow{u}`$, alors l'écriture se simplifie :

$`\overrightarrow{E}(\overrightarrow{r},t)=\overrightarrow{E}(\pm k z \pm \omega t)\quad`$
 et $`\quad\overrightarrow{B}(\overrightarrow{r},t)=\overrightarrow{B}(\pm k z  \pm \omega t)`$

* $`\overrightarrow{E}(kz\,-\,ct)`$ ou $`\overrightarrow{E}(-\,kz\,+\,ct)`$ indique une onde plane 
progressive monochromatique qui se déplace vers les $`z`$ croissants.

* $`\overrightarrow{E}(+\,kz\,+\,ct)`$ ou $`\overrightarrow{E}(-\,kz\,-\,ct)`$ indique une onde plane 
progressive monochromatique qui se déplace vers les $`z`$ décroissants.-->


##### Ondes planes monochromatiques stationnaire

A la découverte de l'onde EM stationnaire :

Etude que nous avons réalisée en travail à distance.

Ecrire le champ électrique d'une OPPM EM $`\overrightarrow{E_1}`$, polarisée rectilignement selon Oy, d'amplitude réelle $`E_0`$, de pulsation $`\omega`$, se propageant en direction de Ox selon les x croissants, en notation réelle et en notation complexe.

Ecrire le champ électrique d'une OPPM EM $`\overrightarrow{E_2}`$, polarisée rectilignement selon Oy, d'amplitude réelle $`E_0`$, de pulsation $`\omega`$, se propageant en direction de Ox selon les x décroissants, en notation réelle et en notation complexe.



1.  Calculer le champ électrique résultant 
$`\overrightarrow{E_{tot}}=\overrightarrow{E_1}+\overrightarrow{E_2}`$
(faire ce calcul en notation réelle, puis en notation complexe)


2.  L'onde résultante est-elle une OPPM? 
Caractériser cette onde résultante.


3.  Comment pouvez-vous calculer le champ magnétique de cette onde résultante ?















