---
title: Logique
published: true
routable: true
visible: false
---

### Collecte d'éléments de mathématiques, niveau 3.

#### Logique et théorie mathématique.

*[Math_Logic-10]  Aserción / Assertion / ...*

[ES]<br>
[FR] La mathématique utilise des **assertions** qui peuvent être *vraies ou fausses*.<br>
[EN] 

[ES] **aserción** = *afirmación, frase, oración, proposición*. <br>
[FR] **assertion** = *phrase, énoncé, proposition*. <br>
[EN] 

[ES] La lógica matemática representa las aserciones mediante letras.<br>
[FR] En logique mathématiques, les assertions sont représentées par des lettres majuscules.<br>
[EN] 

**valor de verdad** / **valeur de vérité** / ...

[ES] <br>
[FR] Une proposition $`P`$ peut prendre 2 valeurs de vérité possibles : vrai, ou faux.<br>
[EN] 

[ES] <br>
[FR] La valeur de vérité d'une proposition $`P`$ s'écrit $`v(P)`$.
[EN] 

[ES] 
* el valor **verdadero** está representado por la letra *V* o el número *1*.
* el valor **falso** está representado por la letra *F* o el número *0*.
[FR] Notations :
* la valeur **vrai** se représente par la lettre *V* ou le nombre *1*.
* la valeur **faux** se représente par la lettre *F* ou le nombre *0*.
[EN] 

-----------------------

*[Math_logic-15] Proposiciones indecidibles? Propositions indécidables?*

[ES] ¿Que decir?<br>
[FR] Que dire ?<br>
[EN] What to say?<br>

[ES] La paradoja del mentiroso que dice "En esta oración presente, estoy mintiendo.".<br>
[FR] Le paradoxe du menteur qui dit "Dans cette phrase présente, je mens.".<br>
[EN] 

------------------------

*[Math_Logic-20]  Lógica / logique / logic*

[ES]<br>
[FR] La logique étudie les rapports entre les propositions et leurs valeurs, sans se soucier de leurs sens.<br>
[EN] 

[ES]<br>
[FR] De même que l'algèbre les propriétés des opérations et équations sans se soucier des valeurs des nombres en jeu.<br>
exemple : l'algèbre établit que $`a\times (b+c) = a\times b + a\times c`$<br>
[EN] 


[ES] La lógica matemática representa las proposiciones mediante letras.<br>
[FR] En logique mathématiques, les assertions sont représentées par des lettres majuscules.<br>
[EN] 

-------------------------

*[Math_Logic-30]  axiomas y teoremas / axiomes et théorèmes / axioms and theorems*

[ES] <br>
[FR] Un **axiome** est une *assertion* qui est posée et considérée comme *vraie, sans démonstration*.<br>
Un **théorème** est une *assertion* dont *la valeur vraie est démontrée* par un raisonnement logique à partir d'autres assertions (axiomes ou théorèmes).
[EN]

--------------------------

*[Math_Logic-40] théorie mathématique*

[ES] <br>
[FR] 
[EN]

--------------------------

*[Math_Logic-50]*<br>
[ES]    <br>
[FR] *Théorie contradictoire ou cohérente* <br>
[EN] 

[ES]   <br>
[FR] Une théorie est **contradictoire** si *une assertion est à la fois vraie et fausse* car dans ce cas *toutes les assertions sont à la fois vraies et fausses*.<br>
[EN] 

[ES]   <br>
[FR] Une théorie est **cohérente** si elle n'est *pas contradictoire*.<br>
[EN] 

--------------------------------------

*[Math_Logic-60]  Tabla de verdad / table de vérité / ...*

[FR] Donne la valeur de vérité d'une assertions composée<br>

------------------------------

##### Opération sur les assertions :

*[Math_Logic-70]  Négation*

[ES]     <br>
[FR] Soit $`P`$ une assertion.<br>
La **négation de $`P`$** est une nouvelle assertion qui s'écrit **$`\mathbf{\text{NON}(P)}`$** ou **$`\mathbf{\neg P}`$**, et dont la valeur est *définie par* :
* *$`\neg P`$ est vraie si $`P`$ est fausse*.
* *$`\neg P`$ est fausse si $`P`$ est vraie*.<br>
[EN]

| $`\quad P\quad`$   |  $`\quad\neg P\quad`$ |
| :-------------------: | :-------------------: |
| V | F |
| F | V |

ou

| $`\quad P\quad`$   |  $`\quad\neg P\quad`$ |
| :-------------------: | :-------------------: |
| 1 | 0 |
| 0 | 1 |

!!! *Ejemplos / exemples / examples* :
!!!  * $`\neg (3\lt 5)`$ est une assertion fausse.
!!!  * $`\neg (3 = 5)`$ est une assertion vraie.

-----------------------------------------

*[Math_Logic-80]  	Equivalencia / équivalence*

Símbolo / symbole / symbol : **$`\mathbf{\Longleftrightarrow}`$**

[ES]  <br>
[FR] Soient $`P`$ et $`Q`$ deux assertions.

L'assertion **$`\mathbf{P \Longleftrightarrow Q}`$** :
  * se lit *$`P`$ est équivalent à $`Q`$*.
  * est **vraie si et seulement si** les valeurs de vérité de $`P`$ et $`Q`$ sont égales : **$`\mathbf{v(P)=v(Q)}`$**,<br>
donc si les assertions $`P`$ et $`Q`$ sont vraies ou fausses en même temps.

Les assertions **$`P \Longleftrightarrow Q`$** et **$`Q \Longleftrightarrow P`$** ont la *même définition*,<br>
sont *deux écritures différentes de la même* **équivalence de $`P`$ et $`Q`$**.<br>
[EN]

[ES] <br>
[FR] Table de vérité de l'équivalence :<br>
[EN] 

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longleftrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | V |
| V | F | F |
| F | V | F |
| F | F | V |

ou

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longleftrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 1 |
| 1 | 0 | 0 |
| 0 | 1 | 0 |
| 0 | 0 | 1 |

!!! *Ejemplos / exemples / examples* :<br>
!!! [ES] <br>
!!! [FR] "Jean est le fils de Jacques" $`\quad \Longleftrightarrow \quad`$ "Jacques est le père de Jean".<br>
!!! [EN]

-----------------------

*[Math_Logic-90]  ... / conjonction / ..*

[ES] Símbolo : <br>
[FR] Symbole : **ET** ou **$`\mathbf{\land}`$** <br>
[EN] Symbol :

[ES]  <br>
[FR] Soient $`P`$ et $`Q`$ deux assertions.<br>
[EN]

L'assertion **$`\mathbf{P \land Q}`$** :
  * se lit *conjonction de $`P`$ et de $`Q`$*.
  * est **vraie si et seulement si** les assertions *$`P`$ et $`Q`$ sont vraies toutes les deux*,<br>
donc si et seulement si **$`v(P)=v(Q)=1`$**.
  * donc est fausse dès que l'une au moins des deux assertions $`P`$ et $`Q`$ est fausse.

[ES] <br>
[FR] Table de vérité de la conjonction :<br>
[EN] 

 $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \land Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | V |
| V | F | F |
| F | V | F |
| F | F | F |

ou

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \land Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 1 |
| 1 | 0 | 0 |
| 0 | 1 | 0 |
| 0 | 0 | 0 |

-----------------------

*[Math_Logic-100]  ... / disjonction / ..*

[ES] Símbolo : <br>
[FR] Symbole : **OU** ou **$`\mathbf{\lor}`$** <br>
[EN] Symbol :

[ES]  <br>
[FR] Soient $`P`$ et $`Q`$ deux assertions.<br>
[EN]

L'assertion **$`\mathbf{P \lor Q}`$** :
  * se lit *disjonction de $`P`$ et de $`Q`$*.
  * est **fausse si et seulement si** les assertions *$`P`$ et $`Q`$ sont fausses toutes les deux*,<br>
donc $`v(P \lor Q)=1`$ si et seulement si **$`v(P)=v(Q)=0`$**.
  * donc $`P \lor Q)`$ est vraie dès que l'une au moins des deux assertions $`P`$ et $`Q`$ est vraie.

[ES] <br>
[FR] Table de vérité de la disjonction :<br>
[EN] 

 $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \lor Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | V |
| V | F | V |
| F | V | V |
| F | F | F |

ou

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \lor Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 1 |
| 1 | 0 | 1 |
| 0 | 1 | 1 |
| 0 | 0 | 0 |

-----------------------

*[Math_Logic-101]  ... / disjonction / ..*

[ES] ?

!!!! [FR] *Attention :*
!!!!
!!!! *Dans la langue française*, le "ou" dans l'expression *P ou Q* est un *"ou" exclusif*. Cela signifie que si la proposition *(P ou Q)* est vraie*, alors soit *P est vraie à l'exclusion de Q*, soit *Q est vraie à l'exclusion de P,* mais donc P et Q ne peuvent être vraies ensemble.
!!!!
!!!! _Par exemple, si dans un restaurant un menu indique que vous avez droit au "fromage ou déssert", cela signifie que vous avez le droit de commander soit le fromage, soit le déssert, mais pas les deux en même temps._
!!!!
!!!! *En mathématique*, le *OU* est *inclusif*. Ce la signifie que la proposition $`(P OU Q)`$ est vraie, si $`P`$ est vraie, si $`Q`$ est vraie, et si $`P`$ et $`Q`$ sont toutes les deux vraies.

[EN] ?

-----------------------

*[Math_Logic-110]  ... / implication / ..*

[ES] Símbolo : <br>
[FR] Symbole : **$`\mathbf{\Longrightarrow}`$** <br>
[EN] Symbol :


[ES]  <br>
[FR] Soient $`P`$ et $`Q`$ deux assertions.
[EN] 

L'assertion **$`\mathbf{P \Longrightarrow Q}`$** :
  * se lit *$`P`$ implique $`Q`$*.
  * est **fausse si et seulement si** la première assertion *$`P`$ est vraie* et la suivante *$`Q`$ est fausse*,<br>
donc si et seulement si **$`v(P)=1`$ et $`v(Q)=0`$**.

[ES] <br>
[FR] Table de vérité de l'implication :<br>
[EN] 

 $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | V |
| V | F | F |
| F | V | V |
| F | F | V |

ou

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 1 |
| 1 | 0 | 0 |
| 0 | 1 | 1 |
| 0 | 0 | 1 |

-----------------------

*[Math_Logic-120]  ... / incompatibilité / ..*

[ES] Símbolo : <br>
[FR] Symbole : **$`|`$** <br>
[EN] Symbol :


[ES]  <br>
[FR] Soient $`P`$ et $`Q`$ deux assertions.
[EN] 

L'assertion **$`\mathbf{P | Q}`$** :
  * se lit *$`P`$ est incompatible avec $`Q`$*.
  * est **fausse si et seulement si** Les assertions *$`P`$ et $`Q`$ sont vraies ensemble*,<br>
donc $`v(P | Q)=0`$ si et seulement si **$`v(P)=1`$ et .$`v(Q)=1`$**

Les assertions **$`P | Q`$** et **$`Q | P`$** ont la *même définition*,<br>
sont *deux écritures différentes de la même* **incompatibilité de $`P`$ et $`Q`$**.<br>

[ES] <br>
[FR] Table de vérité de l'implication :<br>
[EN] 

 $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | F |
| V | F | V |
| F | V | V |
| F | F | V |

ou

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 0 |
| 1 | 0 | 1 |
| 0 | 1 | 1 |
| 0 | 0 | 1 |

-------------------------

####

*[Math_Logic-130.1]  ... / Lois de Morgan / ..*

[ES]  <br>
[FR] Théorème (Lois de Morgan) :<br>
Pour deux assertions $`P`$ et $`Q`$, les équivalences suivantes sont vraies :

$`\mathbf{\text{NON}(\,P\;ET\;Q\,) \quad \Longleftrightarrow \quad \left(\,\text{NON}(\,P\,)\;OU\;\text{NON}(\,Q\,)\right)}`$<br>
$`\mathbf{\text{NON}(\,P \;OU\; Q\,) \quad \Longleftrightarrow \quad \left(\,\text{NON}(\,P\,) \;ET 
\;\text{NON}(\,Q\,)\right)}`$

[EN]

[ES][FR][EN] :<br>
$`\mathbf{\neg(\,P \land Q\,) \quad \Longleftrightarrow \quad \neg P  \lor \neg Q}`$<br>
$`\mathbf{\neg(\,P \lor Q\,) \quad \Longleftrightarrow \quad \neg P \land \neg Q}`$

-----------------

*[Math_Logic-130.2]  ... / Démonstation : Morgan*

[ES]

[FR] Avant d'écrire la table de vérité de ces propositions, allégeons le tableau en notant :<br>
$`A= \text{NON}(\,P\;\;ET\;\;Q\,) \quad`$  ,
$`\quad \text{C}=\large ( \normalsize \,\text{NON}(\,P\,)\;\;OU\;\;\text{NON}(\,Q\,)\,\large ) \normalsize`$<br>
$`B= \text{NON}(\,P\;\;OU\;\;Q\,) \quad`$ , 
$`\quad \text{C}=\large ( \normalsize \,\,\text{NON}(\,P\,)\;\;ET\;\;\text{NON}(\,Q\,)\,\large ) \normalsize`$<br>

et la table de vérité s'écrit :

| $`\;P\;`$ | $`\;Q\;`$ | $`\;A\;`$ | $`\;B\;`$

$`A= \text{NON}(\,P\;\;ET\;\;Q\,) \quad`$ , $\quad \text{C}=(\,\text{NON}(\,P\,)\;\;OU\;\;\text{NON}(\,Q\,)\,)`$<br>
$`B= \text{NON}(\,P\;\;OU\;\;Q\,) \quad`$ , $\quad \text{C}=(\,\text{NON}(\,P\,)\;\;ET\;\;\text{NON}(\,Q\,)\,)`$

[EN] 








