---
title: Les Ondes
published: true
routable: true
visible: false
lessons:
    -   
      slug: classical-corpuscules-and-waves
      name: PARALLELE : Mécanique de Newton, corpuscules et ondes
      order: 3
    -   
      slug: from-classical-world-to-wave-corpuscular-duality
      name: PARALLELE : from corpuscules and waves to wave-corpuscular duality
      order: 2
    -   
      slug: waves-3
      name: LINÉAIRE : Ondes
      order: 2
---
$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Contreforts :&nbsp; _physiciens_

---------------------------

*Physique classique :*

#### L'onde et la description de sa propagation

<br>


RÉSUMÉ
: ---   

  *Le concept d'onde, et ses propriétés*    
  
  __Onde mécanique__ : perturbation d'un milieu matériel, caractérisé par une grandeur <!--ou une propriété--> physique scalaire $`\eta`$ ou vectorielle
  $`\vec{\eta}`$, qui s'étend de proche en proche sur des distances souvent bien plus grandes
  que l'amplitude de déplacement $`\delta`$ de chaque particule du milieu autour de sa position d'équilibre.
  * Onde __transversale__ : déplacement local du milieu perturbé est perpendiculaire à la direction de propagation.
  * Onde __longitudinale__ : déplacement local du milieu perturbé est parallèle à la direction de propagation.
  * Onde __progressive__ : la perturbation se propage sur de grandes distances.
  * Onde __stationnaire__ : la perturbation ne se propage pas.<br>
  Les ondes stationnaires résultent de la superposition d'ondes progressives.

  __Représentation mathématique__ dans un référentiel $`\mathscr{R}(O,x,y,z,t)`$ : une fonction $`U`$ définie sur tout l'espace et obligatoirement dépendante du temps,
  scalaire $`U(vec{r},t)`$ ou vectorielle $`\overrightarrow{U}(vec{r},t)`$

  __Propriétés des ondes mécaniques__
  * __Non localisée__ : fonction spatialement étendue.
  * __Propagation d'énergie__. 
  * __Pas de transport de matière__ au delà de $`\delta`$.
  * Dans un milieu matériel,
     * le __phénomène de diffraction__ est observé lorsqu'une onde mécanique rencontre un obstacle.
     * le __phénomène d'interférence__ peut être observé en présence de deux ondes.
  * À l'interface entre deux milieux de caractéristiques différentes,
     * le __phénomène de réflexion__, totale ou partielle, est observé lorsque l'onde atteint l'interface.
     * le __phénomène de réfraction__ est observé lorsque l'onde traverse l'interface.

  Le concept d'__onde__ s'élargie à tout phénomène conduisant aux propriétés des ondes mécaniques.
  * __Onde électromagnétique__ : Propagation du champ électromagnétique dans le vide ou dans la matière.
  * __Onde gravitationnelle__ : Propagation d'une perturbation dans la géométrie de l'espace-temps 
                de la relativité générale d'Einstein. Ne se traite pas dans le cadre de la physique classique.

  __Célérité__ $`v`$ : vitesse de propagation de l'onde progressive.<br>
  $`\mathscr{v} = \dfrac{\Delta \mathscr{l}}{\Delta t}`$, avec $`\Delta \mathscr{l}`$ distance parcourue par l'onde pendant la durée  $`\Delta t`$.

  -----------------------

  *L'onde périodique*   
  __Onde périodique__ : en tout point de l'espace de vecteur position $`\vec{r}`$ et à tout instant $`t`$, la perturbation $`U(\vec{r},t)`$ du milieu se répète à intervalles de temps réguliers :   
  $`U(\vec{r},t) = U(\vec{r}\,,\; t+n\times T)`$, avec $`n\in\mathbb{Z}`$ et $`T`$ une durée.    

  * __Propriété fondamentale__ de l'onde périodique : sa propriété temporelle décrite par les grandeurs physiques équivalentes :
      * La __période temporelle__ $`T`$ de l'onde (d'appellation commune : "période"), <br>
                   homogène à un temps : unité S.I., la "seconde" (notation $`s`$)..
      * La __fréquence temporelle__ $`\nu`$ $`\; = 1\,/\,T`$ : inverse de la période temporelle, <br> 
                   homogène à l'inverse d'un temps : unité S.I., le "hertz" (notation $`s^{-1}\equiv Hz`$) 

  * __Propriétés du milieu__ : On se limitera à la célérité $`\mathscr{v}`$
     * milieu __linéaire__ (noté L) : en présence de plusieurs ondes, la perturbation de milieu est égale à
                           la somme des perturbations induites par chaque onde en absence des autres
                           (principe de superposition).
     * milieu __homogène__ (noté H) : $`\mathscr{v}`$  ne dépend pas de la position dans le milieu.
     * milieu __isotrope__ (noté I) : $`\mathscr{v}`$  ne dépend pas de la direction de propagation de l'onde.  
     * milieu __dispersif__ : la célérité dépend de la fréquence temporelle de l'onde :
     $`\mathscr{v} = \mathscr{v}(\nu) = \mathscr{v}(T)`$
     * milieu __non dispersif__ : la célérité de dépend pas de la fréquence temporelle de l'onde.
     
  * __Propriété de l'onde dans un milieu LHI__  : sa propriété spatiale décrite par les grandeurs physiques équivalentes :
      * La période spatiale appelée __longueur d'onde__ $`\lambda`$, <br>
                   homogène à une longueur : unité S.I., le "mètre" (notation $`m`$), ou ses unités multiples
                   (kilomètre "$`km`$", ...) ou sous-multiples (millimètre "$`mm`$", micromètre "$`\mu m`$", 
                    nanomètre "$`nm`$",... )
      * La __fréquence spatiale__ $`1/\lambda`$ : inverse de la longueur d'onde, <br> 
                   d'unité S.I., le $`m^{-1}`$ et ses miultiples et sous-multiples.

    -----------------------
    
    *L'onde sinusoïdale*   
      je galère ...
     Noms communs d'usage :   
     __onde sinusoïdale__ &equiv; __onde harmonique__ (&equiv; __onde monochromatique__ en optique).  
     Ce qu'il faudrait dire pour être précis : Onde monofréquence temporelle.
     
  * en tout point de l'espace de vecteur position $`\vec{r}`$, son profil de variation
      temporelle est de forme sinusoïdale. 
      *  Onde stationnaire sinusoïdale $`U(\vec{r}, t) = U_0(\vec{r})\cdot \sin(\omega t+\varphi)\quad`$,
      
         $`( = U_0\cdot \cos(\omega t - \pi/2 + \varphi)`$)
      *  où de façon plus
 * __Propriété fondamentale__ de l'onde harmonique : sa propriété temporelle décrite par les grandeurs physiques équivalentes :
      * La __période temporelle__ $`T`$ de l'onde (d'appellation commune : "période"), <br>
                   homogène à un temps : unité S.I., la "seconde" (notation $`s`$)..
      * La __fréquence temporelle__ $`\nu`$ $`\; = 1\,/\,T`$ : inverse de la période temporelle, <br> 
                   homogène à l'inverse d'un temps : unité S.I., le "hertz" (notation $`s^{-1}\equiv Hz`$) 
 

<br>

-----------------

Liste des questions et figures à faire... dans le désordre ...


#### Qu'est-ce qu'une onde ?





#### Quelle différence entre une onde longitudinale et une onde transverse ?




#### Quelle différence entre une onde progressive et une onde stationnaire ?

* **Onde progressive**   
  <br>
  **Couplage** entre les *coordonnées d'espace et de temps* de la forme :   
  * Pour une onde scalaire unidimensionnelle :  
    <br>
    **$`\large{U(x,t) = f(\pm x \pm \mathscr{v} t)}`$**

* *Onde stationnaire*   
  <br>
  **Séparation** des *coordonnées d'espace et de temps* dans deux fonctions différentes.
  * Pour une onde scalaire unidimensionnelle :  
    <br>
    *$`\large{U(x,t) = f(x)\times g(t)}`$*



#### Qu'est-ce que la célérité d'une onde ?




----------------------------------

#### Qu'est-ce que l'équation de d'Alembert ?

* Écriture d'une onde scalaire unidimensionnelle dans un système de coordonnées spatiale et temporelle $`(x,t)`$ :   
  <br>
  **$`\large{\dfrac{\partial^2 U(x,t)}{\partial x^2}\,-\,\dfrac{1}{\mathscr{v}}\cdot\dfrac{\partial^2 U(x,t)}{\partial t^2}= 0}`$**

* Pour une onde scalaire tridimensionnelle dans un système de coordonnées cartésiennes et temporelle $`(x,y,z,t)`$ :   
  <br>
  $`\left(\dfrac{\partial^2 U(x,t)}{\partial x^2}\,+\dfrac{\partial^2 U(x,t)}{\partial y^2}\,
   +\dfrac{\partial^2 U(z,t)}{\partial x^2}\right)\,-\,\dfrac{1}{\mathscr{v}}\cdot\dfrac{\partial^2 U(x,t)}{\partial t^2}= 0`$   
  <br>
  ou en écriture vectorielle (indépendante du système de coordonnées choisi) :   
  <br>
  **$`\large{\Delta U(x,t)\,-\,\dfrac{1}{\mathscr{v}}\cdot\dfrac{\partial^2 U(x,t)}{\partial t^2}= 0}`$** 
  


-------------------------------


#### Qu'est-ce qu'une onde périodique ?



##### Quelles sont les grandeurs fondamentales décrivant une onde périodique ?



##### Quelles sont les grandeurs décrivant une onde périodique qui dépendent du milieu de propagation ?


---------------------------


#### Quelle différence entre un milieu dispersif et un milieu non dispersif ?



#### Qu'est-ce que la relation de dispersion d'un milieu ?

------------------------------------------

#### Qu'est-ce qu'une onde progressive sinusoïdale ?



#### Comment décrire mathématiquement une onde progressive sinusoïdale ?


##### L'équivalence des fonctions sinus et cosinus.


##### L'écriture en notation complexe.



##### L'onde progresive sinusoïdale est-elle physiquement réaliste ?



##### Quel est l'intérêt de l'onde sinusoïdale ?



##### Que dit le théorème de Fourier ?



#### Qu'est-ce que le spectre d'une onde ?


------------------------------------------------

#### Quelles sont les phénomènes propres aux ondes ?



* Lorsque plusieurs ondes se propagent dans un même milieu

   * Le phénomène d'interférence
   * Le phénomène de diffraction

* Lorsque l'onde rencontre une interface entre deux milieux différents

   * Le phénomène de réflexion
   * Le phénomène de réfraction
   * 
   
--------------------------------------------

#### Qu'est-ce que le phénomène d'interférence ?


##### Qu'est-ce que deux ondes synchrones ?



##### Qu'est-ce que le principe de superposition ?


##### Comment reconnaître le phénomène d'interférence ?


##### Que signifient "interférences constructives" et "interférence destructives" ?


##### Que représentent les noeuds et les ventres ?


##### Quelle lien entre interférences et ondes stationnaires ?



![waves_interferences_ventres_noeuds](waves_interferences_ventres_noeuds_niv_3a_L1200.gif)

niveau 2


--------------------------------------------

#### Qu'est-ce que le phénomène de diffraction ?



--------------------------------------------

#### Qu'est-ce que le phénomène de réflexion ?





--------------------------------------------

#### Qu'est-ce que le phénomène de réfraction ?


![refraction d'une onde plane sur un dioptre plan](wave-optics-n3-refraction-1_L1000.gif)









<!-------------



#### Quels phénomènes sont caractéristiques d'une onde ?

![waves-sinusoide-lambda-n3_L1200](waves-sinusoide-lambda-n3_L1200.gif)

figure à transférer en niveau 2

...



#### Qu'est-ce que le phénomène de réfraction ?


#### Qu'est-ce qu'une onde périodique ?


#### Qu'est-ce que le phénomène d'interférence ?



#### Qu'est-ce qu'une onde stationnaire ?




![waves_interferences_ventres_noeuds](waves_interferences_ventres_noeuds_niv_3a_L1200.gif)

niveau 2


#### Quelles sont les différentes grandeurs physique caractérisant une onde périodique ?

![refraction d'une onde plane sur un dioptre plan](wave-optics-n3-refraction-1_L1000.gif)

niveau 2 reprise au 3?


------------>


