---
title: Géométrie et coordonnées - proposition 2
published: true
routable: true
visible: false
lessons:
   - slug: geometry-coordinates-prop2-123-panorama-overview
     order: 1
   - slug: geometry-coordinates-prop2-1-linear
     order: 2
   - slug: geometry-coordinates-prop2-1-parallel
     order: 2
   - slug: travail-symetries-avec-existant-n1
     order: 3
---


!!!! *Attention : COURS EN CONSTRUCTION :*    
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.

<!--MétaDonnée : ... -->

---------------------------------------------

!   
! *LE  TEMPS  ET  L'ESPACE*   
!

Programme proposé (à discuter) pour la partie main :      
1 - J'ai conscience du temps   
1.1 - Ma perception et représentation du temps   
1.1.2 - Je distingue le passé, l'instant présent, et l'avenir   
1.1.3 - J'observe des évènements simultanés ou qui se succèdent dans le temps   
1.1.4 - J'ai conscience de phénomènes cycliques   
1.1.5 - Je mesure des durées entre deux évènements   
1.1.6 - Je date des évènements.   
1.2 - Nos perceptions communes du temps   
1.2.1 - Mon temps propre   
1.2.2 - Et toi, quelle est ta perception du temps?   
1.2.3 - De quoi pouvons-nous convenir ensemble?   
1.2.4 - Ce que révèlent les mesures temporelles les plus précises   
2 - Je perçois l'espace   
2.1 - Ma perception et représentation de l'espace   
2.1.1 - J'observe des corps plus ou moins éloignés   
2.1.2 - Je mesure des distance et des longueurs  
2.1.3 - J'ai conscience d'un espace a 3 dimensions   
2.1.4 - Une surface a 2 dimensions   
2.1.5 - Une ligne a 1 dimension   
2.1.6 - Une point a 0 dimension   
2.2 - Nos perceptions et représentations communes de l'espace  
2.2.1 - Et toi, quelle est ta perception de l'espace?    
2.2.2 - De quoi pouvons-nous convenir ensemble?   
3 - Au-delà de ce que révèlent nos sens, vers un espace-temps   
à transcrire et adapter sous forme de questions (avec liberté) ici dans cette partie synthèse.

<!-- partie synthèse du chapitre "Perception et représentation du temps"
Que perçois-je du temps?
Qu'est-ce qu'un phénomène cyclique?
Comment puis-je mesurer la durée entre deux évènements ?
Comment puis-je repérer un évènements dans le temps?
De quoi pouvons nous convenir ensemble sur le temps?
Quelles sont les unités de mesure des durées?
Quelle différence entre durée et date ?
<!-- partie synthèse du chapitre "Perception et représentation de l'espace"
Que perçois-je de l'espace?
Comment situer un objet par rapport à moi?
Qu'est-ce que la distance?
Qu'est-ce que la direction?
Que signifie "l'espace possède 3 dimensions"?
De quoi pouvons nous convenir ensemble sur l'espace?
Quelles sont les unités de mesure des longueurs?
Comment localiser un objet de façon utile pour tous?

Il faudra préciser des éléments de vocabulaire.
Idée :
Localiser $`\equiv`$ situer $`\equiv`$ positionner (ou trouver la position) $`\equiv`$ repérer
Dans le langage courant :   
situer < trouver la position < repérer $`\le`$ localiser
(c'est difficile, chaque mots a toujours différents usages, différentes définitions...)

(là, on verra que pour trouver une réponse complète à cette question, on aura
besoin des propriétés de l'espace : donc de sa géométrie)

#### Comment trouver la distance entre deux objets connaissant leurs positions?

(c'est la suite, donc idem, on aura besoin de la géométrie de notre espace sensible, donc euclidienne)
====================================================-->


#### Que perçois-je du temps?

* Je vis dans l'**instant présent**.
* J'ai conscience d'un **temps fléché**, qui s'écoule *du passé vers le futur*.

![](mechanics-time-now_v2_fr.gif)   
_Ma perception du temps_

#### Comment mesurer l'intervalle de temps entre deux évènements ?

* **intervalle de temps** = **durée**.

* Je perçois des **évènements cycliques** .   
_(rythme des *saisons*, *cycle de la lune*, alernance *jour-nuit*, *mouvement du balancier* d'un pendule,_ 
_*incrémentation des secondes* sur un affichage digital du temps...)._

(figure à créer, gif avec plusieurs exemples de cycle)

* Les *cycles* des différents évènements observés sont **cohérents entre eux**.
(...)

* $`\Longrightarrow`$ pour **mesurer la durée entre deux évènements**, je peux
  *choisir un évènement cyclique comme référence*,   
  et définir comme **unité de temps** la *durée de son cycle*.

* L'**intervalle de temps** entre deux évènements, exprimée *dans l'unité de mesure choisie*, est 
le *nombre de cycle de référence compté entre ces deux évènements*.

(figure à créer: indiquant la façon mesurer des durée et de dater des évènements, avec comme légende
"Mon temps propre").


#### Comment repérer un évènements dans le temps?

* **repérer dans le temps** = **dater**

* Je veux *dater un évènement $`T`$* dans le temps.

* Je peux *choisir un évènement de référence $`T_O`$*,    
   puis *compter le nombre de cycle de référence* entre $`T_O`$ et $`T`$.  

* La **date** de l'évènement $`T`$, exprimée *dans l'unité de temps choisie*, est le
*nombre de cycle de référence entre $`T_O`$ et $`T`$*.


#### Quelle est l'unité de temps dans le système international de mesure?

la seconde, à développer.

Les autres unités usuelles (peut-être seulement dans la partie principale)



#### Que perçois-je de l'espace?

Je perçois dans l'espace des corps immobiles ou en mouvement.


##### Des objets et des êtres plus ou moins loin

À faire 
Parler de la notion de distance et de longueur.   
Figure à faire : par exemple une photo de 3 objets plus ou moins proches, avec focalisations successivement sur les 3 objets.

##### Comment mesurer l'intervalle d'espace entre deux objets immobiles ?

À faire 
Idée :   
\- distance entre 2 objets, ou entre les deux extrémités d'un même objet.   
\- mesurer c'est comparer et compter.    
\- nécessité d'un étalon de longueur, qui définit une unité de mesure.    
\- etc...    


##### Quelle est l'unité de longueur dans le système international de mesure?

À faire  
\- le mètre   
\- ses sous et ses sur-multiples   


##### Que signifie "l'espace a 3 dimensions" ?

![](time-space-euclidian-geometry-3D-space_serieA_L740_v3.gif)   
_Ma perception de l'espace_

Sur la figure, je suis localisé dans l'espace, et mon regard pointe l'horizon situé devant moi.

* *Je peux me déplacer* :
   * en **avant ou** en **arrière**.
   * à **gauche ou** à **droite**.
   * en **haut ou** en **bas**   
   _(me lever ou m'accroupir, ou sur un escalier ou avec un avion)_

* Et **ces déplacements** peuvent être simultanés, ils **sont indépendants**.   
  _Par exemple :_
   * _je vais me déplacer en avant vers la gauche._
   * _un avion gagne de la hauteur en tournant vers la droite._
   
De la même façon, je peux dire :

> Figure à faire, pour rompre la longueur du texte. Exemple : sur une scène où l'on voit
> un objet, indiquer 3 flèches successives, orientées devant-derrière, gauche-droite, haut-bas,
> qui indique un chemin possible  pour rejopindre l'objet.

* Un *objet extérieur se situe* :
   * **devant ou derrière** moi.
   * à **gauche ou** à **droite**.
   * plus **haut ou** plus **bas**.
   
* Et *localiser* cette objet nécessite de *préciser sa distance dans ces 3 directions*.   
  _Par exemple, sur la figure le sommet de l'arbre le plus proche est situé devant, sur la gauche et plus haut._

J'ai *besoin de définir* **trois directions indépendantes**
   * pour *préciser un déplacement*.
   * pour *localiser* quelque-chose.   
   
**$`\Longrightarrow`$ L'espace possède trois dimensions (3D)**.   
<br>*Trois dimensions* = *trois degrés de liberté*.


##### Comment situer des objets par rapport à moi ?

À faire  


##### Comment situer des objets par rapport à un repère fixe ?

À faire  


#### Que pouvons nous convenir ensemble sur le temps et l'espace ?

![](clock-time-numbered_L746.gif)

1. **Je** *perçois l'espace à travers le temps*, et j'y observe des corps immobiles et en mouvement.
2. **Tu** *perçois l'espace à travers le temps*, et tu y observes des corps immobiles et en mouvement.
3. **Tous**, *nous percevons tous l'espace à travers le temps*, et nous y observons des corps 
immobiles et en mouvement.

**$`\quad\Longrightarrow`$ Que pouvons nous convenir ensemble ?**

Dans la **vie quotidienne** :   

* Nous sommes *tous confrontés aux mêmes cycles*.   
_(rythme des *saisons*, *cycle de la lune*, alernance *jour-nuit*, *mouvement du balancier* d'un pendule,_ 
_*incrémentation des secondes* sur un affichage digital du temps...)._

* Nos *montres et horloges indiquent la même heure*, mesures les mêmes durées.

* Lors de nos échanges, nous remarquons que : 
   * *nous mesurons les mêmes durées* entre deux évènements.
   * *deux évènements simultanés pour moi sont simultanés pour tous*.

**$`\quad\Longrightarrow`$ Nous convenons d'un temps universel**   
<br> *universel* = *partagé, commun à tous*
   

* $`\quad\Longrightarrow`$ nous pouvons définir en commun des unités de mesures, nous accorder sur des dates et des durées.    
  
> à continuer, sur l'espace, et l'indépendance entre l'espace et le temps.


!   
! *LA  GEOMETRIE  DE  L'ESPACE*   
!

Programme proposé (à discuter) pour la partie main :   
1 - Sègment de droites, droites et demi-droites   
1.1 - Le sègment de droite     
1.2 - Du sègment de droite et à la droite     
1.3 - Droites séquentes et droites parallèles     
2 - Le plan   
3 - La sphère   
4 - Le cercle   
4.1 - Le cercle   
4.2 - l'arc de cercle   
5 - Les angles    
5.1 - Comment définir un angle    
5.2 - comment quantifier un angle    
5.3 - Les angles remarquables     
5.3.1 - L'angle complet : 360°      
5.3.2 - L'angle plat : 180°      
5.3.3 - L'angle droit : 90°      
5.3.4 - L'angle de 45°      
5.3.5 - L'angle de 60°   
5.3.6 - L'angle de 30°   
5.3.7 - Réaliser un angle de valeur donnée.   
à transcrire et adapter sous forme de questions (avec liberté) ici dans cette partie synthèse.



#### Qu'est-ce qu'un angle ?

<!-------------------
* Dans un plan, deux droites non parallèles se coupent en un point  $`O`$.
* Ces deux droites non parallèles définissent quatre demi-droites qui partagent la même extrémité $`O`$.
-------------------->

* **Dans un plan, deux demi-droites partageant une même extrémité** séparent le plan en *deux parties disjointes, et complémentaires* : ensemble, elle recomposent le plan.

* Intuitivement, ces deux demi-droites nous *apparaissent plus ou moins non parallèles*.
* L'**angle** *quantifie cet écart au parallélisme*.

#### Comment se mesure un angle quelconque ?

* *Dans la vie de tous les jours*, un angle **se mesure en degré d'arc**, de **notation** " **°** ".
* *Toutes les directions d'un plan*, observées depuis un points du plan, couvre un angle de **360°**.
* Le *cercle complet* couvre **360°**.

* *A l'échelle d'une feuille de papier*, avec une précision de mesure de l'ordre du degré : un **rapporteur**.

![](protrator-measurement-angle-FR_L600.gif)

* *A l'échelle d'une feuille de papier et jusqu'à l'horizon*, pour une mesure plus présice : un **goniomètre**.

<!--------------------
#### Combien puis-je discerner de valeurs d'angle à l'oeil nu?

à faire, idées :   
\- une douzaine
-------------------->

#### Qu'est-ce qu'un angle remarquable ?

* C'est un *angle qui* **peut se tracer sans effectuer de mesure** de longueur (à l'aide d'une règle ou d'un mètre) ou d'angle (à l'aide d'un rapporteur ou d'un goniomètre).

* Sa construction **nécessite seulement un élément de longueur fixe** :
   * écartement entre la pointe et la mine d'un compas.
   * extrémités d'une ficelle ou d'une corde tendues.

##### Que représentent les angles de 360° et de 0° ?

* *Deux demi-droites de même extrémité et confondues* **sépare tout plan** qui les contient en **2 parties** :
   * le **plan lui-même** : correspond à l'*angle de 360°*
   * une **partie vide** : correspond à l'*angle de 0°*

![](cake-angle-360_v2_L1200.gif)

* L'angle de *360° divise un disque* en **1 seule part**, qui est donc le **disque complet**.
* Dans un plan, avoir une *vision à 360°* signifie pouvoir voir dans **toutes les directions du plan**.

![](cake-angle-0_v2_L1200.gif)

##### Que représente l'angle de 180° ?

* *Deux demi-droites de même extrémité, parallèles mais non confondues* **sépare tout plan** qui les contient en **2 demi-plans** :
   * À chaque **demi-plan** correspond à l'*angle de 180°*

![](cake-angle-180_v2_L1200.gif)

* L'angle de *180° divise un disque* en **2 demi-disques : 2 parties d'aires égales**.
* Dans un plan, avoir une *vision à 180°* signifie pouvoir voir dans **une moitié de toutes les directions du plan**.

##### Comment diviser un angle quelconque par deux sans effectuer de mesure ?

1. $`\alpha`$ est un angle quelconque de sommet $`O`$.

![](divide-angle-by-2_v2_L1200.gif)

2. Je trace un cercle à partir du sommet de l'angle $`\alpha`$.
3. Ce cercle intercepte les deux demi-droites aux points $`P_1`$ et $`P_2`$.
4. Je trace un cercle de centre $`P_1`$ et de rayon $`R`$ qui entoute $`O`$.
5. Je trace un cercle de même rayon $`R`$ mais de centre $`P_2`$.
6. Ces deux cercles se coupent aux points $`M_1`$ et $`M_2`$,   
$`M_1`$ appartenant à la portion de plan couverte par l'angle $`\alpha`$.
8. Je trace la droite qui contient $`M_1`$ et $`M_2`$.
9. Je trace la demi-droite $`[OM_1)`$
10. Cette demi-droite $`[OM_1)`$ divise l'angle $`\alpha`$ en deux angles égaux, donc de valeurs $`\dfrac{\alpha}{2}`$.


##### Que représente l'angle de 90° ?

![](cake-angle-90_v2_L1200.gif)

* L'angle de *90° divise un disque* en **4 parts d'aires égales**.
  _(exemple : un gâteau en 4 parts égales)_

##### Comment construire un angle de 90° ?

* En divisant l'angle de $`180°`$ par 2.

![](construction-angle-90_L1200.gif)

* Par pliage.

##### Que représente l'angle de 45° ?

![](cake-angle-45_v2_L1200.gif)

* L'angle de *45° divise un disque* en **8 parts d'aires égales**.

##### Comment construire un angle de 45° ?

* En divisant l'angle de $`90°`$ par 2.

![](construction-angle-45_L1200.gif)

* Par pliage.


<!--------------------
##### Quels sont les angles réalisables avec une simple feuille de papier de forme quelconque ? 

> à faire :   
> Par pliage : 360° et 0°, 180° , 90° , 45° , ...   
> figure animés en cours de réalisation.


##### Quels sont les angles réalisables avec un simple élément rigide de longueur quelconque? 

> à faire :   60° , 30° , puis multiples 90°, 120°, 150° , 180° , 210° , ...
---------------------------->


##### Que représente l'angle de 60° ?

![](cake-angle-60_v2_L1200.gif)

* L'angle de *60° divise un disque* en **6 parts d'aires égales**.
  _(exemple : un gâteau en 6 parts égales)_

##### Comment construire un angle de 60° ?

![](construction-angle-60_v2_L900.gif)   
_Attention : comprendre visuellement un figure ne suffit pas._   
_Comprendre un concept nécessite de se le réexpliquer après quelques jours et en absence de toute figure._   
_Acquérir une compétence nécessite de réaliser un projet la mettant en oeuvre après quelques jours et en absence de toute figure._

Pour un défi dans la partie "au-delà" :   
* Tracer deux droites d'un plan, séquantes en un point et séparées par un angle de 60° :
   * sur une feuille de papier avec un compas.
   * sur un tableau, avec une ficelle est une craie ou un feutre.
   * sur un terrain, avec une corde et un pieu.
   * sur le sol, simplement avec vos deux pieds.
   * 


##### Que représente l'angle de 30° ?

![](cake-angle-30_v2_L1200.gif)

* L'angle de *30° divise un disque* en **12 parts d'aires égales**.
  _(exemple : Le cadran d'une montre analogique est partagé en 12 parties égales, chacune indiquant une heure entre 1 et 12, ou 13 et 24 )_

##### Comment construire un angle de 30° ?

* En construisant un angle de $`60°`$ qui est divisé par 2.

![](construction-angle-30_v2_L900.gif)   
_Attention : comprendre visuellement un figure ne suffit pas._   
_Comprendre un concept nécessite de se le réexpliquer après quelques jours et en absence de toute figure._   
_Acquérir une compétence nécessite de réaliser un projet la mettant en oeuvre après quelques jours et en absence de toute figure._

Pour un défi dans la partie "au-delà" :   
* Tracer deux droites d'un plan, séquantes en un point et séparées par un angle de 30° :
   * sur une feuille de papier avec un compas.
   * sur un tableau, avec une ficelle est une craie ou un feutre.
   * sur un terrain, avec une corde et un pieu.
   * sur le sol, simplement avec vos deux pieds.

##### Que représente l'angle de120° ?

![](cake-angle-120_v2_L1200.gif)



!   
!  *SYMÉTRIES ET INVARIANCES EN GÉOMÉTRIE*  
!

Programme proposé (à discuter) pour la partie main, à faire :   
Si ce chapitre est mis avant DES  FIGURES ET DES VOLUMES, partir des symétries et invariances
observées dans la nature. Avantage, les formes et les figures pourraient aussi être introduites
par leurs propriétés de symétries.   
Symétrie par rapport à un point, à une droite, à un plan...   
et peut-être les volumes  platoniciens? Pas grande utilité de fait. Peut-être simplement dans une partie "beyond"?



!   
! *DES  FIGURES  ET  DES  VOLUMES*   
! 

Programme proposé (à discuter) pour la partie main :   
1 - Lignes, surfaces et volumes   
2 - Les figures simples dans un plan :     
2.1 - Les quadrilatères   
2.1.1 - Le quadrilatère   
2.1.2 - Le rectangle et le carré   
2.1.2 - Le parallélogramme et le losange   
2.1.3 - Le trapèze   
2.2 - Les triangles   
2.2.1 - Le triangle   
2.2.2 - Le triangle rectangle   
2.2.3 - Les triangles isocèle et équilatéral (est-ce vraiment utile?)   
2.2.4 - Triangles semblables    
2.2.5 - Tracer un triangle de longueurs de côtés données.   
2.3 - Les polygones   
2.4 - Le cercle   
3 - Les volumes simples dans l'espace :     
3.1 - Le cube et le parallélépipède rectangle   
3.2 - Les prismes (avec pour base différents polygones)    
3.3 - Les pyramides (avec pour base différents polygones)    
3.4 - Le cylindre   
3.5 - La sphère   
à transcrire et adapter sous forme de questions (avec liberté) ici dans cette partie synthèse.   

#### Qu'est-ce un quadrilatère ?

* **Quatres points quelconques** de l'espace *ne s'inscrivent pas dans un plan* en général . 

* **Quatres points dans un même plan** définissent un *quadrilatère*.   
<br>   
![](geometry-euclidian-quadrilateral-360_1_L1200.jpg)

* *Propriété* : **somme des angles = 360°**.   
<br>  
![](geometry-euclidian-quadrilateral-360_6_L1200.jpg)

#### Que sont les quadrilatères particuliers ?

* **Trapèze** : *quadrilatère à deux côtés parallèles*.

* **Parallélogramme** :   
*quadrilatère dont les côtés sont parallèles deux à deux*.   
&nbsp;&nbsp;&nbsp;&nbsp;ou (équivalent)    
*quadrilatère dont les longueurs de côtés opposés sont égales*.    
<br>   
![](geometry-euclidian-quadrilateral-parallelogram_L1200.jpg)

* **Rectangle** : *quadrilatère avec 4 angles droits*   
<br>   
![](geometry-euclidian-quadrilateral-rectangle_L1200.jpg)

* **Carré** : *quadrilatère avec 4 angles droits et de côtés de longueurs égales*   
<br>   
![](geometry-euclidian-quadrilateral-carre_L1200.jpg)

* **Losange** : *quadrilatère dont tous les côtés sont égaux*.   
<br>   
![](geometry-euclidian-quadrilateral-rhombus_L1200.jpg)


#### Comment définir et calculer l'aire d'un rectangle ?

*Il s'agit d'une* **définition**     
car les aires des autres formes se déduisent de l'aire d'un rectangle.

![](aire-rectangle_L1200.jpg)

* L'**aire $`\mathbf{A}`$ d'un rectangle** *de côtés de longueurs $`a`$ et $`b`$* exprimées 
  dans une même unité de mesure _um_ s'écrit : 
<br>   
**$`\mathbf{A=a\times b}`$** _$`\quad um^2`$_

* **$`\Longrightarrow`$** l'**aire A d'un carré** *de côtés de longueur $`a`$* exprimée dans l'unité de mesure _um_ s'écrit :
<br>   
**$`\mathbf{A=a^2}`$** _$`\quad um^2`$_

#### Comment calculer l'aire d'un parallélogramme ?

*Se déduit de l'aire d'un rectangle.*

![](aire-parallelogramme-2_L1200.gif)

* **aire A d'un parallélogramme** *de côté de longueur $`a`$ et de hauteur $`h`$* exprimés 
  dans une même unité de mesure _um_ s'écrit :   
<br>
**$`\mathbf{A=a\times h}`$** _$`\quad m^2`$_


#### Comment calculer l'aire d'un triangle ?

*Se déduit de l'aire d'un rectangle.*

![](aire-triangle_L1200.gif)

* L'**aire A d'un triangle quelconque** *de base de longueur $`a`$ et de hauteur $`h`$* exprimés 
  dans une même unité de mesure _um_ s'écrit :   
<br>   
* **$`\mathbf{A=\dfrac{a\times h}{2}}`$**  _$`\quad m^2`$_

* L'aire A d'un triangle rectangle :
   * défini par la longueur $`a`$ de sa base et sa hauteur $`h`$ exprimés 
     dans une même unité de mesure _um_ s'écrit comme pour le triangle quelconque :   
   $`\mathbf{A=\dfrac{a\times h}{2}}\quad um^2`$_
   * défini par les longueurs $`a`$ et $`b`$ des côtés adjacent et opposé... (définir avant côtés adjacent, opposé, l'hypothénuse).    
   $`\mathbf{A=\dfrac{a\times b}{2}}\quad um^2`$_    
_dans ce cas, on voit que $`b=h`$_



!   
! *GÉOMÉTRIE  ET  RÈGLES  DE  CALCUL*   
!

Programme proposé (à discuter) pour la partie main :   
1 - Triangles semblables et théorème de Thalès    
2 - Carrés, rectangles, triangles rectangles et le théorème de Pythagore   
3 - Carrés, rectangles, et l'égalité $`(a+b)^2=a^2+b^2+2ab`$   
4 - La projection parallèle   
5 - Cercle, projection, et fonctions sinus et cosinus   
6 - Le nombre $`\large{\pi}`$   
à transcrire et adapter sous forme de questions (avec liberté) ici dans cette partie synthèse.   


#### Identité remarquable $`(x+y)^2=x^2+y^2+2xy`$

* Un **carré de côté $`\mathbf{a+b}`$** peut se décomposer en :
  * un *carré de côté $`\mathbf{a}`$*   
  *$`\quad\quad\large + `$*
  * un *carré de côté $`\mathbf{b}`$*   
  *$`\quad\quad\large + `$*
  * *deux rectangles de côtés $`\mathbf{a}`$ et $`\mathbf{b}`$*. 

![](_a-plus-b_2_v2.gif)

* **$`\mathbf{\Longrightarrow}`$ l'aire $`\mathbf{(a+b)^2}`$** du carré de côté $`a+b`$ est égale à :
  * l'*aire $`\mathbf{a^2}`$* du carré de côté $`a`$      
  *$`\quad\quad\large + `$* 
  * l'*aire $`\mathbf{b^2}`$* du carré de côté $`b`$   
  *$`\quad\quad\large + `$*  
  * *l'aire $`\mathbf{2\times ab}`$* des deux rectangles de côtés $`a`$ et $`b`$. 

![](_a-plus-b_2.jpg)



![](geometry-a2plusb2-identity-L1200.gif)

**vue du côté du calcul**    
(affiché ici à la suite, ou un peu mieux construit pour un affichage en mode parallèle?)

Par définition de la fonction puissance 2 : *$`\mathbf{x^2 = x \times x}`$*,

**$`\mathbf{(x+y)^2\;=\; (x+y) \times (x+y)}`$**

Créer une figure animée pour expliquer le passage entre ces 2 égalités,

**$`\mathbf{(x+y)^2= (x\times x) + (x\times y) + (y\times x) + (y\times y)}`$**

L'ordre des termes au sein d'une addition n'importe pas : *$`\mathbf{a+b=b+a}`$* ,

**$`\mathbf{(x+y)^2\;= (x\times x) + (y\times y) + (x\times y) + (y\times x)}`$**

L'ordre des termes au sein d'une multiplication n'importe pas : *$`\mathbf{a\times b=b \times a}`$* ,

donc $`(x\times y) + (y\times x) = (x\times y) +(x\times y) = 2 \times (x\times y)`$

$`\quad = (y\times x) +(y\times x) = 2 \times (y\times x)`$ ,

**$`\mathbf{(x+y)^2= (x\times x) + (x\times x) + 2 \times y\times x}`$**

Simplification d'écriture : *$`\mathbf{x\times y = x\cdot y = xy = yx = y\cdot x = y\times x}`$*,

**$`\mathbf{(x+y)^2=xx+yy+2xy= x^2 + y^2 + 2xy}`$**



#### Qu'est-ce que le théorème de Pythagore ?

##### Est-il important ?

Incorporer la figure chronologie-importance-sciences-&-techniques

##### Comment le démontrer ?

* Il existe de nombreuses démonstrations du théorème de Pythagore

*Une démonstration purement géométrique*

![](pythagore-v2_L1000.gif)

(ce texte sera peut-être à déplacer dans la partie "main", à voir en construisant cette partie "main").

Soient **$`a`$ et $`b`$ deux nombres quelconques**.

1. *Partir d'un* **carré** de longueur **de côté $`a+b`$** :
   * Y *faire apparaître* **deux carrés** :
      * un carré de longueur **de côté $`a`$**.
      * un carré de longueur **de côté $`b`$**.
   * Dans l'espace restant, *faire apparaître* **4 triangles rectangles** semblables :
      * de **côtés adjacent et opposé** de longueurs **$`a`$ et $`b`$**.
      * de longueur d'**hypothénuse** **$`c`$**.

2. *Partir de ce même carré* :
    * *Déplacer les 4 triangles* rectangles précédents, de façon à y *faire apparaitre un* **unique carré** :   
    $`\Longrightarrow`$ la longueur **de côté** de ce carré est égale à **$`c`$**,   
      longueur de l'hypothénuse des 4 triangles.
      

![](geometry-pythagore-2-v2_L1200.jpg)


3. A partir du premier cas, l'**aire $`(a+b)^2`$** du grand carré *est égale à la somme* :
   * de l'**aire $`a^2`$** du premier carré.
   * de l'**aire $`b^2`$** du second carré.
   * et **4 fois l'aire $`ab/2`$** de chaque triangle rectangle.

4. Dans le second cas, l'**aire $`(a+b)^2`$** du grand carré *est égale à la somme* :
   * de l'**aire $`c^2`$** du grand carré.
   * et **4 fois l'aire $`ab/2`$** de chaque triangle rectangle.


![](pythagore-3.gif)
<!--possibilité refaire cette figure encore plus fluide de mouvement,
pour une taille mémoire pas beaucoup plus grande...-->

5. *Par comparaison*, j'obtiens :   
$`\quad a^2+b^2+4\cdot\dfrac{ab}{2}=c^2+4\cdot\dfrac{ab}{2}`$   
*puis en soustrayant $`4\,ab/2`$ de chaque côté* de l'équation   
j'obtiens la *relation fondatrice* du théorème de Pythagore :   
*$`\quad \mathbf{a^2+b^2=c^2}`$*.    
   

##### Comment s'énonce le théorème de Pythagore ?

*Énoncé mathématique*

* **Dans un triangle rectangle**
   * de *côtés adjacent et opposés* de longueurs *$`\mathbf{a}`$ et $`\mathbf{b}`$*,
   * d'*hypothénuse* de longueur *$`\mathbf{c}`$*   
La relation suivante **est toujours vraie** :   
<br>
**$`\quad\large\mathbf{ a^2+b^2=c^2}`$**


*Énoncé avec le langage des mots*

* **"Dans un triangle rectangle, le carré de l'hypothénuse est égal à la somme des carrés des côtés adjacent et opposé."**



#### Théorème de Thalès, et la règle de trois

Figure animée à faire.




!   
!  *SYSTÈMES  DE  COORDONNÉES*   
!

Programme proposé (à discuter) pour la partie main :   
1 - Je repère à l'aide de coordonnées
2 - Je localise sur le globe terrestre
3 - J'utilise une carte routière.
4 - Je situe avec table d'orientation panoramique
5 - Je fais une course d'orientation
5.1 - avec géolocalisation par satellite.
5.2 - avec une carte et une boussole.
5.3 - sans instrument ni carte.
6 - Du globe terretre à une carte du monde.   
à transcrire et adapter sous forme de questions (avec liberté) ici dans cette partie synthèse.   


! *Je localise à la surface de la terre*
!


#### Comment situer ma ville ? un autre lieu ?

<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/earth_find_your_location_ALowB2.mp4" type="video/mp4">
</video>

<!----------------------

[](beautiful-blue-planet.gif)

* Tu repères la forme des continents.
* Tu repères approximativement un lieu en le positionnant entre des points particuliers sur la surface terrestre :<br>
\- la pointe d'un continent.<br>
\- la courbure d'un fleuve.<br>
\- ...<br>

##### Qu'est-ce qu'un repère ?


##### Qu'est-ce que l'axe Sud-Nord ?

* Il passe par les pôles nord et sud géographiques.

* (faire animation ou petite video de 24h de rotation terrestre, avec éclairement solaire, au 21 juin)<br>
Cela montrera que le pôle nord voit toujours le solei,k que le pôle sud reste dans la nuit. Que les durées jours nuits tendent à s'égaliser quand on tend vers l'équateur. Cela fera l'objet d'un défi dans la partie "Beyond" :)

* Dans la partie beyond aussi, montrrer comment on peut repérer les pôles géographiques à partir de la surface terrestre. Nord, étoile polaire à la verticale? et le ciel tourne autour? Le ciel semble tourner autour de la verticale aux pôles.


##### Pourquoi des coordonnées liées à la Terre ?
![](earth-rotation.gif)<br>
_La Terre vue d'un satellite géostationnaire_




Pour essayer video courte

Le niveau 1 sera plus court, on peu mettre de petites vidéos attrayantes.

Il faut faire quelques chapitres, et tester comment cela, passe, 
les remarques d'ado (10-14ans), adultes faiblement scolarisés

Ceci est juste un tout premier jet, il faudra beaucoup tester l'attarctivité là...


#### Une belle planète


#### La Terre tourne sur elle-même autour de son axe sud-nord.

<!---------------------------------------------


La Terre tourne sur elle-même en 24h.
L'axe Sud-Nord est un bon repère.
Le pôle nord et la pôle sudsont des endroits que l'on peut atteindre et repérer.
L'ensemble des lieux à mi distance des deux pôles est l'équateur.

(ce gif est à edécouper et il faut rajouter les références copyright, ....
mais il est presque aussi lourd qu'une vidéo... alors?)

------------------------------------------------

#### La Terre vue d'un satellite géostationnaire

-------------------------------------------------

Pour localiser une ville sur la Terre, il faut un repère fixe par rapport à la Terre.

Et là on repasse à un schéma, ou un schéma animé gif,
pour expliquer latitude, longitude

et les maps internets rajoutent l'altitude

et exemples?

Rendre cela intéressant?
------------------------------------------------->

---------------

! *J'utilise une carte géographique*
!

À faire

----------------------------------------

! *Je situe avec une table d'orientation panoramique*
!


#### Qu'est-ce qu'une table d'orientation ?

Idée : dans quelle direction (et sens) à partir d'un point d'observation ?   
$`\Longrightarrow`$ les 4 points cardinaux : est, sud, ouest, nord,   
et les intermédiaires sud-est, sud-ouest, nord-ouest et nord-est.   
$`dans le champ de vue, tout point de la surface terrestre est localisé dans 8 domaines de direction.   

<!--Idée :---------------------
localiser, c'est comparer et encadrer.
------------------------------->

#### Comment puis-je repérer la direction d'un lieu ?

![](viewpoint-indicator-2_v2_L850.gif)    
(figure modifiable, ou qui peut se changer)
_Fig.  : Le lieu indiqué par la flèche violette est situé en direction du sud-ouest._

Idée : comment préciser mieux la direction ?    
\- passage de 8 à 16 domaines de localisation :
sud , sud-sud-ouest, sud-ouest, ouest-sud-ouest, ouest, ouest-nord-ouest, nord-ouest, nord-nord-ouest, nord, etc...    
\- passage de 16 à ... 360 domaines de localisation :   
Trop nombreux, ils ne sont pas nommés, mais ils sont délimités par des nombres entiers allant de 0 à 359 (360 est le retour à 0).   
* système de coordonnées
  *  une origine du système.
  *  le plan horizontal contenant l'origine.
  *  l'axe sud-nord, pointant vers le nord.
  *  la verticale à l'origine, orientée vers le haut.
  *  un sens choisi autour de la verticalde, pour la graduation des angles en degré.
discours à construire...
direction (et sens) d'un lieu est repéré par l'angle $`\varphi`$ entre l'axe Sud-Nord et la direction où il est observé depuis l'origine.   
difficile de déterminer exactement la valeur de l'angle $`\varphi`$, on évalue un encadrement de façon à pouvoir dire avec une grande confiance
que le lieu recherché se situe dans l'encadrement donné de la valeur de $`\varphi`$.


![](viewpoint-indicator-3_v3_L850.gif)
(figure modifiable, ou qui peut se changer)
_Fig.  : Le lieu indiqué par la flèche violette est situé en direction du sud-sud-ouest.   
Le lieu indiqué est caractérisé par l'angle $`\varphi=120 \pm 2°`$_


#### Comment connaître sa distance ?

![](viewpoint-indicator-4_v2_L850.gif)   
Tout peut être amélioré ou changé.


#### Comment indiquer l'altitude d'un sommet montagneux?

![](viewpoint-indicator-5_L850.gif)

-----------------

! *Du globe terretre à une carte du monde*
!
<!--
Là, à faire. Mais pour dire (sans le dire à ce niveau 1) qu'aucune projection de
la surface d'une sphère sur un plan ne peut conserver les angles et les distances...

Pour tester la visibilité des figures avant finition :

Idée de question :"Pourquoi faire une carte de la Terre?"   
Réponse possible : "Pour envelopper d'un seul regard la totalité de la surface terrestre."  
-->

#### Pourquoi faire une carte de la Terre ?

* Pour **envelopper d'un seul regard la surface terrestre** en totalité.

![](earth-map-earth-globe-geometry-1_L1200.gif)

Et *peut-être aussi* pour :

* **comparer les tailles des continents**.
 
* **trouver le chemin le plus court** entre villes éloignés.


#### Comment réaliser une carte de la Terre?"  

Une **première idée** :

![](earth-map-earth-globe-geometry-2_L1000.gif)

* *En tout lieu sur Terre*, le **méridien** (nord-sud) et le **parallèle** (est-ouest) **sont perpendiculaires**
 
* *Sur une feuille de papier*, je trace :
   * *verticalement* **les méridiens**,
   * *horizontalement* **les parallèles**.
    
* **$`\mathbf{\Longrightarrow}`$** Comme sur la surface terrestre,   
*en tout point de la feuille*, le **méridien** (vertical) et le **parallèle** (horizontal) **sont perpendiculaires**.

* *Sur la feuille je reporte* **les couleurs des continents et des océans** en s'aidant des méridiens et parallèles.

J'ai ainsi réalisé une **carte de la surface terrestre**.

<!--
Idée de question :"Comment réaliser une carte de la Terre?"  
Réponse possible :   
Une première idée :  
\- en chaque lieu de la Terre, le méridien et le parallèle qui passe par ce lieu sont orthogonaux".   
donc :   
\- reporter verticalement sur une carte les méridiens, et horizontalement les parallèles.   
\_ en chaque pixel de cette carte, reporter la couleur du pixel correspondant sur le globe terrestre.  
-->

#### Ma carte ainsi réalisée est-elle fiable ?

* **Puis-je y comparer** *des distances ?*, et *des surfaces ?*

##### Non, sur ma carte les distances ne sont pas respectées

![](earth-map-earth-globe-geometry-3_L1000_v2.gif)  

* **Je ne peux pas comparer des distances** avec précision.

* *Par exemple* :
   * L'**équateur terrestre**, *40 000 km* de circonférence,   
   (**E** sur la figure)
   * Le **cercle polaire**, *16 000 km* de circonférence,   
   (**C** sur la figure)
   * Le **pôle sud**, *un simple lieu* sur Terre,  
   (**P** sur la figure)   
   sont *représentés par* des **lignes de longueurs égales** sur la carte.   
   (égales à la largeur de la carte)


##### Non, sur ma carte les chemins les plus courts ne sont pas des segments de droite.

*Qu'est-ce qu'un grand cercle* sur une sphère ?

* Un **grand cercle** sur une sphère est un *cercle dont tout diamètre passe par le centre de la sphère*.
`
* Soit $`\mathscr{S}`$ une sphère de centre $`O`$ :
   * Le **cercle $`\mathscr{C_1}`$** dont un diamètre $`\mathscr{D_1}`$ ne passe par par $`O`$ n'est *pas un grand cercle*.
   * Le **cercle $`\mathscr{C_2}`$** dont un diamètre $`\mathscr{D_2}`$ passe par $`O`$ est un *grand cercle*.

![](grand-cercle-1_L1200.gif)


*Qu'elle est le chemin le plus court* sur une sphère entre deux de ses points ?


* Le **chemin le plus court** entre deux points sur la surface d'une sphère est le *plus petit arc du
grand cercle* qui contient ces deux points.

* Soient deux points $`P`$ et $`Q`$ sur une sphère $`\mathscr{S}`$ de centre $`O`$ :
   * Le **plus petit arc du cercle $`\mathscr{C_0}`$** joignant$`P`$ et $`Q`$ n'est *pas le chemin le plus court*.
   * Le **plus petit arc du cercle $`\mathscr{C_1}`$** joignant$`P`$ et $`Q`$ n'est *pas le chemin le plus court*.
   * Le **plus petit arc du grand cercle $`\mathscr{C_2}`$** joignant$`P`$ et $`Q`$ est le *chemin le plus court*.

![](grand-cercle-2_L1200.gif)


* Un **grand cercle** est l'intersection entre la sphère et un plan passant par son milieu.   
$`\Longrightarrow`$ ce plan *coupe la sphère en deux demi-sphères*.

![](grand-cercle-orange_L1200.jpg)   
_Nous découpons en général une orange selon un grand cercle._


      
*Sur la figure suivante :*

* **A - Sur le globe terrestre** sont représentés les **plus courts chemins entre** :   
   1. chemin *vert* : **Fort-de-France - La Rochelle**.
   2. chemin *bleu* : **Montréal - Oslo**.
   3. chemin *rouge* : **Libreville - Macapá**.

![](earth-map-earth-globe-geometry-trips_v5_L900.gif)

* **B - Sur la carte** obtenue, ces chemins les plus courts **ne sont pas des segments de droites**.

   * **$`\Longrightarrow`$ en général** les **segments de droite** sur la carte ne représentent  **pas les chemins les plus courts** sur la surface terrestre entre ces deux points.
   
   * **Seule exception** :  lorsque les **deux points** sont **situés sur l'équateur terrestre**.    
    _Cas du chemin rouge Libreville - Macapá_   
    En effet l'*équateur terrestre* est le *seul grand cercle du globe* dont la représentation est une *ligne droite sur ma carte*.
        

<!--##### Non, les formes sont déformées et les aires ne peuvent se comparer.

figure à faire   


<!--
\- Je ne peux pas déterminer le chemin le plus court entre deux lieux de la Terre :   
$nbsp;$nbsp;\- à faire, mais la trajectoire la plus courte prise entre deux points de la Terre 
ne correspond pas à un sègment de droite sur la carte.
-->

<!--##### Non, les formes sont déformées et les aires ne peuvent se comparer.

figure à faire   -->


#### Existe-t-il une projection d'une sphère sur un plan qui respecte toutes les distances, aires et angles?

* **Non, une telle projection n'existe pas**.

![](geometry-euclidian-non-euclidian-orange_L1200.gif)
_Il n'existe aucune façon d'aplanir un minimum une peau d'orange sans la déformer, sans la déchirer_   
<!--merci pour l'idée Martin :)-->

*Pourquoi ?*

* C'est un point qui sera développé dans les niveaux supérieurs.   
En quelques mots : la **géométrie à la surface 2D d'une sphère** n'est *pas la géométrie euclidienne de notre espace 3D usuel*.


#### Comment réaliser au mieux la surface terrestre sur une carte? 

à terminer, décrire cette construction, probablement nécessité d'une autre image.

![](earth-projection-final-stage_v1_L1000.gif)


#### A quoi correspond un point de la carte ?

* un point sur la surface terrestre

* un axe, partant du centre de la sphère et passant par un point de sa surface.


#### Comment représenter sur une carte une direction dans l'espace ?

![](sphere-celeste-1_L1200.gif)

![](sphere-celeste-1b.gif)

**1** - Lorsque le regard d'un **observateur** se situe *à l'intérieur d'une sphère imaginaire*, la direction de son **regard coupe** cette sphère en *un point de sa surface*.

**2** - **Deux observateurs** occupant des *positions différentes* à l'intérieur de la sphère attribueront à **une même direction** de l'espace des *points différents* à la surface de la sphère.

**3** - **Par convention**, le regard de l'*observateur est situé au centre* de la sphère imaginaire.


#### Quel équateur, quels pôles définir pour repérer une direction ?

![](sphere-celeste-2_L1200.gif)

* Cela **dépend du sujet observé** dans toutes les directions de l'espace.
* Pour un sujet donné, les directions correspondantes aux **pôles et** à l'**équateur** 
*doivent pouvoir se déduire de l'observation* elle-même.
* Les **astrophysiciens** choississent les *coordonnées galactiques*.


#### Que sont les coordonnées galatiques ?

![](galactic-plane-demo-copriright-to-do_L1000.gif)



!   
!  *DES  GRANDEURS  PHYSIQUES  QUI  VARIENT, ET  LEURS  REPRESENTATIONS*   
!
!
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! L'idée est d'introduire :<br>
! - pour la suite dans ce niveau 1, les grandeurs comme la vitesse, l'accélération, les forces, qui ne se résument pas à un nombre.<br>
! - pour le niveau 2, idem, et on commencera à parler de grandeurs scalaires et vectorielles.<br>
! - pour le niveau 3, les grandeurs et champs scalaires et vectoriels.<br>
! - pour le niveau 4, les grandeurs et champs tensoriels, avec le tenseur comme une généralisation et un dépassement des scalaires et des vecteurs.
! <br>
!
! Donc déjà par dire ce qu'est une grandeur physique (je ne vois pas de mot plus simple pour ce niveau).<br>
! Les grandeurs physiques qui peuvent s'exprimer par un nombre (exemple : température) et par une flèche plus ou moins longues (exemple : vitesse du vent).<br>
! Ces grandeurs peuvent varier dans l'espace comme dans le temps.<br>
! Comment représenter les variations spatiales de ces grandeurs :<br>
! - une carte météorologique des température.<br>
! - une  carte météorologique des vents.<br>
! et leurs variations temporelles
! - pour continuer avec les exemples météorologiques et faire prendre conscience de l'urgence climatique :<br>
! &nbsp;&nbsp; - animation (gif) prévisions températures moyennes sur le globe -->2100 pour différents scénarios.<br>
! &nbsp;&nbsp; - graphique (température moyenne/temps) -->2100 sur une zone donnée du globe.<br>
! <br>
! Lien direct avec un bloc en mathématique sur les fonctions et leurs représentation, avec possibilité d'affichage en parallèle dans un mode.<br>
! <br>
! </details>  

Programme :


!   
!  *MODELISER  LES  PHENOMENES  OBSERVÉS*   
!
!
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! Il s'agit en fait sans le dire d'une première introduction (sans le dire) à la méthode scientifique. A partir des observations sur le temps, l'espace, les corps immobiles et en mouvements et des propriétés géométriques de l'espace et des nombres et des opérations d'introduire  la notion de modélisation physique.<br>  
! <br>
! Et de façon plus concrête, à partir des ces éléments de perceptions et de la mathématique, d'introduire la physique classique et la physique moderne.<br> 
! <br>
! Même si on doit bétonner la physique classique, car c'est celle qui est utile dans la vie de tous les jours, celle qui se "ressent" dans notren expérience du quotidien et qui nous permet de réaliser tout projet à ce niveau 1, il est important d'avoir une connaisance culturelle sur la physique moderne. Et la mise en parallèle de la physique classique, des relativités et quantique permet de mieux comprendre les "bases" de chacune, comment elles façonnent chacune notre vision du monde et se complètent, et de comprendre la notion-même de "modèle".<br>
! <br>
! Donc, a priori, se dirige en ce qui concerne la physique classique, vers la première étape de cinématique (sans dire ce mots), débarrassée des coordonnées. Donc a priori, on partirait des notions de position, de vitesse et d'accélération. Puis (sans le dire) vers des sensations physiques utiles, puis des concepts de dynamique et d'énergétique. <br>
! <br>
! </details>  

Programme :



--------------------------------------------------------------------

### Tests de visualisation (notamment sur smartphones) de figures,



! TEST VIDEO/GIF, EN/HORS CONNEXION
!

##### Le gif tout seul, issu de la vidéo de StD

![](test-meca-1-mp4-gif-steph-durand_v5.gif)  
_Indépendance des mouvements en x et en y._   
_La résistance de l'air est négligeable dans cette expérience._

Un charriot avance à vitesse constante, et un mécanisme dans le charriot projette une balle vers le haut.   
Remarquez la loi de l'inertie :   
la vitesse horizontale, initiale de la balle, due au charriot n'est pas affectée par ce qui se passer verticalement.   
La balle a gardé horizontalement la même vitesse que le charriot et elle retombe exactement dedans.   
La balle possède une vitesse constante en x et elle subit une chute libre en y;       
la combinaison de ces deux mouvements produit une parabole.   
Répétons le point crucial :   
pendant que la balle monte, elle conserve la même vitesse horizontale que le charriot,   
et donc elle retombe exactement dans le charriot.


##### Ceci est une vidéo associée avec commande html pour la vidéo

1. sans le Gif ni le texte associé

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
</video>
-->

2. sans le Gif ni le texte associé, mais avec phrase    
Your browser does not support the video tag.

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
Your browser does not support the video tag.
</video>
-->

3. avec le Gif mais sans le texte associé

<!--
<video width="100%" muted autoplay loop controls poster="/temporary_ins/geometry-coordinates-prop2/n1/overview/test-meca-1-mp4-gif-steph-durand_v2.gif">
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
</video>
-->


4. avec le Gif et le texte associé

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
![](test-meca-1-mp4-gif-steph-durand_v2.gif)   
<br>
Voici un mouvement horizontal à vitesse constante,   
Et voici un mouvement vertical en chute libre, ascendant, puis descendant.   
Et maintenant la combinaison des deux mouvements :   
Pendant que le charriot avance à vitesse constante, la balle est projetée vers le haut.   
Remarquez la loi de l'inertie :   
la vitesse horizontale, initiale de la balle, due au charriot n'est pas affectée par ce qui se passer verticalement.   
La balle a gardé horizontalement la même vitesse que le charriot et elle retombe exactement dedans.   
La balle possède une vitesse constante en x et elle subit une chute libre en y;       
la combinaison de ces deux mouvements produit une parabole.   
Répétons le point crucial :   
pendant que la balle monte, elle conserve la même vitesse horizontale que le charriot,   
et donc elle retombe exactement dans le charriot.
</video>
-->

##### Ceci est une vidéo associée avec commande markdown

2. sans le Gif ni le texte associé, mais avec phrase    

<!--
![Your browser does not support the video tag.](Méca-1-step-durand_10is.mp)
-->

3. avec le Gif mais sans le texte associé

<!--
![test-meca-1-mp4-gif-steph-durand_v5.gif](Méca-1-step-durand_10is.mp)
-->

4. avec le Gif et le texte associé

<!--
![![](test-meca-1-mp4-gif-steph-durand_v5.gif)   
Voici un mouvement horizontal à vitesse constante,   
Et voici un mouvement vertical en chute libre, ascendant, puis descendant.   
Et maintenant la combinaison des deux mouvements :   
Pendant que le charriot avance à vitesse constante, la balle est projetée vers le haut.   
Remarquez la loi de l'inertie :   
la vitesse horizontale, initiale de la balle, due au charriot n'est pas affectée par ce qui se passer verticalement.   
La balle a gardé horizontalement la même vitesse que le charriot et elle retombe exactement dedans.   
La balle possède une vitesse constante en x et elle subit une chute libre en y;       
la combinaison de ces deux mouvements produit une parabole.   
Répétons le point crucial :   
pendant que la balle monte, elle conserve la même vitesse horizontale que le charriot,   
et donc elle retombe exactement dans le charriot.](Méca-1-step-durand_10is.mp)
-->



