---
title: Coordonnées cartésiennes
published: true
routable: true
visible: false
lessons:
    - slug: cartesian-cylindrical-spherical-coordinates
      name: PARALLÈLE : Coordonnées cartésienne, cylindrique et sphérique
      order: 1
    - slug: cartesian-coordinates-linear
      name: LINÉAIRE : Les coordonnées cartésiennes
      order: 2
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-4_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

<!--MétaDonnée : INS-1°année-->

<!-- Partie synthèse $`\longleftarrow`$ Coordonnées cylindriques N3 -->

##### Niveau Contreforts :&nbsp; _toute spécialité_

---------------------------

#### Que sont les coordonnées cartésiennes ?

* 3 coordonnées *spatiales* : **$`\mathbf{x\;,\;y\;,\;z}`$**

* définies à partir d'un **système de référence** :<br>
\- **1 point $`O`$** de l'espace, *origine* des coordonnées.<br>
\- **3 axes** *orthogonaux 2 à 2*.<br>
\- **1 unité de longueur** identique pour les axes.

* **$`\mathbf{x, y, z}`$** sont des *longueurs*, de coordonnées SI : le mètre *($`\mathbf{m}`$)*.
<br><br>
![](cartesian_coordinates_definition_L1200.gif)
 
#### Quels sont les domaines de variation des coordonnées ?

![](cartesian_coordinates_variation_range_L1200_v1.gif)


#### Quelle est la propriété spécifique des coordonnées cartésiennes ?

* **Pour tout point $`M`$** de l'espace $`\mathscr{E}`$ de *coordonnées cartésiennes $`(x, y, z)`$*, la distance $`OM`$ 
s'exprime simplement en fonction des coordonnées :<br><br> 
**$`\mathbf{OM=\sqrt{x^2+y^2+z^2}}`$**. 

* Cette propriété est **propre aux coordonnées cartésiennes** :<br>
<br> 
Soit $`(O,\alpha,\beta,\gamma)`$ un système de coordonnées,
<br> 
$`\mathbf{\forall M(\alpha;\beta,\gamma)\in\mathscr{E}\quad| \quad OM=\sqrt{\alpha^2+\beta^2+\gamma^2})}`$
$`\mathbf{\quad\Longleftrightarrow\quad(\alpha;\beta,\gamma)}`$ sont des coordonnées cartésiennes.



#### Comment définir le vecteur unitaire associé à chaque coordonnée ?

* Le vecteur unitaire $`\overrightarrow{e_{\alpha}}`$ indique la **direction et
le sens de déplacement** d'un point $`M`$ si *seule la coordonnée $`\alpha`$* du point 
$`M`$ *varie d'une quantité positive infinitésimale $`d\alpha^+`$*.


* **$`\mathbf{M(x,y,z) \longrightarrow M'(x+\Delta x^+,y,z)}`$**<br>
* **$`\mathbf{M(x,y,z) \longrightarrow M'(x,y+\Delta y^+,z)}`$**<br>
* **$`\mathbf{M(x,y,z) \longrightarrow M'(x,y,z+\Delta z^+)}`$**<br>
**$`\mathbf{M(\rho,\varphi,z) \longrightarrow M'''(\rho,\varphi,z+\Delta z^+)}`$** <br>
(avec $`\Delta x^+=\Delta x>0`$, $`\Delta y^+=\Delta y>0`$ et $`\Delta z^+=\Delta z>0`$)<br>
<br>**$`\Longrightarrow`$ directions et sens** de <br>
**$`\quad\overrightarrow{e_x}`$** : selon l'axe $`Ox`$,   
**$`\quad\overrightarrow{e_y}`$** : selon l'axe $`Oy`$,   
**$`\quad\overrightarrow{e_z}`$** : selon l'axe $`Oz`$.

* Dans les trois cas, la trajectoire suivie par $`M`$ : sègment de droite<br>
$`\Longrightarrow`$ longueur parcourue = norme du vecteur déplacement.<br>
$`\Longrightarrow`$ $`l_{\Delta\rho}=||\overrightarrow{MM'}||\quad`$, 
 $`\quad l_{\Delta y}=||\overrightarrow{MM''}||`$ et  $`\quad l_{\Delta z}=||\overrightarrow{MM'''}||`$

* Cas général ($`dx, dy\text{ et u}dz >0\;\text{ ou }<0`$) :<br>
**$`\mathbf{\overrightarrow{dl_x}}`$** $`\displaystyle=\lim_{\Delta x\rightarrow 0} \overrightarrow{MM'}`$ **$`\mathbf{ = x \cdot \overrightarrow{e_x}}`$**.   
**$`\mathbf{\overrightarrow{dl_y}}`$** $`\displaystyle=\lim_{\Delta x\rightarrow 0} \overrightarrow{MM''}`$ **$`\mathbf{ = y \cdot \overrightarrow{e_y}}`$**.   
**$`\mathbf{\overrightarrow{dl_z}}`$** $`\displaystyle=\lim_{\Delta x\rightarrow 0} \overrightarrow{MM'''}`$ **$`\mathbf{ = z \cdot \overrightarrow{e_z}}`$**.   


#### La base $`(\overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})`$ est orthonormée.


* **$`\mathbf{(\overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})}`$** est la *base associée à un point $`M(x_M,y_M,z_M)`$*.

* $`(\overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})`$ est orthonormée **directe** *si les trois vecteurs de base
dans l'ordre* où ils apparaissent dans l'écriture de la base :
   * *premier : $`\overrightarrow{e_x}`$*,
   * *deuxième : $`\overrightarrow{e_y}`$*,
   * *troisième : $`\overrightarrow{e_z}`$*, 
   
   ont des *orientations relatives* qui respectent la **règle d'orientation de l'espace** dite de la **main droite** :
   * **si** le premier vecteur, *$`\mathbf{\overrightarrow{e_x}}`$*, est orienté en *direction et sens du pouce* d'une main droite,
   * **si** le deuxième vecteur, *$`\mathbf{\overrightarrow{e_y}}`$*, est orienté en *direction et sens de l'index* de la même main droite,
   * **alors** le troisième vecteur *$`\mathbf{\overrightarrow{e_z}}`$* doit être orienté en *direction et sens du majeur* de la même main droite.
<br>
![](physics-mechanics-space-orientation-right-hand-rule-direction_L1200_horiz_vert.jpg)   
<br>
Dans le **cas contraire** :
   * premier vecteur, *$`\mathbf{\overrightarrow{e_x}}`$* orienté en *direction et sens du pouce* d'une main droite,
   * euxième vecteur, *$`\mathbf{\overrightarrow{e_y}}`$* orienté en *direction et sens de l'index* de la même main droite,
   * troisième vecteur *$`\mathbf{\overrightarrow{e_z}}`$* orienté en *direction et __sens inverse du majeur__* de la même main droite,
la **base orthonormée** est dite **indirecte**.


#### Comment s'exprime le vecteur position $`\overrightarrow{OM}`$ ?


![](cartesian_coordinates_position_vector_OM_L1200.gif)

<!------------------------
##### Quelle différence entre coordonnées d'un point $`M`$, et composantes du vecteur $`\overrightarrow{OM}`$ ?

@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@from cylindrical
@@@@@@@@@@@@@@@@@@@@@@@@@@

------------------>


#### Que sont l'élément de longueur $`dl`$ et  vecteur déplacement élémentaire $`\overrightarrow{dl}`$ ?

* Un point **$`M(x,y,z)`$** fait un **déplacement infinitésimal** jusqu'au point
$`M'(x+dx,y+dy,z+dz)`$, avec *$`dx`$, $`dy`$ et $`dz`$ variations infinitésimales,
positives ou négatives*, des coordonnées $`x\;,\;y\;,\;z`$.

##### Vecteur déplacement élémentaire $`\overrightarrow{dl}`$

* vecteur déplacement élémentaire = *élément vectoriel d'arc* [Norme IEC](http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-02)

* Le **vecteur déplacement élémentaire** est le vecteur   
**$`\mathbf{\overrightarrow{dl}}`$** $`\;=dl_x\cdot\overrightarrow{e_x}+dl_y\cdot\overrightarrow{e_y}+dl_z\cdot\overrightarrow{e_z}`$
**$`\mathbf{\quad=dl_x\cdot\overrightarrow{e_x}+dy\cdot\overrightarrow{e_y}+dz\cdot\overrightarrow{e_z}}`$**

*  permet de calculer les vecteurs vitesse $`\overrightarrow{\mathscr{v}}(t)`$ et accélération $`\overrightarrow{a}(t)`$ d'un point M à tout instant t :<br>
**$`\mathbf{\overrightarrow{\mathscr{v}}(t)}`$**$`\;=\dfrac{\overrightarrow{dOM}}{dt}`$**$`\mathbf{\\;=\dfrac{\overrightarrow{dl}}{dt}}`$**<br>
**$`\mathbf{\overrightarrow{a}(t)}`$**$`\;=\dfrac{\overrightarrow{d^2 OM}}{dt^2}`$**$`\mathbf{\\;=\dfrac{d}{dt}\left(\dfrac{\overrightarrow{dl}}{dt}\right)}`$**

##### Élément de longueur $`dl`$

* élément de longueur = *élément scalaire d'arc* [Norme IEC](http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-01)

* L'**élément de longueur $`\mathbf{dl}`$** est la *longueur parcourue* sur la trajectoire entre $`M`$ et $`M'`$ :<br>
**$`\mathbf{dl}`$**$`\;=\sqrt{dl_x^2+dl_y^2+dl_z^2}`$**$`\mathbf{\\;=\sqrt{dx^2+dy^2+dz^2}}`$**

* Permet de calculer la longueur $`\mathscr{l}`$ d'une trajectoire $`L`$, lorsque les coordonnées $`x(t)`$, $`y(t)`$ et $`z(t)`$ varient en fonction du temps de façon indépendantes les une des autres :<br>
**$`\displaystyle\mathbf{\mathscr{l}=\int_L dl}`$**

#### Qu'est-ce que la surface élémentaire associée à chaque coordonnée ?

* **Element de surface $`\mathbf{dS_x}`$**, surface élémentaire *perpendiculaire à $`\mathbf{\overrightarrow{e_x}}`$*.   
 <br>_Utilisable, par exemple, pour calculer l'aire d'une surface contenue dans un plan perpendiculaire à l'axe $`Ox`$._

figure à faire



* **Element de surface $`\mathbf{dS_y}`$**, surface élémentaire *perpendiculaire à $`\mathbf{\overrightarrow{e_y}}`$*.   
 <br>_Utilisable, par exemple, pour calculer l'aire d'une surface contenue dans un plan perpendiculaire à l'axe $`Oy`$._

figure à faire   



* **Element de surface $`\mathbf{dS_z}`$**, surface élémentaire *perpendiculaire à $`\mathbf{\overrightarrow{e_z}}`$*.   
 <br>_Utilisable, par exemple, pour calculer l'aire d'une surface contenue dans un plan perpendiculaire à l'axe $`Oz`$._

figure à faire   

---

#### Qu'est-ce que le volume élémentaire ?

Le **volume élémentaire** en chaque point $`M`$ de coordonnées $`(x,y,z)`$
est le volume $`d\tau`$ d'un *parallélépipède rectangle mésoscopique*, d'*arêtes parallèles aux vecteurs
$`\overrightarrow{e_x}`$, $`\overrightarrow{e_y}`$ et $`\overrightarrow{e_z}`$*,
et de *longueurs* respectives *$`\mathbf{dl_x`$, $`dl_y`$ et $`dl_z}`$*.

Donc **$`\mathbf{d\tau}`$**$`\; = dl_x \cdot dl_y\cdot dl_z`$**$`\; =\mathbf{dx\;dy\;dz}`$**

figure à faire


     
