---
title: "Boundary conditions, reflection and transmission"
published: true
routable: true
visible: false
---

<!------
## Reflected and transmitted electromagnetic waves at interfaces
-------->

#### Chapter 3

### Boundary conditions,<br>reflexion and transmission

<br>

#### 3.1 - Boundary conditions

Before considering the reflection and transmission of electromagnetic
waves between two media, we have to determine the relations governing
the be- haviour of the fields $`\overrightarrow{D}`$, $`\overrightarrow{B}`$, $`\overrightarrow{E}`$ and $`\overrightarrow{H}`$ at the
interface between two materials. Simply stated, these relations,
called the "__boundary conditions__" tell us that if we know the fields
in one material close to the separation surface then we can calculate
some components of these same fields in the other material (again,
close to the separation surface). We will consider an LHI material and
the relations we will find are valid __for any point__ close to the
separation surface and __for any time__. These two conditions are
important to find some of the results later in this chapter. The
boundary conditions can be obtained from the Maxwell equations. The
first two equations

@@@@@@@@@@@@

will give information on the normal components of $`\overrightarrow{D}`$ and $`\overrightarrow{B}`$,
while the third and fourth

@@@@@@@@@@@@

will give information on the tangential components of $`\overrightarrow{E}`$ and $`\overrightarrow{H}`$.

To obtain the boundary conditions we consider a surface separating two
Linear Homogeneous and Isotropic (LHI) media whose properties such as that
the permittivity and permeability are different. We denote as
$`\overrightarrow{E}_1\,,\overrightarrow{B}_1\,,\overrightarrow{D}_1`$ and $`\overrightarrow{H}_1`$ the fields present in
material 1 close to its surface. Likewise an index 2 will be used for
the fields in the second material.

<br>
![](electromag-in-media-reflexion-transmission-fig-31.jpg)   
_Figure 3.1 : Scheme for deriving boundary conditions for perpendicular field components._
_$`S_1\,, S_2`$ and $`S'`$ represent respectively the surface at the top, bot- tom and interface._
>

##### Normal components

__$`\overrightarrow{D}`$ vector__

Let's apply Maxwell equation (i) to the small cylinder showed in
figure [3.1] which extends from one side to the other on
the separation surface. This box has a base surface A and an
infinitesimally small thickness $`\delta`$. We get:

@@@@@@@@@@@@@@@@@@@@@@@@@

If we now let $`\delta\longrightarrow 0`$ symmetrically with respect to the separation
surface such that the cylinder gets "pressed" onto the surface:

* The third term on the left hand side of the previous equation will
  be negligible as the flux of the vector $`\overrightarrow{D}`$, which is a finite
    quantity, through an infinitesimally small surface will approach
    0.

* The volume charge will be reduced to a surface charge at the
    interface only as the volume will approach 0. The volume charge
    density is replaced by a surface charge density $`\sigma`$ and the
    volume integral is replaced by surface integral over the middle
    surface $`S'`$.

We obtain:

@@@@@@@@

Now, considering that $`d\overrightarrow{a_2}=-d\overrightarrow{a_1}`$ we can write:

@@@@@@@@@@@@@

Finally, as $`S_1=S'`$ and $`d\overrightarrow{a_2}=\overrightarrow{n}_{2\rightarrow 1}\,da_1`$ we can
write:

@@@@@@@@@

or

@@@@@@@@@@@

The normal component of the vector $`\overrightarrow{D}`$ is in general discontinuous.
It is continuos only if there are no conduction charges at the
separation surface.

__$`\overrightarrow{B}`$ vector__

The situation is identical for the vector $`\overrightarrow{B}`$, the only difference
being that the right hand side of the equation is always 0. We
conclude that:

@@@@@@@@@

or

@@@@@@@@@

The normal component of $`\overrightarrow{B}`$ is always conserved.


##### Tangential components

<br><br>
![](electromag-in-media-reflexion-transmission-fig-32.jpg)   
_Figure 3.2 : Contour for deriving boundary conditions for parallel field components._

__$`\overrightarrow{E}`$ vector__

We integrate the third Maxwell equation around the rectangular contour
C that straddles the boundary of width W and thickness $`\delta`$ as shown in
figure [3.2.]. We chose to integrate the line integral
following the right-hand sense relative to the surface normal
$`\overrightarrow{n_a}`$. By letting $`\delta\rightarrow 0`$, we get

@@@@@@@@@@@

as the line integral along the sides goes to zero and the flux of the
induction field $`\overrightarrow{B}`$, which is a finite quantity, approaches 0.
Considering that $`\overrightarrow{CD}-\overrightarrow{AB}=d\vec{l}`$, we get:

@@@@@@@@@@

or again

@@@@@@@@@@@@

i.e. the tangential components of the electric field are always
conserved at the interface. This condition can also be written:

@@@@@@@@@@ $`\quad (equ. 3.16)`$

__$`\overrightarrow{H}`$ vector__

Following the same reasoning as for the $`\overrightarrow{E}`$ vector we write for the
left hand side when $`\delta\rightarrow 0`$ :


@@@@@@@@@@@@@ $`\quad (equ. 3.17)`$

The right hand side needs more attention. The flux of the vector $`\overrightarrow{D}`$
approaches 0. However the flux of the vector $`\overrightarrow{J}`$ over an infinitesimal surface
can give a finite value: the surface integral reduces to an integral
over the line of width W equal to the side of the rectangle. No volume
current can contribute, however a surface current $`\overrightarrow{J}_S`$ (i.e. a
current flowing on the separation surface with dimensions $`[A/m]`$
not $`[A/m*^2]`$ as $`\overrightarrow{J}`$) can. This is typically the case of a
perfect conductor where a finite current can flow through a
infinitesimally small area. We get:

@@@@@@@@ $`\quad (equ. 3.18)`$

or again

@@@@@@@@ $`\quad (equ. 3.19)`$

i.e. the tangential components of the magnetic field $`\overrightarrow{H}`$ is
discontinuous unless no surface currents exist. As for the electric
field, this condition can also be written:

@@@@@@@@ $`\quad (equ. 3.20)`$

!! *Summary*   
!! 
!! *vector form*   
!! * @@@@@
!! * @@@@@


! *Remarks*   
!
! * If medium 1 & 2 are perfect dielectrics then there are no charges
! nor surface currents at the interface, and so the tangential component
! of $`\overrightarrow{H}`$ and the normal component of $`\overrightarrow{D}`$ are both continuous.   
!
! * If medium 1 is a perfect dielectric and medium 2 is a perfect metal,
! there are charges and surface currents at the interface, and so the
! tangential component of $`\overrightarrow{H}`$ and the normal component of $`\overrightarrow{D}`$ are
! not continuous.   
!
! * In case of linear media, the 4 relations can be expressed in terms
! of $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ alone using the constitutive relations
! $`\overrightarrow{D}=\epsilon\,\overrightarrow{E}`$ and $`\overrightarrow{B}=\mu\,\overrightarrow{H}`$.

&&&&&&&&&&&&&&&&&&&&&&&&&

<br><br>

#### chap2 Reflection and transmission at normal incidence

We suppose that the *xy* plane at *z* = 0 is the boundary between
medium 1 and medium 2. A plane wave of angular frequency *ω*
travelling in medium 1 in the positive *z* direction and polarised
along the *x* axis makes a normal incidence at the interface with
medium 2.

##### Case 1: perfect dielectric/perfect conductor

We will first consider the case of a normal incidence for a wave
travelling in vacuum (a particular case of a perfect dielectric with
*ε* = *ε*~0~, *n* = 1, *µ* = *µ*~0~) at the interface with a perfect
conductor. For the perfect conductor, as *σ* , its penetration depth
*δ* 0, i.e. no electromagnetic field can exist inside it. No
transmission can occur, the wave is totally reflected. The incident
and reflected waves are:

*i*

**[B]{.underline}***i* = *B*0 e*i*(*kz*−*ωt*)**ˆe***y* =
>
*i* e*i*(*kz*−*ωt*)**ˆe***y*
>
(3.21)
>
medium 1 perfect dielectric
>
$`\overrightarrow{E}`$*~i~*

$`\overrightarrow{B}`$*~i~* **k***~i~*

**k***~r~*

\", µ

![](media/image172.png)$`\overrightarrow{E}`$*~r~* $`\overrightarrow{B}`$*~r~*

medium 2 perfect conductor
>
![](media/image174.png)
>
$`\overrightarrow{j}`$*~s~* O y **n**ˆ
>
Figure 3.3: Left: Normal incidence at the boundary between a perfect
dielec- tric and a perfect conductor. Right the total fields at a few
different times.

and

0 *i*(*kz*+*ωt*) *r*
>
**[B]{.underline}***r* = *B*0 e−*i*(*kz*+*ωt*)**ˆe***y*
>
(3.22)
>
Using the boundary conditions at the interface (*z* = 0) we have:
>
*E~T~* ~1~ − *E~T~* ~1~ = 0 ⇒ $`\overrightarrow{E}`$*~T~* ~1~ = $`\overrightarrow{E}`$*~i~* + $`\overrightarrow{E}`$*~r~*
= 0 ⇒ *E*^0^ = −*E*^0^
>
(3.23)
>
as the boundary conditions are valid in any point of the surface and
at any time. We cab therefore write the reflected wave as:
>
*i* 0
>
**[B]{.underline}***r* = *B*0e−*i*(*kz*+*ωt*)**ˆe***y* = *i y*
>
(3.24)
>
In medium 1 we have a superposition of the incident and reflected
waves. The total wave is given by:
>
 $`\overrightarrow{E}`$*~tot~* = $`\overrightarrow{E}`$*~i~* + $`\overrightarrow{E}`$*~r~* = *E*^0^ (*e^ikz^* −
*e*^−*ikz*^l *e*^−*iωt*^ = 2*iE*^0^ sin(*kz*)*e*^−*iωt*^**ˆe***~x~*
>
(3.25)

*i* *i*

or in real notation

f $`\overrightarrow{E}`$*~tot~* = 2*E*^0^ sin(*kz*) sin(*ωt*)**ˆe***~x~*

*tot*

*i kz*
>
*ωt ~y~*
>
This wave represents a **stationary wave**1: a wave the oscillates in
place. The nodes and antinodes of the electric field and magnetic
field are out of phase
>
1Be careful not to confuse a stationary wave with an evanescent wave.
>
by *π/*2. In particular the electric field has a node at the interface
(imposed by the boundary conditions) and the magnetic field as instead
an antinode at the interface. A stationary wave does not transport any
net energy. This can be readily understood as as much energy is
carried by the incident wave from right to left as the reflected one
in the opposite direction. Calculating the Poynting vector we have:
>
$`\overrightarrow{S}`$ = [$`\overrightarrow{E}`$*tot **×***]{.underline} [$`\overrightarrow{B}`$*tot*]{.underline} =
*E*0*B*0 sin(2
>
) sin(2
>
)**ˆe**
>
(3.27)
>
*tot µ*0
>
*[i i]{.underline} kz µ*~0~
>
*ωt ~z~*
>
which at any point *z* changes direction periodically. Its
time-averaged values is indeed *\<* $`\overrightarrow{S}`$*~tot~ \>~t~*= 0.
>
Due to the discontinuity of the magnetic field, a surface current
density must

![](media/image175.png)![](media/image176.jpeg){width="2.4469674103237096in"
height="1.3326695100612422in"}E*max* E*min*

Figure 3.4: Left: The incident, reflected and resulting wave at a
particular time. Right: The superposition of several resulting waves
at different times. See the video of the simulation on the [moodle
page.](https://moodle.insa-toulouse.fr/course/view.php?id=621)
>
be present at the interface. Using the fourth boundary condition we
get:
>
**nˆ *× ***($`\overrightarrow{H}`$~1~ − 0) = $`\overrightarrow{j}`$*~s~*
>
⇒ $`\overrightarrow{j}`$*~s~* = −*n***ˆe***~z~ **×***
>
[*B~tot~*(*z* = 0)]{.underline}**ˆe** =
>
*µ*0 *y*
>
2*E*0 cos( )**ˆe**
>
*µ c*

0

##### Case 2: 2 perfect dielectrics

We are dealing now with two perfect dielectrics. For the discussion we
will consider that the materials are non-magnetic (*µ* = *µ*~0~) and
that no charges nor currents exist at the interface (*σ~s~* = 0*,*
$`\overrightarrow{j}`$*~s~* = 0). The incident ware is given by
>
f **[E]{.underline}***i* = *E*0 e*i*(*k*~1~*z*−*ωt*)**ˆe***x*
>
*E*^0^*n*
>
(3.28)
>
**[B]{.underline}***i* = *B*0 e*i*(*k*~1~*z*−*ωt*)**ˆe***y* = *i* 1
e*i*(*k*1*z*−*ωt*)**ˆe***y*
>
![](media/image177.png) ![](media/image180.png)
>
Figure 3.5: Left: Normal incidence at the boundary between twp perfect
dielectrics. Right the total fields in medium 1 at a few different
times showing a partial standing wave. The minimum amplitude of
$`\overrightarrow{E}`$*~tot~* is no more 0.
>
where **k**~1~ and *n*~1~ are the wavevecvtor and refractive index of
medium 1. The reflected and transmitted waves are:
>
**[E]{.underline}***r* = *E*0 e−*i*(*k*~1~*z*+*ωt*)**ˆe***x*

0

(3.29)
>
**[B]{.underline}***r* = *B*0 e−*i*(*k*~1~*z*+*ωt*)**ˆe***y* = − *Er
n*1
>
e−*i*(*k*~1~*zωt*)**ˆe***y*

and

*r c*
>
**[E]{.underline}***t* = *E*0 e*i*(*k*~2~*z*−*ωt*)**ˆe***x*

0

(3.30)

**[B]{.underline}** = *B*0 e*i*(*k*~2~*z*−*ωt*)**ˆe***y* = *Et n*2
e*i*(*k*~2~*z*−*ωt*)**ˆe***y*

*t t c*
>
We need now two boundary conditions to determine the reflected and
trans- mitted waves. Using the tangential boundary conditions for
$`\overrightarrow{E}`$ and $`\overrightarrow{H}`$ we have:

f *E*^0^ + *E*^0^ = *E*^0^

(3.31)

*n*~1~(*Ei* − *Er* ) = *n*~2~*Et*

Solving for *E*^0^ and *E*^0^ we obtain:
>
*r t*

 *E*0 = *n*1−*n*2 *E*0

 *E*0 = 2*n*1 *E*0

We can now define the
>
*t n*~1~+*n*~2~ *i*

-   Reflection coefficient *r* = *^E^*0 = [*n* −*n*]{.underline}

and
>
*r*0 1 2

*E n*~1~+*n*~2~

-   the Transmission coefficient *t* = *^E^*0 = [2*n *]{.underline} .

0 *n* 1
>
*E* 1+*n*2

#### chap2 Reflection and transmission at oblique incidence

We now turn to the more general case of an oblique incidence at an
arbitrary angle *θ~i~*. Before that we will need a few definitions and
considerations.

![](media/image182.png)Figure 3.6: Plane of incidence, *s* and *p*
polarisations.

##### chap5 Plane of incidence

We first define the **plane of incidence** as the plane the contains
the incidence wavevector and the normal to the interface separating
the two materials. Let's consider a linearly polarised plane wave
making an oblique incidence at the interface between medium 1 and 2.
Two special cases arise:

-   if $`\overrightarrow{E}`$*~i~* is contained in the plane of incidence, the wave is
    said to be *p* (for parallel to the plane of incidence) or again
    Transverse Magnetic (TM) as the magnetic field will be
    perpendicular to the plane of incidence. The symbol "/I" is also
    often used.

-   if $`\overrightarrow{E}`$*~i~* is perpendicular to the plane of incidence, the wave
    is said to be *s* (for the german word for perpendicular - to the
    plane of incidence) or Transverse Electric (TE). The symbol "⊥" is
    used in this case.

Any other polarisation state can be decomposed into the sum of a TM
and TE wave.

##### chap5 Laws of reflection and refraction

We will derive here the laws of reflection and refraction by making
use of the boundary conditions which are independent on the
polarisation of the incident wave. W will not make any assumption on
the wavevector and frequencies of the wave. We implicitly assumed in
the previous section that the frequen- cies are the same as the
wavevectors's moduli in the same medium. We will
>
demonstrate it here. Let's consider the the general situation as of an
inci- dent, reflected and refracted wave as depicted in figure
[3.7.](#_bookmark64) The three plane

![](media/image183.png)

Figure 3.7: []{#_bookmark64 .anchor}General case of reflection and
refraction
>
monochromatic wave are:
>
**[E]{.underline}***i* = $`\overrightarrow{E}`$0*ei*(**k***~i~*·**r**−*ωt*)
>
**[E]{.underline}** = $`\overrightarrow{E}`$0*ei*(**k***r* ·**r**−*ω*^l^*t*)
**[E]{.underline}** = $`\overrightarrow{E}`$0*ei*(**k***t*·**r**−*ω*^ll^*t*)
>
The boundary conditions are applied to the interface (*z* = 0) and
must be valid for **all points on the interface** and **for all
times**.
>
In *z* = 0, for the tangential component of the electric field we
have:
>
0 *ei*(**k***~i~*·**r***~s~*−*ωt*) + $`\overrightarrow{E}`$0
>
*ei*(**k***r* ·**r***s*−*ω*^l^*t*) = $`\overrightarrow{E}`$0
>
*ei*(**k***t*·**r***s*−*ω*^ll^*t*) (3.35)
>
where **r***~s~* is a vector on the interface.

i.  For this condition to be valid *t* we must have *ω* = *ω*^t^ =
    *ω*^tt^. As a consequence we have

\|**k***~i~*\| = \|**k***~r~*\| = *[ω]{.underline} n*~1~ (3.36)

\|**k***~t~*\| = *[ω]{.underline} n*~2~ (3.37)

ii. For this condition to be valid []{#_bookmark65 .anchor}∀**r***~s~*
    we must have:

**k***~i~* · **r***~s~* = **k***~r~* · **r***~s~* = **k***~t~* ·
**r***~s~* (3.38)
>
Taking the first two terms we can write

(**k***~i~* − **k***~r~*) · **r***~s~* = 0*.* (3.39)

As **r***~s~* belongs to the interface, (**k***~i~* **k***~r~*) is
normal to it. This means that the vectors **k***~i~*, **k***~r~* and
the normal belong to the same plane, i.e. the plane of incidence.

iii. Equation [3.38](#_bookmark65) can be recast as

*x*(*k~i~*)*~x~* + *y*(*k~i~*)*~y~* = *x*(*k~r~*)*~x~* +
*y*(*k~r~*)*~y~* = *x*(*k~t~*)*~x~* + *y*(*k~t~*)*~y~* ∀*x, y* (3.40)
>
These relations can be satisfied only if all the *x* and *y*
components are the same. Taking the *x* components we can write

a.  (*k~i~*)*~x~* = \|*k~i~*\| sin *θ~i~*

b.  (*k~r~*)*~x~* = \|*k~r~*\| sin *θ~r~*

c.  (*k~t~*)*~x~* = \|*k~t~*\| sin *θ~t~*

From the first two relations we get *θ~i~* = *θ~r~* as \|*k~i~*\| =
\|*k~r~*\|.
>
From the first and the third we get \|*k~i~*\| sin *θ~i~* = \|*k~t~*\|
sin *θ~t~* or

#### chap2 Fresnel's laws & Brewster's angle

From the previous section we can write the incident, reflected and
transmitted waves as:
>
**[E]{.underline}***i* = $`\overrightarrow{E}`$0*ei*\[**k**~1~(*x* sin *θ*~1~+*z* cos
*θ*~1~)−*ωt*\] **[E]{.underline}***r* = $`\overrightarrow{E}`$0*ei*\[**k**~1~(*x* sin
*θ*~1~−*z* cos *θ*~1~)−*ωt*\] **[E]{.underline}***t* =
$`\overrightarrow{E}`$0*ei*\[**k**~2~(*x* sin *θ*~2~+*z* cos *θ*~2~)−*ωt*\]
>
where the indices "1" and "2" indicate the first and second medium
physical quantities. We will now separate the discussion for a TE and
a TM wave. Due to the isotropic nature of the media considered here, a
TE incident wave will give rise to TE reflected and transmitted waves.
Likewise for a TM incident wave.

##### chap3 TE Wave TM Wave

![](media/image184.png) ![](media/image187.png)
>
Figure 3.8: []{#_bookmark67 .anchor}Configuration for a TE and TM
incidence.

__**chap5 TE Wave**__

$`\overrightarrow{E}`$ is tangential and $`\overrightarrow{B}`$ is contained in the plane of incidence.
From figure [3.8](#_bookmark67) we can write using the two tangential
boundary conditions and the relations $`\overrightarrow{B}`$ = *µH*, \|$`\overrightarrow{B}`$\| =
^[\|$`\overrightarrow{E}`$\|]{.underline}^ *n*:
>
 *n*1 (*E*^0^ − *E*^0^) cos *θ*~1~ = *n*2 *E*^0^ cos *θ*~2~
>
As before, we define the reflection and transmission coefficient for a
TE ( or

s)  wave as:

*E*0 *E*0

*r*~⊥~ = *^[r]{.underline}^ , t*~⊥~ = *^[t]{.underline}^ ,* (3.42)
>
0 0

*i* *i*

which by solving the previous equations can be evaluated to:
>
 *n*1 cos *θ*~1~ − *n*2 cos *θ*~2~
>
cos *θ*~1~ + cos *θ*~2~ *µ*~1~ *µ*~2~
>
[2*n*1]{.underline} cos *θ*~1~
>
*µ*~1~

*.* (3.43)

*t*⊥ = *n*~1~ *n*~2~
>
cos *θ*~1~ + cos *θ*~2~ *µ*~1~ *µ*~2~

__**chap5 TM Wave**__

$`\overrightarrow{E}`$ is s contained in the plane of incidence and $`\overrightarrow{B}`$ is
transverse. From figure [3.8](#_bookmark67) we can write using the two
tangential boundary conditions and the relations $`\overrightarrow{B}`$ = *µH*,
\|$`\overrightarrow{B}`$\| = ^[\|$`\overrightarrow{E}`$\|]{.underline}^ *n*:

 *n*1 (*E*^0^ − *E*^0^) = *n*2 *E*^0^ *.*

Solving the system we obtain the reflection and transmission
coefficients for a TM (/I or *p*) wave as:

 *n*1 cos *θ*~2~ − *n*2 cos *θ*~1~

cos *θ*~1~ + cos *θ*~2~ *µ*~2~ *µ*~1~
>
[2*n*1]{.underline} cos *θ*~1~
>
*µ*~1~

*.* (3.44)

*t*I/ = *n*~2~ *n*~1~



chap4 Brewster's angle

cos *θ*~1~ + cos *θ*~2~ *µ*~2~ *µ*~1~
>
Let's make a few considerations on the consequences of the Fresnel
relations by plotting the reflection coefficients for *s* and *p*
polarisations. We, first of all, separate the two cases according to
the relative value of the two media refrac- tive indices *n*~1~ and
*n*~2~. By using Snell-Descartes law *n*~1~ sin(*θ*~1~) = *n*~2~
sin(*θ*~2~) we have that

a.  If *n*~1~ *\< n*~2~ −→ *θ*~1~ *\θ*~2~

b.  If *n*~1~ *\n*~2~ −→ *θ*~1~ *\< θ*~2~

chap5 Case a)

In this case, we consider the range 0 *θ*~1~ *π/*2 for the incident
angle *θ*~1~. Correspondingly, the refraction angle *θ*~2~ will vary
in the range 0 *θ*~2~ *θ*2*max*. Using Snell we have:

i.  For *θ*~1~ = 0 → *θ*~2~ = 0, =⇒ *r*~⊥~ = *r*I/ =
    [*n*1−*n*2]{.underline} *\<* 0.

n~1~ \< n~2~ n~1~ \n~2~

![](media/image190.png)

Figure 3.9: The snell law for *n*~1~ *\< n*~2~ and *n*~1~ *\n*~2~.
>
1.0
>
n~1~ = 1
>
1.0
>
0.8
>
0.5 n~2~ = 1.5 ✓*B*
>
0.0
>
0.6
>
0.4
>
-0.5
>
-1.0
>
r*~?~*
>
r*~k~*

0 20 40

60 80
>
0.2
>
0.0

0 20 40

60 80
>
Angle of incidence (deg) Angle of incidence (deg)

1.0

0.5

0.0

-0.5

-1.0

0 20

40 60 80
>
1.0
>
0.8
>
0.6
>
0.4
>
0.2
>
0.0

0 20

40 60 80
>
Angle of incidence (deg) Angle of incidence (deg)
>
Figure 3.10: []{#_bookmark68 .anchor}Plot of the reflection
coefficients (*r*~⊥~ and *r*I/) and the correspond- ing reflectivities
(*R*~⊥~ and *R*I/) for case a (top) and case b (bottom).

ii. For *θ*~1~ = *π/*2 → *θ*~2~ = *θ*2*max* =⇒ *r*~⊥~ = −1 and *r*I/ =
    +1

This signifies that for the particular angle *θ~B~* (the Brewster's
angle) *r*I/(*θ~B~*) = 0, as shown in figure [3.10.](#_bookmark68) By
plotting the reflectance (*R* = \|*r*\|2), we see that
>
no reflection occurs for *p*-polarised wave for *θ*~1~ = *θ~B~* and
the reflection for *p* waves is, in any case, much smaller than the
reflections for *s* waves for angles close to *θ~B~*. This phenomenon
suggests different applications:

-   The possibility of polarising unpolarised waves by reflection for an
    inci- dence angle *θ* = *θ~B~*: the reflected wave will be 100%
    linearly polarised while the transmitted one only partially
    polarised (see figure [3.11).](#_bookmark69)

-   The possibility of removing unwanted reflections by using polarisers
    (Po- laroid sun-glasses for instance, figure
    [3.12);](#_bookmark70)

-   The possibility of transmitting 100% of the intensity of an incident
    wave thought an interface using a proper polarisation and
    incidence angle.

![](media/image191.png){width="2.991770559930009in"
height="2.5861450131233594in"}

Figure 3.11: []{#_bookmark69 .anchor}An illustration of the
polarisation of light that is incident on an interface at Brewster's
angle.
[https://en.wikipedia.org/wiki/Brewster'](https://en.wikipedia.org/wiki/Brewster%27s_angle)
[s_angle](https://en.wikipedia.org/wiki/Brewster%27s_angle)

chap5 Case b)

In this case, total reflections will occur for angles *θ*~1~
*θ*1*lim*. The considera- tions on the Brewster's angle stated above
will still hold.
>
The condition *r~p~* = 0 inserted in the Fresnel equation gives
>
*n*~1~ cos *θ*~2~ = *n*~2~ cos *θ~B~* (3.45) while from Snell's law we
have
>
*n*~2~ sin *θ*~2~ = *n*~1~ sin *θ~B~.* (3.46)
>
![](media/image4.jpeg){width="3.0679155730533685in"
height="0.9943744531933508in"}
>
Figure 3.12: []{#_bookmark70 .anchor}Photographs of a window taken
with a camera polariser filter rotated to two different angles. In the
picture at left, the polariser is aligned with the polarisation angle
of the window reflection. In the picture at right, the polariser has
been rotated 90° eliminating the heavily polarised reflected sunlight.
[https://en.wikipedia.org/wiki/Brewster's_angle](https://en.wikipedia.org/wiki/Brewster%27s_angle)
>
By multiplying the left and the right terms of the previous equations
together we get
>
sin 2*θ~B~* = sin 2*θ*~2~ (3.47)
>
which gives as only possible solution *θ~B~* + *θ*~2~ = *π/*2 ( i.e.
the transmitted and reflected beams are perpendicular, see figure
[3.11)](#_bookmark69) and *θ~B~* = arctan [*n*2]{.underline} . It is
>
easy to show that *θ~B~ \< θ*1*lim*, i.e. the Brewster's angle is
always smaller than the limit angle for total reflection.

chap4 Total internal reflection

Let's consider the oblique incidence shown in figure
[3.8.](#_bookmark67) The transmitted field is given by
>
$`\overrightarrow{E}`$*t* = $`\overrightarrow{E}`$0*ei*\[(*k*~2~)*~x~x*+(*k*~2~)*~z~z*−*ωt*\] (3.48)
>
Using the boundary conditions we have previously found that
>
[]{#_bookmark71 .anchor}( 2 *ω*2 2

*k*~2~)*~x~* = (*k*~1~)*~x~* = *k*~1~ sin *θ*~1~ and *k*2 = *n*2*.*
(3.49)

*c*2
>
Using this relation we can write

(*k*~2~)2 = *k*^2^ − (*k*~2~)2 = *[ω]{.underline}* (*n*^2^ − *n*^2^ sin2
*θ*~1~) *.* (3.50)

When the incidence occurs at the limit angle *θ*~1~ = *θ*1*lim*, Snell
law gives *n*~2~ = *n*~1~ sin *θ*1*lim*. If now we increase the
incidence angle, we have *θ*~1~ *\θ*1*lim* and thus *n*~2~ *\< n*~1~
sin *θ*~1~ or *n*^2^ − *n*^2^ sin2 *θ*~1~ *\<* 0. Plugging this into
equation [3.49,](#_bookmark71) we
>
obtain:
>
2 1

(*k*~2~)

= *i[ω]{.underline}* j*n*^2^ sin2 *θ*~1~ − *n*^2^
>
(3.51)
>
i.e. (*k*~2~)*~z~* is purely imaginary and the transmitted wave
becomes:
>
$`\overrightarrow{E}`$*t* = $`\overrightarrow{E}`$0*ei*\[(*k*~2~)*~x~x*−*ωt*\]*e*−(*k*~2~)*~z~z* (3.52)
>
The wave has a propagating character in the *x* direction and an
evanescent character in the *z* direction. Let's consider the case of
a TE wave. The Fresnel relation gives
>
*r* = [*n*~1~ cos *θ*~1~ − *n*~2~ cos *θ*~2~]{.underline} =
[(*k*~1~)*~z~* − (*k*~2~)*~z~*]{.underline}
>
(3.53)

⊥ *n*~1~ cos *θ*~1~ − *n*~2~ cos *θ*~2~ (*k*~1~)*~z~* + (*k*~2~)*~z~*

As (*k*~2~)*~z~* is purely imaginary we have, as expected,
>
\|*r*~⊥~\| = 1 (3.54)
>
but also

*r*~⊥~ = \|*r*~⊥~\|*e^iφ^* = *e^iφ^* (3.55)

i.e. the reflected wave is totally reflected with a phase shift.

chap2 Oblique incidence onto a perfect conductor

We consider now a linearly polarised plane wave travelling in a
perfect dielec- tric making an oblique incidence onto a perfect
conductor. The case of vacuum is trivially obtained by setting the
refractive index *n* = 1. These calculations will serve as a basis for
the next chapter, which deals with rectangular metal- lic waveguides.
This is the reason why we adopt here a different frame with respect to
the previous sections. Once again we will deal with TE and TM waves
separately. As before, being the second medium a perfect conductor, no
electromagnetic fields can exists in it. We will deal only with the
incident and reflected fields.

chap5 TE Wave Incident fields

Considering the situation depicted in figure [3.13,](#_bookmark74) the
incident wavevector is given by:

0

1

**k***~i~* = −*k* cos *θ*

*,* (3.56)
>
1 *k* sin *θ*
>
$`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ fields form the picture (or using the plane wave rule
**[B]{.underline}***~i~*
>
we obtain[2](#_bookmark73):
>
= [**k***~i~ **×***]{.underline} $`\overrightarrow{E}`$*~i~* ),

*ω*

**[E]{.underline}***i* = []{#_bookmark73 .anchor}−*E*0 e*i* (−*ky* cos
*θ* + *kz* sin *θ* − *ωt*)**ˆe***x* (3.57)
>
2there is "-" sign in front of the fields as the chosen electric field
drawn in figure [3.13](#_bookmark74) is antiparallel to the *x* axis.

chap3 TE Wave TM Wave

![](media/image192.png)![](media/image194.png)

Figure 3.13: []{#_bookmark74 .anchor}Configuration des champs ´e.m
pour le mode TE.
>
and
>
$`\overrightarrow{B}`$ = 1
>
*i* 1
>
0
>
− *nE*0 sin *θ* e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
*,* (3.58)

chap5 Reflected fields

1 − *nE*0 cos *θ* e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
The reflected electric field **[E]{.underline}***~r~* = *E*~0~ e*i*
(*ky* cos *θ* + *kz* sin *θ* − *ωt*)**ˆe***~x~* is obtained by
repeating the same procedure. Considering that the incident and
reflected angles are the same, we have:

0

1

**k***~r~* = *k* cos *θ ,*

1

1 *k* sin *θ*
>
In addition, applying the boundary condition to the tangential
component of the electric field (which is here the total electric
field) we have *E~r~x* + *E~i~x* = 0. We finally obtain:

**[E]{.underline}***r* = *E*0e*i* (*ky* cos *θ* + *kz* sin *θ* −
*ωt*)**ˆe***x* (3.59)

and

$`\overrightarrow{B}`$ = 1
>
*r* 1
>
0
>
*nE*0 sin *θ* e*i* (*ky* cos *θ* + *kz* sin *θ ωt*) *c*
>
*.* (3.60)

chap5 Total fields

1 − *nE*0 cos *θ* e*i* (*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
We calculate now the total fields **[E]{.underline}**
>
= **[E]{.underline}** + **[E]{.underline}** , **[B]{.underline}** =
**[B]{.underline}** + **[B]{.underline}**
>
existing in
>
medium 1 for a TE wave:
>
⊥ *i r* ⊥ *i r*

**[E]{.underline}** = *E*0 (e*i* (*ky* cos *θ* + *kz* sin *θ* − *ωt*) −
e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)l **ˆe***x* =

= 2*iE*~0~ sin (*ky* cos *θ*) e*i* (*kz* sin *θ* − *ωt*)
>
**ˆe***~x~*
>
*.* (3.61)

\'- amp..li,.tude

., \'-
>
propa..g,.ation
>
., pola\'-r..is,.a.,tion
>
The total magnetic field is given by:
>
0
>
1

$`\overrightarrow{B}`$ = 1

2*inE*0 sin *θ* sin (*ky* cos *θ*) e*i* (*kz* sin *θ* − *ωt*)
>
*.* (3.62)

**-- [B]{.underline}**~⊥~

= [2*nE*~0~]{.underline} *\_u*
>
*c*
>
cos *θ* e*i* (*kz* sin *θ* − *ωt*), i.e. the magnetic
>
field is parallel to the interface.

-   The fields have a standing wave character along the *y* axis (see
    figure [3.14).](#_bookmark75) The positions of the nodes and
    antinodes plane for the electric field are given by:

    -   $`\overrightarrow{E}`$ = **0** for *y~n~*

*nπ k* cos *θ*

, *n* integer

-   **[E]{.underline}** \| is maximum for *y~p~*

= [(2*p* + 1)*π*]{.underline} , *p* integer.
>
*k θ*
>
![](media/image196.jpeg)same *z* components
>
![](media/image198.png) propagating wave // *z*
>
antiparallel *y* components
>
 standing wave // *y*
>
Figure 3.14: []{#_bookmark75 .anchor}The total electric field
amplitude of a TE wave upon oblique incident onto a perfect conductor.
The field has a propagation character along the *z* axis and a
standing wave character along the *y* axis. A node and an antinode
plane are displayed. The blue and red colours represent the minimum
and maximum of the field amplitude. You can easily reproduce this
pattern with water waves.

chap5 Poynting vector

To this aim it is convenient to revert to the real notation for the
fields:

$`\overrightarrow{E}`$~⊥~ = −2*E*~0~ sin (*ky* cos *θ*) sin (*kz* sin *θ* − *ωt*)
**ˆe***~x~,* (3.63)

and

$`\overrightarrow{B}`$ = 1
>
⊥ 1
>
0
>
−2 *c* sin *θ* sin (*ky* cos *θ*) sin (*kz* sin *θ* − *ωt*)
>
*.* (3.64)
>
1 −2 *c* cos *θ* cos (*ky* cos *θ*) cos (*kz* sin *θ* − *ωt*)
>
Calculating $`\overrightarrow{S}`$ = [$`\overrightarrow{E}`$⊥ ***×***]{.underline} [$`\overrightarrow{B}`$⊥]{.underline}

*µ*~0~

1

we obtain:

0

$`\overrightarrow{S}`$ = − *µ c θ*
>
*ky θ*
>
*kz θ* − *ωt*
>
*.* (3.65)

*nE*^2^

4 sin *θ µ*~0~*c*
>
sin2
>
(*ky*
>
cos

*θ*) sin2

(*kz*
>
sin

*θ* − *ωt*)

while its time average is:

($`\overrightarrow{S}`$)*~t~* =

2
>
[0]{.underline} sin *θ* sin2
>
*µ*~0~*c*
>
(*ky* cos *θ*) **ˆe***~z~* (3.66)
>
Power is therfore carried along the positive *z* direction and is null
on the nodal planes.

chap5 TM wave

The discussion is similar to the TE case with the role of $`\overrightarrow{E}`$ and
$`\overrightarrow{B}`$ exchanged. Referring to figure [3.13](#_bookmark74) we have
again for the wavevectors:
>
0 0
>
1 1
>
**k***~i~* = −*k* cos *θ*

1 *k* sin *θ*

*,* **k***~r~* = *k* cos *θ ,*
>
1 *k* sin *θ*

$`\overrightarrow{E}`$*~i~* = 1

1

0
>
*E*0 sin *θ* e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
*.* (3.67)

and

1 *E*0 cos *θ* e*i* (−*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
**[B]{.underline}** = − [*nE*0]{.underline} e*i* (−*ky* cos *θ* + *kz*
sin *θ* − *ωt*)**ˆe**

*,* (3.68)

Using the boundary condition for the tangential component of the
electric field *E~r~z* + *E~i~z* = 0 and the fact the field experience
total reflection, $`\overrightarrow{E}`$*~i~* = $`\overrightarrow{E}`$*~r~* we obtain:

$`\overrightarrow{E}`$*~r~* = 1

1

0
>
*E*0 sin *θ* e*i* (*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
*.* (3.69)
>
and
>
1 −*E*0 cos *θ* e*i* (*ky* cos *θ* + *kz* sin *θ* − *ωt*)
>
**[B]{.underline}** = − [*nE*0]{.underline} e*i* (*ky* cos *θ* + *kz*
sin *θ* − *ωt*)**ˆe**

*.* (3.70)

Finally, the total fields existing in medium 1 for a TM ( or *p*) wave
are given by:
>
$`\overrightarrow{E}`$ = 1
>
I/ 1
>
0
>
2*E*~0~ sin *θ* cos (*ky* cos *θ*) e*i* (*kz* sin *θ* − *ωt*)
>
*.* (3.71)
>
and
>
1 −2*iE*~0~ cos *θ* sin (*ky* cos *θ*) e*i* (*kz* sin *θ* − *ωt*)

**[B]{.underline}**~I/~

= −2 [*nE*0]{.underline} cos (*ky* cos *θ*) e*i* (*kz* sin *θ* −
*ωt*)**ˆe** *.* (3.72)
>
The same remarks made for the total TE wave can repeated here for the
total TM wave we the appropriate changes for the role of the $`\overrightarrow{E}`$ and
$`\overrightarrow{B}`$ fields.

**-- [B]{.underline}**~I/~

= − [2*nE*0]{.underline} e*i* (*kz* sin *θ* − *ωt*)**ˆe**

, i.e. the magnetic field is

parallel to the interface.

-   The electric fields have a standing wave character along the *y*
    axis (see figure [3.14).](#_bookmark75) The positions of the nodes
    and antinodes planes for the magentic fields are given by:

**-- [B]{.underline}**~I/~

= **0** for *y~n~*
>
= [(2*n* + 1)*π*]{.underline} , *n* integer.
>
*k θ*
>
**--** \|**[B]{.underline}**~I/~\| is maximum for *y~p~*
>
= *[pπ]{.underline}* , *p* integer.
>
*k θ*

Finally, the time-averaged Poytining vector is given by:

2*E*^2^*n*

[0]{.underline} 2

($`\overrightarrow{S}`$)*~t~* =

sin *θ* cos
>
*µ*~0~*c*
>
(*ky* cos *θ*) **ˆe***~z~* (3.73)
>
[]{#_bookmark76 .anchor}**Chapter 4**

