---
title: Expérience de Michelson-Morley
published: true
routable: true
visible: false
lessons:
    -
      slug: michelson-morley-from-classical-to-relativistic-universe
      name: THEORIE-EXP : Michelson-Morley
      order: 2
---

<!--Commandes Latex spécifiques
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
-->

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-1_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Colline

---------------------------

En cours de rédaction, tout un peu dans le désordre et pas le bon chapitrage pour l'instant


### EXPERIENCE FONDAMENTALE : MICHELSON-MORLEY (1887)

### **D'un Univers classique**<br>*à un Univers relativiste*   

<br><br>

#<p style="font-size:65%;text-align: center;">EXPÉRIENCE de MICHELSON-MORLEY :<br><br>La question posée à l'univers</p>

## <p style="font-size:85%;text-align: center;">Le contexte scientifique<br><br>de l'époque</p>

#### Une physique classique, conforme à l'intuition

##### La mécanique classique newtonienne :

* **L'espace et le temps** sont **indépendants**,    
ainsi des distances quelconques Δl $`\delta \mathscr{l}`$ peuvent être parcourue en des durées quelconques Δt $`\delta t`$, avec comme conséquence qu'il n'existe *pas de limite conceptuelle
aux vitesses* v = Δl / Δt $`\mathscr{v}=\delta \mathscr{l}\,/\,\delta t`$`$ qui peuvent être atteinte par un corps matériel accéléré constamment sous l'action d'une force appliquée constante.

* **L'espace et le temps** sont **universels**. Ainsi :    
   * la *distance entre deux points quelconques* de l'espace mesurée avec une règle rigide donnera la *même valeur pour tous les observateurs* réalisant la mesure, quelque-soit leur état de mouvement les uns par rapport aux autres.
   * la *durée entre deux points instants quelconques* mesurée avec une horloge donnera la *même valeur pour tous les observateurs* réalisant la mesure, quelque-soit leurs états de mouvement les uns par rapport aux autres.
   * *deux évènements simultanées* pour un observateur apparaitront *simultanés pour tous  les observateurs* quelque-soit leurs états de mouvement les uns par rapport aux autres, une fois que les durées de parcours de l'information entre chaque évènement et l'observateur auront été déduites.

* à faire, référentiels galiléens, référentiel de Copernic, référentiel absolu ...

* à faire ? Les transformations de Galilée

##### L'onde, comme perturbation d'un milieu matériel.

* L'**onde** ne se conçoit que comme la **perturbation d'un milieu matériel qui se propage**. Donc l'onde nécessite un milieu matériel. La *preuve expérimentale de la nature ondulatoire de la lumière* implique donc l'*existence d'un milieu support des ondes lumineuses nommé "éther"*, malgré les propriétés particulières de ce milieu comme le fait qu'il ne devait opposer aucune résistance aux déplacements des corps matériels.

## <p style="font-size:85%;text-align: center;">La question posée à l'univers</p>


* Les fondements de la mécanique classique et la présence de l'éther sont admis.   
  La question ne portait donc pas sur la remise en causes de ces bases, mais la mise en évidence du mouvement de la Terre par rapport à l'éther, et donc la détermination de l'état "immobile" par rapport à l'éther, la détermination précise du référentiel absolu newtonien identifié à l'éther.

* La *question* était donc :   
 <br>
**Quelle est le mouvement relatif de la Terre dans le référentiel absolue de l'éther ?**   
<br>
*formulée* avec les *concepts classiques admis* en utilisant le *langage mathématique associé*.

## <p style="font-size:85%;text-align: center;">La formulation de la question</p>


#### Une analogie avec une onde matérielle

Les concepts classiques sur l'espace, le temps, et la nature d'une onde, permettent de faire une analogie entre les ondes lumineuses et une onde matérielle, dont l'exemple le plus intuitif est la propagation des ondelettes à la surface d'un lac.

Dans cette analogie, la question est simple :   
<br>
" Comment mesurer la vitesse d'un bateau se déplaçant sur l'eau, en absence de tout repère visuel fixe 
(phare, maisons sur la rive, ...) et de tout système de positionnement par satellites ? "

<br>

---

#### Une première idée.

##### Simple et efficace !

* Sur le bateau un **marin jette dans l'eau** une *bouée attachée à une corde*.
 
* **Sur la corde**, de *petits flotteurs* sont fixés *à intervalles réguliers* de longueur $`\Delta l`$
et suffisamment proches,pour permettre à la corde de rester à la surface de l'eau. 

* La **bouée**, une fois dans l'eau et freinée par celle-ci, *s'immobilise* dans le lac. 

* Pour connaître la direction et le sens de déplacement du bateau par rapport au lac, 
le **marin déroule la corde** de façon qu'à chaque instant *elle décrive un segment de droite*
joignant la bouée au bateau.

* Pour que la bouée, rattachée par la corde au bateau, ne soit pas tractée par celui-ci
et reste bien immobile, le marin déroule la corde de façon à ce que la corde *ne soit jamais tendue*. 

* Le **marin compte alors le nombre de flotteurs** espacés de $`\Delta l`$ qu'il déroule
*sur un intervalle de temps $`\Delta t`$*.   

* Le marin *en déduit la vitesse du bateau*.    

!!! *Exemple :*.  
!!! S'il compte soixante unité de longueur sur une durée de trois minute, il en déduit que la vitesse
!!! du bateau par rapport au lac est de 
!!! $`\mathscr{v}=\dfrac{60}{3} = 20 \text{ u/min}`$ unité de longueur "u" par minute.<br>
!!!
!!! Si la distance entre deux marques consécutives sur la corde était de cinq mètre,
!!! la vitesse du bateau serait de  
!!! $`\mathscr{v}= 100 \text{ m/min}`$ soit $`\mathscr{v}= 6 \text{ km/h}`$._

##### Mais impossible ...

Le principale problème pour appliquer cette procédure aux ondes lumineuses est que l'éther,
milieu de propagation supposée de la lumière, ne s'oppose pas, ne freine pas les corps matériels,
comme le montre la stabilité des orbites planétaires autour du soleil, stabilité qui permet de
prédire la position d'une planète des années à l'avance avec la mécanique classique. Ainsi dans
une expérience analogue à celle décrite ci-dessus mais appliquée aux ondes lumineuses, le corps
matériel jeté jouant le rôle de la bouée ne serait pas freiné. 
_à faire, lien avec le mouvement rectiligne uniforme dans un référentiel galiléen en mécanique classique._

<br>

---

#### Une deuxième idée.

##### Hyper-géniale !

Animation à faire, dérivée du pptx de l'ancien MO astrophysique

* **Trois bateaux nommés A, B et C** naviguent sur un lac en gardant leurs positions relatives constantes,
et tels que les *segments [AB] et [AC]* soient *perpendiculaires* et d'*égales longueurs $`\mathbf{L}`$*.   
<br>
**Sur chaque bateau** un *marin est prêt à jeter une pierre* dans l'eau.   

<br>
* Le **marin du bateau A**, muni d'un chronomètre, *jette sa pierre à un instant $`\mathbf{t_{A}}`$*. 
<br>   
La pierre perturbe la surface du lac, générant une onde sous forme d'une **vaguelette circulaire** 
*centrée* sur la position du *bateau A  à l'instant $`\mathbf{t_{A}}`$*, et dont le 
rayon croît à la vitesse c, vitesse de propagation de l'onde à la surface du lac.

<br>
* La **vaguelette atteint**
   * le *bateau B à l'instant $`\mathbf{t_{AB}}`$* 
   * le *bateau C à l'instant $`\mathbf{t_{AC}}`$*    
<br>
   
* **Sur chacun des bateaux B et C**, un *marin* qui guettait 
l'arrivée de la vaguelette, à son tour *jette une pierre dès réception* de la vaguelette. Ainsi, en retour 
se propagent deux vageulettes circulaires dont les rayons croissent à la vitesse c :
   * une **vaguelette circulaire** *centrée* sur la position du *bateau B à l'instant $`\mathbf{t_{AB}}`$*,
   * une **vaguelette circulaire**, *centrée* sur la position du *bateau C à l'instant $`\mathbf{t_{AC}}`$*,   

<br>
* La **vaguelette** issue **du bateau B** *atteint le bateau A* à l'instant *$`\mathbf{t_{ABA}}`$*,   
La **vaguelette** issue **du bateau C** *atteint le bateau A* à l'instant *$`\mathbf{t_{ACA}}`$*.    
<br>
Le *marin du bateau A* note les instants $`\mathbf{t_{ABA}}`$ et $`\mathbf{t_{ACA}}`$, et *calcule* les **durées des allers-retours**,   
   * **$`\mathbf{\Delta t_{ABA}}`$** *$`\mathbf{\,= t_{ABA}-t_A}`$*,
   * **$`\mathbf{\Delta t_{ACA}}`$** *$`\mathbf{\,= t_{ACA}-t_A}`$*. 

<br>
* Le **marin peut déduire** alors la *vitesse de déplacement* des bateaux en comparant ces durées de parcours :
   * si **les trois bateaux sont immobiles**, alors les *distances aller-retour d<sub>ABA</sub>
   <!--$`d_{ABA}`$* entre les bateaux A et B, *et d<sub>ACA</sub> <!--$`d_{ACA}`$-->* entre les bateaux A et C, 
   sont égales et *sont parcourues en des temps égaux* t<sub>ABA</sub> - t<sub>A</sub>  <!--$`t_{ABA}-t_A`$-->
   et t<sub>ACA</sub> - t<sub>A</sub>  <!--$`t_{ACA}-t_A`$--> par l'onde se propageant à la vitesse c
   à la surface de l'eau.
   * si **les bateaux se déplacent ensemble à une vitesse v** <!--$`\mathscr{v}`$-->, alors cette vitesse 
*v est déductible* par notre marin un peu physicien, s'il connaît la vitesse de propagation des vaguelettes.


##### Et réalisable

L'*application de ce principe* à la mesure de la vitesse de la Terre relativement à l'éther est *directement transposable* :
c'est l'**expérience historique de Michelson-Morley**.

* Un faisceau lumineux parallèle arrive sous un angle d'incidence de 45° sur une lame séparatrice S. 

* La **séparatrice**, centrée en A et jouant le *rôle du bateau A*, scenide le faisceau incident en deux faisceaux 
d'égales intensités, l'un résultant d'une réflexion à sa surface de la séparatrice, l'autre la traversant

* Un **miroir fixe M<sub>1</sub>** centré en B et jouant le *rôle du bateau B*, situé à une distance L de la séparatrice,
  reçoit le faisceau réflechi par la séparatrice sous une incidence normale et le réfléchit à nouveau.

* Un **miroir fixe M<sub>2</sub>** centré en C et jouant le *rôle du bateau C*, situé à la même distance L de la séparatrice,
reçoit le faisceau transmis sous une incidence normale et le réflechit.

<br>

## <p style="font-size:85%;text-align: center;">Description du dispositif expérimental :<br>Interféromètre de Michelson-Morley</p>

animation à faire

<br>

## <p style="font-size:85%;text-align: center;">Calculs classiques<br> pour interpréter la réponse</p>

#### Introduction aux calculs

* La **mise en évidence du mouvement de la Terre** par rapport à l'éther revient à 
*mesurer la différence de temps de parcours $`\Delta t`$* entre les deux faisceaux de l'interféromètre.

* Dans l'interféromètre, appelle :
    * **faisceau 1** le faisceau qui est *réfléchi par le miroir M<sub>1</sub>*
    * **faisceau 2** le faisceau qui est *réfléchi par le miroir M<sub>2</sub>*   

* Pour obtenir le **$`\Delta t`$ maximum**, nous supposons que le *faisceau 1* 
 est aligné *en direction du mouvement de la Terre*,   
 et soit **d<sub>ACA</sub>** la *longueur de son trajet aller-retour* depuis la séparatrice.
 
* L'éther ne pouvant qu'exister et traduisant le référentiel absolu de Newton, le *calcul* 
 peut se faire naturellement dans **deux référentiels** :   
   * le *référentiel de l'interféromètre*
   * le *référentiel de l'éther*

<br>

#### Calculs dans le<br>Référentiel de l'Interféromètre

##### Durées aller-retour des faisceaux

1. **Faisceau 1 (parallèle à la direction du mouvement) :**
   - Aller : Le faisceau se déplace dans la direction du mouvement. La vitesse effective du faisceau est $`c - V`$.
   - Retour : Le faisceau revient dans la direction opposée. La vitesse effective du faisceau est $`c + V`$.
   - Temps total : $`t_2 = \frac{L}{c - V} + \frac{L}{c + V} = \frac{2Lc}{c^2 - V^2}`$

2. **Faisceau 2 (perpendiculaire à la direction du mouvement) :**
   - Aller : Le faisceau se déplace perpendiculairement à la direction du mouvement. La distance parcourue est $`L`$.
   - Retour : Le faisceau revient sur la même distance $`L`$.
   - Temps total : $`t_1 = \frac{2L}{c}`$

##### Retard entre les Faisceaux

Le retard $`\Delta t`$ entre les deux faisceaux est donné par la différence de temps de trajet :

$`\Delta t = t_2 - t_1 = \frac{2Lc}{c^2 - V^2} - \frac{2L}{c} = \frac{2LV^2}{c(c^2 - V^2)}`$

<br>

#### Calculs dans le<br>Référentiel de l'Éther

Dans le référentiel de l'éther, nous devons tenir compte de la composition des vitesses.

<br>

##### Trajet des Faisceaux

1. **Faisceau 1 (perpendiculaire à la direction du mouvement) :**
   - Aller : Le faisceau se déplace perpendiculairement à la direction du mouvement. La distance parcourue est $`L`$.
   - Retour : Le faisceau revient sur la même distance $`L`$.
   - Temps total : $`t_1 = \frac{2L}{\sqrt{c^2 - V^2}}`$

2. **Faisceau 2 (parallèle à la direction du mouvement) :**
   - Aller : Le faisceau se déplace dans la direction du mouvement. La vitesse effective du faisceau est $`c - V`$.
   - Retour : Le faisceau revient dans la direction opposée. La vitesse effective du faisceau est $`c + V`$.
   - Temps total : $`t_2 = \frac{L}{c - V} + \frac{L}{c + V} = \frac{2Lc}{c^2 - V^2}`$

##### Retard entre les Faisceaux

Le retard $`\Delta t`$ entre les deux faisceaux est donné par la différence de temps de trajet :

$`\Delta t = t_2 - t_1 = \frac{2Lc}{c^2 - V^2} - \frac{2L}{\sqrt{c^2 - V^2}}`$

#### Comparaison des Retards

Pour vérifier si les deux expressions du retard $`\Delta t`$ sont équivalentes, comparons-les :

1. **Expression dans le référentiel de l'interféromètre :**
   $`\Delta t = \frac{2LV^2}{c(c^2 - V^2)}`$

2. **Expression dans le référentiel de l'éther :**
   $`\Delta t = \frac{2Lc}{c^2 - V^2} - \frac{2L}{\sqrt{c^2 - V^2}}`$

Pour vérifier l'équivalence, simplifions l'expression dans le référentiel de l'éther :

$`\Delta t = \frac{2Lc}{c^2 - V^2} - \frac{2L}{\sqrt{c^2 - V^2}} = \frac{2Lc - 2L\sqrt{c^2 - V^2}}{c^2 - V^2}`$

En multipliant le numérateur et le dénominateur par $`c + \sqrt{c^2 - V^2}`$ :

$`\Delta t = \frac{(2Lc - 2L\sqrt{c^2 - V^2})(c + \sqrt{c^2 - V^2})}{(c^2 - V^2)(c + \sqrt{c^2 - V^2})}`$

Simplifions le numérateur :

$`(2Lc - 2L\sqrt{c^2 - V^2})(c + \sqrt{c^2 - V^2}) = 2Lc^2 + 2Lc\sqrt{c^2 - V^2} - 2Lc\sqrt{c^2 - V^2} - 2L(c^2 - V^2) = 2Lc^2 - 2Lc^2 + 2LV^2 = 2LV^2`$

Le dénominateur devient :

$`(c^2 - V^2)(c + \sqrt{c^2 - V^2}) = (c - V)(c + V)(c + \sqrt{c^2 - V^2}) = (c - V)(c^2 + c\sqrt{c^2 - V^2} + Vc + V\sqrt{c^2 - V^2})`$

Cependant, nous pouvons simplifier directement en remarquant que :

$`\Delta t = \frac{2LV^2}{(c^2 - V^2)(c + \sqrt{c^2 - V^2}) / (c + \sqrt{c^2 - V^2})} = \frac{2LV^2}{c(c^2 - V^2)}`$

Ainsi, les deux expressions du retard $`\Delta t`$ sont bien équivalentes, sans avoir besoin de faire l'approximation $`V \ll c`$. Cela montre que le retard entre les faisceaux est le même dans les deux référentiels, comme attendu en physique classique.



## <p style="font-size:85%;text-align: center;">La réponse de l'univers</p>

A faire

<br>

## <p style="font-size:85%;text-align: center;">L'interprétation relativiste</p>

! *Note :* les succès expérimentaux ultérieures de l'interprétation relativiste.<br>
! A faire

!! *Pour aller plus loin :* De la relativité restreinte à la relativité générale<br>
!! A faire
