---
title: Ecuaciones de Maxwell, fundamento del electromagnetismo.
published: true
routable: true
visible: false
lessons:
    - slug: maxwell-equations-es
      name: LINEAL - Ecuaciones de Maxwell
      order: 2
---

<!--MétaDonnée : ... -->

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

*Curso en construcción*, **no validado**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-ES_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-3_L1200.jpg)<details>
<summary>Etapa 7 : Probado con estudiantes</summary>  
1. Lluvia de ideas
2. Estructuración
3. Escribiendo : 1/3
4. Escribiendo : 2/3
5. Escribiendo : 3/3
6. Revisión 
7. Probado con estudiantes.
8. Validado, aún incompleto
9. Validado, con base suficiente
10. Validado, operativo, en constante mejora.
</details>

<!--MétaDonnée : ... -->

##### Caminata Montaña :&nbsp;física

---------------------------

### ELECTROMAGNETISMO

### **Las ecuaciones de Maxwell**<br>*y el campo electromagnético $`(\overrightarrow{E}\,,\overrightarrow{B})`$*

<br><br>

RESUMEN
: ---

  *Dominio de validez*:
  
  Muy general. En el vacío, e incluso en la materia si la escala de observación no es mesoscópica,
  sino atómica.
  Sin embargo, una descripción más exacta de la materia a escala atómica
  requiere el uso de la física cuántica.

  Atención: Las expresiones a continuación solo son válidas en el Sistema Internacional de Unidades $`SI`$, antes $`MKS`$.

  ---

  *Forma local de las ecuaciones de Maxwell*

  * En todo punto del espacio y en todo instante:
  <br>
  $`\left\{\begin{array}{l}
  \text{div } \overrightarrow{E} = \dfrac{\rho}{\epsilon_0}\quad \small{(Maxwell-Gauss)}\\
  \text{div } \overrightarrow{B} = 0\quad \small{(Maxwell-Thomson)}\\
  \overrightarrow{\text{rot}} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}\quad\small{(Maxwell-Faraday)}\\
  \overrightarrow{\text{rot}} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\\
  \hspace{3,5cm}\small{(Maxwell-Ampère)}
  \end{array}\right.`$
  <br>
  con $`\dens`$ densidad volumétrica de carga
  &nbsp;&nbsp; y $`\overrightarrow{j}`$ vector densidad volumétrica de corriente.

  * $`\Longrightarrow`$ la conservación de la carga:
    $`\text{div}\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0`$

  * $`\Longrightarrow`$ la propagación en el vacío
    de la onda electromagnética (EM), parte variable del campo electromagnético:
    <br>
    $`\left\{\begin{array}{l}
    \Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}\\
    \Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}
    \end{array}\right.`$
    <br>
    a la celeridad $`c=299\,792\,458\, \text{m}\,\text{s}^{-1}\approx 3\times 10^8\, \text{m}\,\text{s}^{-1}`$,
    constante fundamental de la naturaleza.

  * $`\Longrightarrow`$ el campo EM contiene energía,
    en densidad volumétrica:
    $`\small{\dens}_{energ.EM}`$$`\; = \dfrac{\epsilon_0\,\overrightarrow{E}\cdot\overrightarrow{E}}{2}+\dfrac{\overrightarrow{B}\cdot\overrightarrow{B}}{2\mu_0}`$

  * $`\Longrightarrow`$ todo $`\overrightarrow{dS}`$ recibe la potencia EM:
    $`d\overrightarrow{\mathcal{P}}_{EM}=\overrightarrow{\Pi}\cdot\overrightarrow{dS}`$
    con $`\overrightarrow{\Pi}=\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}`$ vector de Poynting.

  * $`\Longrightarrow`$ el campo EM cede energía a la materia por efecto Joule:
    $`\mathcal{P}_{cedida} = \overrightarrow{j}\cdot\overrightarrow{E}\,d\tau`$

  * $`\Longrightarrow`$ toda partícula cargada acelerada genera una onda electromagnética.  

<br>

#### ¿Cuál fue el trabajo de Maxwell?

* *Hasta mediados del siglo XIV*, **electricidad, magnetismo y óptica** se estudiaban en *áreas científicas distintas*.

* Sin embargo, la *observación de fenómenos naturales y experimentos de laboratorio* mostró una
**interacción incomprendida entre electricidad, magnetismo** e incluso **óptica**.
  * Natural: el rayo puede cargar objetos metálicos, imantar el hierro y crear un relámpago.
  * Experimentos:
    - Una corriente desvía la aguja de una brújula.
    - El movimiento de un imán genera una corriente.

* Buen matemático, **Maxwell** *sintetizó los resultados experimentales* de su época,
que se resumen en 4 ecuaciones, las *ecuaciones de Maxwell*.

* Estas 4 ecuaciones **unifican electricidad, magnetismo y óptica** dentro del electromagnetismo,
y amplían la óptica a un *nuevo mundo: las ondas electromagnéticas*.

![Imagen de las ecuaciones de Maxwell](Maxwell-equation-es.png)
_Maxwell modificó dos de las ecuaciones de la electrostática y la magnetostática,
introduciendo términos de acoplamiento entre E y B,
y revolucionó así la física._

#### ¿Por qué decimos "ecuaciones" y no "teoremas" de Maxwell?

* Las **4 ecuaciones de Maxwell** *no están demostradas*, por lo que no constituyen teoremas.
* Son *planteadas y supuestas verdaderas*, **son postulados**.

<br>

---

<br>

#### ¿Qué son estas 4 ecuaciones de Maxwell?

##### En forma local
*(fundamental, conocer)*

* Dos **expresiones de la divergencia** de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ *inalteradas con respecto al caso estacionario* (electrostática y magnetostática):

  * **$`\large{\mathbf{div \overrightarrow{E} = \dfrac{\rho}{\epsilon_0}}}`$** &nbsp;&nbsp;&nbsp;(ec. *Maxwell-Gauss*).

  * **$`\large{\mathbf{div \overrightarrow{B} = 0}}`$** &nbsp;&nbsp;&nbsp;(ec. *Maxwell-Thomson*).

* Dos **expresiones del rotacional** de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ que *cambian y acoplan los campos $`\mathbf{\overrightarrow{E}}`$ y $`\mathbf{\overrightarrow{B}}`$*:

  * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}}`$**
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(ec. *Maxwell-Faraday*).

  * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}}`$**
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(ec. *Maxwell-Ampère*).

* Donde:
  * $`\rho=\rho^{3D}`$ es la densidad volumétrica de carga.
  * $`\overrightarrow{j}=\overrightarrow{j}^{3D}`$ es el vector densidad volumétrica de corriente.

------------------

* Y estas ecuaciones *reescritas con el operador nabla: $`\mathbf{\nabla}`$*:

  * **$`\mathbf{\nabla\cdot\overrightarrow{E}=\dfrac{\rho}{\epsilon_0}}`$**

  * **$`\mathbf{\nabla\cdot\overrightarrow{B}=0}`$**

  * **$`\mathbf{\nabla\land\overrightarrow{E}= -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**

  * **$`\mathbf{\nabla\land\overrightarrow{B}= \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**

------------------

##### En forma integral

_(saber redemostrar)_

* **Se deducen de las ecuaciones locales**, con la ayuda de :
  * el *teorema de Ostrogradski* :
    $`\forall \overrightarrow{X}(\overrightarrow{r})`$ :
    *$`\displaystyle\iiint_{\tau} \text{div}\,\overrightarrow{X} \cdot d\tau = \displaystyle
\oiint_{S\leftrightarrow\tau} \overrightarrow{X}\cdot\overrightarrow{dS}`$*
  * el *teorema de Stokes* :
    $`\forall \overrightarrow{X}(\overrightarrow{r})`$ :
    *$`\displaystyle\iint_{S} \;\overrightarrow{rot}\,\overrightarrow{X} \cdot dS
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$*.


-----------

* **Ecuación de Maxwell-Gauss**:

  En todo instante $`t`$, y para todo volumen $`\tau`$:

  * $`\forall \overrightarrow{r},\;`$ *$`\mathbf{div \overrightarrow{E} = \dfrac{\rho}{\epsilon_0}}`$*
  $`\Longrightarrow \iiint_{\tau} \text{div } \overrightarrow{E}\,d\tau = \iiint_{\tau}\dfrac{\rho}{\epsilon_0}\,d\tau`$

  * $`\left.\begin{array}{l}
  \iiint_{\tau} \text{div } \overrightarrow{E}\,d\tau = \iiint_{\tau}\dfrac{\rho}{\epsilon_0}\,d\tau \\
  \iiint_{\tau} \text{div}\,\overrightarrow{E} \cdot d\tau = \displaystyle
  \oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  **$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS}
  = \dfrac{1}{\epsilon_0} \cdot \iiint_{\tau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0}}`$**

------------

* **Ecuación de Maxwell-Thomson**:

  En todo instante $`t`$, y para todo volumen $`\tau`$:

  * $`\forall \overrightarrow{r},\;`$ *$`\mathbf{div \overrightarrow{B} = 0}`$*
  $`\Longrightarrow \iiint_{\tau} \text{div } \overrightarrow{B}\,d\tau = 0`$

  * $`\left.\begin{array}{l}
  \iiint_{\tau} \text{div } \overrightarrow{B}\,d\tau = 0 \\
  \iiint_{\tau} \text{div}\,\overrightarrow{B} \cdot d\tau = \displaystyle
  \oiint_{S\leftrightarrow\tau} \overrightarrow{B}\cdot\overrightarrow{dS}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  **$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\tau} \overrightarrow{B}\cdot\overrightarrow{dS}= 0}`$**

-----------------

* **Ecuación de Maxwell-Faraday**:

  En todo instante $`t`$,
  y para toda superficie $`S`$ abierta y orientada, inmóvil y indeformable, que se apoya en un contorno $`\Gamma`$
  (por lo tanto también inmóvil e indeformable),
  con orientación compatible con la de $`S`$ según la regla de la mano derecha:

  * $`\forall \overrightarrow{r},\;`$ *$`\mathbf{\overrightarrow{rot} \,\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$*
  $`\Longrightarrow \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big)`$
  <br>

  * $`\left.\begin{array}{l}
  \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big) \\
  \text{Newton: espacio y tiempo independientes}, \\
  \text{el orden derivación/integración no importa}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  $`\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big)`$
  <br>

  * $`\left.\begin{array}{l}
  \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big) \\
  \iint_{S} \;\overrightarrow{rot}\;\overrightarrow{E} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  **$`\begin{array}{l}
  &nbsp; \\
  \mathbf{\displaystyle\quad\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}= -\dfrac{d}{dt}\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}}
  \end{array}`$**
  <br>
  * Esta ecuación juega un *papel importante en los fenómenos de inducción de Neumann*.   
  _La cantidad_ $`\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}$,
  _de denominación histórica imperfecta "fuerza electromotriz (fem)", homogénea a una tensión, es el origen de una corriente_
  _eléctrica que atraviesa el contorno $`\Gamma`$ si este representa un circuito conductor._

---------------

* **Ecuación de Maxwell-Ampère**:

  En todo instante $`t`$,
  y para toda superficie $`S`$ abierta y orientada, fija e indeformable, que se apoya en un contorno $`\Gamma`$
  con orientación compatible con la de $`S`$ según la regla de la mano derecha:
  <br>

  $`\forall \overrightarrow{r},\;`$ *$`\mathbf{\overrightarrow{rot} \,\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$*
  $`\Longrightarrow`$ $` \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS}`$
  <br>

  $`\left.\begin{array}{l}
  \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS} \\
  \text{Newton: espacio y tiempo independientes},\\
  \text{el orden derivación/integración no importa}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  $`\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS}`$ $`\; = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
  \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}`$
  <br>

  $`\left.\begin{array}{l}
  \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} \\
  \quad = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
  \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS} \\
  \iint_{S} \;\overrightarrow{rot}\;\overrightarrow{B} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}
  \end{array}\right\}`$
  $`\Longrightarrow`$

  **$`&nbsp;\mathbf{\displaystyle\;\,\oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}}`$
  $`\;\mathbf{\displaystyle= \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +\mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}}`$**

<br> 

------------

<br>

#### ¿Por qué hablamos de campo electromagnético?

* Las 2 ecuaciones de acoplamiento de $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ implican
que **variables, $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ no pueden existir el uno sin el otro**.

* El término *$`\dfrac{\partial\overrightarrow{B}}{\partial t}\ne 0`$ implica $`\overrightarrow{E}\ne \overrightarrow{0}`$*
* El término *$`\dfrac{\partial\overrightarrow{E}}{\partial t}\ne 0`$ implica $`\overrightarrow{B}\ne \overrightarrow{0}`$*

<br>

---

<br>

#### ¿Qué dicen las ecuaciones de Maxwell sobre la conservación de la carga?

##### Ley de conservación de la carga eléctrica

* En la materia, las **cargas eléctricas** son transportadas por los *electrones* y
los *protones* de los núcleos atómicos. *En física clásica*, estas partículas existen,
y **no pueden ni surgir de la nada, ni desaparecer**.

* Así, el **principio de conservación de la carga** eléctrica puede resumirse en una frase:
<br>
! *En todo volumen del espacio y durante un intervalo de tiempo dado, la carga eléctrica*
! *que entra en este volumen menos la carga eléctrica*
! *que sale del mismo es igual a la variación de la carga dentro del volumen.*
<br>
Esto se traduce en *escritura matemática* por la **expresión integral**:
<br>
Para toda superficie cerrada $`S`$ que delimita un volumen macroscópico $`\tau`$,
<br>
**$`\mathbf{\oiint_{S\leftrightarrow\tau}\overrightarrow{j}\cdot\overrightarrow{dS}+\iiint_{\tau}\dfrac{\partial\rho}{\partial t}\cdot d\tau=0}`$**
<br>
que se enuncia:
<br>
! *El flujo del vector densidad de corriente volumétrica a través de una superficie cerrada,*
! *es igual a la derivada temporal de la carga total contenida en el interior de esta superficie cerrada.*

![Ley de conservación de la carga](charge-conservation-law-L1200.jpg)

* Esta igualdad, al ser válida para cualquier volumen de integración, implica que
la igualdad se aplica a los integrandos mismos.
$`\Longrightarrow`$ La ley de conservación también tiene una **expresión local**, válida en todo punto del espacio, que se escribe:
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \rho}{\partial t}=0}`$**

<br><br>

![Conservación de la carga](charge-conservation-1-L1200.jpg)

<br>

##### Estudio de las ecuaciones de Maxwell

* **Partamos** de la combinación de operadores notable, válida para todo campo vectorial $`\overrightarrow{U}`$,
que se enuncia    
*"La divergencia del rotacional de un campo vectorial siempre es nula."*   
<br>
$`\forall \overrightarrow{X}\big(\overrightarrow{r},t\big)\;,`$*$`\quad \mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{X}\big)=0}`$*.    
<br>
Apliquémosla al campo de inducción magnética $`\overrightarrow{B}`$ :   
<br>
**$`\mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{B}\big)=0}`$**.

* La *ley de Maxwell-Ampère*
$`\overrightarrow{rot}\,\overrightarrow{B}=\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$   
permite escribir:   
<br>
**$`\mathbf{div\Big(\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0}`$**   

* Al dividir los términos de la derecha y la izquierda por $`\mu_0`$, la ecuación se simplifica :   
<br>
$`div\Big(\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$   

* La ecuación ya contiene $`\overrightarrow{j}`$, busco hacer aparecer $`\dens`$.
Para ello, busco hacer aparecer $`div\,\overrightarrow{j}`$ para luego utilizar la ley de Maxwell-Gauss.
<br>
$`div\,\overrightarrow{j} + div\Big(\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

* En el marco de la *física clásica, espacio y tiempo son independientes*,
el orden de derivación por una variable espacial y una variable temporal no importa:
<br>
*$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right)`$*   
- El operador divergencia solo está constituido por derivadas parciales de variables espaciales.
- $`\dfrac{\partial}{\partial t}`$ es una derivada parcial de la variable tiempo.

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*$`\Longrightarrow\quad div\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}\left(div\right)`$*.   
<br>
Obtenemos:
<br>
**$`\mathbf{div\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}\left(div\,\overrightarrow{E}\right)=0}`$**   

* Usando la *ley de Maxwell-Gauss $`div\,\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}`$*   
obtenemos la **ecuación de conservación local de la carga** eléctrica en régimen variable (por lo tanto siempre verificada):
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0}`$**   

! *Las ecuaciones de Maxwell contienen e implican la conservación de la carga eléctrica.*   

<br>

* Podemos *integrar esta igualdad local* sobre un volumen $`\tau`$ cualquiera:
<br>
$`\displaystyle\iiint_{\tau} \Big(div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}\Big)\,d\tau=0`$   
<br>
*$`\displaystyle\iiint_{\tau} div\,\overrightarrow{j}\,d\tau+\iiint_{\tau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$*   

* El *teorema de Ostrogradski* (= teorema *de la divergencia*) precisa que para todo campo
vectorial $`\overrightarrow{U}`$ y para todo volumen $`\tau`$,
*$`\displaystyle\iiint_{\tau} div\,\overrightarrow{U}\,d\tau=\oiint_S \overrightarrow{U}\cdot dS`$*,   
$`S`$ siendo la superficie cerrada que delimita el volumen $`\tau`$.
<br>
*Aplicado al primer término* de la igualdad, obtenemos:
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} + \iiint_{\tau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$**.

* Al observar de nuevo que *espacio y tiempo son independientes en física clásica*, el orden de derivación o integración por una variable espacial y una variable temporal no importa:
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{\partial}{\partial t} \left(\iiint_{\tau}\dens \,d\tau\right)=0`$**.

* Al constatar que *$`\displaystyle\iiint_{\tau}\dens \,d\tau`$ es la carga total $`Q_{int}`$*
contenida en el volumen $`\tau`$, obtenemos la **expresión integral de la ley de conservación** de la carga:
<br>
**$`\mathbf{\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{dQ_{int}}{dt}=0}`$**.

<br> 

------------

<br>

#### ¿Puede el campo electromagnético ceder energía a la materia?

##### Potencia cedida a un portador de carga

* La **sensibilidad** de una partícula a la **interacción electromagnética** se cuantifica
por el parámetro llamado *carga* eléctrica de la partícula.

* La fuerza que describe la *acción de un campo electromagnético $`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`*
sobre una partícula de carga $`q`$ es la **fuerza de Lorentz**, cuya expresión es:
<br>
**$`\overrightarrow{F}_{\,Lorentz}=q\Big(\overrightarrow{E}+\overrightarrow{v}\land\overrightarrow{B}\Big)`$**
<br>
donde $`\overrightarrow{v}`$ es el vector velocidad de la partícula en el referencial de inercia de la observación.

* *Durante un desplazamiento elemental $`\overrightarrow{dl}`* de la partícula en el campo electromagnético
$`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`*, el **trabajo de la fuerza de Lorentz** se escribe:
<br>
**$`d\mathcal{W}_{\,Lorentz}=\overrightarrow{F}_{Lorentz}\cdot\overrightarrow{dl}`$**,
<br>
es decir,
<br>
$`\begin{align}
d\mathcal{W}_{\,Lorentz}&=q\Big(\overrightarrow{E}+\overrightarrow{v}\land\overrightarrow{B}\Big)\cdot\overrightarrow{dl}\\
&\\
&= q\Big(\overrightarrow{E}\cdot\overrightarrow{dl}\Big)+ q\Big(\overrightarrow{v}\land\overrightarrow{B}\cdot\overrightarrow{dl}\Big)\\
&\\
&= q\,\overrightarrow{E}\cdot\overrightarrow{dl} + q\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big) \\
\end{align}`$
<br>
donde $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)`$ es el producto mixto de la secuencia de los tres vectores.

* Los *vectores $`\overrightarrow{v}`$ y $`\overrightarrow{dl}=\overrightarrow{v}\,dt`* son *colineales*, el producto mixto
es nulo:
<br>
*$`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$*,

!!!!
!!!! <details markdown=1>
!!!! <summary>Recordatorios sobre el producto mixto</summary>
!!!! El producto mixto de tres vectores $`\vec{a}\,,\vec{b}\,,\vec{c}`$, denotado $`(\vec{a}\,,\vec{b}\,,\vec{c})`$
!!!! está definido por:
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{a}\land\vec{b})\cdot\vec{c}`$.
!!!! Es fácil demostrar que es invariante por permutación circular de los 3 vectores:
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{b}\,,\vec{c}\,,\vec{a})=(\vec{c}\,,\vec{a}\,,\vec{b})`$.
!!!! Es, por lo tanto, un número real, cuyo valor absoluto se identifica con el volumen del paralelepípedo
!!!! formado por los tres vectores $`\vec{a}\,,\vec{b}\,,\vec{c}`$.
!!!!
!!!! En el caso estudiado, al menos dos vectores del producto mixto $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)$
!!!! son colineales, ya que $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$.
!!!! Por lo tanto, puedo asegurar que este producto mixto es nulo,
!!!! * ya sea observando que tres vectores, de los cuales dos son colineales, se inscriben en un mismo plano (2D)
!!!! y, por lo tanto, el volumen (3D) construido por estos tres vectores es nulo:
!!!! $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! * ya sea utilizando la invariancia del producto mixto por permutación circular,
!!!! $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=\Big(\overrightarrow{dl},\overrightarrow{v},\overrightarrow{B}\Big)`$
!!!! $`=dt\times\Big(\overrightarrow{v},\overrightarrow{v},\overrightarrow{B}\Big)`$
!!!! y observando que el producto vectorial de dos vectores colineales es nulo:
!!!! $`\big\Vert\overrightarrow{v}\land\overrightarrow{v}\big\Vert=\big\Vert\overrightarrow{v}\big\Vert\cdot\big\Vert\overrightarrow{v}\big\Vert\cdot \sin 0=0`$
!!!! $`\Longrightarrow \overrightarrow{v}\land\overrightarrow{v}=\overrightarrow{0}`$
!!!! $`\Longrightarrow \Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! </details>

* $`\Longrightarrow`$ el **trabajo de la fuerza de Lorentz** se simplifica:
<br>
**$`d\mathcal{W}_{\,Lorentz} = q\,\overrightarrow{E}\cdot\overrightarrow{dl}`$**

! *Nota:*
!
! La *fuerza magnética $`\overrightarrow{F}_{\,magn.}=q\,\overrightarrow{v}\land\overrightarrow{B}`*,
! por naturaleza perpendicular al vector velocidad $`\overrightarrow{v}`$ y, por lo tanto, al vector desplazamiento
! elemental $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$ en todo punto de la trayectoria de la partícula
! de carga $`q`$, *no realiza trabajo*:
!
! $`\mathbf{d\mathcal{W}_{\,magn} = \overrightarrow{F}_{magn}\cdot \overrightarrow{dl}=0}`$
!
! *El trabajo de la fuerza de Lorentz se limita al trabajo de la fuerza eléctrica*:
!
! $`\mathbf{d\mathcal{W}_{\,Lorentz} = d\mathcal{W}_{\,eléc} =q\,\overrightarrow{E}\cdot \overrightarrow{dl}}`$

* La **potencia elemental cedida por el campo** a esta partícula se escribe:
<br>
**$`\mathbf{\mathcal{P}_{cedida} = \dfrac{d\mathcal{W}_{\,Lorentz}}{dt} = q\,\overrightarrow{E}\cdot\overrightarrow{v}}`$**

##### Potencia cedida en un material con un solo tipo de portador de carga

* Si el **medio material** contiene *$`n`$ portadores idénticos de carga $`q`$ por unidad de volumen*,
entonces un volumen elemental $`d\tau`$ contiene $`n\,\tau`$ portadores de carga
y la **potencia elemental cedida** por el campo electromagnético se escribe:
<br>
**$`d\mathcal{P}_{cedida} = n\,\big( q\,\overrightarrow{E}\cdot\overrightarrow{v}\big)\,d\tau`$**

* Expresada *con la densidad volumétrica de carga $`\rho=n\,q`$*:
<br>
$`d\mathcal{P}_{cedida} = \big(n\, q\big)\,\overrightarrow{E}\cdot\overrightarrow{v}\,d\tau = \rho\,\overrightarrow{E}\cdot\overrightarrow{v}\,d\tau`$

* Expresada *con el vector densidad volumétrica de corriente $`\overrightarrow{j}=\rho\,\overrightarrow{v}`$*, observando que
$`\overrightarrow{E}\cdot\overrightarrow{v}=\overrightarrow{v}\cdot\overrightarrow{E}`$:
<br>
**$`d\mathcal{P}_{cedida} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau`$**

##### Potencia cedida en un material con varios tipos de portadores de carga

* Cuando un material contiene **varios tipos de portadores de carga $`q_i`**
en *concentraciones $`n_i`* y animados de *velocidades de deriva $`\overrightarrow{v_d\,i}`*:
<br>
$`\displaystyle d\mathcal{P}_{cedida} = \sum_{i=1}^p \big(n_i\,q_i\,\overrightarrow{E}\cdot\overrightarrow{v_i}\big)\,d\tau`$
<br>
$`\displaystyle d\mathcal{P}_{cedida} = \sum_{i=1}^p \rho_i\,d\tau\,\overrightarrow{E}\cdot\overrightarrow{v_i}`$
<br>
$`\displaystyle d\mathcal{P}_{cedida} = \sum_{i=1}^p\overrightarrow{j_i}\cdot\overrightarrow{E}\,d\tau`$
<br>
*$`d\mathcal{P}_{cedida} = \overrightarrow{j}_{total}\cdot\overrightarrow{E}\,d\tau`$*

* Al establecer simplemente *$`\overrightarrow{j}_{total}=\overrightarrow{j}`*:
<br>
**$`\large{\mathbf{d\mathcal{P}_{cedida} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**

* La *potencia cedida* por el campo electromagnético *en un volumen $`\tau`* se llama **$`\large{\text{Efecto Joule}}`**,
<br>
**$`\large{\displaystyle\mathbf{\mathcal{P}_{cedida} = \iiint_{\tau}\big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**

---

#### ¿Contiene el campo electromagnético energía?

* Si el *campo electromagnético* puede ceder energía a la materia, es porque él mismo **contiene energía**.

* Un campo electromagnético $`\big(\overrightarrow{E}\,,\,\overrightarrow{B}\big)`$ que se extiende en el espacio,
la energía contenida en el campo está descrita por
una **densidad volumétrica de energía electromagnética $`\dens_{energía-EM}^{3D}`** definida en cada punto del espacio.

* Parte de la identidad matemática
<br>
$`\mathbf{div\,\big(\overrightarrow{U}\land\overrightarrow{V}\big)=
\overrightarrow{V}\cdot\big(\overrightarrow{rot}\,\overrightarrow{U}\big)\,-\,\overrightarrow{U}\cdot\big(\overrightarrow{rot}\,\overrightarrow{V}\big)}`$
<br>
y aplícala al campo electromagnético $`\big(\overrightarrow{E}\,,\overrightarrow{B})`$ estableciendo $`\overrightarrow{U}=\overrightarrow{E}`$
y $`\overrightarrow{V}=\overrightarrow{B}`$
<br>
**$`\mathbf{div\,\big(\overrightarrow{E}\land\overrightarrow{B}\big)=\overrightarrow{B}\cdot\big(\overrightarrow{rot}\,\overrightarrow{E}\big)\,-\,\overrightarrow{E}\cdot\big(\overrightarrow{rot}\,\overrightarrow{B}\big)}`**,
<br>
$`\color{blue}{\scriptsize{
\text{Identifica los términos } \overrightarrow{rot}\,\overrightarrow{E} \text{ y } \overrightarrow{rot}\,\overrightarrow{B}}}`$
$`\color{blue}{\scriptsize{\text{ con sus causas respectivamente}}}`$
$`\color{blue}{\scriptsize{\text{con las ecuaciones de Maxwell-Faraday y Maxwell-Ampère}}}`$
<br>
$`\begin{align}div\,\big(\overrightarrow{E}\land\overrightarrow{B}\big)
=&\,\overrightarrow{B}\cdot
\big(
\underbrace{\overrightarrow{rot}\,\overrightarrow{E}}
_{\color{blue}{=-\frac{\partial \vec{B}}{\partial t}}}\big)\,\\
&\quad-\,\overrightarrow{E}\cdot\big(\underbrace{\overrightarrow{rot}\,\overrightarrow{B}}_{\color{blue}{=\mu_0\,\vec{j}+\mu_0\epsilon_0\frac{\partial \vec{E}}{\partial t}
}}\big)\end{align}`$
<br>
$`div\,\big(\overrightarrow{E}\land\overrightarrow{B}\big)`$
$`\quad=-\,\mu_0\,\vec{j}\cdot\overrightarrow{E}\,-\,\mu_0\,\epsilon_0\dfrac{\partial \vec{E}}{\partial t}\cdot\overrightarrow{E}
\,-\,\overrightarrow{B}\cdot \dfrac{\partial \vec{B}}{\partial t}\big)$
<br>
$`\color{blue}{\scriptsize{
\text{Recuerda que } \vec{u}\dfrac{\partial \vec{u}}{\partial t}=\dfrac{1}{2}\,\dfrac{\partial (\vec{u}\cdot\vec{u})}{\partial t}=\dfrac{1}{2}\,\dfrac{\partial u^2}{\partial t}}}`$
<br>
$`div\,\big(\overrightarrow{E}\land\overrightarrow{B}\big)`$
$`\quad =-\,\mu_0\,\vec{j}\cdot\overrightarrow{E}\,-\,\dfrac{\mu_0\,\epsilon_0}{2}\,\dfrac{\partial E^2}{\partial t}
\,-\,\dfrac{1}{2}\,\dfrac{\partial B^2}{\partial t}
$`
<br>
$`\color{blue}{\scriptsize{\text{El reconocimiento del término de efecto Joule }\vec{j}\cdot\vec{E}=\dfrac{d\mathcal{P}_{cedida}}{d\tau}}}`$
$`\color{blue}{\scriptsize{\text{incita a dividir cada miembro de la ecuación por }\mu_0 }}`$
<br>
$`
div\,\left(\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}\right)`$
$`\quad = -\,\underbrace{
\vec{j}\cdot\overrightarrow{E}
}_{
\color{blue}{=\frac{d\mathcal{P}_{cedida}}{d\tau}}
}
\,-\,\dfrac{\epsilon_0}{2}\,\dfrac{\partial E^2}{\partial t}
\,-\,\dfrac{1}{2\,\mu_0}\,\dfrac{\partial B^2}{\partial t}
$`
<br>
$`\color{blue}{\scriptsize{\text{que puedes reescribir:}}}`$
<br>
**$`\mathbf{
div\,\left(\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}\right)}`$
$`\mathbf{\quad = -\,\vec{j}\cdot\overrightarrow{E}
\,-\,\dfrac{\partial}{\partial t}\,\left(
\dfrac{\epsilon_0\,E^2}{2}\,+\,\dfrac{B^2}{2\,\mu_0}
\right)
}`$**

* Así aparece la **densidad volumétrica de energía electromagnética** de *unidad SI: $`J\,m^{-3}`*:
<br>
**$`\large{\mathbf{\dens_{energía-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}}}`$**

* Esta densidad volumétrica $`\dens_{energía-EM}^{3D}`$ *posee dos componentes*:
* una *componente eléctrica* **$`\;\dens_{eléc}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$**
* una *componente magnética* **$`\;\dens_{magn}^{3D}=\dfrac{B^2}{2 \mu_0}`$**.

* La energía electromagnética $`\mathcal{E}_{EM}`$ contenida **en un volumen $`\tau`** se expresa:
<br>
**$`\displaystyle\large{\mathbf{\mathcal{E}_{EM}=\iiint_{\tau} \left(\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}\right) d\tau}}`$**


<br>

------------

<br>

#### ¿Por qué hablamos de ondas electromagnéticas?

##### Ecuación de onda

* Para un *campo vectorial $`\overrightarrow{U}(\overrightarrow{r},t)`$*, la **ecuación de onda de d'Alembert** se escribe:
<br>
**$`\Delta \overrightarrow{U} - \dfrac{1}{v^2} \; \dfrac{\partial^2 \;\overrightarrow{U}}{\partial\; t^2}=0`$**

* La expresión del *operador Laplaciano vectorial $`\Delta`$* en función de los operadores $`grad`$, $`div`$ y $`rot`$ es:
<br>
*$`\Delta =\overrightarrow{grad} \left(div\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\right)`$*

* La **idea** es *calcular para cada uno de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$*
la expresión de *su Laplaciano*, para ver si se identifica con la ecuación de onda.

---

##### Estudio de la componente $`\overrightarrow{E}`$ del campo electromagnético

* Para **establecer la expresión $`\;\;\Delta \overrightarrow{E}`$**, calculo
$`\;\;\overrightarrow{rot}\left(\overrightarrow{rot}\;\overrightarrow{E}\right)\;\;$$, luego
$`\;\;\overrightarrow{grad} \left(div \overrightarrow{E}\right)\;\;$* a partir de las ecuaciones de Maxwell.

* $`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
\overrightarrow{rot} \,\left( -\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$
<br>
En física clásica, el espacio y el tiempo están desacoplados. Las coordenadas espaciales
y la coordenada temporal son independientes. El orden de derivación o integración entre
coordenadas espaciales y la coordenada temporal no importa, por lo tanto:
<br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\overrightarrow{rot}\overrightarrow{B}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$
<br><br>
*$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=-\mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  - \mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$*
<br><br>

* $`\overrightarrow{grad} \left( div \; \overrightarrow{E} \right) = \overrightarrow{grad}\left( \dfrac{\rho}{\epsilon_0} \right)`$

* La reconstrucción de
$`\Delta \;\overrightarrow{E} =\overrightarrow{grad} \left(div\;\overrightarrow{E}\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\;\overrightarrow{E}\right)`$
da:
<br>
$`\Delta \;\overrightarrow{E} = \overrightarrow{grad}\left( \dfrac{\rho}{\epsilon_0} \right) + \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$
<br>
lo que da, por identificación con el primer término de la ecuación de onda:

**$`\mathbf{\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_0} \;
\overrightarrow{grad}\left(\rho \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}}`$**
<br>
*(ecuación de propagación del campo eléctrico)*

---

##### Estudio de la componente $`\overrightarrow{B}`$ del campo electromagnético

* Un *estudio de forma idéntica* (propuesto en autoevaluación en la parte avanzada) me llevaría
para el campo magnético $`\overrightarrow{B}`$ a la ecuación de propagación:
<br>
**$`\mathbf{\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}}`$**
<br>
*(ecuación de propagación del campo magnético)*

---

##### Propagación de una onda electromagnética en la materia

* El estudio parte de las ecuaciones de Maxwell y de las dos ecuaciones:
<br>
$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_0} \;
\overrightarrow{grad}\left(\rho \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}`$
<br>
$`\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}`$
<br>
y es objeto de todo un **desarrollo en un capítulo posterior**.

---

##### Propagación de una onda electromagnética en el vacío

* El *espacio vacío* se caracteriza por una ausencia de cargas, fijas o en movimiento.
La densidad volumétrica de carga $`\rho_{vacío}`$ así como el vector densidad volumétrica de corriente
$`\overrightarrow{j}_{vacío}`$ tienen un valor nulo en todo el espacio vacío,
<br>
*$`\rho_{vacío}=0\quad\text{y}\quad\overrightarrow{j}_{vacío}=\overrightarrow{0}`$*.

* Por lo tanto, la propagación de la onda electromagnética en el vacío se expresa en forma
del sistema de **dos ecuaciones de d'Alembert**:
<br>
**$`\large{\boldsymbol{\mathbf{\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}}}}`$**
<br>
**$`\large{\boldsymbol{\mathbf{\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}}}}`$**

!!!! *¡Atención!*:
!!!!
!!!! Las *ecuaciones de Maxwell implican la propagación del campo electromagnético*.
!!!!
!!!! *Pero,*
!!!!
!!!! Las *dos ecuaciones de onda para los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`*
!!!! no implican las ecuaciones de Maxwell*.
!!!!
!!!! Todo campo $`\overrightarrow{E}`$ que verifique
!!!! $`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! y todo campo $`\overrightarrow{B}`$ que verifique
!!!! $`\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! no describen la propagación de una onda electromagnética a menos que $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$
!!!! verifiquen las ecuaciones de Maxwell.

---

##### Rapidez de la velocidad de la luz en el vacío

* La identificación de las ecuaciones de propagación de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$
con la ecuación de onda de d'Alembert muestra que *el campo electromagnético se propaga a la rapidez*
<br>
*$`\large{\mathscr{v}=\dfrac{1}{\sqrt{\epsilon_0\,\mu_0}}}`$*

* La *rapidez de la luz en el vacío*, denotada *$`\mathbf{c}`$* es una **constante fundamental** del universo, y su valor exacto es:
<br>
*$`\large{c=299\,792\,458\, m\,s^{-1}\approx 3\times 10^8\, m\,s^{-1}}`$*

!! *Para ir más allá*:
!!
!! Las ecuaciones de propagación de las ondas electromagnéticas, establecidas aquí en el marco
!! de la física clásica,
!! prevén que las ondas electromagnéticas se propagan en el vacío a la rapidez
!! $`c=1/\sqrt{\epsilon_0\,\mu_0}`$, rapidez constante independiente del movimiento del observador.
!!
!! Esto está en contradicción con la ley de adición de velocidades en mecánica clásica, que
!! resulta de las transformaciones de Galileo.
!!
!! $`\Longrightarrow`$ durante la segunda mitad del $`19^{ème}`$ siglo, el trabajo de los físicos fue
!! intentar modificar las ecuaciones de Maxwell para hacerlas compatibles con la física clásica.
!!
!! Pero fue lo contrario lo que había que hacer: modificar la mecánica de Newton, base de la física clásica,
!! para hacerla compatible con las ecuaciones de Maxwell.
!!
!! Este trabajo inverso fue el de Albert Einstein, quien publicó en 1905 un artículo titulado
!! "Sobre la electrodinámica de los cuerpos en movimiento",
!! que fue el nacimiento de la teoría de la Relatividad especial, que revolucionó nuestra concepción
!! del espacio y del tiempo.
!!
!! Más tarde, en 1915, Einstein presentó un artículo titulado
!! "Los fundamentos de la teoría de la Relatividad General"
!! que revolucionó nuestra concepción de la relación entre el espacio-tiempo y su contenido en materia y energía.
!!
!! *Física newtoniana*:
!! espacio + tiempo + materia + energía.
!!
!! *Física relativista en el sentido restringido*:
!! espacio-tiempo + materia-energía ($`E=m\,c^2`$).
!!
!! *Física relativista en el sentido general*:
!! espacio-tiempo-materia-energía.

---

#### ¿Qué es el espectro electromagnético?

* **Maxwell** plantea la hipótesis de que *la luz* visible, cuya velocidad se había medido a partir
de la observación astronómica del movimiento de los satélites de Júpiter, *es una onda electromagnética*.
<br>
$`\Longrightarrow`$ la luz es solo una pequeña parte de las ondas electromagnéticas.
<br>
$`\Longrightarrow`$ todo un *nuevo mundo de "luces"* se revela, llamado **espectro electromagnético**.

![Espectro electromagnético](astro-electromagnetic-spectrum-N4_1_fr_L1200.jpg)

* En particular, **el conocimiento del universo** resultaba *antes de Maxwell* de la sola observación del *dominio visible*,

![Cielo visible](ciel-visible-bsp_L1200.jpg)

* se extiende *ahora* a *todo el espectro electromagnético*.

![Cielo en varias longitudes de onda](ciel-images-bsp_L600_transparence.gif)

---

#### ¿Qué es el vector de Poynting?

* La **onda electromagnética contiene energía**:
  * con *en cada punto del espacio* una **densidad volumétrica de energía $`\dens_{energía-EM}^{3D}`$*,
  - con una *componente eléctrica* **$`\;\dens_{eléc}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$*,
  - con una *componente magnética* **$`\;\dens_{magn}^{3D}=\dfrac{B^2}{2 \mu_0}`$*.
  * que **se desplaza en el vacío** *a la velocidad $`c`$*.

* El **vector de Poynting** traduce este hecho, y permite el *cálculo de la energía* de una onda electromagnética
incidente *sobre una superficie cualquiera por segundo*.

* El **vector de Poynting**, definido en cada punto del espacio, está *definido por* la relación:
<br>
*$`\large{\mathbf{d\mathcal{P}=\overrightarrow{\Pi}\cdot\overrightarrow{dS}}}`$*
<br>
donde $`d\mathcal{P}`$ es la *potencia elemental* de la onda electromagnética
*radiada a través del elemento de superficie* $`\overrightarrow{dS}`$.

![Vector de Poynting](poynting-vector-1_L1200.jpg)

* Su **expresión** en función de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ es:
<br>
**$`\large{\mathbf{\overrightarrow{\Pi}=\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}}}`$**

* *Unidad SI*: **$`\mathbf{W\,m^{-2}}`$**

! *Nota 1*:
!
! El desplazamiento de una carga (de unidad $`SI: C)`$ contenida en un volumen elemental
! $`d\tau\quad (SI: m^3)`$ de densidad volumétrica de
! carga $`\rho_{carga}^{3D}\quad (SI: C\,m^{-3})`$ a una velocidad
! $`\overrightarrow{v_d}\quad (SI: m\,s^{-1})`$:
! * permite definir un vector densidad de corriente (eléctrica) volumétrica
! $`\overrightarrow{j}_{corriente}^{3D}=\rho_{carga}^{3D}\,v_d\,`$
! $`\quad (SI: A\,m^{-2})`$,
! * y así permite calcular la intensidad elemental $`dI\quad (SI: A = C\,s^{-1})`$ de la corriente que atraviesa
! todo elemento de superficie
! $`\overrightarrow{dS}\quad (SI: m^2)`$,
! $`dI= \overrightarrow{j}_{corriente}^{3D}\cdot\overrightarrow{dS}`$!
!
! De la misma manera,
!
! el desplazamiento de la energía (de unidad $`SI: J)`$ de la onda electromagnética contenida
! en un volumen elemental $`d\tau\quad (SI: m^3)`$ de densidad volumétrica de energía
! $`\dens_{energía_EM}^{3D}\quad (SI: J\,m^{-3})`$ a la rapidez $`c\quad (SI: m\,s^{-1})`$:
! * permite definir el equivalente de un vector densidad de potencia de la onda electromagnética,
! llamado *vector de Poynting* y denotado $`\overrightarrow{\Pi}\quad (SI: J\,s^{-1}\, m^{-2}=W\, m^{-2})`$,
! * lo que permite calcular la potencia elemental $`d\mathcal{P}\quad (SI: W)`$ de la onda EM que atraviesa todo elemento de superficie
! $`\overrightarrow{dS}`$,
! $`d\mathcal{P}= \overrightarrow{\Pi}\cdot\overrightarrow{dS}`$.

! *Nota 2*:
!
! *La expresión del vector de Poynting* en función del campo eléctrico y del campo magnético de la onda,
! así como *su significado*, son *más fáciles de recordar* si se elige expresarlo
! *en función del campo de excitación magnética $`\overrightarrow{H}`$*.
!
! *__En el vacío__ (y únicamente en el vacío)*:
! El campo magnético está tan bien descrito por el campo de inducción
! $`\overrightarrow{B}`$ que interviene en la fuerza de Lorentz que induce los efectos,
! como por el campo de excitación magnética $`\overrightarrow{H}`$.
! Estos dos campos son proporcionales, siendo la constante de proporcionalidad $`\mu_0`$:
! <br>
! $`\overrightarrow{B}=\mu_0\,\overrightarrow{H}\quad\text{(en el vacío)}`$
!
! La expresión en el vacío del vector de Poynting es entonces:
! <br>
! $`\overrightarrow{\Pi}=\overrightarrow{E}\land\overrightarrow{H}`$
!
! Recordando
! * de la electrostática que la unidad SI de $`\overrightarrow{E}`$ es el $`V\,m^{-1}$,
! * de la magnetostática que la unidad SI de $`\overrightarrow{H}`$ es el $`A\,m^{-1}$,
! * del estudio de los circuitos que $`\mathcal{P}\,(W) = U\,(V)\times I\,(A)`$,
!
! entonces la *unidad SI del vector de Poynting* aparece fácilmente como *$`V\,A\,m^{-2}= W\,m^{-2}`$*
!
! En el sistema internacional de medidas, el vector de Poynting se expresa en *vatios por metro cuadrado*.
!
! La *magnitud física del vector de Poynting* es una *potencia por unidad de superficie*.

<br> 

------

<br>

#### ¿Cómo calcular la potencia que atraviesa una superficie de área y orientación cualquiera?

* La **potencia** se calcula simplemente mediante la expresión:
<br>
**$`\displaystyle\mathcal{P}=\iint_S \overrightarrow{\Pi}\cdot\overrightarrow{dS}`$**

* Sea una **onda electromagnética monocromática** de período temporal $`\mathbf{T_{onda}}`$.
  * **$`\mathbf{T_{onda}}`** es el *período temporal de $`\overrightarrow{E}`*, campo eléctrico de la onda.
  * La energía eléctrica es proporcional a $`E^2`$, <br>
    el *período de las variaciones energéticas* de la onda es **$`\mathbf{T_{energía}}`** *$`\mathbf{=\dfrac{T_{onda}}{2}}`$*.

* Todo **sensor** se caracteriza por un **tiempo de respuesta $`\mathbf{\Delta t_{respuesta}}`** que cuantifica su *rapidez*.
  <br>
  Sea un sensor sensible a la energía electromagnética:
  * Si *$`\mathbf{\Delta t_{respuesta}\ll T_{energ.}}`$*, entonces el sensor es sensible a la *potencia instantánea*:
    <br>
    *$`\displaystyle\large{\mathbf{\mathcal{P}(t)=\iint_S \overrightarrow{\Pi}(t)\cdot\overrightarrow{dS}}}`$*
    <br>
  * Si **$`\mathbf{\Delta t_{respuesta}\gg T_{energ.}}`**, entonces el sensor no puede seguir las variaciones temporales de
    la potencia instantánea, y solo mide el **valor promedio de la potencia** estimado en $`\Delta t_{respuesta}`$:
    <br>
    **$`\displaystyle\large{\mathbf{<\mathcal{P}(t)>\;=\iint_S <\overrightarrow{\Pi}(t)>\cdot\overrightarrow{dS}}}`$**

!!! *Ejemplo*:
!!!
!!! El *dominio visible* corresponde a:
!!! * una *longitud de onda* en el vacío del orden de 500 nanómetros: *$`\mathbf{\lambda = 5\cdot 10^{-7}\,m}`$*
!!! <br>
!!! Esto corresponde a un período temporal del campo eléctrico $`T_{onda}`$ de:
!!! <br>
!!! $`T_{onda}=\dfrac{\lambda}{c}=\dfrac{5\cdot 10^{-7}}{3\cdot 10^{8}} = 1.7\times 10^{-15}\,s`$,
!!! <br>
!!! es decir,
!!! <br>
!!! $`T_{energ.}=8.5\times 10^{-16}\,s`$
!!! <br>
!!! En ambos casos, el orden de magnitud del *período* es de $`\mathbf{T\approx 10^{-15}\,s}`$.
!!!
!!! Ningún sensor logra seguir las variaciones instantáneas de potencia de la luz visible.

---

#### ¿Cómo emitir una onda electromagnética?

* Basta con **acelerar una partícula cargada**.

