---
title: Les Ondes
published: true
routable: true
visible: false
lessons:
    -   
      slug: classical-corpuscules-and-waves
      name: PARALLELE : Mécanique de Newton, corpuscules et ondes
      order: 3
    -   
      slug: from-classical-world-to-wave-corpuscular-duality
      name: PARALLELE : des ondes et corpuscules à la dualité onde-corpuscule
      order: 2
    - 
      slug: from-corpuscule-to-mechanical-wave-3
      name: PARALLÈLE particule et onde.
      order: 3
    -   
      slug: waves-3
      name: LINÉAIRE : Ondes
      order: 2
---
$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Contreforts :&nbsp; _physiciens_

---------------------------

*Physique classique :*

#### L'onde et la description de sa propagation

<br>

RÉSUMÉ
: ---   

  *Le concept d'onde, et ses propriétés*    
  
  __Onde mécanique__ : perturbation d'un milieu matériel, caractérisé par une grandeur <!--ou une propriété--> physique scalaire $`\eta`$ ou vectorielle
  $`\vec{\eta}`$, qui s'étend de proche en proche sur des distances souvent bien plus grandes
  que l'amplitude de déplacement $`\delta`$ de chaque particule du milieu autour de sa position d'équilibre.
  * Onde __transversale__ : déplacement local du milieu perturbé perpendiculaire à la direction de propagation.
  * Onde __longitudinale__ : déplacement local du milieu perturbé parallèle à la direction de propagation.
  * Onde __progressive__ : la perturbation se propage sur de grandes distances.
  * Onde __stationnaire__ : la perturbation ne se propage pas, résulte de la superposition d'ondes progressives.

  __Représentation mathématique__ un champ $`U`$ obligatoirement dépendant du temps,
  scalaire $`U(\vec{r},t)`$ ou vectoriel $`\overrightarrow{U}(\vec{r},t)`$

  __Propriétés des ondes mécaniques__
  * __Non localisée__ : fonction spatialement étendue.
  * __Transport d'énergie__. 
  * __Pas de transport de matière__ au delà de $`\delta`$.
  * Dans un milieu matériel,
     * le __phénomène de diffraction__ observé lorsqu'une onde mécanique rencontre un obstacle.
     * le __phénomène d'interférence__ peut être observé en présence de deux ondes.
  * À l'interface entre deux milieux de caractéristiques différentes,
     * le __phénomène de réflexion__, totale ou partielle, observé lorsque l'onde atteint l'interface.
     * le __phénomène de réfraction__ observé lorsque l'onde traverse l'interface.

  Le concept d'__onde__ s'élargit à tout phénomène conduisant aux propriétés des ondes mécaniques.
  * __Onde électromagnétique__ : Propagation du champ électromagnétique dans le vide ou dans la matière.
  * __Onde gravitationnelle__ : Propagation d'une perturbation dans la géométrie de l'espace-temps 
                de la relativité générale d'Einstein. Ne se traite pas dans le cadre de la physique classique.

  __Célérité__ $`v`$ : vitesse de propagation de l'onde progressive.<br>
  $`\mathscr{v} = \dfrac{\Delta \mathscr{l}}{\Delta t}`$, avec $`\Delta \mathscr{l}`$ distance parcourue par l'onde pendant la durée  $`\Delta t`$.

  -----------------------

  *L'onde périodique*   
  __Onde périodique__ : en tout point de l'espace de vecteur position $`\vec{r}`$ et à tout instant $`t`$, la perturbation $`U(\vec{r},t)`$ du milieu se répète à intervalles de temps réguliers :   
  $`U(\vec{r},t) = U(\vec{r}\,,\; t+n\times T)`$, avec $`n\in\mathbb{Z}`$ et $`T`$ une durée.    

  * __Propriété fondamentale__ de l'onde périodique : sa propriété temporelle décrite par les grandeurs physiques équivalentes :
      * La __période temporelle__ $`T`$ de l'onde (d'appellation commune : "période"), <br>
                   homogène à un temps : unité S.I., la "seconde" (notation $`s`$)..
      * La __fréquence temporelle__ $`\nu`$ $`\; = 1\,/\,T`$ : inverse de la période temporelle, <br> 
                   homogène à l'inverse d'un temps : unité S.I., le "hertz" (notation $`s^{-1}\equiv Hz`$) 

  * __Propriétés du milieu__ : On se limitera à la célérité $`\mathscr{v}`$
     * milieu __linéaire__ (noté L) : en présence de plusieurs ondes, la perturbation de milieu est égale à
                           la somme des perturbations induites par chaque onde en absence des autres
                           (principe de superposition).
     * milieu __homogène__ (noté H) : $`\mathscr{v}`$  ne dépend pas de la position dans le milieu.
     * milieu __isotrope__ (noté I) : $`\mathscr{v}`$  ne dépend pas de la direction de propagation de l'onde.  
     * milieu __dispersif__ : la célérité dépend de la fréquence temporelle de l'onde :
     $`\mathscr{v} = \mathscr{v}(\nu) = \mathscr{v}(T)`$
     * milieu __non dispersif__ : la célérité de dépend pas de la fréquence temporelle de l'onde.
     
  * __Propriété de l'onde dans un milieu LHI__  : sa propriété spatiale décrite par les grandeurs physiques équivalentes :
      * La période spatiale appelée __longueur d'onde__ $`\lambda`$, <br>
                   homogène à une longueur : unité S.I., le "mètre" (notation $`m`$), ou ses unités multiples
                   (kilomètre "$`km`$", ...) ou sous-multiples (millimètre "$`mm`$", micromètre "$`\mu m`$", 
                    nanomètre "$`nm`$",... )
      * La __fréquence spatiale__ $`1/\lambda`$ : inverse de la longueur d'onde, <br> 
                   d'unité S.I., le $`m^{-1}`$ et ses miultiples et sous-multiples.

    -----------------------
    
    *L'onde progressive plane sinusoïdale*   
    <!--- Noms communs d'usage :   
     __onde sinusoïdale__ &equiv; __onde harmonique__ (&equiv; __onde monochromatique__ en optique).-->
     
  *  Une onde progressive plane sinusoïïdale se propageant en direction et sens d'un vecteur unitaire $`\vec{n}`$ :
     s'écrit $`U(\vec{r},t) = U_0 \cdot \cos(\, \omega t\;\mathbf{-}\;\vec{k}\cdot\vec{r}  + \varphi)`$, avec
     * $`U(\vec{r}, t)`$ : __élongation__ en $`\vec{r}`$ et $`t`$
     * $`U_0`$ : __amplitude__ = élongation maximum
     * $`\omega t - \vec{k}\cdot\vec{r} + \varphi`$ : __phase__ en $`\vec{r}`$ et $`t`$
     * $`\vec{k} = k\,\vec{n}`$ : __vecteur d'onde__, avec :<br>
       &nbsp;&nbsp; k : __nombre d'onde__, d'unité S.I. $`rad\,m^{-1}`$, <br>

  * __Propriété fondamentale__ : aux propriétés temporelles $`T`$ et $`\nu`$ s'ajoute la pulsation $`\omega`$
       d'unité S.I. le radian par seconde ($`rad\,s^{-1}`$) et telle que :   
       $`\omega = 2\pi\,\nu = \dfrac{2\pi}{T}`$

  * __Propriété dépendante du milieu__ la propriété spatiale "vecteur d'onde" $`\vec{k}`$,
     s'ajoute à $`\lambda`$ en précisant la direction et le sens de propagation.

  * Relations entre propriétés :   
    $`k = \dfrac{2\pi}{\lambda} = \dfrac{2\pi}{\mathscr{v} T} = \dfrac{2\pi\,\nu}{T} = \dfrac{\omega}{\mathscr{v}}`$

  * Cas d'une onde unidimensionnelle : $`U(\vec{r}, t) = U_0\cdot \cos(\omega t  \;\mathbf{-}\;kx  + \varphi)`$
  
  * Onde sinusoïdale se propageant en sens inverse de $`\vec{n}`$ :   
       $`U(\vec{r}, t) = U_0\cdot \cos(\,\omega t\;\mathbf{+}\; \vec{k}\cdot\vec{r}  + \varphi)`$

  * Intérêt : vient du __théorème de Fourier__ :
     * Toute onde périodique se décompose en une somme discrète d'onde sinusoïdales.
     * Toute onde (quelconque) se décompose en une somme intégrale d'onde sinusoïdales
  
 

<br>

-----------------

<br>

#### Qu'est-ce qu'une onde ?

* Notre représentation intuitive du phénomène ondulatoire vient des ondes matérielles.

* Une **onde mécanique** est la *perturbation d'un milieu matériel* caractérisé par une 
  grandeur physique qui *s'étend de proche en proche* sur des distances souvent bien plus 
  grandes que l'amplitude de déplacement δ de chaque particule du milieu autour
  de sa position d'équilibre.   
  Cette perturbation, qui implique de l'énergie, est *générée par un phénomène physique localisé*
  dans l'espace, appelé **source** de l'onde.

* Ce qui caractérise une onde mécanique :
   * décrite par un champ dépendant du temps,    
      $`\Longrightarrow`$ elle n'est *pas localisée*.
   * L'onde *transporte de l'énergie*. 
   * L'onde *ne transporte pas de matière*. 

* Suivant la nature de la grandeur physique décrivant l'onde, on qualifie :
   * **onde scalaire** : la grandeur physique est scalaire.   
     _&ndash;&nbsp; hauteur d'une vaguelette à la surface de l'eau, la source étant le point d'impact du cailloux jeté._   
     _&ndash;&nbsp; densité volumique de l'air, la source sonore étant la membrane de l'enceinte qui comprime_   
     _puis détend alternativement l'air en son voisinage._
     _&ndash;&nbsp; ..._
   * **onde vectorielle** : la grandeur physique est vectorielle.
     _vecteur déplacement des atomes constituant la matière, ..._
   * **onde tensorielle** : la grandeur physique est tensorielle.   
     _contrainte, déformation, ..._
    
* Le *concept d'onde s'étend* à des grandeurs physiques sans lien avec la matière.
   * **Ondes électromagnétiques** : propagation du champ électromagnétique $`\big(\vec{E},\vec(B)\big)`$ 
     dans le vide.
   * **Ondes gravitationnelles** : propagation d'une déformation de l'espace-temps représentée
     par sa grandeur physique "métrique" qui décrit localement les propriétés géométriques de l'espace et du temps.


##### Onde unidimensionnelle

* Exemple : La perturbation de la corde tendue d'une guitare.

![](wave-square_L1000.gif)

![](wavepacket_non-dispersive-v2_L1000.gif)

![](1D-corde-vibrante-f1-harm24_v2_L1000.gif)


##### Onde bidimensionnelle (2D) ou tridimensionnelle (3D)

* Exemple d'onde bidimensionnelle : vaguelettes à la surface de l'eau.
* Exemple d'onde tridimensionnelle : une onde sonore.

![représentation 2D d'ondes diverses 2D et 3D](different-waves-2.gif)

* La figure représente différents types d'ondes (2D ou 3D) :   
   d) onde quelconque
   e) onde plane progressive.
   f) onde stationnaire.
   g) onde sphérique progressive.


##### Quelle différence entre une onde longitudinale et une onde transverse ?




#### Quelle différence entre une onde progressive et une onde stationnaire ?

<br>

##### L'onde est unidimensionnelle

* **Onde progressive**   
  <br>
  **Couplage** entre les *coordonnées d'espace et de temps* que nous prendrons de la forme :   
    <br>
    **$`\mathbf{\large{U(x,t) = f \left(t\, \pm\, \dfrac{x}{\mathscr{v}}\right)}}`$**   
    <br>
    L'important est le couplage des coordonnées d'espace et de temps qui peut prendre aussi les 
    *formes équivalentes* suivantes :   
    <br>
    $`\begin{align} U(x,t) &=  f \Big(t\, \pm\, \dfrac{x}{\mathscr{v}}\Big)\\
    &= f \Big[\dfrac{1}{\mathscr{v}}\big( \mathscr{v}t\, \pm\, x \big)\,\Big] = f'(\mathscr{v}t\, \pm\, x)
    \end{align}`$   
    <br>
    ou encore   
    <br>
    *$`\large{\boldsymbol{\mathbf{U(x,t) = g\,(x\, \pm\, \mathscr{v}t)}}}`$*$`\,=  g \Big(\dfrac{x}{\mathscr{v}} \pm\, t \Big)`$
   
   
<br>
* **Onde stationnaire**   
  <br>
  **Séparation** des *coordonnées d'espace et de temps* dans deux fonctions différentes.   
  Résulte d'une superposition d'ondes progressives :   
    <br>
    **$`\mathbf{\large{U(x,t) = f(t)\times g(x)}}`$**


<br>

##### L'onde est bi ou tridimensionnelle

* La *position d'un point $`M`$* de l'espace est repéré
  par son **vecteur position $`\overrightarrow{OM} = \overrightarrow{r}`$**.   

* **Onde progressive**

   * Nous distinguons intuitivement *deux types d'ondes progressives*, l'onde *plane* et l'onde *sphérique*.
   
   <br>
   
   * **__Onde plane__** progressive :   
     <br>
     Elle possède une **direction et un sens de propagation** *identiques en tout point* $`M`$ de l'espace,    
     représentés par un **vecteur unitaire $`\vec{n}`$** qui pointe en direction et sens de la propagation.   
     <br>
     L'écriture vectorielle générale :   
     <br>
     **$`\large{\mathbf{\boldsymbol{  U(\overrightarrow{r},t) = f\left(\vec{n}\cdot\vec{r} \pm \mathscr{v}t  \right)}}}`$**   
     <br>
     En *coordonnées cartésiennes : $`\overrightarrow{r}=x\,\overrightarrow{e_x}\,+\,y\,\overrightarrow{e_y}\,+\,z\,\overrightarrow{e_z}`$*  
     <br>
     Il est souvent *judicieux* de choisir un axe de coordonnées pointant en direction de la propagation de l'onde, 
     par exemple *$`\overrightarrow{n}=\overrightarrow{e_x}`$*.   
     <br>
     $`\Longrightarrow\;\vec{r}\cdot\vec{n}=\big(x\,\overrightarrow{e_x}+y\,\overrightarrow{e_y}+z\,\overrightarrow{e_z}\big)\cdot\overrightarrow{e_x}=x`$   
     <br>
     ce qui permet de travailler en unidimensionnel.
     
   
   * **__Onde sphérique__** progressive :   
     <br>
     Elle est émise par une *source assimilable  à un point $`S`$ * de l'espace, et *diverge* à partir de ce point.   
     <br>
     L'étude est plus simple en **coordonnées sphériques, d'origine $`S`$**.    
     <br>
     $`\Longrightarrow`$**$`\;\overrightarrow{r}=\overrightarrow{SM}`$**, *position d'un point $`M`$* à partir de la source.   
     <br>
     L'écriture générale est :   
     <br>
     **$`\large{\mathbf{\boldsymbol{  U(\overrightarrow{r},t) = f(r)\times g(r - \mathscr{v}t)}}}`$**   
     ou encore   
     <br> 
     *$`\large{\mathbf{\boldsymbol{  U(\overrightarrow{r},t) = f(r)\times g'\left(t - \dfrac{r}{\mathscr{v}}\right)}}}`$*   
     <br>
     *$`\mathbf{f(r)}`$* est une *fonction d'atténuation* purement géométrique :   
     permet de garder l'énergie émise par la source constante bien qu'elle se répartisse 
     sur des fronts d'onde sphériques de rayons $`r`$ croissants lors de la propagation.

    
<br>
* **Onde stationnaire**   
  <br>
  **Séparation** des *coordonnées d'espace et de temps* dans deux fonctions différentes.   
    <br>
    **$`\mathbf{\large{U(x,t) = f(t)\times g(\overrightarrow{r})}}`$**
 
<br>
   
----------------------------------

#### Qu'est-ce que l'équation de d'Alembert ?

* Écriture d'une onde scalaire unidimensionnelle dans un système de coordonnées spatiale et temporelle $`(x,t)`$ :   
  <br>
  **$`\mathbf{\large{\dfrac{\partial^2 U\normalsize{(x,t)}}{\partial x^2}\,-\,\dfrac{1}{\mathscr{v}^2}\cdot\dfrac{\partial^2 U\normalsize{(x,t)}}{\partial t^2}= 0}}`$**

* Pour une onde scalaire tridimensionnelle dans un système de coordonnées cartésiennes et temporelle $`(x,y,z,t)`$ :   
  <br>
  $`\left(\dfrac{\partial^2 U(x,t)}{\partial x^2}\,+\dfrac{\partial^2 U(x,t)}{\partial y^2}
  \,+\dfrac{\partial^2 U(z,t)}{\partial x^2}\right)`$
  $`\,-\,\dfrac{1}{\mathscr{v}^2}\cdot\dfrac{\partial^2 U(x,t)}{\partial t^2}= 0`$   
  <br>
  ou en écriture vectorielle (indépendante du système de coordonnées choisi) :   
  <br>
  **$`\mathbf{\large{\Delta U}\normalsize{(\vec{r},t)}\large{\,-\,\dfrac{1}{\mathscr{v}^2}\cdot\dfrac{\partial^2 U\normalsize{(\vec{r},t)}}{\partial t^2}= 0}}`$** 
  


<!-------------------------------


#### Qu'est-ce qu'une onde périodique ?





#### Quelles sont les grandeurs fondamentales décrivant une onde périodique ?



#### Quelles sont les grandeurs décrivant une onde périodique qui dépendent du milieu de propagation ?


---------------------------


#### Quelle différence entre un milieu dispersif et un milieu non dispersif ?



#### Qu'est-ce que la relation de dispersion d'un milieu ?


------------------------------------------>

<br>

-------------------------------


#### Qu'est-ce qu'une Onde Plane Progressive Harmonique (OPPH) ?


  * **sinusoïdale** &equiv; **harmonique** (&equiv; **monochromatique** en optique).   
  <br>

  * **O** *nde* **P** *lane* **P** *rogressive* **H** *armonique* &equiv; **OPPH**
     
  *  Une **OPPH** se propageant *en direction et sens* d'un *vecteur unitaire $`\vec{n}`$* 
     s'écrit :  
     <br>
     **$`\large{\boldsymbol{\mathbf{U(\vec{r},t) = A \cdot \cos(\, \omega t\;\mathbf{-}\;\vec{k}\cdot\vec{r}  + \varphi)}}}`$**,   
     <br>
     avec *$`\mathbf{\vec{k} = k\,\vec{n}}`$* et :   
     * *$`\mathbf{U(\vec{r}, t)}`$* : **élongation** en $`\vec{r}`$ et $`t`$
     * *$`\mathbf{A}`$* : **amplitude** = élongation maximum
     * *$`\boldsymbol{\mathbf{\omega t - \vec{k}\cdot\vec{r} + \varphi}}`$* : **phase** en $`\vec{r}`$ et $`t`$
     * *$`\boldsymbol{\mathbf{\varphi}}`$* : **phase à l'origine**,   
       à l'origine du système de coordonnées, $`\vec{r}=\vec{0}`$, et à l'instant $`t=0`$ origine de l'axe des temps.   
     <br>
  * **Propriété fondamentale** de l'onde : propriété *temporelle*, décrite par différentes *grandeurs physiques équivalentes* qui sont :   
     * **$`\mathbf{T}`$** la *période* temporelle, d'unité S.I. **$`(s)`$**.
     * **$`\boldsymbol{\mathbf{\nu}}`$** la *fréquence* temporelle, d'unité S.I. **$`(Hz = s^{-1})`$**
     * **$`\boldsymbol{\mathbf{\omega}}`$** la *pulsation* temporelle, d'unité S.I. **$`(rad\,s^{-1})`$**
     <br>
     telles que :   
     <br>
     **$`\large{\boldsymbol{\mathbf{\omega = 2\pi\,\nu = \dfrac{2\pi}{T}}}}`$**   
     <br>
  * **propriété du milieu** vis à vis de l'onde :   
     * **$`\boldsymbol{\mathscr{v}}`$** la **célérité** ou *vitesse de propagation* de 
       l'onde dans le milieu, d'unité S.I. **$`(m\,s^{-1})`$**

     * Souvent, la *célérité* **$`\boldsymbol{\mathbf{\mathscr{v}(\nu)}}`$** *dépend de la fréquence* 
       temporelle $`\mathscr{\nu}`$ de l'onde. Le **milieu** est alors dit **dispersif**.    
       <br>
       Le milieu est dit non dispersif dans le cas contraire.   
       <br>
       En général, un milieu est dispersif, mais il peut être non dispersif dans un
       domaine de fréquence d'intérêt.   
       <br>
       
      
  * **Propriété de l'onde dépendante du milieu** de propagation, propriété *spatiale*, décrite 
   par différentes *grandeurs physiques équivalentes* qui sont :   
   * **$`\boldsymbol{\mathbf{\lambda}}`$** la *longueur d'onde*   
     ou périodicité spatiale dans la direction de la propagation, d'unité S.I. **$`(m)`$**
   * **$`\mathbf{\overrightarrow{k}}`$** le *vecteur d'onde* qui s'étend en direction et sens de la propagation.   
   * **k** le *nombre d'onde* ou norme du vecteur d'onde, d'unité S.I. **$`(rad\,m^{-1})`$**   
   <br>
   telles que :   
   **$`\mathbf{\vec{k}=k \,\vec{n}}`$** où *$`\mathbf{\vec{n}}`$* 
   est le *vecteur unitaire* pointant en *direction et sens de propagation* de l'onde.   
   <br>
   **$`\large{\boldsymbol{\mathbf{k = \dfrac{2\pi}{\lambda}}}}`$**
     

  * *Relations entre les propriétés* temporelles, spatiales et du milieu :   
    <br>
    **$`\large{\boldsymbol{\mathbf{k = \dfrac{2\pi}{\lambda} = \dfrac{2\pi}{\mathscr{v} T} = \dfrac{2\pi\,\nu}{T} = \dfrac{\omega}{\mathscr{v}}}}}`$**   
    <br>
    !!!! *Attention* 
    !!!!
    !!!! Parfois dans la littérature, le terme *nombre d'onde* est défini par $`k = 1\,/\,\lambda`$.    
    !!!! Il diffère d'un facteur $`2\pi`$ de la définition ici donnée.   
  <br>
  * Cas d'une *onde unidimensionnelle* :    
    <br>
    **$`\boldsymbol{\mathbf{U(\vec{r}, t) = A \cdot cos(\omega t - kx  + \varphi)}}`$**

  * Une OPPH peut aussi s'écrire en utilisant la fonction sinus. Nous avons alors, pour une :   
    OPPH 1D :   
    $`U(\vec{r}, t) = A\cdot \sin(\omega t  - kx  + \varphi)`$   
    OPPH 2D ou 3D :   
    $`U(\vec{r}, t) = A \cdot \sin(\omega t - \vec{k}\cdot\vec{r}  + \varphi)`$   

<br>

##### Les notations utilisant la fonction sinus ou la fonction cosinus sont-elles équivalentes?

* Fonctions **sinus et cosinus** représentent *une même fonction, déphasée de $`\pi/2`$*:   
  <br>
  *$`\boldsymbol{\mathbf{sin (\varphi) = cos  (\varphi - \pi/2)}}`$*.


*  $`\Longrightarrow`$ Les écritures d'une OPPH avec une fonction sinus ou une fonction cosinus sont équivalentes.   
   <br>
**$`\mathbf{U(x,t)=A\cdot cos\,(\omega t - \vec{k}\cdot\vec{r} + \varphi)}`$**
$`\quad = A\cdot cos \Big(\omega t - \vec{k}\cdot\vec{r}  + \underbrace{ \varphi + \dfrac{\pi}{2}}_{\color{blue}{=\;\varphi'}} - \dfrac{\pi}{2}\Big)`$
$`\quad = A\cdot 
\;\underbrace{cos \Big[\,\Big(\omega t - \vec{k}\cdot\vec{r}  + \varphi'\Big) - \dfrac{\pi}{2}}_{\color{blue}{cos(a-\pi/2)\\\;=cos(a)\,cos(\pi/2)+sin(a)\,sin(\pi/2)\\=\;sin(a)}}\Big]`$
**$`\boldsymbol{\mathbf{\quad=A\cdot sin\,(\omega t - \vec{k}\cdot\vec{r} + \varphi')}}`$**   
  $`\quad\quad\quad \text{avec } \varphi'=\varphi + \dfrac{\pi}{2})`$   


* L'utilisation de la **fonction cosinus** sera *privilégiée* :
   * à cause de sa parité qui implique : $`U(x,t)=A\cdot cos\,(\omega t - kx + \varphi)`$
     $`\; = A\cdot cos\,(kx - \omega t - \varphi)`$
   * pour une identification directe avec l'*écriture en notation complexe*.

<br>


##### Comment représenter une OPPH en notation complexe ?

* On utilise le fait que la fonction exponentielle se décompose de la façon suivante :   
<br>
$`\forall \alpha \in \mathbb{R}\;,\,`$ **$`\large{exp{\,\alpha} = cos \,\alpha + i\cdot sin \,\alpha}\quad`$**, avec *$`\large{\;i^{\,2}=-1}`$*.

* Ainsi l'**onde sinusoïdale plane progressive** peut s'écrire :   
   <br>   
   * soit en *notation réelle* :   
     <br>
     1D : *$`\;\large{\boldsymbol{\mathbf{U(x,t)=A\cdot cos\,(\omega t - k x + \varphi)}}}`$*   
     3D : *$`\;\large{\boldsymbol{\mathbf{U(\vec{r},t)=A\cdot cos\,(\omega t - \vec{k}\cdot\vec{r} + \varphi)}}}`$*   

   * soit en **notation complexe** :  
      <br>
      1D : **$`\;\large{\boldsymbol{\mathbf{\underline{U}(x,t)}}}`$** $`\;= A\cdot \underbrace{exp\,[\,i\,(\omega t - k x + \varphi}_{\color{blue}{exp(a+b) = exp(a)\times exp(b)})\,]}`$   
           <br>
          $`\;\quad\quad\quad\quad\quad =\underbrace{A\;e^{\,i\,\varphi}}_{\color{blue}{\underline{A}=A\; e^{\,i\,\varphi}}}\cdot exp\,[\,i\,(\omega t - kx)\,]`$
           <br>
          **$`\;\quad\quad\quad\quad\quad\boldsymbol{\mathbf{\large{\,=\underline{A}\cdot e^{\,i\,(\omega t - kx)}}}}`$**    
     <br>
      3D : **$`\;\large{\boldsymbol{\mathbf{\underline{U}(\vec{r},t)=\underline{A}\cdot e^{\,i\,(\omega t - \vec{k}\cdot\vec{r})}}}}`$**   
     <br>
     avec *$`\boldsymbol{\large{\mathbf{\underline{A}=A\; e^{\,i\varphi}}}}`$ : amplitude complexe*.
 
<br>

* L'**onde $`U(x,t)`$** est **réelle** et s'exprime comme la *partie réelle de l'onde complexe $`\underline{U}(x,t)`$*.  
 
<br>

* L'**amplitude réelle $`A`$** de l'onde s'exprime comme la *racine carrée du produit*
  *de l'amplitude complexe $`\underline{A}`$ par son complexe conjugué $`\underline{A}^{\ast}`$* :   
  * $`\underline{A}=A\,e^{\,i\,\varphi}`$ : amplitude complexe.
  * $`\underline{A}^{\ast}=A\,e^{\,-i\,\varphi}`$ : amplitude complexe conjuguée.

  $`\begin{align}
      \large{\mathbf{\color{brown}{\quad \sqrt{\underline{A}\,\underline{A}^{\ast}}}}} &= \sqrt{A\,e^{\,i\,\varphi}\times A\,e^{\,-i\,\varphi}}\\  
  \\
  &= \sqrt{A^2\,e^{\,i\,\varphi}\,e^{\,-i\,\varphi}} = \sqrt{A^2\,e^{\,(i-i)\,\varphi}}\\
  \\
  &= \sqrt{A^2\,e^0}=\sqrt{A^2} = \vert\,A\,\vert^2\\
  \\
  &\large{\mathbf{\color{brown}{= A}}}\end{align}`$




##### Quel est l'intérêt de la notation complexe ?

* De difficulté mathématique équivalente à la notation réelle pour le calcul de la superposition de deux OPPH.
* **Indispensable** pour le calcul de la *superposition d'un nombre fini (>2) ou infini d'OPPH*,   
  lorsqu'elles sont de *même amplitude* et *déphasées 2 à 2 d'un pas constant* :   

* Permet de **calculer et comprendre** le principe physique :   
   * des *réseaux de diffraction*, intervenant dans les **monochromateurs** à réseaux
   * d'une *figure de diffraction*.
   * de la *diffraction* des ondes *par la matière cristalline*.
   * les **filtres optiques interférentiels**
   * ...


<br>

##### Qu'est-ce que la représentation de Fresnel d'une OPPH ?

* Soit un **nombre complexe $`\underline{U}_1`$**.
 
* $`\underline{U}_1`$ peut s'exprimer :
   * avec son *amplitude réelle $`A_1`$* et son *argument $`\theta_1`$* :   
     <br>
     **$`\mathbf{\underline{U}_1=A_1\;e^{\,i\,\theta_1}}`$**   
     <br>
   * avec ses *composantes réelle $`A_1 cos\,\theta_1`$ et imaginaire $`A_1 sin\,\theta_1`$* :  
     <br>
     **$`\mathbf{\underline{U}_1=A_1\cos\,\theta_1\;+\;i\,A_1\sin\,\theta_1}`$**
     

* La *représentation de $`\underline{U}`$ est un **vecteur** géométrique dans l'espace des nombres complexes.

* Le vecteur représentatif se décompose en *deux composantes* par projection orthogonale selon deux axes orthogonaux :
   * axe des *nombres réels*
   * axe des *nombres imaginaires*   
 
* La **norme** du vecteur est l'amplitude réelle *amplitude réelle $`A_1`$*   
  L'**angle** exprimé en radian que forme le vecteur avec l'axe réel est l'*argument $`\theta_1`$*.


* Dans le cas de la **notation complexe d'une OPPH** l'argument *$`\theta_1`$* représente la *phase* de l'OPPH :    <br>
  *$`\mathbf{\theta_1=\omega  1 t+ \varphi_1}`$*   
  <br>

![](fresnel-representation-complex-number_L1200.jpg)

<br>

* En représentation de Fresnel, Une *OPPH en un point* de l'espace est donc représentée par un **vecteur tournant**,
  à la **pulsation $`\omega_1`$**.

![](plane-wave-progressive-monochrome-complex-representation_L1200.gif)

<br>

##### Quel est l'intérêt de la représentation de Fresnel ?

* C'est une **représentation visuelle** d'un nombre complexe.
* *Moins puissante que les calculs en notation complexe*, elle permet de déduire facilement
  l'amplitude résultant de la **superposition d'un petit nombre d'OPPH**.

<br>

#### L'onde plane progressive harmonique est-elle physiquement réaliste ?

* Une onde progressive sinusoïdale $`U(\vec{r},t) = U_0\cdot \cos(\omega t - \vec{k}\cdot\vec{r} + \varphi)`$ :
  * existe de tout temps : $`t\in ]-\infty ; +\infty[`$
  * est définie en tout point de l'espace, de vecteur position $`\vec{r}`$   
  
*  Elle transporterait donc une *énergie infinie*.

*  $`\Longrightarrow`$ une onde sinusoïdale progressive est **physiquement irréaliste**.



##### Quel est alors son l'intérêt ?

* Elle est une **solution évidente** de l'équation d'onde.

* La *linéarité de l'équation d'onde* permet d'exprimer toute **onde physique** solution de cette équation
  comme une *combinaison linéaire* d'ondes planes progressives sinusoïdales.

* C'est l'*analyse de Fourier* qui permet de calculer cette décomposition d'une onde physique en
  son **spectre** d'ondes planes progressives sinusoïdales.



##### Qu'est-ce que le principe de superposition linéaire ?


* Il s'applique si dans un milieu toute onde créée par une source n'est pas modifiée par la présence 
  ou non d'autres ondes créées par d'autres sources.

* Dans ce cas, en présence de nombreuses onde, l' **élongation résultante** en tout point de l'espace et à tout instant s'exprime
  comme la *somme des élongations* qui seraient induites par chacune *des ondes individuelles* (comme si elles
  étaient seules) en présence.   
  
* Expression mathématique du **principe de superposition** :      
  Soient $`n`$ ondes notées $`U_i(\overrightarrow{r},t)\;(avec i\in\{1,\dots,n\})`$, 
  l'onde totale résultante $`U_{tot}(\overrightarrow{r},t)`$ s'écrit :   
  <br>
  **$`\mathbf{\displaystyle\large{U_{tot}(\overrightarrow{r},t) = \sum_{i=1}^{n} U_i(\overrightarrow{r},t)}}`$**



##### Qu'est-ce que le théorème de Fourier ?

* **Théorème fondamental** qui intervient dans *tous les domaines de la physique*.   
  Il précise que :   

* **toute fonction périodique $`^{\;(1)}`$** $`f(t)`$ de fréquence $`\nu`$ peut s'exprimer comme une *somme discrète*
  *de fonctions sinusoïdales* de fréquences $`n\nu`$ multiples de $`\nu`$, et de différentes phases à l'origine.    
   * en notation réelle :   
     $`\displaystyle f(t) = f_0 + \sum_{n=1}^{\infty} F_n\,\cos\,(2\pi\,n\nu\,t\,+\,\varphi_n)`$  
     <br>
     avec $`F(\nu)`$ l'amplitude de la composante de fréquence $`n\nu`$.


   * en notation complexe :   
     $`\displaystyle f(t) = f_0 + \sum_{n=1}^{\infty} F_n\,\exp\,(i\,2\pi n\nu t+\varphi_n)`$ 


   * *$`f_0`$* est la **composante continue**.
   * la fonction périodique de *plus basse fréquence*, $`\nu`$, est appelée **composante fondamentale**
   * les fonctions de *fréquences $`n\nu`$ avec $`n >1`$* sont appelées **composantes harmoniques**.
   * **$`F_n`$** est l'*amplitude de la composante de fréquence $`n\nu`$*.

<br>
* **toute fonction non périodique$`^{\;(1)}`$** $`f(t)`$ de fréquence $`\nu`$ peut s'exprimer comme une
  *somme intégrale d'ondes sinusoïdales* de différentes fréquences et phases à l'origine.   
   * en notation complexe :   
     $`\begin{align}\displaystyle f(t) &= f_0 + \int_{-\infty}^{+\infty} F(\nu)\,\exp\big(i\,2\pi\nu\,t\,+\,\varphi(\nu)\big) \,d\nu \\
       \\
       &= f_0 + \int_{-\infty}^{+\infty} \underline{F(\nu)}\,\exp\big(i\,2\pi\nu\,t)\,d\nu \\
        &\quad\quad\quad\quad\quad\text{ avec }\underline{F(\nu)} = F(\nu)\,e^{\,i\varphi(\nu)}
       \end{align}`$ 

*   * **$`\underline{F(\nu)}`$** est l'*amplitude complexe* de la composante de fréquence $`\nu`$.

* **$`\mathbf{(1)}`$** : sous réserve de quelques restrictions peu contraignantes en physique.
  

##### Qu'est-ce que le spectre d'une fonction $`f(t)`$ ?

* Le **spectre** d'une fonction $`f(t)`$ est l'*information sur toute les composantes* qui composent $`f(t)`$ :    
  * *fréquences* des composantes d'amplitude non nulle.
  * *amplitudes* de ces composantes.

* La **représentation** d'un spectre est données dans *deux graphes* :
   * Le graphe en *amplitude $`F(\nu)`$*.   
   * Le graphe en *phase à l'origine $`\varphi(\nu)`$*.   
  <br>
  _(figures à faire, un exemple de $`f(t)`$ et sa décomposition spectrale en $`F(\nu)`$) et $`\varphi(\nu)`$._

<br>   

------------------------------------------------

#### Quelles sont les phénomènes propres aux ondes ?

* Ces phénomènes ne sont pas décrits par la physique classique appliquée aux corps et corpuscules.

* Lorsque *une ou plusieurs ondes* se propagent dans *un même milieu* :

   * Le phénomène d'**interférence** peut être observé en présence de plusieurs ondes.
     
   * Le phénomène de **diffraction** peut être observé lorsqu'un obstacle pertube la propagation d'une onde.

* Lorsque *une onde* rencontre une *interface entre deux milieux différents*

   * Le phénomène de **réflexion**  peut être observé.
   * Le phénomène de **réfraction** peut être observé lorsque l'onde traverse l'interface.
   * 
   
--------------------------------------------


#### Qu'est-ce que le phénomène d'interférence ?

Le phénomène d'interférence est le fait que lorsque des ondes se superposent dans l'espace et le temps,
l'amplitude de l'onde resultante n'est pas la somme des amplitudes des ondes en présence.

![interférences entre deux ondes sphériques d'égale amplitiudes et déphasées de pi,
et propagation des zéros](2_sources_circulaires_dephasees_pi_v2_L1000.gif)

* La figure ci-dessus est la **représentation symbolique des interférences** créées par la 
  *superposition de deux ondes circulaires synchrones*, de même amplitude mais en opposition de phases à leurs sources.

* L'*interprétation des couleurs* se rapproche de l'expérience de la cuve à onde.
    * zone du **bleu le plus foncé** : *valeur maximale* pour l'élongation de l'onde résultante.   
      _(crêtes des vaguelettes observées)._
    * zone du **bleu le plus clair** : *valeur minimale*.
      _(creux des vaguelettes observées)._
    * zone de **bleu moyen** : *élongation nulle*.

  * On discerne des **lignes stationnaires** sur lesquelles l'*élongation nulle*.    
    Elles correspondent à des zones qui restent non perturbées.
    

<!----------------
!!! déphasées de $`/pi`$ à leurs sources
!!! <details markdown=1>
!!! <summary>Représentation symbolique des interférences créées par deux ondes sphériques.<br>
!!! </summary>
!!! La figure représente les interférences de deux ondes progressives sphériques $`U_1(\vec{r},t)`$ et $`U_1(\vec{r},t)`$, synchrones mais 
!!! déphasées de $`/pi`$ à leurs sources en $`S_1`$ et $`S_2`$.
!!! Afin de mieux visualiser le phénomène, la modélisation des sources sphériques n'est pas physique. 
$`U(\vec{r},t)=U_0\cdot\cos(k r-\omega t)`$ au lieu de $`U(\vec{r},t)=\dfrac{U_0}(r}\cdot\cos(kr-\omega t)`$ 
pour une onde progressive sphérique se propageant dans l'espace. Pour une onde sphérique réelle non amortie, 
la décroissance en $`1/r`$ de l'amplitude de l'onde à partir de sa source en $`r=0`$ permet la conservation de
l'énergie. 
Considérons une onde dont la puissance transportée 
En effet, au cours de sa progression, l'intensité $`I_O`$ proportionnelle en tout point à $`U_O^2`$ ontenue sur un front d'onde se répartie 
sur la surface $`4\pi r^2`$ sur une sphère de rayon croissant r au fur et à mesure de la progression.
de ra
Le modèle mathémait
!!! Même en absence de phénomène
!!! l'équation de propagation
!!! </details>




* Une onde projette de l'énergie.

* Le **phénomène d'interférence** apparaît lors de la *superposition de plusieurs ondes* dans l'espace.

* Il y a interference lorsque la *distribution spatiale d'énergie résultante* d'une superposition d'ondes
  n'est **pas égale à** la *somme des distributions d'énergie propres à chaque onde* prise isolément.


---------------->



##### Que signifient "interférences constructives" et "interférence destructives" ?


##### Que représentent les noeuds et les ventres ?


##### Quelle lien entre interférences et ondes stationnaires ?

<br>

------------------------------------------------

#### Interférences produites par la superposition de deux OPPH synchrones ou cohérentes.


##### Qu'est-ce que deux OPPH synchrones ?

* **Deux OPPH** de pulsations respectives $`\omega_1`$ et $`\omega_2`$ sont **synchrones** si leurs *pulsations sont égales* :   
  <br>
  *$`\omega_1 = \omega_2`$*


##### Les OPPH qui interfèrent ont une même amplitude, ne même direction et un même sens de propagation.

* Les **deux OPPH** sont :
   * *synchrones ou cohérentes* (en optique)
   * d'*amplitudes égales*
   * et se propagent *vers les $`x`$ croissants*.

<br>

-------------------

**Calcul de l'onde résultante** *en notation réelle*

* En notation réelle, les deux OPPH s'écrivent :   
  <br>
  **$`\boldsymbol{\mathbf{U_1(x,t) = A\cdot cos(\omega t - kx + \varphi_1)}}`$**   
  **$`\boldsymbol{\mathbf{U_2(x,t) = A\cdot cos(\omega t - kx + \varphi_2)}}`$**

* Calcul de l'onde résultante :  
  <br>
  $`\color{brown}{\mathbf{U(x,t)}}\; = U_1(x,t) + U_2(x,t)`$   

$`\begin{align} \quad &=A\;\big[\,cos(\underbrace{\omega t - kx}_{\color{blue}{\text{  posons }\\ \omega t - kx \,=\, \alpha}} + \varphi_1) + cos(\underbrace{\omega t - kx}_{\color{blue}{=\; \alpha}} + \varphi_1)\,\big]
&\\
&=A\;\big[\,cos\Big(\alpha + \dfrac{\varphi_1+\varphi_1}{2} + \dfrac{\varphi_2-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\alpha + \dfrac{\varphi_2+\varphi_2}{2} + \dfrac{\varphi_1-\varphi_1}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,cos\Big(\underbrace{\alpha + \dfrac{\varphi_1+\varphi_2}{2}}_{\color{blue}{=\;\alpha '}} + \dfrac{\varphi_1-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\underbrace{\alpha + \dfrac{\varphi_1+\varphi_2}{2}}_{\color{blue}{\text{nous avons posé }\\ \alpha + (\varphi_1+\varphi_2)/2\; = \;\alpha '}} - \dfrac{\varphi_1-\varphi_2}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,cos\Big(\alpha ' + \dfrac{\varphi_1-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\alpha ' - \dfrac{\varphi_1-\varphi_2}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,\underbrace{cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,-\,sin(\alpha ')\,sin\Big(\dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{\text{car   }cos(a+b)\;=\;cos\,a\,cos\,b\;-\;sin\,a\,sin\,b}}\big)\\
&\quad + \underbrace{cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,+\,sin(\alpha ')\,sin\Big(\dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{\text{car   }cos(a-b)\;=\;cos\,a\,cos\,b\;+\;sin\,a\,sin\,b}}\big)\,\Big]\\
&\\
&=2\,A\cdot cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)
\end{align}`$   
<br>
$`\quad\boldsymbol{\mathbf{=\color{brown}{2\,A\cdot cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big) \cdot cos\Big(}\color{blue}{\underbrace{\color{brown}{\omega t - kx + \dfrac{\varphi_1+\varphi_2}{2}}}_{\text{pulsation }\omega\text{ inchangée}}}\color{brown}{\Big)}}}`$

-----------------------------------------

* L'*onde résultante*
   * est **harmonique**.
   * a la **même fréquence** $`\nu\,=\,\dfrac{\omega}{2\pi}`$ que les deux ondes initiales.
   
* L'**amplitude** de l'onde résultante est :   
  <br>
  **$`\boldsymbol{\mathbf{A_{résult.} = \left| \,2\,A\cdot cos\Big(\dfrac{\varphi_1 - \varphi_2}{2} \Big) \,\right|}}`$**   
  <br>
  $`\quad\quad\quad=\sqrt{4\,A^2 \cdot cos^2\Big(\dfrac{\varphi_1 - \varphi_2}{2}\Big)}`$   
  <br>
  $`\color{blue}{\scriptsize{\left.\begin{align} \quad\quad &cos(a+b)=cos(a)cos(b)-sin(a)sin(b)\\
                     &cos(a-b)=cos(a)cos(b)+sin(a)sin(b)\end{align}
               \right\}\Longrightarrow\\
        \quad\quad cos^2(a)=cos(a)cos(a)=\dfrac{1}{2}[cos(a+a)+cos(a-a)]\\
        \quad\quad\quad\quad=\dfrac{1}{2}[1 + cos(2a)]}}`$   
   <br>
   $`\boldsymbol{\mathbf{\quad\quad \color{brown}{=\sqrt{2\,A^2 \cdot \big(1 + cos\,(\varphi_1 - \varphi_2)\big)}}}}`$

<br>

----------------------------

**Calcul de l'onde résultante** *en notation complexe*

* Une **onde harmonique réelle $`U_1`$** s'écrit comme la *partie réelle de l'onde harmonique complexe $`\underline{U_1}`$*.   
  <br>
  $`\begin{align} U_1&(x,t) = A\cdot cos(\omega t - kx + \varphi_1)\\
     &\\
     &= \mathscr{Re}\big[A\cdot \big(cos(\omega t - kx + \varphi_1)\\
     &\quad\quad\quad\quad + i\;sin(\omega t - kx + \varphi_1)\big)\big]\\
     &\\
     &= \mathscr{Re}\big[A\cdot e^{\,i\;(\omega t - kx + \varphi_1)} \big]\\
     &\\
     &= \mathscr{Re}\big[\underline{U_1}(x,t)\big] \end{align}`$

* Le deux ondes harmoniques qui interfèrent, d'écriture réelle :   
   <br>
     $`U_1(x,t) = A\cdot cos(\omega t - kx + \varphi_1)`$   
     $`U_2(x,t) = A\cdot cos(\omega t - kx + \varphi_2)`$   
   <br>
   s'écrivent en notation complexe :   
   <br>
     **$`\boldsymbol{\mathbf{\underline{U_1}(x,t) = A\cdot e^{\,i\;(\omega t - kx + \varphi_1)}}}`$**    
     **$`\boldsymbol{\mathbf{\underline{U_2}(x,t) = A\cdot e^{\,i\;(\omega t - kx + \varphi_2)}}}`$**   
   <br>

<!---------------------
   soit encore :   
   <br>
     $`\begin{align}\underline{U_1}(x,t) &= \underline{A_1}\cdot e^{\,i\;(\omega t - kx)}\\
       &\quad\quad\text{avec }\underline{A_1} = A_1\,e^{\,i\;\varphi_1}\end{align}`$.  
     <br>
     $`\begin{align}\underline{U_2}(x,t) &= \underline{A_2}\cdot e^{\,i\;(\omega t - kx)}\\
       &\quad\quad\text{avec }\underline{A_2} = A_2\,e^{\,i\;\varphi_2}\end{align}`$.  
     <br>
    ou $`\underline{A_2}`$ et $`\underline{A_2}`$ sont les amplitudes complexes des deux ondes.
---------------------------->
  
* Calcul de l'onde complexe résultante :  
  <br>
  **$`\mathbf{\underline{U}(x,t)}`$**$`\; = \underline{U_1}(x,t) + \underline{U_2}(x,t)`$    
  <br>
  $`\quad =A\;\big[ \,e^{\,i\;(\omega t\,-\, kx \,+ \,\varphi_1)} + e^{\,i\;(\omega t\, - \,kx \,+ \,\varphi_2)}\,\big]`$     
  <br>
  $`\color{blue}{\scriptsize{\quad\text{mettons en commun les termes qui peuvent l'être}}}`$   
  <br>
  $`\quad =A\;e^{\,i\;(\omega t\,-\, kx)}`$
  $`\cdot\big(\,e^{\,i\varphi_1}\,+\,e^{\,i\varphi_1}\big)`$   
  <br>
  $`\quad =A\;e^{\,i\;(\omega t\,-\, kx)}`$
  $`\cdot\Big(\,e^{\,i\big(\frac{\varphi1 + \varphi2}{2}\;+\;\frac{\varphi1-\varphi2}{2}\big)}`$
  $`\,+\,e^{\,i\;\big(\frac{\varphi1 + \varphi2}{2}\;-\;\frac{\varphi1-\varphi2}{2}\big)}\Big)`$   
   <br>
   $`\color{blue}{\scriptsize{\quad \text{utilisons } exp\,(a+b)\;=\; exp\,(a)\;\times\; exp\,(b)}}`$  
   $`\color{blue}{\scriptsize{\quad\text{et regroupons encore les termes communs.}}}`$   
   <br>
   $`\quad = A\;e^{\,i\,(\omega t\,-\, kx)}\,e^{\,i\,\left(\frac{\varphi1 + \varphi2}{2}\right)}`$
   $`\cdot\Big(
\,e^{\,i\big(\frac{\varphi1-\varphi2}{2}\big)}
\,+\,
e^{\,-\,i\;\big(\frac{\varphi1-\varphi2}{2}\big)}
\Big)`$
   <br>
   $`\color{blue}{\scriptsize{\quad \text{utilisons} \quad exp\,(i\,a)\,+\,exp\,(-\,i\,a)\;=\;2\,cos\,a}}`$  
   <br>
   $`\quad = 2\,A\;e^{\,i\;(\omega t\,-\, kx)}\,e^{\,i\,\left(\frac{\varphi1 + \varphi2}{2}\right)}`$
   $`\cdot \,cos\left(\frac{\varphi1-\varphi2}{2}\right)`$   
  <br>
   $`\quad = 2\,A\;cos\left(\frac{\varphi1-\varphi2}{2}\right)\;e^{\,i\,\left(\omega t\,-\, kx\,+\,\frac{\varphi1 + \varphi2}{2}\right)}`$   
   <br>
  L'onde réelle est donc :  
  <br>
 **$`\mathbf{\underline{U}(x,t)}`$**   
  $`\quad\boldsymbol{\mathbf{=\color{brown}{2\,A\cdot cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big) \cdot cos\Big(}\color{blue}{\underbrace{\color{brown}{\omega t - kx + \dfrac{\varphi_1+\varphi_2}{2}}}_{\text{pulsation }\omega\text{ inchangée}}}\color{brown}{\Big)}}}`$

  <br>
  Bien sûr nous obtenons le même résultat qu'avec le calcul en notation réelle.

<br>

------------------------------------

##### Les OPPH qui interfèrent sont d'amplitudes égales et se propagent en sens opposés.


* Les **deux OPPH** sont :
   * *synchrones ou cohérentes* (en optique)
   * d'*amplitudes égales*
   * et se propagent, l'une *vers les $`x`$ croissants* **et** l'autre *vers les $`x`$ décroissants*

![waves_interferences_ventres_noeuds](waves_interferences_ventres_noeuds_niv_3a_L1200.gif)


**Calcul de l'onde résultante** *en notation réelle*

A faire

**Calcul de l'onde résultante** *en notation complexe*

  
  ![](stationary-wave-1D-ventre_L1200.jpg)   
  ![](waves-interferences-ventres-noeuds-niv_3a-2_L1200.gif)   
  ![](stationary-wave-1D-noeud_L1200.jpg)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;_Onde stationnaire unidimensionnelle._
  
  ![](2D-stationary-wave_L1200.gif)
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;_Onde stationnaire bi oi tri-dimensionnelle._ 
  
* L'*onde résultante* est :

A faire

* Définir :
   * l'onde
   * les interférences constructives
   * les interférences destructives
   * les noeuds
   * les lignes nodales.
   * les ventres.


<!-------------------
$`\begin{align} \quad &=A\;\big[\,cos(\underbrace{\omega t - kx}_{\color{blue}{\text{  posons }\\ \omega t + kx \,=\, \alpha}} + \varphi_1) + cos(\underbrace{\omega t - kx}_{\color{blue}{=\; \alpha}} + \varphi_1)\,\big]
&\\
&=A\;\big[\,cos\Big(\alpha + \dfrac{\varphi_1+\varphi_1}{2} + \dfrac{\varphi_2-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\alpha + \dfrac{\varphi_2+\varphi_2}{2} + \dfrac{\varphi_1-\varphi_1}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,cos\Big(\underbrace{\alpha + \dfrac{\varphi_1+\varphi_2}{2}}_{\color{blue}{=\;\alpha '}} + \dfrac{\varphi_1-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\underbrace{\alpha + \dfrac{\varphi_1+\varphi_2}{2}}_{\color{blue}{\text{nous avons posé }\\ \alpha + (\varphi_1+\varphi_2)/2\; = \;\alpha '}} - \dfrac{\varphi_1-\varphi_2}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,cos\Big(\alpha ' + \dfrac{\varphi_1-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\alpha ' - \dfrac{\varphi_1-\varphi_2}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,\underbrace{cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,-\,sin(\alpha ')\,sin\Big(\dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{\text{car   }cos(a+b)\;=\;cos\,a\,cos\,b\;-\;sin\,a\,sin\,b}}\big)\\
&\quad + \underbrace{cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,+\,sin(\alpha ')\,sin\Big(\dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{\text{car   }cos(a-b)\;=\;cos\,a\,cos\,b\;+\;sin\,a\,sin\,b}}\big)\,\Big]\\
&\\
&=2\,A\cdot cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)
\end{align}`$   
<br>
$`\quad\boldsymbol{\mathbf{=\color{brown}{2\,A\cdot cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big) \cdot cos\Big(}\color{blue}{\underbrace{\color{brown}{\omega t - kx + \dfrac{\varphi_1+\varphi_2}{2}}}_{\text{pulsation }\omega\text{ inchangée}}}\color{brown}{\Big)}}}`$

---------------->




#### Quel lien entre l'énergie et l'amplitude de l'onde ?

* Une onde projette de l'énergie à travers l'espace.

* *Selon la grandeur physique* que décrit l'onde, l'**énergie** $`\mathscr{E}`$ de l'onde contenue
  en tout élément de volume $`d\tau_P`$ de l'espace.
  (apparaissant comme ponctuel à l'échelle d'observation, et donc représenté par un point $`P`$)
  est **proportionnelle** :
   * au **carré de l'amplitude** de l'onde en ce point.
   * (moins souvent) **à l'amplitude** de l'onde en ce point.

<br>

#### Quels liens entre l'énergie, la puissance, l'intensité d'une onde ?

* L'**intensité** de l'onde est l'*énergie* traversée *par surface élémentaire $`dS`$ en un temps infinitésimal $`dt`$*.   
  $`\Longrightarrow`$ unité S.I. : *$'J\,s^{-1}\,m^{-2}\;=\; W\,m^{-2}`$*.   


* Si un **capteur** *prélève une partie $`\mathscr{W}`$ de l'énergie* de l'onde, la **puissance reçue $`\mathscr{P}`$**
  par le capteur est :  
  <br>
  **$`\mathbf{\mathscr{P} = \dfrac{d\mathscr{W}}{dt}}\quad,`$** unité S.I. : *$`J\,s^{-1}`$*.
   * Un **capteur "rapide"** qui *suit la variation d'intensité au cours d'une période*
     temporelle de l'onde (onde périodique) **mesure la puissance instantanée $`\mathscr{P}(t)`$** :   
     <br>
     $`\mathscr{P}(t) = \dfrac{d\mathscr{W}}{dt}(t)`$
   <br>
   * Un **capteur "lent"** sensible uniquement à la puissance moyenne reçue sur une période temporelle $`\Delta t`$ très grande
     devant la période $`T`$ de l'onde (onde périodique) **mesure la puissance moyenne $`<\mathscr{P}(t)>`$** :  
     <br>
     $`\displaystyle <\mathscr{P}(t)> = \dfrac{1}{\Delta t} \int_{t=0}^{\Delta t} \mathscr{P}(t)`$,  
     <br>
     $`\quad\quad\text{lorsque } \Delta t >> T,\quad T\text{ période de l'onde}`$

<br>


#### Pourquoi parfois seule l'amplitude de l'onde résultante est nécessaire ?

* Lorsque le **capteur** a un **temps de réponse $`\delta t`$ grand devant la périodocité $`T`$** de l'onde, 
il n'arrive pas à suivre la variation de l'élongation au sein d'une période temporelle.

* $`\Longrightarrow`$ Il n'est ainsi pas sensible à la puissance instantanée,    
  il n'est sensible et *ne mesure que la puissance $`<\mathscr{P}(t)>`$* moyennée sur la durée $`\delta t`$,

*  $`<\mathscr{P}(t)>`$ est *proportionnelle* à l'énergie contenue dans l'onde, soit suivant le type d'onde : 
   * **au carré de l'amplitude**.
   * (moins souvent) **à l'amplitude**.

!!! <details markdown=1>
!!! <summary>
!!! *Exemple 1*
!!! </summary>
!!! <br>
!!! *Un photodétecteur de lumière (UV, visible, infrarouge) ou un oeil humain (visible)* <br>
!!!
!!! Le *spectre visible* est un petit domaine de longueurs d'onde dans le vide s'étendant *de 380 à 780*
!!! *nanomètres*. 
!!!
!!! Prenons par exemple la longueur d'onde *$`\lambda = 500\,nm`$*, qui est perçue
!!! comme formant une *couleur verte*. Quelle est la fréquence temporelle $`\nu`$ correspondante ?   
!!! <br>
!!! $`\lambda = c\,T = \dfrac{c}{\nu}\Longrightarrow \nu=\dfrac{\lambda}{c}`$   
!!! <br>
!!! *$`\nu_{\lambda=500nm} = \dfrac{3\times 10^8 \; m\,s^{-1}}{500\times 10^{-9}\,m} = 6\times 10^{14}\,Hz`$*   
!!! <br>
!!! Aucune chaine de mesure n'est capable de suivre la variation de la puissance instantanée au sein d'une 
!!! *période temporelle de l'onde $`T=1\,/\,\nu = 1,6\times 10^{-15\,s}`$*.
!!!
!!! *Photodétecteurs comme oeil* ne sont *seulement sensibles à la puissance moyennée*.
!!!
!!! Pour le calcul d'une figure d'interférence ou de diffraction dans le dommaine visible, vue par l'oeil
!!! ou mesurée par un photodétecteur ou une matrice de détecteur, la grandeur physique à prendre en compte est
!!! le *carré de l'amplitude* de l'onde.
!!! </details>

!!! <details markdown=1>
!!! <summary>
!!! *Exemple 2*
!!! </summary>
!!! <br>
!!! *notre perception des sons.* <br>
!!!
!!! Le *spectre sonore audible* par l'ouïe humain s'étend de *20 à 20000 Hz*
!!!
!!! La chaine de mesure des sons de l'ouïe humain traduit, au stade final de la conscience, fréquence et intensité
!!! de l'onde sonore en terme de hauteur, de timbre et niveau d'intensité d'un son.
!!!
!!! Nous ne discernons pas la variation d'intensité sonore au sein d'une période temporelle d'un son
!!! pur (ou sinusoïdal). Nous ne sommes sensibles qu'à la puissance moyenne de l'onde sonore.
!!! </details>


#### Comment calculer l'amplitude seule de l'onde résultante ?

##### 1 - Superposition de deux ondes synchrones (cohérentes en optique) d'amplitude différentes


![](waves_sum_2_progressives_meme_sens_v2.gif)   
_La superposition de deux ondes harmoniques est une onde harmonique._


* Les deux OPPH se superposent en un point $`x_0`$ de l'espace.    
  Elles s'écrivent en fonction du temps :    
  <br>
  En *notation réelle* :   
   * $`U_1(t) = A_1\cdot cos(wt-kx+\varphi_1) = A_1\cdot cos \,\theta_1(t)`$   
   * $`U_2(t) = A_2\cdot cos(wt-kx+\varphi_2) = A_1\cdot cos \,\theta_2(t)`$

  En *notation commlexe* :  
   * $`\underline{U}_1(t) = A_1\,e^{\,i\,\theta_1(t)}`$   
   * $`\underline{U}_2(t) = A_2\,e^{\,i\,\theta_2(t)}`$

  Et en *représentation de Fresnel* elles se décrivent par deux vecteurs tournants :    
   * $`\overrightarrow{U}_1`$ d'amplitude $`A_1`$ qui tourne à la pulsation $`\omega`$
     avec un déphasage à l'origine $`\varphi_1`$.
   * $`\overrightarrow{U}_2`$ d'amplitude $`A_2`$ qui tourne à la même pulsation $`\omega`$
     avec un déphasage à l'origine $`\varphi_2`$.    

![](sum-two-plane-wave-progressive-monochrome-complex-representation-1_L1200.gif)

* Soit $`U_(t)`$ l'onde résultante de la superposition de $`U_1(t)`$ et $`U_2(t)`$, 
  et $`\overrightarrow{U}(t)`$ son vecteur représentatif.   
  <br>
  $`U_1(t)`$ et $`U_2(t)`$ ayant la même pulsation, leur différence de phase $`\varphi_2 - \varphi_1`$
  reste stationnaire.   
  <br>
  $`\Longrightarrow\quad \color{brown}{\overrightarrow{U}(t)}`$ est un **vecteur de norme constante** 
  qui tourne à la **pulsation $`\omega`$**.   
  <br>

![](sum-two-plane-wave-progressive-monochrome-complex-representation-2_L1200.gif)

  Il **représente une OPPH** d'écritures réelle et complexe :   
   * $`U(t) = A\, cos \,\theta(t)`$    
   * $`\underline{U}(t) = A\,e^{\,i\,\theta(t)}`$    
  et telle que son amplitude soit la norme du vecteur $`U_(t)`$ :   
   $`A = \|\overrightarrow{U}\|`$

<br>

![](sum-two-plane-wave-progressive-monochrome-complex-representation-3_L1200.jpg)

* Calculons l'amplitude de l'onde résultante avec la représentation de Fresnel.

**$`\mathbf{A = \|\overrightarrow{U}\| =\sqrt{\overrightarrow{U}\cdot\overrightarrow{U}}}`$**

$`=\sqrt{\big(\overrightarrow{U}_1 + \overrightarrow{U}_2\big)\cdot\big(\overrightarrow{U}_1 + \overrightarrow{U}_2\big)}`$

$`=\sqrt{\overrightarrow{U}_1\cdot\overrightarrow{U}_1 + \overrightarrow{U}_2\cdot\overrightarrow{U}_2+2\;\overrightarrow{U}_1\cdot\overrightarrow{U}_2}`$

$`=\sqrt{\|\overrightarrow{U}_1\|^2+ \|\overrightarrow{U}_2\|^2+2\;\|\overrightarrow{U}_1\|\;\|\overrightarrow{U}_2\|\;cos\Big(\widehat{\overrightarrow{U}_1,\overrightarrow{U}_2}\Big)}`$

$`=\sqrt{A_1^2\;+\;A_2^2\;+\;2 \;A_1\,A_2\;cos(\theta_2-\theta_1)}`$**

**$`\mathbf{ =
 \sqrt{A_1^2\;+\;A_2^2\;+\;
2 \;A_1\,A_2\;cos(\varphi_2-\varphi_1)}}`$**

<br>

* Calculons l'amplitude de l'onde résultante en notation complexe.  

**$`\mathbf{A = \sqrt{\underline{A}\,\underline{A}^{\ast}}}`$**

$`=\sqrt{(A_1\,e^{\,i\,\theta_1}+A_2\,e^{\,i\,\theta_2})\cdot(A_1\,e^{\,-i\,\theta_1}+A_2\,e^{\,-i\,\theta_2})}`$

$`=\sqrt{A_1^2\,e^0 +A_2\,e^0 + A_1 e^{\,i\,\theta_1} A_2\,e^{\,-i\,\theta_2} + A_1 e^{\,-i\,\theta_1} A_2\,e^{\,i\,\theta_2}}`$

$`=\sqrt{A_1^2 +A_2 + A_1A_2\,\big( e^{\,i\,(\theta_1 -\theta_2)} + e^{\,-i\,(\theta_1 - \theta_2}}`$

$`=\sqrt{A_1^2 +A_2 + 2\,A_1A_2\,cos\,(\theta_1 -\theta_2)}`$

**$`\mathbf{ =
 \sqrt{A_1^2\;+\;A_2^2\;+\;
2 \;A_1\,A_2\;cos(\varphi_2-\varphi_1)}}`$**

<br>

--------------------------------------

#### Qu'est-ce qu'une Onde Sphérique Progressive Harmonique ?

  * **O** *nde* **S** *phérique* **P** *rogressive* **H** *armonique* &equiv; **OSPH**


 *  Une **OSPH**, est une onde  :
    * **harmonique** de pulsation *$`\omega`$*   
      $`\Longrightarrow`$ elle est périodique dans le temps.   
    <br>
    * Sa **source** est observée *ponctuelle*, localisé en un point *$`S`$*.    
    <br>
    * **1 - ** Dans un milieu homogène et isotrope et à partir de sa source elle **se propage** *dans toutes les directions*
      avec une célérité *$`\mathscr{v}`$*.  
    <br>
    * **2 - ** La puissance moyenne propagée par l'onde et proportionnelle au carré de l'amplitude se répartissant sur des sphères centrées sur $`S`$ 
      et de rayons $`r`$ croissants à fur et à mesure de sa propagation, l'**amplitude  $`A\,/\,r`$** de l'onde
      n'est *pas constante et décroit en $`1\,/\,r`$*.
    <br>
    * *1 et 2* $`\;\Longrightarrow\;`$ l'OSPH n'a *pas de périodicité spatiale*.
     
* L' OSPH s'écrit :  
  <br>
  en *notation réelle* :   
  <br>
  **$`\large{\boldsymbol{\mathbf{U(\vec{r},t) = \dfrac{A}{r} \cdot \cos(\, \omega t\;- k\;r  + \varphi)}}}`$**.   
  <br>
  en *notation complexe* :  
  <br>
 **$`\large{\boldsymbol{\mathbf{U(\vec{r},t) = \dfrac{A}{r} \cdot e^{\,i\,(\omega t\;- k\,r\;  +\; \varphi)}}}}`$**.  
  <br>
  avec *$`r`$** *distance à la source $`S`$*.

! *Note*   
! Lorsque la source de l'OSPM, à terminer...

<br>

---------------------------------------------


#### Qu'est-ce que le principe d'Huygens-Fresnel ?

* Ce principe a été premièrement formulé par Christian Huygens en 1678.   
  Il a été ensuite modifié et étendue par Augustin Fresnel en 1818.

* C'est une **Théorie approchée**, initialement établie pour décrire les phanomènes ondulatoires en optique,
  qui *explique simplement*, de façon quantitative et correcte, le *phénomène de diffraction*
  propre à tout type d'onde.

 
* Le **principe de Fresnel-Huygens** :   
  <br>
  Soit une **source primaire** émettant une *onde progressive harmonique* de pulsation $`\omega`$.   
  <br>
  Un'**élément de surface $`dS_P`$** en tout point $`P`$ **d'un front de l'onde primaire** et
  de vecteur représentatif $`\overrightarrow{dS}_P`$ perpendiculaire au front d'onde et
  orienté dans le sens de propagation de l'onde primaire en $`P`$, se comporte comme une 
  *source secondaire* émettant dans le demi-espace devant elle une *onde sphérique progressive monochromatique* :   
   * de **même pulsation* $`\omega`$ que l'onde primaire.
   * de *même phase en $`P`$* que l'onde primaire.
   * d'amplitude proportionelle à l'amplitude de l'onde primaire en $`P`$ , et la surface élémentaire $`dS_P`$.

* $`\Longrightarrow`$ **En tout point $`M`$** situé dans le demi-espace situé devant le front d'onde en $`P`$, l'**onde résultante**
  est la *superposition de toutes les ondes secondaires* en $`M`$.

* $`\Longrightarrow`$ Les **ondes secondaires** se superposent et forment les *nouveaux fronts* d'ondes dans
  la direction de propagation.

<br>

![]( waves-fresnel-huygens-principle-2_L1200.jpg)    




<!------------------------
 * Enoncé : 
   
 * Domaine de validité :
    * donne une distribution d'intensité très proche de celle observée en réalité,
      lorsque celle-ci est calculée suffisamment loin des fentes
 * permet de calculer la figure de diffraction-interférence observée derrière un écran opaque
   percé de fentes et éclairé par une source cohérentes.
 * Lien avec la physique :


_Les deux thèmes suivants : réflexion et réfraction, sont à mettre dans un chapitre spécifique,
à pouvoir afficher en parallèle avec le chapitre correspondant en Optique Géométrique._

--------------------------->


--------------------------------------------

#### Qu'est-ce que le phénomène de diffraction ?

à faire

![](diffraction-lambda-wave_L1000.gif)

![](diffraction-width-split_v2_L1000.gif)

<br>

--------------------------------------------

#### Quelle différence entre interférence et diffraction ?

* Il n'y a pas de différence.

* Les deux phénomènes sont liés à la distribution spatiale d'amplitude ou d'intensité d'une onde
  résultante créée par un ensemble fini de sources synchrones, ou cohérentes (ondes lumineuses).
   * le terme **interférence** est utilisé quand les sources qui interfèrent sont des **sources discrètes**.   
     _exemple : figure d'interférence de deux fentes très fines._
   * le terme **diffraction** est utilisé quand les *sources forment un continuum*.   
     _exemple : figure de diffraction d'une fente large._

* Interférence et diffraction agissent toujours ensemble.   
     _exemple : figure d'interférence et de diffraction de deux fentes larges._
  
<br>


--------------------------------------------

#### Qu'est-ce que le phénomène de réflexion ?

à faire



--------------------------------------------

#### Qu'est-ce que le phénomène de réfraction ?
<br>

Une onde propage de l'énergie.

* Le **phénomène de réfraction** correspond à une *modification de la direction* de propagation
d'une onde *à la traversée d'une interface* entre deux milieux différents.   

* Ce phénomène de réfraction est **propre à toute onde**. Il s'observe en *optique, acoustique, sismologie, ...*

![refraction d'une onde plane sur un dioptre plan](wave-optics-n3-refraction-1_v2_L1000.gif)
_Modélisation du phénomène de réfraction d'une onde plane._

* La **période temporelle $`T`$** de l'onde, **grandeur fondamentale** propre à l'onde et donc 
  *ne dépend pas du milieu* de propagation.

* **Chacun des milieux**, de part et d'autre de l'interface, est caractérisé par 
   *sa propre vitesse de propagation* de l'onde.

* La **longueur d'onde $`\lambda`$**, distance parcourue par l'onde 
  au cours d'une période temporelle $`T`$, *dépend de la célérité* $`\mathscr{v}`$ et donc *du milieu*.


<br>

##### Quel rôle joue l'interface entre les deux milieux ?
<br>

![](refraction-intro-1_L1200.gif)

**a** - L'onde plane incidente change de direction à la traversée de l'interface entre les deux milieux.

**b** - Le **principe de Huygens-Fresnel** postule une *continuité de phase* de la fonction 
d'onde *à la traversée de l'interface* entre les deux milieux.

**c** - *Dans le plan de l'interface*, la fonction d'onde a une **périodicité $`\Lambda`$** 
qui dépend de l'angle d'incidence.


<br>

##### Quelle propriété de l'onde varie à la traversée de l'interface ?   
<br>

![](refraction-intro-2_L1200.gif)

* La **grandeur physique fondamentale** caractérisant une onde progressive *est temporelle*, soit :
   * sa période temporelle *$`T`$ ou* sa fréquence temporelle *$`\nu=1\,/\,T`$*.
   * sa pulsation *$`\omega = 2\pi\,\nu = 2\pi\,/\,T`$* pour une *onde harmonique*.
   

* L'**onde** progressive plane harmonique de *période temporelle $`T`$* présente :

   * une **longueur d'onde $`\lambda_1`$** *$`\; = \mathscr{v}_1\;T`$* dans le milieu 1 ou sa célérité est $`\mathscr{v}_1`$.
   * une **longueur d'onde $`\lambda_2`$** *$`\; = \mathscr{v}_2\;T`$* dans le milieu 1 ou sa célérité est $`\mathscr{v}_2`$.

<br>

##### Que représente un rayon ?<br> Et comment caractériser sa trajectoire ?   
<br>

![](refraction-intro-3_L1200.gif)

* L'**onde** plane progressive harmonique **propage de l'énergie** 
   * dans sa *direction de propagation*.
   * *perpendiculaire au fronts d'onde*.

* La *direction de propagation* de l'énergie peut être représentée par un **rayon**.   
  _trajectoire fléchée de couleur jaune sur la figure._

* La **trajectoire du rayon** est *déviée à l'interface*.

* Les **angles d'incidence et de réfraction** du rayon sont repérés *par rapport à la normale* à l'interface
  au point où le rayon traverse l'interface.
   * **$`\theta_1`$** est l'*angle d'incidence*.
   * **$`\theta_2`$** est l'*angle de réfraction*.

<br>
   
##### Quelle est la loi de la réfraction ?   
<br>

* Les deux angles **$`\theta_1`$ et $`\theta_2`$** peuvent s'exprimer en *fonction* des longueurs d'ondes
*$`\lambda_1`$ et $`\lambda_2`$*, et d'une **longueur de référence commune**, la longueur d'onde **$`\Lambda`$**
dans le plan de l'interface.

* Les relations utilisent le *théorème de Pythagore* dans un triangle rectangle.

![](refraction-relation-1_L1200.jpg)

![](refraction-relation-2_L1200.jpg)


* Exprimons cette longueur de référence commune dans chaque milieu :   
  <br>
  **$`\large{\boldsymbol{\mathbf{\Lambda = \dfrac{\lambda_1}{sin\,\theta_1}}}}\quad`$** 
  et *$`\quad\large{\boldsymbol{\mathbf{\Lambda = \dfrac{\lambda_2}{sin\,\theta_2}}}}`$*.   

* Nous en déduisons la **loi de la réfraction** :   
  <br>
  $`\left.\begin{align}
   &\Lambda = \dfrac{\lambda_1}{sin\,\theta_1}\\
   &\Lambda = \dfrac{\lambda_2}{sin\,\theta_2}
   \end{align}\right\}\Longrightarrow\;\dfrac{sin\,\theta_1}{\lambda_1}=\dfrac{sin\,\theta_2}{\lambda_2}`$   
   <br>
   $`\hspace{2.5cm}\Longrightarrow\;\dfrac{sin\,\theta_1}{\mathscr{v}_1\,T}=\dfrac{sin\,\theta_2}{\mathscr{v}_2\,T}`$   
   <br>
   $`\hspace{2.5cm}\Longrightarrow\;\color{brown}{\large{\boldsymbol{\mathbf{\dfrac{sin\,\theta_1}{\mathscr{v}_1}=\dfrac{sin\,\theta_2}{\mathscr{v}_2}}}}}`$
   

![](refraction-relation-3_L1200.jpg)


C'est incomplet. Traiter à la suite le phénomène de réflexion totale..

<br>

##### Quel est le lien avec l'Optique géométrique ?

<br>

* La célérité **$`c=3\times 10^8\;m\,s^{-1}`$** de la lumière dans le vide est une **constante fondamentale de la nature**.   
  L'expérience, comprises dans le cadre de la relativité d'Einstein, montre que $`c`$ est une *vitesse limite infranchissable*.

* Dans un **matériau transparent**, isotrope et homogène, tout se passe comme si la lumière se propage en ligne droite
  à une *célérité $`\mathscr{v}`$* qui dépend du matériau.

* Caractéristique du matériau, la célérité $`\mathscr{v}`$ s'exprime à travers la 
  notion d'*indice de réfraction* $`n`$ défini par :   
  <br>
  *$`\large{\mathbf{n=\dfrac{c}{\mathscr{v}}}}`$*.

* La *loi de la réfraction en optique géométrique* s'exprime en utilisant la notion d'indice de réfraction
  pour caractériser les milieux de part et d'autre de leur interface.   
  <br>
  Connue sous le nom de **Loi de Snell-Descartes**, elle s'écrit :   
  <br>
  **$`\large{\mathbf{n_1\cdot sin\,\theta_1 = n_2\cdot sin\,\theta_2}}`$**

(niveau 2 ou 3 ? plutôt deux...)





<!-------------



#### Quels phénomènes sont caractéristiques d'une onde ?

![waves-sinusoide-lambda-n3_L1200](waves-sinusoide-lambda-n3_L1200.gif)

figure à transférer en niveau 2

...



#### Qu'est-ce que le phénomène de réfraction ?


#### Qu'est-ce qu'une onde périodique ?


#### Qu'est-ce que le phénomène d'interférence ?



#### Qu'est-ce qu'une onde stationnaire ?




![waves_interferences_ventres_noeuds](waves_interferences_ventres_noeuds_niv_3a_L1200.gif)

niveau 2


#### Quelles sont les différentes grandeurs physique caractérisant une onde périodique ?

![refraction d'une onde plane sur un dioptre plan](wave-optics-n3-refraction-1_L1000.gif)

niveau 2 reprise au 3?


------------>

#### Superposition de deux OPPH

* Soient **deux OPPH** :   
<br>
**$`U_1(\overrightarrow{r},t)`$** *$`\;= A_1\,cos\big(\omega_1 t + \overrightarrow{k}_1\cdot\overrightarrow{r}+\varphi_1\big)`$*   
<br>
**$`U_2(\overrightarrow{r},t)`$** *$`\; = A_2\,cos\big(\omega_2 t + \overrightarrow{k}_2\cdot\overrightarrow{r}+\varphi_2\big)`$*   
<br>
telles que :   
   * Les **amplitudes** $`A_1`$ et $`A_2`$ sont *quelconques*.
   * Les **pulsations**  $`\omega_1`$ et $`\omega_2`$ sont *quelconques*.
   * Les **phases à l'origine** $`\varphi_1`$ et $`\varphi_2`$ sont *quelconques*.   
   <br>
   * Même si les **vecteurs d'ondes** $`\overrightarrow{k}_1=\dfrac{\omega_1}{\mathscr{v}_1}`$ et $`\overrightarrow{k}_2=\dfrac{\omega_2}{\mathscr{v}_2}`$
sont liés aux pulsations $`{\omega_1}`$ et $`{\omega_1}`$ et à la célérité de l'onde dans le milieu, un milieu dispersif peut donner lieu à 
deux célérités différentes pour $`{\omega_1}`$ et $`{\omega_1}`$. Ainsi le cas le plus général doit considérer des vecteurs d'ondes
*quelconques*.


* Pour chaque grandeur physique, la façon de *gérer ces valeurs indépendantes* est de les **réexprimer** en fonction de ce qu'elles ont en commun,
une **valeur moyenne**, et de leurs **écarts respectifs** par rapport à la valeur moyenne. Ainsi :   
   * **$`A_1 =`$**$`\; \dfrac{A_1 + A_2}{2} +  \dfrac{A_1 - A_2}{2} = `$ *$`\; A_{moy} + \Delta A_{1-2}`$*    
     <br>
     **$`A_2 =`$**$`\; \dfrac{A_1 + A_2}{2} -  \dfrac{A_1 - A_2}{2} = `$ *$`\; A_{moy} - \Delta A_{1-2}`$*   

   * **$`\omega_1 =`$**$`\; \dfrac{\omega_1 + \omega_2}{2} +  \dfrac{\omega_1 - \omega_2}{2} = `$ *$`\; \omega_{moy} + \Delta \omega_{1-2}`$*   
     <br>
     **$`\omega_2 =`$**$`\; \dfrac{\omega_1 + \omega_2}{2} -  \dfrac{\omega_1 - \omega_2}{2} = `$ *$`\; \omega_{moy} - \Delta \omega_{1-2}`$*  

   * **$`\overrightarrow{k}_1 =`$**$`\; \dfrac{\overrightarrow{k}_1 + \overrightarrow{k}_2}{2} +  \dfrac{\overrightarrow{k}_1 - \overrightarrow{k}_2}{2} = `$ *$`\; \overrightarrow{k}_{moy} + \Delta \overrightarrow{k}_{1-2}`$*    
     <br>
     **$`\overrightarrow{k}_2 =`$**$`\; \dfrac{\overrightarrow{k}_1 + \overrightarrow{k}_2}{2} -  \dfrac{\overrightarrow{k}_1 - \overrightarrow{k}_2}{2} = `$ *$`\; \overrightarrow{k}_{moy} - \Delta \overrightarrow{k}_{1-2}`$*   

   * **$`\varphi_1 =`$**$`\; \dfrac{\varphi_1 + \varphi_2}{2} +  \dfrac{\varphi_1 - \varphi_2}{2} = `$ *$`\; \varphi_{moy} + \Delta \varphi_{1-2}`$*    
     <br>
     **$`\varphi_2 =`$**$`\; \dfrac{\varphi_1 + \varphi_2}{2} -  \dfrac{\varphi_1 - \varphi_2}{2} = `$ *$`\; \varphi_{moy} - \Delta \varphi_{1-2}`$*    

* *Travaillons* d'abord avec les **termes d'amplitude** :   
<br>
**$`U(\overrightarrow{r},t)`$**$`\; = U_1(\overrightarrow{r},t) + U_2(\overrightarrow{r},t)`$   
<br>
$`\begin{array}\quad = &A_1\,cos\big(\underbrace{\omega_1 t + \overrightarrow{k}_1\cdot\overrightarrow{r}+\varphi_1}_{\color{blue}{\theta_1(\vec{r},t)}}\big)\\
  &+ A_2\,cos\big(\underbrace{\omega_2 t + \overrightarrow{k}_2\cdot\overrightarrow{r}+\varphi_2}_{\color{blue}{\theta_2(\vec{r},t)}}\big)\end{array}`$

$`\quad\;\, = A_1\,cos\,\theta_1 + A_2\,cos\,\theta_2`$   

$`\quad\;\, = (A_{moy}+ \Delta A_{1-2})\,cos\,\theta_1 + (A_{moy} - \Delta A_{1-2})\,cos\,\theta_2`$   

**$`\quad\;\, = A_{moy}\,(cos\,\theta_1 + cos\,\theta_2) + \Delta A_{1-2}\,(cos\theta_1 - cos\theta_2)`$**

* *Travaillons* les **termes de phase** :   
<br>
**$`\theta_1(\overrightarrow{r},t)`$**$`\; = \omega_1 t + \overrightarrow{k}_1\cdot\overrightarrow{r}+\varphi_1`$

$`\begin{align}\quad\;\;= \big[ (\omega_{moy}&+ \Delta \omega_{1-2})\, t + \big(\overrightarrow{k}_{moy}+ \Delta \overrightarrow{k}_{1-2}\big)\cdot\overrightarrow{r}\\
&+( \varphi_{moy} + \Delta \varphi_{1-2})\big]\end{align}`$

$`\begin{align}
\quad\;\,&= \big[ \big(\underbrace{\omega_{moy} t + \overrightarrow{k}_{moy}\cdot\overrightarrow{r}+ \varphi_{moy}}_{\color{blue}{\theta_{moy}(\overrightarrow{r},t)}}\big) \\
&\quad + \big(\underbrace{\Delta \omega_{1-2} t + \Delta \overrightarrow{k}_{1-2}\cdot\overrightarrow{r}+\Delta\varphi_{1-2}}_{\color{blue}{\theta_{1-2}(\overrightarrow{r},t)}}\big)\big]
\end{align}`$

**$`\quad\;\;=\,\theta_{moy}(\overrightarrow{r},t)\,+\,\theta_{1-2}(\overrightarrow{r},t)`$**   
<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;et de la même façon nous obtenons :   
<br>
**$`\quad\;\;\theta_2(\overrightarrow{r},t)`$**$`\; = \omega_2 t + \overrightarrow{k}_2\cdot\overrightarrow{r}+\varphi_2`$   
<br>
$`\quad\quad \;\; = \cdots`$   
<br>
**$`\quad\quad\;\;=\,\theta_{moy}(\overrightarrow{r},t)\,-\,\theta_{1-2}(\overrightarrow{r},t)`$**  


* *Travaillons* les **termes $`(cos\theta_1+cos\theta_2)`$ et $`(cos\theta_1-cos\theta_2)`$** qui interviennent
  dans l'expression de $`U(\vec{r},t)`$ :   
  <br>
  **$`cos\theta_1+cos\theta_2 =`$**$`\;cos\,(\theta_{moy}+\Delta\theta_{1-2})+cos\,(\theta_{moy}-\Delta\theta_{1-2}`$   
  <br>
  $`\color{blue}{\scriptsize{\left.\begin{align} \quad\quad &cos(a+b)=cos(a)cos(b)-sin(a)sin(b)\\
                     &cos(a-b)=cos(a)cos(b)+-sin(a)sin(b)\end{align}
               \right\}\Longrightarrow\\
        \quad\quad cos(a+b)\,+\,cos(a-b)\,=\,2\,cos(a)\,cos(b)}}`$  
  <br>
  **$`\quad\;\; = 2\,cos\,\theta_{moy}\;cos\,\Delta\theta_{1-2}`$**   
  <br>
  de même   
  <br>
  **$`cos\theta_1-cos\theta_2 =`$**$`\;cos\,(\theta_{moy}+\Delta\theta_{1-2})-cos\,(\theta_{moy}-\Delta\theta_{1-2}`$   
  <br>
  $`\color{blue}{\scriptsize{\left.\begin{align} \quad\quad &cos(a+b)=cos(a)cos(b)-sin(a)sin(b)\\
                     &cos(a-b)=cos(a)cos(b)+-sin(a)sin(b)\end{align}
               \right\}\Longrightarrow\\
        \quad\quad cos(a+b)\,-\,cos(a-b)\,=\,-\,2\,sin(a)\,sin(b)}}`$  
  <br>
  **$`\quad\;\; = -\,2\,sin\,\theta_{moy}\;sin\,\Delta\theta_{1-2}`$**


* Nous obtenons l'**expression finale** de l'onde résultante de la *superposition de deux OPPH* quelconques :   
  <br>
  **$`U(\overrightarrow{r},t)`$**  
  <br>
  *$`\begin{array}\quad = &A_1\,cos\big(\underbrace{\omega_1 t + \overrightarrow{k}_1\cdot\overrightarrow{r}+\varphi_1}_{\color{blue}{\theta_1(\vec{r},t)}}\big)\\
  &+ \;A_2\,cos\big(\underbrace{\omega_2 t + \overrightarrow{k}_2\cdot\overrightarrow{r}+\varphi_2}_{\color{blue}{\theta_2(\vec{r},t)}}\big)
  \end{array}`$*   
  <br>
  $`\begin{array}\quad = &+\,2\,A_{moy}\,cos\,\theta_{moy}\;cos\,\Delta\theta_{1-2}\\
   &-\,2\,\Delta A_{1-2}\,\,sin\,\theta_{moy}\;sin\,\Delta\theta_{1-2}\end{array}`$   
  <br>
  **$`\begin{array}\quad = &+\,2\,A_{moy}\,cos\big(\omega_{moy} t + \overrightarrow{k}_{moy}\cdot\overrightarrow{r}+ \varphi_{moy}\big)\\
    &\quad\times\,cos\big(\Delta \omega_{1-2} t + \Delta \overrightarrow{k}_{1-2}\cdot\overrightarrow{r}+\Delta\varphi_{1-2}\big)\\
   &-\,2\,\Delta A_{1-2}\,sin\big(\omega_{moy} t + \overrightarrow{k}_{moy}\cdot\overrightarrow{r}+ \varphi_{moy}\big)\\
    &\quad\times\,sin\big(\Delta \omega_{1-2} t + \Delta \overrightarrow{k}_{1-2}\cdot\overrightarrow{r}+\Delta\varphi_{1-2}\big)
    \end{array}`$**


#### Retour sur quelques cas particuliers

##### Le phénomène des battements sonores

* Le **tympan** de l'oreille est situé en une *position $`\overrightarrow{r}_0`$* fixe de l'espace.   
<br>
*  L'ouïe humain perçoit deux notes comme séparées par **une octave**, deux notes dont le *rapport des fréquences* fondamentales est **2**.

* La **musique occidentale** contemporaine utilise la gamme tempérée qui *divise l'octave en 12 intervalles égaux*
  appelés demi-tons,
  donc de *rapport de fréquence* égale à la racine douzième de deux : *$`|\nu_1\,/\,\nu_2| = \sqrt[12]{2} = 2^{\frac{1}{12}}`$*.   
  <br>
  Ceci assure bien que monter de 12 demi-tons permet d'atteindre l'octave, la fréquence double de celle du départ :  
  $`\big(\sqrt[12]{2}\big)^{12} = \big(2^{\frac{1}{12}}\big)^{12} = 2^{\frac{12}{12}} = 2^1 = 2`$   
  <br>
* Le **comma** est un intervalle entre deux sons sinusoïdaux (sons purs) de fréquences
   $`\nu_1`$ et $`\nu_2`$ de fréquences très proches, de façon que la *différence de hauteur* correspondante
   perçue par l'ouïe humain soit *à la limite de perception*. Il correspond environ à *un cinquième de demi-ton*, soit
   un écart relatif en fréquence :   
   $`\left|\dfrac{\nu_2-\nu_1}{\nu_1}\right| \approx \frac{1}{5}\,\sqrt[12]{2} = \frac{1}{5}\, 2^{\frac{1}{12}}\approx 1,0595`$

* Le **phénomène de battement** nécessite *deux conditions* :
   * Que les deux vibrations sonores qui vont interférer au niveau du tympan soient 
     d'*amplitudes comparables*, afin q'un son perçu ne domine pas l'autre.   
     $`\Longrightarrow`$ nous prendrons **$`A_1=A_2=\color{brown}{A}`$**   
     $`\Longrightarrow`$**$`\Delta A_{1-2}=0`$**   
    <br>
   * Qu'entre les deux notes qui interfèrent, la *différence de hauteur soit inférieure au comma*,
     afin qu'une seule hauteur de son soit perçue.
     $`\Longrightarrow`$ nous prendrons **$`\left|\dfrac{\nu_2-\nu_1}{\nu_1}\right|\le\dfrac{\sqrt[12]{2}}{5}=0,0032`$**

* L'équation de ce phénomène se résume à :   
   <br>
  **$`\mathbf{\boldsymbol{U(\overrightarrow{r},t)}}`$**  
  $`\begin{array}\quad = &+\,2\,\color{blue}{\underbrace{A_{moy}}_{=\;A}}\,cos\big(\omega_{moy} t + \color{blue}{\underbrace{\overrightarrow{k}_{moy}\cdot\overrightarrow{r}+ \varphi_{moy}}_{=\;\varphi_A}} \big)\\
    &\quad\times\,cos\big(\Delta \omega_{1-2} t + \color{blue}{\underbrace{\Delta \overrightarrow{k}_{1-2}\cdot\overrightarrow{r}+\Delta\varphi_{1-2}}_{=\;\varphi_B}}\big)\\
   &-\,2\,\color{blue}{\underbrace{\Delta A_{1-2}}_{=\;0}}\,sin\big(\omega_{moy} t + \overrightarrow{k}_{moy}\cdot\overrightarrow{r}+ \varphi_{moy}\big)\\
    &\quad\times\,sin\big(\Delta \omega_{1-2} t + \Delta \overrightarrow{k}_{1-2}\cdot\overrightarrow{r}+\Delta\varphi_{1-2}\big)
    \end{array}`$    
   <br>
   **$`\begin{array}\quad = \underbrace{2\,A\,\,cos\big(\Delta \omega_{1-2} t + \varphi_B)}_{\color{blue}{\text{lentement variable} \\ \text{fonction enveloppe}}} \times cos\,(\omega_{moy} t + \varphi_A)
   \end{array}`$** 


*  Écoutons ce phénomène :

 * Prenons comme son de base, le **la médium**, donné par les *diapasons* standards, de fréquence **$`\nu_1=440\,Hz`$**.   
   L'**écart de fréquence** ne doit pas dépasser *$`|\nu_2 - \nu_1| \le (440\times 0,0032) = 1,4 \,Hz`$*   
   Choisissons **$`\nu_2=441\,Hz`$**


  
  


<!------------------
!! *Pour aller plus loin*
!! En musicologie, le comma naturel est l'intervalle de hauteur entre de sons dont 
!! les fréquences fondamentales $`\nu_1`$ et $`\nu_2`$ diffèrent dans le rapport $`81/80`$.
!! à continuer. Développer un peu dans la partie Beyond.
------------------->

##### Les casques anti-bruit


##### Les fentes d'Young









