---
title: 'Distributions cylindriques de charge'
published: true
routable: true
visible: false
lessons:
    -
        slug: gauss-integral-cylindrical-symmetry-3-linear
        order: 1
    -
        slug: gauss-integral-cylindrical-symmetry-3-method-main
        order: 3
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!! *COURS EN CONSTRUCTION :* <br>
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com. Ce cours est *en construction*, il n'est *pas validé par l'équipe pédagogique* à ce stade. <br>
!!!! Document de travail destiné uniquement aux équipes pédagogiques.


### Distributions de charge à symétrie de révolution


##### Distribution de charge à symétrie de révolution et repère cylindrique $`(O,\rho, \varphi, z)`$

Une distribution de charge à symétrie de révolution signifie que les charges possèdent 
un axe de rotation d'ordre infini appelé axe de révolution.

Le repère de l'espace le mieux adapté pour décrire une telle distribution est le 
repère cylindrique $`(O, \rho, \varphi, z)`$ où l'axe $`Oz`$ est l'axe de révolution du cylindre, 
l'origine $`O`$ étant un point quelconque pris sur cet axe.

Décrite dans ce repère cylindrique $`(O, \rho, \varphi, z)`$, la distribution
de charge à symétrie de révolution se caractérise par une invariance de la densité de charge 
par rotation d'angle $`\varphi`$ quelconque. Il en résulte que la densité volumique 
de charge ne dépend plus de la coordonnée $`\varphi`$, mais des seules coordonnées $`\rho`$ et $`z`$.

$`\dens`$ à symétrie cylindrique $`\require{cancel}\Longleftrightarrow\dens\,(\rho,\xcancel{\varphi}, z) =\dens\,(\rho, z)`$


##### Distributions volumique, surfacique et linéïque de charge

L'espace réel perçu possède 3 dimensions, les charges occupent les trois dimensions 
spatiales et tout point point de l'espace peut être caractérisé par une densité volumique de charge $`\dens`$
d'unité SI (pour Système International d'unité) $`Cm^{-3}`$.

$`\dens = \dens\,(\rho, \varphi, z)\quad`$ $`Cm^{-3}`$

!!!! *Attention* :   
!!!!
!!!! La *lettre grecque "rho"* désigne traditionnellement à la fois :
!!!! * la *coordonnée rho* du repère cylindrique.
!!!! * une *densité volumique* (densité volumique de charge, densité volumique de masse = masse volumique, ...).
!!!!
!!!! Pour distinguer ces deux significations de la lettre rho et éviter toute confusion, *M3P2 utilise* deux police de caractères différentes de cette même lettre rho :
!!!!
!!!! * *$`\large\rho`$* est la *coordonnée rho* du repère cylindrique.   
!!!! * *$`\dens`$* représente une *densité volumique*.

Dans le cas de charges localisées au voisinage d'une surface ,sur une couche d'épaisseur $`e`$ négligeable, 
alors un point de cette surface peut être caractérisé par une densité surfacique de charge $`\dens^{2D}`$
d'unité SI $`Cm^{-2}`$. Densité surfacique se dit aussi densité superficielle. Si les charges 
sont sur la surface latérale du cylindre, la densité surfacique s'écrit :

$`\dens^{2D} = \dens^{2D}\,(\varphi, z)\quad`$ $`Cm^{-2}`$

Dans la case de charges réparties sur une ligne de section droite $`S_{\perp}`$ négligeable, 
tout point de cette ligne peut être caractérisé par une densité linéïque de charge $`\dens^{1D}`$
d'unité SI $`Cm^{-1}`$. Dans ce cas la densité linéïque de charge s'écrit : 

$`\dens^{1D} = \dens^{1D}\,(z)\quad`$ $`Cm^{-1}`$

! *Important* :   
!
! *Densités surfaciques et linéïque* de charge résultent d'une *idéalisation*, d'une *modélisation 2D et 1D* de la distribution des charges dans l'espace.   
!
! Si d'une façon générale, à l'échelle d'observation les grandeurs physiques et les champs varient de façon continue dans l'espace 3D, *des discontinuités peuvent apparaître* lors des modélisations 2D ou 1D.    
!
! Ces discontinuités correspondent à une perte d'information, aux variations continues ignorées des grandeurs physiques et des champs le long des dimensions négligées. 

!! *Pour aller plus loin* :   
!!
!! Un *point* est une *abstraction mathématique sans dimension* (0D) de volume nul. 
!!
!! Il représente un *petit volume* entourant tout point M, *non résolu à l'échelle d'observation* spatiale, mais suffisamment grand pour que la valeur moyenne de la grandeur physique exprimée en ce point soit statistiquement stable à l'échelle d'observation temporelle.  
!!  
!! Un tel volume est dit *volume mésoscopique*. 
!! 
!! Cette notion de volume mésoscopique sera précisée et utilisée dans les diverses études 
!! sur les propriétés physiques de la matière, dès ce niveau contrefort puis au niveau montagne.


##### Les distribution de charge à symétrie de révolution, de forme cylindrique

  
Un cylindre de rayon $`R`$ uniformément chargé est un exemple de distribution de charge 
à symétrie de révolution qui peut être décrite, dans le repère cylindrique associé, par :

* la densité volumique de charge \dens^{3D} :   
$`\left\{\begin{array}{ll}
\rho\le R \Longrightarrow \dens^{3D}(\rho)=\dens^{3D}_0 = cste\ne 0 \\
\rho\gt R \Longrightarrow \dens^{3D}(\rho)= 0
\end{array}\right.`$

* lorsque la section droite du fil est négligée, par la densité surfacique de charge \dens^{1D} : 
$`\left\{\begin{array}{ll}
r = 0 \Longrightarrow \dens^{1D}(\rho)=\dens^{1D}_0 = cste\ne 0 \\
r \ne 0 \Longrightarrow \dens^{1D}(\rho)=0
\end{array}\right.`$








