#!/usr/bin/env bash

COURSES_DIR="user/pages"
BACKUP="${COURSES_DIR}.$(date +%F_%R)"


# Make sure we're at project root
cd "$(dirname "$(realpath "$0")")";
cd ..


echo -e "Creating a backup of pages in ${BACKUP}…"
mv ${COURSES_DIR} ${BACKUP}


echo -e "Fetching fresh courses from server…"
git submodule update --init --recursive
git submodule foreach git checkout master
git submodule foreach git pull origin master


echo -e "Done!"
