# M3P2

These are the sources of an instance of Grav tailored for the courses of M3P2.

The plugins and themes are included.
Only the php vendors are not included.

## Run locally for fast development

Install dependencies:

	bin/grav install

Then try out

	bin/grav

to troubleshoot.

Add the courses from the other repository

	bin/clone_courses.sh


And run locally

	php -S localhost:8000 system/router.php


## Mirror the courses to generate a static website

This may come in handy when we'll want offline access

    wget -mkxKE -e robots=off https://courses.m3p2.ljbac.com

And then to browse locally, for example :

    cd courses.m3p2.ljbac.com
    
    firefox index.html


## Upgrading vendors

Since our plugins and themes are in this repository, they are frozen.

So far, Grav itself is safe to update, as well as all plugins **but mathjax** (until they merge our MR).

Todo: look up .dependencies and perhaps we'll remove the plugins dir altogether from this repository.

The theme `textbook` is tailored for M3P2 courses.
The plugin `gitlab-markdown-adapter` was expressly made for this Grav instance.

To update Grav you should use the [Grav Package Manager](https://learn.getgrav.org/advanced/grav-gpm) or `GPM`:

```
$ bin/gpm selfupgrade
```

To update plugins and themes:

```
$ bin/gpm update
```

---

---

---

# ![](https://avatars1.githubusercontent.com/u/8237355?v=2&s=50) Grav

Grav is a **Fast**, **Simple**, and **Flexible**, file-based Web-platform.
It follows similar principles to other flat-file CMS platforms, but has a different design philosophy than most.
Grav comes with a powerful **Package Management System** to allow for simple installation and upgrading of plugins and themes, as well as simple updating of Grav itself.

The underlying architecture of Grav is designed to use well-established and _best-in-class_ technologies to ensure that Grav is simple to use and easy to extend. Some of these key technologies include:

* [Twig Templating](https://twig.sensiolabs.org/): for powerful control of the user interface
* [Markdown](https://en.wikipedia.org/wiki/Markdown): for easy content creation
* [YAML](https://yaml.org): for simple configuration
* [Parsedown](https://parsedown.org/): for fast Markdown and Markdown Extra support
* [Doctrine Cache](https://www.doctrine-project.org/projects/doctrine-orm/en/latest/reference/caching.html): layer for performance
* [Pimple Dependency Injection Container](https://pimple.sensiolabs.org/): for extensibility and maintainability
* [Symfony Event Dispatcher](https://symfony.com/doc/current/components/event_dispatcher/introduction.html): for plugin event handling
* [Symfony Console](https://symfony.com/doc/current/components/console/introduction.html): for CLI interface
* [Gregwar Image Library](https://github.com/Gregwar/Image): for dynamic image manipulation

# Requirements

- PHP 5.6.4 or higher. Check the [required modules list](https://learn.getgrav.org/basics/requirements#php-requirements)
- Check the [Apache](https://learn.getgrav.org/basics/requirements#apache-requirements) or [IIS](https://learn.getgrav.org/basics/requirements#iis-requirements) requirements


# License

See [LICENSE](LICENSE.txt)

[gitflow-model]: http://nvie.com/posts/a-successful-git-branching-model/
[gitflow-extensions]: https://github.com/nvie/gitflow

