---
title: Magnétostatique 2
published: true
routable: true
visible: false
lessons:
    - slug: stationary-magnetic-field
      order: 2
---


#### Quels sont les effets d'un champ magnétique stationnaire ?

#### Quelle force sur une particule chargée en mouvement ?

Les *effets* d'un champ magnétiques *sont induits* par le **champ d'induction magnétique $`\overrightarrow{B}`$**.

Ce champ $`\overrightarrow{B}`$ exerce une **force magnétique $`\mathbf{\overrightarrow{F_{mag}}}`$ sur toute particule** chargée de **charge $`q`$** et mobile dans le référentiel d'étude, c'est à dire animée d'une **vitesse $`\overrightarrow{v}`$** non nulle.

L'expression de la force magnétique est $`\overrightarrow{F_{mag}}`$ :

**$`\mathbf{\overrightarrow{F}_{mag} = q \; (\overrightarrow{v}\land\overrightarrow{B})}`$**

<!-----------------------------------------------------------
Il faut mettre au point cette remarque dans "pour aller plus loin". En quelques lignes ici, puis probablement dans un développement plus conséquent dans la fenêtre "Au-delà". Enfin, l'explication du point de vue relativiste, dans un thème relativité".
! *Pour aller plus loin* :
!
! Ainsi la force magnétique dépend de la vitesse de la particule chargée sur laquelle est s'exerce. Or la vitesse est une grandeur relative : deux observateurs en mouvement l'un par rapport à l'autre mesurent des vitesses différentes à une même charge  $`q`$. 
! * un observateur A mesure une vitesse $`\overrightarrow{v_A}`$. Dans son référentiel, la force magnétique s'exprime $`\overrightarrow{F_{mag}^A} = q\; (\overrightarrow{v_A}\land\overrightarrow{B})`$, et conduit en un temps $`dt`$ à une variation $`\overrightarrow{dp_A}=\overrightarrow{F_{mag}^A}\cdot dt`$ de la quantité de mouvement de la particule.
! * un observateur B, en mouvement uniforme par rapport à A mesure pour la même particule une vitesse $`\overrightarrow{v_B}\ne\overrightarrow{v_A}`$. Dans son référentiel, la force magnétique $`\overrightarrow{F_{mag}^B} = q \;(\overrightarrow{v_B}\land\overrightarrow{B})`$ sur la particule conduit à une variation $`\overrightarrow{dp_B}=\overrightarrow{F_{mag}^B}\cdot dt`$ de sa quantité de mouvement sur la même durée $`dt`$.
!
! Pourtant il n'y a pas deux réalités propres à chaque observateur, tous deux observent le même effet magnétique, une même modification du mouvement de la particule induit par une variation de la quantité de mouvement.
!
! En mécanique classique, la variation $`\overrightarrow{dp}=\overrightarrow{F}\cdot dt`$ de la quantité de mouvement pendant une durée $`dt`$ est un invariant, donc $`\overrightarrow{dp}=\overrightarrow{dp_A}=\overrightarrow{dp_B}`$, ce qui mène à <br>
! $`\overrightarrow{dp_A}=\overrightarrow{dp_B}`$
! $`\quad\Longrightarrow\quad\overrightarrow{F_{mag}^A}=\overrightarrow{F_{mag}^B}`$
! $`\quad\Longrightarrow\quad q\; (\overrightarrow{v_A}\land\overrightarrow{B})=q\;(\overrightarrow{v_B}\land\overrightarrow{B})\quad[eq.1]`$
!
! L'hypothèse de départ $`\overrightarrow{v_B}\ne\overrightarrow{v_A}`$  implique que soit q, soit $`\overrightarrow{B}`$, soit les deux, dépendent de l'observateur. 
!
! La charge électrique d'une particule ne dépend pas de sa vitesse, c'est un invariant. En effet un atome d'hélium et une molécule dhydrogène $`H_2`$ contiennent le même nombre de protons (2) et le même nombre d'électrons (2). Cependant les états de mouvement des électrons et des protons dans $`He`$ et $`H_2`$ sont différents, voire extrêmement différents pour les protons distants de $`0.7\overset{\circ}{A}`$ dans $`H_2`$ et étroitement liés dans le noyau de $`He`$. Une des preuve expérimentale de l'invariance de la charge électrique est la neutralité mesurée de $`He`$ comme de $`H_2`$. Cette neutralité  implique une exacte compensation de la charge électronique par la charge du noyau qui ne saurait être réalisée si la charge électrique variait avec la vitesse.
!
! Cependant la variation de $`\overrightarrow{B}`$ observée par les observateurs A et B n'est pas $`\require{cancel}\xcancel{||\overrightarrow{B_B}|| / ||\overrightarrow{B_A}|| = ||\overrightarrow{v_A}|| / ||\overrightarrow{v_B}||}`$ comme le laisserait penser $`[eq.1]`$. En fait, même si les champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ sont découplés lorsqu'ils sont stationnaires (l'électrostatique et la magnétostatique peuvent être étudiées séparément, et dedans aucune loi de couple ces deux champs), ils doivent être considérés ensemble. Ce fait peut être compris en considérant le cas fictif d'un ensemble de particules ponctuelles de charge q, jointives sur une ligne droite infinie et immobiles les unes par rapport aux autres.
* 
et ses déplaçant toutes à la même vitesse 

Cela est facile à comprendre en considérant des charges électriques ayant une même vitesse $`\overrightarrow{v}`$ pour un observateur A. La force créée par ces charges fait appel à la magnétostatique

sont les deux côtés d'un même champ ... 
---------------------------------------------------------------------->

#### Quelle force sur un conducteur parcouru par un courant ?

##### Le contexte

* Soit un circuit conducteur $`C`$ parcouru par un courant
électrique $`I`$ et plongé dans un champ magnétique $`\overrightarrow{B}`$.
* Soit un élément $`dC`$  de $`C`$, de longueur $`dl`$ et de section $`dS`$ , de volume $` d\tau=dl\cdot dS`$
* Soit $`\rho_{liée}`$ la densité volumique de charges liées (les ions positifs du métal conducteur) dans cet élément $`dC`$.
* Soit $`\rho_{libre}`$ la densité volumique de charges libres (les électrons libres du métal conducteur).
* Soit $`\overrightarrow{v}_{dér\,/\,dC}`$ la vitesse de dérive (vitesse orientée sous l'action d'un champ électrique) des
charges libres par rapport aux charges fixes (donc par rapport à un référentiel lié à
l'élément de circuit $`dC`$).
* Soit $`\overrightarrow{V}_{dC\,/\,\mathcal{R}}`$ la vitesse de l'élément de circuit $`C`$ dans le référentiel du laboratoire supposé galiléen.

![](Force-Laplace-ToDoAgain.jpg)

* Le courant $`I`$ parcourant le circuit $`dC`$ (donc traversant la section droite $`dS`$ du circuit) est :<br>
$` I= \overrightarrow{j}\cdot\overrightarrow{d_S} = \rho_{libre}\cdot\overrightarrow{v}_{dér\,/\,dC}\cdot \overrightarrow{d_S}`$
* Ce circuit est plongé dans un champ d'induction magnétique $`\overrightarrow{B}`$ uniforme.

##### La force de Laplace

* L'expression de la force magnétique $`\overrightarrow{dF_B}`$ s'exerçant sur cet élément de circuit $`dC`$ est :<br>
<br>$`\overrightarrow{dF_B}=
\rho_{liée}\cdot d\tau\cdot(\overrightarrow{V}_{dC\,/\,\mathcal{R}}\wedge\overrightarrow{B})\;+\;
\rho_{libre}\cdot d\tau\cdot [÷,(\overrightarrow{v}_{dér\,/\,dC}+\overrightarrow{V}_{dC\,/\,\mathcal{R}})\wedge\overrightarrow{B}]`$<br>
<br>$`\overrightarrow{dF_B}= (\rho_{libre}+\rho_{liée}) \cdot d\tau \cdot (\overrightarrow{V}_{dC\,/\,\mathcal{R}} \wedge \overrightarrow{B}) + \rho_{libre} \cdot d\tau \cdot (\overrightarrow{v}_{dér\,/\,dC} \wedge \overrightarrow{B})`$

* Le matériau conducteur du circuit est neutre : en absence de courant  il y a autant de protons positifs que d'électrons liés et libres dans tout volume mésoscopique $`d\tau`$ du conducteur :<br>
$`\rho=\rho_{liée} + \rho_{libre}=0`$<br>
Lorsque le circuit est traversé par un courant stationnaire, cette neutrailté est conservée dans tout $`d\tau`$ : 
en effet au cours d'un temps $`dt`$ une même charge $`dq`$ (due aux électrons libres) à la fois quitte et entre dans tout volume $`d\tau`$, maintenant sa neutralité, ce qui entraîne :<br>
$`\dfrac{\partial \rho}{dt}=\dfrac{\partial \,(\rho_{liée} + \rho_{libre}}{dt}=0`$$`\quad\Longrightarrow \overrightarrow{dF_B}= \rho_{libre} \cdot d\tau \cdot (\overrightarrow{v}_{dér\,/\,dC} \wedge \overrightarrow{B})`$.

* On nomme **force de Laplace** cette force magnétique $`\overrightarrow{dF_B}`$ qui s'exerce sur chaque élément $`dC`$ du circuit :<br>
<br>**$`\mathbf{\overrightarrow{dF}_{Laplace}= \rho_{libre} \cdot d\tau \cdot (\overrightarrow{v}_{dér\,/\,dC} \wedge \overrightarrow{B})}`$**

* Cette **force de Laplace** sur chaque élément $`dC`$ **peut induire** :<br>
<br>\- une **déformation du circuit électrique** dans le *cas d'un circuit déformable*.<br>
<br>\- une **force de Laplace $`\overrightarrow{F}_{Laplace}=\oint_C \overrightarrow{dF}_{Laplace}`$** qui s'aplique **à l'ensemble du circuit** dans le *cas d'un circuit rigide*.<br>
<br>Dans ces deux cas, la force de Laplace **peut modifier le mouvement du circuit** électrique.

#### Quelle est la force magnétique sur une spire parcourue par un courant ?

##### dans un champ magnétique uniforme

##### dans un champ magnétique non uniforme

#### Quels sont les moments et couple magnétiques sur une spire parcourue par un courant ?

##### dans un champ magnétique uniforme

##### dans un champ magnétique non uniforme


