---
title: Systèmes de coordonnées
published: false
visible: false
---

[ES] Estos elementos del curso se apoyan en el capítulo anterior "geometrías-espacio-tiempo", 
en el marco intuitivo del espacio y el tiempo de Newton, del teorema de Pitágoras y del dominio
de las funciones trigonométricas.<br>
[FR] Ces éléments de cours s'appuient sur le chapitre précédent "geometries-space-time", dans le
cadre intuitif de l'espace et le temps de Newton, du théorème de pythagore et de la maitrise
des fonctions trigonométriques.<br>
[EN] These elements below lean on the previous chapter "geometries-space-time", in the
Newton's intuitive framework of space and time, of the Pythagorean theorem and with
the mastery of the trigonometric functions.

## Sistema de coordenadas / Système de coordonnées / Coordinate system

* **N1 ($`\rightarrow`$ N2, N3, N4)**<br>
[ES] Se percibe que el espacio tiene 3 dimensiones, y el tiempo una sola dimensión, que va del 
pasado al futuro <br>
$`\Longrightarrow`$ sistema de coordenadas : 3+1=4 números reales que especifican la posición y fecha 
en el espacio y el tiempo de cualquier punto o evento $`M`$.<br>
[FR] L'espace est perçu comme ayant 3 dimensions, et le temps une dimension unique fléché du passé vers le futur<br>
$`\Longrightarrow`$ système de coordonnées : 3+1=4 nombres réels qui précisent la position 
et la date dans l'espace et le temps de tout point ou évènement $`M`$.<br>
[EN] Space is perceived as having three dimensions, and time a single dimension, arrowed from the past to the future<br>
$`\Longrightarrow`$ coordinate system : 3+1=4 real numbers which specify the position and the date 
in space and time of any point or event $`M`$.

* **N1 ($`\leftarrow`$ N2 N3 N4)**<br>
**Coordenadas geográficas / Coordonnées géographiques / Geographic coordinates**<br>
[ES] para construir: planeta Tierra, polo y hemisferio norte, polo y hemisferio sur. <br>
\- latitud $`\leftrightarrow`$ paralelos; longitude $`\leftrightarrow`$ meridianos;
altitud $`\leftrightarrow`$ nivel del mar o superficie de referencia. <br>
\- latitud $`l`$: $`l=0°\leftrightarrow`$ ecuador; $`l=+90°\leftrightarrow`$ polo
norte geográfico ; $`l=-\,90° \leftrightarrow`$ polo sur geográfico.<br>
\- Longitud $`L`$: $`L = 0°\,0'\,0''\leftrightarrow`$ Grennwich (ciudad, Reino Unido);
Enlaces con medición de ángulos en grados con un transportador. <br>
\- $`1° = 60'`$ (minuto de arco); $`1 '= 60''`$ (segundo de arco). <br>
\- una posición se escribe en el orden latitud, longitud, altitud.<br>
[FR] à construire : planète Terre, pôle et hémisphère nord , pôle et hémisphère sud.<br>
\- latitude $`\leftrightarrow`$ parallèles ; longitude $`\leftrightarrow`$ méridiens ;
altitude $`\leftrightarrow`$ niveau de la mer, ou surface de référence.<br>
\- latitude $`l`$ : $`l=0°\leftrightarrow`$ équateur ; $`l=+90°\leftrightarrow`$ pôle 
nord géographique ; $`l=-\,90°\leftrightarrow`$ pôle sud géographique. <br>
\- Longitude $`L`$ : $`L=0°\,0'\,0''\ \leftrightarrow`$ Grennwich (ville, UK); 
\- Liens avec mesure des angles en degré avec un rapporteur.<br>
\- $`1°=60'`$ (minute d'arc) ; $`1'=60''`$ (seconde d'arc).<br>
\- une position s'écrit dans l'ordre latitude, longitude, altitude.<br>
[EN] to build: planet Earth, north pole and hemisphere, south pole and hemisphere. <br>
\- latitude $`\leftrightarrow`$ parallels; longitude $`\leftrightarrow`$ meridians;
altitude $`\leftrightarrow`$ sea level, or reference surface. <br>
\- latitude $`l`$ : $`l=0° \leftrightarrow`$ equator; $`l=+90° \leftrightarrow`$ pole
true north; $`l=-\,90° \leftrightarrow`$ geographic south pole. <br>
\- Longitude $`L`$: $`L = 0°\,0'\,0'' \leftrightarrow`$ Grennwich (city, UK);
\- Links with measurement of angles in degrees with a protractor. <br>
\- $`1° = 60'`$ (minute of arc); $`1'= 60''`$ (arc second). <br>
\- a position is written in the order latitude, longitude, altitude.<br>
<br>Ejemplos / Exemples / Examples :<br>
[ES] [EN] :<br>
\- UNAL-Manizales : $`5°03'22.08N'' \quad 75°29'28.37''O \quad 2132m`$<br>
\- Univ de Guadalajara : $`20°40'25.76N'' \quad 103°21'30.62''O \quad 1557m`$<br>
\- INSA-Toulouse : $`43°34'11.67N'' \quad 1°28'03.85''E \quad 148m`$<br>
[FR] :<br>
\- Univ de Guadalajara : $`20°40'25,76N'' \quad 103°21'30,62''O \quad 1557m`$<br>
\- UNAL-Manizales : $`5°03'22,08N'' \quad 75°29'28,37''O \quad 2132m`$<br>
\- INSA-Toulouse : $`43°34'11,67N'' \quad 1°28'03,85''E \quad 148m`$<br>


# En mecánica clásica / En mécanique classique / In classical mechanics

y en mecánica cuántica no relativista / et en mécanique quantique non relativiste /
and in non-relativistic quantum mechanics :

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] El espacio y el tiempo son independientes, por lo que hay dos sistemas de coordenadas independientes :<br>
[FR] L'espace et le temps sont indépendants,  donc il y a deux systèmes de coordonnées indépendants :<br>
[EN] Space and time are independent, so there are two independent coordinate systems :<br>

* **N2 ($`\rightarrow`$ N3, N4)**<br>
**Sistema de coordenadas espaciales / système de coordonnées spatiales / spatial coordinate system :**<br>
[ES] El espacio euclidiano de la mecánica de Newton tiene tres dimensiones 
$`\Longrightarrow`$ 3 números reales son necesarios y suficientes para marcar una posición en el espacio.<br>
[FR] L'espace euclidien de la mécanique de Newton a trois dimensions $`\Longrightarrow`$ 3 nombres réels 
sont nécessaires et suffisants pour repérer une position dans l'espace.<br>
[EN] The Euclidean space of Newton's mechanics has three dimensions $`\Longrightarrow`$ 3 real
numbers are necessary and sufficient to locate a position in space.

* **N3 ($`\rightarrow`$ N4)**<br>
**Sistema de coordenada temporale / Système de coordonnée temporelle / Time coordinate system :**<br>
[ES] El tiempo tiene una dimensión, apuntando del pasado al futuro 
$`\Longrightarrow`$ solo un numero real es necesario y suficiente para marcar una fecha en el tiempo.<br>
[FR] Le temps possède une seule dimension $`\Longrightarrow`$ seul un nombre réel
est nécessaire et suffisant pour dater un évènement dans le temps.<br>
[EN] Time has one dimension $`\Longrightarrow`$ only one real
number is necessary and sufficient to date an event in time.


### Coordenadas cartesianas / Coordonnées cartésiennes / Cartesian coordinates (N2-N3-N4)

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] En el marco del espacio y del tiempo de Newton, y de la geometría euclidiana.<br>
[FR] Dans le cadre de l'espace temps de Newton, et de la géométrie euclidienne.<br>
[EN] In the framework of Newton's space and time, and Euclidean geometry.<br>


* **N2 ($`\rightarrow`$ N3, N4)**<br>
Las coordenadas cartesianas se escriben / les coordonnées cartésiennes s'écrivent / The artesian coordinates write :<br>
$`(x,y,z)`$,<br>
con / avec /with :
$`x\in\mathbb{R}`$,  $`y\in\mathbb{R}`$ et $`z\in\mathbb{R}`$.<br>
Coordenadas cartesianas de un punto $`M`$ /coordonnées cartésiennes d'un point $`M`$ / Cartesian coordinates of a point $`M`$ :<br>
$`(x_M,y_M,z_M)`$.<br>
Escribimos / on écrit / we write :<br>
$`M(x_M,y_M,z_M)`$<br>
Si el punto es cualquier punto, simplificamos / Si le point est un point quelconque, on simplifie / If the point is any point, we simplify ;<br>
$`M(x,y,z)`$. 

* **N2 ($`\rightarrow`$ N3, N4)**<br> [ES] Característica de los sistemas de coordenadas
"cartesianos" : la distancia $`d_ {12}`$ entre dos puntos $`M_1`$ y $`M_2`$ del espacio, y de coordenadas
 cartesianas $`(x_1, y_1, z_1)`$ y $`(x_2, y_2, z_2)`$ está dado por el teorema de Pitágoras:<br>
[FR] Caractéristique des systèmes de coordonnées "cartésiennes" : la distance $`d_{12}`$
entre deux points $`M_1`$ et $`M_2`$ dans l'espace, et de coordonnées cartésiennes $`(x_1, y_1, z_1)`$ 
et $`(x_2, y_2, z_2)`$ est donné par le théorème de Pythagore :<br>
[EN] Characteristic of "Cartesian" coordinate systems : the distance $`d_ {12}`$ between 
two points $`M_1`$ and $`M_2`$ in space, and of Cartesian coordinates $`(x_1, y_1, z_1)`$ 
and $`(x_2, y_2, z_2)`$ is given by the Pythagorean theorem:<br>
<br>$`d_{12}=\sqrt{(x_2-x_1)^2+(y_2-y_1)^2+(z_2-z_1)^2}`$

<!--$`d_{12}=\sqrt{(x_2-X_1)^2+(Y_2-Y_1)^2+(Z_2-Z_1)^2}=\displaystyle\sqrt{\sum_{i=1}^3(X_2^î-X_1î)^2}`$-->

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Característica de los sistemas de coordenadas "cartesianos" : si un punto $`M(x,y,z)`$ 
hace un desplazamiento infinitesimal hasta el punto $`M'(x+dx,y+dy,z+dz)`$,<br>
el Elemento escalar de línea $`dl`$ se escribe simplement :<br>
[FR] Caractéristique des systèmes de coordonnées "cartésiennes" : si un point $`M(x,y,z)`$ 
fait un déplacement infinitésimal jusqu'au point $`M'(x+dx,y+dy,z+dz)`$,<br>
l'élément scalaire de longueur $`dl`$ s'écrit simplement :<br>
[EN] Characteristic of "Cartesian" coordinate systems : if a point $`M(x,y,z)`$ makes 
an infinitesimal displacement up to point $`M'(x+dx,y+dy,z+dz)`$,<br>
the scalar line element $`dl`$ writes simply :<br>
<br>$`dl=\sqrt{dx^2+dy^2+dz^2}`$


* **N3 ($`\rightarrow`$ N4)**<br>
[ES] elemento vectorial de línea :<br>
[FR] vecteur déplacement élémentaire $`\overrightarrow{dOM}=\overrightarrow{dl}`$ <br>
 (http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-02 : Il 
faudrait mieux dire et écrire élément vectoriel d'arc?) :<br> 
[EN] vector line element or veftor path element :<br>
$`d\overrightarrow{OM}=\overrightarrow{dr}=\overrightarrow{MM'}=dl\,\overrightarrow{e_T}`$,<br>
con / avec / with<br>
<!--$`\overrightarrow{e_T}
=\dfrac{\dfrac{\partial \overrightarrow{OM}}{\partial x}}{\left| \left| 
\dfrac{\partial \overrightarrow{OM}}{\partial x} \right| \right|}`$.-->

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Cuando solo la coordenada $`x`$ de un punto $`M(x,y,z)`$ varía
continuamente entre los valores $`x`$ y $`x+\Delta x`$, el punto M recorre un segmento
de longitud $`\Delta l_x=\Delta x`$. Cuando $`\Delta x`$ 
tiende a $`0`$, la longitud infinitesimal $`dl_x`$ recorrida para el punto $`M`$ 
es :<br>
[FR] Lorsque seule la coordonnées $`x`$ d'un point $`M(x,y,z)`$ varie de façon 
continue entre les valeurs $`x`$ et $`x+\Delta x`$, le point M parcourt un sègment
de droite de longueur $`\Delta l_x = \Delta x`$. Lorsque $`\Delta x`$ tend vers $`0`$,
la longueur infinitésimale $`dl_x`$ parcourt pour le point $`M`$ est :<br>
[EN] When only the $`x`$ coordinate of a point $`M(x, y, z)`$ varies
continuously between the values $`x`$ and $`x + \Delta x`$, the point M covers
a line segment of length $`\Delta l_x = \Delta x`$. When $`\Delta x`$ tends
towards $`0`$, the infinitesimal length $`dl_x`$ covered by the point $`M`$ is :<br>
<br>$`\displaystyle dx=\lim_{\Delta x\rightarrow 0 \\ \Delta x>0} \Delta x`$
$`\quad\Longrightarrow\quad dl_x=dx`$.<br>       <!--\text{élément scalaire d'arc : }-->
<br>tambien / de même / similarly : $`dl_y=dy`$ et $`dl_z=dz`$.

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Cuando solo la coordenada $`x`$ de un punto $`M(x,y,z)`$ aumenta
infinitesimalmente entre los valores $`x`$ y $`x+dx`$ ($`dx>0`$), el vector de desplazamiento
$`\overrightarrow{MM'}=\partial\overrightarrow{OM}_x`$ del punto $`M`$ el vector 
tangente a la trayectoria en el punto $`M`$ que se escribe :<br>
[FR] Lorsque seule la coordonnées $`x`$ d'un point $`M(x,y,z)`$ s'accroît de façon 
infinitésimale entre les valeurs $`x`$ et $`x+dx`$ ($`dx>0`$), le vecteur déplacement 
$`\overrightarrow{MM'}=\partial\overrightarrow{OM}_x`$ du point $`M`$ est le vecteur
tangent à la trajectoire au point $`M`$ qui sc'écrit :<br>
When only the $`x`$ coordinate of a point $`M(x,y,z)`$ increases infinitesimally between
the values $`x`$ and $`x+dx`$ ($`dx>0`$), the displacement vector
$`\overrightarrow{MM'}=\partial\overrightarrow{OM}_x`$ of the point $`M`$ is the 
tangent vector to the trajectory at point $`M`$. It writes :<br>
<br>$`\overrightarrow{MM'}=\partial\overrightarrow{OM}_x=\dfrac{\partial \overrightarrow{OM}}{\partial x}\cdot dx`$<br>
<br>[ES] El vector unitario tangente a la trayectoria  $`\overrightarrow{e_x}`$ (que indica la dirección y el sentido
de desplazamiento del punto M cuando solo aumenta infinitesimalmente la coordenada x se escribe:<br>
[FR] Le vecteur unitaire tangent à la trajectoire $`\overrightarrow{e_x}`$ (qui indique la direction et le sens 
de déplacement du point M lorsque seule la coordonnée x croît de façon infinitésimale) s'écrit :<br>
[EN] The unit vector tangent to the trajectory  $`\overrightarrow{e_x}`$  (which indicates the direction of displacement 
of the point M when only the coordinate x increases in an infinitesimal way) writes :<br>
<br>$`\overrightarrow{e_x}=\dfrac{\partial\overrightarrow{OM}_x}{||\partial\overrightarrow{OM}_x||}`$<br>
<br>tambien / de même / similarly :<br>
$`\partial\overrightarrow{OM}_y=\dfrac{\partial \overrightarrow{OM}}{\partial y}\cdot dy`$,
$`\quad\overrightarrow{e_y}=\dfrac{\partial\overrightarrow{OM}_y}{||\partial\overrightarrow{OM}_y||}`$<br>
$`\partial\overrightarrow{OM}_z=\dfrac{\partial \overrightarrow{OM}}{\partial z}\cdot dz`$,
$`\quad\overrightarrow{e_z}=\dfrac{\partial\overrightarrow{OM}_z}{||\partial\overrightarrow{OM}_z||}`$

* **N3 ($`\rightarrow`$ N4)**<br> 
[ES] Los vectores $`\overrightarrow{e_x}`$, $`\overrightarrow{e_y}`$ y $`\overrightarrow{e_z}`$ 
forman una **base ortonormal** del espacio. La base $`(\overrightarrow{e_x},\overrightarrow{e_x},\overrightarrow{e_x})`$ 
es la **base asociada a las coordenadas cartesianas**. En coordenadas cartesianas, los vectores
de base asociadas a las coordenadas cartesianas mantienen la 
**misma dirección y el mismo sentido sea cual sea la posición del punto $`M`$**.<br>
[FR] Les vecteurs $`\overrightarrow{e_x}`$, $`\overrightarrow{e_y}`$ y $`\overrightarrow{e_z}`$ 
forment une **base orthonormée** de l'espace. C'est la **base associée aux coordonnées cartésiennes**.
En coordonnées cartésiennes, les vecteurs de base gardent la 
**même direction et le même sens quelque-soit la position du point $`M`$**.<br>
[EN] The vectors $`\overrightarrow{e_x}`$, $`\overrightarrow{e_y}`$ y $`\overrightarrow{e_z}`$ 
form an **orthonormal basis** of space. It is the **base associated with Cartesian coordinates**.
In Cartesian coordinates, the base vectors keep the 
**same direction whatever the position of the point $`M`$**.<br>
<br>$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ 
base ortogonal independiente de la posición de $`M`$ / base orthogonale indépendante
de la position de $`M`$ / orthogonal basis independent of the position of $`M`$.

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] La norma del vector $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}`$ 
es el elemento escalar de linea $`dl_x`$, entonces el vector $`\overrightarrow{e_x}`$ 
se escribe :<br>
[FR] La norme du vecteur $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}`$ 
est l'élément de longueur $`dl_x`$, donc le vecteur $`\overrightarrow{e_x}`$ s'écrit :<br>
[EN] the norm (or length) of the vector $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}`$ 
is the scalar line element $`dl_x`$, so the vector $`\overrightarrow{e_x}`$ writes :<br>
<br>$`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}=dl_x\;\overrightarrow{e_x}=dx\;\overrightarrow{e_x}`$<br>
<br>tambien / de même / similarly :<br>
$`\partial\overrightarrow{OM}_y=\overrightarrow{dl_y}=dl_y\;\overrightarrow{e_y}=dy\;\overrightarrow{e_y}`$<br>
$`\partial\overrightarrow{OM}_z=\overrightarrow{dl_z}=dl_z\;\overrightarrow{e_z}=dz\;\overrightarrow{e_z}`$


* **N3 ($`\rightarrow`$ N4)**<br>
[ES] El elemento vectorial de línea $`\overrightarrow{dOM}=\overrightarrow{dl}`$ en coordenadas cartesianas es
el vector de desplazamiento del punto $`M(x,y,z)`$ al punto $`M'(x+dx,y+dy,z+dz)`$ cuando 
las coordenadas varían infinitamente de $`dx`$, $`dy`$ y $`dz`$, y se escribe :<br>
[FR] Le vecteur déplacement élémentaire $`\overrightarrow{dOM}=\overrightarrow{dl}`$ en 
coordonnées cartésiennes est le vecteur déplacement du point $`M(x,y,z)`$ au point
$`M'(x+dx,y+dy,z+dz)`$ quand les coordonnées varient infinitésimalement des quantités
$`dx`$, $`dy`$ y $`dz`$, et il s'écrit :<br>
[EN] The vector line element or vector path element $`\overrightarrow{dOM}=\overrightarrow{dl}`$ 
in cartesian coordinates is the displacement vector from point $`M(x,y,z)`$ to point 
$`M'(x+dx,y+dy,z+dz)`$ when the coordinates vary infinitely in quantities $`dx`$, $`dy`$ y $`dz`$,
and it writes :<br>
<br>$`=\overrightarrow{MM'}=d\overrightarrow{OM}=\overrightarrow{dr}=\overrightarrow{dl}`$
$`=\partial\overrightarrow{OM}_x+\partial\overrightarrow{OM}_y+\partial\overrightarrow{OM}_z`$
$`=\overrightarrow{dl_x}+\overrightarrow{dl_y}+\overrightarrow{dl_z}`$
$`=l_x\;\overrightarrow{e_x}+l_y\;\overrightarrow{e_y}+l_z\;\overrightarrow{e_z}`$
$`=dx\;\overrightarrow{e_x}+dy\;\overrightarrow{e_y}+dz\;\overrightarrow{e_z}`$<br>
<br>[ES] y su norma es el elemento scalar de linea :<br>
[FR] et sa norme el l'élément de longueur :<br>
[EN] y its norm (or length) is thescalar line element :<br>
<br>$`||\overrightarrow{dl}||=\sqrt{dl_x^2+dl_y^2+dl_z^2}=\sqrt{dx^2+dy^2+dz^2}`$<br>
<br>$`||\overrightarrow{dl}||=\sqrt{\overrightarrow{dl}\cdot\overrightarrow{dl}}`$
$`=\sqrt{(dl_x\;\overrightarrow{e_x}+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z})\cdot
(dl_x\;\overrightarrow{e_x}+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z})}`$
$`=\sqrt{(dl_x)^2\;(\overrightarrow{e_x}\cdot\overrightarrow{e_x})+(dl_y)^2\;(\overrightarrow{e_y}\cdot\overrightarrow{e_y})
+(dl_z)^2\;(\overrightarrow{e_z}\cdot\overrightarrow{e_z})}`$
$`+(2\,dl_x\,dl_y)\,(\overrightarrow{e_x}\cdot\overrightarrow{e_y})`$
$`+(2\,dl_x\,dl_z)\,(\overrightarrow{e_x}\cdot\overrightarrow{e_z})`$
$`+(2\,dl_y\,dl_z)\,(\overrightarrow{e_y}\cdot\overrightarrow{e_z})`$
$`=\sqrt{(dl_x)^2+(dl_y)^2+(dl_z)^2}`$
$`=\sqrt{dx^2+dy^2+dz^2}=dl`$


* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Los 3 vectores $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}\quad`$,
$`\quad\partial\overrightarrow{OM}_y=\overrightarrow{dl_y}\quad`$ y
$`\quad\partial\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ son 2 a 2 ortogonales.<br>
[FR] Les 3 vecteurs $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}\quad`$,
$`\quad\partial\overrightarrow{OM}_y=\overrightarrow{dl_y}\quad`$ et
$`\quad\partial\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ sont orthogonaux 2 à 2.<br>
[EN] The 3 vectors $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}\quad`$,
$`\quad\partial\overrightarrow{OM}_y=\overrightarrow{dl_y}\quad`$ and
$`\quad\partial\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ are 2 to 2 orthogonal.<br>
$`\Longrightarrow`$ :<br>
[ES] El área de un elemento de superficie construido por 2 de estos vectores 
se expresará simplemente como el producto de sus normas.Y el volumen definido 
por estos 3 vectores será simplemente el producto de sus estándares.<br>
[FR] L'aire d'un élément de surface construit par 2 de ces vecteurs s'exprimera 
simplement comme le produit de leurs normes. Et le volume définit par ces 3 vecteurs 
sera simplement le produits de leurs normes.<br>
[EN] The area of a surface element constructed by 2 of these vectors will be expressed 
simply as the product of their norms. The volume defined by these 3 vectors will simply
be the product of their norms.

-------

[ES] ¿Usas la letra $`S`$ o la letra $`A`$ para expresar el área de una superficie? ¿Y qué
quieres usar, sabiendo que el estándar es la letra $`A`$?<br>
[FR] Suivant les recommendations de cette norme, peut-être prendre l'habitude à l'INSA
d'utiliser la lettre $`A`$ au lieu de $`S`$ pour exprimer l'aire d'une surface? Sinon
on peut continuer avec $`S`$ si l'usage est fort, en expliquant dans une note [FR-ES-EN]
que en français on utilise $`S`$ mais que $`A`$ est recommandé.<br>
[EN] Do you use the letter $`S`$ or the letter $`A`$ to express the area of a surface? 
And what do you want to use, knowing that the standard is the letter $`A`$?<br>
http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=121-11-21<br>
[ES] Tenemos que elegir de forma independiente para cada idioma, entre estas notaciones :<br>
[FR] Nous devons choisir de façon indépendante pour chaque langue, entre ces notations :<br>
[EN] We have to choose independently for each language, between these notations :<br>
$`\overrightarrow{dA}\quad`$,$`\quad\overrightarrow{d^2A}\quad`$,
$`\quad\overrightarrow{dS}\quad`$,$`\quad\overrightarrow{d^2S}\quad`$  

--------

* **N3 ($`\rightarrow`$ N4)**<br>
<br>http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-06.<br>
[ES] Según la dirección elegida, los **elementos escalares de superficie $`dA`$** en coordenadas cartesianas son :<br>
[FR] Selon la direction choisie, les **éléments scalaires de surface $`dA`$** en coordonnées cartésiennes sont :<br>
[EN] According to the chosen direction, the **scalar surface elements $`dA`$** in Cartesian coordinates are :<br>
<br>$`dA_{xy}=dl_x\;dly=dx\;dy\quad`$, $`\quad dA_{xz}=dl_x\;dlz=dx\;dz\quad`$, $`\quad dA_{yz}=dl_y\;dlz=dy\;dz`$<br>
<br>http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-07.<br>
[ES] y los **elementos vectoriales de superficie $`\overrightarrow{dA}`$** correspondiente son :<br>
[FR] et les **éléments vectoriels de surface $`\overrightarrow{dA}`$** correspondants sont :<br>
[EN] and the corresponding **vector surface elements $`\overrightarrow{dA}`$** are :<br>
<br>$`d\overrightarrow{A_{xy}}=\pm\;\partial\overrightarrow{OM}_x\land\partial\overrightarrow{OM}_y`$
$`=\pm\;\overrightarrow{dl_x}\land\overrightarrow{dl_y}`$
$`=\pm\; (dl_x\;\overrightarrow{e_x})\land(dl_y\;\overrightarrow{e_y})`$
$`=\pm\; dl_x\;dl_y\;(\overrightarrow{e_x}\land\overrightarrow{e_y})`$
$`= \pm \; dx\;dy\;\overrightarrow{e_z}`$<br>
<br>$`d\overrightarrow{A_{xz}}=\pm\;\partial\overrightarrow{OM}_x\land\partial\overrightarrow{OM}_z`$
$`=\pm\;\overrightarrow{dl_x}\land\overrightarrow{dl_z}`$
$`=\pm\; (dl_x\;\overrightarrow{e_x})\land(dl_z\;\overrightarrow{e_z})`$
$`=\pm\; dl_x\;dl_z\;(\overrightarrow{e_x}\land\overrightarrow{e_z})`$
$`=\mp\; dx\;dy\;\overrightarrow{e_z}`$<br>
<br>$`d\overrightarrow{A_{yz}}=\pm\;\partial\overrightarrow{OM}_y\land\partial\overrightarrow{OM}_z`$
$`=\pm\;\overrightarrow{dl_y}\land\overrightarrow{dl_z}`$
$`=\pm\; (dl_y\;\overrightarrow{e_y})\land(dl_z\;\overrightarrow{e_z})`$
$`=\pm\; dl_y\;dl_z\;(\overrightarrow{e_y}\land\overrightarrow{e_z})`$
$`=\pm\; dy\;dz\;\overrightarrow{e_x}`$<br>

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Una superficie $`S`$ es una **superficie cerrada** si es la
**frontera que separa un volumen interior y un espacio exterior**.
Cualquier camino que conecte cualquier punto del volumen interior y cualquier punto
del espacio exterior pasa necesariamente a través de la superficie cerrada. 
Ejemplo: la superficie de una pelota. <br>
Una superficie $`S`$ es una **superficie abierta** si **no está cerrada**. 
Cualesquiera dos puntos infinitamente cerca uno del otro y 
ubicados a ambos lados de la superficie, existe un camino que conecta estos dos puntos
sin cruzar la superficie. Ejemplo: la superficie de una hoja de papel. (presentar a matemáticos).<br>
[FR] Une surface $`S`$ est une **surface fermée** si elle est la 
**frontière délimitant un volume intérieur et un espace extérieur**. 
Tout chemin reliant un point quelconque dans le volume intérieur et un point
quelconque de l'espace extérieur traverse nécessairement la surface fermée. Exemple : la surface d'un ballon.<br>
Une surface $`S`$ est une **surface ouverte** si elle n'est **pas fermée**. Alors, quelques soient deux points 
infiniment proches l'un de l'autre et situés de part et d'autre de la surface, il existe 
un chemin qui lie ces deux points sans traverser la surface. Exemple : la surface 
d'une feuille de papier. (à soumettre à des mathématiciens).<br>
[EN] A surface $`S`$ is a ** closed surface ** if it is the
**border delimiting an interior volume and an exterior space**.
Any path connecting any point in the interior volume and any point
inside the outer space necessarily crosses the closed surface. Example: the surface of a ball. <br>
A surface $`S`$ is an **open surface** if it is **not closed**. So, whatever two points
infinitely close to each other and located on either side of the surface, there exists
a path that connects these two points without crossing the surface. Example: the surface
of a sheet of paper. (to be submitted to mathematicians). <br>

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Cálculo integral del área $`A`$ de una superficie cerrada macroscópica $`S_{\circ}`$ :<br>
[FR] Calcul intégral de l'aire $`A`$ d'une surface fermée $`S_{\circ}`$ macroscopique :<br>
[EN] Integral calculus of the area $`A`$ of a macroscopic closed surface $`S_{\circ}`$ :<br>
$`A=\displaystyle\oiint_{S_{\bigcirc}} dA`$<br>
[ES] Cálculo integral del área $`A`$ de una superficie abierta macroscópica $`S_{\smallsmile}`$ :<br>
[FR] Calcul intégral de l'aire $`A`$ d'une surface ouverte $`S_{\smallsmile}`$ macroscopique :<br>
[EN] Integral calculus of the area $`A`$ of a macroscopic open surface $`A_{\smallsmile}`$ :<br>
$`A=\displaystyle\iint_{S_{\smallsmile}} dA`$<br>
[ES] Esta diferencia en la escritura es muy importante. Por ejemplo en electromagnetismo :<br>
[FR] Cette différence d'écriture est très importante. Par exemple en électromagnétisme :<br>
[EN] This difference in writing is very important. For example in electromagnetism :<br>
$`\displaystyle\forall S_{\bigcirc}\quad  \oiint_{S_{\bigcirc}} \overrightarrow{B}\cdot\overrightarrow{dA}=0\quad`$, 
en general $`\displaystyle\iint_{S_{\smile}} \overrightarrow{B}\cdot\overrightarrow{dA}\,\cancel{=}\, 0`$

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Vector de posición (o vector de posición) de un punto $`M(x,y,z)`$ en coordenadas cartesianas :<br>
[FR] Vecteur position d'un point $`M(x,y,z)`$ en coordonnées cartésiennes :<br>
[EN] Position vector of a point $`M(x,y,z)`$ in Cartesian coordinates:<br>

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Elemento de volumen $`d\tau`$ en coordenadas cartesianas :<br>
[FR] Élément de volume $`d\tau`$ en coordonnées cartésiennes :<br>
[EN] Volume element $`d\tau`$ in Cartesian coordinates:<br>
$`d\tau=dx\;dy\;dz`$


### Coordenadas cilíndricas / Coordonnées cylindriques / Cylindrical coordinates (N3-N4)



* **N3 ($`\rightarrow`$ N4)**<br>
Las coordenadas cartesianas se escriben / les coordonnées cartésiennes s'écrivent / The artesian coordinates write :<br>
$`(\rho, \varphi, z)`$,<br>
con / avec /with :<br>
$`\rho\in [0;\infty[`$,  $`\varphi\in [0;2\pi[`$ et $`z \in [-\infty;\infty[`$.<br>
Coordenadas cartesianas de un punto $`M`$ /coordonnées cartésiennes d'un point $`M`$ / Cartesian coordinates of a point $`M`$ :<br>
$`(\rho_M, \varphi_M, z_M)`$,<br>
Escribimos / on écrit / we write :<br>
$`M(\rho_M, \varphi_M, z_M)`$<br>
Si el punto es cualquier punto, simplificamos / Si le point est un point quelconque, on simplifie
/ If the point is any point, we simplify ;<br>
$`M(\rho, \varphi, z)`$.

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] elemento escalar de línea :<br>
[FR] élément de longueur :<br>
[EN] scalar line element :<br>
<br>$`dl=\sqrt{d\rho^2+ (\rho\,d\varphi)^2+dz^2}`$


* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Cuando solo la coordenada $`\rho`$ de un punto $`M(\rho, \varphi, z)`$ varía
continuamente entre los valores $`\rho`$ y $`\rho+\Delta \rho`$, el punto $`M`$ recorre un segmento
de longitud $`\Delta l_{\rho}=\Delta \rho`$. Cuando $`\Delta \rho`$ 
tiende a $`0`$, la longitud infinitesimal $`dl_{\rho}`$ recorrida para el punto $`M`$ 
es :<br>
[FR] Lorsque seule la coordonnées $`\rho`$ d'un point $`M(\rho, \varphi, z)`$ varie de façon 
continue entre les valeurs $`\rho`$ et $`\rho+\Delta \rho`$, le point $`M`$ parcourt un sègment
de droite de longueur $`\Delta l_{\rho}=\Delta \rho`$. Lorsque $`\Delta \rho`$ tend vers $`0`$,
la longueur infinitésimale $`dl_{\rho}`$ parcourue pour le point $`M`$ est :<br>
[EN] When only the $`x`$ coordinate of a point $`M(\rho, \varphi, z)`$ varies
continuously between the values $`\rho`$ and $`\rho+\Delta \rho`$, the point $`M`$ covers
a line segment of length $`\Delta l_{\rho}=\Delta \rho`$. When $`\Delta \rho`$ tends
towards $`0`$, the infinitesimal length $`dl_{\rho}`$ covered by the point $`M`$ is :<br>
<br>$`\displaystyle d\rho=\lim_{\Delta \rho\rightarrow 0 \\ \Delta \rho>0} \Delta \rho`$
$`\quad\Longrightarrow\quad dl_{\rho}=d\rho`$.<br>       <!--\text{élément scalaire d'arc : }-->
<br>tambien / de même / similarly : $`dl_z=dz`$.<br>
<br>[ES] Cuando solo la coordenada $`\varphi`$ de un punto $`M(\rho, \varphi, z)`$ varía
continuamente entre los valores $`\varphi`$ y $`\varphi +\Delta \varphi`$, el punto $`M`$ 
recorre un arco de circulo
de longitud $`\Delta l_{\varphi}=\rho\:\Delta \varphi`$. Cuando $`\Delta \varphi`$ 
tiende a $`0`$, la longitud infinitesimal $`dl_{\varphi}`$ recorrida para el punto $`M`$ 
es :<br>
[FR] Lorsque seule la coordonnées $`\varphi`$ d'un point $`M(\rho, \varphi, z)`$ varie de façon 
continue entre les valeurs $`\varphi`$ et $`\varphi +\Delta \varphi`$, le point $`M`$ parcourt un 
arc de cercle de longueur $`\Delta l_{\varphi}=\rho\;\Delta \varphi`$. Lorsque $`\Delta \varphi`$ tend vers $`0`$,
la longueur infinitésimale $`dl_{\varphi}`$ parcourue pour le point $`M`$ est :<br>
[EN] When only the $`\varphi`$ coordinate of a point $`M(\rho, \varphi, z)`$ varies
continuously between the values $`\varphi`$ and $`\varphi+\Delta \varphi`$, the point $`M`$ covers
an arc of circle of length $`\Delta l_{\varphi}=\rho\,\Delta \varphi`$. When $`\Delta \varphi`$ tends
towards $`0`$, the infinitesimal length $`dl_{\varphi}`$ covered by the point $`M`$ is :<br>
<br>$`\displaystyle d\varphi=\lim_{\Delta \varphi\rightarrow 0 \\ \Delta \varphi>0} \Delta\varphi`$
$`\quad\Longrightarrow\quad dl_{\phi}=\rho\,d\varphi`$.<br>    


* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Cuando solo la coordenada $`\rho`$ de un punto $`M(\rho, \varphi, z)`$ aumenta
infinitesimalmente entre los valores $`\rho`$ y $`\rho+d\rho`$ ($`d\rho>0`$)
para llegar al punto $`M'(\rho+\Delta\rho, \varphi, z)`$, el vector de desplazamiento
$`\overrightarrow{MM'}=\partial\overrightarrow{OM}_{\rho}`$ del punto $`M`$ el vector 
tangente a la trayectoria en el punto $`M`$ que se escribe :<br>
[FR] Lorsque seule la coordonnées $`\rho`$ d'un point $`M(x,y,z)`$ s'accroît de façon 
infinitésimale entre les valeurs $`\rho`$ et $`\rho+d\rho`$ ($`d\rho>0`$)
pour atteindre le point $`M'(\rho+\Delta\rho, \varphi, z)`$, le vecteur déplacement 
$`\overrightarrow{MM'}=\partial\overrightarrow{OM}_{\rho}`$ du point $`M`$ est le vecteur
tangent à la trajectoire au point $`M`$ qui sc'écrit :<br>
When only the $`\rho`$ coordinate of a point $`M(x,y,z)`$ increases infinitesimally between
the values $`\rho`$ and $`\rho+d\rho`$ ($`d\rho>0`$) to reach the point
$`M'(\rho+\Delta\rho, \varphi, z)`$, the displacement vector
$`\overrightarrow{MM'}=\partial\overrightarrow{OM}_{\rho}`$ of the point $`M`$ is the 
tangent vector to the trajectory at point $`M`$. It writes :<br>
<br>$`\overrightarrow{MM'}=\partial\overrightarrow{OM}_{\rho}=\dfrac{\partial \overrightarrow{OM}}{\partial \rho}\cdot d\rho`$<br>
<br>[ES] El vector unitario tangente a la trayectoria  $`\overrightarrow{e_{\rho}}`$ (que indica la dirección y el sentido
de desplazamiento del punto $`M`$ cuando solo aumenta infinitesimalmente la coordenada $`\rho`$ se escribe:<br>
[FR] Le vecteur unitaire tangent à la trajectoire $`\overrightarrow{e_{\rho}}`$ (qui indique la direction et le sens 
de déplacement du point $`M`$ lorsque seule la coordonnée $`\rho`$ croît de façon infinitésimale) s'écrit :<br>
[EN] The unit vector tangent to the trajectory  $`\overrightarrow{e_{\rho}}`$  (which indicates the direction of displacement 
of the point $`M`$ when only the coordinate $`\rho`$ increases in an infinitesimal way) writes :<br>
<br>$`\overrightarrow{e_{\rho}}=\dfrac{\partial\overrightarrow{OM}_{\rho}}{||\partial\overrightarrow{OM}_{\rho}||}`$<br>
<br>tambien / de même / similarly :<br>
$`\partial\overrightarrow{OM}_{\varphi}=\dfrac{\partial \overrightarrow{OM}}{\partial \varphi}\cdot d\varphi`$,
$`\quad\overrightarrow{e_{\varphi}}=\dfrac{\partial\overrightarrow{OM}_{\varphi}}{||\partial\overrightarrow{OM}_{\varphi}||}`$<br>
$`\partial\overrightarrow{OM}_z=\dfrac{\partial \overrightarrow{OM}}{\partial z}\cdot dz`$,
$`\quad\overrightarrow{e_z}=\dfrac{\partial\overrightarrow{OM}_z}{||\partial\overrightarrow{OM}_z||}`$

* **N3 ($`\rightarrow`$ N4)**<br> 
[ES] Los vectores $`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ y $`\overrightarrow{e_z}`$ 
forman una **base ortonormal** del espacio. La base $`(\overrightarrow{e_{\rho}},\overrightarrow{e_x},\overrightarrow{e_x})`$ 
es la **base asociada a las coordenadas cartesianas**. En coordenadas cartesianas, los vectores
de base asociadas a las coordenadas cartesianas mantienen la 
**misma dirección y el mismo sentido sea cual sea la posición del punto $`M`$**.<br>
[FR] Les vecteurs $`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ y $`\overrightarrow{e_z}`$ 
forment une **base orthonormée** de l'espace. C'est la **base associée aux coordonnées cartésiennes**.
En coordonnées cartésiennes, les vecteurs de base gardent la 
**même direction et le même sens quelque-soit la position du point $`M`$**.<br>
[EN] The vectors $`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ y $`\overrightarrow{e_z}`$ 
form an **orthonormal basis** of space. It is the **base associated with Cartesian coordinates**.
In Cartesian coordinates, the base vectors  
**change of direction when the position of the point $`M`$ changes**.<br>
<br>$`(\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_x})`$ 
base ortogonal dependiente de la posición de $`M`$ / base orthogonale dépendante
de la position de $`M`$ / orthogonal basis dependent of the position of $`M`$.

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] La norma del vector $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}`$ 
es el elemento escalar de linea $`dl_x`$, entonces el vector $`\overrightarrow{e_x}`$ 
se escribe :<br>
[FR] La norme du vecteur $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}`$ 
est l'élément de longueur $`dl_x`$, donc le vecteur $`\overrightarrow{e_x}`$ s'écrit :<br>
[EN] the norm (or length) of the vector $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}`$ 
is the scalar line element $`dl_x`$, so the vector $`\overrightarrow{e_x}`$ writes :<br>
<br>$`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}=dl_x\;\overrightarrow{e_x}=dx\;\overrightarrow{e_x}`$<br>
<br>tambien / de même / similarly :<br>
$`\partial\overrightarrow{OM}_y=\overrightarrow{dl_y}=dl_y\;\overrightarrow{e_y}=dy\;\overrightarrow{e_y}`$<br>
$`\partial\overrightarrow{OM}_z=\overrightarrow{dl_z}=dl_z\;\overrightarrow{e_z}=dz\;\overrightarrow{e_z}`$

* **N3 ($`\rightarrow`$ N4)**<br>
[ES] Los 3 vectores $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}\quad`$,
$`\quad\partial\overrightarrow{OM}_y=\overrightarrow{dl_y}\quad`$ y
$`\quad\partial\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ son 2 a 2 ortogonales.<br>
[FR] Les 3 vecteurs $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}\quad`$,
$`\quad\partial\overrightarrow{OM}_y=\overrightarrow{dl_y}\quad`$ et
$`\quad\partial\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ sont orthogonaux 2 à 2.<br>
[EN] The 3 vectors $`\partial\overrightarrow{OM}_x=\overrightarrow{dl_x}\quad`$,
$`\quad\partial\overrightarrow{OM}_y=\overrightarrow{dl_y}\quad`$ and
$`\quad\partial\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ are 2 to 2 orthogonal.<br>
$`\Longrightarrow`$ :<br>
[ES] El área de un elemento de superficie construido por 2 de estos vectores 
se expresará simplemente como el producto de sus normas.Y el volumen definido 
por estos 3 vectores será simplemente el producto de sus estándares.<br>
[FR] L'aire d'un élément de surface construit par 2 de ces vecteurs s'exprimera 
simplement comme le produit de leurs normes. Et le volume définit par ces 3 vecteurs 
sera simplement le produits de leurs normes.<br>
[EN] The area of a surface element constructed by 2 of these vectors will be expressed 
simply as the product of their norms. The volume defined by these 3 vectors will simply
be the product of their norms.





### Coordenadas esféricas / Coordonnées sphériques / Spherical coordinates (N3-N4)

$`M=M(\rho, \theta, \varphi)`$

[ES] elemento escalar de línea :<br>
[FR] élément de longueur :<br>
[EN] scalar line element :<br>

$`dl=\sqrt{dr^2+(r\,d\theta)^2+(r\,sin\theta\,d\varphi)^2}`$

### Coordenadas curvilíneas generalizadas / Coordonnées curvilignes généralisées / Generalized curvilinear coordinates (N4)


