---
title: Le phénomène d'interférences
published: true
routable: true
visible: false
lessons: 
    - slug: interferences-diffraction
      order: 2
---

!!!! *COURS EN CONSTRUCTION :* <br>
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com. Ce cours est *en construction*, il n'est *pas validé par l'équipe pédagogique* à ce stade. <br>
!!!! Document de travail destiné uniquement aux équipes pédagogiques.

<!--MétaDonnée : ... -->

### Le phénomène d'interférences

Le **phénomène d'interférences** est observé lorsque la *superposition de deux ou 
plusieurs ondes* de même nature (sonores, mécaniques, électromagnétiques) donne lieu 
à une *intensité résultante qui n'est pas égale à la simple addition des intensités* 
prises individuellement.

<!-------------------------------
un image animée
M3P2-cuve-ondes-2-sources-ponctuelles-interferences-1_L800.gif
ou une video mp4 très courtes (1s) à mettre en boucle
M3P2-cuve-ondes-2-sources-ponctuelles-interferences-1_L800.mp4
sont disponibles dès que la taille (environ 2Mo) est acceptée sur le GitLab
-------------------------------->

![](M3P2-cuve-ondes-2-sources-ponctuelles-interferences-1_L1200.jpg)<br>
_Interférences de deux sources ponctuelles, réalisées dans 
une cuve à onde par deux aiguilles vibrantes qui percute la surface de l'eau [image libre de droit] ._

! Note : pour l'onde électromagnétique, une interférence peut se traduire localement par le phénomène  :  lumière + lumière = obscurité.

**En pratique** sur un écran d'observation, les *intensités individuelles*  des ondes
incidentes *varient lentement* alors que les **différences de phase** entre les ondes 
qui interfèrent et qui sont à l'origine du phénomène d'interférence **varient rapidement**.

On appelle **franges d'interférences** le *lieu des points M* caractérisés par une
*intensité moyenne $`\overline{\,I\,}`$ donnée* :

* Les **franges brillantes** correspondent à une *intensité maximale : $`I=I_{max}`$*
* Les **franges sombres** correspondent à une *intensité minimale : $`I=I_{min}`$*

### Quantification du phénomène d'interférences : le contraste

Le **contraste** (ou visibilité) des franges quantifie notre *aptitude à discerner
les franges* (notre aptitude visuelle imparfaite, ou l'aptitude d'un capteur de rayonnement
moins imparfaite).

Il se définit localement à partir de la distribution d'intensité résultante des ondes
qui interfèrent. Si localement *$`I_{max}`$* est l'*intensité maximum* et *$`I_{min}`$* 
l'*intensité minimum*, le contraste (ou visibilité) des franges se définit par :

$`\mathcal{V} = \dfrac{I_{max}-I_{min}}{I_{max}+I_{min}}`$

Cette caractérisation des franges permet une **mesure comprise entre 0 et 1**, valeurs limites
qui représentent les *deux cas extrêmes* :

* Pas de franges, donc **intensité uniforme** $`\Longleftrightarrow`$ $`I_{max}=I_{min}`$ $`\Longleftrightarrow`$ *$`\mathcal{V} = 0`$*.

* **Franges de visibilité maximum** $`\Longleftrightarrow`$ $`I_{min}=0`$ $`\Longleftrightarrow`$ *$`\mathcal{V} = 1`$*.

### Interférences entre deux ondes électromagnétiques monochromatiques planes

Soient **deux ondes planes** dans le vide, notées 1 et 2, de **même pulsation  $`\omega`$**
et d'**amplitudes $`A_1`$ et $`A_2`$**, de **polarisations rectilignes selon 
$`\overrightarrow{e_1}`$ et $`\overrightarrow{e_2}`$**, et qui *se superposent en un point M*
de l'espace localisé par le vecteur $`\overrightarrow{r} = \overrightarrow{OM}`$, 
par rapport à un point origine $`O`$ pris comme origine de l'espace, 

Ces deux ondes s'écrivent :

* _Expression en notation réelle :_

$`\overrightarrow{E_1}(\overrightarrow{r},t)
= A_1 \cdot cos (\omega t-\phi_1)\cdot \overrightarrow{e_1}\quad`$ et
 $`\quad \overrightarrow{E_2}(\overrightarrow{r},t)
= A_2 \cdot cos(\omega t-\phi_2)\cdot \overrightarrow{e_2}`$

* _Expression en notation complexe :_

$`\underline{\overrightarrow{E_1}}(\overrightarrow{r},t)
= A_1 \cdot e^{-i\,(\omega t-\phi_1)} \cdot \overrightarrow{e_1}\quad
`$ et $`\quad\underline{\overrightarrow{E_2}}(\overrightarrow{r},t)
= A_2 \cdot e^{-i\,(\omega t-\phi_2)} \cdot \overrightarrow{e_2}`$

!!!! *ATTENTION :*
!!!!
!!!! L'*écriture réelle d'une onde, seule, décrit la réalité physique mesurable de l'onde*.
!!!! Le champ réel est la partie réelle du champ complexe : $`\overrightarrow{E}(\overrightarrow{r},t)= \Re [\underline{\overrightarrow{E}}(\overrightarrow{r},t)]`$
!!!!

!! *POUR ALLER PLUS LOIN :*
!!
!! L'*onde électromagnétique plane progressive monochromatique (OPPM)* est un *concept mathématique* sans réalité. En effet, de par son expression mathématique  <!-- <br>
!! $`\overrightarrow{E}(\overrightarrow{r},t)= E_0 \cdot cos (\overrightarrow{k}.\overrightarrow{r}-\omega t)\cdot \overrightarrow{u}`$ (ici polarisée rectilignement)<br>
!! --> l'OPPM peut être définie à chaque instant, depuis des temps infinis dans le passé et jusqu'en des temps infinis dans le futur, et elle s'étend à l'infini dans tout l'espace. Et de part la densité d'énergie électromagnétique qu'elle porte, l'OPPM contient une énergie infinie.
!! <!--
!! De plus, comme en présence d'une OPPM, un volume infinitésimal $`d \tau`$ de l'espace contient l'énergie électromagnétique moyenne <br>
!! $`\langle U_{EM}\rangle = (\langle u_{E}\rangle + \langle u_{M} \rangle) \cdot d\tau`$$`=\left(\dfrac{\epsilon_0\langle E^2\rangle}{2} + \dfrac{\langle B^2\rangle}{2\mu_0}\right) \cdot d\tau`$$`=\left(\dfrac{\epsilon_0\langle E^2\rangle}{2} + \dfrac{\langle E^2\rangle}{2\,c^2\,\mu_0}\right) \cdot d\tau`$$`=\left(\dfrac{\epsilon_0\langle E^2\rangle}{2} + \dfrac{\epsilon_0\langle E^2\rangle}{2}\right) \cdot d\tau`$$`=\epsilon_0\langle E^2\rangle \cdot d\tau`$
!!
!!alors intégré sur tout l'espace, une OPPM contiendrait une énergie infinie.
!! -->
!!
!! Cela est *physiquement non réaliste*. Le champ électromagnétique est en couplage avec la distribution de charges dans l'univers. Il est créé lorsque des charges sont accélérées, se propage puis se modifie et perd  de l'énergie lorsqu'il accélère des charges suite à la forcre qu'il exerce sur elles.
!!
!! Cependant, le grand *intérêt du concept d' OPPM* vient du *théorème de Fourier*, qui démontre que *tout signal dépendant du temps peut se décomposer comme une somme (discrète pour un signal périodique, intégrale pour un signal transitoire) de fonctions harmonique (harmomique=sinusoïdale).  Ce point sera détaillé dans une autre partie. De ce fait,nous portons une attention particulière aux OPPM.

Le *champ électrique résultant* est :

* _Expression en notation réelle :_

$`\overrightarrow{E_{tot}}(\overrightarrow{r},t)= A_1 \cdot cos (\omega t-\phi_1)\cdot \overrightarrow{e_1}\;`$
$`+\;A_2 \cdot cos (\omega t-\phi_2)\cdot \overrightarrow{e_2}`$

* _Expression en notation complexe :_

$`\underline{\overrightarrow{E}_{tot}}(\overrightarrow{r},t)
=A_1 \; e^{-i\,\omega t} \, e^{i\,\phi_1}\cdot \overrightarrow{e_1}
`$$`\;+\;
 A_2 \; e^{-i\,\omega t} \, e^{i\,\phi_2}\cdot \overrightarrow{e_2}`$
 
 $`\underline{\overrightarrow{E}}_{tot}(\overrightarrow{r},t)
= e^{-i\,\omega t}
\cdot
 [A_1 \, e^{i\,\phi_1}\cdot \overrightarrow{e_1}
`$$`+
 A_2 \, e^{i\,\phi_2}\cdot \overrightarrow{e_2}]`$
 
 L'*intensité de l'onde résultante $`I_{tot}`$* s'écrit :
 
 $`\langle I_{tot} \rangle= \epsilon_0 \,c \; ||\overrightarrow{E}||^2`$$`=\dfrac{\epsilon_0\,c}{2} \; ||\overrightarrow{E}||`$
 
 * _Calcul en notation réelle :_

$`I_{tot}= \dfrac{\epsilon_0\,c}{2} \; [A_1^2 \cdot cos^2 (\omega t-\phi_1)\cdot \overrightarrow{e_1} \cdot \overrightarrow{e_1}`$ $`\;+\;A_2^2 \cdot cos^2 (\omega t-\phi_2)\cdot \overrightarrow{e_2} \cdot \overrightarrow{e_2}`$ $`\;+\;2 \;A_1\,A_2 \cdot cos (\omega t-\phi_1)\,cos (\omega t-\phi_2)\cdot \overrightarrow{e_1} \cdot \overrightarrow{e_2}]`$


 * _Calcul en notation complexe :_

$`I_{tot}
= \dfrac{\epsilon_0\,c}{2} \; ||\overrightarrow{E}||`$$`
= \dfrac{\epsilon_0\,c}{2} \; \overrightarrow{E}\cdot \overrightarrow{E^*}`$
$`= A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1} `$
$`+  A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}`$
$`+2 \,A_1 \, A_2\; \overrightarrow{e_1} \cdot \overrightarrow{e_2}`$

$`\quad\quad = A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1} `$
$`+  A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2} `$
$`+ \,A_1 \, A_2\;e^{i(\phi_1-\phi_2)} \;\overrightarrow{e_1} \cdot \overrightarrow{e_2}`$
$`+ \,A_2 \, A_1\;e^{i(\phi_2-\phi_1)} \;\overrightarrow{e_2} \cdot \overrightarrow{e_1}`$

--------------------

* Si les deux ondes ont des **polarisations rectilignes orthogonales $`(\overrightarrow{e_1} \perp \overrightarrow{e_2}) `$**, alors 

$`I_{tot}= A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1} `$$`+ A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}=I_1 + I_2`$

Il n'y a *pas interférence* entre ces deux ondes.

-----------------------

* Si les deux ondes ont des **polarisations rectilignes non orthogonales $`(\overrightarrow{e_1} \cdot \overrightarrow{e_2}) =cos \Phi `$**, telles que , alors 

$`I_{tot}=A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1}+A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}`$
$`+2 \,A_1\,A_2\,cos(\phi_1 - \phi_2)=I_1 + I_2`$
$`+ \,2\,\sqrt{I_1\,I_2} \, cos(\phi_1 - \phi_2) \cdot cos \Phi`$

Un *terme d'interférence $`\,2\,\sqrt{I_1\,I_2} \, cos(\phi_1 - \phi_2) \cdot cos \Phi`$* apparait.

-------

* Si les deux ondes ont des **polarisations rectilignes dans la même direction $`(\overrightarrow{e_1} = \overrightarrow{e_2}) `$** alors  $`cos\, \Phi = 1`$  et :

$`I_{tot}= A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1}+A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}`$
$`+2\,A_1\,A_2\,cos(\phi_1 - \phi_2)=I_1 + I_2`$
$`+\,2\,\sqrt{I_1\,I_2} \, cos(\phi_1 - \phi_2)`$

Le *terme d'interférence* se limite à *$`\,2\,\sqrt{I_1\,I_2} \, cos(\phi_1 - \phi_2)`$*.

------------

* Si les deux ondes ont une **même amplitude $`A`$** et des **polarisations rectilignes dans la même direction $`(\overrightarrow{e_1} = \overrightarrow{e_2}) `$** alors :

$`I_{tot}=A^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1}+A^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}`$
$`+2 \,A^2\,cos(\phi_1 - \phi_2)=2 \;I \cdot [\,1`$
$`+ cos(\phi_1 - \phi_2)]`$

Ce sont les *meilleures conditions de réalisation et d'observation*.

L'**interférence** est :

* **totalement destructive** en tous les point de l'espace où les deux ondes sont en *opposition de phase*, soit  :

*$`|\phi_1 - \phi_2|=(2n+1)\,\pi`$ avec $`n \in \mathbb{Z}`$ $`\Longrightarrow cos(\phi_1 - \phi_2)=-1`$*

En ces points là * $`I_{tot}=I_{min}=0`$* , l'*intensité est nulle* et donc l'obscurité totale.

* **totalement constructive** en tous les point de l'espace où les deux ondes sont *en phase*, soit :

*$`|\phi_1 - \phi_2|=2n\,\pi`$, avec $`n \in \mathbb{Z} `$ $`\Longrightarrow cos(\phi_1 - \phi_2)=+1`$*

En ces points là, *$`I_{tot}=I_{max}= 4 \,A^2`$*.

### Interférences par N ondes de même amplitude, déphasées avec un pas constant

Soient **N ondes** de *même amplitude $`A`$* déphasées entre-elles d'un *pas constant $`\phi`$*. 

$`A_{tot}=A\,e^0\,+\,A\,e^{i\phi}\,+\,A\,e^{i\,2\,\phi}\,+\,\cdot\cdot\cdot\,`$$`+\,A\,e^{i\,(N-1)\,\phi}`$

$`\quad =A\,\cdot \,(1 \,+\,e^{i\phi}\,+\,e^{i\phi}\,+\,\cdot\cdot\cdot\,`$$`+\,e^{i\,(N-1)\,\phi})`$

Le *terme entre parenthèse* forment une **progression géométrique de raison $`e^{i\phi}`$**.

! *RAPPEL :*
!
! La *somme $`S_N`$ des termes d'une suite géométrique* de *premier terme $`a`$* et de *raison  $`q`$* avec $`q \ne 0`$ et  $`q \ne 1`$ s'écrit :
!
! $`S_N=a + a\,q + a\,q^2 + a\,q^3 + \cdot\cdot\cdot `$$`+ a\,q^{N-1}`$
!
! donc
!
! $`q\,S_N= a\,q + a\,q^2 + a\,q^3 + a\,q^4 + \cdot\cdot\cdot `$$`+ a\,q^N`$
!
! et 
!
! $`q\,S_N-S_N= a\,q^N \,- a`$
!
! $`S_N\,(q-1)= a\,(q^N-1)`$
!
! *$`S_N=a \cdot \dfrac{q^N-1}{q-1}`$*
!


Si *j'applique ce résultat* concernant les suites géométriques pour calculer le terme d'**amplitude totale résultante** de la superposition des ondes considérées, j'obtiens

$`\underline{A_{tot}}=A\cdot \dfrac{e^{i\,N\,\phi}-1}{e^{i\,\phi}-1}`$
$`\;=\dfrac{(1-cos\,N\phi)+i\,sin\, N\phi}{(1-cos\,\phi)+i\,sin\,\phi}`$

L'**intensité résultante** est alors

$`I_{tot}=\underline{A_{tot}}\,\underline{A^*_{tot}}=|\,A^2\,|`$
$`=A^2\cdot\dfrac{(1-cos^2\,N\phi)+sin^2\,N\phi}{(1-cos^2\,\phi)+sin^2\,\phi}`$

$`I_{tot}=A^2\cdot\dfrac{1-2\cos\,N\phi+cos^2\,N\phi+sin^2\,N\phi}{1-2\cos\,\phi+cos^2\,\phi+sin^2\,\phi}`$
$`= A^2\cdot\dfrac{2-2\cos\,N\phi}{2-2\cos\,\phi}`$

$`I_{tot}= A^2\cdot\dfrac{1-cos\,N\phi}{1-cos\,\phi}`$

! *RAPPEL :* 
!
! Des deux relations trigonométriques de base suivantes :
!
! $`cos(a-b)=cos\,a \;cos\,b \;`$$`+\; sin\,a \;sin\,b\quad `$(1)<br>
! $`cos(a+b)=cos\,a \;cos\,b \;`$$`-\; sin\,a \;sin\,b\quad`$(2)
! 
! j'obtiens, en soustrayant (1)-(2)
! 
! $`cos(a-b)-cos(a+b)=2\; sin\,a \;sin\,b `$
!

L'identification $`a=b=\dfrac{N\,\phi}{2}`$ dans la relation $`cos(a-b)-cos(a+b)=2\; sin\,a \;sin\,b `$ conduit à

$`cos\left(\dfrac{N\,\phi}{2}-\dfrac{N\,\phi}{2}\right)-cos\left(\dfrac{N\,\phi}{2}+\dfrac{N\,\phi}{2}\right)`$
$`=2\; sin\,\dfrac{N\,\phi}{2} \;sin\,\dfrac{N\,\phi}{2}`$

$`cos\,0 - cos\,N\,\phi=1 - cos\,N\,\phi `$$`=2\; sin^2\,\dfrac{N\,\phi}{2}`$

De même, l'identification $`a=b=\dfrac{\phi}{2}`$  conduit à $`1 - cos\,\phi =2\; sin^2\,\dfrac{\phi}{2}`$ .

Au total, la **distribution d'intensité en fonction du pas de déphasage  $`\phi`$** entre deux rayons consécutifs s'écrit :

**$`\mathbf{I_{tot}= A^2\cdot\dfrac{sin^2\,\dfrac{N\,\phi}{2}}{sin^2\,\dfrac{\phi}{2}}}`$**


! *IMPORTANT :*
!
! Cette *fonction $`\mathbf{\dfrac{sin^2\,\dfrac{N\,\phi}{2}}{sin^2\,\dfrac{\phi}{2}}}`$* est une *fonction fondamentale dans l'étude des réseaux de diffraction*, et nous l'appellerons ici *fonction Interférences-réseau*, notée *$`Interf_{res}`$*.
!
! Cette fonction dépend du nombre entier N d'ondes qui interfèrent et de la différence de phase constante $`\phi`$ entre deux ondes successives : $`Interf_{res}=Interf_{res}(N,\phi)`$
!

#### Propriétés de la fonction $`Interf_{res}`$

Le phénomène d'interférence se traduisant par l'alternance de franges sombres et
brillantes, et se mesurant localement par le contraste à partir de l'intensité maximum 
et l'intensité minimum entre deux franges successives, j'étudie les positions et 
intensités des maxima et minima de cette fonction.

Cette fonction prendra clairement un maximum appelé **maximum principal** lorsque 
son *dénominateur $`sin^2\dfrac{\phi}{2}`$ s'annule*, ce qui est réalisé *aux valeurs
de $`\phi`$* telles que :

 $`sin^2 \dfrac{\phi}{2} = 0 \quad\Longleftrightarrow \quad\dfrac{\phi}{2}=k\pi`$
  *$`\quad\Longleftrightarrow\quad \mathbf{\phi=2\,k\pi\;\quad}`$, avec $`\mathbf{k \in \mathbb{Z}}`$*.
  
Pour trouver l'intensité de ces maxima, je dois étudier la valeur de $`interf_{res}(\phi)`$ 
dans la limite où $`\phi`$ tend vers $`2\,k\pi`$. En ces points, le dénominateur et le
numérateur de la fonction $`interf_{res}(\phi)`$ s'annulent, la valeur de la fonction est
alors indéterminée. Je lève cette indétermination en calculant la limite de la fonction 
$`interf_{res}(\phi)`$ en m'aidant d'un développement limité au voisinage de ces points
$`\phi=2\,k\pi`$,.`$

! *RAPPEL :*
!
! Soit une fonction  $`f`$ à variable réelle $`x`$, définie sur un intervalle $`U`$ de $`\mathbb{R}`$. 
! Si cette fonction est $`k`$ fois dérivable sur $`U`$ et si sa $`k^{ième}`$ fonction dérivée, 
! notée $`f^{(k)}`$, est continue sur $`U`$ (les mathématiciens disent alors que cette fonction 
! est de classe $`C^k`$), alors le développement limité à l'ordre $`n\le k`$ de $`f`$ 
! au voisinage d'un point $`x_0\in U`$ s'exprime par la formule de Taylor :<br>
! $`f(x-x_0)\;=\;f(x_0)+(x-x_0) \cdot f^{(1)}(x_0)`$$`\;`$
! $`\;+\;\dfrac{(x-x_0)^2}{2\,!} \cdot f^{(2)}(x_0)`$
! $`\;+\;\dfrac{(x-x_0)^3}{3\,!}\cdot f^{(3)}(x_0)`$$`\;+\;\cdot\cdot\cdot`$
! $`\;+\;\dfrac{(x-x_0)^n}{n\,!}\cdot f^{(n)}(x_0)`$$`\;+\; o(x-x_0)`$,<br>
! où $`o(x-x_0)`$ est une fonction qui tend vers $`0`$ lorsque $`x`$ tend vers $`x_0`$ plus vite que la fonction $`x^n`$.
!
! En physique, la somme<br>
! $`f(x_0)+\sum_{i=1}^{n}\dfrac{(x-x_0)^i}{i\,! }\cdot f^{(i)}(x_0)`$ <br> réalise l'approximation à l'ordre $`n`$ de la fonction $`f `$ au point $`x`$, approximation d'autant meilleure que $`n`$ est grand :
!
! $`f(x) \simeq f(x_0)+\sum_{i=1}^{n}\dfrac{(x-x_0)^i}{i\,! }\cdot f^{(i)}(x_0)`$
!

Je pose $`x=\dfrac{N\phi}{2}`$ et je calcule les premiers termes d'un développement 
limité de la fonction $`f(x)=\sin^2\;x'`$ au voisinage de $`x_0=2N\,k\pi`$ :

* $`f(x_0)=sin^2(2\,k\pi)=0`$

* $`f^{(1)}(x)=\dfrac{d \sin^2 x}{d x}=2\cdot cos x \cdot sin x \quad`$<br>
$`\Longrightarrow \quad f^{(1)}(x_0) = 2\cdot cos (2\,k\pi)^2  \cdot sin (2\,k\pi)^2 =0`$

* $`f^{(2)}(x)=\dfrac{d^2\sin^2 x}{d^2 x}=\dfrac{d}{d x}\left(2\cdot cos x \cdot sin x \right)`$ 
$`=2 \;[\,cos^2 x - sin^2 x\,]\quad`$<br>
$`\Longrightarrow \quad f^{(2)}(x_0)=2 [cos (2\,k\pi)^2 -sin(2\,k\pi)^2]=2`$

Appliquer alors la formule de Taylor à l'ordre 2 me donne

$`sin^2 x=2\;\dfrac{x^2}{2}+o(x-x_0)`$

J'en déduis la limite de $`sin^2 x`$ lorsque $`x`$ tend vers $`x_0`$ ,

$`\displaystyle\lim_{x \to x_0}sin^2 x = x^2`$

et en réexprimant cette fonction avec la variable $`\phi`$, j'obtiens

$`\displaystyle\lim_{\phi \to 2\,k\pi}sin^2 \dfrac{N\phi}{2}=\dfrac{N^2\phi^2}{4}`$

De même, la valeur $`N=1`$ me donne $`\displaystyle\lim_{\phi \to 2 k\pi}sin^2 \dfrac{\phi}{2}=\dfrac{\phi^2}{4}`$.

AInsi les **maxima principaux** de la fonction $`Interf_{res}`$ ont pour *valeur unique*  :

$`Interf_{res}(2 k\pi)=\displaystyle\lim_{\phi \to 2 k\pi}\dfrac{sin^2 \dfrac{N\phi}{2}}{sin^2 \dfrac{\phi}{2}}`$
$`=\dfrac{\dfrac{N^2\phi^2}{4}}{\dfrac{\phi^2}{4}}`$

*$` \mathbf{ Interf_{res}(2 k\pi)=N^2 }`$*

! *IMPORTANT :* 
!
! Les *maxima principaux de la fonction Interférences-réseau* ont une *même intensité qui croît comme $`N^2`$*, carré du nombre d'ondes qui interfèrent.
!
 
**Entre ces maxima principaux**, la fonction Interférences-réseau possède **plusieurs
minima nuls** localisés aux valeurs de $`\phi`$ pour lesquelles le numérateur de la 
fonction s'annule, soit *aux valeurs* 

$`sin^2 \dfrac{N\phi}{2} = 0 \quad\Longleftrightarrow \quad\dfrac{N\phi}{2}=k\pi`$

*$`\quad\Longleftrightarrow\quad\mathbf{\phi=\dfrac{2 k\pi}{N}}\quad`$, avec 
$`\mathbf{k \in \mathbb{N}}`$*.

Ainsi **entre deux maximas principaux** se trouvent *$`N-1`$ minima* de valeurs nulles,
séparés par *$`N-2`$ maxima secondaires*.

Le premier minimum nul jouxtant un maximum principal situé en $`\phi=2 k\pi`$ (maximum 
principal d'ordre k) est localisé en $`\phi=2 k\pi+\dfrac{2\pi}{N}`$. Ce déphasage
$`\dfrac{2\pi}{N}`$ entre un maximum principal et le premier munimum nul est un bon
critère pour quantifier la largeur d'un maximum principal. 

! *IMPORTANT :* 
!
!  La *largeur d'un pic principal*, quantifiée par la valeur du déphasage séparant le maximum du pic du premier minimum nul, est *proportionnelle à $1/N$*, inverse du nombre des ondes qui interfèrent.
!

#### Représentation de la fonction $`Interf_{res}`$

* $`N=1 \Longrightarrow`$ amplitude et intensité de l'onde uniforme : pas d'interférences.


* $`N=2 \Longrightarrow`$ amplitude set intensité de l'onde uniforme : interférences à deux ondes.

<!--![](interferences_intensity-seule_N2_L1200.jpg)-->

Faisons croître le nombre $`N`$ des ondes qui interfèrent, et observons :

![](interferences_N2-24_L1200.gif)


#### L'ordre d'observation d'un réseau de diffraction


Lors de l'observation de la lumière à l'infini dans une direction donnée, 
la différence de phase $`\phi`$ entre deux ondes est fonction de la longueur d'onde 
selon l'expression :

$`\phi=\dfrac{2 \pi \, \delta}{\lambda}`$.

Deux longueurs d'onde différentes donneront deux systèmes de franges différentes, qui se superposeront.

![](reseau-intensity-N2-N24_L1200.gif)
_Pour N=2, tous les pics principaux ont une même hauteur.
Ce n'est pas cas lorsque N croît cas cette figure à cause du pas
$`\Delta\phi`$ trop grand utilisé pour le calcul de cette figure réalisé 
avec un simple tableur. Tous les maxima devraient avoir la même valeur._


Et une première compréhension des ordres de travail d'un réseau de diffraction :

![](reseau-order-N8_L1200.jpg)  ![](reseau-order-N16_L1200.jpg)

<!-- pour le site, sera en .gif
 ![](reseau-order-N8-16_L1200.gif) -->

### Interférences à ondes multiples

Ce chapitre *généralise le chapitre précédent* aux interférences générées par des **ondes d'amplitudes différentes**, et de **pas de déphasage non constant**.

! *Domaine d'application :* 
!
! Cette étude me permettra de *comprendre et d'interpréter le phénomène d'interférence* (franges et couleurs) observées lorsque la *lumière* est *réflechie ou transmise à travers des couches minces*. 
!
! Outre l'interprétation des phénomènes, elle ouvre vers le *calcul des filtres interférentiels* et la *caractérisation de l'épaisseur de couches minces et des défauts de surface* . Pour cela je dois connaître quelques résultats importants des relations de Fresnel, c'est à dire concernant la réflexion et la transmission de la lumière entre deux matériaux transparents.

#### Coefficients de réflexion et de transmission

Les **relations de Fresnel** précisent le *comportement des ondes électromagnétiques à l'interface entre deux matériaux diélectriques*. 

Dans le cas ou l'onde électromagnétique atteint la surface avec un **angle d'incidence $`\theta_{inc}`$** nul, et tant que l'approximation **$`cos\,\theta_{inc}\simeq 1`$** peut être réalisée, les relations de Fresnel se simplifient et donne un *résultat très important* pour l'optique ondulatoire (et en complément pour l'optique des rayons) :

! *Rappel :*
!
! L'*optique ondulatoire* est un *modèle scalaire* des ondes électromagnétiques. Elle ne décrit pas la double nature vectorielle du champ électromagnétique ($`\vec(E), \vec{B}`$) et n'est pas sensible à la polarisation de la lumière. Ses calculs d'interférences correspondent à des composantes de $`\vec{E}`$ selon une même direction. L'*onde électromagnétique* est décrite par son *amplitude $` A`$* et son *intensité est porportionnelle à $`A^2`$, $`I\propto A^2`$* (en notation complexe, $`\underline{A}`$ et $`I\propto\underline{A}\,\underline{A}^*=|\underline{A}|^2`$).
!

Soit une **onde électromagnétique d'amplitude $`A`$** se propageant dans un milieu d'*indice de réfraction $`n_1`$* et atteignant sous incidence normale l'interface avec un *milieu d'indice de réfraction $`n_2`$*.

##### Coefficients en amplitude.

L'amplitude $`A_{trans}`$ de l'*onde transmise* s'écrit **$`A_{trans}=t_{12}\cdot A`$**,<br>
où **$`t_{12}`$** est le **coefficient de transmission en amplitude**.

L'amplitude $`A_{ref}`$ de l'*onde réfléchie* s'écrit **$`A_{ref}=r_{12}\cdot A`$**,<br>
où **$`r_{12}`$** est le **coefficient de réflexion en amplitude**.

Sous incidence normale _(et avec une très bonne approximation sous incidence quasi-normale)_ les coefficients $`t_{12}`$ et $`r_{12}`$ ne dépendent que des indices $`n_1`$ et $`n_2`$ :

*  **$`t_{12}=\dfrac{2\,n_1}{n_1 + n_2}`$** : donc $`t_{12}\in[0;1]`$, $`t_{12}`$ est **toujours positif**.
 
*  **$`r_{12}=\dfrac{n_1 - n_2}{n_1 + n_2}`$** : donc $`r_{12}\in[-1;1]`$, $`r_{12}`$ **peut être négatif** :<br>
**si $`r_{12}<0`$** alors on peut décomposer $`r_{12}`$ en **$`r_{12}`$**$`=-1\times |r_{12}|`$**$`=e^{\displaystyle i\,\pi} \times |r_{12}|`$**<br>
$`\Longrightarrow`$ : *à l'interface, l'onde réfléchie se déphase de $`\pi`$* (soit d'une *demi-longueur d'onde*) par rapport à l'onde incidente.

![reflexion-transmission-fresnel-amplitude-intensity_L1200.jpg](reflexion-transmission-fresnel-amplitude-intensity_L1200.jpg)
_Pour faciliter la visualisation, les angles d'incidence, de réflexion et de réfraction (ou transmission) sont largement exagérés sur le schéma. Les résultats utilisés concernant les relations de Fresnel supposent une onde incidente d'angle d'incidence quasi normal à l'interface._

##### Coefficients en intensité.

L'intensité $`I_{trans}`$ de l'*onde transmise* s'écrit **$`I_{trans}=T_{12}\cdot I`$**,<br>
où **$`T_{12}`$** est le **coefficient de transmission en intensité**.

L'intensité $`I_{ref}`$ de l'*onde réfléchie* s'écrit **$`I_{ref}=R_{12}\cdot I`$**,<br>
où **$`R_{12}`$** est le **coefficient de réflexion en intensité**.

Là encore, sous incidence normale les coefficients $`T_{12}`$ et $`R_{12}`$ ne dépendent que des indices $`n_1`$ et $`n_2`$ :

**$`T_{12}=\dfrac{n_1}{n_2}\times t_{12}^2`$**$` = \dfrac{n_1}{n_2}\cdot \dfrac{4\,n_1^2}{(n_1 + n_2)^2}`$
**$`=\dfrac{4\,n_1\,n_2}{(n_1 + n_2)^2}=t_{12}\cdot t_{21}`$**

**$`R_{12}= r_{12}^2=\dfrac{(n_1 - n_2)^2}{(n_1 + n_2)^2}`$**

Nous remarquons que *$`R_{12}=R_{21}`$* et nous noterons **$`R`$** le **coeficient de réflexion en intensité**. De même *$`T_{12}=T_{21}`$* et nous noterons **$`T`$** le **coeficient de transmission en intensité**.

!!! *Exemple :* Pour un *dioptre air / verre*, tel que $`n_{air}=1`$ et $`n_{verre}\simeq 1,5`$, 
!!!
!!! *$`r_{12}`$*$`=\dfrac{1-1,5}{1+1,5}=\dfrac{-\,0,5}{2,5}`$*$`\;=-\,0,2`$*
!!!
!!! *$`R\,`$*$`=r_{12}^2=0,04`$*$`=4\%`$*.
!!!
!!! *$`T`$*$`=\dfrac{4\times 1\times 1,5}{(1+1,5)^2}=\dfrac{6}{6,25}=0,96`$*$`\;=96\%`$*.
!!!
!!! Remarque : $`R+T=0,04+0,96=1`$
!!!

La loi de **conservation de l'énergie** s'avère bien *vérifiée* :

**$`R+T`$**$`=\dfrac{(n_1 - n_2)^2}{(n_1 + n_2)^2}+\dfrac{4\,n_1\,n_2}{(n_1 + n_2)^2}`$**$`=1`$**

A l'interface entre deux milieux diélectriques LHI (le vide ayant aussi les caractéristiques d'un tel milieu) l'*énergie incidente se répartit sans perte entre énergie réfléchie et énergie transmise*. 
<!-- bien sûr, si l'interface est caractérisée par une densité surfacique de courant <!-- ou de charges libres? à vérifier), ce n'est plus le même problème).-->

!!!! *Attention :*
!!!!
!!!! L'*erreur courante* est d'oublier que l'intensité de l'onde n'est que proportionelle (et pas égale) au carré de l'amplitude : **$`I\propto A^2`$ et pas $`\require{cancel}\xcancel{I= A^2}`$.**
!!!!
!!!! L'erreur courante, si nous écrivons ou pensons $`I= A^2`$, est d'en déduite à juste titre que *$`\require{cancel}\xcancel{T_{12}=t_{12}^2}`$* ce qui est faux. De même, en pensant à la conservation de l'énergie qui implique que l'intensité réfléchie plus l', nous pourrions être amené à écrire trop rapidement *$`\xcancel{r_{12}^2+t_{12}^2=1}`$*, ce qui là encore est faux.
!!!!
!!!! Il n'y a *pas d'autre choix* que de *connaître les coefficients de réflexion et transmission en amplitude* **ET** *en intensité*. Ils ne se déduisent pas les uns des autres.
!!!!
!!!! C'est pour cela que *nous écrivons $`I\propto A^2`$ au lieu de $`\require{cancel}\xcancel{I= A^2}`$* comme dans certains ouvrages. En effet le coefficient de proportionnalité dépend du milieu de propagation. L'écriture $`I=A^2`$ ne doit être employée que si un seul milieu de propagation est considéré, mais il faut mieux ne pas l'utiliser car elle n'apporte rien par rapport à l'écriture $`I\propto A^2`$.
!!!!
!!!! La simple proportionalité entre $`I`$ et $`A`$ est largement suffisante pour décrire les phénomènes d'interférences  de même que pour les caractériser par leur contraste $`\mathcal{V} = \dfrac{I_{max}-I_{min}}{I_{max}+I_{min}}`$
!!!!

!! *Pour aller plus loin :*
!!
!! L'étude de la propagation des onde s électromagnétiques dans les milieux matériels nous apprend que dans un milieu d'indice de réfraction $`n`$, l'intensité définit $`I`$ comme la moyenne temporelle du vecteur de Poynting $`\langle\Pi\rangle`$, pour une onde électromagnétique plane, progressive et monochromatique polarisé rectilignement représentée par son champ électrique $`\vec{E}=E_0\cdot cos\,(\vec{k}.\vec{r}-\omega\,t)\,\vec{u}`$ (où $`\vec{u}`$ est le vecteur unitaire indiquant la direction de polarisation), s'écrit :
!!
!! $`I=\dfrac{c\,\epsilon_0\,E_0^2}{2\,n}`$
!!

#### Réflexion et transmission par une lame mince à faces parallèles.

Étudions la réflexion et la transmission de la lumière par une **lame mince à faces parallèles transparente** *d'indice de réfraction $`n_2`$*,  d'*épaisseur $`e`$* et localisée *dans un milieu d'indice de réfraction $`n_1`$*.


![interferences-thin-blade-reflexion-transmission-amplitude_L1200.jpg](interferences-thin-blade-reflexion-transmission-amplitude_L1200.jpg)
Pour ne nous intéresser qu'aux facteurs d'atténuation dus à la réflexion ou la transmission à travers la lame, les expressions indiquées pour les amplitudes réflechies $`A_{ref\,n}`$ et transmises $`A_{ref\,n}`$ sont données pour un déphasage $`\phi=4\pi`$ entre deux faisceaux réfléchis comme entre deux faisceaux transmis. Voir le texte de l'étude pour le cas général qui tient compte du déphasage géométrique de chaque faisceau par rapport au faisceau incident d'amplitude $`A`$. L'angle d'incidence $`\theta_{inc}`$ comme les angles induits $`\theta_{ref}`$ et $`\theta_{trans}`$ sont exagérés sur le schéma pour faciliter la visualisation. 

<!--=== figure à refaire===-->

! *Remarque :*
!
! Pour l'étude de la réflexion et de la transmission à travers une telle lame, *la lumière rencontre deux dioptres*, du *milieu 1 vers le milieu 2* et du *milieu 2 vers le milieu 1*. C'est le moment de remarquer que :
! * $`r_{12}=-\,r_{21}`$ 
! * $`T=T_{12}=T_{21}`$ n'est pas égal à $`\xcancel{T=t_{12}^2}`$ ou $`\xcancel{T=t_{21}^2}`$, mais nous avons l'égalité
! 
! *$`T`$*$`=\dfrac{4\,n_1^2}{(n_1 + n_2)^2}`$*$`=t_{12}\cdot t_{21}`$*,<br>
!
! et ce *terme $`t_{12}\cdot t_{21}`$* est *important* : il intervient dans l'amplitude de tous les rayons réflechis (hors la première réflexion directe) $`A_{ref\,1},\;,A_{ref\,2}`$... et dans l'amplitude de tous les rayons transmis à travers la lame $`A_{trans\,0},\;,A_{trans\,1}\;,A_{trans\,2}`$...
!


##### La lame faiblement réfléchissante est éclairée en lumière monochromatique.

Si le **coefficient de réflexion** (en amplitude ou en intensité) est suffisamment **faible** alors *seuls les deux premiers faisceaux* réfléchis ou transmis *contribuent aux figures d'interférences* observées dans chaque cas. Ce cas est facile à réaliser, avec une simple lame de verre.

!!! *Exemple :*
!!!
!!! Considérons une *simple lame de verre* d'indice *$`n_{verre}\simeq 1,5`$* placée *dans l'air ($`n_{air}=1)`$* pour réutiliser les calculs de l'exemple précédent.
!!!
!!! Nous avions déjà calculé $`r_{12}=-\,0,2`$, $`R=4\%`$ et $`T=96\%`$
!!!
!!! Lorsque le déphasage entre deux faisceaux réfléchis ou eux faisceaux transmis est égal à $`2\pi`$ et donc qu'ils interfèrent constructivement, le calcul des rapports d'amplitude $`A_{ref\,1}\,/\,A_{ref\,0}`$ , $`A_{ref\,2}\,/\,A_{ref\,1}`$  et $`A_{trans\,1}\,/\,A_{trans\,0}`$ donne :
!!!
!!! $`\dfrac{A_{ref\,1}}{A_{ref\,0}}=\dfrac{A\cdot r_{21}\cdot t_{12}\cdot t_{21}}{A\cdot r_{12}}`$$`=t_{12}\cdot t_{21}=96\%`$
!!! 
!!! $`\dfrac{A_{ref\,2}}{A_{ref\,1}}=\dfrac{A\cdot r_{21}^3\cdot t_{12}\cdot t_{21}}{A\cdot r_{21}\cdot t_{12}\cdot t_{21}}`$$`=r_{21}^2=r_{12}^2=4\%`$
!!!
!!! $`\dfrac{A_{trans\,1}}{A_{trans\,0}}=\dfrac{A\cdot r_{21}^2\cdot t_{12}\cdot t_{21}}{A\cdot t_{12}\cdot t_{21}}`$$`=r_{21}^2=r_{12}^2=4\%`$
!!!

* Les **deux premiers faisceaux réfléchis** sont d'*amplitudes quasi-égales* car ces deux faisceaux subissent chacun une réflexion (terme en $`r_{12}`$ pour l'un et en $`r_{21}=-r_{12}`$ pour l'autre. Leur variation d'amplitude vient simplement du terme $`t_{12}\,t_{21}`$ qui est alors proche de l'unité (_si $`R<<1`$ alors $`T=1-R\simeq 1`$_). Les faisceaux suivants ont des amplitudes beaucoup plus faibles (termes en $`r_{21}^3,\,r_{21}^5,\,.. .`$) et leur contribition aux franges d'interférence ne sera pas visible. Les **interférences observées en réflexion** sont donc principalement *créées par ces deux premiers faisceaux* et nous nous limiterons à ces deux premiers faisceaux pour le calcul.  Elles sont *fortement contrastées*  car les deux faisceaux qui interfèrent ont des amplitudes proches.

* Le **deuxième faisceau transmis** a une *amplitude très faible* par rapport au premier, en effet le rapport de leurs intensités est $`r_{12}^2`$. Les amplitudes des faisceaux suivants décroisssent fortement par le même facteur, et donc ces faisceaux pourront être négligés dans le calcul des **interférences observées en transmission**. Par contre, même si leurs amplitudes sont très différentes, il est essentiel de *tenir compte des deux premiers faisceaux* pour la prévision ou l'explication des interférences (_il faut au moins deux ondes cohérentes pour observer des interférences_). Le **contraste des franges** sera *très faible*, très probablement l'oeil n'observera qu'un éclairement homogène lorsqu'il regardera à travers la lame.

Ainsi, pour ce cas d'une **lame faiblement réfléchissante**, nous pouvons nous limiter aux *deux premiers faisceaux pour le calcul des interférences* en réflexion ou en transmission.

La **méthode** est toujours la même. Calculer la *différence de chemin optique* entre deux faisceaux successifs, en déduire le *déphasage* qui dépend de la longeur d'onde, *sommer les amplitudes* et en *déduire l'intensité*.
<!--====rajouter dès que c'est prêt==============
et analyser la figure d'interférence
======================================-->

*Calcul de la différence de chemin optique*

!!!! *Attention :*
!!!!
!!!! *Dès qu'il y a réflexion, si le coefficient de réflexion en amplitude est négatif* (cela dépend du signe de $`n_1-n_2`$), alors cela implique que signifie que le champ électrique change de sens lors de la réflexion à l'interface, et donc qu'une différence de chemin optique *supplémentaire* que nous nommons *différence de chemin optique de réflexion* et notons *$`\delta_{ref}=\lambda/2`$* doit être introduite, conduisant au *déphasage supplémentaire de réflexion $`\phi_{ref}=\pi`$*.
!!!!
!!!! Nous distinguons donc *différence de chemin optique géométrique $`\delta_{geo}`$*, la différence de chemin optique *classique* due à des longueurs de trajet différents effectuées dans des milieux qui peuvent avoir des indices de réfraction différents, de la différence de chemin optique  $`\delta_{ref}`$.
!!!!
!!!! La *différence de chemin optique totale $`\delta`$* à prendre en compte est 
!!!!
!!!! *$`\delta=\delta_{géo}+\delta_{ref}`$*
!!!!

Calculons la **différence de chemin optique géométrique**. Bien sûr la configuration est différente selon que nous étudions les interférencess en réflexion ou en transmission, mais en terme de calcul dans ce cas précis le résultat est identique et nous pouvons généraliser ce calcul. 

![optical-path-difference-thin-blade-reflexion-transmission-amplitude_L1200.jpg](optical-path-difference-thin-blade-reflexion-transmission-amplitude_L1200.jpg)

Le faisceau incident $`A`$ arrive au point $`U`$, point à partir duquel son chemin comme son amplitude se divisent en deux. Regardons les interférences créées à l'infini (_ou sur un écran situé dans le plan focal image d'une lentille convergente, où sur la rétine de l'oeil située dans le plan focal image du cristallin (l'oeil n'accommode alors pas, voir "optique des rayons"_)) dans la direction des faisceaux réfléchis. 

Les distances parcourues d'une part entre le point $` X`$ et l'infini pour le faisceau ($`A_{ref\,0}`$) d'amplitude $`A_{ref\,0}`$, et d'autre part entre le point $`W`$ et l'infini pour le faisceau ($`A_{ref\,1}`$) sont égales. La différence de chemin optique "géométrique" entre ces deux faisceaux est la différence de chemin optique $`\delta_{XW}`$ entre les points $`X`$ et $`W`$. Le **faisceau ($`A_{ref\,1}`$)**, *par rapport au faisceau ($`A_{ref\,1}`$)*, parcours **en plus** une **distance  $`UV + VW`$ dans le milieu d'indice $`n_2`$**, et **en moins** la **distance $`UX`$ dans le milieu d'indice $`n_1`$**. Ainsi :

**$`\delta_{géo}=\delta_{XW}=\delta_{UW}-\delta_{UX}`$**

$`\delta_{UW}=\delta_{UV}+\delta_{VW}=\dfrac{2\,n_2\,e}{cos\,\theta_2}`$ 

$`\delta_{UX}=n_1\cdot UW\cdot sin\,\theta_{inc}=n_1\cdot (UH+HW)\cdot sin\,\theta_{inc}`$
$`\;=2\,n_1\cdot UH\cdot sin\,\theta_{inc}`$
$`\;= 2\,n_1\cdot e\cdot tg \,\theta_2\cdot sin\,\theta_{inc}`$

La relation de Snell-Descartes $`n_1\cdot sin\,\theta_{inc} = n_2\cdot sin\,\theta_2`$ permet de réexprimer la relation précédente uniquement en fonction de l'angle $`\theta_2`$ 

$`\delta_{UX}=2\,n_1\cdot tg \,\theta_2\cdot \dfrac{n_2}{n_1}\cdot sin \,\theta_2`$
$`=2\,n_2\cdot tg \,\theta_2\cdot sin \,\theta_2`$
$`=2\,n_2\cdot \dfrac{sin^2 \,\theta_2}{cos \,\theta_2} \,\theta_2 `$

d'où

$`\delta_{géo}=\delta_{XW}=\delta_{UW}-\delta_{UX}`$
$`=\dfrac{2\,n_2\,e}{cos\,\theta_2}\;-\;\dfrac{2\,n_2\cdot sin^2 \,\theta_2}{cos \,\theta_2}`$ 
$`=2\,n_2\,e\cdot \dfrac{1-sin^2 \,\theta_2}{cos\,\theta_2}`$ 
$`=2\,n_2\,e\cdot \dfrac{cos^2 \,\theta_2}{cos\,\theta_2}`$ 

pour obtenir le **résultat final**

**$`\delta_{géo}=2\,n_2\,e\cdot cos\,\theta_2`$**

!!!! *Attention :*
!!!!
!!!! Pour les *lames minces à faces parallèles*, cette différence de marche géométrique entre 2 faisceaux successifs a :
!!!! * une *expression très simple : $`\delta_{géo}=2\,n_2\,e\cdot cos\,\theta_2`$*
!!!! * une expression trompeuse, parce qu'elle se rapproche visuellement et cognitivement parlant de l'expression $`\delta_{UW}=\dfrac{2\,n_2\,e}{cos\,\theta_2}`$
!!!!
!!!! Sans avoir ce point d'omportance en mémoire, le risque est grand que vous vous soouveniez d'une expression très simple en $`cos\,\theta_2`$, et en regardant trop rapidement la figure que nous n'en déduisiez érronément :
!!!!
!!!!  $`\xcancel{\delta_{géo}=\dfrac{2\,n_2\,e}{cos\,\theta_2}}`$

! *Important :*
!
!Le même calcul s'applique quelque-soit le couple de faisceaux successifs réfléchis ou transmis. Dans le cas d'une *lame mince à faces parallèles*, la *différence de chemin optique géométrique* est *constante* et s'exprime :
!
! *$`\delta_{géo}=2\,n_2\,e\cdot cos\,\theta_2`$*

*Calcul du déphasage*

* **Interférences en réflexion** : le premier terme est en $`r_{12}`$ et le $`r_{21}`$. Comme $`r_{21}=-r_{12}`$, il doit apparaître au final une *différence de marche de réflexion $`\delta_{ref}=\lambda\, / \,2`$* qui se rajoute à la différence de chemin optique géométrique $`\delta_{géo}`$, <br>
$`\delta=\delta_{géo}+\delta_{ref}=2\,n_2\,e\cdot cos\,\theta_2\;+\;\dfrac{\lambda}{2}`$
<br>
La différence de phase entre deux rayons successifs est donc au final<br>
**$`\phi=\dfrac{2\,\pi\,\delta}{\lambda}`$**
$`\,=\dfrac{2\,\pi\,(\delta_{géo}+\delta_{ref})}{\lambda}`$
**$`\,=\dfrac{4\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}+\pi`$**
$`=\phi_{géo}+\phi_{ref}`$

* **Interférences en transmission** : le rapport d'amplitude entre deux faisceaux successifs est $`r_{21}^2`$, donc quelque-soit le signe de $`r_{21}`$ il n'y aura pas de différence de marche et donc pas de déphasage de réflexion. Nous avons simplement :<br>
**$`\phi=\dfrac{2\,\pi\,\delta}{\lambda}`$**
$`\,=\dfrac{2\,\pi\,\delta_{géo}}{\lambda}`$
**$`=\dfrac{4\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}`$**
$`=\phi_{géo}`$

*Calcul de l'amplitude totale*

* **Interférences en réflexion** : rappel, on se limite aux *deux premiers faisceaux*.<br>
<br>
$`\underline{A}_{\,tot}=A\cdot r_{12} + A \cdot r_{21} \cdot t_{12} \cdot t_{21} \cdot e^{\displaystyle\,i\,\phi_{géo}}`$<br>
<br>
Comme $`r_{21}=-1\cdot r_{12}=e^{\,i\,\pi}\cdot r_{12}`$<br>
<br>
$`\underline{A}_{\,tot}=A\cdot r_{12}\cdot`$
$`\;\left( 1 + e^{\,i\,\pi}\cdot t_{12} \cdot t_{21} \cdot e^{\displaystyle\,i\,(\phi_{géo}+\phi_{ref})}\right)`$
$`\;=A\cdot r_{12}\cdot \left( 1 + \cdot t_{12} \cdot t_{21} \cdot e^{\displaystyle\,i\,(\phi_{géo}+\pi)}\right)`$
$`\;=A\cdot r_{12}\cdot \left( 1 + \cdot t_{12} \cdot t_{21} \cdot e^{\displaystyle\,i\,(\phi_{géo}+\phi_{ref})}\right)`$
<br>
<br> nous voyons bien qu'*au final* le déphasage des deux ondes est *$`\phi=\phi_{géo}+\phi_{ref}`$*.<br>
<br>
Comme $`T=t_{12}\cdot t_{12}\simeq 1`$, nous faisons l'**approximation $`T=t_{12}=t_{12}=1`$**.<br>
<br>
**$`\underline{A}_{\,tot}=A\cdot r_{12}\cdot \left( 1 +e^{\displaystyle\,i(\phi_{géo}+\phi_{ref})}\right)`$**
$`=\,A\cdot r_{12}\cdot \left( 1 +e^{\displaystyle\,i \left( \dfrac{\,4\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}+\pi \right)} \right)`$

!!!! *Attention :* 
!!!!
!!!! Si dans le calcul de l'amplitude puis de l'intensité final n'est considéré que la valeur absolue $`r=|r_{12}|=|r_{21}|`$ du coefficient de réflexion en amplitude, alors la différence de marche et le déphasage de réflection n'apparaitront pas naturellement dans les calculs et devront être rajoutés.

! *Remarque :*
!
! Si nous ne remarquons pas que $`-1=e^{\,i\,\pi}`$, cela n'est bien sûr pas grave. Il suffit d'écrire normalement 
!
! $`\underline{A}_{\,tot}=A\cdot r_{12}\cdot \left( 1 -\,e^{\displaystyle\,i\phi_{géo}}\right)`$ 
!
! au lieu de 
!
! $`\underline{A}_{\,tot}=A\cdot r_{12}\cdot \left( 1 +e^{\displaystyle\,i(\phi_{géo}+\phi_{ref})}\right)`$, 
!
! et de poursuivre les calculs. Les résultats finaux seront bien sûr identiques.

* **Interférences en transmission** : on se limite aux *deux premiers faisceaux*.<br>
<br>
$`\underline{A}_{\,tot}=A\cdot t_{12}\cdot t_{21} `$$`\;+ A \cdot r_{12}^2 \cdot t_{12} \cdot t_{21} \cdot e^{\displaystyle\,i\,\phi_{géo}}`$<br>
<br>
**$`\underline{A}_{\,tot}=A\cdot  t_{12}\cdot t_{21}\cdot \left( 1+ r_{12}^2\cdot e^{\displaystyle\,i\,\phi_{géo}}\right)`$**<br>
<br>
avec l'**approximation $`T=t_{12}=t_{12}=1`$** et en se souvenant que $`r_{12}^2=R`$<br>
<br>
**$`\underline{A}_{\,tot}=A \cdot \left( 1+ R \cdot e^{\displaystyle\,i\,\phi_{géo}}\right)`$**
$`\;=A \cdot \left( 1 + R\cdot e^{\displaystyle\,i \left(\dfrac{\,4\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}\right)}\right)`$

*Calcul de l'intensité*

* **Interférences en réflexion** : <br>
<br>
$`I \propto \underline{A}_{\,tot}\,\underline{A}_{\,tot}^*`$<br>
<br>
$`I \propto A^2\cdot r_{12}^2\cdot \left( 1 +e^{\displaystyle\,i\,(\phi_{géo}+\phi_{ref})}\right)`$
$`\;\cdot\left( 1 +e^{\displaystyle\,-\,i(\phi_{géo}+\phi_{ref})}\right)`$<br>
<br>
$`I \propto A^2\cdot r_{12}^2\cdot \left( 1 +e^{\displaystyle\,i\,(\phi_{géo}+\pi)}\right)`$
$`\;\cdot\left( 1 +e^{\displaystyle\,-\,i(\phi_{géo}+\pi)}\right)`$<br>
<br>
$`I \propto A^2\cdot r_{12}^2\cdot \left( 1 -e^{\displaystyle\,i\,\phi_{géo}}\right)`$
$`\;\cdot \left( 1 -e^{\displaystyle\,-\,i\,\phi_{géo}}\right)`$<br>
<br>
$`I \propto A^2\cdot R\cdot \left( 2 - e^{\displaystyle\,i\,\phi_{géo}}+ e^{\displaystyle\,-\,i\,\phi_{géo}}\right)`$<br>
<br>
$`I \propto 2\,A^2\cdot R\cdot \left( 1 -cos\,\phi_{géo}\right)`$<br>
<br>
soit au final<br>
<br>
**$`I \propto 2\,A^2\cdot R\cdot \sin^2\,\dfrac{\phi_{géo}}{2}`$**
$`\;=\,A^2\cdot R \cdot sin^2 \left( \dfrac{\,2\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}\right)`$<br>
<br>
Comme prévisible, le **contraste des franges sera très grand**, on a ici dans l'approximation considérée $`T=t_{12}=t_{12}=1`$<br>
<br>
**$`\mathcal{V} = \dfrac{I_{max}-I_{min}}{I_{max}+I_{min}}`$**$`\;=\dfrac{1-0}{1-0}`$**$`\;=1`$**

<!--==== à mettre au point et expliquer mieux là========
Les franges d'interférence par réflexion sont à centre noir. En effet lorsque $\delta=0`$ et $p=0`$, alors $'I=0`$
==========================================-->

* **Interférences en transmission** : <br>
<br>
$`I \propto \underline{A}_{\,tot}\,\underline{A}_{\,tot}^*`$<br>
<br>
$`I \propto A^2 \cdot \left( 1+ R \cdot e^{\displaystyle\,i\,\phi_{géo}}\right)`$
$`\;\cdot  \left( 1+ R \cdot e^{\displaystyle\,-i\,\phi_{géo}}\right)`$<br>
<br>
$`I \propto A^2 \cdot \left[ 1+ R^2 + R \cdot \left( e^{\displaystyle\,i\,\phi_{géo}}+ e^{\displaystyle\,\,i\,\phi_{géo}} \right)\right]`$<br>
<br>
$`I \propto A^2 \cdot \left[ 1+ R^2 + 2\,R\,cos\, \phi_{géo}\right]`$<br>
<br>
$`I \propto A^2 \cdot \left[ 1-2\,R+ R^2 + \left( 2\,R+2\,R\,cos\, \phi_{géo}\right)\right]`$<br>
<br>
$`I \propto A^2 \cdot \left[\left( 1-R\right)^2+ 2\,R\cdot\left( 1+\,cos\, \phi_{géo}\right)\right]`$<br>
<br>
**$`I \propto A^2 \cdot \left[\left( 1-R\right)^2+ 4\,R\cdot cos^2\,\dfrac{\phi_{géo}}{2}\right]`$**
$`=A^2 \cdot \left[\left( 1-R\right)^2+ 4\,R\cdot cos^2\, \left( \dfrac{\,2\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}\right)\right]`$<br>
<br>
Si $`R<<1`$, le **contraste des franges sera très faible**:<br>
<br>
**$`\mathcal{V} = \dfrac{I_{max}-I_{min}}{I_{max}+I_{min}}`$**
$`=\;\dfrac{( 1+R)^2-( 1-R)^2}{( 1+R)^2+( 1-R)^2}`$


!!! *Exemple :*
!!!
!!! En reprenant la *lame de verre* d'indice de réfraction *$`n_{verre}\simeq 1,5`$* placée *dans l'air ($`n_{air}=1`$*, ce qui donne *$`R=0,04`$* :
!!!!
!!!! Les *franges observées en réflexion* ont un *contraste* très proche du *maximum ($`\simeq1`$)*.
!!!
!!! Les *franges observées en transmission* ont un *contraste très faible* et en pratique ne seront pas observées.
!!!
!!! $`( 1+R)^2=(1+0.04)^2=1,082`$ et $`( 1-R)^2=(1-0.04)^2=0,922`$
!!!
!!! *$`\mathcal{V}`$*$`\;=\dfrac{( 1+R)^2-( 1-R)^2}{( 1+R)^2+( 1-R)^2}=\dfrac{1,082-0,922}{(1,082+0,922)}`$
$`\;=\dfrac{0,160}{(2,004)}\simeq0;08`$

![lame-mince-faces-paralleles_nb_L600.jpg](lame-mince-faces-paralleles_nb_L600.jpg)

<!--===A termminer, reste pas grand chose pour une première mouture===

*Analyse de la figure d'interférence en réflexion*

* **Interférences en réflexion** : <br>

La lumière incidente est monochromatique de longueur d'onde (dans le vide) $`\lambda`$.
La lame a une épaisseur $`e`$ et un indice de réfraction $`n_2`$ constants, et est placé dans un milieu d'indice de réfraction $`n_1`$ constant.

L'intensiié $`I \propto 2\,A^2\cdot R\cdot \sin^2\,\dfrac{\phi_{géo}}{2}`$ varie périodiquement en fonction du déphasage, et donc de l'angle $\theta_2`$ de réfraction dans la lame, donc de l'angle des rayons incidents grâce à la loi de Snell-Descartes.

L'intensité $`\;=\,A^2\cdot R \cdot sin^2 \left( \dfrac{\,2\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}\right)`$ atteint sa valeur maximum lorsque $`\dfrac{\,2\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}=\dfrac{\pi}{2}+k\,\pi
$`\;=\,A^2\cdot R \cdot sin^2 \left( \dfrac{\,2\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}\right)`$<br>

<!--===A termminer, reste pas grand chose pour une première mouture===

Lé différence de marche 
**$`I \propto 2\,A^2\cdot R\cdot \sin^2\,\dfrac{\phi_{géo}}{2}`$**
$`\;=\,A^2\cdot R \cdot sin^2 \left( \dfrac{\,2\,\pi\,n_2\,e\cdot cos\,\theta_2}{\lambda}\right)`$<br>


* **Interférences en transmission** : <br>

===================-->





##### Transmission à travers une lame semi-réfléchissante, éclairée en lumière monochromatique.

Si le coefficient de réflexion (en amplitude ou en intensité) est élevé, alors le facteur de proportionnalité en amplitude entre deux faisceaux successifs, $`r_{21}^2`$ est beaucoup plus grand (tout en restant inférieur à 1) que dans le cas précédent de la lame faiblement réfléchissante. Dès lors nous ne pouvoir plus nous limiter aux deux premiers faisceaux transmis pour calculer les interférences, nous devons tenir compte de la série des rayons transmis.

La **différence de chemin optique** comme le **déphasage** entre deux faisceaux successifs $`A_{trans\,n-1}`$ et $`A_{trans\,n}`$ a déjà été fait avant.  Ils sont *constants* (ils ne dépendent pas de n) et d'expressions :

 **$`\delta=2\,n_2\,e\,cos\,\theta_2`$**
 
 **$`\phi=\dfrac{2\,\pi\,\delta}{\lambda}=\dfrac{4\,\pi\,\,n_2\,e\,cos\,\theta_2}{\lambda}`$**
 
*Calcul de l'amplitude totale*

Les amplitudes des rayons transmis successifs, pour un rayon premier rayon transmis d'amplitude $`A_{trans\,0}`$ sont, en se souvenant que $`r_{21}^2=R`$ :

**$`\underline{A}_{\,trans\,1}`$**$`=r_{21}^2\cdot e^{\,i\,\phi}\cdot A_{trans\,0}`$**$`\;=R\cdot e^{\,i\,\phi}\cdot \underline{A}_{\,trans\,0}`$**,<br>
**$`\underline{A}_{\,trans\,2}`$**$`=r_{21}^4\cdot  e^{\,2\,i\,\phi}\cdot A_{trans\,0}`$**$`\;=R^2\cdot e^{\,2\,i\,\phi}\cdot \underline{A}_{\,trans\,0}`$**,<br>
...<br>
**$`\underline{A}_{\,trans\,N}`$**$`=r_{21}^{2N}\cdot e^{\,N\,i\,\phi}\cdot A_{trans\,0}`$**$`\;=R^{N}\cdot e^{\,N\,i\,\phi} \cdot \underline{A}_{\,trans\,0}`$**


Ainsi entre deux faisceaux successifs $`A_{trans\,n-1}`$ et $`A_{trans\,n}`$, l'amplitude décroit d'un facteur complexe $`r_{21}^2\;e^{\,i\,\phi}=R\;e^{\,i\,\phi}`$ constant. L'amplitude totale s'écrit :

$`\underline{A}_{\,tot}=\underline{A}_{\,trans\,0}\;\left(1+R\cdot e^{\,i\,\phi}+R^2`$
$`\;\cdot e^{\,2\,i\,\phi}+R^3\cdot e^{\,3\,i\,\phi}`$$`\;+...R^N\cdot e^{\,N\,i\,\phi}+...\right)`$

Les termes entre parenthèse forme une suite géométrique de raison $`R\,e^{\,i\,\phi}`$. la méthode de calcul de la somme $`S_N`$ des N premiers termes à été rappelée et utilisée précédemment dans ce chapitre. Nous avons donc :

$`\displaystyle\sum_{j=0}^N \underline{A}_{\,trans\,j}=\underline{A}_{\,trans\,0}\;\dfrac{1-R^{N+1}\,e^{\,(N+1)i\,\phi}}{1-R\,e^{\,i\,\phi}}`$

Le grande différence par rapport au cas de N ondes de même amplitude qui interfèrent, est que maintenant l'amplitude est modifiée par le facteur $`R\;e^{\,i\,\phi}`$ entre deux faisceaux successifs. Le module de $`R\;e^{\,i\,\phi}`$ est strictement inférieur à 1 car le coefficient de réflexion en intensité $`R`$ est inférioeur à 1, donc le module de $`R^{N+1}\;e^{\,(N+1)\,i\,\phi}`$ comme sa partie réelle tendent vers 0 quand N tend vers l'infini. Ainsi, si nous tenons compte de tous les termes jusqu'à l'infini, nous avons :

$`\displaystyle\lim_{N=0}^{\infty} \sum_{j=0}^N \underline{A}_{\,trans\,j}`$
$`\;=\displaystyle \lim_{N=0}^{\infty}\;\underline{A}_{\,trans\,0}\;\dfrac{1-R^{N+1}\,e^{\,(N+1)i\,\phi}}{1-R\,e^{\,i\,\phi}}`$
$`\;=\underline{A}_{\,trans\,0}\cdot\dfrac{1}{1-R\,e^{\,i\,\phi}}`$

d'où

$`\underline{A}_{\,tot}=\underline{A}_{\,trans\,0}\cdot\dfrac{1}{1-R\,e^{\,i\,\phi}}`$
$`\;=\underline{A}_{\,trans\,0}\cdot\dfrac{1}{(1-R\,cos\,\phi)+i\,R\,sin\,\phi}`$

Réécrivons l'amplitude totale sous une forme plus propice aux calculs ultérieurs, soit avec un dénominateur réel :

$`\underline{A}_{\,tot}=\underline{A}_{\,trans\,0}`$
$`\cdot\dfrac{(1-R\,cos\,\phi)-i\,R\,sin\,\phi}{[(1-R\,cos\,\phi)+i\,R\,sin\,\phi]\cdot [(1-R\,cos\,\phi)-i\,R\,sin\,\phi]}`$

$`\underline{A}_{\,tot}=\underline{A}_{\,trans\,0}`$
$`\cdot\dfrac{(1-R\,cos\,\phi)-i\,R\,sin\,\phi}{(1-R\,cos\,\phi)^2 + R^2\,sin^2\,\phi}`$

*Calcul de l'intensité*

$`I\propto\underline{A}_{\,tot}\,\underline{A}_{\,tot}^*=|\underline{A}_{tot}|^2`$

$`I\propto\underline{A}_{\,trans\,0}\;\underline{A}_{\,trans\,0}^*`$
$`\;\dfrac{[(1-R\,cos\,\phi)+i\,R\,sin\,\phi]\cdot [(1-R\,cos\,\phi)-i\,R\,sin\,\phi]}{[(1-R\,cos\,\phi)^2 + R^2\,sin^2\,\phi]^2}`$

Comme $`\underline{A}_{\,trans\,0}\;\underline{A}_{\,trans\,0}^*`$ est un nombre réel, nous pouvons le faire passer dans le coefficient de proportionnalité :

$`I\propto\dfrac{(1-R\,cos\,\phi)^2 + R^2\,sin^2\,\phi}{[(1-R\,cos\,\phi)^2 + R^2\,sin^2\,\phi]^2}`$

$`I\propto\dfrac{1}{(1-R\,cos\,\phi)^2 + R^2\,sin^2\,\phi}`$

$`I\propto\dfrac{1}{1-2R\,cos\,\phi+R^2\,cos^2\,\phi + R^2\,sin^2\,\phi}`$

$`I\propto\dfrac{1}{1-2R\,cos\,\phi+R^2}`$

$`I\propto\dfrac{1}{1-2R+2R-2R\,cos\,\phi+R^2}`$

$`I\propto\dfrac{1}{(1-2R+R^2)+2R\;(1-cos\,\phi)}`$

$`I\propto\dfrac{1}{(1-R)^2+2R\;(2\,sin^2\,\dfrac{\phi}{2})}`$

En divisant numérateur et dénominateur par la même quantité $`1-R^2`$, nous obtenons :

$`I\propto\dfrac{1}{1-R^2}\cdot\dfrac{1}{1+\dfrac{4R}{(1-R)^2}\cdot sin^2\,\dfrac{\phi}{2}}`$

En faisant passer $`(1-R^2)^{-1}`$ dans le coefficient de proportionnalité, l'**intensité transmise** sous la forme d'une fonction simple :

**$`I\propto\dfrac{1}{1+m\cdot sin^2\,\dfrac{\phi}{2}}`$**, avec **$m=\dfrac{4R}{(1-R)^2}`$**

Pour une lame à face parallèle donnée d'indice $`n_2`$ et d'épaisseur $`e`$, de coefficient de réflexion en intensité $`R`$ donné, l'intensité transmise est alors simplement fonction de l'angle de réfraction $`\theta_{2}`$ et de la longueur d'onde $`\lambda`$ (dans le vide) du faisceau parallèle incident sur la lame.

**$`I\propto\dfrac{1}{1+m\cdot sin^2\,\dfrac{\phi}{2}}`$**, avec **$`\phi=\dfrac{2\pi\delta}{\lambda}=\dfrac{2\pi}{\lambda}\;(1\,n_2\,e\,cos\,\theta_2)`$**

Eclairons la lame avec un faisceau parallèle de lumière blanche sous incidence normale ($`\theta_{inc}=0 \;\Longrightarrow\; \theta_2=0`$).

Nous avons alors $`\phi=\dfrac{2\pi\delta}{\lambda}=\dfrac{2\pi}{\lambda}\;(2\,n_2\,e)`$

Étudions l'*intensité* donné par la *fonction $\dfrac{1}{1+m\cdot sin^2\,\dfrac{\phi}{2}}`$*.

* Un **maximum d'intensité  $`I_{max}`$** est réalisé lorsque $`sin^2\,\dfrac{\phi}{2}=0`$, soit :<br>
<br>
$` I= I_{max}\quad\Longleftrightarrow\quad sin^2\,\dfrac{\phi}{2}=0`$
**$`\quad\Longleftrightarrow\quad \phi=2\,p\,\pi\quad\Longleftrightarrow\quad \delta=p\,\lambda`$**.<br>
<br>
Nous observons une *série de maxima d'intensités égales*, un *maximum est identifié par son* **ordre** qui est la valeur de **k**.

* Un **minimum d'intensité $`I_{min}`$** est réalisé lorsque $`sin^2\,\dfrac{\phi}{2}=1`$, soit :<br>
<br>
$` I= I_{min}\quad\Longleftrightarrow\quad sin^2\,\dfrac{\phi}{2}=1`$
**$`\quad\Longleftrightarrow\quad \phi=\pi + 2\,p\,\pi`$$`\quad\Longleftrightarrow\quad \delta=\dfrac{\lambda}{2}+p\,\lambda`$**<br>
<br>
Pour une lame semi-réflechissante, l'*intensité minimale $`I_{min}`$ est très faible* comparée à l'intensité maximale $`I_{max}`$.

![function-dichroic-filter-I-phi_L1200.jpg](function-dichroic-filter-I-phi_L1200.jpg)

!!! *Exemple :*  $`R\sim 0,8`$ donne $`T\sim 0,2`$ , $`m=80`$ et $`I_{min}\sim\dfrac{I_{max}}{80}`$



!! *Pour aller plus loin* :
!!
!! Obtenir un coefficient de réflexion en intensité de valeur élevée, par exemple $`R=0,8`$ avec une lame diélectrique transparente d'indice $`n_2`$ plongée dans l'air ($`n_{air}=1`$, il faudrait que $`n_2\simeq 19`$, ce qui n'existe pas dans le domaine visible. Pour réaliser cela, on dépose sous vide des couches semi-refléchissantes iodentiques sur chacune des faces de la lame, pour atteindre la valeur $`R=0,8`$. 

*Largeur d'un maximum $`\Delta\phi`$ et coefficient de finesse F*.

La **largeur d'un maximum** est définie comme sa *largeur à mi-hauteur*.

L'intensité est proportionnelle à la fonction $`[1+m\cdot sin^2\,(\phi\,/\,2)]^{-1}`$. Posons ce coefficient de proportionnalité égal à l'unité. Nous avons maintenant $`I=[1+m\cdot sin^2\,(\phi\,/\,2)]^{-1}`$, ce qui donne une valeur d'intensité maximum $`I_{max}=1`$ réalisée pour un déphasage $`\phi=2\,p\,\pi\;,\;p\;`$ étant l'ordre du maximum.
 
 La demi-largeur $`\Delta\phi\,/\,2`$ du maximum correspond à la valeur de déphasage $`\phi=2\,p\,\pi\,+\,(\Delta\phi/2)`$ pour laquelle $` I=I_{max}\,/\,2=1/2`$, soit :
 
$`I=\dfrac{I_{max}}{2}=\dfrac{1}{2}`$
$`\quad \Longleftrightarrow \quad \dfrac{1}{2}=\dfrac{1}{1+m\cdot sin^2\,\left(\dfrac{2\,p\,\pi}{2}+\dfrac{\Delta\phi}{4}\right)}`$
$`\quad\Longleftrightarrow\quad m\cdot sin^2\,\left(2\,p\,\pi+\dfrac{\Delta\phi}{4}\right)=1`$
$`\quad\Longleftrightarrow\quad sin^2\,\left(2\,p\,\pi+\dfrac{\Delta\phi}{4}\right)=\dfrac{1}{m}`$
$`\quad\Longleftrightarrow\quad sin^2\,\left(\dfrac{\Delta\phi}{4}\right)=\dfrac{1}{m}`$

Comme $`m`$ est grand, le facteur $`1/m`$ est petit et donc nous pouvons écrire :

$`sin^2\,\left(\dfrac{\Delta\phi}{4}\right)=\left(\dfrac{1}{m}\simeq\dfrac{\Delta\phi}{4}\right)^2`$
 
 ce qui conduit à :
 
 $`I=\dfrac{I_{max}}{2}\quad\Longleftrightarrow\quad \Delta\phi^2=\dfrac{4^2}{m}`$
 $`\quad\Longleftrightarrow\quad \Delta\phi=\dfrac{4}{\sqrt{m}}`$
 
 La **largeur d'un maximum** est **$`\Delta\phi=\dfrac{4}{\sqrt{m}}`$**
 
 Le **coefficient de finesse** est défini par **$`F=\dfrac{2\pi}{\Delta\phi}=\dfrac{\pi\,\sqrt{m}}{2}`$**. 
 
 Comme $`\phi=2\pi`$ est le déphasage entre 2 maximum consécutifs, le coefficient de finesse $`F`$ *indique que* la **largeur d'un maximum** est **$`F`$ fois plus petite que la distance entre 2 maxima**.
 
!!! *Exemple :* 
!!!
!!! Avec les valeurs de l'exemple précédent :
!!!
!!! $`R\sim 0,8`$ donne $`T\sim 0,2`$ , $`m=80`$ et $`I_{min}\sim\dfrac{I_{max}}{80}`$
!!!
!!! nous obtenons un *coefficient de finesse de 14* :
!!!
!!! $`F=\dfrac{\pi\,\sqrt{m}}{2}=\dfrac{3,14\,\sqrt{80}}{2}=14`$
!!!
!!! Les *maxima d'intensité sont les franges brillantes* de la figure d'interférence observée. $`F=14`$ signifie que *la largeur d'une frange est $`1/14`$ de l'interfrange*.

!! *Pour aller plus loin :*
!!
!! Une application utilisant ce principe est le *filtre interférentiel = filtre dichroïque*.
!!
!! *Éclairé en lumière blanche*, un filtre interférentiel ne *laisse passer* que la lumière située dans *un domaine très étroit de longueur d'onde*.
!!
!! 

![function-dichroic-filter-I-lambda_L1200.jpg](function-dichroic-filter-I-lambda_L1200.jpg)


