---
title: 'The optical path T'
---

#####Le chemin optique

Lorsque la lumière se déplace sur des trajectoires traversant des milieux d'indices réfraction différents, les différents temps de parcours ne sont pas égaux aux longueurs correspondantes multipliées par un nombre réel unique, indépendant des trajectoires. Cela reste vrai sur la trajectoire unique d'un rayon de lumière traversant plusieurs milieux : pour une même longueur considérée le long de la trajectoire, le temps de parcours pourra être différent selon la portion de trajectoire sur laquelle la longueur est prise. Je peux résumer cela d'une phrase :

<ins>Sur l'ensemble des cas,</ins><strong> le temps de parcours n'est pas proportionnel à la distance parcourue.</strong>

Or la grandeur physique importante associée à un parcours entre deux points de l'espace, pour savoir si la lumière choisira ce parcours plutôt q'un autre, sera le temps de parcours. Cependant lorsque je visualise mentalement une trajectoire, je vois une ligne à laquelle j'associe intuitivement une longueur. <ins>Comment travailler mathématiquement avec une grandeur physique homogène à une longueur, mais qui aurait les mêmes propriétés que le temps de parcours pour décrire la propagation de la lumière </ins>? Une telle grandeur a été définie en physique, et est grandement utilisée en optique géométrique, optique ondulatoire, électromagnétisme, et elle est nommée "<strong>chemin optique</strong> noté usuellement "<strong> $\delta_o$</strong>".

Le chemin optique $\delta_o$ d'un parcours donné $\Gamma_o$ entre deux points A et B de l'espace est <ins>homogène à une longueur</ins>. Son <strong>unité (S.I.)</strong> (son unité dans le Système International d'unités) est donc le "<ins>mètre</ins>".

Pour tout segment de droite pris entre deux points infiniment proche dans l'espace, son chemin optique infinitésimal (ou élémentaire) <strong>$\mathrm{d}\delta$</strong> est égal à sa <ins>longueur euclidienne $\mathrm{d}s$ multipliée par la valeur de l'indice de réfraction $n$</ins> moyennée sur le segment infinitésimal considéré :
<strong>$\mathrm{d}\delta\;=\;n\times \mathrm{d}s$</strong>

Le chemin optique $\delta$ d'un parcours donné $\Gamma_o$ entre deux point de l'espace est simplement la somme des chemins optiques infinitésimaux intégrés sur ce parcours :
<strong>$\delta = \int_{\Gamma_o}\mathrm{d}\delta= \int_{\Gamma_o}n\cdot \mathrm{d}s$</strong>

Quelques soient deux points donnés A et B de l'espace, et quelque soit le parcours considéré entre ces deux points, le <strong>chemin optique</strong> sera <ins>toujours égal au temps de parcours de la lumière sur ce parcours divisé par la vitesse de la lumière dans le vide $c$ </ins>qui est une constante universelle de la nature :
<strong>$\mathrm{d}\delta\;=\;\frac{ds}{c}$
$\delta = \int_{S_{AB}}n\cdot\mathrm{d}s\;=\;\int_{S_{AB}}\frac{c}{v}\cdot\mathrm{d}s$
$\hspace{1cm}= c\;\int_{S_{AB}}\frac{\mathrm{d}s}{v} =\;c\;\tau$</strong>


<br>
<ul class="exemple">Je peux maintenant considérer un rayon lumineux se propageant d'un point A à un point B, et lui imposer au cours de sa trajectoire entre A et B d'interagir avec un système optique. Je peux ensuite considérer l'ensemble des chemins possibles (ils sont en nombre infini en optique) entre A et B, et considérer une application f qui à chaque chemin de cet ensemble associe une grandeur physique particulière. En optique géométrique, les deux grandeurs physiques intéressantes sont le temps de parcours et le chemin optique. La question est :<br>
Le trajet réellement suivi par la lumière dans chaque cas correspond-t-il à un chemin défini par un point particulier de la fonction f ?. Les points particuliers qui vont m'intéresser en optique géométrique sont appelés en mathématiques les points stationnaires.</ul>
