---
title: 'Superficie refractaria esférica en aproximación paraxial.'
---

### Superficie refractaria esférica en aproximación paraxial.

#### Superficie refractiva

Una **superficie refractiva** es una *superficie pulida entre dos medios con diferentes índices de refracción*.

!!!! *ATENCIÓN* : <br>
!!!! De la misma manera que usamos en español la palabra "espejo" para calificar una "superficie reflectante", en francés se usa la palabra "dioptre" para calificar una "superficie refractante".
!!!! El término "dioptre" en inglés es la unidad de medida "dioptría" de la vergencia de un sistema óptico. En francés, la misma unidad de mesa se llama "dioptrie".
!!!! Así que ten en cuenta el siguiente esquema:
!!!!
!!!! superficie refractiva: *ES : superficie refractiva* , *FR : dioptre* , *EN : refracting surface*.<br>
!!!! _Una bola de cristal forma una superficie refractiva esférica: un "dioptre sphérique" en francés._
!!!!
!!!! unidad de medida: *ES: dioptría* , *FR: dioptrie* , *EN: dioptre*.<br>
!!!! _Mis lentes correctoras para ambos ojos son 4 dioptrías: "4 dioptries" en francés, y "4 dioptres" en inglés._

#### Superficie refractiva esférica.

#### Estudio analítico de la posición y forma de una imagen.

Una **superficie refractiva esférica** en óptica analítica paraxial se caracteriza por "tres cantidades físicas" :
* **$`n_{ini}`$** : *índice de refracción del medio inicial* (centro ubicado en el lado de la luz incidente).
* **$`n_{fin}`$** : *índice de refracción del medio final * (medio ubicado en el lado de la luz emergente, después de la refracción por la superficie refractiva).
* **$`\overline{SC}`$** : *distancia algebraica entre el __vértice S__* (punto de intersección de la superficie refractiva con su eje óptico, su eje de revolución.)* y el *_centro de curvatura_ C* de la superficie refractiva esférica.

! *IMPORTANTE*: El estudio analítico a continuación también se aplica para una superficie refractiva plana. Basta con señalar que una superficie refractiva plana es una superficie refractiva esférica cuyo radio de curvatura tiende hacia el infinito.

Considera un *punto objeto* **$`B_{obj}`$** cuya proyección ortogonal en el eje óptico da el  *punto objeto* **$`A_{obj}`$**. Si el punto del objeto está ubicado en el eje óptico, entonces $`B_{obj}=A_{obj}`$ y lo llamaremos punto objeto $`A_{obj}`$. El punto objeto $`B_{obj}`$ puede ser ambos **real** *y* **virtual**.

El **cálculo de la posición**del *punto imagen* **$`B_ {ima}`$**, *punto conjugado del punto objeto $`B_ {obj}`$* por superficie refractiva esférica, sucede en **dos pasos** :

1.  Uso la **relación de conjugación de la superficie refractiva esférica** para calcular la *posición del punto*  **$`A_ {ima}`$** , $`A_ {ima}`$ siendo la *proyección ortogonal en el eje óptico del punto de imagen * $`B_{ima}`$.

**$`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=\dfrac{n_{fin}-n_{ini}}{\overline{SC}}`$**

Para lograr esto *necesito conocer la _distancia algebraica_* **$`\overline{SA_{obj}}`$**, y el *cálculo de la _distancia algebraica _* **$`\overline{SA_{ima}}`$**  a lo largo del eje óptico *me da la posición del punto $`A_{ima}`$*.

2. Utilizo la **expresión de la "magnificación transversal" para una dioptría esférica** para calcular el *__valor algebraico__  de la magnificación transversal* **$` \overline{M_T}`$** *del segmento $`[A_ {obj } B_ {obj}]`$*, luego deduzco la *__longitud algebraica__*  **$`\overline {A_{ima}B_ {ima}}`$** del aumento $`[A_ {ima}B_ { ima}]`$, que es la distancia entre el punto imagen $`B_{ima}`$ y su proyección ortogonal en el eje óptico $`A_{ima}`$.

Por *definición :* **$`\overline{M_T}=\dfrac{\overline{A_{ima}B_{ima}}}{\overline{A_{obj}B_{obj}}}`$**.
Su *expresión para un superficie refractiva esférica* es : **$`\overline{M_T}=\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$**.

Conozco $`\overline{SA_{obj}}$, $n_{ini}$ and $n_{fin}$, calculé previamente $`\overline{SA_{ima}}$, entonces puedo determinar $`\overline{M_T}`$ y deducir $`\overline{A_{ima}B_{ima}}`$


! *IMPORTANTE* : La relación de conjugación y la expresión de la magnificación transversal para una superficie refractiva plana se obtienen fácilmente reescribiendo la relación de conjugación y la  expresión e la magnificación transversal para una superficie refractiva esférica en el límite de un radio de curvatura que tiende hacia el infinito :  $`|\overline{SC}|\longrightarrow\infty`$.<br> Cela donne *pour un dioptre plan :*
!
! * *relación de conjugación :*&nbsp;&nbsp; $`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=0`$.
!
! * *expresión de la magnificación transversal :*&nbsp;&nbsp; $`\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$ &nbsp;&nbsp; (no esta cambiada).
!
! Esto generaliza y completa tu dominio de superficie refractiva plana en comparación con lo que vio en caminos pedagogicos en llanura y colinas.

#### Etude graphique de la position et de la forme d'une image.



