---
title: Brainstorming to structure a theme "Electromagnetism"
published: true
routable: true
visible: false
lessons:
    - slug: brainstorming-123-electromagnetism
      order: 3
    - slug: brainstorming-234-electromagnetism
      order: 2
---

#### Brainstorming to structure a theme "Electromagnetism" : level 3

--------------------------------------

### Foreword

This step is important, because it will be the 
**first tree structure of the filesystems and subfiles in which the contributors will work**. 
This tree structure may evolve, but it is less agile than the educational contents
themselves. In themselves, the titles of the chapters and sub-chapters are less important.
They can be changed easily, they are not the structure.

#### Advice on how to structure this level 3

This is the **equivalent of the first or two first years in university**. There is a big jump 
with the previous level. But we are not limited to a number of hours or pages. 
We can make a quiet and controlled progression even within this level 3.

The high school is not homogeneous, there are pathways, specialties and options, 
and moreover the programs also vary according to the country and period. 
Some mathematical tools of level our N3 can be seen already in high school in some
countries. Conversely, it is possible that certain points of our level N2, are not 
seen in high school. **Think these levels 2 and 3 freely and without references in mind**.

Even inside a level, you have to be very progressive, we have the space for that.
The gap should not be too large from one level to another, so as not to demotivate
the students. 

##### The blocks

In this level 3, the **blocks** are important because they **allow to differentiate the students**. 
For example we can make an electrostatic block for students who wish to stop at this level 3
in electromagnetism. It can be a block with only direct calculations, and the notion of 
electric dipole. But without Gaussian theorems and the divergence operator, which will
be put in another block for students who have to prepare the mastery of Maxwell's equations
of electromagnetism at level 4.

Later we can associate a metadata in the file, to identify then blocks and offer 
specific pedagogical circuits according to the student's wishes.

So use the blocks to also **target different pre-specialties** within this level 3. 

#### To participate

The different proposals are numbered: they start with:
[BRST-EMG3-number]: Title <br>
_BRST-EMG3 for Brainstorming STructure ElectroMaGnétism level 3)_

To **add a proposition, create it** between 2 propositions, or in the following (following 
the logic of the proposition). To do this, start with: <br>
*a new [BRST-EMG3-number] + (three initials in brackets representing you) + Title*

To **react to an existing proposal**, add your comment after the others
starting with three initials in brackets representing you:
(CLM): previous comment
*(my initials): my comment*

_or send an email specifying:_
_the reference [BRST-EMG3-number], the my 3 initials and my comment_
_(+ a title if it's a new proposition)_ 

To **communicate my proposals**, either:
* directly on the GitLab m3p2 with your login/password: <br>
if you are not there already, go to https://gitlab.m3p2.com/brainstorming-123-electromagnetism <br>
or https://gitlab.m3p2.com/brainstorming-234-electromagnetism, <br>
and at the end of the page, in the green box click on "Edit this course".
* on the google drive m3p2 project in the document Brainstorming-1-electromagnetism.docx.
* or send an email to ... specifying: <br>
the reference [BRST-EMG1-number], then the 3 letters that identify me (my initials) and my comment
 (+ a title if it's a new proposition) _

The Gitlab will be kept up to date with your proposals, also translated into French and Spanish. <br>
_(This is not required, but if you can also make your contribution in English, but also in_
_French or Spanish, this will ease the translation work)._ <br>
This page at this level can be viewed in a multilingual version at: <br>
https://m3p2.com/polyglot/brainstorming-pedagogical-teams/synthesis-structuring/electromagnetism/n3

----------------------------------------

### Brainstorming

