---
title: Mécanique du solide : statique
published: true
routable: true
visible: false
---
!!!! COURS EN CONSTRUCTION (juste un essai)
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com. Ce cours est en construction, il n'est pas validé par l'équipe pédagogique à ce stade. 
!!!! Document de travail destiné uniquement aux équipes pédagogiques.


### Modélisation des systèmes mécaniques

#### Notion de système matériel

##### Point matériel

On appelle point materiel un élément dont les dimensions sont suffisamment petites pour qu'il soit possible de repérer sa position par les trois coordonnees $`x, y, z`$ d'un point geometrique $`P`$ . On associe ces trois paramètres une quatrième caracteristique, sa masse (elementaire) $`m`$.

<!--
(CLE) :
Cette notion de point matériel va être expliquée beaucoup, un peu plus précis qu'ici avec la notion de volume mésoscopique.
-->

##### Système matériel

Un **système materiel** $`S`$ est un *ensemble de points materiels*. Par exemple, un solide indéformable  est un système matériel dont la distance entre les points est invariante.

Un système materiel sera, dans la suite de ce cours, soit :

* un solide rigide $`S_i`$.
* un ensemble de $`n`$ solides rigides : on a alors  $`S = \left\{\overset{n}{\underset{i=1}{\large\cup\normalsize}}\; S_i\right\}`$

<!--
(CME) :
(mathématiquement, $`S = \overset{n}{\underset{i=1}{\large\cup\normalsize}}\; S_i`$ ou
$`S = \overset{n}{\underset{i=1}{\cup}}\; S_i`$ suffit )
-->

* une partie d'un solide rigide.

![](baldas1.jpg)

Les frontières du système étudié permettent de définir :

* l'intérieur du système considéré.
* l'extérieur du système considéré.

![](baldas2.jpg)

Pour étudier un système, on est amené :

* à le découper en sous-systèmes, c'est à dire en délimiter clairement une partie, l'isoler mentalement, et à faire apparaître les liens de cette parrie avec le reste.
* à modéliser les phénomènes qui régissent le comportement de chaque sous-système (loi de comportement).

Les liens ( liaisons ) qui existent entre d'une part les parties d'un système, et d'autre par entre le système et son environnement, mettent en jeu des forces qui garantissent ces liaisons et qu'il s'agit également de modéliser.

#### Notion de force

##### Éléments caractéristiques

La notion de **force** est une notion tout d'abord physiologique. On peut l'appréhender par exemple dans l'action de tendre ou de comprimer un ressort.

On peut attribuer à cette notion :

* un *support*.
* un *sens* sur ce support.
* un *module* correspondant à une intensité.

##### Effet des forces

Une force s'exerçant sur un système matériel peut avoir un **effet** :

* **statique** : le *système reste au repos* (mais les forces produisent des déformations).
* **dynamique** : le *système se met en mouvement* par rapport à un repère de référence, ou son mouvement est modifié (et des déformations se produisent également).

##### Classification des forces

*D'après le mode d'action de ces forces*

Parmi les **différentes forces** s'exerçant sur ou au sein d'un système donné, on identifie :

* les *forces à distances* (pesanteur, forces électromagnétiques).
* les *forces de contact*, actions mutuelles de la matière d'un ensemble matériel sur un autre au niveau d'une surface de contact.
* les *forces de cohésion* de la matière (forces existant entre les points matériels et qui garantissent la cohésion du solide).

*D'après la définition des frontières du système*

Après avoir isolé un système $`S`$ (composé de un ou plusieurs solides), on fait la distinction fondamentale entre :

* les forces extérieures à $`S`$ qui sont les forces exercées sur $`S`$ par un système ou par un solide extérieur à $`S`$ (ce sont des forces de distance ou de contact).
* les forces intérieures à $`S`$ qui sont des forces exercées par une partie de $`S`$ sur une autre partie de $`S`$ (elles représentent les interactions entre différentes parties de $`S`$).

! *Note :* <br>
! Cette distinstion entre forces intérieures ou  extérieures est purement conventionnelle : une même force peut être intérieure ou extérieure selon le système considéré.

##### Modélisation des forces

On peut représenter une **force** par l'association d'un *vecteur et* d'un *support* :

* le support est le support de la force.
* le sens du vecteur est celui dans lequel la force agit.
* le module du vecteur est proportionnel à l'intensité de la force.

Une force est donc assimilable à un **vecteur glissant** (défini à partir de 6 paramètres). Ainsi il est possible d'associer un torseur à un ensemble de forces (voir dans la suite de ce cours le chapitre Torseurs).

Soit un *système $`(S)`$ soumis à* l'action d'un *ensemble de forces extérieures $`F_i`$*. On définit le **torseur $`\mathbf{[F_{ext/S}]}`$** des forces extérieures à $`(S)`$ par :

**$`\mathbf{[F_{ext/S}]=\left[ \overrightarrow{R}_{[F]}=\sum \overrightarrow{F_i}, \overrightarrow{M}_{A[F]}=\sum \overrightarrow{AP_i}\land\overrightarrow{F_i}\right]}`$**

où les $`P_i`$ sont des points des supports des $`\overrightarrow{F_i}`$.

*Modélisation des forces à distance*

Les **forces à distances** agissent en chacun des points du système matériel considéré. Elle seront représentées de façon classique par un **champ de vecteurs $`\overrightarrow{F_P}`$ défini en tout point $`P`$**.

![](baldas3.jpg)

L'exemple le plus courant est celui des forces de gravité :

$`\overrightarrow{F_P}=dm\;\overrightarrow{g}`$

<!--
(CME) :
1 : je mettrais "forces de pesanteur" au lieu de forces de gravité, parce que le poids comprends à la fois la force de gravité et les forces d'inertie dues au mouvement de rotation de la Terre. Dans le cadre de M3P2, le cursus est global et doit être cohérent. Cette distinction est faite dans le cours de gravitation en année 1.
2 : comme il y a $`dm`$, ,ne doit-on pas écrire $`\overrightarrow{dF_P}`$ au lieu de $`\overrightarrow{F_P}`$ ?. Je ne sais pas. Dans la mesure du possible il faudra garder une logique d'écriture mathématique, car les étudiants ont beaucoup de mal avec cela, et dans d'autres cas, cela peut être dramatique. On peut aussi garder $`\overrightarrow{F_P}`$ et juste après, dans un apparté rouge (Attention), faire la remarque.
3 : Pour alléger le message, et bien séparé le général des exemples, il y a l'apparté orange (exemples)
-->

*Modélisation des forces de cohésion*

On s'intéressera aux **forces de cohésion** s'exerçant au sein d'un système matériel considéré quand on se préoccupera des problèmes de résistance de solides déformables. Ce cours étant consacré à la dynamique des solides rigides, on ne fera appel à cette notion qu'à l'occasion de quelques démonstrations ponctuelles; on les illustrera alors en considérant les **actions mutuelles de deux points matériels $`P`$ et $`P'`$ infiniment proches** :

<!--
(CME) :
Dans le cadre de M3P2, c'est le type de remarque pour se projeter dans le futur, et est une remarque annexe dans le cadre du cours. je la mettrais dans un apparté vert (au-delà)
-->

![](baldas4.jpg)

*Modélisation des forces de contact*

Le contact entre deux systèmes implique une zone de contact commune de la forme à priori quelconque; les **forces de contact** ont donc un *caractère localisé*.

Soient deux solides $`S_1`$ et $`S_2`$  ; soit $`\Sigma`$ la zone de contact à travers laquelle s'exercent les efforts de contact.

![](baldas5.jpg)

__Modélisation des actions de contact élémentaires :__

On isole le solide $`S_2`$. La répartition des efferts de $`S_1`$ sur $`S_2`$ est à priori inconnue.

Soit un élément de surface $`d\Sigma`$ centré sur un point $`P`$. Soit $`(\Pi)`$ le plan tangent à $`(\Sigma)`$ en $`P`$ et $`\overrightarrow{n}`$ la normale à $`(\Pi)`$, dirigée vers l'extérieur de $`S_2`$.

![](baldas6.jpg)

On modélise l'**action élémentaire de $`S_1`$ sur $`S_2`$** et s'exerçant en $`P`$ par un vecteur glissant $`\overrightarrow{df_{S_1/S_2}}`$ d'intensité et de direction à priori inconnues. On pose :

**$`\mathbf{\overrightarrow{df}_{S_1/S_2}=df_{N\;S_1/S_2}\cdot \overrightarrow{n}+\overrightarrow{df}_{\large\tau\normalsize\;S_1/S_2}}`$**

où :

* **$`\mathbf{df_{N\;S_1/S_2}}`$** est appelée réaction normale en $`P`$ et représente la *résistance élémentaire de $`S_1`$ à la pénétration par $`S_2`$*.
* **$`\mathbf{\overrightarrow{df}_{\tau\;S_1/S_2}}`$** est appelée réaction tangentielle en $`P`$ et représente la *résistance élémentaire de $`S_1`$ au glissement de $`S_2`$ par rapport à $`S_1`$* ; c'est une force élémentaire dite de **frottement**.

__Torseur des actions de contact :__

Une façon de *modéliser, de caractériser les actions de contact de $`S_1`$ sur $`S_2`$* consiste à former le **torseur** noté
$`[F_{1/2}]`$ et constitué de l'ensemble des forces élémentaires de contact, soit :

**$`\mathbf{ [F_{1/2}] = \left[ \overrightarrow{R}_{[F_{1/2}]}\;, \overrightarrow{M}_{O\,[F_{1/2}]} \right] }`$**

ce torseur écrit en un point $`O`$ quelconque. On a :

 *$`\quad\left\{\begin{array}{l}
  \overrightarrow{R}_{[F_{1/2}]}=\displaystyle\int_{\small\sum\normalsize} \overrightarrow{df}_{S_1/S_2} \\
 \overrightarrow{M}_{O\,[F_{1/2}]}=\displaystyle\int_{\small\sum\normalsize} \overrightarrow{OP}\land\overrightarrow{df}_{S_1/S_2}
\end{array}\right.`$*

__Décomposition du torseur des actions de contact :__

Ce torseur, à priori quelconque, admet un axe central $`(\Delta)`$. Soit $`A`$ l'intersection de $`(\Delta)`$ et de $`(\sum)`$.
Soit $`\overrightarrow{n}`$ la normale à la zone de contact et $`A`$.

<!--
(CME) :
Là, pour simplifier l'écriture, je nommerais un axe $`\Delta`$ et non $`(\Delta)`$.
-->

![](baldas7.jpg)

On pose :

$`\overrightarrow{R}_{[F_{1/2}]}=R_N\cdot\overrightarrow{n}+R_{\tau}\cdot\overrightarrow{\tau}`$

<!--
(CME) :
Il faudra homogénéïser l'écriture du vecteur unitaire normal $`\overrightarrow{n}`$ (ca ok) et dans le plan tangent...
peut-être écrire $`\overrightarrow{e_N}`$ et $`\overrightarrow{e_T}`$?
Cela revient dans toute la méca et dans tout l'électromagnétisme, partout
-->

Comme en $`A`$, $`\overrightarrow{R}_{[F_{1/2}]}`$ et  $`\overrightarrow{M}_{A\,[F_{1/2}]}`$ sont colinéaires, on pose :

$`\overrightarrow{M}_{[F_{1/2}]}=M_N\cdot\overrightarrow{n}+M_{\tau}\cdot\overrightarrow{\tau}`$

__Signification des composantes :__

Ainsi le **torseur des actions de contact** de $`S_1`$ sur $`S_2`$ peut être défini par **4 paramètres**,leur signification est la suivante :

* **$`\mathbf{R_N}`$** est la *résistance de $`S_1`$ à la pénétration par $`S_2`$* :<br>
$`R_N`$ est négatif, dirigé de $`S_1`$ vers $`S_2`$.<br>
Si *$`\mathbf{R_N=0}`$*, le contact s'annule, il n'y a *pas de contact*.

* **$`\mathbf{R_T}`$** est la *résistance de $`S_1`$ au glissement* qui pourrait se produire de $`S_1\,/\,S_2`$.<br>
Cette résistance est due au frottement des deux solides.

* **$`\mathbf{M_N}`$** est la *résistance de $`S_1`$ au pivotement* qui pourrait se produire de $`S_1\,/\,S_2`$.

* **$`\mathbf{M_T}`$** est la *résistance de $`S_1`$ au roulement* qui pourrait se produire de $`S_1\,/\,S_2`$.

__Modèle de comportement élémentaire - Modèle de Coulomb :__

Le *modèle de comportement le plus courant* - mais relativement grossier - (celui que l'on adoptera dans le cadre de ce cours), appelé **modèle de Coulomb**, s'énonce comme suit (on négligera les résistances au pivotement et au roulement devant la résistance au glissement) :

![](baldas8.jpg)

* **$`\mathbf{R_N}`$** : résistance à la pénétration est *dirigée vers l'intérieur du solide* isolé. Si $`R_N=0`$, le contact s'annule.
* **$`\mathbf{R_T}`$** : résistance au glissement qui pourrait se produire :
  * en **statique** : *s'oppose au mouvement que prendrait le solide* s'il n'y avait pas de frottement.
  * en **mouvement** : *s'oppose à la vitesse de glissement*.<br>
<br>\- si il existe un glissement au contact de $`S_1/S_2`$, alors $` |\,R_T\,|=f\,|\,R_N\,| `$,<br>
<br>\- si il n'y a pas de glissement de $`S_1/S_2`$, alors $`|\,R_T\,|\le f\,|\,R_N\,| `$,<br>
<br>où **$`\mathbf{f}`$** est le **coeficient de frottement**, qui est toujours positif : *$`\mathbf{f\ge 0}`$*


! *Note :*<br>
! Le *coefficient de frottement* $`f=\tan\varphi`$ caractérise le contact entre $`S_1`$ et $`S_2`$. Il *dépend de la nature des deux surfaces* en contact (rugosité, propriétés physico-chimiques).<br>
! 
! Relation de linéarité entre deux forces, ce coefficient est *sans unité*.
!
! On peut donner quelques exemples :<br>
! * acier sur acier : $`f=0,3`$<br>
! * acier sur bronze : $`f=0,1`$<br>
! * acier sur ferodo : $`f=0,73`$

#### Modélisation des liaisons entre solides

Considérons un esemble de solides. par définition, on appelle liaison toute restriction à la liberté d'un solide par rapport à un autre. les principales liaisons entre solides peuvent être définies à partir de modèles géométriques parfaits : les surfaces de contact entre les deux solides en liaison sont :

* des points
* des courbes
* des plans
* des sphères
* des cylindres

Pour chacune de ces surfaces, la démadche précédente peut-être appliquée. On appellera forces de liaison les actions qui s'exercent dans le cadre de ces liaisons.

##### Liaisons parfaites

Une **liaison** entre deux solides est dite **parfaite** si elle possède une *géométrie exacte* et si le contact entre les deux solides se fait *sans frottement*.

*Modélisation du contact ponctuel parfait*

Soient deux solides $`S_1`$ et $`S_2`$ en **contact ponctuel** parfait. La *zone de contact* entre les deux solides est *infiniment petite*.

![](baldas9.jpg)

On associe à cette liaison en **repère caractéristique de la géométrie**. 

Le **centre $`A`$** du repère est le *point de contact*. 

*Dans ce repère*, le **torseur** des actions de contact s'écrit :

**$`[F_{1/2}]=\left[ R_N \overrightarrow{n}=R_N \overrightarrow{z}, \overrightarrow{0}\right]_A`$**
**$`\quad=\left[\,\left|\begin{array}{l} 0 \\ 0 \\ Z \end{array}\right.\;
\left|\begin{array}{l} 0 \\ 0 \\ 0 \end{array}\right.\,\right]_{\;A,\mathcal{B}}`$**

Remarque : on constate que :

* une composante nulle de la résultante du torseur des efforts de contact de $`S_1\,/\,S_2`$ correspond à un mouvement de translation relative possible de $`S_2`$ par rapport à $`S_1`$ dans cette direction.
* la composante non nulle de la résultante correspond au mouvement relatif de $`S_2`$ par rapport à $`S_1`$ dans la direction normale $`\overrightarrow{n}`$.
* les composantes nulles du moment du torseur des efforts de contact de $`S_1\,/\,S_2`$ correspondant à des mouvements de rotation relative possibles de $`S_2`$ par rapport à $`S_1`$ suivant chacun des axes.

*Modélisation d'un contact plan parfait*

__Problème tridimentionnel :__

Soient deux solides $`S_1`$ et $`S_2`$ en contact plan parfait.

![](baldas10.jpg)

*On associe à cette liaison* un **repère caractéristique de sa géométrie** ; $`O`$ est un point quelconque de la zone de contact.

On isole $`S_2`$. En l'absence de frottement, les actions élémentaires de $`S_2`$ sur $`S_1`$ sont toutes dirigées suivant la normale au contact. Le moment par rapport à l'axe $`O\overrightarrow{n}`$ de ces actions élémentaires est nul. Le torseur des actions de contact en un point $`O`$ quelconque s'écrit donc dans la base $`\mathcal{B}`$ :

**$`[F_{1/2}]=\left[ R_N \overrightarrow{n}=R_N \overrightarrow{z}, \overrightarrow{M}_{O\;[F_{1/2}]}\right]_O`$**
**$`\quad=\left[\,\left|\begin{array}{l} 0 \\ 0 \\ Z \end{array}\right.\;
\left|\begin{array}{l} L \\ M \\ O \end{array}\right.\,\right]_{\;O,\mathcal{B}}`$**

Remarque : on constate à nouveau que :

* une comosante nulle de la résultante du torseur des efforts de contact de $`S_1\,/\,S_2`$ correspond à un mouvement de translation relative possible de $`S_2`$ par rapport à $`S_1`$ dans cette direction.
* la composante non nulle de la résultante correspond au mouvement relatif de $`S_2`$ par rapport à $`S_1`$ dans la direction de la normale $`\overrightarrow{n}`$.
* la composante nulle du moment du torseur des efforts de contact de $`S_1\,/\,S_2`$ correspond à un mouvement de rotation relative possible de $`S_2`$ par rapport à $`S_1`$ suivant l'axe $`\overrightarrow{n}`$.
* les composantes non nulles du moment du torseur des efforts de contact de $`S_1\,/\,S_2`$ correspondent à des mouvements de rotation relative impossibles de  $`S_2`$ par rapport à $`S_1`$ suivant chacun de ces axes.

*Tableau des principales liaisons parfaites*

La démarche est similaire pour les autres liaisons usuelles.

Notons à nouveau de façon générale que :

* une composante nulle de la résultante du tenseur des efforts de contact de $`S_1\,/\,S_2`$ correspond à un mouvement de translation relative possible de $`S_2`$ par rapport à $`S_1`$ dans cette direction.
* composante nulle du moment du torseur des efforts de contact de $`S_1\,/\,S_2`$ correspond à un mouvement de rotation relative possible de $`S_2`$ par rapport à $`S_1`$ suivant cet axe.

Cette dualité entre les composantes du torseur des efforts de contact et les mouvements relatifs possibles des deux solides sera reprise en détail lors du chapitre consacré à la modélisation du mouvement des solides rigides.

Le tableau représentatif est le suivant : $`O`$, point où sont réduits les ytroseurs cinématiques et les torseurs des inter-efforts.

|  |  |  |  |
|:------------------|:------------------|:------------------|:------------------|
| Liaison ponctuelle | O point de contact | Pivot <br> Glissant | O point sur l'axe de liaison |
Linéaire rectiligne | O point sur ligne de contact | Pivot | O point sur l'axe de liaison |
Linéaire annulaire | O point sur ligne de contact | Glissière | O point sur l'axe de liaison |
Rotule | O Centre de la sphère | Encastrement | O point quelconque |
Appui Plan | O point sur plan de contact |

















