---
title: 'nouveau cours : synthèse'
---

### Le miroir

#### Qu'est-ce qu'un miroir ?

##### Objectif

* premier : **réfléchir** la lumière, **focaliser ou disperser la lumière**.
* ultime : **réaliser des aimges**, seul ou comme composant d'un système optique.

##### Principe physique

* utilise le **phénomène de réflexion**, décrit par la loi de la réflexion.

##### Constitution

* **surface** plane ou courbe (sphérique pour les plus simples à réaliser, 
parabolique ou elliptique) **polie** finement de façon qu'en chaque point de sa surface,
son état de surface ne dévie de sa forme théorique que d'une distance inférieure à 
$`\lambda/10`$ ($`\lambda`$ étant la longueur d'onde dans le vide de la lumière devant 
être réfléchie). Pour accroître fortement sa réflectivité (pourcentage d'intensité lumineuse 
réflechie par rapport à l'intensité lumineuse totale incidente), la surface est 
**le plus souvent métallisée**.


##### Intérêt en optique

* **L'un des plus importants composants optiques simples**, utilisé *seul ou
combiné en série* avec d'autres composants optiques dans des d'instruments optiques : 
certains objectifs d'appareils photographiques, télescopes.


#### Pourquoi étudier les miroirs plans et sphériques ?

* Les **miroirs plans et sphériques** sont *techniquement les plus simples à réaliser*, 
aussi sont-ils les *plus communs et moins chers*.
* En optique paraxial, les propriétés optiques d'un **miroir plan** sont celles
d'un *miroir sphérique dont le rayon de courbure tend vers l'infini*.


##### Miroir plan, miroirs sphériques concaves et convexes

![](plane-concave-convex-mirrors.png)<br>
Fig. 1.  Miroir   a) plan    b) concave    c) convexe


#### Les miroirs plans et sphériques sont-ils stigmatiques ?

##### Stigmatisme rigoureux dun miroir plan

* Un miroir plan est **rigoureusement stigmatique*.
* Objet et image sont symétriques de chaque côté de la surface du miroir plan<br>
$`\Longrightarrow`$ Un objet réel donne une image virtuelle.<br> Un objet virtuel donne une image réelle.

##### Non stigmatisme du miroir sphérique

* En chaque point d'un miroir sphérique, la loi de la réflexion s'applique.
* Un miroir sphérique est non stigmatique : tous les rayons (ou leurs prolongements) 
issus d'un point objet, après réflexion ne convergent généralement pas vers un point image
(voir Fig. 2.)

![](spherical-mirror-rays-stigmatism-1000-1.jpg)<br>
Fig. 2. Non stigmatisme du miroir sphérique

![](spherical-mirror-rays-stigmatism-1000-2.jpg)<br>
Fig. 3. Mais quand nous limitons l'ouverture du miroir 

![](spherical-mirror-rays-stigmatism-1000-3.jpg)<br>
Fig. 4 . et limitons l'utilisation du miroir de telle façon que les angles d'incidence restent 
petits, alors un point image peut-être déterminé : le miroir devient quasi-stigmatique.

* les miroirs sphériques à ouverture limitée (voir Fig. 3.) et utilisés de telle façon que les angles d'incidence restent petits
en tout point de sa surface (voir Fig. 4.) réalisent les conditions de stigmatisme approché.

##### Conditions de Gauss / approximation paraxiale et stigmatisme approché

* Quand un miroir sphérique est utilisé dans les conditions suivantes, dites **conditions de Gauss** :<br>
\- Les *angles d'incidence restent petits*<br>
(les rayons incidents sont faiblement inclinés par rapport à l'axe optique, et interceptent la surface
sphérique du miroir au voisinage de l'axe optique),<br>
alors le miroir sphérique peut être considéré comme *quasi- stigmatique*, et ainsi
*peut être utilisé pour construire des images optiques*.

* Mathematiquement, quand un angle $`\alpha`$ est petit ($`\alpha < or \approx 10 ^\circ`$),
les approximations suivantes peuvent être faites :<br>
$`sin(\alpha) \approx  tg (\alpha) \approx \alpha`$ (rad), et $`cos(\alpha) \approx 1`$.

* L'optique géométrique limitée aux conditions de Gauss s'appelle l'**optique gaussienne** ou **optique paraxiale**.
 
#### Le miroir sphérique mince (optique paraxiale)

* Nous appelons **miroir sphérique mince** un *miroir sphérique utilisé dans les conditions de Gauss*.


##### Etude analytique  (en optique paraxiale)

* **Relation de conjugaison du miroir sphérique mince** :<br><br>
$`\dfrac{1}{\overline{SA_{ima}}}+\dfrac{1}{\overline{SA_{obj}}}=\dfrac{2}{\overline{SC}}`$&nbsp;&nbsp;(equ.1)

* **Expression du grandissement transversal** :<br><br>
$`\overline{\gamma_t}=-\dfrac{\overline{SA_{ima}}}{\overline{SA_{obj}}}`$&nbsp;&nbsp;(equ.2)

Tu connais $`\overline{SA_{obj}}`$, tu calcules $`\overline{SA_{ima}}`$ en utilisant (equ. 1) 
puis $`\overline{\gamma_t}`$ avec (equ.2), et déduis $`\overline{A_{ima}B_{ima}}`$.

! *UTILE 1* :<br>
! La relation de conjugaison et l'expression du grandissement transversal pour un miroir plan 
! s'obtiennent en réécrivant ces deux équations pour un miroir sphérique dans la limite
! $`|\overline{SC}|\longrightarrow\infty`$.
! Tu obtiens alors : $`\overline{SA_{ima}}=\overline{SA_{obj}}`$ et
! $`\overline{\gamma_t}=+1`$.

! *UTILE 2* :<br>
! *You can find* the conjunction and the transverse magnification *equations for a plane mirror directly from 
! those of the spherical mirror*, with the following assumptions :<br>
! $`n_{eme}=-n_{inc}`$<br>
! (to memorize : medium of incidence=medium of emergence, therefor same speed of light, but direction
! of propagation reverses after reflection on the mirror)<br>
! are obtained by rewriting these two equations for a spherical refracting surface in the limit 
! when $`|\overline{SC}|\longrightarrow\infty`$.
! Then we get for a plane mirror :<br>
! $`\overline{SA_{ima}}=\overline{SA_{obj}}`$ and $`\overline{M_T}=+1`$

##### Graphical study

*1 - Determining object and image focal points*

Positions of object focal point F and image focal point F’ are easily obtained from the conjunction
equation (equ. 1).

* Image focal length $`\overline{OF'}`$ : $`\left(|\overline{OA_{obj}}|\rightarrow\infty\Rightarrow A_{ima}=F'\right)`$<br><br>
(equ.1) $`\Longrightarrow\dfrac{1}{\overline{SF'}}=\dfrac{2}{\overline{SC}}\Longrightarrow\overline{SF'}=\dfrac{\overline{SC}}{2}`$

* Object focal length $`\overline{OF}`$ : $`\left(|\overline{OA_{ima}}|\rightarrow\infty\Rightarrow A_{obj}=F\right)`$<br><br>
(equ.2) $`\Longrightarrow\dfrac{1}{\overline{SF}}=\dfrac{2}{\overline{SC}}\Longrightarrow\overline{SF}=\dfrac{\overline{SC}}{2}`$

*2 - Thin spherical mirror representation*

* **Optical axis = revolution axis** of the mirror, positively **oriented** in the direction of propagation of the incident light.

* Thin spherical mirror equation :<br><br>
\-**line segment**, perpendicular to the optical axis, centered on the axis with symbolic *indication of the 
direction of curvature* of the surface at its extremities, and *dark or hatched area on the non-reflective 
side* of the mirror.<br><br>
\-**vertex S**, that locates the refracting surface on the optical axis;<br><br>
\-**nodal point C = center of curvature**.<br><br>
\-**object focal point F** and **image focal point F’**.

##### Examples of graphical situations, with analytical results to train

[Click here for geogebra animation](https://www.geogebra.org/m/jwgy9q7z)

* with **real objects** 

![](Thin-spherical-mirror-InfAC-1000.jpg)<br>
Fig. 5.  Concave mirror with object between infinity and C

![](Thin-spherical-mirror-CAF-1000.jpg)<br>
Fig. 6.  Concave mirror with object between C and F/F’

![](Thin-spherical-mirror-FAS-1000.jpg)<br>
Fig. 7.  Concave mirror with object between F/F’ and S

![](Thin-spherical-mirror-InfAS-1000.jpg)<br>
Fig. 8.  Convex mirror




















