---
title: 'Spherical refracting surface  : overview'
media_order: dioptre-1.gif
---

### What is a refracting interface ? 

#### Refracting surface : physical description

* **Interface separating two transparent media of different refractive indices**.

* can be **found in nature** :<br>
Examples :<br>
\- a **plane refracting surface** : the *flat and quiet surface of a lake*.
\- a **spherical refracting surface** : a *fish ball aquarium*.

![](spherical-refracting-surface-example-1.jpg)<br>
Fig. 1. The spherical refracting interface of a fish ball aquarium.

* **appears in the design and modeling of other optical elements** :<br>
Examples :<br>
\- a **glass window pane** is the combinaison of *two parallel plane refracting interfaces* (air/glass, then glass/air), separated by the thickness of the pane.<br>
\- a **lens** is composed of *two consecutive curved (often spherical) refracting interfaces* (air/glass, then glass/air) that are rotational symmetrical around a same axis.

#### Refracting interface versus refracting surface

!!!! *DIFFICULT POINT* : One plane or spherical refracting interface has two different optical behaviors for image formation, 
is characterized by two different sets of parameters, depending of the direction of the light propagation.
!!!!
!!!!Consider a plane interface (a thick window whose thickness and effect can be neglected) separating air and water, 
and two twins (Thompson and Thomson) at equal distances on both sides of the interfaces (Fig. 2a).
!!!!
!!!! ![](plane-refracting-surface-1.jpg)<br>
!!!! Fig. 2a : The situation is not symmetrical.
!!!!
!!!! * When Thompson (in air) looks at Thomson (in water), the light propagates from Thomson to Thompson’s eyes. 
The fact is that Thompson sees the image of his brother closer than the real position of his brother (Fig. 2b)
!!!!
!!!! ![](plane-refracting-surface-2.jpg)<br>
!!!! Fig. 2b. Thompson sees his brother closer than his real position in water.
!!!!
!!!! * In the opposite situation, when Thomson (in water) looks at Thompson (in air), 
the light propagates from Thompson to Thomson’s eyes. 
And the fact is that Thomson sees the image of his brother farther away than his real position (Fig. 2c)<br>
!!!! (Strictly speaking, the eye of a fish should be considered in this situation, eyes well adapted to the vision in water, 
and in direct contact with water. If not, we should consider that the Thompson’s dive mask is filled with water,
to have Thomson’s eyes in contact with water and not add another water/air refracting interface 
(that of the dive mask) on the path of the light).
!!!!
!!!! ![](plane-refracting-surface-3.jpg)<br>
!!!! Fig. 2c. Thomson sees in brother farther than his real position in air.
!!!!
!!!! All this can be predicted and calculated, but this example shows that this air/water plane 
refracting interface corresponds to two different plane refracting surfaces :<br>
!!!!
!!!! * First case , refracting surface such as :<br>
!!!!   \- refracting index of the medium of the incident light : $n_{inc} = n_{water} = 1.33$<br>
!!!!   \- refracting index of the medium of the emergent light : $n_{eme} = n_{air} = 1$<br>
!!!!
!!!! *¨ Second case , refracting surface such as :<br>
!!!! \- refracting index of the medium of the incident light : $n_{inc} = n_{air} = 1$<br>
!!!! \- refracting index of the medium of the emergent light : $n_{eme} = n_{water} = 1.33$.
!!!!

#### Non stigmatism of spherical refracting surfaces

![](dioptre-spherique-snell-law.png)<br>
Fig. 3. : In each point of the spherical refracting surface, the Snell-Descartes relation applies.

![](dioptre-spherique-non-stigmatique-1.png)<br>
Fig. 4. : A spherical refracting surface is not stigmatic: The rays (or their extensions) coming 
from an object point generally do not converge towards an image point.

![](dioptre-spherique-non-stigmatique-2.png)<br>
Fig. 5a. : If we limit the opening of the spherical refracting surface so that only the rays 
meeting the surface near the vertex are refracted through the surface.

![](dioptre-spherique-gauss-conditions.png)<br>
Fig. 5b. : and if the object points remain close to the optical axis, so that the angles of 
incidence and refraction remain small, then for each object point an image point can be almost
defined, and therefore the spherical refracting surface becomes quasi-stigmatic.

#### Gauss conditions / paraxial approximation and quasi-stigmatism

When spherical refracting surfaces are used under the following conditions, named **Gauss conditions** :<br>
\- All *incident rays lie close to the optical axis*<br>
\- The *angles of incidence and refraction are small*<br>
Then *the spherical refracting surfaces* can be considered *quasi-stigmatic*, and therefore they can be used to build optical images.

Mathematically, when an angle $`\alpha`$ is small $`alpha < or \approx 10 ^\circ`$,  the following approximations can be made :<br>
$`sin(\alpha) \approx  tan (\alpha) \approx \alpha`$, and $`cos(\alpha) \approx 1`$.

*Geometrical optics limited to Gaussian conditions* is called *Gaussian optics* or *paraxial optics*.

#### Characterization of a spherical refracting surface

* 2 distincts points : **vextex S** and **center of curvature C** on the optical axis,
which defines $`\overline{SC}`$ : algebraic distance between vertex S and center C of curvature on optical axis.

* 2 refractive index values :<br>
\- **$`n-{inc} : refractive index of the medium of the incident light**.<br>
\- **$`n-{eme} : refractive index of the medium of the emergent light**.

* 1 arrow : indicates the *direction of light propagation*

#### Thin spherical refracting surface

We call **thin spherical refracting surface** a spherical refracting surface *used in the Gauss conditions*.

#### Analytical study (in paraxial optics)








spherical refracting surface

!!!! DIFFICULT  POINT:<br>
!!!! A same plane or spherical plane refracting interface will have two different optical behaviors, will be modeled by two different sets of parameters, depending on the direction of the light propagation.
!!!!
!!!! Consider a plane interface (a thick window whose thickness and effect can be neglected) that separates air and water, and two twins (Thompson and Thomson) at equal distances on both sides of the interface.
!!!!
!!!! <!-- fig 2a to add --><br>
!!!! Fig. 2a. The situation is not symmetrical :
!!!!
!!!! * When  Thompson (in air) looks at Thomson (in water) the light propagets from Thomson to Thompson's eyes. The fact is that Thompson sees the image of his brother closer than the real position of his brother.
!!!!
!!!! <!-- fig 2b to add--><br>
!!!! Fig. 2b.
!!!
!!!! * In the opposite situation, when Thomson (in water) looks at his brother (in air), the light propagates from Thompson to Thomson's eyes. And the fact is that Thomson sees the image of his brother farther away from his real position.<br>
!!!! (Strictly speaking, the eye of a fish should be considered in this situation, eyes well adapted to vision in water and in direct contact with water. If not, we should consider that the Thomson's dive mask is filled with water, to have Thomson's eyes in contact with water and not to add another water/air refracting surface (that of the dive mask) on the path of the light rays :
!!!!
!!!! <!-- fig 2c to add-→<br>
!!!! Fig. 2c.
!!!!
!!!! All this can be predicted and calculated, but this example shows that this air/water plane refracting interface corresponds to two different plane refracting surfaces :
!!!!
!!!! * First case : refracting surface such as :<br>
!!!! \- refractive index of the medium of incident light : $n_{inc}=n_{water}=1.33$<br>
!!!! \- refractive index of the medium of emerging light : $n_{eme}=n_{air}=1$
!!!!
!!!! * Second case : for this refracting surface :<br>
!!!! \- refractive index of the medium of incident light : $n_{inc}=n_{air}=1$<br>
!!!! \- refractive index of the medium of emerging light : $n_{eme}=n_{water}=1.33$
!!!!











### Spherical refracting surface modeling.

#### Description 

![](dioptre-1.gif)

with :
* arrow : indicates direction of light propagation.
* $`n_{ini}`$ : refractive index of the initial medium.
* $`n_{fin}`$ : refractive index of the final medium.
* $`\overline{SC}`$ : algebraic distance between vertex S and center C of curvature on optical axis.



!!!! *BE CAREFUL* :<br>
!!!! In the same way as we use in English the single word "mirror" to qualify a "reflecting surface", in French is use the single word "dioptre" to qualify a "refracting surface".
!!!! The term "dioptre" in English is a unit of mesure of the vergence of an optical system. In French, the same unit of measure is named "dioptrie".
!!!! So keep in mind the following scheme :
!!!!
!!!! refracting surface : *EN : refracting surface* , *ES : superficie refractiva* , *FR : dioptre*.<br>
!!!! _A crystal ball forms a spherical refracting surface : un "dioptre sphérique" in French._
!!!!
!!!! unit of measure : *EN : dioptre* , *ES : dioptría* , *FR : dioptrie*.<br>
!!!! _My corrective lens for both eyes are 4 dioptres : "4 dioptries" in French._


#### Spherical refracting surface.

#### Analytical study

A **spherical refracting surface** in analytical paraxial optics is defined by *three quantities* :
* **$`n_{ini}`$** : *refractive index of the initial medium* (the medium on the side on the incident light).
* **$`n_{fin}`$** : *refractive index of the final medium* (the medium on the side on the emerging light, after crossing the refracting surface).
* **$`\overline{SC}`$** : the *algebraic distance between the __vertex S__* (sometimes called "pole", is the centre of the aperture) *and the __center of curvature C__* of the refracting surface.

! *USEFUL* : The whole analytic study below also applies to a plane refracting surface. We just need to remark that a plane surface is a spherical surface whose radius of curvature tends towards infinity.

##### Spherical refracting surface equation

**spherical refracting surface equation** = **"conjuction equation" for a spherical refracting surface**

**$`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=\dfrac{n_{fin}-n_{ini}}{\overline{SC}}`$**

##### Transverse magnification expression

2. I use the **"transverse magnification equation" for a spherical refracting surface**, to calculate the *__algebraic value__ of the transverse magnification* **$`\overline{M_T}`$**, then to derive the *__algebraic length__* **$`\overline{A_{ima}B_{ima}}`$** of the segment $`[A_{ima}B_{ima}]`$, that is the algebraic distance of the point image $`B_{ima}`$ from its orthogonal projection $`A_{ima}`$ on the optical axis.

By *definition :* **$`\overline{M_T}=\dfrac{\overline{A_{ima}B_{ima}}}{\overline{A_{obj}B_{obj}}}`$**.
Its *expression for spherical refracting surface :* **$`\overline{M_T}=\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$**.

I know $`\overline{SA_{obj}}$, $n_{ini}$ and $n_{fin}$, I have previously calculated $`\overline{SA_{ima}}$, so I can calculate $`\overline{M_T}`$ and deduced $`\overline{A_{ima}B_{ima}}`$


! *USEFUL* : The conjuction equation and the transverse magnification equation for a plane refracting surface are obtained by rewriting these equations for a spherical refracting surface in the limit when $`|\overline{SC}|\longrightarrow\infty`$.<br> Then we get *for a plane refracting surface :*
!
! * *conjuction equation :*&nbsp;&nbsp; $`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=0`$.
!
! * *transverse magnification equation :*&nbsp;&nbsp; $`\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$ &nbsp;&nbsp; (unchanged).
!
! This generalizes and completes the knowledge you get about plane refracting surfaces seen in your pedagogical paths in plain and hills.


#### Graphical study