---
title: Electrocinétique
published: true
routable: true
visible: false
---

!!!! *COURS EN CONSTRUCTION :* <br>
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com. Ce cours est *en construction*, il n'est *pas validé par l'équipe pédagogique* à ce stade. <br>
!!!! Document de travail destiné uniquement aux équipes pédagogiques.

<!--MétaDonnée : INS-2°année-->
<!-- Cours préparatoire à la magnétostatique-->


### Qu'est-ce qu'un milieu conducteur électrique ?

Un milieu est électriquement **conducteur** si il contient des *charges 
libres de se déplacer* à travers le milieu *sous l'influence d'un champ électrique*
aussi faible soit-il.

![](conduction-1-2-L1200-new.gif)

* Dans les **conducteurs solides**, les charges libres sont des *électrons*.
* Dans les **conducteurs liquides (électrolytes)**, les charges libres sont des *ions
positifs et des ions négatifs*.
* Dans les **conducteurs gazeux (plasma)**, les porteurs de charges sont des *électrons et
des ions positifs*.

### Qu'est-ce qu'un courant électrique ?

#### Courant électrique, et intensité du courant électrique

* **Courant électrique** : mouvement d'ensemble de porteurs de charge électrique mobiles.

* **Intensité $`I`$** du courant électrique :<br>
<br>
L'intensité $`I`$ du courant électrique **à travers une surface orientée $`S`$** est égale à la *charge électrique $`\Delta Q`$ qui traverse cette surface $`S`$ dans le sens positif de la surface pendant la durée $`\Delta t`$.*<br>
<br>
**$`I=\left. \dfrac{\Delta Q}{\Delta t} \right|_S`$**<br>
<br>
<br>L'intensité $`I`$ est ainsi une grandeur algébrique : elle peut être positive ou négative, et sa notation devrait être $`\overline{I}`$.<br>

![current-intensity-definition-2_v1_L1200](current-intensity-definition-2_v1_L1200.jpg)

![current-intensity-definition-2_v1_L1200](current-intensity-definition-1-2_v1_L1200.gif)

![current-intensity-definition-2_v1_L1200](current-intensity-definition-1-3_v1_L1200.gif)

![current-intensity-definition-2_v1_L1200](current-intensity-definition-5_v1_L1200.jpg)


* Lorsque **$`I`$ ne dépend pas du temps**, le courant est dit *stationnaire* ou *continu*.<br>
<br> Lorsque **$`I`$ change de valeur au cours du temps**, le courant est dit *variable*, et se note *$`I(t)`$* .<br>
<br> Lorsque pour un courant variable voit le **sens du mouvement** d'ensemble des porteurs de charge **s'inverse au cours du temps**, le courant est dit *alternatif*.

* **Unité SI** de l'intensité $`I`$  : *Ampère*, de symbole *$`A`$*.<br>
<br>Une courant d'intensité d'**un ampère ($`1\,A`$)** correspond donc à une *charge de 1 Coulomb ($`1\,C`$) qui traverse une surface donnée en une seconde ($`1\,s`$). 

! *Note :*
!
! L'Ampère est une unité de base du système international d'unités, parmi les sept unités de base qu'il contient et qui sont le mètre, le kilogramme, la seconde, l'ampère, le kelvin, la mole et la candela. Toutes les autres unités, nommées unités dérivées, s'expriment en fonction des sept unités de base à partir d'une analyse dimensionnel.

* *Intensité instantanée  :








### Qu'est-ce que vitesse de dérive et mobilité dans les conducteurs solides ?

#### Vitesse de dérive dans un conducteur solide

* Dans un **plasma peu dense**, chaque *particule libre* de charge $`q`$ et de masse $`m`$
au repos est relativement libre de se déplacer. Sous l'effet de la force électrique 
$`\overrightarrow{F_E}=q \cdot \overrightarrow{E}`$,
elle est accélérée $`\overrightarrow{a}=\overrightarrow{F_E}/m`$, 
et sa *vitesse augmente constamment* et peut atteindre des vitesses relativistes.

* Dans un matériau dense comme un **conducteur solide**, au cours de sa trajectoire 
chaque *particule libre* de charge $`q`$ subit *pleins de "chocs"* (expression classique)
avec notamment les atomes du réseau matériel, qui 
*relaxent sa quantité de mouvement et son énergie cinétique*.<br><br> 
$`\Longrightarrow`$ *mouvement désordonné sans direction privilégiée*, donc qui
n'*induit pas de courant électrique* à travers une surface : c'est le 
**mouvement d'agitation thermique**.<br><br>
$`\Longrightarrow`$ à ce mouvement d'agitation thermique se superpose un 
*lent mouvement de dérive en direction du champ électrique* (matériaux isotropes) qui 
réaccélère la particule entre deux chocs : c'est un **mouvement de dérive**.

* Dans un volume mésoscopique de matériau conducteur et dans une description classique 
des forces moyennes qui agissent sur les particules libres chargées au sein de ce 
volume, les **chocs** agissent comme une *force de frottement* *$`\overrightarrow{F_{frot}}`$* 
*qui s'oppose à la force électrique* *$`\overrightarrow{F_E}`$*. 

* Lorsque ces deux forces sont égales en modules et de sens opposés 
*$`(\;\overrightarrow{F_{frot}}=-\overrightarrow{F_E}\;)`$*
, la *force résultante s'annule*, donc l'accélération moyenne s'annule et la population 
de particules chargées libres d'un même type se déplacent globalement d'un vecteur 
vitesse appelé **vecteur vitesse de dérive $`\overrightarrow{v_{d}}`$**.<br><br>
$`\Longrightarrow`$ de vitesse moyenne faible, mais de direction stable, le
**mouvement de dérive** induit un *courant électrique dans le matériau*.

<!--Remarque : au niveau 4, cela va vers les semi-conducteurs, puis les phénomènes de transport.-->

### Mobilité d'un matériau conducteur

* Pour des valeurs de champ électrique pas "trop fort" (régime ohmique), la 
**vitesse de dérive $`\overrightarrow{v_d}`$** est 
*proportionnelle au champ électrique appliqué $`\overrightarrow{E}`$*. 

* Le *rapport de proportionnalité* entre $`\overrightarrow{v_d}`$ et $`\overrightarrow{E}`$
s'appelle la mobilité :<br><br>
**$`\overrightarrow{v_{d}}=-\mu \cdot \overrightarrow{E}`$**<br><br>
$`\Longrightarrow`$ Plus un matériau aura une mobilité importante pour ses électrons
libres par exemple, plus la vitesse de dérive des électrons sera importante pour 
un même champ électrique appliqué, plus le courant électrique sera important pour 
une même densité volumique en électrons libres. Par ailleurs, plus le matériau 
répondra en fréquence.

### Vecteur densité volumique de courant

#### Avec un seul type de porteur de charge

Soit un matériau solide conducteur soumis à un champ électrique extérieur $`\overrightarrow{E}`$.

* En un temps $`dt`$, en moyenne un porteur de charge libre parcourt un vecteur
distance $`\overrightarrow{dl}`$ telle que :
**$`\overrightarrow{dl}= \overrightarrow{v_d} \cdot dt`$** 

Soit une petite surface mésoscopique $`\overrightarrow{dS}`$ orientée en direction
et sens du courant électrique.

* Les porteurs qui traverseront en ce temps $`dt`$ la surface $`\overrightarrow{dS}`$ 
 sont ceux situés dans le parallélépipède rectangle de section $`dS`$ et de longueur $`d`$,
donc de volume mésoscopique $`d\tau`$ tel que :<br> 
$`d\tau = dl \cdot dS = ||\overrightarrow{v_d}|| \cdot dt\cdot dS`$.

* La charge totale $`dQ_{dS}`$ qui traverse dans le temps $`dt`$ est donc la charge 
* totale $`dQ_{d\tau}`$ des porteurs de charge libres contenus dans le volume $`d\tau`$.

<!--images individuelles du gif 1-2
![](conducteur-1-L1200-new-ok.jpg)

![](conducteur-2-L1200-new-ok.jpg) -->

<!-- images individuelles du gif 2-3-4-5

![](conducteur-3-L1200-new-ok.jpg)

![](conducteur-4-L1200-new-ok.jpg)

![](conducteur-5-L1200-new-ok.jpg) -->

![](conduction-2-3-4-5-L1200-new.gif)

<!-- images individuelles du gif 5-6-7

![](conducteur-6-L1200-new-ok.jpg)

![](conducteur-7-L1200-new-ok.jpg) -->

![](conduction-5-6-7-L1200-new.gif)

<!-- images individuelles du gif 7-8

![](conducteur-8-L1200-new-ok.jpg) -->

![](conduction-7-8-L1200-new.gif)

![](conducteur-9-L1200-new-ok.jpg)

![](conducteur-10bis-L1200-new-ok.jpg)

![](conducteur-11-L1200-new-ok.jpg)

![](conducteur-12-L1200-new-ok.jpg)


## Que représente le vecteur densité superficielle de courant ?

![](densite-surfacique-courant-L1200.jpg)


## Quelle équation indique la conservation de la charge ?

![](charge-conservation-1-L1200.jpg)

![](charge-conservation-2bis-L1200.jpg)


## Quelle est la loi d'Ohm ?

![](Ohm-law-L1200.jpg)


## Un circuit conducteur est-il chargé ?


Probablement circuit conducteur en régime stationnaire ou lentement variable

![](circuit-conducteur-1-L1200-colored-ok.jpg)

![](circuit-conducteur-2-L1200-colored-ok.jpg)



![](electrostatics-conducteur-1-L1200-colored-ok.jpg)

![](circuit-electrique-2-L1200.jpg)

![](charge-conservation-law-L1200.jpg)

![](charge-conservation-law-stationary-current.jpg)







