---
title: 'El concepto de rayo de luz'
media_order: 'OG_rayons_foret.mp3,OG_rayons_foret.ogg,rays_forest.jpg'
---

###Fundamentos de la óptica geométrica

#### Óptica Geométrica <br> un modelo físico simple.

Sus *fundamentos* son :
* El concepto de **rayo de luz** camino orientado de la energía luminosa
* El concepto de **índice de refracción** caracteriza la velocidad aparente de la luz en un medio homogéneo
* El **principio de Fermat**
 
##### Rayo de luz

![](rays_forest.jpg)

<!--Para el audio :
Caminar en el bosque en un día caluroso de verano es un gran placer. El contraste entre la frescura de las áreas sombreadas por el follaje y los troncos de los árboles, y el calor de la luz solar directa es sorprendente. rayos de luz directos aumentan la temperatura del aire, haciendo que el sudor, y golpear su piel que le da la sensación de la luz, no desagradable, porque dominado, ardor. La luz transporta energía .... Mientras camina, se puede anticipar, prisa a la llegada de una zona de sombra, como el juego de luces con espacio cebra árboles a su alrededor. En el aire los aromas únicos y maravillosos de la selva, los rayos de luz se propagan en línea recta, que siguen la trayectoria de propagación de la energía de la luz.-->

[AUDIO : _la intuición del "rayo de luz" durante un paseo por el bosque_](OG_rayons_foret.mp3)

Los **rayos de luz** son *líneas orientadas* que en cada uno de sus puntos indican la *dirección y el sentido de propagación de la energía de la luz*.

Los rayos de luz siguen *líneas rectas en un entorno homogéneo*.

* Los rayos de luz *no interactúan*

##### El índice de refracción

**índice de refracción $`n`$** &nbsp;&nbsp;:&nbsp;&nbsp;
**$`n\;=\;\dfrac{c}{v}`$**
* **`c`** : *velocidad de la luz en el vacío* (límite absoluto)
* **`v`** : *velocidad de la luz en un medio* homogéneo

**$`\Longrightarrow\: : \: n`$** : cantidad física **adimensional ** y **siempre >1**.

Dependencia : **$`n\;=\;n(\nu)\;\;\;`$** , ou **$`\;\;\;n\;=\;n(\lambda_0)\;\;\;`$** *(con $`\lambda_0`$ longitud de onda en el vacío)*

<!--
Yo quería hacer este punto importante aquí, pero no es simple: con el efecto Doppler, medio de propagación no se mueve en relación con el observador ... creo que debe ser la advertencia en el texto principal, y resumen de todos en este lugar tan paralela 1:

!!!! PRECAUCIÓN : frecuencia $\nu$ de un (variable de tiempo) de onda medida por un observador dado, no es dependiente en el medio de propagación, donde la medición se lleva a cabo. Este no es el caso de la medida de longitud de onda $\lambda$ , que depende del medio de propagación como la propagación de la onda de velocidad $V$ puede depender de ese entorno. Frecuencia, longitud de onda y la velocidad de propagación de una onda están conectados por la ecuación $\lambda\:=\:\frac{V}{\nu}$, mais :<br>
!!!! la **cantidad fundamental** (independiente del medio) es la frecuencia $\nu$ (la escala temporal)**.
-->

!! PARA IR MÁS LEJOS :
!!
!! en todo el espectro electromagnético y por cualquier medio :
!!$`n`$ : valor complejo dependiente de la frecuencia $\nu$ de la onda electromagnética, las variaciones fuerte representativo de todos los mecanismos de interacción de luz / materiales : $`n(\nu)=\Re[n(\nu)]+\Im[n(\nu)]`$<br>
!!
!! en el visible (donde se usa $`\lambda_0`$ más que $`\nu`$) y por medio transparente :<br>
!! valor real, pequeñas variaciones de $`n`$ con $`\lambda_0`$ $`\left(\frac{\Delta n}{n} < 1\%\right)`$

##### Camino óptico

**camino óptico** *$`\delta`$* &nbsp;&nbsp;&nbsp; $`=`$
**longitud euclidiana** *$`s`$* &nbsp;&nbsp; $`\times`$ &nbsp;&nbsp; **índice de refracción** *$`n`$*

* **$`\Gamma`$** : *camino (línea continua) entre dos puntos fijos A y B*
* **$`\mathrm{d}s_P`$** : *elemento infinitesimal de longitud en el punto P en el camino $`\Gamma`$*
* **$`n_P`$** : *índice de refracción al punto P*
* **$`\mathrm{d}\delta_P`$** : *infinitesimal camino óptico en el punto P en el camino $`\Gamma`$*

Camino óptico a lo largo de un camino entre dos puntos fijos A y B :

**$`\delta\;=\;\displaystyle\int_{P \in \Gamma}\mathrm{d}\delta_P\;`$$`=\;\int_{P \in \Gamma}n_P\cdot\mathrm{d}s_P`$**

* **$`\delta`$** $`=\displaystyle\int_{\Gamma}n\cdot\mathrm{d}s\;=\;\int_{\Gamma}\dfrac{c}{v}\cdot\mathrm{d}s`$ = $`c\;\displaystyle\int_{\Gamma}\dfrac{\mathrm{d}s}{v}`$ = *$`\;c\;\tau`$*
* **$`\delta`$** es *proporcional al tiempo de curso*
