---
title: 'The 4 laws of geometrical optics'
---

* **Fermat's principle** *$\Longrightarrow$ the 4 laws of geometrical optics* :

#### Law of reversibility of the path of light.

Optical path and property of stationarity : concept of orientation not used <br>
*$\Longrightarrow$ stationarity property does not depend on the orientation* of the path.

**$\Longrightarrow$**  the **trajectory** *followed by the light* is **indépendant of the direction of propagation along the trajectory**.

#### Law of the rectilinear light trajectory in homogeneous and isotrope media. 

Euclidian space : *straight line = shortest path between 2 points*

**$\Longrightarrow$**  in an **optically homogeneous and isotrope medium**, the *light travels rectilinearly* : the **light rays are straight lines**.

#### The 2 laws of reflection and refraction
! <details markdown=1>
! <summary>
! IF NECESSARY : reminder if the definitions of the angles and refractive indexes used below. 
! </summary>
! $n_{incid}$ : refractive index of the incident light medium.<br>
! $n_{émerg}$ : refractive index of the emergent light medium (so after crossing the surface).<br>
! $i_{incid}$ : incident ray - normal to the surface at the point of impact angle.<br>
! $i_{émerg}$ : emergent ray - normal to the surface at the point of impact angle.<br>
! </details>

For any incident ray impacting a surface :
* The **surface at the point of impact** is *locally a plane*.
* **Plan of incidence** : plane that *contains the incident ray and normal to the surface at the point of impact*.
* **Refracted and reflected rays** are *in the plane of incidence*, on the *side opposite to the incident ray in relation to the normal* at the surface at the impact point.

*Reflection law* : **$i_{réflec} = i_{incid}$**

*Refraction law (Snell-Descartes)* : for any $i_{incid}$  :
* if $\dfrac{n_{incid}}{n_{émerg}}\cdot\sin(i_{incid})\leqslant1$ then **refraction phenomenon** :<br><br>
**$n_{émerg}\cdot sin(i_{émerg})=n_{incid}\cdot sin(i_{incid})$**<br>

* if $\dfrac{n_{incid}}{n_{emerg}}\cdot\sin(i_{incid})>1$ then **total reflection phenomenon** :<br>
*reflected ray* on the interface that follows the reflection law **$i_{réflec} = i_{incid}$**<br>

* **Critical angle** (of inidence) **for total reflection : $i_{incid_limit}=\arcsin\left (\dfrac{n_{émerg}}{n_{incid}}\right)$** *$\Longrightarrow i_{émerg}=\pi/2\:rad = 90 °$*

_Phenomena of reflection and refraction on a refracting surface._

![](interaction_lumiere_surface_3_650.gif)

!! <details markdown=1>
!! <summary>
!! TO GO FURTHER : intensity distribution between reflected and transmitted beam at a refracting surface.
!! </summary>
!! Geometrical optics: does not quantify the reflected $R$ and transmitted $T$ parts of the  incident beam intensity at a plane refracting surface. This distribution varies according to the incidence angle, the polarization of the incident light, the wavelength. This is described by electromagnetism.
!! However a simple result is useful and to know :
!! *The light intensity is either reflected or transmitted* : $R+T=1$.
!!
!! For a light beam of wavelength $\lambda$ of normal incidence upon a refracting surface :
!! - ratio reflected power versus incident power : $R=\left(\dfrac{n_{incid}-n_{émerg}}{n_{incid}+n_{émerg}}\right)^2$
!! - ratio transmitted power versus incident power  : $T=1-R$
!!</details>

_Total reflection phenomenon_

<!--to finalize if possible :
1) DIFFICULT : geogebra animation should spend over 100% of the window width, and keep its correct ratio width / height.
2) VERY DIFFICULT: make sure that in connection mode, the animated image corresponding to the geogebra is displayed as long as the animation iframe geogebra is not downloaded, then it does not appear when the geogeba is ready, and that it is displayed in offline mode".-->

<!--iframe width="auto" height="auto" sandbox="allow-same-origin allow-scripts" src="https://www.geogebra.org/material/iframe/id/bg5ewxee" frameborder="0" allowfullscreen></iframe-->

_smartphone : switch to "landscape" mode to see the geogebra animations._
<iframe width="640" height="360" sandbox="allow-same-origin allow-scripts" src="https://www.geogebra.org/material/iframe/id/bg5ewxee" frameborder="0" allowfullscreen></iframe>
<!--image gif correspondante-->
![](Opt_Geo_refle_lim_650.gif)




