---
title : conduction
published : false

---


## Qu'est-ce qu'un milieu conducteur électrique ?

Un milieu est électriquement **conducteur** si il contient des *charges 
libres de se déplacer* à travers le milieu *sous l'influence d'un champ électrique*
aussi faible soit-il.

![](conduction-1-2-L1200-new.gif)

* Dans les **conducteurs solides**, les charges libres sont des *électrons*.
* Dans les **conducteurs liquides (électrolytes)**, les charges libres sont des *ions
positifs et des ions négatifs*.
* Dans les **conducteurs gazeux (plasma)**, les porteurs de charges sont des *électrons et
des ions positifs*.

## Qu'est-ce que vitesse de dérive et mobilité dans les conducteurs solides ?

### Vitesse de dérive dans un conducteur solide

* Dans un **plasma peu dense**, chaque *particule libre* de charge $`q`$ et de masse $`m`$
au repos est relativement libre de se déplacer. Sous l'effet de la force électrique 
$`\overrightarrow{F_E}=q \cdot \overrightarrow{E}`$,
elle est accélérée $`\overrightarrow{a}=\overrightarrow{F_E}/m`$, 
et sa *vitesse augmente constamment* et peut atteindre des vitesses relativistes.

* Dans un matériau dense comme un **conducteur solide**, au cours de sa trajectoire 
chaque *particule libre* de charge $`q`$ subit *pleins de "chocs"* (expression classique)
avec notamment les atomes du réseau matériel, qui 
*relaxent sa quantité de mouvement et son énergie cinétique*.<br><br> 
$`\Longrightarrow`$ *mouvement désordonné sans direction privilégiée*, donc qui
n'*induit pas de courant électrique* à travers une surface : c'est le 
**mouvement d'agitation thermique**.<br><br>
$`\Longrightarrow`$ à ce mouvement d'agitation thermique se superpose un 
*lent mouvement de dérive en direction du champ électrique* (matériaux isotropes) qui 
réaccélère la particule entre deux chocs : c'est un **mouvement de dérive**.

* Dans un volume mésoscopique de matériau conducteur et dans une description classique 
des forces moyennes qui agissent sur les particules libres chargées au sein de ce 
volume, les **chocs** agissent comme une *force de frottement* *$`\overrightarrow{F_{frot}}`$* 
*qui s'oppose à la force électrique* *$`\overrightarrow{F_E}`$*. 

* Lorsque ces deux forces sont égales en modules et de sens opposés 
*$`(\;\overrightarrow{F_{frot}}=-\overrightarrow{F_E}\;)`$*
, la *force résultante s'annule*, donc l'accélération moyenne s'annule et la population 
de particules chargées libres d'un même type se déplacent globalement d'un vecteur 
vitesse appelé **vecteur vitesse de dérive $`\overrightarrow{v_{d}}`$**.<br><br>
$`\Longrightarrow`$ de vitesse moyenne faible, mais de direction stable, le
**mouvement de dérive** induit un *courant électrique dans le matériau*.

<!--Remarque : au niveau 4, cela va vers les semi-conducteurs, puis les phénomènes de transport.-->

### Mobilité d'un matériau conducteur

* Pour des valeurs de champ électrique pas "trop fort" (régime ohmique), la 
**vitesse de dérive $`\overrightarrow{v_d}`$** est 
*proportionnelle au champ électrique appliqué $`\overrightarrow{E}`$*. 

* Le *rapport de proportionnalité* entre $`\overrightarrow{v_d}`$ et $`\overrightarrow{E}`$
s'appelle la mobilité :<br><br>
**$`\overrightarrow{v_{d}}=-\mu \cdot \overrightarrow{E}`$**<br><br>
$`\Longrightarrow`$ Plus un matériau aura une mobilité importante pour ses électrons
libres par exemple, plus la vitesse de dérive des électrons sera importante pour 
un même champ électrique appliqué, plus le courant électrique sera important pour 
une même densité volumique en électrons libres. Par ailleurs, plus le matériau 
répondra en fréquence.

## Vecteur densité volumique de courant

### Avec un seul type de porteur de charge

Soit un matériau solide conducteur soumis à un champ électrique extérieur $`\overrightarrow{E}`$.

* En un temps $`dt`$, en moyenne un porteur de charge libre parcourt un vecteur
distance $`\overrightarrow{dl}`$ telle que :
**$`\overrightarrow{dl}= \overrightarrow{v_d} \cdot dt`$** 

Soit une petite surface mésoscopique $`\overrightarrow{dS}`$ orientée en direction
et sens du courant électrique.

* Les porteurs qui traverseront en ce temps $`dt`$ la surface $`\overrightarrow{dS}`$ 
 sont ceux situés dans le parallélépipède rectangle de section $`dS`$ et de longueur $`d`$,
donc de volume mésoscopique $`d\tau`$ tel que :<br> 
$`d\tau = dl \cdot dS = ||\overrightarrow{v_d}|| \cdot dt\cdot dS`$.

* La charge totale $`dQ_{dS}`$ qui traverse dans le temps $`dt`$ est donc la charge 
* totale $`dQ_{d\tau}`$ des porteurs de charge libres contenus dans le volume $`d\tau`$.

<!--images individuelles du gif 1-2
![](conducteur-1-L1200-new-ok.jpg)

![](conducteur-2-L1200-new-ok.jpg) -->

<!-- images individuelles du gif 2-3-4-5

![](conducteur-3-L1200-new-ok.jpg)

![](conducteur-4-L1200-new-ok.jpg)

![](conducteur-5-L1200-new-ok.jpg) -->

![](conduction-2-3-4-5-L1200-new.gif)

<!-- images individuelles du gif 5-6-7

![](conducteur-6-L1200-new-ok.jpg)

![](conducteur-7-L1200-new-ok.jpg) -->

![](conduction-5-6-7-L1200-new.gif)

<!-- images individuelles du gif 7-8

![](conducteur-8-L1200-new-ok.jpg) -->

![](conduction-7-8-L1200-new.gif)

![](conducteur-9-L1200-new-ok.jpg)

![](conducteur-10bis-L1200-new-ok.jpg)

![](conducteur-11-L1200-new-ok.jpg)

![](conducteur-12-L1200-new-ok.jpg)


## Que représente le vecteur densité superficielle de courant ?

![](densite-surfacique-courant-L1200.jpg)


## Quelle équation indique la conservation de la charge ?

![](charge-conservation-1-L1200.jpg)

![](charge-conservation-2bis-L1200.jpg)


## Quelle est la loi d'Ohm ?

![](Ohm-law-L1200.jpg)


## Un circuit conducteur est-il chargé ?


Probablement circuit conducteur en régime stationnaire ou lentement variable

![](circuit-conducteur-1-L1200-colored-ok.jpg)

![](circuit-conducteur-2-L1200-colored-ok.jpg)

Ca, ca va passer dans l'électrostatique de la matière :

ici des conducteurs

je prépare l'électrostatique des diélectriques

![](electrostatics-conducteur-1-L1200-colored-ok.jpg)


