---
text : "Phénomènes d'interférences et de diffraction"
published : false
visible : false
----
### Aspect ondulatoire de la lumière

Les **phénomènes d'interférences et de diffraction** sont *caractéristiques des ondes*.

Interférences et diffraction lumineuses *traduisent l'aspect ondulatoire de la lumière*.

![](interferences_diffraction_general.jpg)


### Le phénomène d'interférences

Le **phénomène d'interférence** est observé lorsque la *superposition de deux ou plusieurs ondes* de même nature (sonores, mécaniques, électro-magnétiques) donne lieu à une *intensité résultante qui n'est pas égale à la simple addition des intensités* prises individuellement.

!!Note : pour l'onde électromagnétique, une interférence peut se traduire localement par le phénomène  :  lumière + lumière = obscurité.

**En pratique** sur un écran d'observation, les *intensités individuelles*  des ondes incidentes *varient lentement* alors que les **différences de phase** entre les ondes qui interfèrent et qui sont à l'origine du phénomène d'interférence **varient rapidement**.

On appelle **franges d'interférences** le *lieu des points M* caractérisés par une *intensité moyenne $\overline{\,I\,}`$ donnée* :

* Les **franges brillantes** correspondent à une *intensité maximale : $`I=I_{max}`$*
* Les **franges sombres** correspondent à une *intensité minimale : $`I=I_{min}`$*

### Quantification du phénomène d'interférences : le contraste

Le **contraste** (ou visibilité) des franges quantifie notre *aptitude à discerner les franges*.

Il se définit localement à partir de la distribution d'intensité résultante des ondes qui interfèrent. Si localement *$`I_{max}`$* est l'*intensité maximum* et *$`I_{min}`$* l'*intensité minimum*, le contraste (ou visibilité) des franges se définit par :

$`\mathcal{V} = \dfrac{I_{max}-I_{min}}{I_{max}+I_{min}}`$

Cette caractérisation des franges permet une **mesure comprise entre 0 et 1**, valeurs limites qui représentent les *deux cas extrêmes* :

* Pas de franges, donc **intensité uniforme** $`\Longleftrightarrow`$ $`I_{max}=I_{min}`$ $`\Longleftrightarrow`$ *$`\mathcal{V} = 0`$*.

* **Franges de visibilité maximum** $`\Longleftrightarrow`$ $`I_{min}=0`$ $`\Longleftrightarrow`$ *$`\mathcal{V} = 1`$*.

### Interférences entre deux ondes électromagnétiques monochromatiques planes

Soient **deux ondes planes** dans le vide, notées 1 et 2, de **même pulsation  $`\omega`$** et d'**amplitudes $`A_1`$ et $`A_2`$**, de **polarisations rectilignes selon  $`\overrightarrow{e_1}`$ et $`\overrightarrow{e_2}`$**, et qui *se superposent en un point M* de l'espace localisé, par rapport à un point pros comme origine de l'espace, par le vecteur $`\overrightarrow{r} = \overrightarrow{OM}`$

Ces deux ondes s'écrivent :

* _Expression en notation réelle :_

$`\overrightarrow{E_1}(\overrightarrow{r},t)
= A_1 \cdot cos (\omega t-\phi_1)\cdot \overrightarrow{e_1}`$ et
 $`\overrightarrow{E_2}(\overrightarrow{r},t)
= A_2 \cdot cos(\omega t-\phi_2)\cdot \overrightarrow{e_2}`$

* _Expression en notation complexe :_

$`\underline{\overrightarrow{E_1}}(\overrightarrow{r},t)
= A_1 \cdot e^{-i\,(\omega t-\phi_1)} \cdot \overrightarrow{e_1}
`$ et $`\underline{\overrightarrow{E_2}}(\overrightarrow{r},t)
= A_2 \cdot e^{-i\,(\omega t-\phi_2)} \cdot \overrightarrow{e_2}`$

!!!! *ATTENTION :*
!!!!
!!!! L'*écriture réelle d'une onde, seule, décrit la réalité physique mesurable de l'onde*.
!!!! Le champ réel est la partie réelle du champ complexe : $`\overrightarrow{E}(\overrightarrow{r},t)= \Re [\underline{\overrightarrow{E}}(\overrightarrow{r},t)]`$
!!!!

!! *POUR ALLER PLUS LOIN :*
!!
!! L'*onde électromagnétique plane progressive monochromatique (OPPM)* est un *concept mathématique* sans réalité. En effet, de par son expression mathématique  <!-- <br>
!! $`\overrightarrow{E}(\overrightarrow{r},t)= E_0 \cdot cos (\overrightarrow{k}.\overrightarrow{r}-\omega t)\cdot \overrightarrow{u}`$ (ici polarisée rectilignement)<br>
!! --> l'OPPM peut être définie à chaque instant, depuis des temps infinis dans le passé et jusqu'en des temps infinis dans le futur, et elle s'étend à l'infini dans tout l'espace. Et de part la densité d'énergie électromagnétique qu'elle porte, l'OPPM contient une énergie infinie.
!! <!--
!! De plus, comme en présence d'une OPPM, un volume infinitésimal $`d \tau`$ de l'espace contient l'énergie électromagnétique moyenne <br>
!! $`\langle U_{EM}\rangle = (\langle u_{E}\rangle + \langle u_{M} \rangle) \cdot d\tau`$$`=\left(\dfrac{\epsilon_0\langle E^2\rangle}{2} + \dfrac{\langle B^2\rangle}{2\mu_0}\right) \cdot d\tau`$$`=\left(\dfrac{\epsilon_0\langle E^2\rangle}{2} + \dfrac{\langle E^2\rangle}{2\,c^2\,\mu_0}\right) \cdot d\tau`$$`=\left(\dfrac{\epsilon_0\langle E^2\rangle}{2} + \dfrac{\epsilon_0\langle E^2\rangle}{2}\right) \cdot d\tau`$$`=\epsilon_0\langle E^2\rangle \cdot d\tau`$
!!
!!alors intégré sur tout l'espace, une OPPM contiendrait une énergie infinie.
!! -->
!!
!! Cela est *physiquement non réaliste*. Le champ électromagnétique est en couplage avec la distribution de charges dans l'univers. Il est créé lorsque des charges sont accélérées, se propage puis se modifie et perd au fur et à mesure de l'énergie lorsqu'il accélère des charges suite à la forcre q'il exerce sur elles.
!!
!! Cependant, le grand *intérêt du concept d' OPPM* vient du *théorème de Fourier*, qui démontre que *toute onde peut se décomposer comme une somme intégrale d'OPPM*. Ce point sera détaillé dans la suite de ce cours.

Le *champ électrique résultant* est :

* _Expression en notation réelle :_

$`\overrightarrow{E_{tot}}(\overrightarrow{r},t)
= A_1 \cdot cos (\omega t-\phi_1)\cdot \overrightarrow{e_1}
\;`$$`+\;A_2 \cdot cos (\omega t-\phi_2)\cdot \overrightarrow{e_2}`$

* _Expression en notation complexe :_

$`\underline{\overrightarrow{E}_{tot}}(\overrightarrow{r},t)
=A_1 \; e^{-i\,\omega t} \, e^{i\,\phi_1}\cdot \overrightarrow{e_1}
`$$`\;+\;
 A_2 \; e^{-i\,\omega t} \, e^{i\,\phi_2}\cdot \overrightarrow{e_2}`$
 
 $`\underline{\overrightarrow{E}}_{tot}(\overrightarrow{r},t)
= e^{-i\,\omega t}
\cdot
 [A_1 \, e^{i\,\phi_1}\cdot \overrightarrow{e_1}
`$$`+
 A_2 \, e^{i\,\phi_2}\cdot \overrightarrow{e_2}]`$
 
 L'*intensité de l'onde résultante $`I_{tot}`$* s'écrit :
 
 $`\langle I_{tot} \rangle= \epsilon_0 \,c \; ||\overrightarrow{E}||^2`$$`=\dfrac{\epsilon_0\,c}{2} \; ||\overrightarrow{E}||`$
 
 * _Calcul en notation réelle :_

$`I_{tot}= \dfrac{\epsilon_0\,c}{2} \; [A_1^2 \cdot cos^2 (\omega t-\phi_1)\cdot \overrightarrow{e_1} \cdot \overrightarrow{e_1}`$ $`\;+\;A_2^2 \cdot cos^2 (\omega t-\phi_2)\cdot \overrightarrow{e_2} \cdot \overrightarrow{e_2}`$ $`\;+\;2 \;A_1\,A_2 \cdot cos (\omega t-\phi_1)\,cos (\omega t-\phi_2)\cdot \overrightarrow{e_1} \cdot \overrightarrow{e_2}]`$


 * _Calcul en notation complexe :_

$`I_{tot}
= \dfrac{\epsilon_0\,c}{2} \; ||\overrightarrow{E}||`$$`
= \dfrac{\epsilon_0\,c}{2} \; \overrightarrow{E}\cdot \overrightarrow{E^*}`$$`
= A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1} `$$`+  A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}`$$`+2 \,A_1 \, A_2\; \overrightarrow{e_1} \cdot \overrightarrow{e_2}`$

$`\quad\quad = A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1} `$$`+  A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2} `$$`+ \,A_1 \, A_2\;e^{i(\phi_1-\phi_2)} \;\overrightarrow{e_1} \cdot \overrightarrow{e_2} `$$`+ \,A_2 \, A_1\;e^{i(\phi_2-\phi_1)} \;\overrightarrow{e_2} \cdot \overrightarrow{e_1}`$

--------------------

* Si les deux ondes ont des **polarisations rectilignes orthogonales $`(\overrightarrow{e_1} \perp \overrightarrow{e_2}) `$**, alors 

$`I_{tot}= A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1} `$$`+ A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}=I_1 + I_2`$

Il n'y a *pas interférence* entre ces deux ondes.

-----------------------

* Si les deux ondes ont des **polarisations rectilignes non orthogonales $`(\overrightarrow{e_1} \cdot \overrightarrow{e_2}) =cos \Phi `$**, telles que , alors 

$`I_{tot}=A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1}+A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}`$$`+2 \,A_1\,A_2\,cos(\phi_1 - \phi_2)=I_1 + I_2 `$$`+ \,2\,\sqrt{I_1\,I_2} \, cos(\phi_1 - \phi_2) \cdot cos \Phi`$

Un *terme d'interférence $`\,2\,\sqrt{I_1\,I_2} \, cos(\phi_1 - \phi_2) \cdot cos \Phi`$* apparait.

-------

* Si les deux ondes ont des **polarisations rectilignes dans la même direction $`(\overrightarrow{e_1} = \overrightarrow{e_2}) `$** alors  $`cos\, \Phi = 1`$  et :

$`I_{tot}= A_1^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1}+A_2^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}`$$`+2 \,A_1\,A_2\,cos(\phi_1 - \phi_2)=I_1 + I_2 `$$`+ \,2\,\sqrt{I_1\,I_2} \, cos(\phi_1 - \phi_2)`$

Le *terme d'interférence* se limite à *$`\,2\,\sqrt{I_1\,I_2} \, cos(\phi_1 - \phi_2)`$*.

------------

* Si les deux ondes ont une **même amplitude $`A`$** et des **polarisations rectilignes dans la même direction $`(\overrightarrow{e_1} = \overrightarrow{e_2}) `$** alors :

$`I_{tot}=A^2\,\overrightarrow{e_1} \cdot \overrightarrow{e_1}+A^2\,\overrightarrow{e_2} \cdot \overrightarrow{e_2}`$$`+2 \,A^2\,cos(\phi_1 - \phi_2)=2 \;I \cdot [\,1`$$`+ cos(\phi_1 - \phi_2)]`$

Ce sont les *meilleures conditions de réalisation et d'observation*.

L'**interférence** est :

* **totalement destructive** en tous les point de l'espace où les deux ondes sont en *opposition de phases*, soit  :

*$`|\phi_1 - \phi_2|=(2n+1)\,\pi`$ avec $`n \in \mathbb{Z}`$ $`\Longrightarrow cos(\phi_1 - \phi_2)=-1`$*

En ces points là * $`I_{tot}=I_{min}=0`$* , l'*intensité est nulle* et donc l'obscurité totale.

* **totalement constructive** en tous les point de l'espace où les deux ondes sont *en phase*, soit :

*$`|\phi_1 - \phi_2|=2n\,\pi`$, avec $`n \in \mathbb{Z} `$ $`\Longrightarrow cos(\phi_1 - \phi_2)=+1`$*

En ces points là, *$`I_{tot}=I_{max}= 4 \,A^2`$*.

### Interférences par N ondes de même amplitude, déphasées avec un pas constant

Soient **N ondes** de *même amplitude $`A`$* déphasées entre-elles d'un *pas constant $`\phi`$*. 

$`A_{tot}=A\,e^0\,+\,A\,e^{i\phi}\,+\,A\,e^{i\phi}\,+\,\cdot\cdot\cdot\,`$$`+\,A\,e^{i\,(N-1)\,\phi}`$

$`\quad =A\,\cdot \,(1 \,+\,e^{i\phi}\,+\,e^{i\phi}\,+\,\cdot\cdot\cdot\,`$$`+\,e^{i\,(N-1)\,\phi})`$

Le *terme entre parenthèse* forment une **progression géométrique de raison $`e^{i\phi}`$**.

! *RAPPEL :*
!
! La *somme $`S_N`$ des termes d'une suite géométrique* de *premier terme $`a`$* et de *raison  $`q`$* avec $`q \ne 0`$ et  $`q \ne 1`$ s'écrit :
!
! $`S_N=a + a\,q + a\,q^2 + a\,q^3 + \cdot\cdot\cdot `$$`+ a\,q^{N-1}`$
!
! donc
!
! $`q\,S_N= a\,q + a\,q^2 + a\,q^3 + a\,q^4 + \cdot\cdot\cdot `$$`+ a\,q^N`$
!
! et 
!
! $`q\,S_N-S_N= a\,q^N \,- a`$
!
! $`S_N\,(q-1)= a\,(q^N-1)`$
!
! *$`S_N=a \cdot \dfrac{q^N-1}{q-1}`$*
!


Si *j'applique ce résultat* concernant les suites géométriques pour calculer le terme d'**amplitude totale résultantes** de la superposition des ondes considérées, j'obtiens

$`\underline{A_{tot}}=A\cdot \dfrac{e^{i\,N\,\phi}-1}{e^{i\,\phi}-1}`$$`=\dfrac{(1-cos\,N\phi)+i\,sin\, N\phi}{(1-cos\,\phi)+i\,sin\,\phi}`$

L'**intensité résultante** est alors

$`I_{tot}=\underline{A_{tot}}\,\underline{A^*_{tot}}=|\,A^2\,|`$$`=A^2\cdot\dfrac{(1-cos^2\,N\phi)+sin^2\,N\phi}{(1-cos^2\,\phi)+sin^2\,\phi}`$

$`I_{tot}=A^2\cdot\dfrac{1-2\cos\,N\phi+cos^2\,N\phi+sin^2\,N\phi}{1-2\cos\,\phi+cos^2\,\phi+sin^2\,\phi}`$$`= A^2\cdot\dfrac{2-2\cos\,N\phi}{2-2\cos\,\phi}`$

$`I_{tot}= A^2\cdot\dfrac{1-cos\,N\phi}{1-cos\,\phi}`$

! *RAPPEL :* 
!
! Des deux relations trigonométriques de base suivantes :
!
! $`cos(a-b)=cos\,a \;cos\,b \;`$$`+\; sin\,a \;sin\,b\quad `$(1)<br>
! $`cos(a+b)=cos\,a \;cos\,b \;`$$`-\; sin\,a \;sin\,b\quad`$(2)
! 
! j'obtiens, en soustrayant (1)-(2)
! 
! $`cos(a-b)-cos(a+b)=2\; sin\,a \;sin\,b `$
!

L'identification $`a=b=\dfrac{N\,\phi}{2}`$ dans la relation $`cos(a-b)-cos(a+b)=2\; sin\,a \;sin\,b `$ conduit à

$`cos\left(\dfrac{N\,\phi}{2}-\dfrac{N\,\phi}{2}\right)-cos\left(\dfrac{N\,\phi}{2}+\dfrac{N\,\phi}{2}\right)`$$`=2\; sin\,\dfrac{N\,\phi}{2} \;sin\,\dfrac{N\,\phi}{2} `$

$`cos\,0 - cos\,N\,\phi=1 - cos\,N\,\phi `$$`=2\; sin^2\,\dfrac{N\,\phi}{2}`$

De même, l'identification $`a=b=\dfrac{\phi}{2}`$  conduit à $`1 - cos\,\phi =2\; sin^2\,\dfrac{\phi}{2}`$ .

Au total, la **distribution d'intensité en fonction du pas de déphasage  $`\phi`$** entre deux rayons consécutifs s'écrit :

**$`\mathbf{I_{tot}= A^2\cdot\dfrac{sin^2\,\dfrac{N\,\phi}{2}}{sin^2\,\dfrac{\phi}{2}}}`$**


! *IMPORTANT :*
!
! Cette *fonction $`\mathbf{\dfrac{sin^2\,\dfrac{N\,\phi}{2}}{sin^2\,\dfrac{\phi}{2}}}`$* est une *fonction fondamentale dans l'étude des réseaux de diffraction*, et nous l'appellerons ici *fonction Interférences-réseau*, notée *$`Interf_{res}`$*.
!
! Cette fonction dépend du nombre entier N d'ondes qui interfèrent et de la différence de phase cosntante $`\phi`$ entre deux ondes successives : $`Interf_{res}=Interf_{res}(N,\phi)`$
!

#### Propriétés de la fonction $`Interf_{res}`$

Le phénomène d'interférences se traduisant par l'alternance de franges sombres et brillantes, et se mesurant localement par le contraste à partir de l'intensité maximum et l'intensité minimum entre deux franges succesives, j'étudie les positions et intensités des maximum et minimum de cette fonction.

Cette fonction prendra clairement un maximum appelé **maximum principal** lorsque son *dénominateur $`sin^2\dfrac{\phi}{2}`$ s'annule*, ce qui est réalisé *aux valeurs de $`\phi`$* telles que :

 $`sin^2 \dfrac{\phi}{2} = 0 \quad\Longleftrightarrow \quad\dfrac{\phi}{2}=k\pi`$
 
 *$`\quad\Longleftrightarrow\quad \mathbf{\phi=2\,k\pi\;\quad}`$, avec $`\mathbf{k \in \mathbb{Z}}`$*.
  
Pour trouver l'intensité de ces maxima, je dois étudier la valeur de $`interf_{res}(\phi)`$ dans la limite où $`\phi`$ tend vers $`2\,k\pi`$. En ces points, le dénominateur et le numérateur de la fonction $`interf_{res}(\phi)`$ s'annulent, la valeur de la fonction est alors indéterminée. Je lève cette indétermination en calculant la limite de la fonction $`interf_{res}(\phi)`$ en ces points  $`\phi=2\,k\pi`$, en m'aidant d'un développement limité.`$

! *RAPPEL :*
!
! Soit une fonction  $`f`$ à variable réelle $`x`$, définie sur un intervalle $`U`$ de $`\mathbb{R}`$. Si cette fonction est $`k`$ fois dérivable sur $`U`$ et si sa $`k^{ième}`$ fonction dérivée, notée $`f^{(k)}`$, est continue sur $`U`$ (les mathématiciens disent alors que cette fonction est de classe $`C^k`$), alors le développement limité à l'ordre $`n\le k`$ de $`f`$ au voisinage d'un point $`x_0\in U`$ s'exprime par la formule de Taylor :<br>
! $`f(x-x_0)\;=\;f(x_0)+(x-x_0) \cdot f^{(1)}(x_0) `$$` \;+\; \dfrac{(x-x_0)^2}{2\,!} \cdot f^{(2)}(x_0) `$$`\;+\;  \dfrac{(x-x_0)^3}{3\,!} \cdot f^{(3)}(x_0) `$$`\;+\;  \cdot\cdot\cdot `$$`\;+\;  \dfrac{(x-x_0)^n}{n\,!}\cdot f^{(n)}(x_0)`$$`\;+\; o(x-x_0)`$, <br>
!où $`o(x-x_0)`$ est une fonction qui tend vers $`0`$ lorsque $`x`$ tend vers $`x_0`$ plus vite que la fonction $`x^n`$.
!
! En physique, la somme<br>
! $`f(x_0)+\sum_{i=1}^{n}\dfrac{(x-x_0)^i}{i\,! }\cdot f^{(i)}(x_0)`$ <br> réalise l'approximation à l'ordre $`n`$ de la fonction $`f `$ au point $`x`$, approximation d'autant meilleure que $`n`$ est grand :
!
! $`f(x) \simeq f(x_0)+\sum_{i=1}^{n}\dfrac{(x-x_0)^i}{i\,! }\cdot f^{(i)}(x_0)`$
!

Je pose $`x=\dfrac{N\phi}{2}`$ et je calcule les premiers termes d'un développement limité de la fonction $`f(x)=\sin^2\;x'`$ au voisinage de $`x_0=2N\,k\pi`$ :

* $`f(x_0)=sin^2(2\,k\pi)=0`$

* $`f^{(1)}(x)=\dfrac{d \sin^2 x}{d x}=2\cdot cos x \cdot sin x \quad`$<br>
$`\Longrightarrow \quad f^{(1)}(x_0) = 2\cdot cos (2\,k\pi)^2  \cdot sin (2\,k\pi)^2 =0`$

* $`f^{(2)}(x)=\dfrac{d^2\sin^2 x}{d^2 x}=\dfrac{d}{d x}\left(2\cdot cos x \cdot sin x \right)`$ 
$`=2 \;[\,cos^2 x - sin^2 x\,]\quad`$<br>
$`\Longrightarrow \quad f^{(2)}(x_0)=2 [cos (2\,k\pi)^2 -sin(2\,k\pi)^2]=2`$

Appliquer alors la formule de Taylor à l'ordre 2 me donne

$`sin^2 x=2\;\dfrac{x^2}{2}+o(x-x_0)`$

J'en déduis la limite de $`sin^2 x`$ lorsque $`x`$ tend vers $`x_0`$ ,

$`\displaystyle\lim_{x \to x_0}sin^2 x = x^2`$

et en réexprimant cette fonction avec la variable $`\phi`$, j'obtiens

$`\displaystyle\lim_{\phi \to 2\,k\pi}sin^2 \dfrac{N\phi}{2}=\dfrac{N^2\phi^2}{4}`$

De même, la valeur $`N=1`$ me donne $`\displaystyle\lim_{\phi \to 2 k\pi}sin^2 \dfrac{\phi}{2}=\dfrac{\phi^2}{4}`$.

AInsi les **maxima principaux** de la fonction $`Interf_{res}`$ ont pour *valeur unique*  :

$`Interf_{res}(2 k\pi)=\displaystyle\lim_{\phi \to 2 k\pi}\dfrac{sin^2 \dfrac{N\phi}{2}}{sin^2 \dfrac{\phi}{2}}`$
$`=\dfrac{\dfrac{N^2\phi^2}{4}}{\dfrac{\phi^2}{4}}`$

*$` \mathbf{ Interf_{res}(2 k\pi)=N^2 }`$*

! *IMPORTANT :* 
!
! Les *maxima principaux de la fonction Interférences-réseau* ont une *même intensitéqui croît comme $`N^2`$*, carré du nombre d'ondes qui interfèrent.
!
 
**Entre ces maxima principaux**, la fonction Interférence-réseau possède **plusieurs
minima nuls** localisés aux valeurs de $`\phi`$ pour lesquelles le numérateur de la 
fonction s'annule, soient *aux valeurs* 

$`sin^2 \dfrac{N\phi}{2} = 0 \quad\Longleftrightarrow \quad\dfrac{N\phi}{2}=k\pi`$

*$`\quad\Longleftrightarrow\quad\mathbf{\phi=\dfrac{2 k\pi}{N}}\quad`$, avec 
$`\mathbf{k \in \mathbb{N}}`$*.

Ainsi **entre deux maximas principaux** se trouvent *$`N-1`$ minima* de valeur nulle,
séparés par *$`N-2`$ maxima secondaires*.

Le premier minimum nul jouxtant un maximum principal situé en $`\phi=2 k\pi`$ (maximum 
principal d'ordre k) est localisé en $`\phi=2 k\pi+\dfrac{2\pi}{N}`$. Ce déphasage
$`\dfrac{2\pi}{N}`$ entre un maximum principal et le premier munimum nul est un bon
critère pour quantifier la largeur d'un maximim principal. 

! *IMPORTANT :* 
!
!  La *largeur d'un pic principal*, quantifiée par la valeur du déphasage séparant le maximum du pic du premier minimum nul, est *proportionnelle à $1/N$*, inverse du nombre des ondes qui interfèrent.
!

#### Représentation de la fonction $`Interf_{res}`$

* $`N=1 \Longrightarrow`$ amplitude et intensité de l'onde uniforme : pas d'interférences.


* $`N=2 \Longrightarrow`$ amplitude set intensité de l'onde uniforme : interférences à deux ondes.

<!--![](interferences_intensity-seule_N2_L1200.jpg)-->

Faisons croître le nombre $`N`$ des ondes qui interfèrent, et observons :

![](aef_interf_1224.jpg)

![](aef_interf_2358.jpg)

<!--![](interferences_intensity-seule_N5_L1200.jpg)-->

<!--![](interferences_intensity-seule_N20_L1200.jpg)-->

<!-- pour le site, sera en .gif
 ![](interferences_N2-24_L1200.gif) -->


### Pour prendre un peu d'avance :

Après l'études des phénomènes d'interférences et de diffraction, je regarderai quelques situations physiques simples ou quelques éléments optiques qui réalisent ces phénomènes. Le cours se construit.

Mais déjà, je verrai qu'une façon d'obtenir de telles interférences est d'illuminer un réseau de diffraction avec une onde (je préciserai les conditions).

Dans ce cas, lors de l'observation de la lumière à l'infini dans une direction donnée, la différence de phase $`\phi`$ entre deux ondes est fonction de la longueur d'onde selon l'expression :

$`\phi=\dfrac{2 \pi \, \delta}{\lambda}`$.

Deux longueurs d'onde différentes donneront deux systèmes de franges différentes, qui se superposeront.

Je regarde bien les figures suivantes, pour comprendre visuellement le phénomène observé. Cela donne une première piste pour décomposer une lumière polychromatique en ses différentes composantes. 

![](aef-reseau.jpg)

<!--![](reseau-intensity-N2_L1200.jpg)![](reseau-intensity-N3_L1200.jpg)-->

<!--![](reseau-intensity-N4_L1200.jpg)![](reseau-intensity-N5_L1200.jpg)-->

<!--![](reseau-intensity-N8_L1200.jpg)![](reseau-intensity-N12_L1200.jpg)-->

<!--![](reseau-intensity-N16_L1200.jpg)![](reseau-intensity-N24_L1200.jpg)-->

<!-- pour le site, sera en .gif
 ![](reseau-intensity_L1200.gif) -->

Et une première compréhension des ordres de travail d'un réseau de diffraction :

![](aef-ordre.jpg)

<!--![](reseau-order-N8_L1200.jpg)  ![](reseau-order-N16_L1200.jpg)-->

<!-- pour le site, sera en .gif
 ![](reseau-order-N8-16_L1200.gif) -->

### Le phénomène de diffraction

Lorsqu'un faisceau de lumière parallèle éclaire un écran opaque percé d'une toute petite ouverture, et que j'étudie l'éclairement de la lumière transmise sur un second écran suffiamment loin du premier, je remarque que les dimensions de la tâche lumineuse observée ne correspondent pas à l'ombre portée de l'ouverture. Si un faisceau de lumière tombe sur une fente très fine d'épaisseur variable, l'ouverture angulaire du faisceau augmente à la traversée de la fente lorsque la largeur de la fente diminue.

Ce phénomène montre que *la lumière est déviée lors de son passage au voisinage d'ouvertures ou d'obstacles de tailles caractéristiques proches de la longueur d'onde* de la lumière, c'est le **phénomène de diffraction** de la lumière.

Ce phénomène est *inexplicable dans le cadre de l'optique des rayons (optique géométrique)* qui postule que la lumière se propage en ligne droite dans un milieu homogène et isotrope comme le vide ou l'air.

#### Le principe de Huygens-Fresnel

Le **principe de Fresnel-Huygens** stipule que :

* *chaque point d'un front d'onde génère une onde sphérique*, l'enveloppe de ces ondes sphériques secondaires constituant un nouveau front d'onde (contribution d'Huygens).

* Ces **sources sphériques secondaires d'un même front d'onde** sont *mutuellement cohérentes*. L'**amplitude complexe** de l'onde lumineuse **résultante** en tout point d'observation est la *somme des amplitudes complexes de toutes ces sources secondaires* (contribution de Fresnel).

<br>

-----

Pour *visualiser le principe de Huygens-Fresnel* à l'aide d'un **écran plan et opaque**, éclairé par une **onde plane monochromatique sous incidence normale** :

* L'écran est percé d'une **simple ouverture infinitésimale**, l'*onde transmise* est alors une *onde sphérique centrée sur l'ouverture*de *même longueur d'onde* que celle de l'onde incidente. Il y a *continuité de la phase de l'onde à la traversé* de l'ouverture infinitésimale.

![](Huygens-Fresnel-principle-1point-1spherical-wave.jpg) 

* L'écran est percé d'une **ouverture étendue** , *chacun des points* de l'ouverture plane est *source d'une onde sphérique secondaire* qui contribuera à l'onde transmise. Il y a *continuité de la phase* de l'onde *à la traversée de chaque point* de l'ouverture étendue.

![](Huygens-Fresnel-principle-1aperture-1D-1a-1b-1d_spherical-wave.gif)

* L'**onde transmise** est la *résultante de l'infinité des ondes secondaires sphériques* émises par chacun des points de l'ouverture plane étendue.

![](Huygens-Fresnel-principle-1aperture-1D-addition_multi_spherical-wave.gif)<br>
_*ATTENTION* ; L'animation proposée ici illustre schématiquement le principe que tu reconstruis l'onde diffractée en faisant l'intégrale des contributions de l'infinité des sources sphériques secondaires. Mais la figure de diffraction finale obtenue est fausse, car seules quelques ondes sphériques ont été prises en compte dans l'image finale. Seul le calcul de l'amplitude puis de l'intensité résultantes en chaque point te permettra de connaitre l'onde transmise.*[Contribution pour une animation schématique plus réaliste bienvenue]*_

! *REMARQUE :* 
!
! Ainsi, l'étude du *phénomène de diffraction* se ramène à l'étude des *interférences créés par une infinité d'ondes élémentaires*, issues des sources secondaires uniformémenr réparties sur les pupilles.
!

---
<!-- pour le site, sera en .gif
 ![](reseau-order-N8-16_L1200.gif) -->


#### Description mathématiques du phénomène de diffraction à travers une pupille rectangulaire.

Je me limite au cas d'une pupille rectangulaire, éclairée sous incidence normale par une onde plane monochormatique de longueur d'onde $``\lambda`$.

! *IMPORTANT :*
!
! La *longueur d'onde $`\lambda`$*, caractérisant la période spatiale de l'onde, n'est *pas une grandeur fondamentale* de l'onde. Seules le grandeurs temporelles de l'onde comme la période temporelle $`T`$, sa fréquence (temporelle) $`\nu`$ ou sa pulsation $`\omega`$ sont des fréquences fondamentales car indépendantes du mileu de propagation de l'onde. À fréquence $`\nu`$ donnée, la longueur d'onde $`\lambda`$ *dépend de la vitesse de propagation* de l'onde $`v`$ selon la relation $`\lambda=v/\nu`$. Dans le cas de la lumière et plus généralement d'une onde électomagnétique, la *longueur d'onde considérée sera toujours la longueur d'onde dans le vide*.
!

Pour étudier le ohénomène de diffraction, je choisis le **repère cartésien 
$`(O, \overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$** tel que :
* l'**origine $`O`$** soit prise *au centre de la pupille* rectangulaire.
* l'**onde plane incidente** se propage en *direction et sens du vecteur $`\overrightarrow{e_z}`$`*.
* les **côtés de la pupille** rectangulaire sont dirigés *selon les vecteurs $`\overrightarrow{e_x}`$ et $`\overrightarrow{e_y}`$*.

Les **dimensions de la pupille** rectangulaire est *$`x_0`$ selon $`Ox`$* et *$`y_0`$ selon $`Oy`$*.

Les sources secondaires émettant les ondes sphériques sont distribuées uniformément sur toute la surface de la pupille.

D'une manière générale, le calcul de l'intensité diffractée en un point $`M(x,y,z)`$ de l'espace repéré par le vecteur $`\overrightarrow{OM} =\overrightarrow{r} = r\cdot\overrightarrow{u}`$ situé dans le demi-espace $`(z>0)`$ se conduit en évaluant :
* la différence $`\Delta s`$ entre la distance $`PM`$ (distance de la source secondaire de surface élémentaire $`dS`$ située au point $`P`$ et le point $`M`$ et la distance $`OM`$ :<br>
**$`\Delta s=PM-OM`$**
*  la différence de chemin optique $`\delta`$ corespondante :<br> 
**$`\delta=n\cdot\Delta s`$**<br> 
où $`n`$ est l'indice de réfraction caractérisant le milieu de propagation. Pour l'air et le vide,  $`n=1`$`.
* la différence de phase au point $`M`$ entre l'onde émise par la source secondaire en $`P`$ et celle émise par source secondaire située à l'origine $`O`$, prise comme référence des phases :<br>
**$`\phi=\dfrac{2\pi\delta}{\lambda}`$**

La contribution $`\underline{dA}`$ (à un coefficient de proportionnalité près) d'une surface élémentaire $`dS`$  de la pupille $`\mathscr{P}`$  l'amplitude complexe totale au point M s'écrit :

* **$`\underline{dA}=e^{i\,\phi} dS`$**

L'amplitude complexe totale et l'intensité de l'onde diffractée  se déduisent alors simplement 

* **$`\displaystyle\underline{A}=\iint_{\mathscr{P}}\underline{dA}=\iint_{\mathscr{P}} e^{i\,\phi} dS`$**

* $`I_{tot}=\underline{A}\,\underline{A}^{*}=|\,A^2\,| `$



#### Diffraction en champ lointain

**Diffraction en champ lointain** =**Diffraction à l'infini** =  **Diffraction de Fraunhofer**

Un *cas particulièrement intéressant* est le calcul de la diffraction en champ lointain. 

En pratique, cela correspond à calculer ou à observer la figure dans un **plan d'observation placé suffisamment loin de la pupille** $\mathscr{P}`$`de façon à ce que  les ondes sphériques secondaires puissent être approximées par des ondes planes au niveau du plan d'observation. Il faut pour cela que les rayons de courbure des ondes sphériques secondaires au niveau de l'écran d'observation soient très grands devant les dimensions de l'écran. La distribution d'intensité à l'infini est aussi réalisée (à un facteur d'échelle près) dans le **plan focal image d'une lentille convergente**.

La condition de validité est que distance $`d`$ entre la pupille et le plan d'observation vérifie le **critère $`d\gg a^2/\lambda`$**, où a est la plus grande longueur de la pupille.

<!--
!!! Exemple : 
-->

--------

J'étudie la diffraction en champ lointain dans une **direction données par le vecteur unitaire $`\overrightarrow{u}`$** :<br>
$`\overrightarrow{u}=u_x\cdot\overrightarrow{e_x}\;+\;
u_y\cdot\overrightarrow{e_y}\;+\;u_z\cdot\overrightarrow{e_z}`$<br>
<!--ANCIEN==================================
$`\overrightarrow{u}=(\overrightarrow{u}\cdot\overrightarrow{e_x})\;\overrightarrow{e_x}+
+(\overrightarrow{u}\cdot\overrightarrow{e_y})\;\overrightarrow{e_y}
+(\overrightarrow{u}\cdot\overrightarrow{e_z})\;\overrightarrow{e_z}`$<br>
$`\overrightarrow{u}=(cos \;\theta_x\cdot\overrightarrow{e_x}+
+cos \;\theta_y\cdot\overrightarrow{e_y}
+cos \;\theta_z\cdot\overrightarrow{e_z}`$<br>
Les angles *$`\theta_x`$ et $`\theta_y`$ caractérisent la direction d'observation*.
===========================================-->

Pour une *source secondaire* située en un **point P de coordonnées $`(x_P, y_P, 0)`$** de la pupille, que le point M d'observation se situe à très grande distance ou dans le plan focal image d'une lentille convergente, la distance algébrique $`\overline{OH}=PM-OM`$ s'exprime très simplement comme le produit scalaire $`\overrightarrow{OP}\cdot\overrightarrow{u}`$ :

**$`\overline{OH}=PM-OM=\overrightarrow{OP} \cdot\overrightarrow{u}`$
$`=u_x\cdot x_P\;+\;u_y\cdot y_P`$**

Si la **lumière se propage dans l'air** d'indice de réfraction *$`n=1`$*, la différence de chemin optique $`\delta_P`$ et la différence de phase $`\phi_P`$ caractérisant cette source secondaire s'écrivent :

**$`\delta=n\cdot(u_x\cdot x_P\,+\,u_y\cdot y_P)`$**

**$`\phi=\dfrac{2\,\pi\,\delta}{\lambda}= \dfrac{2\,\pi\,n\,(u_x\, x_P\;+\;u_y\, y_P)}{\lambda}`$**

L'amplitude complexe totale en M (à un facteur multiplicatif près) s'exprime alors 

**$`\displaystyle\underline{A}=\iint_{\mathscr{P}} e^{\dfrac{i\,2\,\pi\,n\,(u_x\,x\,+\,u_y\,y)}{\lambda}}\;dx\,dy`$**

!! *POUR ALLER PLUS LOIN :*
!!
!! Ce résultat se généralise au cas où la *pupille* introduit en chacun de ses points une différence de phase et une absoprtion variables, caractérisées par une fonction de *transmittance complexe $`t(x,y)`$ appelée fonction pupillaire*. 
!!
!! L'*amplitude complexe diffractée* s'écrit alors :<br>
!! *$`\displaystyle\underline{A}=\iint_{\mathscr{P}} t(x,y)\;e^{\dfrac{i\,2\,\pi\,n\,(u_x\,x_P\,+\,u_y\,y_P)}{\lambda}}\;dx\,dy`$*<br>
!! Je reconnais ici la *transformée de Fourier de la fonction pupillaire*.
!!
!! Ce résultat est repris et développé dans ce qui constitue l'*Optique de Fourier*. L'optique de Fourier est un *outil puissant* pour la compréhension et la maîtrise entre autre du *filtrage optique* et de l'*holographie*. 
!!
!! L'holographie permet l'enregistrement 2D et la reconstruction 3D d'ondes optiques. Elle permet de reconstituer une scène en vrai relief, contrairement aux diverses techniques de cinéma 3D actuelles. En vraie 3D, l'angle de vision sous lequel un spectateur observe l'image 3D reconstituée d'un objet change lorsque le spectateur se déplace.
!!

##### Calcul 2D de l'intensité diffractée et de la figure de diffraction

Je calcule d'abord l'intensité diffracté dans le cas 2D, où l'onde incidente se propage en direction et sens du vecteur $`\overrightarrow{e_z}`$ et où la pupille centrée en $`O`$ et de dimension $`x_0`$ est parallèle au vecteur $`\overrightarrow{e_x}`$

![](diffraction-aperture-1D-Fraunhofer-infinity-with-waves.jpg) 

L'amplitude complexe totale en M (à un facteur multiplicatif près) se limite alors à

**$`\displaystyle\underline{A}=\int_{\mathscr{P}} e^{\dfrac{i\,2\,\pi\,u_x\,x}{\lambda}}\;dx`$$\displaystyle=\int_{-x_0/2}^{+x_0/2}  e^{\dfrac{i\,2\,\pi\,u_x\,x}{\lambda}}\;dx`$**

$`\displaystyle \underline{A}=\dfrac{\lambda}{i\,2\,\pi\,u_x}\left(e^{\dfrac{i\,\pi\,u_x\,x_0}{\lambda}}-\;e^{\dfrac{-i\,\pi\,u_x\,x_0}{\lambda}}\right)`$

$`\displaystyle \underline{A}=-i\; \dfrac{\lambda}{i\,2\,\pi\,u_x}\left[ \left(cos\;\dfrac{\pi\,u_x\,x_0}{\lambda}+i\;sin\dfrac{\pi\,u_x\,x_0}{\lambda}\right)\right.`$$`\left.-\left( cos\;\dfrac{\pi\,u_x\,x_0}{\lambda}-i\;sin\;\dfrac{\pi\,u_x\,x_0}{\lambda}\right)\right]`$

$`\displaystyle \underline{A}=-i\; \dfrac{\lambda}{2\pi,u_x} \left( 2\,sin \;\dfrac{\pi\,u_x\,x_0}{\lambda}\right)`$

Je réécris ce résultat sous la forme usuelle

$`\displaystyle \underline{A}=-i\; x_0\cdot\dfrac{sin\,\dfrac{\pi\,u_x\,x_0}{\lambda}}{\dfrac{\pi\,u_x\,x_0}{\lambda}}`$

<!--ANCIEN================================
$`\displaystyle \underline{A}=\int_{-\delta_0/2}^{+\delta_0/2} A \cdot exp \;\left(i\cdot\dfrac{2\pi\delta}{\lambda}\right) \cdot d\delta`$$`\;=A\cdot\dfrac{\lambda}{2\pi}\left[exp \;\left(i\cdot\dfrac{2\pi\delta}{\lambda}\right)\right]_{-\delta_0/2}^{+\delta_0/2}`$
$`=A\cdot\dfrac{\lambda}{2\,\pi\,\theta}\left[e^{\left(i\cdot\dfrac{\pi\,sin\,\theta\,x_0}{\lambda}\right)-exp \;\left(-i\cdot\dfrac{\pi\delta_0}{\lambda}\right)\right]`$
$`=A\cdot \dfrac{\lambda}{2\pi} \left[ \left(cos\;\dfrac{\pi\delta_0}{\lambda}+i\;sin\dfrac{\pi\delta_0}{\lambda}\right)\right.`$$`\left.-\left( cos\;\dfrac{\pi\delta_0}{\lambda}-i\;sin\;\dfrac{\pi\delta_0}{\lambda}\right)\right]`$
$`=A\cdot\dfrac{\lambda}{2\pi} \left( 2\,sin \;\dfrac{\pi\delta_0}{\lambda}\right)`$
Je réécris ce résultat sous la forme usuelle
$`=A\,\delta_0\cdot\dfrac{sin\,\dfrac{\pi\delta_0}{\lambda}}{\dfrac{\pi\delta_0}{\lambda}}`$
===============================================-->

qui fait apparaître la **fonction sinus cardinal**, notée **$`sinc\;u`$** et définie par 

**$`sinc\;u = \dfrac{sin\;u}{u}`$**.

L'*intensité diffractée à l'infini* en direction du vecteur unitaire $`\overrightarrow{u}`$, faisant un angle $`\theta`$ par rapport à l'axe $`O`$ est alors (*à un facteur multiplicatif près*) :

**$`I=x_0^2\cdot \dfrac{sin^2\,\left( \dfrac{\pi\,u_x\,x_0}{\lambda} \right)}{\left( \dfrac{\pi\,u_x\,x_0}{\lambda} \right)^2}`$$`\quad=x_0^2\cdot sinc^2\left( \dfrac{\pi\,u_x\,x_0}{\lambda} \right)`$**

---------

Je souhaite exprimer l'intensité diffractée à l'infini en fonction de l'angle $`\theta`$ qui caractérise mieux visuellement la direction d'observation dans cette étude 2D

![](diffraction-aperture-1D-Fraunhofer-infinity.jpg) 

Je remarque que

$` \overrightarrow{u}=u_x\cdot\overrightarrow{e_x}\;+\; u_z\cdot\overrightarrow{e_z}`$
$`=\;sin\,\theta\cdot\overrightarrow{e_x}\;+\;cos\,\theta\cdot\overrightarrow{e_z}`$

et l'intensité diffractée à l'infini se réécrit

$`I(\theta)=x_0^2\cdot \dfrac{sin^2\,\left( \dfrac{\pi\,x_0\,sin\,\theta}{\lambda} \right)}{\left( \dfrac{\pi\,x_0\,sin\,\theta}{\lambda} \right)^2}`$$`\quad=x_0^2\cdot sinc^2\left( \dfrac{\pi\,x_0\,sin\,\theta}{\lambda} \right)`$



---------------------------------

J'observe maintenant la figure de diffraction à l'infini dans le plan focal image d'une lentille convergente.

![](diffraction-aperture-1D-Fraunhofer-image-focal-plane-convergent-lens.jpg) 

J'utilise la lentille de distance focale image $`f'`$ dans les conditions de Gauss. Je choisis un repère de l'espace $`(S, \overrightarrow{e_X}, \overrightarrow{e_Z})`$ tel que

* $`\overrightarrow{e_X}= \overrightarrow{e_x}\quad`$ et $`\quad\overrightarrow{e_Z}= \overrightarrow{e_z}`$

* Les points $`O`$ et $`S`$ sont alignés sur l'axe $`Oz`$

La lentille est centré en $`S`$ et l'axe $`Oz`$ est son axe optique.

Les lois de l'optique géométrique me disent que l'onde diffractée observée à l'infini dans la direction donnée par l'angle $`\theta`$ convergera en un point se coordonnée $`X=f'\cdot \theta`$.

! *RAPPEL :*
!
! L'expression géométrique exacte est $`X=f'\cdot tan \,\theta`$, mais dans les conditions de Gauss, l'angle $`\theta`$ reste petit, et les approximations utilisées en optique géométrique <br>
! $`\quad\theta\;\simeq\;sin\,\theta\;\simeq\;tan\,\theta\quad`$ lorsque $`\theta`$ est exprimé en radians, <br>
! sont alors valables.
!

L'intensité observée au point de coordonnée  $`X`$ est l'intensité diffractée à l'infini (à un facteur près) par la pupille dans la direction $`\theta`$ , et sont expression est 

$`I(X)=x_0^2\cdot \dfrac{sin^2\,\left( \dfrac{\pi\,x_0\,X}{\lambda\,f'} \right)}{\left( \dfrac{\pi\,x_0\,X}{\lambda\,f'} \right)^2}`$$`\quad=x_0^2\cdot sinc^2\left( \dfrac{\pi\,x_0\,X}{\lambda\,f'} \right)`$



##### Propriétés et représentation des fonctions $`sinc`$ et $`sinc^2`$

! *IMPORTANT :*
!
! La *fonction sinus cardinale *$`sinc\;\phi = \dfrac{sin\;\phi }{\phi }`$* et *son carré $`sinc^2`$* sont deux *fonctions fondamentales* qui interviennent *dans tous les phénomènes ondulatoires* en physique.
! 

* Ces fonctions  $`sinc \;\phi`$ et $`sinc^2\;\phi `$ présentent chacune un **maximum principal unique**  lorsque lorsque leurs dénominateurs s'annulent, à l'*origine des phase $`\phi=0`$*. La valeur de ce maximum unique est l'unité :<br>
$`sinc\;0\;=\;1\quad`$  et   $`\quad sinc^2 \;0 \;= \;1`$

* Ces fonctions  $`sinc \;\phi`$ et $`sinc^2\;\phi `$ **s'annulent** lorsque *$`\phi=0 \Longleftrightarrow \phi=k\;\pi`$*.

* La valeur des pics secondaires de la fonction $`sinc^2`$ décroissent très rapidement avec la valeur entière de k. 

![](function-sinc-sinc2_L1200.jpg)

##### Calcul 3D de l'intensité diffractée et de la figure de diffraction

L'intensité diffracté dans le cas 3D s'obtient très facilement si le calcul 2D est fait. 
L''onde incidente se propage en direction et sens du vecteur $`\overrightarrow{e_z}`$ et où la pupille centrée en $`O`$ et de dimensions $`x_0`$ selon le vecteur $`\overrightarrow{e_x}`$ et  $`y_0`$ selon le vecteur $`\overrightarrow{e_y}`$

<!--========
Pas encore de figure faite ici
![](diffraction-aperture-1D-Fraunhofer-infinity-with-waves.jpg) 
===========-->

L'amplitude complexe totale en M (à un facteur multiplicatif près) se limite alors à

**$`\displaystyle\underline{A}=\iint_{\mathscr{P}} e^{\dfrac{i\,2\,\pi\,(u_x\,x+u_y\,y)}{\lambda}}\;dx`$$\displaystyle `$**

**$`\displaystyle\underline{A}=\int_{-x_0/2}^{+x_0/2}  e^{\dfrac{i\,2\,\pi\,u_x\,x}{\lambda}}\;dx\;\int_{-y_0/2}^{+y_0/2}  e^{\dfrac{i\,2\,\pi\,u_y\,y}{\lambda}}\;dy`$**

L'intensité diffractée apparait comme le produit de deux intégrales identiques à celle déjà calculée, j'obtiens donc :

$`\displaystyle \underline{A}=- \; x_0\; y_0\cdot\dfrac{sin\,\dfrac{\pi\,u_x\,x_0}{\lambda}}{\dfrac{\pi\,u_x\,x_0}{\lambda}}\cdot\dfrac{sin\,\dfrac{\pi\,u_y\,y_0}{\lambda}}{\dfrac{\pi\,u_y\,y_0}{\lambda}}`$

---------------------------------

J'observe maintenant la figure de diffraction à l'infini dans le plan focal image d'une lentille convergente de distance focale image $`f'`$ utilisée dans les conditions de Gauss. Je choisis un repère de l'espace $`(S, \overrightarrow{e_X}, \overrightarrow{e_Y} \overrightarrow{e_Z})`$ tel que

* $`\overrightarrow{e_X}= \overrightarrow{e_x}\quad`$ et $`\quad\overrightarrow{e_Z}= \overrightarrow{e_z}`$

* Les points $`O`$ et $`S`$ sont alignés sur l'axe $`Oz`$

La lentille est centré en $`S`$ dans le plan $`XOY`$ et l'axe $`Oz`$ est son axe optique.

L'intensité observée au point de coordonnées  $`(X,Y)`$ s'écrit :

$`I(X)=x_0^2\;y_0^2\cdot sinc^2\left( \dfrac{\pi\,x_0\,X}{\lambda\,f'} \right)\cdot sinc^2\left( \dfrac{\pi\,y_0\,Y}{\lambda\,f'} \right)`$

#### Propriétés et représentation de l'intensité diffractée

Si je dois décrire la figure de diffraction observée, j'obtiens

![](diffraction-rectangular_L600.jpg)

* Un **maximum central unique**, rectangulaire et *allongé* dans la *direction où la fente  a sa plus petite dimension*. ce maximum est *très intense* car il est le produit des maxima principaux selon les directions $`X`$ et $`Y`$.

* **Sur chacun des axes  $`SX`$ et $`SY`$** j'observe une *série de maxima secondaires d'intensité*, équivalente à celle calculée dans le cas 2D. Chaque maximum secondaire est alors le produit des maxima secondaires de l'axe considéré par le maximum principal de l'axe perpendiculaire à celui-ci.

* **Hors des axes $`X`$ et $`Y`$**, il existe des *maxima tertiaires*, mais d'intensités si faible qu'ils sont *quasiment invisible à l'oeil humain*.<br><br>
Le **motif en croix** résultant vient du fait que l'intensité totale est le produit des fonctions $`sinc^2`$ dans les deux directions $`X`$ et $`Y`$. En dehors des axes $`X`$ et $`Y`$, les *maxima tertiaire d'intensité* résultent du *produit de deux maxima secondaires* selon chacun des axes $`X`$ et $`Y`$. Chaque maxima secondaire ayant une intensité déjà faible par rapport à maximum principal, le produit de deux maxima secondaires devient très faible, et les *maxima tertiaires hors axes* sont *quasi-invisibles*.

<!--====ANCIENNE ECRITURE=======================
puis son complexe conjugué, 
$`\underline{A_{tot}^*}`$
$`=A\cdot\dfrac{\lambda}{2\pi}\left[ exp \;\left(-i\cdot\dfrac{\pi\delta_0}{\lambda}\right)-exp \;\left(+i\cdot\dfrac{\pi\delta_0}{\lambda}\right)\right]`$
$`I_{tot}`$ en fonction de la différence de chemin optique $`\delta`$
$`I_{tot}=\underline{A_{tot}}\,\underline{A_{tot}^{*}}`$
$`I_{tot}=A^2\cdot\dfrac{\lambda^2}{4\pi^2}
\left[exp \;\left(i\cdot\dfrac{\pi\delta_0}{\lambda}\right)-exp \;\left(-i\cdot\dfrac{\pi\delta_0}{\lambda}\right)\right]`$
$`\cdot
\left[ exp \;\left(-i\cdot\dfrac{\pi\delta_0}{\lambda}\right)-exp \;\left(+i\cdot\dfrac{\pi\delta_0}{\lambda}\right)\right]`$
$`I_{tot} =\dfrac{A^2\lambda^2}{4\pi^2} \cdot
 \left( e^{i\dfrac{\pi\delta_0}{\lambda}}-e^{- i\dfrac{\pi\delta_0}{\lambda}} \right) `$
 $`\cdot \left( e^{-i\dfrac{\pi\delta_0}{\lambda}}-e^{ i\dfrac{\pi\delta_0}{\lambda}} \right) `$
 $`I_{tot} =\dfrac{A^2\lambda^2}{4\pi^2} \cdot
 \left( e^{i\,0}-e^{ 2i\dfrac{\pi\delta_0}{\lambda}} -e^{ -2i\dfrac{\pi\delta_0}{\lambda}}+e^{i\,0}\right) `$
 $`I_{tot} =\dfrac{A^2\lambda^2}{4\pi^2} \cdot
 \left[ 2- \left( e^{ i\dfrac{2\pi\delta_0}{\lambda}} +e^{ -i\dfrac{2\pi\delta_0}{\lambda}}\right)\right] `$
 $`I_{tot} =\dfrac{2\,A^2\lambda^2}{4\pi^2} \cdot
 \left( 1-cos\,\dfrac{2\pi\delta_0}{\lambda}\right)`$
 $`I_{tot} =\dfrac{2\,A^2\lambda^2}{4\pi^2} \cdot
 \left( 2\,sin^2\,\dfrac{2\pi\delta_0}{\lambda}\right)`$
 $`I_{tot} =\dfrac{A^2\lambda^2}{4\pi^2} \cdot
 \left( 2-2 e^{i\dfrac{\pi\delta_0}{\lambda}}\cdot e^{- i\dfrac{\pi\delta_0}{\lambda}} \right) `$
 
=================================-->

### Description mathématiques du phénomène de diffraction à travers une ouverture circulaire

L'étude du phénomène de **diffraction par une ouverture circulaire** est *très important* ppur deux raisons complémentaires :

* Les **instruments optiques** comme les *objectifs* des appareils photo, les *microscopes*, les *télescopes*, utilisent des éléments optiques simples circulaires (lentilles, miroirs), et plus généralement présentent la *symétrie de révolution* et voient leurs *faisceaux de lumière incidente limités par des ouvertures circulaires*. 

* le **phénomène de diffraction** *dégrade l'image obtenue* par ces systèmes, par rapport à ce qui est attendu en ne considérant que la simple optique géométrique. Ainsi l'**image d'une source située à l'infini** n'est *pas ponctuelle* dans le plan focal image de l'instrument, mais une ***tache, appelée tache d'Airy**, *dont le diamètre dépend de l'instrument* et de la longueur d'onde de la lumière observée.

#### Diffraction en champ lointain

<!--=============================
C'est le cas le plus intéressant concernant l'étude de la diffraction par une ouverture circulaire. En effet chacun des instruments optiques cités précédemment est souvent utilisé avec un capteur matriciel placé dans son plan focal. C'est dans ce plan qu'est réalisé la tache d'Airy, figure de diffraction en champ lointain de la pupille circulaire instrumentale.
===============================-->

Conduire les **calculs mathématiques** pour une ouverture circulaire sont *semblables à ce qui a été fait* dans le cas de l'ouverture rectangulaire, mais je rencontrerai *non pas une fonction sinus cardinale* facile à calculer, *mais* une fonction spéciale appelé *fonction de Bessel de premier ordre* dont les valeurs sont tabulées et qui donc est moins facile à manipuler.

Ainsi la description mathématique de la figure de diffraction en champ lointain due à une ouverture circulaire, que je peux observer dans le plan focal image d'une lentille convergente s'exprime (à un facteur multiplicatif près) :

$`I(X,Y)=I_0\;\left( 2\cdot \dfrac{J_1 \left( \dfrac{\pi\,D}{\lambda}\;\dfrac{\sqrt{X^2+Y^2}}{f'}\right)}{\dfrac{\pi\,D}{\lambda}\;\dfrac{\sqrt{X^2+Y^2}}{f'}}\right)^2`$

où D est le diamètre de l'ouverture circulaire

$`J_1`$ est la fonction de Bessel de première espèce définie comme 

$`\displaystyle J_1(u)=\dfrac{-i}{2\,\pi}\;\int_0^{2\pi} e^{i\;u\,cos\,\phi} \; e^{i\,\phi} \; d\phi`$

Ainsi exprimée, l'**intensité observée $`I(X,Y)`$** dans le plan focal image décrit une *tache centrale très brillante* entourée d'*anneaux concentriques d'intensités* bien plus faibles et *décroissantes* lorsque la distance au centre croît. La tache centrale est les anneaux sont séparés par une extinction lumineuse. Cette figure de diffraction en champ lointain de l'ouverture circulaire,  **tache d'Airy**, joue un *rôle fondamentale dans la limite de résolution* des instruments optiques.

#### Propriétés et représentation de la tache d'Airy

Si je dois décrire la tache d'Airy, j'obtiens

* un **maximum principal unique centré sur l'origine**
 
* un **premier anneau d'extinction** (intensité nulle) de *rayon $`R_0`$*$`=\sqrt{X_0^2+Y_0^2}`$ d'expression<br>
<br>
**$`R_0=1,22\;\dfrac{\lambda\;f'}{D}`$**

* une **succession d'anneaux d'extinction** *séparés par des anneaux moins sombres*. Les rayons normalisés $`R\,/\,(\lambda f'/D)`$ et les intensités relatives correspondantes $`I(R)\,/\,I_0`$ des 6 premiers maxima et minima sont <br>
<br>
![](tabulation-intensity-airy-400.jpg)

La dépendance du rayon $`R_0=1,22\;\dfrac{\lambda\;f'}{D}`$ en fonction de la longueur d'onde $`\lambda`$ et de l'inverse du diamètre $`1\,/\;D`$ implique deux faits importants :

* La *dépendance en $`1\,/\;D`$* implique que **plus grand sera la diamètre** d'ouverture d'un système optique, **meilleure sera la résolution** de l'image qu'il rendra.<br>
<br>


!! *POUR ALLER PLUS LOIN :*
!!
!! Ainsi * en astronomie, augmenter le diamètre d'un télescope*, certes,  *augmente la puissance lumineuse interceptée* par celui-ci et donc la *sensibilité* du télescope, sont aptitude à observer des objects des objets moins lumineux ou plus lointains dans l'univers, mais aussi cela *augmente  la résolution des images* des objets observées, de discerner de nouveaux détails ou encore de séparer des sources angulairement très proches (voir critère de Rayleight).
!!
!! En *microscopie optique*, lors de la conception d'un microscpe il faut que *le grossissement prévu* par la sélection d'un objectif et d'un oculaire *ne doit pas être dégradé* et donc limité par le *phénomène de diffraction*.
!!


* La *dépendance en $`\lambda`$*  implique que lorsque l'ouverture reçoit une onde incidente polychromatique, chaque $`\lambda`$ produit sa propre tache d'Airy. Le **maximum central** est **commun** à chaque longueur d'onde (et *apparait blanc* si l'onde polychromatique est perçue blanche par l'oeil humain), mais un **phénomène d'irisation** est observé au fur *dans les anneaux brillants secondaires*.<br>
<br>
![](airy-monoc-polyc_L600.jpg)<br>
_tache d'Airy observée a) en lumière quasi-monochromatique b) en lumière blanche._

#### Critère de Rayleight pour la tache d'Airy

Dans les instrument d'optique, le faisceau de rayons issu d'un point objet A est limité par un diaphragme qui peut être constitué par la monture des lentilles. L'image A'  que donne l'instrument du point A n'est pas ponctuelle mais en réalité une petite tache de diffraction.

Les images de deux points voisinsbdans le plan objet constituent dans le plan image deux taches d'Airy.  Je ne peux distinguer chacune de ces deux taches que si elles n'empiètent pas trop l'une sur l'autre.

Je me définis un critère intuitif et facilement quantifiable. Puisque je connais le rayon de la première extinction de la tache d'airy, le centre étant le maximum principal d'intensité, alors j'admets que mon oeil peut séparer deux taches d'Airy lorsque le centre de l'une se situe au-delà du premier minimum d'extinction de l'autre. 

Le **cas limite**, qui me permet le *choix entre discernabilité ou non discernabilité* des deux taches,  constitue le **critère de Raylight**. 

Dans le cas d'**observation à l'infini**, de *sources lumineuse éloignées* caractérisées par la *distance angulaire  $`\alpha`$* qui les sépare, le **critère de Rayleight** précise que les deux sources pourront être discernées si $`\alpha`$ est supérieure ou égale à la **distance angulaire minimal $`\alpha_min`$** telle que :

**$`\alpha_min=1,22 \dfrac{\lambda}{D}`$**

 ![](raylight-airy_L600.jpg)
