
# THIS DOCUMENT IS A DRAFT

> Contributions welcome!

## Courses Model

Each Course MUST have:

- one Identifier _(unique, URL-safe, path-safe)_
- one Title
- one Content
- one Topic
- one Language `ISO 639-1` (two letter code, eg: `fr`)

Each course MAY have

- one or more Courses as dependencies
- one or more Tags

Keep it simple, for now.  There will be room for events (class projects, etc.) later.

## Course File Format

We should probably follow something akin to [what Grav does](https://learn.getgrav.org/15/content/content-pages).

- A frontmatter in YAML holding metadata
- The course in Markdown + HTML

The markdown enhancements should be documented here as well.

Ideas:
- use gitlab's flavor as base, since it has latex and mermaid already
- https://zestedesavoir.com/ has a pretty good markdown flavor as well (information and warning bubbles), tailored for education


## Topics Tree

To get a sense of what the topics may look like, here's a non-exhaustive list :

- **Astronomy** – studies the universe beyond Earth, including its formation and development, and the evolution, physics, chemistry, meteorology, and motion of celestial objects (such as galaxies, planets, etc.) and phenomena that originate outside the atmosphere of Earth (such as the cosmic background radiation).
    - **Astrodynamics** – application of ballistics and celestial mechanics to the practical problems concerning the motion of rockets and other spacecraft.
    - **Astrometry** – branch of astronomy that involves precise measurements of the positions and movements of stars and other celestial bodies.
    - **Astrophysics** – study of the physical aspects of celestial objects
    - **Celestial mechanics** - the branch of theoretical astronomy that deals with the calculation of the motions of celestial objects such as planets.
    - **Extragalactic astronomy** – branch of astronomy concerned with objects outside our own Milky Way Galaxy
    - **Galactic astronomy** – study of our own Milky Way galaxy and all its contents.
    - **Physical cosmology** – study of the largest-scale structures and dynamics of the universe and is concerned with fundamental questions about its formation and evolution.
    - **Planetary science** – scientific study of planets (including Earth), moons, and planetary systems, in particular those of the Solar System and the processes that form them.
    - **Stellar astronomy** – natural science that deals with the study of celestial objects (such as stars, planets, comets, nebulae, star clusters and galaxies) and phenomena that originate outside the atmosphere of Earth (such as cosmic background radiation)
- **Atmospheric physics** – study of the application of physics to the atmosphere
- **Atomic, molecular, and optical physics** – study of how matter and light interact
    - **Optics** – branch of physics which involves the behavior and properties of light, including its interactions with matter and the construction of instruments that use or detect it.
- **Biophysics** – interdisciplinary science that uses the methods of physics to study biological systems
    - **Neurophysics** – branch of biophysics dealing with the nervous system.
    - **Polymer physics** – field of physics that studies polymers, their fluctuations, mechanical properties, as well as the kinetics of reactions involving degradation and polymerisation of polymers and monomers respectively.
    - **Quantum biology** - application of quantum mechanics to biological phenomenon.
- **Chemical physics** – branch of physics that studies chemical processes from the point of view of physics.
- **Computational physics** – study and implementation of numerical algorithms to solve problems in physics for which a quantitative theory already exists.
- **Condensed matter physics** – study of the physical properties of condensed phases of matter.
- **Electromagnetism** – branch of science concerned with the forces that occur between electrically charged particles.
- **Geophysics** – the physics of the Earth and its environment in space; also the study of the Earth using quantitative physical methods
- **Mathematical physics** – application of mathematics to problems in physics and the development of mathematical methods for such applications and for the formulation of physical theories.
- **Mechanics** – branch of physics concerned with the behavior of physical bodies when subjected to forces or displacements, and the subsequent effects of the bodies on their environment.
    - **Aerodynamics** – study of the motion of air.
    - **Biomechanics** – study of the structure and function of biological systems such as humans, animals, plants, organs, and cells by means of the methods of mechanics.
    - **Classical mechanics** – one of the two major sub-fields of mechanics, which is concerned with the set of physical laws describing the motion of bodies under the action of a system of forces.
        - **Kinematics** – branch of classical mechanics that describes the motion of points, bodies (objects) and systems of bodies (groups of objects) without consideration of the causes of motion.[6][7][8]
            - **Homeokinetics** - the physics of complex, self-organizing systems
    - **Continuum mechanics** – branch of mechanics that deals with the analysis of the kinematics and the mechanical behavior of materials modeled as a continuous mass rather than as discrete particles.
    - **Dynamics** – study of the causes of motion and changes in motion
    - **Fluid mechanics** – study of fluids and the forces on them.
        - **Fluid statics** – study of fluids at rest
        - **Fluid kinematics** – study of fluids in motion
        - **Fluid dynamics** – study of the effect of forces on fluid motion
    - **Statics** – branch of mechanics concerned with the analysis of loads (force, torque/moment) on physical systems in static equilibrium, that is, in a state where the relative positions of subsystems do not vary over time, or where components and structures are at a constant velocity.
- **Statistical mechanics** – branch of physics which studies any physical system that has a large number of degrees of freedom.
- **Thermodynamics** – branch of physical science concerned with heat and its relation to other forms of energy and work.
- **Nuclear physics** – field of physics that studies the building blocks and interactions of atomic nuclei.
- **Particle physics** – branch of physics that studies the properties and interactions of the fundamental constituents of matter and energy.
- **Psychophysics** – quantitatively investigates the relationship between physical stimuli and the sensations and perceptions they affect.
- **Plasma physics** – the study of plasma, a state of matter similar to gas in which a certain portion of the particles are ionized.
- **Quantum physics** – branch of physics dealing with physical phenomena where the action is on the order of the Planck constant.
- **Relativity** – theory of physics which describes the relationship between space and time.
    - **General Relativity** – the geometric theory of gravitation the current description of gravitation in modern physics.
    - **Special Relativity** – a theory that describes the propagation of matter and light at high speeds.

- **Agrophysics** – study of physics applied to agroecosystems
    - **Soil physics** – study of soil physical properties and processes.
- **Cryogenics** – cryogenics is the study of the production of very low temperature (below −150 °C, −238 °F or 123K) and the behavior of materials at those temperatures.
- **Econophysics** – interdisciplinary research field, applying theories and methods originally developed by physicists in order to solve problems in economics
- **Materials physics** – use of physics to describe materials in many different ways such as force, heat, light and mechanics.
- **Vehicle dynamics** – dynamics of vehicles, here assumed to be ground vehicles.

_Source : https://en.wikipedia.org/wiki/Outline_of_physics#Branches_of_physics_

-----

We should use a tree of directories, one directory for each topic.

Directory names MUST :
- be between 3 and 32 characters
- be lowercase
- not contain spaces _(we know it looks better, but i's also a free ticket to hell)_
- not contain non-ASCII
- start by a letter
- be alphanumeric only, plus `-` and `_`.
- validate with case-sensitivity the regex `^[a-z][a-z0-9_-]+[a-z0-9]$`

## Possible driver implementations

- with Grav
- with Moodle
- with schema.org (jsonld?) (may use Grav for this)
- with OAI-PMH  (may use Grav for this?)

Multiple frontends may be buit to display these courses.

## Tips

- http://flagpedia.net/emoji

## TODO

- Look up https://schema.org/Course and comply somehow
- Look up [OAI-PMH](ttp://www.unit.eu/ressources-educatives-libres/valoriser-des-rel) and comply somehow
