#### Sistemas de coordenadas / Systèmes de coordonnées - Repère de l’espace / Coordinate systems

-------------------------------

IMPORTANTE / IMPORTANT

[ES] No veo en español o inglés la distinción entre "sistema de coordenadas" y
lo que llamamos en Francia el "repère" asociado. ¿Me equivoco? Si esta diferencia 
existe entre los tres idiomas, será importante explicarla en el curso.<br>
Definir un "repère" me parece importante para hacer la distinción entre
"repère" y marco de referencia...

[FR] Je ne vois pas en espagnol ou en anglais la distinction entre "système de coordonnées" et
le repère associés. Je me trompe ? Si cette différence existent entre les trois langues,
l'expliciter dans le cours sera important.<br>
Définir la notion de repère me parait important pour faire la différence entre repère
et référentiel...

[EN] I don't see in Spanish or English the distinction between "coordinate system" and
what we call in France the associated "repère". I am wrong? f this difference exists
between the three languages, explaining it in the course will be important.<br>
To define a "repère" seems to me important to me to make the distinction between
"repère" and reference frame...

-----------------------------------

### Introducción / Introduction

* *CS10*

[ES] En mecánica clásica (no relativista), *el tiempo y el espacio no* están *acoplados*.

[FR] En mécanique classique (non relativiste) , *temps et espace* ne sont *pas couplés*.

[EN] In classical mechanics (not relativistic), *time and space* are *not coupled*.

-----------------------------------

* *CS20*

[ES] *En el espacio*, la *posición de un punto M* se identifica a partir de un **punto O origen** del
espacio por el **vector $`\overrightarrow{OM}`$**.

[FR] *Dans l’espace*, la *position d’un point M* est repérée à partir d’un **point O origine** de
l’espace par le **vecteur $`\overrightarrow{OM}`$**.

[EN] *In space*, the *position of a point M* is marked from a **point origin O** of
the space by the **vector $`\overrightarrow{OM}`$**.

-----------------------------------

* *CS30*

[ES] El *espacio clásico* de Newton tiene **3 dimensiones**. Esto significa que, desde el origen O del espacio,
la posición de cualquier punto M se puede definir de forma única mediante 
**3 números reales $`(\alpha_M, \beta_M, \gamma_M )`$**, llamados **coordenadas** (o coordenadas espaciales) 
del punto M. Escribimos $`M=M(\alpha_M, \beta_M, \gamma_M)`$.

[FR] L’*espace classique de Newton* a **3 dimensions**. Cela signifie que, à partir de l’origine O de l’espace,
la position de tout point M peut-être définie de façon unique par **3 nombres réels $`(\alpha_M, \beta_M, \gamma_M )`$**
, appelés **coordonnées** (ou coordonnées spatiales) du point M. On écrit $`M=M(\alpha_M, \beta_M, \gamma_M)`$.

[EN] The Newton's *classical space* has **3 dimensions**. This means that, from the origin O of space,
the position of any point M can be uniquely defined by **3 real numbers $`(\alpha_M, \beta_M, \gamma_M )`$**,
called **coordinates** (or spatial coordinates) of point M. We write $`M=M(\alpha_M, \beta_M, \gamma_M)`$.

-----------------------------------

* *CS40*

[ES] Si no nos referimos a un punto particular en el espacio, sino a un cualquier punto
que puede estar en cualquier lugar del espacio, entonces sus coordenadas son
variables reales, y simplemente escribimos $`M=M(\alpha, \beta, \gamma)`$.

[FR] Si nous ne faisons pas référence à un point particulier de l'espace, mais à un point
quelconque pouvant se situer n'importe où dans l'espace, alors ses coordonnées sont des
variables réelles, et nous écrivons simplement $`M=M(\alpha, \beta, \gamma)`$.

[EN] If we are not referring to a particular point in space, but to any point that can
be located anywhere in space, then its coordinates are real variables, and we simply write
$`M=M(\alpha, \beta, \gamma)`$.

-----------------------------------

* *CS50*

[ES] Hay *varias formas posibles de definir unas coordenadas espaciales*: Hablamos de 
** sistemas de coordenadas**.

[FR] ]Il y a *plusieurs façons possible de définir des coordonnées spatiales* : On parle de
**systèmes de coordonnées**.

[EN] There are *several possible ways to define spatial coordinates*: We speak of 
**coordinate systems**.

-----------------------------------

* *CS60*

[ES] Se definen caracteres alfanuméricos específicos para los sistemas de coordenadas comunes:<br>
\- *coordenades cartesianas* : **$`(x, y, z)`$ or $`(O, x_1, x_2, x_3)`$**<br>
\- *coordenades cilindricas* https://en.wikipedia.org/wiki/ISO_31-11 :
**$`(\rho, \phi, z)`$** (o $`(r, \phi, z)`$ si hay una ambigüedad con $`\rho`$, 
por ejemplo si $`\rho`$ se usa para la densidad densidad de carga eléctrica).<br>
\- *coordenades esfèriques* : **$`(r, \theta, \phi)`$**.

[FR] Des caractères alphanumériques spécifiques sont définis pour les systèmes de coordonnées 
usuels :<br>
\- *cartésiennes* : **$`(x, y, z)`$ or $`(O, x_1, x_2, x_3)`$**<br>
\- *cylindriques* https://en.wikipedia.org/wiki/ISO_31-11 :
**$`(\rho, \phi, z)`$** (ou $`(r, \phi, z)`$  si il y a une ambiguïté avec $`\rho`$, 
par exemple si $`\rho`$ est utilisé pour la charge (électrique) volumique).<br>
\- *sphériques* : **$`(r, \theta, \phi)`$**.

[EN] Specific alphanumeric characters are defined for some widely used coordinate systems :<br>
\- *cartesian* : **$`(x, y, z)`$ or $`(O, x_1, x_2, x_3)`$**<br>
\- *cylindrical* https://en.wikipedia.org/wiki/ISO_31-11 :
**$`(\rho, \phi, z)`$** (or $`(r, \phi, z)`$ if there is an ambiguity with $`\rho`$, 
for example if $`\rho`$ is used for (electric) charge density).<br>
\- *spherical* : **$`(r, \theta, \phi)`$**

<!--Commentaire----------------
Par exemple à l'INSA au GP, on utilise $`(r, \theta, z)`$ et  $`(r, \theta, \phi)`$, ce qui
fait que l'angle $`\theta`$ en coordonnées cylindriques est définit comme l'angle $`\phi`$
en sphériques. C'est l'occasion de changer cela pour nous conformer aux normes, et pour redonner
de la simplicité dans l'apprentissage des systèmes de coordonnées.
-------------------------------->

### Coordonnées cartésiennes

####  Définition des coordonnées et domaines de définition

* *CS100*

Système de coordonnées cartésiennes :<br>
\- **1 punto $`\mathbf{O}`$** de l'espace, choisi comme **origine** des coordonnées cartésiennes.<br>
\- **3 axes** appelés **$`\mathbf{Ox , Oy , Oz}`$**, se coupant en $`O`$ et **orthogonaux deux à deux**.<br>
\- **1 unité de longueur**.

---------------------

* *CS110*

Coordonnées cartésiennes : $`( x, y, z)`$

Tout point $`M`$ de l'espace est projeté orthogonalement sur le plan $`xOy`$ conduisant au point $`m_{xy}`$,
et sur l'axe $`Oz`$ conduisant au point $`m_z`$. Le point $`m_{xy}`$ est projeté orthogonalement sur les axes $`Ox`$ et $`Oy`$, conduisant respectivement aux points $`m_x`$ et $`m_y`$ (voir figure ...). <br>
ou, pour un équivalent d'écriture plus simple, mais moins visuel :<br>
Tout point $`M`$ de l'espace est projeté orthogonalement sur chacun des axes $`Ox , Oy , Oz`$ conduisant respectivement aux points $`m_x`$, $`m_y`$ et $`m_z`$.


---------------------

* *CS120*

Les **coordonnées cartésiennes $`\mathbf{x_M , y_M , z_M}`$** du point $`M`$ sont les 
distances algébriques $`\overline{Om_x}`$, $`\overline{Om_y}`$ et $`\overline{Om_z}`$ mesurées depuis le point origine $`O`$ jusqu'à chacun des points $`m_x`$, $`m_y`$ et $`m_z`$. 

**$`\mathbf{x_M=\overline{Om_x}}`$ , $`\mathbf{y_M=\overline{Om_y}}`$ , $`\mathbf{z_M=\overline{Om_z}}`$**

Les coordonnées $`x , y , z`$ sont des **longueurs** algébriques, dont l'**unité** dans le système international d'unité **S.I.** est le **mètre**, de symbole **$`\mathbf{m}`$**.

**Unidades S.I. / Unités S.I. / S.I. units : $`\mathbf{x(m)\;,\;y(m)\;,\;z(m)}`$**

---------------------

* *CS130*

Chaque point $`M`$ de l'espace est repéré de façon unique par un et un seul triplet constitué de ses 3 coordonnées cartésiennes. On écrit : $`M=M(x_M,y_M,z_M)`$.

Si le point est un point quelconque, on simplifie :

$`M(x,y,z)`$, **$`\mathbf{M(x,y,z)}`$**

----------------------

* *CS140*

**Tout l'espace** est couvert par les coordonnées cartésiennes lorsque chacune varie de façon indépendante des autres dans son propre domaine de variation. Leurs domaines de variation sont :

**$`\mathbf{x\in\mathbb{R}}`$  ,  $`\mathbf{y\in\mathbb{R}}`$  ,  $`\mathbf{z\in\mathbb{R}}`$**


#### Base vectorielle et repère de l'espace associés

##### Longueur du parcours associée à une variation de coordonnée

---------------------

* *CS150*

Lorsque seule la coordonnées $`x`$ d'un point $`M(x, y, z)`$ varie de façon 
continue entre les valeurs $`y`$ et $`\rho+\Delta \rho`$, le point $`M`$ parcourt un sègment
de droite de longueur $`\Delta l_{\rho}=\Delta \rho`$. Lorsque $`\Delta \rho`$ tend vers $`0`$,
la longueur infinitésimale $`dl_{\rho}`$ parcourue pour le point $`M`$ est :

$`\displaystyle dx=\lim_{\Delta x \rightarrow 0 \\ \Delta x>0} \Delta x`$
$`\quad\Longrightarrow\quad dl_x=dx`$  , **$`\mathbf{dl_x=dx}`$**

de même

$`dl_y=dy`$  , **$`\mathbf{dl_y=dy}`$**<br>

$`dl_z=dz`$  , **$`\mathbf{dl_z=dz}`$**

----------------

* *CS160*

!!!! Attention : Cette propriété que les longueurs élémentaires $`dl_{\alpha}`$ s'identifie à la variation infinitésimale de la coordonnée $`d\alpha`$ correspondante est une propriété des systèmes de coordonnées cartésiennes :
!!!!
!!!! Coordonnées cartésiennes $`\Longrightarrow \quad dl_{\alpha}=d\alpha`$.
!!!!
!!!! Mais lorsque nous passons aux coordonnées cylindriques et sphériques, et en généralisant aux coordonnées curvilignes, cette identité n'est plus systématiquement vraie.
!!!!
!!!! En général : $`\Longrightarrow \quad dl_{\alpha} \ne d\alpha`$
!!!!
!!!! Il est donc important de *distinguer la distance infinitésimal $`dl_{\alpha}`$* parcourue par un $`M`$ lors d'une variation infinitésimale  d'une seule de ses coordonnées $`\alpha`$, *de la variation $`d\alpha`$* de cette même coordonnée.

<!--
* *C60* : 

[ES] Característica de los sistemas de coordenadas "cartesianos" : si un punto $`M(x,y,z)`$ 
hace un desplazamiento infinitesimal hasta el punto $`M'(x+dx,y+dy,z+dz)`$,<br>
el Elemento escalar de línea $`dl`$ se escribe simplement :

[FR] Caractéristique des systèmes de coordonnées "cartésiennes" : si un point $`M(x,y,z)`$ 
fait un déplacement infinitésimal jusqu'au point $`M'(x+dx,y+dy,z+dz)`$,<br>
l'élément scalaire de longueur $`dl`$ s'écrit simplement :

[EN] Characteristic of "Cartesian" coordinate systems : if a point $`M(x,y,z)`$ makes 
an infinitesimal displacement up to point $`M'(x+dx,y+dy,z+dz)`$,<br>
the scalar line element $`dl`$ writes simply :

$`dl=\sqrt{dx^2+dy^2+dz^2}`$ , **$`\mathbf{dl=\sqrt{dx^2+dy^2+dz^2}}`$**
-->

##### Vecteur unitaire associé à chaque coordonnée

* *CS170*

Lorsque seule la coordonnées $`x`$ d'un point $`M(x,y,z)`$ s'accroît de façon 
infinitésimale entre les valeurs $`x`$ et $`x+dx`$ ($`dx>0`$), le vecteur déplacement 
$`\overrightarrow{MM'}=d\overrightarrow{OM}_x`$ du point $`M`$ est le vecteur
tangent à la trajectoire au point $`M`$ qui sc'écrit :

$`\overrightarrow{MM'}=d\overrightarrow{OM}_x=\dfrac{\partial \overrightarrow{OM}}{\partial x}\cdot dx`$

Le vecteur unitaire tangent à la trajectoire $`\overrightarrow{e_x}`$ (qui indique la direction et le sens 
de déplacement du point M lorsque seule la coordonnée x croît de façon infinitésimale) s'écrit :

$`\overrightarrow{e_x}=\dfrac{\partial\overrightarrow{OM}_x}{||\partial\overrightarrow{OM}_x||}`$

de même :

$`d\overrightarrow{OM}_y=\dfrac{\partial \overrightarrow{OM}}{\partial y}\cdot dy`$,
$`\quad\overrightarrow{e_y}=\dfrac{\partial\overrightarrow{OM}_y}{||\partial\overrightarrow{OM}_y||}`$<br>
$`d\overrightarrow{OM}_z=\dfrac{\partial \overrightarrow{OM}}{\partial z}\cdot dz`$,
$`\quad\overrightarrow{e_z}=\dfrac{\partial\overrightarrow{OM}_z}{||\partial\overrightarrow{OM}_z||}`$


#### Base et repère cartésiens

* *CS180*

Les vecteurs déplacement élémentaire $`d\overrightarrow{OM}_x , d\overrightarrow{OM}_y , d\overrightarrow{OM}_z`$ associés aux trois coordonnées $`x , y, z`$ et définis en un même point $`M`$ de l'espace sont orthogonaux deux à deux <'--, et forment un trièdre direct-->. Il en est donc ainsi de même pour les vecteurs unitaires $`\overrightarrow{e_x}`$, $`\overrightarrow{e_y}`$ y $`\overrightarrow{e_z}`$.

Les vecteurs $`\overrightarrow{e_x}`$, $`\overrightarrow{e_y}`$ y $`\overrightarrow{e_z}`$ 
forment une **base orthonormée** de l'espace. C'est la base associée aux coordonnées cartésiennes.
En coordonnées cartésiennes, les **vecteurs de base** gardent la 
**même direction et le même sens quelque-soit la position du point $`M`$**.

$`||\overrightarrow{e_x}||=||\overrightarrow{e_y}||=||\overrightarrow{e_z}||=1`$<br>
$`\overrightarrow{e_x}\perp\overrightarrow{e_y}\quad,\quad\overrightarrow{e_y}\perp\overrightarrow{e_z}\quad,\quad\overrightarrow{e_x}\perp\overrightarrow{e_z}`$

$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ 
base orthogonale indépendante de la position de $`M`$

---------------------

* *CS190*

[FR] Un repère cartésien, noté $`(O, \overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$, 
est l'ensemble formé par un point  $`O`$ origine des coordonnées et une base vectorielle cartésienne $`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$.

En coordonnées cartésiennes, tout point $`M`$ de l'espace peut se repérer :<br>
\- soit par ses coordonnées cartésiennes $`(x, y, z)`$ dans le système d'axes cartésien $`(Ox, Oy, Oz)`$.<br>
\- soit par son vecteur position $`\overrightarrow{OM}`$ d'expression 
$`\overrightarrow{OM}=x\;\overrightarrow{e_x}+y\;\overrightarrow{e_y}+z\;\overrightarrow{e_z}`$  dans le repère cartésien $`(O, \overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$.<br>
Les composantes d'un vecteur position sont appelées coordonnées, $`x, y, z`$ sont les coordonnées cartésiennes du point $`M`$.

------------------

* *CS200*

Des grandeurs physiques vectorielles $`G`$ associées à un point $`M`$ autres que sa position $`\overrightarrow{OM}`$ peuvent s'exprimer avec les vecteurs de la base cartésienne $`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$: <br>
$`\overrightarrow{G}=G_x\;\overrightarrow{e_x}+G_y\;\overrightarrow{e_y}+G_z\;\overrightarrow{e_z}`$.<br>
$`G_x, G_y, G_z`$ sont appelées composantes de la grandeur physique $`G`$ dans la base $`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$.<br>
Exemples grandeurs physiques vectorielles $`G`$ associée à un point $`M`$ :<br>
\- le vecteur vitesse $`V`$, dont les composantes cartésiennes $`V_x, V_y, V_z`$ s'expriment en $`m\;s^{-1}`$ dans le S.I. <br>
\- le vecteur accélération $`a`$, dont les composantes cartésiennes $`a_x, a_y, a_z`$  s'expriment en $`m\;s^{-2}`$ dans le S.I. <br>
\- la force totale appliquée $`F`$, dont les composantes cartésiennes $`F_x, F_y, F_z`$ s'expriment en $`N`$ (newton) dans le S.I. <br>
\- ...


forment le repère cartésien 
$`(O, \overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$.

Un point $`M`$ de l'espace est repéré par son vecteur position $`\overrightarrow{OM}`$.
Le vecteur $`\overrightarrow{OM}`$ en coordonnées cartésiennes s'écrit en fonctio



#### Déplacement, surface et volume élémentaires

##### Vecteur déplacement élémentaire

* *CS220*

La norme du vecteur $`d\overrightarrow{OM}_x=\overrightarrow{dl_x}`$ 
est l'élément de longueur $`dl_x`$, donc le vecteur $`\overrightarrow{e_x}`$ s'écrit :

$`d\overrightarrow{OM}_x=\overrightarrow{dl_x}=dl_x\;\overrightarrow{e_x}=dx\;\overrightarrow{e_x}`$

de même :

$`d\overrightarrow{OM}_y=\overrightarrow{dl_y}=dl_y\;\overrightarrow{e_y}=dy\;\overrightarrow{e_y}`$<br>
$`d\overrightarrow{OM}_z=\overrightarrow{dl_z}=dl_z\;\overrightarrow{e_z}=dz\;\overrightarrow{e_z}`$

--------------------------------

* *CS230*

L'**élément vectoriel d'arc** ou vecteur déplacement élémentaire $`\overrightarrow{dOM}=\overrightarrow{dl}`$ en 
coordonnées cartésiennes est le vecteur déplacement du point $`M(x,y,z)`$ au point
$`M'(x+dx,y+dy,z+dz)`$ quand les coordonnées varient infinitésimalement des quantités
$`dx`$, $`dy`$ y $`dz`$, et il s'écrit :

$`\overrightarrow{MM'}=d\overrightarrow{OM}=\overrightarrow{dr}=\overrightarrow{dl}`$
$`=d\overrightarrow{OM}_x+d\overrightarrow{OM}_y+d\overrightarrow{OM}_z`$
$`=\overrightarrow{dl_x}+\overrightarrow{dl_y}+\overrightarrow{dl_z}`$
$`=dl_x\;\overrightarrow{e_x}+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z}`$
$`=dx\;\overrightarrow{e_x}+dy\;\overrightarrow{e_y}+dz\;\overrightarrow{e_z}`$

**$`\mathbf{d\overrightarrow{OM}=\overrightarrow{dl}}`$**
**$`\mathbf{=dl_x\;\overrightarrow{e_x}+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z}}`$**
**$`\mathbf{=dx\;\overrightarrow{e_x}+dy\;\overrightarrow{e_y}+dz\;\overrightarrow{e_z}}`$**

##### Scalaire déplacement élémentaire

* *CS240*

[FR] et sa norme el l'élément de longueur :

$`||\overrightarrow{dl}||=\sqrt{dl_x^2+dl_y^2+dl_z^2}=\sqrt{dx^2+dy^2+dz^2}`$

$`||\overrightarrow{dl}||=\sqrt{\overrightarrow{dl}\cdot\overrightarrow{dl}}`$
$`=\left[(dl_x\;\overrightarrow{e_x}+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z})\cdot
(dl_x\;\overrightarrow{e_x}\right.`$
$`\left.+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z})\right]^{1/2}`$
$`=\left[(dl_x)^2\;(\overrightarrow{e_x}\cdot\overrightarrow{e_x})\right.`$
$`+(dl_y)^2\;(\overrightarrow{e_y}\cdot\overrightarrow{e_y})`$
$`+(dl_z)^2\;(\overrightarrow{e_z}\cdot\overrightarrow{e_z})`$
$`+(2\,dl_x\,dl_y)\,(\overrightarrow{e_x}\cdot\overrightarrow{e_y})`$
$`+(2\,dl_x\,dl_z)\,(\overrightarrow{e_x}\cdot\overrightarrow{e_z})`$
$`\left.+(2\,dl_y\,dl_z)\,(\overrightarrow{e_y}\cdot\overrightarrow{e_z})\right]^{1/2}`$
$`=\sqrt{(dl_x)^2+(dl_y)^2+(dl_z)^2}`$
$`=\sqrt{dx^2+dy^2+dz^2}=dl`$

##### Surfaces élémentaires

* *CS250*

Les 3 vecteurs $`d\overrightarrow{OM}_x=\overrightarrow{dl_x}\quad`$,
$`\quad d\overrightarrow{OM}_y=\overrightarrow{dl_y}\quad`$ et
$`\quad d\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ sont orthogonaux 2 à 2.

$`\Longrightarrow`$ :

L'aire d'un élément de surface construit par 2 de ces vecteurs s'exprime 
simplement comme le produit de leurs normes. Et le volume défini par ces 3 vecteurs 
est simplement le produits de leurs normes.

-------------------

* *CS260*

Selon la direction choisie, les **éléments scalaires de surface $`dS`$** en coordonnées cartésiennes sont :

\- dans un plan $`z = cst`$ :<br>
$`\quad dS=dS_{xy}=dS_{yx}=dl_x\;dl_y=dx\;dy\quad`$ , **$`\mathbf{dS=dl_x\;dl_y=dx\;dy}`$**<br>
\- dans un plan $`y = cst`$ :<br>
$`\quad dS=dS_{xz}=dS_{zx}=dl_x\;dl_z=dx\;dz\quad`$ , **$`\mathbf{dS=dl_x\;dl_z=dx\;dz}`$**<br>
\- dans un plan $`x = cst`$ :<br>
$`\quad dS=dS_{yz}=dS_{zy}=dl_y\;dl_z=dy\;dz`$, **$`\mathbf{dS=dl_y\;dl_z=dy\;dz}`$**

--------------------

* *CS270*

et les **éléments vectoriels de surface $`\overrightarrow{dS}`$** correspondants sont :

$`d\overrightarrow{S_{xy}}=\pm\;d\overrightarrow{OM}_x\land d\overrightarrow{OM}_y`$
$`=\pm\;\overrightarrow{dl_x}\land\overrightarrow{dl_y}`$
$`=\pm\; (dl_x\;\overrightarrow{e_x})\land(dl_y\;\overrightarrow{e_y})`$
$`=\pm\; dl_x\;dl_y\;(\overrightarrow{e_x}\land\overrightarrow{e_y})`$
$`= \pm \; dx\;dy\;\overrightarrow{e_z}`$

$`d\overrightarrow{S_{xz}}=\pm\;d\overrightarrow{OM}_x\land d\overrightarrow{OM}_z`$
$`=\pm\;\overrightarrow{dl_x}\land\overrightarrow{dl_z}`$
$`=\pm\; (dl_x\;\overrightarrow{e_x})\land(dl_z\;\overrightarrow{e_z})`$
$`=\pm\; dl_x\;dl_z\;(\overrightarrow{e_x}\land\overrightarrow{e_z})`$
$`=\mp\; dx\;dy\;\overrightarrow{e_z}`$

$`d\overrightarrow{S_{yz}}=\pm\;d\overrightarrow{OM}_y\land d\overrightarrow{OM}_z`$
$`=\pm\;\overrightarrow{dl_y}\land\overrightarrow{dl_z}`$
$`=\pm\; (dl_y\;\overrightarrow{e_y})\land(dl_z\;\overrightarrow{e_z})`$
$`=\pm\; dl_y\;dl_z\;(\overrightarrow{e_y}\land\overrightarrow{e_z})`$
$`=\pm\; dy\;dz\;\overrightarrow{e_x}`$

##### Volume élémentaire

* *CS280*

Élément de volume $`d\large\tau`$ en coordonnées cartésiennes :

$`d\large\tau\normalsize=dx\;dy\;dz`$ , **$`d\large\tau\normalsize=dx\;dy\;dz`$**


#### Vecteur position

* *CS285*

Vecteur position d'un point $`M(x,y,z)`$ en coordonnées cartésiennes :<br>
[EN] Position vector of a point $`M(x,y,z)`$ in Cartesian coordinates:<br>

$`\overrightarrow{OM}=x\;\overrightarrow{e_x}+y\;\overrightarrow{e_y}+z\;\overrightarrow{e_z}`$

**$`\mathbf{\overrightarrow{OM}=x\;\overrightarrow{e_x}+y\;\overrightarrow{e_y}+z\;\overrightarrow{e_z}}`$**

#### Vecteur vitesse

* *CS290*

#### Vecteur accélération

* *CS295*

------------------------------------


### Coordenadas cilíndricas / Coordonnées cylindriques / Cylindrical coordinates N3

#### Définition des coordonnées et domaines de définition

* *CS300* :  

Cadre de référence : système cartésien de coordonnées  $`(O, x, y, z)`$

\- **1 point $`O`$ origine** de l'espace.<br>
\- **3 axes** nommés **$`Ox , Oy , Oz`$**, se coupant en $`O`$, **orthogonaux 2 à 2**.<br>
\- **1 unité de longueur**.<br>

---------------------

* *CS310* :  

Coordonnées cylindriques $`(\rho , \varphi , z)`$ :

\- Tout point $`M `$ de l'espace est projeté orthogonalement sur le plan $`xOy`$ conduisant au point $`m_{xy}`$,
et sur l'axe $`Oz`$ conduisant au point $`m_z`$.

\- La **coordonnée $`\rho_M`$** du point $`M`$ est la *distance non algébrique $`Om_{xy}`$* entre le point $`O`$ et le point $`m_{xy}`$.<br>
\- La **coordonnée $`\varphi_M`$** du point $`M`$ est l'*angle non algébrique $`\widehat{xOm_{xy}}`$* entre l'axe $`Ox`$ et la demi-droite $`Om_{xy}`$, 
le sens de rotation étant tel que le trièdre *$`(Ox , Om_{xy}, Oz)`$* est un *trièdre direct*.<br>
\- La **coordonnée $`z_M`$** du point $`M`$ est la *distance algébrique $`\overline{Om_z}`$* entre le point $`O`$ et le point $`m_z`$.

**$`\rho_M=\overline{Om_{xy}}`$ , $`\varphi_M=\widehat{xOm_y}`$ , $`z_M=Om_z`$**

--------------------

* *CS320*

! *Remarque :* Les deux premières coordonnées cylindriques d'un point $`M`$ sont les coordonnées polaires du point $`m_{xy}`$ dans le plan $`xOy`$ (plan $`z=0`$). Ce sont aussi les coordonnées polaires du point $`M`$ dans le plan $`z=z_M`$.

\- Les coordonnées **$`\rho`$ **et **$`z`$** sont des *longueurs*, dont l'*unité S.I.* est le mètre, de symbole *$`m`$*.<br>
\- La coordonnée **$`\varphi`$** est un angle, dont  l'*unité S.I.* est le radian, de symbole *$`rad`$*.

**Unités S.I. : $`\rho\;(m)`$ , $`\varphi\;(rad)`$ , $`z\;(m)`$**

--------------------

* *CS330*

\- Tout point $`M`$ de l'espace, excepté le point origine $`O`$,  est repéré de façon unique par un et un seul triplet constitué de ses 3 coordonnées cylindriques.<br>
\- Au point origine $`O`$ est attribué les coordonnées cylindriques $`(0 , 0 , 0)`$.

\- Escribimos / on écrit / we write : $`M(\rho_M,\varphi_M,z_M)`$

\- Si el punto es cualquier punto, simplificamos / Si le point est un point quelconque, on simplifie / If the point is any point, we simplify :

$`M(\rho , \varphi , z)`$, **$`\mathbf{M(\rho , \varphi , z)}`$**

------------------

* *CS340*

\- **Tout l'espace** est couvert par les coordonnées cylindriques variant indépendamment 
dans les domaines $`\rho\in\mathbb{R_+^{*}}=[0 ,+\infty[ `$  ,  
$`\varphi\in[0,2\pi[`$ et $`z\in\mathbb{R}=]-\infty ,+\infty\,[`$.

**$`\mathbf{\rho\in\mathbb{R_+^{*}}=[0 ,+\infty[}`$ , $`\mathbf{ \varphi\in[0,2\pi[ }`$ ,  $`\mathbf{ z\in\mathbb{R}=]-\infty ,+\infty[ } `$**


--------------

* *CS350*

!<details markdown=1>
! <summary>
! Notations sur les ensembles de nombres réels 
! </summary>
! * le symbole $`\infty`$ désigne l'infini.
! * $`\mathbb{R}`$ : ensemble des nombres réels :
! $`\mathbb{R}\; = \; \{x\in\mathbb{R}\}\;=\;]-\infty , +\infty\,[`$.
! * $`\mathbb{R}^{*}`$ : ensemble des nombres réels non nuls : 
! $`\mathbb{R}^{*}\; = \; \{x\in\mathbb{R}\,|\,x\ne 0\}\; = \; ]-\infty , 0\,[ \;\cup\; ]\,0 , + \infty\,[`$.
! * $`\mathbb{R}_+`$ : ensemble des nombres réels positifs : 
! $`\mathbb{R}_+\; = \; \{x\in\mathbb{R}\,|\,x \ge 0\}\; = \; [\,0 , + \infty\,[`$.
! * $`\mathbb{R}_+`$ : ensemble des nombres réels négatifs : 
! $`\mathbb{R}_+\; = \; \{x\in\mathbb{R}\,|\,x \ge 0\}\; = \; ]-\infty , 0\,]`$.
! * $`\mathbb{R}_+^{*}`$ : ensemble des nombres réels positifs non nuls : 
! $`\mathbb{R}_+^{*}\; = \; \{x\in\mathbb{R}\,|\,x \le 0\}\; = \; ]\,0 , + \infty\,[ `$.
! * $`\mathbb{R}_{-}^{*}`$ : ensemble des nombres réels négatifs non nuls : 
! $`\mathbb{R}_{-}^{*}\; = \; \{x\in\mathbb{R}\,|\,x > 0\,]\;= \; ]-\infty , 0\,[ `$.
!
!    --------
! * {...} indique un ensemble d'éléments.
! *  la liste, le texte ou l'expression logique ... précise les éléments de l'ensemble.
! *  on peut donner un nom à l'ensemble : exemple : A={...}.
! *  le symbole " $`|`$ " signifie "tel que". Exemple :<br>
!    $`\{x\in\mathbb{R} | x \lt 0\}`$ désigne lensemble des nombre réels x, tels que $`x \lt 0`$.
!
!   -------
!  Les intervalles par l'exemple :
! * $` [2 , 3] `$ : intervalle des nombres réels compris entre 2 et 3, 2 et 3 étant inclus.
! * $` ]2 , 3[ `$ : intervalle des nombres réels compris entre 2 et 3, 2 et 3 étant exclus.
! * $` [2 , 3[ `$ : intervalle des nombres réels compris entre 2 et 3, 2 étant inclus et 3 exclus.
! * $` ]2 , 3 ]`$ : intervalle des nombres réels compris entre 2 et 3, 2 étant exclus et 3 inclus.
! * fait appel à la notion mathématique de limite.
! * L'infini est toujours exclu, on ne peut jamais l'atteindre, il ne peut pas être inclus :<br>
! $`]-\infty`$ et pas $`\require{cancel}\xcancel{[-\infty}`$ , $`+\infty[`$ et pas $`\require{cancel}\xcancel{+\infty]}`$
! <\details>

<!--
Las coordenadas cilíndricas se escriben / les coordonnées cylindriques s'écrivent / The cylindrical coordinates write :

$`(\rho, \varphi, z)`$ , **$`\mathbf{(\rho, \varphi, z)}`$**

con / avec /with :

$`\rho\in [0;\infty[`$,  $`\varphi\in [0;2\pi[`$ et $`z \in [-\infty;\infty[`$ , 

**$`\mathbf{ \rho\in [0;\infty[}`$  ,  $`\mathbf{\varphi\in [0;2\pi[}`$  ,  $`\mathbf{z \in [-\infty;\infty[ }`$** 

Coordenadas cilíndricas de un punto $`M`$ /coordonnées cylindriques  d'un point $`M`$ / cylindrical  coordinates of a point $`M`$ :

$`(\rho_M, \varphi_M, z_M)`$,

Escribimos / on écrit / we write :

$`M(\rho_M, \varphi_M, z_M)`$

Si el punto es cualquier punto, simplificamos / Si le point est un point quelconque, on simplifie / If the point is any point, we simplify :

$`M(\rho, \varphi, z)`$ , **$`\mathbf{M(\rho, \varphi, z)}`$** -->


#### Base vectorielle et repère de l'espace associés

##### Variation d'une coordonnée et longueur du parcours associée

* *CS360* 

[ES] Cuando solo la coordenada $`\rho`$ de un punto $`M(\rho, \varphi, z)`$ varía
continuamente entre los valores $`\rho`$ y $`\rho+\Delta \rho`$, el punto $`M`$ recorre un segmento
de longitud $`\Delta l_{\rho}=\Delta \rho`$. Cuando $`\Delta \rho`$ 
tiende a $`0`$, la longitud infinitesimal $`dl_{\rho}`$ recorrida para el punto $`M`$ 
es :

[FR] Lorsque seule la coordonnées $`\rho`$ d'un point $`M(\rho, \varphi, z)`$ varie de façon 
continue entre les valeurs $`\rho`$ et $`\rho+\Delta \rho`$, le point $`M`$ parcourt un sègment
de droite de longueur $`\Delta l_{\rho}=\Delta \rho`$. Lorsque $`\Delta \rho`$ tend vers $`0`$,
la longueur infinitésimale $`dl_{\rho}`$ parcourue pour le point $`M`$ est :

[EN] When only the $`\rho`$ coordinate of a point $`M(\rho, \varphi, z)`$ varies
continuously between the values $`\rho`$ and $`\rho+\Delta \rho`$, the point $`M`$ covers
a line segment of length $`\Delta l_{\rho}=\Delta \rho`$. When $`\Delta \rho`$ tends
towards $`0`$, the infinitesimal length $`dl_{\rho}`$ covered by the point $`M`$ is :

$`\displaystyle d\rho=\lim_{\Delta \rho\rightarrow 0 \\ \Delta \rho>0} \Delta \rho`$
$`\quad\Longrightarrow\quad dl_{\rho}=d\rho`$, **$`\mathbf{dl_{\rho}=d\rho}`$**.

tambien / de même / similarly : $`dl_z=dz`$ , , **$`\mathbf{dl_z=dz}`$**.

[ES] Cuando solo la coordenada $`\varphi`$ de un punto $`M(\rho, \varphi, z)`$ varía
continuamente entre los valores $`\varphi`$ y $`\varphi +\Delta \varphi`$, el punto $`M`$ 
recorre un arco de circulo
de longitud $`\Delta l_{\varphi}=\rho\:\Delta \varphi`$. Cuando $`\Delta \varphi`$ 
tiende a $`0`$, la longitud infinitesimal $`dl_{\varphi}`$ recorrida para el punto $`M`$ 
es :

[FR] Lorsque seule la coordonnées $`\varphi`$ d'un point $`M(\rho, \varphi, z)`$ varie de façon 
continue entre les valeurs $`\varphi`$ et $`\varphi +\Delta \varphi`$, le point $`M`$ parcourt un 
arc de cercle de longueur $`\Delta l_{\varphi}=\rho\;\Delta \varphi`$. Lorsque $`\Delta \varphi`$ tend vers $`0`$,
la longueur infinitésimale $`dl_{\varphi}`$ parcourue pour le point $`M`$ est :

[EN] When only the $`\varphi`$ coordinate of a point $`M(\rho, \varphi, z)`$ varies
continuously between the values $`\varphi`$ and $`\varphi+\Delta \varphi`$, the point $`M`$ covers
an arc of circle of length $`\Delta l_{\varphi}=\rho\,\Delta \varphi`$. When $`\Delta \varphi`$ tends
towards $`0`$, the infinitesimal length $`dl_{\varphi}`$ covered by the point $`M`$ is :

$`\displaystyle d\varphi=\lim_{\Delta \varphi\rightarrow 0 \\ \Delta \varphi>0} \Delta\varphi`$
$`\quad\Longrightarrow\quad dl_{\phi}=\rho\,d\varphi`$ , , **$`\mathbf{dl_{\varphi}=\rho\,d\varphi}`$**.

------------

* *CS370* : 

[ES] elemento escalar de línea :<br>
[FR] élément scalaire de longueur :<br>
[EN] scalar line element :

<br>$`dl=\sqrt{d\rho^2+ (\rho\,d\varphi)^2+dz^2}`$ , **$`\mathbf{dl=\sqrt{d\rho^2+ (\rho\,d\varphi)^2+dz^2}}`$**

#### Base vectorielle et repère de l'espace associés

* *CS380*

[ES] Cuando solo la coordenada $`\rho`$ de un punto $`M(\rho, \varphi, z)`$ aumenta
infinitesimalmente entre los valores $`\rho`$ y $`\rho+d\rho`$ ($`d\rho>0`$)
para llegar al punto $`M'(\rho+\Delta\rho, \varphi, z)`$, el vector de desplazamiento
$`\overrightarrow{MM'}=d\overrightarrow{OM}_{\rho}`$ del punto $`M`$ es el vector 
tangente a la trayectoria en el punto $`M`$, dirigido en la dirección del movimiento,
que se escribe :

[FR] Lorsque seule la coordonnées $`\rho`$ d'un point $`M(\rho, \varphi, z)`$ s'accroît de façon 
infinitésimale entre les valeurs $`\rho`$ et $`\rho+d\rho`$ ($`d\rho>0`$)
pour atteindre le point $`M'(\rho+\Delta\rho, \varphi, z)`$, le vecteur déplacement 
$`\overrightarrow{MM'}=d\overrightarrow{OM}_{\rho}`$ du point $`M`$ est le vecteur
tangent à la trajectoire au point $`M`$, dirigé dans le sens du mouvement, qui s'écrit :

[EN] When only the $`\rho`$ coordinate of a point $`M(x,y,z)`$ increases infinitesimally between
the values $`\rho`$ and $`\rho+d\rho`$ ($`d\rho>0`$) to reach the point
$`M'(\rho+\Delta\rho, \varphi, z)`$, the displacement vector
$`\overrightarrow{MM'}=d\overrightarrow{OM}_{\rho}`$ of the point $`M`$ is the 
tangent vector to the trajectory at point $`M`$ oriented in the direction of the movement. It writes :

$`\overrightarrow{MM'}=d\overrightarrow{OM}_{\rho}=\dfrac{\partial \overrightarrow{OM}}{\partial \rho}\cdot d\rho`$

[ES] El vector unitario tangente a la trayectoria  $`\overrightarrow{e_{\rho}}`$ (que indica la dirección y el sentido
de desplazamiento del punto $`M`$ cuando solo aumenta infinitesimalmente la coordenada $`\rho`$ se escribe:

[FR] Le vecteur unitaire tangent à la trajectoire $`\overrightarrow{e_{\rho}}`$ (qui indique la direction et le sens 
de déplacement du point $`M`$ lorsque seule la coordonnée $`\rho`$ croît de façon infinitésimale) s'écrit :

[EN] The unit vector tangent to the trajectory  $`\overrightarrow{e_{\rho}}`$  (which indicates the direction of displacement 
of the point $`M`$ when only the coordinate $`\rho`$ increases in an infinitesimal way) writes :

$`\overrightarrow{e_{\rho}}=\dfrac{\partial\overrightarrow{OM}_{\rho}}{||\partial\overrightarrow{OM}_{\rho}||}`$

tambien / de même / similarly :

$`d\overrightarrow{OM}_{\varphi}=\dfrac{\partial \overrightarrow{OM}}{\partial \varphi}\cdot d\varphi`$,
$`\quad\overrightarrow{e_{\varphi}}=\dfrac{\partial\overrightarrow{OM}_{\varphi}}{||\partial\overrightarrow{OM}_{\varphi}||}`$<br>
$`d\overrightarrow{OM}_z=\dfrac{\partial \overrightarrow{OM}}{\partial z}\cdot dz`$,
$`\quad\overrightarrow{e_z}=\dfrac{\partial\overrightarrow{OM}_z}{||\partial\overrightarrow{OM}_z||}`$

--------------------

* *CS390*

[ES] La norma del vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
es el elemento escalar de linea $`dl_{\rho}`$, entonces el vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
se escribe :

[FR] La norme du vecteur $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
est l'élément de longueur $`dl_{\rho}`$, donc le vecteur $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ s'écrit :

[EN] the norm (or length) of the vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
is the scalar line element $`dl_{\rho}`$, so the vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ writes :

$`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}=dl_{\rho}\;\overrightarrow{e_{\rho}}
=d\rho\;\overrightarrow{e_{\rho}}`$ , **$`\mathbf{\overrightarrow{dl_{\rho}}=d\rho\;\overrightarrow{e_{\rho}}}`$**

tambien / de même / similarly :

$`d\overrightarrow{OM}_z=\overrightarrow{dl_z}=dl_z\;\overrightarrow{e_z}=dz\;\overrightarrow{e_z}`$ ,
**$`\mathbf{\overrightarrow{dl_z}=dz\;\overrightarrow{e_z}}`$**

[ES] La norma del vector $`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}`$ 
es el elemento escalar de linea $`dl_{\varphi}`$, entonces el vector $`\overrightarrow{e_{\varphi}}`$ 
se escribe :

[FR] La norme du vecteur $`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}`$ 
est l'élément de longueur $`dl_{\varphi}`$, donc le vecteur $`\overrightarrow{e_{\varphi}}`$ s'écrit :

[EN] the norm (or length) of the vector $`d\overrightarrow{OM}_{varphi}=\overrightarrow{dl_{varphi}}`$ 
is the scalar line element $`dl_{\varphi}`$, so the vector $`\overrightarrow{e_{\varphi}}`$ writes :

$`\partial\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}=dl_{\varphi}\;\overrightarrow{e_{\varphi}}
=\rho\,d\varphi\;\overrightarrow{e_{\varphi}}`$ , 
**$`\mathbf{\overrightarrow{dl_{\varphi}}=\rho\,d\varphi\;\overrightarrow{e_{\varphi}}}`$**

-------------------------

* *CS400*

[ES] El **elemento vectorial de línea** o ?? $`\overrightarrow{dOM}=\overrightarrow{dl}`$ en coordenadas cilíndricas es
el vector de desplazamiento del punto $`M(\rho, \varphi, z)`$ al punto $`M'(\rho+ d\rho, \varphi + d\varphi, z+ dz)`$ cuando 
las coordenadas varían infinitesimalmente de $`d\rho`$, $`d\varphi`$ y $`dz`$, y se escribe :

[FR] L'**élément vectoriel d'arc** ou vecteur déplacement élémentaire $`\overrightarrow{dOM}=\overrightarrow{dl}`$ en 
coordonnées cylindriques est le vecteur déplacement du point $`M(\rho, \varphi, z)`$ au point
$`M'(\rho+ d\rho, \varphi + d\varphi, z+ dz)`$ quand les coordonnées varient infinitésimalement des quantités
$`d\rho`$, $`d\varphi`$ et $`dz`$, et il s'écrit :

[EN] The **vector line element** or vector path element $`\overrightarrow{dOM}=\overrightarrow{dl}`$ 
in Cylindrical coordinates is the displacement vector from point $`M(\rho, \varphi, z)`$ to point 
$`M'(\rho+ d\rho, \varphi + d\varphi, z+ dz)`$ when the coordinates vary infinitesimally in quantities 
$`d\rho`$, $`d\varphi`$ and $`dz`$,
and it writes :

$`\overrightarrow{MM'}=d\overrightarrow{OM}=\overrightarrow{dr}=\overrightarrow{dl}`$
$`=d\overrightarrow{OM}_{\rho}+d\overrightarrow{OM}_{\varphi}+d\overrightarrow{OM}_z`$
$`=\overrightarrow{dl_{\rho}}+\overrightarrow{dl_{\varphi}}+\overrightarrow{dl_z}`$
$`=dl_{\rho}\;\overrightarrow{e_{\rho}}+dl_{\varphi}\;\overrightarrow{e_{\varphi}}+dl_z\;\overrightarrow{e_z}`$
$`=d\rho\;\overrightarrow{e_x}+\rho\;d\varphi\;\overrightarrow{e_y}+dz\;\overrightarrow{e_z}`$

**$`\mathbf{d\overrightarrow{OM}=\overrightarrow{dl}}`$**
**$`\mathbf{=dl_{\rho}\;\overrightarrow{e_{\rho}}+dl_{\varphi}\;\overrightarrow{e_{\varphi}}+dl_z\;\overrightarrow{e_z}}`$**
**$`\mathbf{=d\rho\;\overrightarrow{e_{\rho}}+\rho\;dl_{\varphi}\;\overrightarrow{e_{\varphi}}+dz\;\overrightarrow{e_z}}`$**

[ES] y su norma es el elemento scalar de linea :<br>
[FR] et sa norme el l'élément de longueur :<br>
[EN] y its norm (or length) is thescalar line element :

$`||\overrightarrow{dl}||=\sqrt{dl_x^2+dl_y^2+dl_z^2}=\sqrt{dx^2+dy^2+dz^2}`$

$`||\overrightarrow{dl}||=\sqrt{\overrightarrow{dl}\cdot\overrightarrow{dl}}`$
$`=\left[(dl_x\;\overrightarrow{e_x}+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z})\cdot
(dl_x\;\overrightarrow{e_x}\right.`$
$`\left.+dl_y\;\overrightarrow{e_y}+dl_z\;\overrightarrow{e_z})\right]^{1/2}`$
$`=\left[(dl_x)^2\;(\overrightarrow{e_x}\cdot\overrightarrow{e_x})\right.`$
$`+(dl_y)^2\;(\overrightarrow{e_y}\cdot\overrightarrow{e_y})`$
$`+(dl_z)^2\;(\overrightarrow{e_z}\cdot\overrightarrow{e_z})`$
$`+(2\,dl_x\,dl_y)\,(\overrightarrow{e_x}\cdot\overrightarrow{e_y})`$
$`+(2\,dl_x\,dl_z)\,(\overrightarrow{e_x}\cdot\overrightarrow{e_z})`$
$`\left.+(2\,dl_y\,dl_z)\,(\overrightarrow{e_y}\cdot\overrightarrow{e_z})\right]^{1/2}`$
$`=\sqrt{(dl_x)^2+(dl_y)^2+(dl_z)^2}`$
$`=\sqrt{dx^2+dy^2+dz^2}=dl`$

-------------------------------

* *CS410*
 
[ES] Los vectores $`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ y $`\overrightarrow{e_z}`$ 
forman una **base ortonormal** del espacio. La base
$`(\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ 
es la base asociada a las coordenadas cilíndricas. En coordenadas cilíndricas, los vectores
de base asociadas cambian de direcciónes cuando el punto $`M`$ se mueve.

[FR] Les vecteurs $`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ y $`\overrightarrow{e_z}`$ 
forment une **base orthonormée** de l'espace. C'est la base associée aux coordonnées cylindriques.
En coordonnées cylindriques, les vecteurs de base associés 
changent de direction lorsque le point $`M`$ se déplace.

[EN] The vectors $`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ y $`\overrightarrow{e_z}`$ 
form an **orthonormal basis** of space. It is the base associated with cylindrical coordinates.
In cylindrical coordinates, the base vectors change of direction when the point $`M`$ moves.

$`||\overrightarrow{e_{\rho}}||=||\overrightarrow{e_{\varphi}}||=||\overrightarrow{e_z}||=1`$<br>
$`\overrightarrow{e_{\rho}}\perp\overrightarrow{e_{\varphi}}\quad,\quad\overrightarrow{e_{\varphi}}\perp\overrightarrow{e_z}\quad,\quad\overrightarrow{e_{\rho}}\perp\overrightarrow{e_z}`$

$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ base cartesiana *directa* $`\quad\Longleftrightarrow\quad (\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ base cilíndrica asociada *directa*.
<br>$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ base cartésienne *directe* $`\quad\Longleftrightarrow\quad (\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ base cylindrique associée *directe*.
<br>$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ *direct* Cartesian base $`\quad\Longleftrightarrow\quad (\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ *direct* associated cylindrical base.

$`(\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ 
base ortogonal dependiente de la posición de $`M`$ / base orthogonale dépendante
de la position de $`M`$ / orthogonal basis dependent of the position of $`M`$.

##### Vecteur déplacement élémentaire

* *CS420*

$`\overrightarrow{OM}=\overrightarrow{OM}(t)\quad\Longrightarrow\quad\left\{ \begin{array}{l}
\overrightarrow{e_{\rho}} = \overrightarrow{e_{\rho}}(t) \\
\overrightarrow{e_{\varphi}}  = \overrightarrow{e_{\varphi}}(t) \\
\overrightarrow{e_z}  = \overrightarrow{cst} \\
\end{array} \right.`$

-----------------------

* *CS430*

Método 1 para el cálculo de / Méthode 1 pour le calcul de / Method 1 for the calculation of :<br>
$`\dfrac{d e_r}{dt}`$ , $`\dfrac{d e_{\varphi}}{dt}`$. 

$`\overrightarrow{e_z}=\overrightarrow{cst}\Longrightarrow\dfrac{d e_z}{dt}=0`$ 


$`\overrightarrow{e_\rho}(t)=cos\,\varphi(t)\;\overrightarrow{e_x}`$$`\;+\;sin\,\varphi(t)\;\overrightarrow{e_y}`$<br>
<br>$`\overrightarrow{e_{\varphi}}(t)=- sin\,\varphi(t)\;\overrightarrow{e_x}`$$`\;+\;cos\,\varphi(t)\;\overrightarrow{e_y}`$

en la base cartesiana / dans la base cartésienne / in the Cartesian base
$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ :

$`\overrightarrow{e_{\rho}}(t)=
\left| \begin{array}{l}
cos\,\varphi(t) \\
sin\,\varphi(t) \\
0 \\
\end{array} \right.\quad`$ , 
$`\quad\overrightarrow{e_{\varphi}}(t)=
\left|\begin{array}{l}
-\,sin\,\varphi(t) \\
cos\,\varphi(t) \\
0 \\
\end{array}\right.`$ 

[ES] ? En el marco de referencia $`\mathcal{R}(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z},t)`$ del observador, es decir cuando la origen del espacio $`O`$ es fija y los tres vectores base verifican

[FR] Dans le référentiel $`\mathcal{R}(O,\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z},t)`$ de l'observateur, c'est à dire dans le référentiel où le repère cartésien $`(O, \overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ est fixe, donc tel que l'origine $`O`$ est fixe et les trois vecteurs de base vérifient 

[EN] In the reference frame $`\mathcal{R}(O,\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z},t)`$ of the observer, i.e.when the origin $`O`$ is fixed and the three base vectors satisfy 

$`\dfrac{d\overrightarrow{e_x}}{dt}=\dfrac{d\overrightarrow{e_y}}{dt}=\dfrac{d\overrightarrow{e_z}}{dt}=0`$ :

recordando / en se rappelant / reminding : $`(fg)'=f'g+fg'`$  

$`\dfrac{d\overrightarrow{e_{\rho}}}{dt}=
\left| \begin{array}{l}
cos\,\varphi(t) \,]\\
sin\,\varphi(t)\, ] \\
0 \\
\end{array} \right.\quad`$
$`\quad =
\left| \begin{array}{l}
\dfrac{d\,cos \,\varphi}{dt} \\
\\
\dfrac{d\,sin\,\varphi}{dt} \\
\\
\dfrac{d\,0}{dt} \\
\end{array} \right.\quad`$

y recordando / et en se rappelant / and reminding : $`(f \circ g)'=(f' \circ g)\,g'`$ , 

$`\dfrac{d\overrightarrow{e_{\rho}}}{dt}=
\left| \begin{array}{l}
-\;sin\,\varphi  \cdot \dfrac{d\varphi}{dt} \\
\\
cos\,\varphi \cdot \dfrac{d\varphi}{dt}\\
\\
0 \\
\end{array} \right.\quad`$
$`=\dfrac{d\varphi}{dt}\;\overrightarrow{e_{\varphi}}`$

**$`\mathbf{\dfrac{d\overrightarrow{e_{\rho}}}{dt}=\dfrac{d\varphi}{dt}\cdot \overrightarrow{e_{\varphi}}}`$**

tambien / de même / similarly :

$`\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=
\left| \begin{array}{l}
\dfrac{d\,[-\,sin\,\varphi(t)]}{dt} \\
\\
\dfrac{d\cos\,\varphi(t)}{dt} \\
\\
\dfrac{d\;0}{dt} \\
\end{array} \right.\quad`$
$`\quad=
\left| \begin{array}{l}
-\,cos\,\varphi(t)\cdot\dfrac{d\varphi}{dt} \\
-\,sin\,\varphi(t)\cdot\dfrac{d\varphi}{dt} \\
0 \\
\end{array} \right.\quad`$
$`\quad\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=-\,\dfrac{d\varphi}{dt}\cdot\overrightarrow{e_{\rho}}`$

**$`\mathbf{\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=-\,\dfrac{d\varphi}{dt}}\cdot\overrightarrow{e_{\rho}}`$**<br>

--------------------

* *CS440*

Método 2 para el cálculo de / Méthode 2 pour le calcul de / Method 2 for the calculation of :<br>
$`\dfrac{d e_{\rho}}{dt}`$ , $`\dfrac{d e_{\varphi}}{dt}`$ 

$`\overrightarrow{e_{\rho}}=cos\,\varphi\;\overrightarrow{e_x}`$
$`\;+\;sin\,\varphi\;\overrightarrow{e_y}`$$`\;+\;0\;\overrightarrow{e_z}`$
$`=\overrightarrow{e_{\rho}}(\varphi)`$<br>
$`\overrightarrow{e_{\varphi}}=- sin\,\varphi\;\overrightarrow{e_x}`$
$`\;+\;cos\,\varphi\;\overrightarrow{e_y}\;+\;0\;\overrightarrow{e_z}`$
$`=\overrightarrow{e_{\varphi}}=\overrightarrow{e_{\varphi}}(\varphi)`$

$`\overrightarrow{e_{\rho}}=\overrightarrow{e_{\rho}}(\varphi)`$ et 
$`\overrightarrow{e_{\varphi}}=\overrightarrow{e_{\varphi}}(\varphi)`$
$`\quad\Longrightarrow\quad`$ pour une variation  infinitésimale $`d\varphi`$, $`\overrightarrow{e_{\rho}}`$ et $`\overrightarrow{e_{\varphi}}`$ varient de :

$`d\overrightarrow{e_{\rho}}=\dfrac{d\overrightarrow{e_{\rho}}}{d\varphi}\cdot d\varphi`$ <br>
$`d\overrightarrow{e_{\varphi}}=\dfrac{d\overrightarrow{e_{\varphi}}}{d\varphi}\cdot d\varphi`$

con / avec / with

$`\dfrac{d\overrightarrow{e_{\rho}}}{d\varphi}=
\left|\begin{array}{l}
\dfrac{d\;cos\,\varphi}{d\varphi} \\
\\
\dfrac{d\;sin\,\varphi}{d\varphi} \\ 
\\
\dfrac{d\;0}{d\varphi} \\
\end{array} \right.\quad`$ 
$`=\left|\begin{array}{l}
-\,sin\,\varphi \\
cos\,\varphi \\
0 \\
\end{array} \right.\quad`$
$`=\overrightarrow{e_{\varphi}}`$

$`\dfrac{d\overrightarrow{e_{\varphi}}}{d\varphi}=
\left|\begin{array}{l}
\dfrac{d\;(-\,sin\,\varphi}{d\varphi} \\
\\
\dfrac{d\;cos\,\varphi}{d\varphi} \\ 
\\
\dfrac{d\;0}{d\varphi} \\
\end{array} \right.\quad`$ 
$`=\left|\begin{array}{l}
-\,cos\,\varphi \\
-\,sin\,\varphi \\
0 \\
\end{array} \right.\quad`$
$`=-\,\overrightarrow{e_{\rho}}`$

$`\varphi=\varphi(t)\quad\Longrightarrow\quad`$ pour unè variation infinitésimale  $`dt`$ , $`\varphi`$ varie de :

$`d\varphi=\dfrac{d\varphi}{dt}\cdot dt`$

$`\Longrightarrow\quad`$ pour une variation infinitésimale  $`dt`$, $`\overrightarrow{e_{\rho}}`$ et $`\overrightarrow{e_{\varphi}}`$ varient de :

$`d\overrightarrow{e_{\rho}}\quad=\dfrac{d\overrightarrow{e_{\rho}}}{d\varphi}\cdot \dfrac{d\varphi}{dt}\cdot dt`$$\quad=\dfrac{d\varphi}{dt}\cdot dt \cdot \dfrac{d\overrightarrow{e_{\rho}}}{d\varphi}\quad=\dfrac{d\varphi}{dt}\cdot dt \cdot
\overrightarrow{e_{\varphi}}`$

$`d\overrightarrow{e_{\varphi}}\quad=\dfrac{d\overrightarrow{e_{\varphi}}}{d\varphi}\cdot \dfrac{d\varphi}{dt}\cdot dt`$
$\quad=\dfrac{d\varphi}{dt}\cdot dt \cdot \dfrac{d\overrightarrow{e_{\varphi}}}{d\varphi}\quad=-\,\dfrac{d\varphi}{dt}\cdot dt \cdot
\overrightarrow{e_{\rho}}`$

$`\dfrac{d\overrightarrow{e_{\rho}}}{dt}=\dfrac{d\varphi}{dt} \cdot
\overrightarrow{e_{\varphi}}`$

$`\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=-\,\dfrac{d\varphi}{dt} \cdot
\overrightarrow{e_{\rho}}`$

$`\dfrac{d\overrightarrow{e_z}}{dt}=\overrightarrow{0}`$

---------------------

* *CS450* 

[ES] En la mecánica clásica, las interacciones entre cuerpos materiales se traducen en términos de fuerza $`\vec{F}`$ y conducen a una aceleración $`\vec{a}`$ de cada cuerpo en interacción proporcional a la inversa de su masa de inercia $`m_I`$ : $`\vec{a}=\dfrac{\vec{F}}{m_I}`$ (o $`\vec{F}=m_I\;\vec{a}`$ , ver capítulo mecánico). Como el vector de aceleración es la segunda derivada temporal del vector de posición, es posible que necesitemos conocer la segunda derivada  temporal de los vectores base para el estudio del movimiento.

[FR] En mécanique classique, les interactions entre les corps matériels se traduisent en terme de force $`\vec{F}`$, et conduisent à une accélération $`\vec{a}`$ de chaque corps en interaction proportionnelle à l'inverse de sa masse d'inertie  $`m_I`$ : $`\vec{a}=\dfrac{\vec{F}}{m_I}`$ (ou $`\vec{F}=m_I\;\vec{a}`$ , voir chapitre mécanique). Dans l'étude du mouvement, nous aurons besoin d'étendre l'étude à la dérivée seconde des vecteurs de base. Comme le vecteur accélaration est la dérivée seconde du vecteur position, nous pourrions avoir besoin de connaître la dérivée seconde par rapport au temps des vecteurs de base pour l'étude du mouvement.

[EN] In classical mechanics, the interactions between material bodies are expressed in terms of force $`\vec{F}`$ , and lead to an acceleration of each interacting body proportional to the inverse of its mass of inertia  $`m_I`$ : $`\vec{a}=\dfrac{\vec{F}}{m_I}`$ (or $`\vec{F}=m_I\;\vec{a}`$ , see mechanical chapter). As the acceleration vector is the second time derivative of the position vector, when studying the motion we might need to know the second time derivative of the base vectors.

$`\dfrac{d^2\,\overrightarrow{e_{\rho}}}{dt^2}\quad=\dfrac{d}{dt}\left(\dfrac{d\,\overrightarrow{e_{\rho}}}{dt}\right)\quad=\dfrac{d}{dt}\left(\dfrac{d\varphi}{dt}\cdot\overrightarrow{e_{\varphi}}\right)`$
$`\quad=\dfrac{d}{dt}\left(\dfrac{d\,\varphi}{dt}\right)\cdot\overrightarrow{e_{\varphi}}\,
+\,\dfrac{d\varphi}{dt}\cdot\dfrac{d}{dt}\left(\overrightarrow{e_{\varphi}}\right)`$

$`\quad=\dfrac{d^2\varphi}{dt^2}\cdot\overrightarrow{e_{\varphi}}\,+\,\dfrac{d\varphi}{dt}\cdot
\dfrac{d\,\overrightarrow{e_{\varphi}}}{dt}`$$`\quad=\dfrac{d^2\varphi}{dt^2}\cdot\overrightarrow{e_{\varphi}}\,+\,\dfrac{d\varphi}{dt}\cdot \left( -\,\dfrac{d\varphi}{dt} \cdot e_{\rho}\right) `$
$`\quad=\dfrac{d^2\,\varphi}{dt^2}\cdot \overrightarrow{e_{\varphi}} \,-\,\left( \dfrac{d\varphi}{dt} \right)^2 \cdot e_{\rho}`$

**$`\mathbf{\dfrac{d^2\,\overrightarrow{e_{\rho}}}{dt^2}=-\,\left( \dfrac{d\varphi}{dt} \right)^2 \cdot e_{\rho}\,+\,\dfrac{d^2\varphi}{dt^2}\cdot \overrightarrow{e_{\varphi}}}`$**

[ES] ¡Atención! No confunda $`\dfrac{d^2\varphi}{dt^2}`$ y $`\left( \dfrac{d\varphi}{dt} \right)^2 `$ (dar un ejemplo).

[FR] Attention ! Ne pas confondre $`\dfrac{d^2\varphi}{dt^2}`$ et $`\left( \dfrac{d\varphi}{dt} \right)^2 `$ (donner un exemple).

[EN] Look out ! Do not confuse $`\dfrac{d^2\varphi}{dt^2}`$ and $`\left( \dfrac{d\varphi}{dt} \right)^2 `$ (give an example).


$`\dfrac{d^2\,\overrightarrow{e_{\varphi}}}{dt^2}\quad=\dfrac{d}{dt}\left(\dfrac{d\,\overrightarrow{e_{\varphi}}}{dt}\right)\quad=\dfrac{d}{dt}\left(-\,\dfrac{d\varphi}{dt}\cdot\overrightarrow{e_{\rho}}\right)`$
$`\quad=-\,\dfrac{d}{dt} \left( \dfrac{d\varphi}{dt} \right) \cdot \overrightarrow{e_{\rho}} \,- \,\dfrac{d\varphi}{dt} \cdot \dfrac{d}{dt} \left( \overrightarrow{e_{\rho}} \right)`$
$`\quad=-\,\dfrac{d^2\varphi}{dt^2} \cdot \overrightarrow{e_{\rho}} \,-\, \dfrac{d\varphi}{dt} \cdot
\dfrac{d\,\overrightarrow{e_{\rho}}}{dt}`$
$`\quad=-\,\dfrac{d^2\varphi}{dt^2} \cdot \overrightarrow{e_{\rho}}\,-\,\dfrac{d\varphi}{dt} \cdot \left( \dfrac{d\varphi}{dt} \cdot e_{\varphi} \right) `$
$`\quad=-\,\dfrac{d^2\,\varphi}{dt^2}\cdot \overrightarrow{e_{\rho}} \,-\,\left( \dfrac{d\varphi}{dt} \right)^2 \cdot e_{\varphi}`$

**$`\mathbf{\dfrac{d^2\,\overrightarrow{e_{\varphi}}}{dt^2}
=-\,\dfrac{d^2\,\varphi}{dt^2}\cdot \overrightarrow{e_{\rho}} \,-\,\left( \dfrac{d\varphi}{dt} \right)^2 \cdot e_{\varphi}}`$**


$`\dfrac{d^2\,\overrightarrow{e_z}}{dt^2} \quad = \dfrac{d}{dt} \left( \dfrac{d\,\overrightarrow{e_z}}{dt} \right) \quad = \dfrac{d\,\overrightarrow{0}}{dt} \quad = \overrightarrow{0}`$

**$`\mathbf{\dfrac{d^2\,\overrightarrow{e_z}}{dt^2}=\overrightarrow{0}}`$**

---------------------

* *CS460*

[ES] La norma del vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
es el elemento escalar de linea $`dl_{\rho}`$, entonces el vector $`\overrightarrow{e_{\rho}}`$ 
se escribe :

[FR] La norme du vecteur $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
est l'élément de longueur $`dl_{\rho}`$, donc le vecteur $`\overrightarrow{e_{\rho}}`$ s'écrit :

[EN] the norm (or length) of the vector $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}`$ 
is the scalar line element $`dl_{\rho}`$, so the vector $`\overrightarrow{e_{\rho}}`$ writes :

$`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}=dl_{\rho}\;\overrightarrow{e_{\rho}}
=\rho\;\overrightarrow{e_{\rho}}`$

tambien / de même / similarly :

$`d\overrightarrow{OM}_z=\overrightarrow{dl_z}=dl_z\;\overrightarrow{e_z}=dz\;\overrightarrow{e_z}`$

[ES] La norma del vector $`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}`$ 
es el elemento escalar de linea $`dl_{\varphi}`$, entonces el vector $`\overrightarrow{e_{\varphi}}`$ 
se escribe :

[FR] La norme du vecteur $`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}`$ 
est l'élément de longueur $`dl_{\varphi}`$, donc le vecteur $`\overrightarrow{e_{\varphi}}`$ s'écrit :

[EN] the norm (or length) of the vector $`d\overrightarrow{OM}_{varphi}=\overrightarrow{dl_{varphi}}`$ 
is the scalar line element $`dl_{\varphi}`$, so the vector $`\overrightarrow{e_{\varphi}}`$ writes :

$`d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}=dl_{\varphi}\;\overrightarrow{e_{\varphi}}
=\rho\,d\varphi\;\overrightarrow{e_{\varphi}}`$

------------------

* *CS470*

[ES] Los 3 vectores $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}\quad`$,
$`\quad d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}\quad`$ y
$`\quad d\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ son 2 a 2 ortogonales.

[FR] Les 3 vecteurs $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}\quad`$,
$`\quad d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}\quad`$ et
$`\quad d\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ sont orthogonaux 2 à 2.

[EN] The 3 vectors $`d\overrightarrow{OM}_{\rho}=\overrightarrow{dl_{\rho}}\quad`$,
$`\quad d\overrightarrow{OM}_{\varphi}=\overrightarrow{dl_{\varphi}}\quad`$ and
$`\quad d\overrightarrow{OM}_z=\overrightarrow{dl_z}`$ are 2 to 2 orthogonal.

$`\Longrightarrow`$ :

[ES] ¡Atención! El área de un elemento de superficie construido por 2 de estos vectores 
no es el producto de sus normas. Tambien el volumen definido 
por estos 3 vectores no será simplemente el producto de sus normas.

[FR] Attention ! L'aire d'un élément de surface construit par 2 de ces vecteurs n'est'
pas le produit de leurs normes. Et le volume définit par ces 3 vecteurs 
n'est le produit de leurs normes.

[EN] Warning! The area of a surface element constructed by 2 of these vectors is not 
the product of their norms. And the volume defined by these 3 vectors is not the product 
of their norms.

--------------------------

* *CS480*

http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-06.

[ES] Según la dirección elegida, los **elementos escalares de superficie $`dA`$** en coordenadas cartesianas son :<br>
[FR] Selon la direction choisie, les **éléments scalaires de surface $`dA`$** en coordonnées cartésiennes sont :<br>
[EN] According to the chosen direction, the **scalar surface elements $`dA`$** in Cartesian coordinates are :

$`dA_{\rho\varphi}=dl_{\rho}\;dl\varphi=d\rho\cdot\rho\;d\varphi\quad`$, $`\quad dA_{\rho z}=dl_{\rho}\;dlz=d\rho\;dz\quad`$, $`\quad dA_{\varphi z}=dl_{\varphi}\;dlz=\rho\,d\varphi\;dz`$

http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-07.<br>
[ES] y los **elementos vectoriales de superficie $`\overrightarrow{dA}`$** correspondiente son :<br>
[FR] et les **éléments vectoriels de surface $`\overrightarrow{dA}`$** correspondants sont :<br>
[EN] and the corresponding **vector surface elements $`\overrightarrow{dA}`$** are :


$`d\overrightarrow{A_{\rho\varphi}}=d\overrightarrow{OM}_{\rho}\land d\overrightarrow{OM}_{\varphi}`$
$`=\overrightarrow{dl_{\rho}}\land\overrightarrow{dl_{\varphi}}`$
$`= (dl_{\rho}\;\overrightarrow{e_{\rho}})\land(dl_{\varphi}\;\overrightarrow{e_{\varphi}})`$
$`=dl_{\rho}\;dl_{\varphi}\;(\overrightarrow{e_{\rho}}\land\overrightarrow{e_{\varphi}})`$
$`=d\rho\;\rho\,d{\varphi}\;(\overrightarrow{e_{\rho}}\land\overrightarrow{e_{\varphi}})`$<br>
<br>$`d\overrightarrow{A_{\varphi z}}=d\overrightarrow{OM}_{\varphi}\land d\overrightarrow{OM}_z`$
$`=\overrightarrow{dl_{\varphi}}\land\overrightarrow{dl_z}`$
$`= (dl_{\varphi}\;\overrightarrow{e_{\varphi}})\land (dl_z\;\overrightarrow{e_z})`$
$`=dl_{\varphi}\;dl_z\;(\overrightarrow{e_{\varphi}}\land\overrightarrow{e_z})`$
$`=\rho\,d\varphi\;dz\;(\overrightarrow{e_{\varphi}}\land\overrightarrow{e_z})`$<br>
<br>$`d\overrightarrow{A_{z \rho}}=d\overrightarrow{OM}_z\land d\overrightarrow{OM}_{\rho}`$
$`=\overrightarrow{dl_z}\land\overrightarrow{dl_{\rho}}`$
$`=(dl_z\;\overrightarrow{e_z})\land(dl_{\rho}\;\overrightarrow{e_{\rho}})`$
$`=dl_z\;dl_{\rho}\;(\overrightarrow{e_z}\land\overrightarrow{e_{\rho}})`$.
$`=dz\;d\rho\;(\overrightarrow{e_z}\land\overrightarrow{e_{\rho}})`$.

[ES] :

[FR] Base cartésien de référence $`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ directe  $`\Longrightarrow`$  base cylindrique $`(\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ directe $`\Longrightarrow`$ :

[EN] : 

$`\overrightarrow{e_{\rho}}\land\overrightarrow{e_{\varphi}}=+\,\overrightarrow{e_z}`$
$`\Longrightarrow d\overrightarrow{A_{\rho\varphi}}=+\,d\rho\;\rho\,d{\varphi}\,\overrightarrow{e_z})`$.<br>
$`\overrightarrow{e_{\rho}}\land\overrightarrow{e_z}=-\,\overrightarrow{e_{\varphi}}`$
$`\Longrightarrow d\overrightarrow{A_{\rho\varphi}}=+\,d\rho\;\rho\,d{\varphi}\,\overrightarrow{e_z})`$.<br>


[ES] :<br>
[FR] Base cartésien de référence $`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ indirecte  $`\Longrightarrow`$  base cylindrique $`(\overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ indirecte $`\Longrightarrow`$ :<br>
[EN] : 

$`\overrightarrow{e_{\rho}}\land\overrightarrow{e_{\varphi}}=-\,\overrightarrow{e_z}`$.
$`\Longrightarrow d\overrightarrow{A_{\rho\varphi}}=-\,d\rho\;\rho\,d{\varphi}\,\overrightarrow{e_z})`$.


-----------------

@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

### Coordonnées sphériques

#### Définition des coordonnées et domaines de définition

* *CS550* 

Les coordonnées sphériques s'écrivent $`(r, \theta, \varphi)`$,

avec :

$`r\in [0;\infty[`$ ,  $`\theta\in[0,\pi]`$ et $`\varphi\in [0;2\pi[`$.

**$`\mathbf{ r\in [0;\infty[}`$  ,  $`\mathbf{\theta\in[0,\pi]}`$  ,  $`\mathbf{\varphi\in [0;2\pi[ }`$**

Coordonnées sphériques d'un point $`M`$ :

$`(r_M, \theta_M, \varphi_M)`$ :

on écrit :

$`M(r_M, \theta_M, \varphi_M)`$

Si le point est un point quelconque, on simplifie

$`M(r, \theta, \varphi)`$ , **$`\mathbf{M=M(\rho, \theta, \varphi)}`$**


#### Variation d'une coordonnée et longueur du parcours associée

* *CS560* 

[FR] élément scalaire de longueur :

$`dl=\sqrt{dr^2+(r\,d\theta)^2+(r\,sin\theta\,d\varphi)^2}`$ ,
**$`\mathbf{dl=\sqrt{dr^2+(r\,d\theta)^2+(r\,sin\theta\,d\varphi)^2}}`$**

--------------------------

* *CS570*

Vecteur position d'un point $`M(r,\theta,\varphi)`$ en coordonnées sphériques :

<br>$`\overrightarrow{OM}=r\;\overrightarrow{e_r}`$ , **$`\mathbf{\overrightarrow{OM}=r\;\overrightarrow{e_r}}`$**

-----------------------------

* *CS580* : **N3 ($`\rightarrow`$ N4)**

Élément de volume $`d\large\tau`$ en coordonnées sphériques :

$`d{\large\tau} =\rho^2\;sin\,\theta\;dr\;d\theta\;d\varphi`$ , **$`\mathbf{d{\large\tau} =\rho^2\;sin\,\theta\;dr\;d\theta\;d\varphi}`$**.

---------------------------

* *CS590* : **N3 ($`\rightarrow`$ N4)**

Lorsque seule la coordonnées $`r`$ d'un point $`M(r, \theta, \varphi)`$ varie de façon 
continue entre les valeurs $`r`$ et $`r+\Delta r`$, le point $`M`$ parcourt un sègment
de droite de longueur $`\Delta l_r=\Delta r`$. Lorsque $`\Delta r`$ tend vers $`0`$,
la longueur infinitésimale $`dl_r`$ parcourue pour le point $`M`$ est :

$`\displaystyle dr=\lim_{\Delta r\rightarrow 0 \\ \Delta r>0} \Delta r`$
$`\quad\Longrightarrow\quad dl_r=dr`$ , **$`\mathbf{dl_r=dr}`$**

Lorsque seule la coordonnées $`\theta`$ d'un point  $`M(r, \theta, \varphi)`$ varie de façon 
continue entre les valeurs $`\theta`$ et $`\theta +\Delta \theta`$, le point $`M`$ parcourt un 
arc de cercle de longueur $`\Delta l_{\theta}=r\;\Delta \theta`$. Lorsque $`\Delta \theta`$ tend vers $`0`$,
la longueur infinitésimale $`dl_{\theta}`$ parcourue pour le point $`M`$ est :

$`\displaystyle d\theta=\lim_{\Delta \theta\rightarrow 0 \\ \Delta \theta>0} \Delta\theta`$
$`\quad\Longrightarrow\quad dl_{\theta}=r\,d\theta`$ , **$`\mathbf{dl_{\theta}=r\,d\theta}`$**   

Lorsque seule la coordonnées $`\varphi`$ d'un point  $`M(r, \theta, \varphi)`$ varie de façon 
continue entre les valeurs $`\varphi`$ et $`\varphi +\Delta \varphi`$, le point $`M`$ parcourt un 
arc de cercle de longueur $`\Delta l_{\varphi}=r \;sin\,\theta\;\Delta \varphi`$. Lorsque $`\Delta \varphi`$ tend vers $`0`$,
la longueur infinitésimale $`dl_{\varphi}`$ parcourue pour le point $`M`$ est :

$`\displaystyle d\varphi=\lim_{\Delta \varphi\rightarrow 0 \\ \Delta \varphi>0} \Delta\varphi`$
$`\quad\Longrightarrow\quad dl_{\varphi}=r\;sin\,\theta\;d\varphi`$ , **$`\mathbf{dl_{\varphi}=r\;sin\,\theta\;d\varphi}`$** 

---------------------------

* *CS600* : **N3 ($`\rightarrow`$ N4)**

Les vecteurs $`\overrightarrow{e_r}`$, $`\overrightarrow{e_{\theta}}`$ et $`\overrightarrow{e_{\varphi}}`$
forment une **base orthonormée** de l'espace. La base $`(\overrightarrow{e_r},\overrightarrow{e_{\theta}},\overrightarrow{e_{\varphi}})`$ 
est la base associée aux coordonnées sphériques.
En coordonnées sphériques, les vecteurs de base associés 
changent de direction lorsque le point $`M`$ se déplace.

$`||\overrightarrow{e_r}||=||\overrightarrow{e_{\theta}}||=||\overrightarrow{e_{\varphi}}||=1`$

$`\overrightarrow{e_r}\perp\overrightarrow{e_{\theta}}\quad,\quad\overrightarrow{e_{\theta}}\perp\overrightarrow{e_{\varphi}}\quad,\quad\overrightarrow{e_{\varphi}}\perp\overrightarrow{e_r}`$

$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ base cartesiana *directa* $`\quad\Longleftrightarrow\quad (\overrightarrow{e_r},\overrightarrow{e_{\theta}},\overrightarrow{e_{\varphi}})`$ base esférica asociada *directa*.
<br>$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ base cartésienne *directe* $`\quad\Longleftrightarrow\quad (\overrightarrow{e_r},\overrightarrow{e_{\theta}},\overrightarrow{e_{\varphi}})`$ base sphérique associée *directe*.
<br>$`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ *direct* Cartesian base $`\quad\Longleftrightarrow\quad (\overrightarrow{e_r},\overrightarrow{e_{\theta}},\overrightarrow{e_{\varphi}})`$ *direct* associated spherical base.

$`\overrightarrow{e_r}=sin\,\theta\;cos\,\varphi\;\overrightarrow{e_x}`$$`\;+\;sin\,\theta\;sin\,\varphi\;\overrightarrow{e_y}`$$`\;+\;cos\,\theta\;\overrightarrow{e_z}`$<br>
<br>$`\overrightarrow{e_{\theta}}=cos\,\theta\;cos\,\varphi\;\overrightarrow{e_x}`$$`\;+\;cos\,\theta\;sin\,\varphi\;\overrightarrow{e_y}`$$`\;-\;sin\,\theta\;\overrightarrow{e_z}`$<br>
<br>$`\overrightarrow{e_{\varphi}}=- sin\,\varphi\;\overrightarrow{e_x}`$$`\;+\;cos\,\varphi\;\overrightarrow{e_y}`$<br>

---------------------------

* *CS610* : **N3 ($`\rightarrow`$ N4)**<br>

Méthode 1 pour le calcul de $`\dfrac{d e_r}{dt}`$ , $`\dfrac{d e_{\theta}}{dt}`$ , $`\dfrac{d e_{\varphi}}{dt}`$ 

$`(\overrightarrow{e_r},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$ 
base ortogonal dependiente de la posición de $`M`$ / base orthogonale dépendante
de la position de $`M`$ / orthogonal basis dependent of the position of $`M`$.<br>
<br>$`\overrightarrow{OM}=\overrightarrow{OM}(t)\quad\Longrightarrow\quad\left\{ \begin{array}{l}
\overrightarrow{e_r} = \overrightarrow{e_r}(t) \\
\overrightarrow{e_{\theta}}  = \overrightarrow{e_{\theta}}(t) \\
\overrightarrow{e_{\varphi}}  = \overrightarrow{e_{\varphi}}(t) \\
\end{array} \right.`$

$`\overrightarrow{e_r}(t)=sin\,\theta(t)\;cos\,\varphi(t)\;\overrightarrow{e_x}`$$`\;+\;sin\,\theta(t)\;sin\,\varphi(t)\;\overrightarrow{e_y}`$$`\;+\;cos\,\theta(t)\;\overrightarrow{e_z}`$<br>
<br>$`\overrightarrow{e_{\theta}}(t)=cos\,\theta(t)\;cos\,\varphi(t)\;\overrightarrow{e_x}`$$`\;+\;cos\,\theta(t)\;sin\,\varphi(t)\;\overrightarrow{e_y}`$$`\;-\;sin\,\theta(t)\;\overrightarrow{e_z}`$<br>
<br>$`\overrightarrow{e_{\varphi}}(t)=- sin\,\varphi(t)\;\overrightarrow{e_x}`$$`\;+\;cos\,\varphi(t)\;\overrightarrow{e_y}`$

dans la base cartésienne $`(\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ :

$`\overrightarrow{e_r}(t)=
\left| \begin{array}{l}
sin\,\theta(t)\cdot cos\,\varphi(t) \\
sin\,\theta(t)\cdot sin\,\varphi(t) \\
cos\,\theta(t) \\
\end{array} \right.\quad`$ , 
$`\quad\overrightarrow{e_{\theta}}(t)=
\left|\begin{array}{l}
cos\,\theta(t)\cdot cos\,\varphi(t) \\
cos\,\theta(t)\cdot sin\,\varphi(t) \\
-\,sin\,\theta(t) \\
\end{array}\right.\quad`$ , 
$`\quad\overrightarrow{e_{\varphi}}(t)=
\left|\begin{array}{l}
-\,sin\,\varphi(t) \\
cos\,\varphi(t) \\
0 \\
\end{array}\right.`$

Dans le référentiel $`\mathcal{R}(O,\overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z},t)`$ de l'observateur, c'est à dire dans le référentiel où le repère cartésien $`(O, \overrightarrow{e_x},\overrightarrow{e_y},\overrightarrow{e_z})`$ est fixe, donc tel que l'origine $`O`$ est fixe et les trois vecteurs de base vérifient 

$`\dfrac{d\overrightarrow{e_x}}{dt}=\dfrac{d\overrightarrow{e_y}}{dt}=\dfrac{d\overrightarrow{e_z}}{dt}=0`$ :

en se rappelant : $`(fg)'=f'g+fg'`$  

$`\dfrac{d\overrightarrow{e_r}}{dt}=
\left| \begin{array}{l}
\dfrac{d}{dt} [\,sin\,\theta(t)\cdot cos\,\varphi(t) \,]\\
\\
\dfrac{d}{dt} [\, sin\,\theta(t)\cdot sin\,\varphi(t)\, ] \\
\\
\dfrac{d}{dt} [\,  cos\,\theta(t)\, ] \\
\end{array} \right.\quad`$
$`\quad =
\left| \begin{array}{l}
\dfrac{d\,sin\,\theta}{dt}\cdot cos\,\varphi\;+\;sin\,\theta\cdot \dfrac{d\,cos \,\varphi}{dt} \\
\\
\dfrac{d\,sin\,\theta}{dt}\cdot sin\,\varphi\;+\;sin\,\theta\cdot \dfrac{d\,sin\,\varphi}{dt} \\
\\
\dfrac{d\,cos\,\theta}{dt} \\
\end{array} \right.\quad`$

et en se rappelant  : $`(f \circ g)'=(f' \circ g)\,g'`$ , 

$`\dfrac{d\overrightarrow{e_r}}{dt}=
\left| \begin{array}{l}
cos\,\theta\cdot \dfrac{d\theta}{dt}\cdot cos\,\varphi\;-\; sin\,\theta\cdot sin\,\varphi  \cdot \dfrac{d\varphi}{dt} \\
\\
cos\,\theta\cdot \dfrac{d\theta}{dt}\cdot sin\,\varphi\;+\; sin\,\theta \cdot cos\,\varphi \cdot \dfrac{d\varphi}{dt}\\
\\
-\,sin\,\theta\cdot \dfrac{d\theta}{dt} \\
\end{array} \right.\quad`$

$`\dfrac{d\overrightarrow{e_r}}{dt}=
\dfrac{d\theta}{dt}\cdot 
\left| \begin{array}{l}
cos\,\theta\cdot cos\,\varphi \\
cos\,\theta\cdot sin\,\varphi \\
-\,sin\,\theta \\
\end{array} \right.`$
$`\;+\;
sin\,\theta\cdot\dfrac{d\varphi}{dt}\cdot 
\left| \begin{array}{l}
-\,sin\,\varphi \\
cos\,\varphi \\
0 \\
\end{array} \right.\quad`$

$`\dfrac{d\overrightarrow{e_r}}{dt}=\dfrac{d\theta}{dt}\cdot\overrightarrow{e_{\theta}}+sin\,\theta\cdot\dfrac{d\varphi}{dt}\cdot \overrightarrow{e_{\varphi}}`$

**$`\mathbf{\dfrac{d\overrightarrow{e_r}}{dt}=\dfrac{d\theta}{dt}\cdot\overrightarrow{e_{\theta}}+sin\,\theta\cdot\dfrac{d\varphi}{dt}\cdot \overrightarrow{e_{\varphi}}}`$**

de même :

$`\dfrac{d\overrightarrow{e_\theta}}{dt}=
\left| \begin{array}{l}
\dfrac{d}{dt} [\,cos\,\theta(t)\cdot cos\,\varphi(t) \,]\\
\\
\dfrac{d}{dt} [\, cos\,\theta(t)\cdot sin\,\varphi(t)\, ] \\
\\
\dfrac{d}{dt} [-\,  sin\,\theta(t)\, ] \\
\end{array} \right.\quad`$
$`\quad =
\left| \begin{array}{l}
\dfrac{d\,cos\,\theta}{dt}\cdot cos\,\varphi\;+\;cos\,\theta\cdot \dfrac{d\,cos \,\varphi}{dt} \\
\\
\dfrac{d\,cos\,\theta}{dt}\cdot sin\,\varphi\;+\;cos\,\theta\cdot \dfrac{d\,sin\,\varphi}{dt} \\
\\
-\,\dfrac{d\,sin\,\theta}{dt} \\
\end{array} \right.\quad`$


$`\dfrac{d\overrightarrow{e_{\theta}}}{dt}=
\left| \begin{array}{l}
-\,sin\,\theta\cdot \dfrac{d\theta}{dt}\cdot cos\,\varphi\;-\; cos\,\theta\cdot sin\,\varphi  \cdot \dfrac{d\varphi}{dt} \\
\\
-\,sin\,\theta\cdot \dfrac{d\theta}{dt}\cdot sin\,\varphi\;+\; cos\,\theta \cdot cos\,\varphi \cdot \dfrac{d\varphi}{dt}\\
\\
-\,cos\,\theta\cdot \dfrac{d\theta}{dt} \\
\end{array} \right.\quad`$<br>
<br>
$`\dfrac{d\overrightarrow{e_{\theta}}}{dt}=
\dfrac{d\theta}{dt}\cdot 
\left| \begin{array}{l}
-\,sin\,\theta\cdot cos\,\varphi \\
-\,sin\,\theta\cdot sin\,\varphi \\
-\,cos\,\theta \\
\end{array} \right.`$
$`\;+\;
cos\,\theta\cdot\dfrac{d\varphi}{dt}\cdot 
\left| \begin{array}{l}
-\,sin\,\varphi \\
cos\,\varphi \\
0 \\
\end{array} \right.\quad`$<br>
<br>
$`\dfrac{d\overrightarrow{e_{\theta}}}{dt}=-\,\dfrac{d\theta}{dt}\cdot\overrightarrow{e_r}+cos\,\theta\cdot\dfrac{d\varphi}{dt}\cdot \overrightarrow{e_{\varphi}}`$<br>
<br>
**$`\mathbf{\dfrac{d\overrightarrow{e_{\theta}}}{dt}=-\,\dfrac{d\theta}{dt}\cdot\overrightarrow{e_r}+cos\,\theta\cdot\dfrac{d\varphi}{dt}\cdot \overrightarrow{e_{\varphi}}}`$**<br>


$`\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=
\left| \begin{array}{l}
\dfrac{d\,[-\,sin\,\varphi(t)]}{dt} \\
\dfrac{d\cos\,\varphi(t)}{dt} \\
0 \\
\end{array} \right.\quad`$
$`\quad=
\left| \begin{array}{l}
-\,cos\,\varphi(t)\cdot\dfrac{d\varphi}{dt} \\
-\,sin\,\varphi(t)\cdot\dfrac{d\varphi}{dt} \\
0 \\
\end{array} \right.\quad`$

$`\quad\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=-\,\dfrac{d\varphi}{dt}\cdot\overrightarrow{e_{\rho}}`$

**$`\mathbf{\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=-\,\dfrac{d\varphi}{dt}}\cdot\overrightarrow{e_{\rho}}`$**<br>

avec $`\overrightarrow{e_{\rho}}`$ vecteur de la base cylindrique :

$`(\overrightarrow{e_{\rho}}, \overrightarrow{e_{\phi}}, \overrightarrow{e_z})`$. 

---------------------------------

* *CS620* : **N3 ($`\rightarrow`$ N4)**

Méthode 2 pour le calcul de 
$`\dfrac{d e_r}{dt}`$ , $`\dfrac{d e_{\theta}}{dt}`$ , $`\dfrac{d e_{\varphi}}{dt}`$ 

$`\overrightarrow{e_r}=sin\,\theta\;cos\,\varphi\;\overrightarrow{e_x}`$
$`\;+\;sin\,\theta\;sin\,\varphi\;\overrightarrow{e_y}`$$`\;+\;cos\,\theta\;\overrightarrow{e_z}`$
$`=\overrightarrow{e_r}(\theta, \varphi)`$<br>
$`\overrightarrow{e_{\theta}}=cos\,\theta\;cos\,\varphi\;\overrightarrow{e_x}`$
$`\;+\;cos\,\theta\;sin\,\varphi\;\overrightarrow{e_y}`$
$`\;-\;sin\,\theta\;\overrightarrow{e_z}`$
$`=\overrightarrow{e_{\theta}}(\theta, \varphi)`$<br>
$`\overrightarrow{e_{\varphi}}=- sin\,\varphi\;\overrightarrow{e_x}`$
$`\;+\;cos\,\varphi\;\overrightarrow{e_y}`$
$`=\overrightarrow{e_{\varphi}}=\overrightarrow{e_{\varphi}}(\theta, \varphi)`$

$`d\overrightarrow{e_r}=\dfrac{\partial\overrightarrow{e_r}}{\partial\theta}\cdot d\theta\;+\;\dfrac{\partial\overrightarrow{e_r}}{\partial\varphi}\cdot d\varphi`$ <br>
$`d\overrightarrow{e_{\theta}}=\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\theta}\cdot d\theta\;+\;\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\varphi}\cdot d\varphi`$ <br>
$`d\overrightarrow{e_{\varphi}}=\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\theta}\cdot d\theta\;+\;\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\varphi}\cdot d\varphi`$

$`\theta=\theta(t)`$ , $`\varphi=\varphi(t)\quad\Longrightarrow\quad`$ pour un même $`dt`$ infinitésimal, $`\theta`$ et $`\varphi`$ varient de :

$`d\theta=\dfrac{d\theta}{dt}\cdot dt`$ et $`d\varphi=\dfrac{d\varphi}{dt}\cdot dt`$

$`\Longrightarrow\quad`$ pour un même $`dt`$ infinitésimal :

$`d\overrightarrow{e_r}=\dfrac{\partial\overrightarrow{e_r}}{\partial\theta}\cdot \dfrac{d\theta}{dt}\cdot dt\;+\;\dfrac{\partial\overrightarrow{e_r}}{\partial\varphi}\cdot \dfrac{d\varphi}{dt}\cdot dt`$ <br>
$`d\overrightarrow{e_{\theta}}=\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\theta}\cdot \dfrac{d\theta}{dt}\cdot dt\;+\;\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\varphi}\cdot \dfrac{d\varphi}{dt}\cdot dt`$ <br>
$`d\overrightarrow{e_{\varphi}}=\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\theta}\cdot \dfrac{d\theta}{dt}\cdot dt\;+\;\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\varphi}\cdot \dfrac{d\varphi}{dt}\cdot dt`$

$`\dfrac{d\overrightarrow{e_r}}{dt}=\dfrac{\partial\overrightarrow{e_r}}{\partial\theta}\cdot \dfrac{d\theta}{dt}\;+\;\dfrac{\partial\overrightarrow{e_r}}{\partial\varphi}\cdot \dfrac{d\varphi}{dt}`$ <br>
$`\dfrac{d\overrightarrow{e_{\theta}}}{dt}=\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\theta}\cdot \dfrac{d\theta}{dt}\;+\;\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\varphi}\cdot \dfrac{d\varphi}{dt}`$ <br>
$`\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\theta}\cdot \dfrac{d\theta}{dt}\;+\;\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\varphi}\cdot \dfrac{d\varphi}{dt}`$

$`\dfrac{\partial\overrightarrow{e_r}}{\partial\theta}=
\left|\begin{array}{l}
\dfrac{\partial}{\partial\theta}(sin\,\theta\cdot cos\,\varphi) \\
\dfrac{\partial}{\partial\theta}(sin\,\theta\cdot sin\,\varphi) \\
\dfrac{\partial}{\partial\theta}(cos\,\theta) \\
\end{array} \right.\quad`$ 
$`=\left|\begin{array}{l}
cos\,\theta\cdot cos\,\varphi \\
cos\,\theta\cdot sin\,\varphi \\
-\,sin\,\theta \\
\end{array} \right.\quad`$
$`=\overrightarrow{e_{\theta}}`$

$`\dfrac{\partial\overrightarrow{e_r}}{\partial\varphi}=
\left|\begin{array}{l}
\dfrac{\partial}{\partial\varphi}(sin\,\theta\cdot cos\,\varphi) \\
\dfrac{\partial}{\partial\varphi}(sin\,\theta\cdot sin\,\varphi) \\
\dfrac{\partial}{\partial\varphi}(cos\,\theta) \\
\end{array} \right.\quad`$ 
$`=\left|\begin{array}{l}
-\,sin\,\theta\cdot sin\,\varphi \\
sin\,\theta\cdot cos\,\varphi \\
0 \\
\end{array} \right.\quad`$
$`=sin\,\theta\cdot\overrightarrow{e_{\varphi}}`$

$`\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\theta}=
\left|\begin{array}{l}
\dfrac{\partial}{\partial\theta}(cos\,\theta\cdot cos\,\varphi) \\
\dfrac{\partial}{\partial\theta}(cos\,\theta\cdot sin\,\varphi) \\
\dfrac{\partial}{\partial\theta}(-\,sin\,\theta) \\
\end{array} \right.\quad`$ 
$`=\left|\begin{array}{l}
-\,sin\,\theta\cdot cos\,\varphi \\
-\,sin\,\theta\cdot sin\,\varphi \\
-\,cos\,\theta \\
\end{array} \right.\quad`$
$`=-\,\overrightarrow{e_r}`$

$`\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\varphi}=
\left|\begin{array}{l}
\dfrac{\partial}{\partial\varphi}(cos\,\theta\cdot cos\,\varphi) \\
\dfrac{\partial}{\partial\varphi}(cos\,\theta\cdot sin\,\varphi)] \\
\dfrac{\partial}{\partial\varphi}(-\,sin\,\theta) \\
\end{array} \right.\quad`$ 
$`=\left|\begin{array}{l}
-\,cos\,\theta\cdot sin\,\varphi \\
cos\,\theta\cdot cos\,\varphi \\
0 \\
\end{array} \right.\quad`$
$`=cos\,\theta\cdot\overrightarrow{e_{\varphi}}`$

$`\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\theta}=
\left|\begin{array}{l}
\dfrac{\partial}{\partial\theta}(-\,sin\,\varphi) \\
\dfrac{\partial}{\partial\theta}(cos\,\varphi) \\
0 \\
\end{array} \right.\quad`$
$`=
\left|\begin{array}{l}
0 \\
0 \\
0 \\
\end{array} \right.\quad`$
$`=\overrightarrow{0}`$

$`\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\varphi}=
\left|\begin{array}{l}
\dfrac{\partial}{\partial\varphi}(-\,sin\,\varphi) \\
\dfrac{\partial}{\partial\varphi}(cos\,\varphi) \\
0 \\
\end{array} \right.\quad`$
$`=
\left|\begin{array}{l}
-\,cos\,\varphi \\
-\,sin\,\varphi \\
0 \\
\end{array} \right.\quad`$
$`=-\,\overrightarrow{e_{\rho}}`$

avec $`\overrightarrow{e_{\rho}}`$ vecteur de la base cylindrique  :
$`(\overrightarrow{e_{\rho}}, \overrightarrow{e_{\phi}}, \overrightarrow{e_z})`$. 

$`\dfrac{d\overrightarrow{e_r}}{dt}=\dfrac{\partial\overrightarrow{e_r}}{\partial\theta}\cdot \dfrac{d\theta}{dt}\;+\;\dfrac{\partial\overrightarrow{e_r}}{\partial\varphi}\cdot \dfrac{d\varphi}{dt}\quad`$
$`=\dfrac{d\theta}{dt}\cdot\overrightarrow{e_{\theta}}\,+\,\dfrac{d\varphi}{dt}\cdot\sin\,\theta\,\overrightarrow{e_{\varphi}}`$

$`\dfrac{d\overrightarrow{e_{\theta}}}{dt}=\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\theta}\cdot \dfrac{d\theta}{dt}\;+\;\dfrac{\partial\overrightarrow{e_{\theta}}}{\partial\varphi}\cdot \dfrac{d\varphi}{dt}`$
$`=-\,\dfrac{d\theta}{dt}\cdot\overrightarrow{e_r}\,+\,\dfrac{d\varphi}{dt}\cdot\cos\,\theta\,\overrightarrow{e_{\varphi}}`$

$`\dfrac{d\overrightarrow{e_{\varphi}}}{dt}=\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\theta}\cdot \dfrac{d\theta}{dt}\;+\;\dfrac{\partial\overrightarrow{e_{\varphi}}}{\partial\varphi}\cdot \dfrac{d\varphi}{dt}`$
$`=\dfrac{d\theta}{dt}\cdot\overrightarrow{0}\,-\,\dfrac{d\varphi}{dt}\cdot\overrightarrow{e_{\rho}}`$

------------------

* *CS630*

$`\overrightarrow{v}(t)=\dfrac{d\overrightarrow{OM}}{dt}=\dfrac{d\overrightarrow{OM}(t)}{dt}=\dfrac{d}{dt}\left[\,r(t)\cdot\overrightarrow{e_r}(t)\,\right]`$$`=\dfrac{dr(t)}{dt}\cdot\overrightarrow{e_r(t)}\;+\;r(t)\cdot\dfrac{d\overrightarrow{e_r}(t)}{dt}`$
$`=\dfrac{dr}{dt}\cdot\overrightarrow{e_r}\;+\;r\cdot\dfrac{d\overrightarrow{e_r}}{dt}`$




