---
title: Exemple de structure possible sur le thème "Electromagnétisme"
published: true
routable: true
visible: false
lessons:
    - slug: structure-example-123-electromagnetism
      order: 3
    - slug: structure-example-234-electromagnetism
      order: 2
---

#### Conseils pour penser la structuration de ce niveau 3

C'est l'**équivalent de la première ou des deux premières années à l'université**.
Il y a un grand saut avec le niveau inférieur. Mais nous ne sommes pas limités
à un nombre d'heures ou de pages. Nous pouvons faire une progression tranquille et maîtrisée
à l'intérieur même de ce niveau 3.

Le lycée n'est pas homogène, il y a des filières, spécialités et options, et par ailleurs
les programmes varient aussi selon les pays et les époques. Certains outils mathématiques 
de niveau N3 peuvent être vus déjà au lycée. A l'inverse, il est possible que certains thèmes
de notre niveau N2, ne soient pas vus au lycée. **Pensez ces niveaux 2 et 3 librement et** 
**sans références en tête**.

Même à l'intérieur d'un niveau, il faut être très progressif, nous avons l'espace pour cela.
Le gap ne doit pas être trop grand d'un niveau à l'autre, pour ne pas démotiver 
les étudiants.


##### Les blocs

Dans ce niveau 3, les **blocs** sont importants parce qu'ils **permettent de différencier**
**les étudiants**. Par exemple nous pouvons faire un bloc électrostatique pour des
étudiants qui souhaitent s'arrêter à ce niveau 3 en électromagnétisme. Cela peut être 
un bloc avec seulement des calculs directs,  et la notion de dipôle électrique. Mais 
sans le théorèmes de Gauss et l'opérateur divergence, qui seront mis dans un autre 
bloc pour les étudiants qui doivent préparer la maîtrise des équations de 
l'électromagnétisme de Maxwell au niveau 4. 

Plus tard on pourra associer une metadonnée dans le fichier, pour sélectionner certains
blocs et proposer des circuits pédagogiques spécifiques selon le souhait de l'étudiant.

Utilisez donc les blocs pour **cibler les différentes pré-spécialités** au sein 
de ce niveau 3.

Note : Un bloc, qui peut contenir plusieurs chapitres et de nombreuses figures, peut être 
assez lourd, mais l'estimation est que un bloc affiché dans un mode de présentation,
s'affiche relativement rapidement en 4G (même hors connection wifi). Un bloc correspondra
fort probablement à 1 page web de M3P2.

--------------------------------------------------------------------------------

##### Code de couleurs de blocs dans cette étape de conception :

!!  BLOC tous les étudiants de niveau 3

!!!!  BLOC étudiants qui devront maîtriser l'électromagnétisme de Maxwell

--------------------------------------------------------------------------------

#### Un exemple de ce qu'il faut arriver à faire en terme de structure : niv 3

!!!! *BLOC ELMAG3-1* 
!!!!
!!!! *Titre possible* : Schéma conceptuel de l'électromagnétisme
!!!!
!!!! *Description succincte :*<br>
!!!! Une introduction sur les niveaux 3 et 4 de l'enseignement de l'électromagnétisme
!!!! destiné aux physiciens et autres qui devront maîtriser les équations de Maxwell.
!!!! Et un guide d'apprentissage sur les niveaux 3 et 4.
!!!! 
!!!! *Eleménts de programme, ou structuration en chapitre* :
!!!!  * donner une vision générale de l'électromagnétisme, le cycle :<br>
!!!! charges en mouvements <br>
!!!! $`=`$ (4 equations de Maxwell) $`\Longrightarrow`$ <br>
!!!! forces de Lorentz sur les charges <br>
!!!! $`=`$ (Dynamique $`\overrightarrow{dp}=\overrightarrow{F}.dt)\Longrightarrow`$ <br>
!!!!  modification du mouvement des charges.<br>
!!!!  * domaine de validité 
!!!!  * bref historique
!!!!  * guide d'apprentissage des niveaux 3 et 4  : pourquoi d'abord électrostat, magnétosta,
!!!!    pourquoi outil mathématique divergence, rotationnel, etc..., <br>
!!!!    différence entre électromag dans le vide, et dans la matière (moyennes des champs
!!!!    dans des volumes mésoscopiques), ...
!!!!
!!!! *Pour qui ?* physiciens et autres qui devront maîtriser les équations de Maxwell.

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-2*
!!
!! *Titre possible* :  *Introduction aux phénomènes électromagnétiques*
!!
!! *Description succincte :* Une vision générale des phénomènes électromagnétiques
!! de niveau N3, en privilégiant l'étude phénoménologique avec l'outil mathématique 
!! de niveau N3 privée des outils divergence et rotationnel (on peut les citer et donner
!! la signification intuitive, mais ne pas aller plus loin) nécessaire pour 
!! l'électromagnétisme de Maxwell. 
!! 
!! *Eleménts de programme, ou structuration en chapitre* :
!!  Les causes du champ électrique ( statique : charges ; et variable : B variable, 
!! donc en particulier courants variables, courants et aimants se déplaçant).  
!! Les causes du champ magnétiques ( statique : courants constants  ; et variable E variable,
!! donc en particulier courants variables, courants et aimants se déplaçant).
!!
!! *Pour qui ?* Pour qui ?  tous (physique, biologie, écologie, etc…) de niveau N3.

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-3* 
!!
!! *Titre possible* : Electrostatique dans le vide : calculs directs
!!
!! *Description succincte :* Electrostatique :  E et V, avec relation intégrale (circulation)
!! et locale (gradient) entre E et V. Calculs directs de E créé par des charges, et
!! de F induit par E sur des charges, introduction au dipôle électrique
!! (force et moment qui s'exerce sur lui, et champ E qu'il créé à grande distance).
!! 
!! *Eleménts de programme, ou structuration en chapitre* :
!!
!! *Pour qui ?* tous (physique, biologie, écologie, etc…) de niveau N3.

--------------------------------------------------------------------------------

!!!! *BLOC ELMAG3-4*
!!!!
!!!! *Titre possible* :  Electrostatique dans le vide : premiers pas vers les équations de Maxwell
!!!!
!!!! *Description succincte :* Théorème de Gauss (intégral et local) et tout l'outil 
!!!! conceptuel et mathématique associé  : symétries, vecteurs et pseudo vecteurs, divergence, 
!!!! rotationnel.
!!!! 
!!!! *Eleménts de programme, ou structuration en chapitre* :
!!!! établir au final div E = rho/eps0 (Gauss), mais aussi rot E = 0
!!!!
!!!! *Pour qui ?* physiciens et autres qui devront maîtriser les équations de Maxwell.

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-5*
!!
!! *Titre possible* : Les milieux conducteurs (soumis à E stationnaire)
!!
!! *Description succincte :*  milieux conducteur & semiconducteurs, charges liées 
!! ET présence de charges libres, vitesse thermique.
!! Matériaux (solide) cond. et semi-cond soumis à E stationnaire : vitesse de dérive, notion de trou
!! Cond. participant à circuit conducteur fermé : vecteur densité volumique de courant, 
!! puis surfacique, intensité, résistivité-conductivité (prop locale) et résistance,
!! Loi d'Ohm (locale et intégrale), équationd de conservation de la charge (tous voient
!! ou revoient ici la divergence)
!! Cond. isolé : champ électrique exterieur/interne/total, transitoire : champ E extérieur => charges libres
!! en surface, équilibre => Etotal=0 => équipotentielle & densité volumique de charge nulle
!! (justification phénoménologique, et par Th Gauss cité pour tous)
!! vers cage de Faraday et ondes EM (même si c'est E variable)
!!
!! *Idée* : c'est pour tous au niveau 3. Si c'est trop détaillé pour certains, il
!! reste une description de ce thème au niveau 2
!!
!!  *Eleménts de programme, ou structuration en chapitre* :
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-6*
!!
!! *Titre possible* : Les milieux diélectriques 1 (soumis à E stationnaire)
!!
!! *Description succincte :*  Description succincte : milieu diélectrique, moment dipolaire
!! électrique, phénomènes à l'origine des moments dipolaires, vecteur polarisation, 
!! polarisation électronique, atomique et d'orientation, relation E et P, milieux LHI : 
!! susceptibilité, polarisation uniforme, non uniforme, densité volumique de charges
!! de polarisation, densité surfacique de charges de polarisation, interface diélectrique/conducteur 
!! avec diélectrique isotrope/anisotrope, vecteur induction électrique, liens entre D, E, P,ε, ε_0, ε_r, χ
!! (tout cela pour E stationnaire, mais dans "au-delà, on indique que cela dépendra de la fréquence
!! du champ E =>N4)
!! 
!! *Idée* : c'est pour tous au niveau 3. Si c'est trop détaillé pour certains, il
!! reste une description de ce thème au niveau 2
!!
!!  *Eleménts de programme, ou structuration en chapitre* :
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

!!!! *BLOC ELMAG3-7*
!!!!
!!!! *Titre possible* : Les milieux diélectriques 2 (soumis à E stationnaire)
!!!!
!!!! *Description succincte :*  Théorème de Gauss (intégral et local) exprimé 
!!!! avec E, puis avec D 
!!!! 
!!!! *Eleménts de programme, ou structuration en chapitre* :
!!!! 
!!!!
!!!! *Pour qui ?* physiciens et autres qui devront maîtriser les équations de Maxwell.

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-8*
!!
!! *Titre possible* : Les condensateurs (soumis à E stationnaire)
!!
!! *Description succincte :*  Conducteurs en influence totale - condensateurs 
!! - capacité - avec et sans diéléctrique - série et en parallèle - énergie - et ?
!!
!!  *Eleménts de programme, ou structuration en chapitre* :
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-9*
!!
!! *Titre possible* : Magnétostatique  dans le vide : calculs directs
!!
!! *Description succincte :*  B (induction) et, H!(excitation) et calculs directs 
!! divers,<br>
!! Les causes du champ magnétique, calculs directs de B/H (fil infini et 
!! que peut-on dire de B/H créé par une nappe de courant, par boucle de courant circulaire 
!! en un point de son axe, et loin de la boucle (analogie avec E, car pas B=rotA), et
!! invariance par rapport à la forme exacte de la boucle dans son plan. Notion de
!! dipôle magnétique.<br>
!! Les effets de B : calculs de forces induites par B, entre 2 conducteurs rectilignes
!! infinis parcouru par I cst, force et moment exercés par B sur une boucle circulaire 
!! rigide de courant, vers l'action d'un B sur un dipôle magnétique.
!!
!! *Idée* : c'est pour tous au niveau 3. Si c'est trop détaillé pour certains, il
!! reste une description de ce thème au niveau 2
!!
!!  *Eleménts de programme, ou structuration en chapitre* :
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

!!!! *BLOC ELMAG3-10* 
!!!!
!!!! *Titre possible* : Magnétostatique dans le vide : premiers pas vers les équations 
!!!! de Maxwell
!!!!
!!!! *Description succincte :*  Théorème d'Ampères (intégral et local) et tout l'outil 
!!!! conceptuel et mathématique divergence, rotationnel, nécessaire aux équations de
!!!! Maxwell , B = rot (A), lien entre A et j, retour sur champ B/H créé par boucle
!!!! circulaire de courant loin ed la boucle.
!!!! 
!!!! *Eleménts de programme, ou structuration en chapitre* :
!!!! établir au final $`rot\overrightarrow{H}=\overrightarrow{j}`$ / 
!!!! $`rot\overrightarrow{B}=\mu_0\overrightarrow{j}`$ ET 
!!!!
!!!! *Pour qui ?* physiciens et autres qui devront maîtriser les équations de Maxwell.

--------------------------------------------------------------------------------